// DisplayBox.cpp: implementation of the CDisplayBox class.
//
//////////////////////////////////////////////////////////////////////

#include "stdafx.h"
#include "fbbW.h"
#include "DisplayBox.h"

#ifdef _DEBUG
#undef THIS_FILE
static char THIS_FILE[]=__FILE__;
#define new DEBUG_NEW
#endif

//////////////////////////////////////////////////////////////////////
// Construction/Destruction
//////////////////////////////////////////////////////////////////////

CDisplayBox::CDisplayBox()
{

}

CDisplayBox::~CDisplayBox()
{

}

//////////////////////////////////////////////////////////////////////
// Create the Display Box
// rect      : position
// pPrentWnd : parent window

BOOL CDisplayBox::Create(const RECT & rect, CWnd * pParentWnd)
{
	ASSERT(pParentWnd != NULL);

	m_pParentWnd = pParentWnd;
	m_nActiveRECtrl = 1;

	BOOL nRet = m_RECtrl1.Create(ES_MULTILINE | ES_AUTOHSCROLL | 
		ES_WANTRETURN | WS_BORDER | WS_HSCROLL | WS_TABSTOP | WS_CHILD |
		WS_VISIBLE, rect, pParentWnd, 0) )
		return FALSE;
}

void CDisplayBox::Print(LPCTSTR lpszText, COLORREF crTextColor)
{
	CRichEditCtrl * pActive;
	CRichEditCtrl * pPassive;

	if( m_nActiveRECtrl == 1 )
	{
		pActive  = &m_RECtrl1;
		pPassive = &m_RECtrl2;
		m_nActiveRECtrl = 2;
	}
	else
	{
		pActive  = &m_RECtrl2;
		pPassive = &m_RECtrl1;
		m_nActiveRECtrl = 1;
	}

//	pPassive->ModifyStyle(NULL, WS_VISIBLE);
	pActive->ModifyStyle(WS_VISIBLE, NULL);

	pPassive->UpdateWindow();
	pActive->UpdateWindow();
	m_pParentWnd->UpdateWindow();
}
