// Display.cpp : implementation file
//

#include "stdafx.h"
#include "fbbw.h"
#include "Display.h"


#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

#define	LINE_LEN		82
#define W_BACK	RGB(255,255,255)

typedef struct
{
	COLORREF	color;
	COLORREF	color_bis;
	int	pos_bis;
	char 	text[LINE_LEN];
} Line;

/////////////////////////////////////////////////////////////////////////////
// CDisplay

CDisplay::CDisplay()
{
	m_bControl = false;

	SelBegin = SelEnd = 0;
	NbLines = 10;

	MaxLines = 500;
	TotLines = 1;
	CurrCol = CurrLine = LastLine = 0;

	int		i;
	Line *LineBuf;

	hMem = GlobalAlloc(GMEM_MOVEABLE, MaxLines * sizeof(Line));
	LineBuf = (Line *)GlobalLock(hMem);
	for (i = 0 ; i < MaxLines ; i++)
	{
		memset(LineBuf[i].text, 0x20, 80);
		LineBuf[i].text[80] = '\0';
		LineBuf[i].color = 1;
		LineBuf[i].color_bis = 0;
		LineBuf[i].pos_bis = 0;
	}
	GlobalUnlock(hMem);

	m_pFont = NULL;
	m_bAnsi = false;
	m_bViewSel = false;
	SelTrace = 0;
}

CDisplay::~CDisplay()
{
	if (hMem)
		GlobalFree(hMem);
	hMem = NULL;
}

BEGIN_MESSAGE_MAP(CDisplay, CWnd)
	//{{AFX_MSG_MAP(CDisplay)
	ON_WM_VSCROLL()
	ON_WM_SIZE()
	ON_WM_KEYDOWN()
	ON_WM_KEYUP()
	ON_WM_RBUTTONDOWN()
	ON_WM_LBUTTONDBLCLK()
	ON_WM_LBUTTONDOWN()
	ON_WM_LBUTTONUP()
	ON_WM_MOUSEMOVE()
	ON_WM_MOUSEWHEEL()
	ON_WM_PAINT()
	ON_WM_CONTEXTMENU()
	ON_COMMAND(ID_SELECT_ALL, OnSelectAll)
	ON_COMMAND(ID_PRINT_SELECTION, OnPrintSelection)
	ON_COMMAND(ID_COPY_SELECTION, OnCopySelection)
	ON_UPDATE_COMMAND_UI(ID_COPY_SELECTION, OnUpdateCopySelection)
	ON_UPDATE_COMMAND_UI(ID_PRINT_SELECTION, OnUpdatePrintSelection)
	ON_WM_SETFOCUS()
	ON_WM_KILLFOCUS()
	ON_WM_ERASEBKGND()
	ON_WM_CHAR()
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CDisplay message handlers

BOOL CDisplay::Create(LPCTSTR lpszClassName, LPCTSTR lpszWindowName, DWORD dwStyle, const RECT& rect, CWnd* pParentWnd, UINT nID, CCreateContext* pContext) 
{	
	SCROLLINFO ScrollInfo;
	ScrollInfo.cbSize = sizeof(SCROLLINFO);
	ScrollInfo.fMask  = SIF_PAGE|SIF_POS|SIF_RANGE;
	ScrollInfo.nMax   = TotLines;
	ScrollInfo.nMin   = 0;
	ScrollInfo.nPage  = NbLines;
	ScrollInfo.nPos   = TotLines-NbLines;
	SetScrollInfo(SB_VERT, &ScrollInfo, true);

	BOOL Ret = CWnd::Create(lpszClassName, lpszWindowName, dwStyle, rect, pParentWnd, nID, pContext);
	
	SetParams();

	return Ret;
}

void CDisplay::OnSize(UINT nType, int cx, int cy) 
{
	CWnd::OnSize(nType, cx, cy);

	Height = cy;
	Width  = cx;

	SetParams();
	Invalidate();
}

void CDisplay::OnVScroll(UINT nSBCode, UINT nPos, CScrollBar* pScrollBar) 
{
	switch (nSBCode) {
	case SB_LINEUP:
		Scroll(-1);
		break;
	case SB_LINEDOWN:
		Scroll(1);
		break;
	case SB_PAGEUP:
		Scroll(-NbLines);
		break;
	case SB_PAGEDOWN:
		Scroll(NbLines);
		break;
	case SB_THUMBPOSITION:
	case SB_THUMBTRACK:
		LastLine = nPos + CurrLine - (TotLines - NbLines);
		if (LastLine < 0)
			LastLine += MaxLines;
		if (LastLine >= MaxLines)
			LastLine -= MaxLines;
		Scroll(0);
		Invalidate(FALSE);
		break;
	}
	
	CWnd::OnVScroll(nSBCode, nPos, pScrollBar);
}

void CDisplay::OnKeyUp(UINT nChar, UINT nRepCnt, UINT nFlags) 
{
	if (nChar == VK_CONTROL)
		m_bControl = false;
}

void CDisplay::OnKeyDown(UINT nChar, UINT nRepCnt, UINT nFlags) 
{
	BOOL bGot = true;
	
	switch(nChar)
	{
	case 'A' :
		if (m_bControl)
			OnSelectAll();
		else
			bGot = false;
		break;
	case VK_INSERT :		
	case 'C' :
		if (m_bControl)
			OnCopySelection();
		else
			bGot = false;
		break;
	case 'P' :
		if (m_bControl)
			OnPrintSelection();
		else
			bGot = false;
		break;
	case VK_UP :		
		Scroll(-1);
		break;
	case VK_DOWN :
		Scroll(1);
		break;
	case VK_PRIOR :
		Scroll(-NbLines);
		break;
	case VK_NEXT :
		Scroll(NbLines);
		break;
	case VK_HOME :
		Scroll(-TotLines);
		break;
	case VK_END :
		Scroll(TotLines);
		break;
	case VK_CONTROL :
		m_bControl = true;
		break;
	default:
		bGot = false;
		break;
	}

	if (!bGot)
		CWnd::OnKeyDown(nChar, nRepCnt, nFlags);
}

void CDisplay::OnRButtonDown(UINT nFlags, CPoint point) 
{
	CWnd::OnRButtonDown(nFlags, point);
}

#define ISCARAC(c)	((isalnum(c & 0x7f)) || (c == '_'))

void CDisplay::OnLButtonDblClk(UINT nFlags, CPoint point) 
{
	int	XPos, YPos;
	UINT	NewSel;

	// Transforme les coordonnees en position du caractere dans le buffer
	XPos = (point.x - 1) / CharW ;
	YPos = (point.y - 1) / CharH ;
	if (XPos < 0)
	{
		XPos = 0;
	}
	if (XPos > 79)
	{
		XPos = 79;
	}
	if (YPos < 0)
		YPos = 0;
	if (YPos >= NbLines)
	{
		if (XPos == 0)
			YPos = NbLines;
		else
			YPos = NbLines-1;
	}

	YPos += (LastLine - NbLines + 1);
	if (YPos < 0)
		YPos += MaxLines;
	if (YPos >= MaxLines)
		YPos -= MaxLines;

	NewSel = XPos + YPos * 80;


	// Cherche le mot a selectionner
	HGLOBAL	hM = hMem;

	if (hM == NULL)
		return;

	char	*cptr;
	Line	*lptr;
	Line	*LineBuf = (Line *)GlobalLock(hM);

	// Selection sur une seule ligne !
	lptr = LineBuf    + YPos;
	cptr = lptr->text;

	if (nFlags & MK_CONTROL)
	{
		if (isgraph(cptr[XPos]))
		{

			int	i = XPos;

			// Cherche le debut du mot
			while (i)
			{
				if (!isgraph(cptr[i-1]))
					break;
				--i;
			}
			SelBegin = i + YPos * 80;

			// Cherche la fin du mot
			i = XPos;
			while (i < 80)
			{
				++i;
				if (!isgraph(cptr[i]))
					break;
			}
			SelEnd = i + YPos * 80;
		}

		else
			SelBegin = SelEnd = NewSel;
	}
	else
	{
		if (ISCARAC(cptr[XPos]))
		{
			int	i = XPos;

			// Cherche le debut du mot
			while (i)
			{
				if (!ISCARAC(cptr[i-1]))
					break;
				--i;
				}
			SelBegin = i + YPos * 80;

				// Cherche la fin du mot
			i = XPos;
				while (i < 80)
			{
				++i;
					if (!ISCARAC(cptr[i]))
					break;
			}
			SelEnd = i + YPos * 80;
		}

		else
			SelBegin = SelEnd = NewSel;
	}


	GlobalUnlock(hM);

	if (SelBegin != SelEnd)
	{
		CClientDC	dc(this);
		DrawSelection(dc);
		SelTrace = 1;
	}

	
	CWnd::OnLButtonDblClk(nFlags, point);
}

void CDisplay::OnLButtonDown(UINT nFlags, CPoint point) 
{
	int	XPos, YPos;
	int	NewSel;

	// Transforme les coordonnees en position du caractere dans le buffer
	XPos = (point.x - 1) / CharW ;
	YPos = (point.y - 1) / CharH ;
	if (XPos < 0)
	{
		XPos = 0;
	}
	if (XPos > 79)
	{
		XPos = 79;
	}
	if (YPos < 0)
		YPos = 0;
	if (YPos >= NbLines)
	{
		if (XPos == 0)
			YPos = NbLines;
		else
			YPos = NbLines-1;
	}

	YPos += (LastLine - NbLines + 1);
	if (YPos < 0)
		YPos += MaxLines;
	if (YPos >= MaxLines)
		YPos -= MaxLines;

	NewSel = XPos + YPos * 80;

	if (nFlags & MK_SHIFT)
	{
		//	End of selection
		if (NewSel != SelEnd)
		{
			CClientDC	dc(this);
			UINT		SelTemp = SelBegin;

			SelBegin = SelEnd;
			SelEnd = NewSel;

			DrawSelection(dc);

			SelBegin = SelTemp;
			SelTrace = 1;
		}
	}

	else
	{
		// Clear the previous selection
		CClientDC	dc(this);
		DrawSelection(dc);

		// Beginning of selection
		SelEnd = SelBegin = NewSel;
		SelTrace = 1;
		// Invalidate(FALSE);
	}
	
	CWnd::OnLButtonDown(nFlags, point);
}

void CDisplay::OnLButtonUp(UINT nFlags, CPoint point) 
{
	SelTrace = 0;
	
	CWnd::OnLButtonUp(nFlags, point);
}

void CDisplay::OnMouseMove(UINT nFlags, CPoint point) 
{
	int	XPos, YPos;
	int	NewSel;

	if ((nFlags & MK_LBUTTON) == 0)
	{
		//Le bouton a ete relache !
		OnLButtonUp(nFlags, point);
		return;
	}

	// En mode selection ?
	if (SelTrace == 0)
		return;

	// Transforme les coordonnees en position du caractere dans le buffer
	XPos = (point.x - 1) / CharW ;
	YPos = (point.y - 1) / CharH ;
	if (XPos < 0)
	{
		XPos = 0;
	}
	if (XPos > 79)
	{
		XPos = 79;
	}
	if (YPos < 0)
	{
		YPos = 0;
	}
	if (YPos >= NbLines)
	{
		if (XPos == 0)
			YPos = NbLines;
		else
			YPos = NbLines-1;
	}

	YPos += (LastLine - NbLines + 1);
	if (YPos < 0)
		YPos += MaxLines;
	if (YPos >= MaxLines)
		YPos -= MaxLines;

	NewSel = XPos + YPos * 80;

	if (NewSel != SelEnd)
	{
		CClientDC	dc(this);
		int			SelTemp = SelBegin;

		SelBegin = SelEnd;
		SelEnd = NewSel;

		DrawSelection(dc);

		SelBegin = SelTemp;
	}
	
	CWnd::OnMouseMove(nFlags, point);
}

void CDisplay::SetParams()
{
	CWindowDC dc(this);
	dc.SelectObject(m_pFont);

	// Recalcule les parametres de la fenetre
	TEXTMETRIC tm;
	dc.GetTextMetrics (&tm);
	CharW = tm.tmAveCharWidth;
	CharH = tm.tmHeight + tm.tmExternalLeading;

	NbLines = Height / CharH;
	/*
	if (TotLines < NbLines)
		TotLines = NbLines;
	*/

	Scroll(0);
}

void CDisplay::Scroll(int nbscr)
{
	int		pos;
	int		maxscr;
	int		UseLines = TotLines - NbLines;
	int		diff = CurrLine - LastLine;

	if (nbscr > 0)
	{
		maxscr = diff;
		if (maxscr < 0)
			maxscr += MaxLines;
		if (maxscr >= MaxLines)
			maxscr -= MaxLines;
		if (nbscr > maxscr)
			nbscr = maxscr;
	}

	if (nbscr < 0)
	{
		maxscr = UseLines - diff;
		if (maxscr < 0)
			maxscr += MaxLines;
		if (maxscr >= MaxLines)
			maxscr -= MaxLines;
		if (-nbscr > maxscr)
			nbscr = -maxscr;
	}

	if (nbscr)
	{
		if (SelTrace)
		{
			CClientDC	dc(this);
			int	SelTemp = SelBegin;

			SelBegin = SelEnd;
			SelEnd += nbscr * 80;

			DrawSelection(dc);

			SelBegin = SelTemp;
		}

		CRect	zone;
		zone.top = 0;
		zone.left = 2;
		zone.right = 2 + Width;
		zone.bottom = NbLines*CharH;

		ScrollWindow(0, -(nbscr * CharH), NULL, &zone);
		LastLine += nbscr;

		if (LastLine < 0)
			LastLine += MaxLines;
		if (LastLine >= MaxLines)
			LastLine -= MaxLines;

	}

	// Scrollbar position

	pos =  TotLines - (CurrLine - LastLine) - NbLines;
	if (pos < 0)
		pos += MaxLines;
	if (pos >= MaxLines)
		pos -= MaxLines;

	SCROLLINFO ScrollInfo;
	ScrollInfo.cbSize = sizeof(SCROLLINFO);
	ScrollInfo.fMask  = SIF_PAGE|SIF_POS|SIF_RANGE;
	ScrollInfo.nMax   = TotLines-1;
	ScrollInfo.nMin   = 0;
	ScrollInfo.nPage  = NbLines;
	ScrollInfo.nPos   = pos;

	SetScrollInfo(SB_VERT, &ScrollInfo, true);

	UpdateWindow();
}

UINT CDisplay::GetLineLen(char *text, UINT lg)
{
	UINT	i;
	UINT	len;
	UINT	spaces;

	len = spaces = 0;

	for (i = 0 ; i < lg ; i++)
	{
		if (*text == ' ')
			++spaces;
		else
		{
			len += spaces;
			spaces = 0;
			++len;
		}
		++text;
	}

	return(len);
}

void CDisplay::GetSelectedText()
{
	int	i;
	int	len;
	char	*cptr;
	Line	*lptr;
	HGLOBAL	hM = hMem;
	HGLOBAL	hClip;

	if (hM == NULL)
		return;

	Line	*LineBuf = (Line *)GlobalLock(hM);

	int	inside;
	int	ligne;

	int	YPosBegin;
	int	XPosBegin;
	int	YPosEnd;
	int	XPosEnd;

	if (SelEnd == SelBegin)
		return;

	// Calcule le sens de la selection. Lastline ne doit pas etre dedans !

	if (SelEnd < SelBegin)
	{
		int tmp = SelBegin;
		SelBegin = SelEnd;
		SelEnd = tmp;
	}

	XPosBegin = SelBegin % 80 ;
	XPosEnd   = SelEnd % 80 ;

	YPosBegin = SelBegin / 80 ;
	YPosEnd   = SelEnd / 80 ;

	if (YPosEnd == YPosBegin)
	{
		// Une seule ligne !
		lptr = LineBuf    + YPosBegin;
		cptr = lptr->text + XPosBegin;
		len = GetLineLen(cptr, XPosEnd - XPosBegin);
		if (len)
		{
			hClip = GlobalAlloc(GMEM_MOVEABLE|GMEM_DDESHARE, len+1);
			char *clipPtr = (char *)GlobalLock(hClip);
			memcpy(clipPtr, cptr, len);
			clipPtr += len;
			*clipPtr = '\0';
			GlobalUnlock(hClip);
		}
	}

	else
	{
		// Selection sur plusieurs lignes

		// Teste le premier cas (cas logique) :
		if (YPosEnd > YPosBegin)
		{
			if ((CurrLine < YPosEnd) && (CurrLine >= YPosBegin))
			{
				// C'est pas bon, on inverse
				int	YPosTemp = YPosEnd;
				YPosEnd = YPosBegin;
				YPosBegin = YPosTemp;
				int	XPosTemp = XPosEnd;
				XPosEnd = XPosBegin;
				XPosBegin = XPosTemp;
			}
		}
		else
		{
			if ((CurrLine >= YPosBegin) || (CurrLine < YPosEnd))
			{
				// C'est pas bon, on inverse
				int	YPosTemp = YPosEnd;
				YPosEnd = YPosBegin;
				YPosBegin = YPosTemp;
				int	XPosTemp = XPosEnd;
				XPosEnd = XPosBegin;
				XPosBegin = XPosTemp;
			}
		}

		len =0;
		inside = 0;
		ligne = CurrLine + 1;
		for (i = 0 ; i < MaxLines ; i++)
		{
			if (ligne == YPosBegin)
			{
				// Premiere ligne
				inside = 1;
				lptr = LineBuf    + ligne;
				cptr = lptr->text + XPosBegin;
				len += GetLineLen(cptr, 80 - XPosBegin);
				len += 2;	//CRLF
			}
			else if (ligne == YPosEnd)
			{
				// Derniere ligne
				inside = 0;
				lptr = LineBuf    + ligne;
				cptr = lptr->text;
				len += GetLineLen(cptr, XPosEnd);
				len += 2;	//CRLF
			}
			else if (inside)
			{
				lptr = LineBuf    + ligne;
				cptr = lptr->text;
				len += GetLineLen(cptr, 80);
				len += 2;	//CRLF
			}
			if (++ligne >= MaxLines)
				ligne = 0;
		}

		hClip = GlobalAlloc(GMEM_MOVEABLE|GMEM_DDESHARE, len+1);
		char *clipPtr = (char *)GlobalLock(hClip);

		inside = 0;
		ligne = CurrLine + 1;
		for (i = 0 ; i < MaxLines ; i++)
		{
			if (ligne == YPosBegin)
			{
				// Premiere ligne
				inside = 1;
				lptr = LineBuf    + ligne;
				cptr = lptr->text + XPosBegin;
				len = GetLineLen(cptr, 80 - XPosBegin);
				if (len)
				{
					memcpy(clipPtr, cptr, len);
					clipPtr += len;
				}
				*clipPtr++ = '\r';
				*clipPtr++ = '\n';
			}
			else if (ligne == YPosEnd)
			{
				// Derniere ligne
				inside = 0;
				lptr = LineBuf    + ligne;
				cptr = lptr->text;
				len = GetLineLen(cptr, XPosEnd);
				if (len)
				{
					memcpy(clipPtr, cptr, len);
					clipPtr += len;
				}
				*clipPtr++ = '\r';
				*clipPtr++ = '\n';
			}
			else if (inside)
			{
				lptr = LineBuf    + ligne;
				cptr = lptr->text;
				len = GetLineLen(cptr, 80);
				if (len)
				{
					memcpy(clipPtr, cptr, len);
					clipPtr += len;
				}
				*clipPtr++ = '\r';
				*clipPtr++ = '\n';
			}
			if (++ligne >= MaxLines)
				ligne = 0;
		}
		len = 1;
		*clipPtr = '\0';
		GlobalUnlock(hClip);
	}

	GlobalUnlock(hM);

	if (len)
	{
	    // Send the Clipboard the data.
		OpenClipboard();
		EmptyClipboard();
		SetClipboardData(CF_TEXT, hClip);
		CloseClipboard();
	}
	else
		GlobalFree(hClip);
}

void CDisplay::DrawSelection(CDC &hdc)
{
	if (!m_bViewSel || SelBegin == SelEnd)
		return;

	// Il y a une selection

	int	i;
	int	pos;
	int	YPos;
	int	YPosBegin;
	int	XPosBegin;
	int	YPosEnd;
	int	XPosEnd;

	// Calcule le sens de la selection. Lastline ne doit pas etre dedans !
	XPosBegin = SelBegin % 80 ;
	XPosEnd   = SelEnd % 80 ;

	YPosBegin = SelBegin / 80 ;
	YPosEnd   = SelEnd / 80 ;

	if (YPosEnd == YPosBegin)
	{
		// Une seule ligne !
		pos = LastLine - NbLines + 1;
		YPosBegin -= pos;
		if (YPosBegin >= MaxLines)
		{
			YPosBegin -= MaxLines;
		}

		XPosBegin *= CharW;
		YPosBegin *= CharH;

		XPosEnd *= CharW;

		CRect Rect(XPosBegin+2, YPosBegin, XPosEnd+2, YPosBegin + CharH);
		hdc.InvertRect(Rect);
		return;
	}

	// Selection sur plusieurs lignes

	// Teste le premier cas (cas logique) :
	if (YPosEnd > YPosBegin)
	{
		if (CurrLine < YPosEnd && CurrLine >= YPosBegin)
		{
			// C'est pas bon, on inverse
			int	YPosTemp = YPosEnd;
			YPosEnd = YPosBegin;
			YPosBegin = YPosTemp;
			int	XPosTemp = XPosEnd;
			XPosEnd = XPosBegin;
			XPosBegin = XPosTemp;
		}
	}
	else
	{
		if (CurrLine >= YPosBegin || CurrLine < YPosEnd)
		{
			// C'est pas bon, on inverse
			int	YPosTemp = YPosEnd;
			YPosEnd = YPosBegin;
			YPosBegin = YPosTemp;
			int	XPosTemp = XPosEnd;
			XPosEnd = XPosBegin;
			XPosBegin = XPosTemp;
		}
	}

	XPosBegin *= CharW;
	XPosEnd   *= CharW;

	int	inside = 0;
	int	ligne;

	// Debut de la zone ecran
	pos = LastLine - NbLines + 1;
	if (pos < 0)
		pos += MaxLines;

	ligne = CurrLine + 1;

	// Out of the window
	for (i = 0 ; i < MaxLines ; i++)
	{
		if (ligne == pos)
			break;
		if (ligne == YPosBegin)
		{
			inside = 1;
		}
		if (ligne == YPosEnd)
		{
			inside = 0;
		}
		if (++ligne >= MaxLines)
			ligne = 0;
	}

	// In the window
	for (i = 0 ; i < NbLines ; i++)
	{
		YPos = i * CharH;
		if (pos == YPosBegin)
		{
			CRect Rect(XPosBegin+2, YPos, 80*CharW+2, YPos + CharH);
			hdc.InvertRect(Rect);
			inside = 1;
		}
		else if (pos == YPosEnd)
		{
			CRect Rect(2, YPos, XPosEnd+2, YPos + CharH);
			hdc.InvertRect(Rect);
			inside = 0;
		}
		else if (inside)
		{
			CRect Rect(2, YPos, 80*CharW+2, YPos + CharH);
			hdc.InvertRect(Rect);
		}
		if (++pos >= MaxLines)
			pos = 0;
	}
}

void CDisplay::OnPaint() 
{
	CPaintDC hdc(this); // device context for painting
	CRect Zone = hdc.m_ps.rcPaint;
	
	// Do not call CWnd::OnPaint() for painting messages
	
	int	i;
	int	top;
	int	bottom;
	int	pos;
	Line	*ptr;
	CRect	zone;	
	
	hdc.SetBkMode(OPAQUE);
	hdc.SetBkColor(W_BACK);
	
	hdc.SelectObject(m_pFont);
	
	//	TCanal	*CanalI = CanalInfo(canal);
	HGLOBAL	hM = hMem;
	
	if (hM == NULL)
		return;
	
	Line *LineBuf = (Line *)GlobalLock(hM);
	
	pos = LastLine - NbLines + 1;
	
	if (pos < 0)
		pos += MaxLines;
	
	top    = Zone.top    / CharH;
	bottom = Zone.bottom / CharH;
	
	for (i = 0 ; i < NbLines ; i++)
	{
		if ((i >= top) && (i <= bottom))
		{
			zone.top = CharH*i;
			zone.left = 2;
			zone.right = Width-1;
			zone.bottom = (CharH*i) + CharH;// - 1;
			
			ptr = LineBuf + pos;
			int offs = ptr->pos_bis;
			
			if (offs)
			{
				hdc.SetTextColor(ptr->color);
				hdc.ExtTextOut(zone.left, zone.top, ETO_OPAQUE, zone, ptr->text, offs, NULL);
				
				CSize Tsize = hdc.GetTextExtent(ptr->text, offs);
				zone.left += Tsize.cx;
				hdc.SetTextColor(ptr->color_bis);
				hdc.ExtTextOut(zone.left, zone.top, ETO_OPAQUE, zone, ptr->text + offs, 80 - offs, NULL);
			}
			else
			{
				hdc.SetTextColor(ptr->color);
				hdc.ExtTextOut(2, zone.top, ETO_OPAQUE, zone, ptr->text, 80, NULL);
			}
		}
		if (++pos >= MaxLines)
			pos = 0;
	}
	
	// Nettoie le bas de la fenetre
	zone.top = CharH*i;
	zone.left = 2;
	zone.right = Width-1;
	zone.bottom = (CharH*i) + CharH;// - 1;

	hdc.ExtTextOut(zone.left, zone.top, ETO_OPAQUE, zone, NULL, 0, NULL);
	
	// Selection
	DrawSelection(hdc);
	
	GlobalUnlock(hM);
}

void CDisplay::OnContextMenu(CWnd* pWnd, CPoint point) 
{
	// TODO: Add your message handler code here
	
	CMenu menu;
	VERIFY(menu.LoadMenu(IDR_DISPLAY_POPUP));
	CMenu* pPopup = menu.GetSubMenu(0);
	ASSERT(pPopup != NULL);
 
	pPopup->TrackPopupMenu(TPM_LEFTALIGN | TPM_RIGHTBUTTON, point.x, point.y, this);
}

void CDisplay::OnSelectAll() 
{
	// TODO: Add your command handler code here
	SelBegin = (CurrLine+1) * 80;
	SelEnd   = (CurrLine)   * 80 + 79;
	Invalidate();	
}

void CDisplay::OnCopySelection() 
{
	// TODO: Add your command handler code here
	GetSelectedText();	
}

void CDisplay::OnUpdateCopySelection(CCmdUI* pCmdUI) 
{
	// TODO: Add your command update UI handler code here
	pCmdUI->Enable(SelBegin != SelEnd);	
}


void CDisplay::OnUpdatePrintSelection(CCmdUI* pCmdUI) 
{
	// TODO: Add your command update UI handler code here
	pCmdUI->Enable(SelBegin != SelEnd);
}

//void CDisplay::SetBkgndColor(CRect *DispRect)
void CDisplay::SetBkgndColor(void)
{
	UpdateWindow();
}


BOOL CDisplay::OnEraseBkgnd(CDC* pDC) 
{
	// TODO: Add your message handler code here and/or call default

	RECT DispRect;
	GetClientRect(&DispRect);
	pDC->FillSolidRect(&DispRect, W_BACK);
	
	return CWnd::OnEraseBkgnd(pDC);
}


void CDisplay::AddString(LPCTSTR lpszText, int len, COLORREF crColor)
{
	char		*text;
	int			NextLine;
	Line		*LineBuf;
	Line		*ptr;
	int			pos;
	int			cr;
	int			c;
	int			id;
	TCHAR		buff[82];
	
	HGLOBAL hM = hMem;
	HGLOBAL hT;
	
	if (hM == NULL)
		return;
	
	hT = GlobalAlloc(GMEM_MOVEABLE, len);
	text = (char *)GlobalLock(hT);

	if (m_bAnsi)
		memcpy(text, lpszText, len);
	else
		OemToCharBuff(lpszText, text, len);

	LineBuf = (Line *)GlobalLock(hM);
	
	for ( ; len > 0; )
	{
		cr = 0;
		id = 0;
		pos = CurrCol;
		
		while (len > 0)
		{
			--len;
			c = *text++;
			
			if (c == '\n')
			{
				cr = 1;
				break;
			}
			buff[id] = c;
			++pos;
			++id;
			if (pos == 80)
			{
				cr = 1;
				break;
			}
		}
		buff[id] = '\0';
		
		ptr = LineBuf + CurrLine;
		if (CurrCol)
		{
			// Fin de ligne
			if (ptr->color != crColor)
			{
				ptr->color_bis = crColor;
				ptr->pos_bis = CurrCol;
			}
		}
		else
		{
			ptr->color = crColor;
			ptr->pos_bis = 0;
			memset(ptr->text, 0x20, 80);
			ptr->text[80] = '\0';
		}
		
		memcpy(ptr->text + CurrCol, buff, id);
		
		// On ecrit dans la fenetre si elle existe
		CClientDC	hdc(this);
		CRect			rect;
		
		if ((id) && (CurrLine == LastLine))
		{
			// Le texte est ecrit dans la derniere ligne de la fenetre
			hdc.SelectObject(m_pFont);
			int x = 2;
			if (CurrCol)
			{
				CSize Size = hdc.GetTextExtent(ptr->text, CurrCol);
				x = 2 + Size.cx;
			}
			
			int	y = CharH * (NbLines - 1);
			
			CRect	zone;
			zone.top = y;
			zone.left = x;
			zone.right = Width;
			zone.bottom = y + CharH;

			hdc.SetBkColor(W_BACK);
			hdc.SelectObject(m_pFont);
			hdc.SetTextColor(crColor);
			hdc.TextOut(x, y, ptr->text + CurrCol, 80 - CurrCol);
			if (SelTrace)
			{
				int	SelTemp = SelBegin;

				SelBegin = CurrLine * 80 + CurrCol;
				DrawSelection(hdc);
				SelBegin = SelTemp;
			}

		}
		
		if (cr == 0)
		{
			CurrCol += id;
			Scroll(0);
		}
		else
		{
			CurrCol = 0;

			if (TotLines < MaxLines)
				++TotLines;
			
			NextLine = LastLine - NbLines;
			if (NextLine < 0)
				NextLine += MaxLines;
		
			if (CurrLine == LastLine)
			{
				// Fenetre en position normale (fin de buffer)
				if (++(CurrLine) >= MaxLines)
					CurrLine = 0;
				ptr = LineBuf + CurrLine;
				memset(ptr->text, 0x20, 80);
				ptr->text[80] = '\0';

				int SelBeginLine = SelBegin / 80;
				int SelEndLine   = SelEnd / 80;
				
				if (CurrLine == SelBeginLine)
				{
					SelBeginLine = CurrLine + 1;
					if (SelBeginLine >= MaxLines)
						SelBeginLine = 0;
					SelBegin = SelBeginLine * 80;
				}
				
				if (CurrLine == SelEndLine)
				{
					SelEndLine = CurrLine + 1;
					if (SelEndLine >= MaxLines)
						SelEndLine = 0;
					SelEnd = SelEndLine * 80;
				}
				
				Scroll(1);
			}
			else if (CurrLine == NextLine)
			{
				// Fenetre en debut de buffer
				if (++(CurrLine) >= MaxLines)
					CurrLine = 0;
				ptr = LineBuf + CurrLine;
				memset(ptr->text, 0x20, 80);
				ptr->text[80] = '\0';

				int SelBeginLine = SelBegin / 80;
				int SelEndLine   = SelEnd / 80;
				
				if (CurrLine == SelBeginLine)
				{
					SelBeginLine = CurrLine + 1;
					if (SelBeginLine >= MaxLines)
						SelBeginLine = 0;
					SelBegin = SelBeginLine * 80;
				}
				
				if (CurrLine == SelEndLine)
				{
					SelEndLine = CurrLine + 1;
					if (SelEndLine >= MaxLines)
						SelEndLine = 0;
					SelEnd = SelEndLine * 80;
				}
				
				Scroll(1);
			}
			else
			{
				// Fenetre dans le buffer
				if (++(CurrLine) >= MaxLines)
					CurrLine = 0;
				ptr = LineBuf + CurrLine;
				memset(ptr->text, 0x20, 80);
				ptr->text[80] = '\0';

				int SelBeginLine = SelBegin / 80;
				int SelEndLine   = SelEnd / 80;
				
				if (CurrLine == SelBeginLine)
				{
					SelBeginLine = CurrLine + 1;
					if (SelBeginLine >= MaxLines)
						SelBeginLine = 0;
					SelBegin = SelBeginLine * 80;
				}
				
				if (CurrLine == SelEndLine)
				{
					SelEndLine = CurrLine + 1;
					if (SelEndLine >= MaxLines)
						SelEndLine = 0;
					SelEnd = SelEndLine * 80;
				}
				
				Scroll(0);
			}
		}
	}
	GlobalUnlock(hM);

	GlobalUnlock(hT);
	GlobalFree(hT);
}


void CDisplay::SetFont(CFont *pFont, BOOL bRedraw)
{
	m_pFont = pFont;
	SetParams();
	if (bRedraw)
		Invalidate();
}

void CDisplay::SetAnsi(BOOL bAnsi)
{
	if (bAnsi == m_bAnsi)
		return;

	m_bAnsi = bAnsi;

//	Line	*ptr;
	HGLOBAL	hM = hMem;
	if (hM == NULL)
		return;
	
	Line *LineBuf = (Line *)GlobalLock(hM);

	char *cptr;
	
	for (int i = 0 ; i < MaxLines ; i++)
	{
		cptr = LineBuf[i].text;
		if (bAnsi)
			OemToCharBuff(cptr, cptr, LINE_LEN);
		else
			CharToOemBuff(cptr, cptr, LINE_LEN);
	}
	GlobalUnlock(hM);
	Invalidate(false);
}


void CDisplay::OnSetFocus(CWnd* pOldWnd) 
{
	CWnd::OnSetFocus(pOldWnd);
	// Validate the selection
	m_bViewSel = true;
	Invalidate(false);
}


void CDisplay::OnKillFocus(CWnd* pNewWnd) 
{
	CWnd::OnKillFocus(pNewWnd);
	// Unvalidate the selection
	m_bViewSel = false;
	Invalidate(false);
}


void CDisplay::ClearSelection()
{
	SelBegin = SelEnd = 0;
	Invalidate(false);
}

BOOL CDisplay::PreTranslateMessage(MSG* pMsg) 
{
	// for modeless processing (or modal)
	ASSERT(m_hWnd != NULL);


    if( IsDialogMessage(pMsg))
        return TRUE;
    else
        return CWnd::PreTranslateMessage(pMsg);
}

void CDisplay::OnChar(UINT nChar, UINT nRepCnt, UINT nFlags) 
{
	// TODO: Add your message handler code here and/or call default
	
	CWnd::OnChar(nChar, nRepCnt, nFlags);
}

#define CTRL(x) ((x) - '@')
BOOL CDisplay::IsDialogMessage( LPMSG pMsg )
{
	if (pMsg->message == WM_CHAR && (
			pMsg->wParam == CTRL('A') || // Select All
			pMsg->wParam == CTRL('C') || // Copy selection
			pMsg->wParam == CTRL('P')    // Print selection
		))
	{
		return TRUE;
	}

	return FALSE;
}

void CDisplay::PrintBuffer(CDC *pDC)
{
	int	i;
	char	*cptr;
	Line	*lptr;
	HGLOBAL	hM = hMem;
	BOOL bPage = false;

	if (hM == NULL)
		return;

	Line	*LineBuf = (Line *)GlobalLock(hM);

	int	inside;
	int	ligne;

	int	YPosBegin;
	int	XPosBegin;
	int	YPosEnd;
	int	XPosEnd;

	// Calcule le sens de la selection. Lastline ne doit pas etre dedans !

	if (SelEnd < SelBegin)
	{
		int tmp = SelBegin;
		SelBegin = SelEnd;
		SelEnd = tmp;
	}

	XPosBegin = SelBegin % 80 ;
	XPosEnd   = SelEnd % 80 ;

	YPosBegin = SelBegin / 80 ;
	YPosEnd   = SelEnd / 80 ;

	if (YPosEnd == YPosBegin)
	{
		int len;

		// Une seule ligne !
		lptr = LineBuf    + YPosBegin;
		cptr = lptr->text + XPosBegin;
		len = GetLineLen(cptr, XPosEnd - XPosBegin);
		if (len)
		{
			PrintHeader(pDC);
			pDC->TextOut(10, 10, cptr, len); // print the line
			PrintFooter(pDC);
		}
	}

	else
	{
		// Selection sur plusieurs lignes

		// Teste le premier cas (cas logique) :
		if (YPosEnd > YPosBegin)
		{
			if ((CurrLine < YPosEnd) && (CurrLine >= YPosBegin))
			{
				// C'est pas bon, on inverse
				int	YPosTemp = YPosEnd;
				YPosEnd = YPosBegin;
				YPosBegin = YPosTemp;
				int	XPosTemp = XPosEnd;
				XPosEnd = XPosBegin;
				XPosBegin = XPosTemp;
			}
		}
		else
		{
			if ((CurrLine >= YPosBegin) || (CurrLine < YPosEnd))
			{
				// C'est pas bon, on inverse
				int	YPosTemp = YPosEnd;
				YPosEnd = YPosBegin;
				YPosBegin = YPosTemp;
				int	XPosTemp = XPosEnd;
				XPosEnd = XPosBegin;
				XPosBegin = XPosTemp;
			}
		}

		inside = 0;
		ligne = CurrLine + 1;

		for (i = 0 ; i < MaxLines ; i++)
		{
			int len;

			if (!bPage)
			{
				PrintHeader(pDC);
				bPage = true;
			}

			len = 0;

			if (ligne == YPosBegin)
			{
				// Premiere ligne
				inside = 1;
				lptr = LineBuf    + ligne;
				cptr = lptr->text + XPosBegin;
				len = GetLineLen(cptr, 80 - XPosBegin);
				pDC->SetTextColor(lptr->color);
				pDC->TextOut(m_nPrintX, m_nPrintY, cptr, len);
				m_nPrintY += m_nPrintCharH;
			}
			else if (ligne == YPosEnd)
			{
				// Derniere ligne
				inside = 0;
				lptr = LineBuf    + ligne;
				cptr = lptr->text;
				len = GetLineLen(cptr, XPosEnd);
				pDC->SetTextColor(lptr->color);
				pDC->TextOut(m_nPrintX, m_nPrintY, cptr, len);
				m_nPrintY += m_nPrintCharH;
			}
			else if (inside)
			{
				lptr = LineBuf    + ligne;
				cptr = lptr->text;
				len = GetLineLen(cptr, 80);
				pDC->SetTextColor(lptr->color);
				pDC->TextOut(m_nPrintX, m_nPrintY, cptr, len);
				m_nPrintY += m_nPrintCharH;
			}

			if (++ligne >= MaxLines)
				ligne = 0;

			if (m_nPrintY >= m_nPrintMax)
			{
				PrintFooter(pDC);
				bPage = false;
			}
		}
		if (bPage)
			PrintFooter(pDC);
	}

	GlobalUnlock(hM);
}

void CDisplay::SetPrintAlign(CDC *pDC, HDC hdcPrn)
{
	short cxPage, cyPage;
	
	cxPage = ::GetDeviceCaps (hdcPrn, HORZRES) ;
	cyPage = ::GetDeviceCaps (hdcPrn, VERTRES) ;

	pDC->SetMapMode (MM_ISOTROPIC) ;
	pDC->SetWindowExt (1000, 1000) ;
	pDC->SetViewportExt (cxPage / 2, -cyPage / 2) ;
	pDC->SetViewportOrg (cxPage / 2,  cyPage / 2) ;
	pDC->SetTextAlign (TA_BASELINE | TA_LEFT) ;

	TEXTMETRIC tm;
	pDC->GetTextMetrics (&tm);

	m_nPrintCharH = tm.tmHeight;
	if (tm.tmExternalLeading)
		m_nPrintCharH += tm.tmExternalLeading;
	else
		m_nPrintCharH += m_nPrintCharH / 5;
	m_nPrintMax = cyPage - m_nPrintCharH * 6;
	m_nPageW = cxPage;
}

void CDisplay::PrintHeader(CDC *pDC)
{
	pDC->StartPage();          // begin a new page

	pDC->SetTextColor(RGB(0,0,0));

	pDC->SetTextAlign(TA_TOP | TA_CENTER) ;

	CString txt;
	char szTitre[80];

	GetParent()->GetWindowText(szTitre, sizeof(szTitre));
	txt.Format("fbbW selection - %s", szTitre);

	m_nPrintY = m_nPrintCharH;

	pDC->TextOut(m_nPageW/2, m_nPrintCharH, txt);

	pDC->SetTextAlign (TA_BASELINE | TA_LEFT) ;
	m_nPrintY += m_nPrintCharH * 2;

	pDC->MoveTo(0, m_nPrintY);
	pDC->LineTo(m_nPageW, m_nPrintY);

	m_nPrintX = 0;
	m_nPrintY = m_nPrintCharH * 5;

}

void CDisplay::PrintFooter(CDC *pDC)
{
	CString txt;

	pDC->SetTextColor(RGB(0,0,0));
	
	m_nPrintY = m_nPrintMax + m_nPrintCharH * 3;

	pDC->MoveTo(0, m_nPrintY - m_nPrintCharH);
	pDC->LineTo(m_nPageW, m_nPrintY - m_nPrintCharH);

	m_nPrintY += m_nPrintCharH * 2;

	CTime Time = CTime::GetCurrentTime();

	txt = Time.Format("%A, %B %d, %Y - %H:%M");
	pDC->SetTextAlign (TA_BASELINE | TA_LEFT) ;
	pDC->TextOut(0, m_nPrintY, txt);

	txt.Format("Page %d", ++m_nPage);
	pDC->SetTextAlign (TA_BASELINE | TA_RIGHT) ;
	pDC->TextOut(m_nPageW, m_nPrintY, txt);

	pDC->EndPage();            // end a page

	pDC->SetTextAlign (TA_BASELINE | TA_LEFT) ;
}

void CDisplay::OnPrintSelection()
{
	if (SelEnd == SelBegin)
		return;

	m_nPage = 0;

	HDC    hdcPrn ;
	
	// Instantiate a CPrintDialog.
	CPrintDialog *printDlg =
		new CPrintDialog(TRUE, PD_ALLPAGES | PD_RETURNDC, NULL);
	
	// Initialize some of the fields in PRINTDLG structure.
	printDlg->m_pd.nMinPage = printDlg->m_pd.nMaxPage = 1;
	printDlg->m_pd.nFromPage = printDlg->m_pd.nToPage = 1;
	
	// Display Windows print dialog box.
	printDlg->DoModal();
	
	// Obtain a handle to the device context.
	hdcPrn = printDlg->GetPrinterDC();
	if (hdcPrn != NULL)
	{
		CDC *pDC = new CDC;
		DOCINFO DocInfo;
		static  char *DocName = "fbbW selection";

		DocInfo.cbSize = sizeof(DOCINFO);
		DocInfo.fwType = 0;
		DocInfo.lpszDatatype = NULL;
		DocInfo.lpszDocName = DocName;
		DocInfo.lpszOutput = NULL;

		pDC->Attach (hdcPrn);      // attach a printer DC
		pDC->StartDoc(&DocInfo);  // begin a new print job
		
		SetPrintAlign(pDC, hdcPrn);// Set the printing alignment

		PrintBuffer(pDC);

		pDC->EndDoc();             // end a print job
		pDC->Detach();             // detach the printer DC
		delete pDC;
	}
	
	delete printDlg;
}

BOOL CDisplay::OnMouseWheel( UINT nFlags, short zDelta, CPoint pt )
{
	if (TotLines > NbLines)
	{
		Scroll((-2 * zDelta) / WHEEL_DELTA);
	}

	// return CWnd::OnMouseWheel( nFlags, zDelta, pt );
	return 0;
}

