#include <alloc.h>
#include <stdio.h>
#include <string.h>
#include "streams.h"
#include "buffers.h"
#include "define.h"
#include "tools.h"
#include "users.h"
#include "message.h"
#include "filter.h"
#include "locator.h"
#include "commands.h"
#include "protocol.h"
extern "C" {
#include "memory.h"
}

extern	char	STREAMS_callsign[MAX_STREAMS][10];
extern	char	STREAMS_level[MAX_STREAMS];

tUser    * pUser;
tUserCfg * pUserCfg;

mem_hand	USERS_hand1;
mem_hand	USERS_hand2;
long		USERS_filePos[MAX_STREAMS+1];	//Le dernier (66) est utilis pour updater les infos provenant du rseau

char		USERS_defaultLanguage = 0;

//-------------------------------------------------------------------------
//------ Envoyer une trame  tous les utilisateurs ------------------------
//-------------------------------------------------------------------------
void USERS_sendAll(char * String, int ToWho, int nMessageType, int nWAZ)
{
	extern unsigned long 	COMMANDS_statut[MAX_STREAMS];
	extern tUser *pUser;

	int   index;
	char *pszBeep;
	char *pszNoBeep;
	char *pszString;

	/* Gestion du BEEP/NOBEEP */
	pszNoBeep = (char *) malloc (strlen (String) + 1);
	if( pszNoBeep == NULL )
		return;
	strcpy(pszNoBeep, String);
	TOOLS_removeBell(pszNoBeep);

	pszBeep = String;

	for(index = 1; index < MAX_STREAMS; index++)
	{
		/* Y a t-il quelqu'un de connecte, et est-ce un
		   utilisateur ? */
		if( ! (STREAMS_callsign[index][0] && (STREAMS_level[index] & LEVEL_user)) )
			continue;

		/* Test sur le filtrage WW */
		if( ! FILTER_isOK(index, FILTER_USER, nWAZ) )
			continue;

		/* Divers filtres (dx, annonces, ...) */
		USERS_getRecord(index);

		switch( nMessageType )
		{
		case PROTOCOL_ANNOUNCEMENT :
			/* Mode NODX_ANNOUNCEMENTS */
			if( pUser->iFlags & USERS_NOANNOUNCEMENTS )
				continue;
			break;
		default :
			/* Ne fait rien pour l'instant */
			break;
		}

		/* Beep ou NoBeep ? */
		if( USERS_getFlags(index) & USERS_NOBEEP )
			pszString = pszNoBeep;
		else
			pszString = pszBeep;

		switch( ToWho )
		{
		case USERS_ALL : 	/* Adresser le message a tous les utilisateurs */
			BUFFERS_addBuff(index, pszString, OUT);
			break;

		case USERS_SYSOP :      /* Adresser le message aux sysops dclares */
			if( STREAMS_level[index] & LEVEL_sysopD )
				BUFFERS_addBuff(index, pszString, OUT);
			break;

		case USERS_EXCEPTCONSOLE : /* Adresser le message a tous les utilisateurs, sauf la console */
			if( index != 65 )
				BUFFERS_addBuff(index, pszString, OUT);
			break;

		case USERS_LOCALCONF :
			if( COMMANDS_statut[index] & COMMANDS_statutLocalConf )
				BUFFERS_addBuff(index, pszString, OUT);
			break;

		case USERS_CLUSTERCONF :
			if( COMMANDS_statut[index] & COMMANDS_statutClusterConf )
				BUFFERS_addBuff(index, pszString, OUT);
			break;

		}/* End SWITCH */
	}/*End FOR*/

	/* Liberer le bloc alloue */
	free(pszNoBeep);
}

//-------------------------------------------------------------------------
//------ Ouvrir une config utilisateur ------------------------------------
//-------------------------------------------------------------------------
//La fonction retourne le nombre de connexions de l'utilisateur
unsigned long USERS_openRecord(int StreamNum, char * UserCall)
{
  FILE *fPtr;
  int	Done = FALSE;
  int	iNb;
  char	sCallSign[10];

  if( StreamNum >= RCMD_VIRTSTREAM )
	StreamNum = 65;

  //Accder aux zones mmoire
  pUser    = (tUser *)    xget(StreamNum, USERS_hand1);
  pUserCfg = (tUserCfg *) xget(StreamNum, USERS_hand2);

  //Prparer l'indicatif (pas de SSID)
  strcpy(sCallSign, UserCall);
  TOOLS_removeSsid(sCallSign);

  //Ouvrir le fichier
  fPtr = fopen(USERS_FILE, "rb");

  //Le fichier n'a pu tre ouvert
  if( ! fPtr )
  {
    USERS_filePos[StreamNum] = USERS_newRecord(sCallSign);
    return 0L;
  }

  while( ! Done )
  {
    //Lire un enregistrement
    USERS_filePos[StreamNum] = ftell(fPtr);	//Position du dbut de l'enregistrement
    iNb = fread(pUser, sizeof(*pUser), 1, fPtr);

    //La lecture a t-elle t possible ?
    if( iNb != 1 )
      break;		//non, fin de fichier atteinte

    //Est-ce le bon indicatif ?
    if( ! strcmp(pUser->sCallSign, sCallSign) )
      Done = TRUE;      //Oui
  }

  //Fermer le fichier
  fclose(fPtr);

  //Si l'utilisateur n'a pas t trouv, initialiser la structure et crer l'enregistrement
  if( ! Done )
    USERS_filePos[StreamNum] = USERS_newRecord(sCallSign);

  //Sauvegarder la structure en mmoire
  xput((unsigned char*) pUser, StreamNum, USERS_hand1);

  //Initialiser et sauvegarder la structure LocalConfig
  memset(pUserCfg, 0, sizeof(*pUserCfg));
  xput((unsigned char*) pUserCfg, StreamNum, USERS_hand2);

  return pUser->lLogins;
}

//---------------------------------------------------------------------------
//------ Initialisation -----------------------------------------------------
//---------------------------------------------------------------------------
int USERS_init(void)
{
  int	index;

  //------ Rserver la mmoire ------
  //Stratgie d'allocation
  setXMstrat("XECV");

  //Rserver
  USERS_hand1 = xalloc(sizeof(*pUser),    MAX_STREAMS+1); //Voir remarque plus haut
  USERS_hand2 = xalloc(sizeof(*pUserCfg), MAX_STREAMS+1); //Voir remarque plus haut

  //Le buffer a t-il pu tre allou
  if( ! USERS_hand1 || ! USERS_hand2 )
    return FALSE;

  //Allouer de la mmoire sur les pointeurs de structure pUser et pUserCfg

  //Initialiser les structures pour chaque stream
  for(index = 0; index <= MAX_STREAMS; index++)
  {
    pUser    = (tUser *)    xget(index, USERS_hand1);
    memset(pUser, 0, sizeof(*pUser));
    xput((byte *) pUser, index, USERS_hand1);

    pUserCfg = (tUserCfg *) xget(index, USERS_hand2);
    memset(pUserCfg, 0, sizeof(*pUserCfg));
    xput((byte *) pUserCfg, index, USERS_hand2);
  }/*End FOR*/

  //Dfinir le mode d'accs
  SetReadMode(USERS_hand1, X_FAST);
  SetReadMode(USERS_hand2, X_FAST);

  return TRUE;
}

//---------------------------------------------------------------------------
//------ Crer un enregistrement nouveau ------------------------------------
//---------------------------------------------------------------------------
long USERS_newRecord(char * CallSign)
{
  FILE * fPtr;
  long lFilePos;

  //Ouvrir le fichier
  fPtr = fopen(USERS_FILE, "a+b");

  //Le fichier n'a pas pu tre ouvert
  if( ! fPtr )
  {
    perror("fopen in USERS_newRecord");
    return 0L;
  }

  //Initialiser les variables
  memset(pUser, 0, sizeof(*pUser));	//Pour rendre le fichier plus clean
  strcpy(pUser->sCallSign, CallSign);
  strcpy(pUser->sName,     CallSign);

//  pUser->sHomeNode[0] = SNULL;
//  pUser->sQth[0] = SNULL;
//  pUser->sLocator[0] = SNULL;

  pUser->byPage = 20;
  pUser->byLanguage = USERS_defaultLanguage;

//  pUser->iBandsOff = 0;
//  pUser->iFlags = 0;

//  pUser->lLogins = 0L;
  pUser->lLastMsg = 1L;
  pUser->lLastConnect = TOOLS_whatDateTime();

  //Position de l'enregistrement
  fseek(fPtr, 0L, SEEK_END);	//sans a, ftell indique 0L (position en dbut de fichier)
  lFilePos = ftell(fPtr);

  //Enregistrer
  fwrite(pUser, sizeof(*pUser), 1, fPtr);

  //Fermer le fichier
  fclose( fPtr );

  return lFilePos;
}

//--------------------------------------------------------------------------
//------ Updater une config utilisateur ------------------------------------
//--------------------------------------------------------------------------
//Ceci implique que pUser pointe dj sur l'enregistrement en question
void USERS_updateRecord(int StreamNum)
{
	FILE * fPtr;

	if( StreamNum >= RCMD_VIRTSTREAM )
		StreamNum = 65;


	//Sauvegarder en mmoire les blocs
	xput((unsigned char*) pUser, StreamNum, USERS_hand1);
	xput((unsigned char*) pUserCfg, StreamNum, USERS_hand2);

	//Ouvrir le fichier
	fPtr = fopen(USERS_FILE, "r+b");

	//Le fichier n'a pas pu etre ouvert
	if( ! fPtr )
	{
		perror("fopen in USERS_updateRecord");
		return;
	}

	//Sauvegarder cet enregistrement
	fseek(fPtr, USERS_filePos[StreamNum], SEEK_SET);
	fwrite(pUser, sizeof(*pUser), 1, fPtr);

	//Fermer le fichier
	fclose( fPtr );
}

//--------------------------------------------------------------------------
//------ Sauver une config utilisateur ------------------------------------
//--------------------------------------------------------------------------
//A la dconnection de l'utilisateur (le buffer est considr comme ferm)
void USERS_saveRecord(int StreamNum)
{
	FILE * fPtr;

	if( StreamNum >= RCMD_VIRTSTREAM )
		StreamNum = 65;

	//Sauvegarder en mmoire les blocs
	xput((unsigned char*) pUser, StreamNum, USERS_hand1);
	xput((unsigned char*) pUserCfg, StreamNum, USERS_hand2);

	//Ouvrir le fichier
	fPtr = fopen(USERS_FILE, "r+b");

	//Le fichier n'a pas pu tre ouvert
	if( ! fPtr )
	{
		perror("fopen in USERS_saveRecord");
		return;
	}

/* Virre le 04-oct-1999 / PB set/nobeep 
  //Accder au buffer mmoris
  pUser = (tUser *) xget(1, USERS_hand1); */

	//Updater le nombre de connexions, ainsi que la date et l'heure
	pUser->lLogins++;
	pUser->lLastConnect = TOOLS_whatDateTime();

	//Sauvegarder cet enregistrement
	fseek(fPtr, USERS_filePos[StreamNum], SEEK_SET);
	fwrite(pUser, sizeof(*pUser), 1, fPtr);

	//Fermer le fichier
	fclose( fPtr );
}

//--------------------------------------------------------------------------
//------ Accder au buffer mmoris ----------------------------------------
//--------------------------------------------------------------------------
//A la dconnection de l'utilisateur (le buffer est considr comme ferm)
void USERS_getRecord(int StreamNum)
{
	if( StreamNum >= RCMD_VIRTSTREAM )
		StreamNum = 65;

	//Accder au buffer mmoris
	pUser    = (tUser *)    xget(StreamNum, USERS_hand1);
	pUserCfg = (tUserCfg *) xget(StreamNum, USERS_hand2);
}

//--------------------------------------------------------------------------
//------ Changer une config utilisateur ------------------------------------
//--------------------------------------------------------------------------
void USERS_changeConfig(char * CallSign, char * String, int Data)
{
  char	sCallSign[20];
  char  sString[100];

  //Ceci car il faut etre sur que les variables d'origines ne soient pas
  //pas modifiees
  strcpy(sCallSign, CallSign);
  strcpy(sString,   String);

  USERS_openRecord(66, sCallSign);

  switch( Data )
  {
    case USERS_NAME :
      strcpy(pUser->sName, TOOLS_maxLength(sString, 22));
      break;

    case USERS_QTH :
      strcpy(pUser->sQth, TOOLS_maxLength(sString, 80));
      break;

    case USERS_COORDINATES :
      {
	char szLocator[8];

	if( LOCATOR_pavStr2locator(sString, szLocator) )
		strcpy(pUser->sLocator, szLocator);
      }
      break;

    case USERS_HOME :
      strcpy(pUser->sHomeNode, TOOLS_maxLength(sString, 9));
      break;

    case USERS_LOCATOR :
      strcpy(pUser->sLocator, TOOLS_maxLength(sString, 6));
      break;
  }/*End SWITCH*/

  USERS_updateRecord(66);
}

//---------------------------------------------------------------------------
//------ Updater la config locale d'un utilisateur --------------------------
//---------------------------------------------------------------------------
void USERS_updateLocalConfig(int StreamNum)
{
	if( StreamNum >= RCMD_VIRTSTREAM )
		StreamNum = 65;

	xput((unsigned char*) pUserCfg, StreamNum, USERS_hand2);
}

//-------------------------------------------------------------------------
//------ Retourner le Home Node d'un utilisateur --------------------------
//-------------------------------------------------------------------------
//La fonction retourne FALSE si l'utilisateur n'a pas ete trouve
int USERS_getHomeQth(char * UserCall, char * HomeQth)
{
  FILE *fPtr;
  int	Done = FALSE;
  int	iNb;

  //Accder aux zones mmoire
  pUser    = (tUser *)    xget(66, USERS_hand1);

  //Ouvrir le fichier
  fPtr = fopen(USERS_FILE, "rb");

  //Le fichier n'a pu tre ouvert
  if( ! fPtr )
    return FALSE;

  while( ! Done )
  {
    //Lire un enregistrement
    USERS_filePos[66] = ftell(fPtr);	//Position du dbut de l'enregistrement
    iNb = fread(pUser, sizeof(*pUser), 1, fPtr);

    //La lecture a t-elle t possible ?
    if( iNb != 1 )
      break;		//non, fin de fichier atteinte

    //Est-ce le bon indicatif ?
    if( ! strcmp(pUser->sCallSign, UserCall) )
      Done = TRUE;      //Oui
  }

  //Fermer le fichier
  fclose(fPtr);

  if( ! Done )
    return FALSE;	//Inconnu

  strcpy(HomeQth, pUser->sHomeNode);
  return TRUE;
}

//--------------------------------------------------------------------------
//------ Vrifier l'existance de l'utilisateur dans la base user -----------
//--------------------------------------------------------------------------
//La fonction retourne TRUE si OK
int USERS_isExist(char * UserCall)
{
  FILE *fPtr;
  int	Done = FALSE;
  int	iNb;

  //Accder aux zones mmoire
  pUser    = (tUser *)    xget(66, USERS_hand1);

  //Ouvrir le fichier
  fPtr = fopen(USERS_FILE, "rb");

  //Le fichier n'a pu tre ouvert
  if( ! fPtr )
    return FALSE;

  while( ! Done )
  {
    //Lire un enregistrement
    USERS_filePos[66] = ftell(fPtr);	//Position du dbut de l'enregistrement
    iNb = fread(pUser, sizeof(*pUser), 1, fPtr);

    //La lecture a t-elle t possible ?
    if( iNb != 1 )
      break;		//non, fin de fichier atteinte

    //Est-ce le bon indicatif ?
    if( ! strcmp(pUser->sCallSign, UserCall) )
      Done = TRUE;      //Oui
  }

  //Fermer le fichier
  fclose(fPtr);

  return Done;	//Inconnu
}

//-------------------------------------------------------------------------
//------ Retourner le Home Node d'un utilisateur --------------------------
//-------------------------------------------------------------------------
//La fonction retourne FALSE si l'utilisateur n'a pas ete trouve
int USERS_get(char * UserCall, char * String, int Field)
{
  FILE *fPtr;
  int	Done = FALSE;
  int	iNb;

  //Accder aux zones mmoire
  pUser    = (tUser *)    xget(66, USERS_hand1);

  //Ouvrir le fichier
  fPtr = fopen(USERS_FILE, "rb");

  //Le fichier n'a pu tre ouvert
  if( ! fPtr )
    return FALSE;

  while( ! Done )
  {
    //Lire un enregistrement
    USERS_filePos[66] = ftell(fPtr);	//Position du dbut de l'enregistrement
    iNb = fread(pUser, sizeof(*pUser), 1, fPtr);

    //La lecture a t-elle t possible ?
    if( iNb != 1 )
      break;		//non, fin de fichier atteinte

    //Est-ce le bon indicatif ?
    if( ! strcmp(pUser->sCallSign, UserCall) )
      Done = TRUE;      //Oui
  }

  //Fermer le fichier
  fclose(fPtr);

  if( ! Done )
    return FALSE;	//Inconnu

  switch( Field )
  {
    case USERS_NAME :
      strcpy(String, pUser->sName);
      break;

    case USERS_QTH :
      strcpy(String, pUser->sQth);
      break;

    case USERS_HOME :
      strcpy(String, pUser->sHomeNode);
      break;

    case USERS_LOCATOR :
      strcpy(String, pUser->sLocator);
      break;
  }/*End SWITCH*/

  return TRUE;
}

//-------------------------------------------------------------------------
//------ Retourner les Flags d'un utilisateur  ----------------------------
//-------------------------------------------------------------------------
unsigned int USERS_getFlags(int StreamNum)
{
	if( StreamNum >= RCMD_VIRTSTREAM )
		StreamNum = 65;

	USERS_getRecord(StreamNum);
	return pUser->iFlags;
}

//-------------------------------------------------------------------------
//------ Enregistrer les Flags d'un utilisateur ---------------------------
//-------------------------------------------------------------------------
void USERS_setFlags(int StreamNum, unsigned int iFlags)
{
	if( StreamNum >= RCMD_VIRTSTREAM )
		StreamNum = 65;

	USERS_getRecord(StreamNum);
	pUser->iFlags = iFlags;
	USERS_updateRecord(StreamNum);
}

/*------------------------------------------------------------------------
  ------ Envoyer une trame de login (un nouvel utilisateur vient de se ---
  ------ connecter) ------------------------------------------------------
  ------------------------------------------------------------------------*/
#pragma argsused
void USERS_sendUserLoginAnnouncement(int StreamNum, char * pszUserCall, int nMsg)
{
	int 	       index;
	extern char *MSG_pParams[10];

	MSG_pParams[9] = pszUserCall;

	if( StreamNum >= RCMD_VIRTSTREAM )
		StreamNum = 65;

	for(index = 1; index < MAX_STREAMS; index++)
	{
		/* Ne pas adresser ce message a l'utiliseur qui vient de se
		   connecter */
		if( index == StreamNum )
			continue;

		/* Ne pas adresser ce message si l'utilisateur ne le souhaite pas */
		if( USERS_getFlags(index) & USERS_NOLOGIN )
			continue;

		/* Y a t-il quelqu'un de connect, et est-ce un utilisateur ? */
		if( STREAMS_callsign[index][0] && (STREAMS_level[index] & LEVEL_user) )
			MSG_send(index, nMsg);
	}
}

/*------------------------------------------------------------------------
  ------ Envoyer un message lors d'une connexion/deconnexion d'un --------
  ------ cluster ---------------------------------------------------------
  ------------------------------------------------------------------------*/
#pragma argsused
void USERS_sendNodeLoginAnnouncement(char * pszNodeCall, int nIsIN)
{
	FILE   *fPtr;
	char	szFileName[256];
	char	szBuffer[256];
	int	index;

	/* Preparer le nom de fichier */
	sprintf(szFileName, "%s%s", SCRIPT_PATH, pszNodeCall);
	TOOLS_removeSsid(szFileName);
	if( nIsIN == TRUE )
		strcat(szFileName, ".in");
	else
		strcat(szFileName, ".out");

#ifdef LINUX
	strlwr(szFileName);
#endif

	/* Envoyer le fichier a tous les utilisateurs connectes,
	   s'il existe */
	fPtr = fopen(szFileName, "rt");
	if( ! fPtr )
		return;		/* Le fichier n'existe pas */

	/* Adresser le contenu du fichier a l'utilisateur */
	for(index = 1; index < MAX_STREAMS; index++)
	{
		if( ! STREAMS_callsign[index][0] || ! (STREAMS_level[index] & LEVEL_user) )
			continue;	/* Pas d'utilisateur connecte ici */

		fseek(fPtr, 0L, SEEK_SET);
		while( fgets(szBuffer, 255, fPtr) )
		{
			#ifdef LINUX
			TOOLS_removeR(szBuffer);
			#endif
			BUFFERS_addBuff(index, szBuffer, OUT);
		}

		/* Ajouter un CR si manquant */
		if( szBuffer[0] && szBuffer[strlen(szBuffer) - 1] != '\n' )
			BUFFERS_addBuff(index, "\n", OUT);
	}

	fclose( fPtr );
}

/*------------------------------------------------------------------------
  ------ Acceder a une config utilisateur --------------------------------
  ------------------------------------------------------------------------*/
/* Retourne FALSE si l'utilisateur n'existe pas */
int USERS_getConfig(char * szCallSign, tUser * user)
{
	if( ! USERS_isExist(szCallSign) )
		return FALSE;

	/* Acceder a la config utilisateur et copie son contenu */
	USERS_openRecord(66, szCallSign);
	memcpy(user, pUser, sizeof(tUser));

	return TRUE;
}

