#include <alloc.h>
#include <dir.h>
#include <string.h>
#include <stdio.h>
#include "tools.h"
#include "streams.h"
#include "define.h"
#include "users.h"
#include "message.h"
#include "commands.h"
#include "buffers.h"

//--------------------------------------------------------------------------
//------ Variables externes ------------------------------------------------
//--------------------------------------------------------------------------
extern 	char	STREAMS_callsign[MAX_STREAMS][10];
extern	tUserCfg * pUserCfg;
extern	unsigned long 	COMMANDS_statut[MAX_STREAMS];

//---------------------------------------------------------------------------
//------ Upload UserCmd -----------------------------------------------------
//---------------------------------------------------------------------------
//la fonction retourne TRUE si la modification du mot du jour est
//acceptee et FALSE sinon
int USERCMD_upload(int StreamNum)
{
  char	szFileName[MAXPATH];
  char	szUserCall[10];

  //Indicaitf de l'utilisateur connecte
  strcpy(szUserCall, STREAMS_callsign[StreamNum]);
  TOOLS_removeSsid (szUserCall);

  //Preparer le nom du fichier
  sprintf(szFileName, "%s%s.cmd", USERCMD_PATH, strlwr(szUserCall));

  //Memoriser la config utilisateur
  USERS_getRecord(StreamNum);			//Acceder a la config de l'utilisateur
  strcpy(pUserCfg->sFileName, szFileName);	//Copier le nom du fichier MOTD
  pUserCfg->iBufferLength = 0;			//Si le buffer existe deja, il sera automatiquement vide au premier appel
  USERS_updateLocalConfig(StreamNum);   	//Sauvegarder les modifs

  COMMANDS_statut[StreamNum] |= COMMANDS_statutChangeUserCMD;

  MSG_send(StreamNum, MSG57);

  return TRUE;
}

/*-----------------------------------------------------------------------
  ------ Lancer les commandes users -------------------------------------
  -----------------------------------------------------------------------*/
void USERCMD_run(int StreamNum)
{
  char  szFileName[MAXPATH];
  char	szUserCall[10];
  char	szBuffer[256];
  FILE *fPtr;

  /*Indicatif de l'utilisateur connecte*/
  strcpy(szUserCall, STREAMS_callsign[StreamNum]);
  TOOLS_removeSsid (szUserCall);

  /*Nom de fichier*/
  sprintf(szFileName, "%s%s.cmd", USERCMD_PATH, szUserCall);
  strlwr(szFileName);

  fPtr = fopen(szFileName, "rt");

  if( fPtr )
  {
    /*Un fichier utilisateur a pu etre ouvert - envoyer les commandes dans
      le buffer*/
    while( fgets(szBuffer, 255, fPtr) )
      BUFFERS_addBuff(StreamNum, TOOLS_N2R(szBuffer), IN);
    fclose (fPtr);
  }
  else
  {
    sprintf(szFileName, "%sdefault.cmd", USERCMD_PATH);

    fPtr = fopen(szFileName, "rt");

    if( fPtr )
    {
      /*Un fichier par defaut a pu etre ouvert - envoyer les commandes dans
	le buffer*/
      while( fgets(szBuffer, 255, fPtr) )
	BUFFERS_addBuff(StreamNum, TOOLS_N2R(szBuffer), IN);
      fclose (fPtr);
    }
  }/*End IF*/
}
