#include <alloc.h>
#include "define.h"
#include "buffers.h"
#include "tools.h"
#include "users.h"

/*-------------------------------------------------------------------------
  ------ Affiche la configuration courante du filtre ----------------------
  -------------------------------------------------------------------------*/
void UFILTER_show(int StreamNum, unsigned long lFilter)
{
	static char * pszTable[] = {"VLF  :", "HF   :", "VHF  :", "UHF  :",
				    "SHF  :", "MODE :" };
	char szBuffer[32];
	unsigned long lCurrent = 1L;
	int index = 0;

	for(int i = 0; i < 25; i++)
	{
		if( lCurrent == USERS_2KM  || lCurrent == USERS_160M ||
		    lCurrent == USERS_6M   || lCurrent == USERS_70CM ||
		    lCurrent == USERS_5CM  || lCurrent == USERS_SSB )
		{
			BUFFERS_printBuff(StreamNum, OUT, "\n%s ",
				pszTable[index++]);
		}

		if( lFilter & lCurrent )
		{

			TOOLS_bits2strBand(lCurrent, szBuffer);
			BUFFERS_printBuff(StreamNum, OUT, "%-5s ",
				szBuffer);
		}

		lCurrent = lCurrent << 1;
	}

	BUFFERS_addBuff(StreamNum, "\n", OUT);
}

/*-------------------------------------------------------------------------
  ------ Verifie si le spot doit etre filtre ------------------------------
  -------------------------------------------------------------------------
  Retourne TRUE si le spot passe dans le filtre                            */
int UFILTER_isOK(int StreamNum, unsigned long lBand, unsigned long lMode)
{
	extern tUser *pUser;
	unsigned long lUserFilter;

	/* Filtre utilisateur */
	USERS_getRecord(StreamNum);
	lUserFilter = ~(pUser->lBandsOff);
	
	/* Mode NODX_ANNOUNCEMENTS */
	if( pUser->iFlags & USERS_NODX )
		return FALSE;	

	if( ! (lUserFilter & lBand) || ! (lUserFilter & lMode) )
		return FALSE;

	return TRUE;
}
