#include <alloc.h>
#include <dir.h>
#include <string.h>
#include <dos.h>
#include <stdio.h>
#include <stdlib.h>
#include <time.h>
#include <ctype.h>
#include "tools.h"
#include "define.h"
#include "symbol.h"
#include "dx.h"
#include "users.h"
#include "commands.h"

#ifdef LINUX
#undef strcasecmp(ptr1,ptr2)
extern "C" int strcasecmp(char * s1, char * s2);
#endif


char sDateTable[12][4] = {"Jan", "Feb", "Mar", "Apr", "May", "Jun", "Jul", "Aug", "Sep", "Oct", "Nov", "Dec"};

extern	long	PARAMS_lTz;

//------------------------------------------------------------------------
//------ Enlve tous les BELL (BEEP) d'une chaine de caractres ----------
//------------------------------------------------------------------------
char * TOOLS_removeBell(char * String)
{
  char * pPtr;

  while( (pPtr = strchr(String, BELL)) != NULL )
    strcpy(pPtr, pPtr+1);

  return String;
}

//------------------------------------------------------------------------
//------ Enlve tous les '\n' d'une chaine de caractres -----------------
//------------------------------------------------------------------------
char * TOOLS_removeN(char * String)
{
  char * pPtr;

  while( (pPtr = strchr(String, '\n')) != NULL )
    strcpy(pPtr, pPtr+1);

  return String;
}

//------------------------------------------------------------------------
//------ Enlve tous les '\r' d'une chaine de caractres -----------------
//------------------------------------------------------------------------
char * TOOLS_removeR(char * String)
{
  char * pPtr;

  while( (pPtr = strchr(String, '\r')) != NULL )
    strcpy(pPtr, pPtr+1);

  return String;
}

//------------------------------------------------------------------------
//------ Enlve tous les '\n' et '\r' d'une chaine de caractres ---------
//------------------------------------------------------------------------
char * TOOLS_removeNR(char * String)
{
  char * pPtr;

  while( (pPtr = strchr(String, '\n')) != NULL )
    strcpy(pPtr, pPtr+1);

  while( (pPtr = strchr(String, '\r')) != NULL )
    strcpy(pPtr, pPtr+1);

  return String;
}

//------------------------------------------------------------------------
//------ Convertir tous les '\n' d'une chaine en '\r' --------------------
//------------------------------------------------------------------------
char * TOOLS_N2R(char * String)
{
  char * pPtr;

  while( (pPtr = strchr(String, '\n')) != NULL)
    *pPtr = '\r';

  return String;
}

//------------------------------------------------------------------------
//------ Convertir tous les '\r' d'une chaine en '\n' --------------------
//------------------------------------------------------------------------
char * TOOLS_R2N(char * String)
{
  char * pPtr;

  while( (pPtr = strchr(String, '\r')) != NULL )
    *pPtr = '\n';

  return String;
}

//------------------------------------------------------------------------
//------ Retourne l'heure (HHMM, ex 1045) --------------------------------
//------------------------------------------------------------------------
int TOOLS_whatTime(void)
{
  time_t	timer;
  struct    tm *sdate;

  timer = time(NULL) - PARAMS_lTz;
  sdate = localtime(&timer);

  return( sdate->tm_hour*100 + sdate->tm_min );
}

//------------------------------------------------------------------------
//------ Retourne l'heure dans une chaine --------------------------------
//------------------------------------------------------------------------
char * TOOLS_whatTime(char * Time)
{
  time_t 	timer;
  struct    tm *sdate;

  timer = time(NULL) - PARAMS_lTz;
  sdate = localtime(&timer);
  sprintf(Time, "%02d%02d", sdate->tm_hour, sdate->tm_min);

  return Time;
}

//------------------------------------------------------------------------
//------ Retourne la date dans une chaine (J-MM-AA) ----------------------
//------------------------------------------------------------------------
char * TOOLS_whatDate(char * Date)
{
  time_t	timer;
  struct    tm *sdate;

  timer = time(NULL) - PARAMS_lTz;
  sdate = localtime(&timer);
  //Remarque : packetcluster ne complete pas le premier caractre
  //du jour par un zro s'il est infrieur  10.
  sprintf(Date, "%2d-%3s-%4d", sdate->tm_mday,
			       sDateTable[sdate->tm_mon],
			       sdate->tm_year + 1900);
  return Date;
}

//------------------------------------------------------------------------
//------ Retourne la seconde (de 00  59 ) -------------------------------
//------------------------------------------------------------------------
int TOOLS_whatSec(void)
{
  time_t	timer;
  struct    tm *sdate;

  timer = time(NULL);
  sdate = localtime(&timer);

  return( sdate->tm_sec );
}

//------------------------------------------------------------------------
//------ Retourne le numero du mois --------------------------------------
//------------------------------------------------------------------------
int TOOLS_whatMonth(void)
{
  time_t	timer;
  struct    tm *sdate;

  timer = time(NULL) - PARAMS_lTz;
  sdate = localtime(&timer);

  return( sdate->tm_mon + 1);
}

//------------------------------------------------------------------------
//------ Retourne l'annee ------------------------------------------------
//------------------------------------------------------------------------
int TOOLS_whatYear(void)
{
  time_t	timer;
  struct    tm *sdate;

  timer = time(NULL) - PARAMS_lTz;
  sdate = localtime(&timer);

  /* Y2K */
  if( sdate->tm_year >= 100 )
	sdate->tm_year -= 100;

  return( sdate->tm_year );
}

//------------------------------------------------------------------------
//------ Convertir date et heure en un unsigned long (id. FAT) -----------
//------------------------------------------------------------------------
unsigned long TOOLS_dateTime_Str2Long(char * Date, char * Time)
{
  char *pPtr;
  unsigned long DateTime;

  //Description du long
  //bits	Description
  //0-4		jour
  //5-8		mois
  //9-15        anne - 1980
  //16-20	secondes / 2 (inutilis dans DxNet)
  //21-26	minutes
  //27-31	heure (0  23)

  //------ Convertir la date ------
  pPtr = Date;

  //Jour
  if( *pPtr == ' ' )	//A cause de packetcluster
    DateTime = atol(pPtr+1);		//BIT 0-4
  else
    DateTime = atol(pPtr);		//BIT 0-4
  pPtr += 3;

  //Mois
  DateTime += ((unsigned long) TOOLS_month2int(pPtr)) * 32L; //BIT 5-8
  pPtr += 4;

  //Anne
  DateTime += ( (atol(pPtr) - 1980L) % 100L ) * 512L;	//BIT 9-15

  //------ Convertir l'heure ------
  pPtr = Time;

  //Secondes ... on passe

  //Minutes
  DateTime += (atol(pPtr)%100L) * 2097152L;	//BIT 21-26

  //Heures
  DateTime += (atol(pPtr)/100L) * 134217728L;	//BIT 27-31

  return DateTime;
}

//------------------------------------------------------------------------
//------ Convertir un unsigned long en Date et Heure ---------------------
//------------------------------------------------------------------------
void TOOLS_dateTime_Long2Str(char * Date, char * Time, unsigned long DateTime)
{
  int 	iVal1;
  int	iVal2;

  //Description du long
  //bits	Description
  //0-4		jour
  //5-8		mois
  //9-15        anne - 1980
  //16-20	secondes / 2 (inutilis dans DxNet)
  //21-26	minutes
  //27-31	heure (0  23)

  //Heure
  iVal1 = (unsigned int) (DateTime / 134217728L);
  DateTime = DateTime % 134217728L;

  //Minutes
  iVal2 = (unsigned int) (DateTime / 2097152L);
  DateTime = DateTime % 2097152L;

  //Convertir en une chaine
  sprintf(Time, "%02d%02d", iVal1, iVal2);

  //Anne
  iVal1 = (unsigned int) (DateTime / 512L);
  iVal1 = iVal1 + 1980;
  DateTime = DateTime % 512L;

  //Mois
  iVal2 = (unsigned int) (DateTime / 32L);
  DateTime = DateTime % 32L;

  //Convertir en une chaine
  sprintf(Date, "%2d-%3s-%4d", (unsigned int) DateTime,
			       sDateTable[iVal2],
			       iVal1);
}

//------------------------------------------------------------------------
//------ Retourne Date et Heure dans un unsigned long --------------------
//------------------------------------------------------------------------
unsigned long TOOLS_whatDateTime(void)
{
  char sDate[12];
  char sTime[5];

  return TOOLS_dateTime_Str2Long(TOOLS_whatDate(sDate), TOOLS_whatTime(sTime));
}

/*------------------------------------------------------------------------
  ------ Conversion d'un lDateTime vers un time_t ------------------------
  ------------------------------------------------------------------------*/
time_t TOOLS_dateTime_Long2time_t(unsigned long lDateTime)
{
	struct tm t_tm;

	t_tm.tm_isdst = -1;
	t_tm.tm_sec   = 0;

	/* Heure */
	t_tm.tm_hour = (int) (lDateTime / 134217728L);
	lDateTime    = lDateTime % 134217728L;

	/* Minutes */
	t_tm.tm_min  = (int) (lDateTime / 2097152L);
	lDateTime    = lDateTime % 2097152L;

	/* Annee */
	t_tm.tm_year = (int) (lDateTime / 512L);
	t_tm.tm_year += 80;
	lDateTime    = lDateTime % 512L;

	/* Mois */
	t_tm.tm_mon  = (int) (lDateTime / 32L);
	lDateTime    = lDateTime % 32L;

	/* Jour */
	t_tm.tm_mday  = (int) lDateTime;

	return mktime(&t_tm);
}

/*------------------------------------------------------------------------
  ------ Calcule la difference entre deux lDateTime ----------------------
  ------ Retourne la difference en secondes ------------------------------
  ------------------------------------------------------------------------*/
double TOOLS_diffDateTime(unsigned long lDateTime1, unsigned long lDateTime2)
{
	return difftime(TOOLS_dateTime_Long2time_t(lDateTime1),
			TOOLS_dateTime_Long2time_t(lDateTime2));
}

/*------------------------------------------------------------------------
  ------ Lire une heure dans une chaine, de la forme 1d,14h,15m,47s ------
  ------ et retourne le resultat, en secondes ----------------------------
  ------------------------------------------------------------------------
  Retour : -1L si erreur                                                  */
long TOOLS_parseTime(const char * pszString)
{
	char * token;
	char * buf;
	long   lSeconds = 0L;

	if( pszString[0] == SNULL )
		return -1L;

	if( (buf = (char*) malloc(strlen(pszString) + 1)) == NULL )
		return -1L;
	else
		strcpy(buf, pszString);

	strlwr(buf);

	token = strtok(buf, ",");
	while(token)
	{
		long  lMult;
		char *pszMult;
		int   index;
		int   Length;

		/* Rechercher la position de l'unite (hours, minutes, ...) */
		index = 0;
		while( isdigit(token[index]) && token[index] != SNULL )
			index++;

		if( index == 0 )
		{
			free(buf);
			return -1L;	/* Pas de chiffre ! */
		}
		else
		{
			pszMult = token + index;
			Length = strlen(pszMult);
		}

		/* Quelle unite ? */
		if( pszMult[0] == SNULL )
			lMult = 60L;	/* Par default : minutes */
		else if( COMMANDS_check(pszMult, "days", Length, 1) )
			lMult = 86400L;
		else if( COMMANDS_check(pszMult, "minutes", Length, 1) )
			lMult = 60L;
		else if( COMMANDS_check(pszMult, "hours", Length, 1) )
			lMult = 3600L;
		else if( COMMANDS_check(pszMult, "seconds", Length, 1) )
			lMult = 1L;
		else
		{
			free(buf);
			return -1L;
		}

		lSeconds += atol(token) * lMult;
		token = strtok(NULL, ",");
	}

	free(buf);
	return lSeconds;
}

/*------------------------------------------------------------------------
  ------ Convertir un nombre de secondes en une chaine de la forme -------
  ------ 1d,14m,15s .... -------------------------------------------------
  ------------------------------------------------------------------------*/
char * TOOLS_seconds2string(long lSeconds, char * pszBuffer)
{
	long val;
	char str[256];

	pszBuffer[0] = SNULL;

	val = lSeconds / 86400L;
	if( val != 0L )
	{
		sprintf(str, "%ldd,", val);
		strcat(pszBuffer, str);
	}
	lSeconds %= 86400L;

	val = lSeconds / 3600L;
	if( val != 0L )
	{
		sprintf(str, "%ldh,", val);
		strcat(pszBuffer, str);
	}
	lSeconds %= 3600L;

	val = lSeconds / 60L;
	if( val != 0L )
	{
		sprintf(str, "%ldm,", val);
		strcat(pszBuffer, str);
	}

	val = lSeconds % 60L;
	if( val != 0L )
	{
		sprintf(str, "%lds,", val);
		strcat(pszBuffer, str);
	}

	if( strlen(pszBuffer) == 0 )
		strcpy(pszBuffer, "0s");
	else
		pszBuffer[strlen(pszBuffer) - 1] = SNULL;

	return pszBuffer;
}

//------------------------------------------------------------------------
//------ Enlve le SSID --------------------------------------------------
//------------------------------------------------------------------------
char * TOOLS_removeSsid(char * String)
{
  char *pPtr;

  if( String == NULL )
    return NULL;	//Par scurit

  pPtr = strchr(String, '-');
  if( pPtr )
    *pPtr = SNULL;

  return String;
}

//------------------------------------------------------------------------
//------ Quel est le SSID ? ----------------------------------------------
//------------------------------------------------------------------------
int TOOLS_whatSsid(char * CallSign)
{
  char *pPtr;

  if( CallSign == NULL )
   return 0;	//Par scurit

  pPtr = strchr(CallSign, '-');
  if( pPtr )
    return( atoi(pPtr+1) );
  else
    return 0;
}

//------------------------------------------------------------------------
//------ Ajoute le SSID a l'indicatif ------------------------------------
//------------------------------------------------------------------------
char * TOOLS_addSsid(char * CallSign, int Ssid)
{
  char string[10];

  if( CallSign == NULL )
    return NULL;	//Par secutit

  sprintf(string, "-%d", Ssid);
  strcat(CallSign, string);

  return CallSign;
}

//------------------------------------------------------------------------
//------ Convertir le numro de version stock dans une chaine -----------
//------ de caractres ("5449") en un int stock dans deux octets --------
//------------------------------------------------------------------------
char * TOOLS_versionStr2Int(char * VersionString, char * VersionInt)
{
  unsigned iVersion = atoi( VersionString );

  VersionInt[0] = iVersion / 256;
  VersionInt[1] = iVersion % 256;
  VersionInt[2] = SNULL;

  return VersionInt;
}

//------------------------------------------------------------------------
//------ Convertir le numro de version int stock dans 2 octets ---------
//------ en une chaine de caractres ("5449") ----------------------------
//------------------------------------------------------------------------
char * TOOLS_versionInt2Str(char * VersionInt, char * VersionString)
{
  unsigned int iVersion = VersionInt[0] * 256 + VersionInt[1];

  sprintf(VersionString, "%d", iVersion);

  return VersionString;
}

//------------------------------------------------------------------------
//------ Limiter la longueur d'une chaine si celle-ci est trop longue ----
//------------------------------------------------------------------------
char * TOOLS_maxLength(char * String, int Length)
{
  if( strlen(String) > (unsigned int) Length )
    String[Length] = SNULL;

  return String;
}

//------------------------------------------------------------------------
//------ Retourner le numro du mois -------------------------------------
//------------------------------------------------------------------------
int TOOLS_month2int(char * Month)
{
  for(int index = 0; index < 12; index++)
  {
    if( ! strncmp(Month, sDateTable[index], 3) )
      return index;
  }/*End FOR*/

  return 0;	//Mois pas trouv !
}

//------------------------------------------------------------------------
//------ Est-ce une trame en "binaire" -----------------------------------
//------------------------------------------------------------------------
//Retourne TRUE si des caractres < 32 on t trouvs (sauf CR & LF)
int TOOLS_isBin(char * Frame, int Length)
{
  int 	index;
  char *pPtr = Frame;

  //Parcourir la chaine ...
  for(index = 0; index < Length; index++)
  {
    if( *pPtr == BELL )
      *pPtr = 14;	//double croche
    else if( *pPtr < 0x20 && *pPtr != CR && *pPtr != LF )
      return TRUE;
    pPtr++;
  }/*End FOR*/

  return FALSE;
}

//------------------------------------------------------------------------
//------ Est-ce un indicatif ---------------------------------------------
//------------------------------------------------------------------------
//La fonction retourne TRUE si la chaine contient au minimum trois octets
//dont un chiffre
//Si des caracteres autres que A-Z, 0-9, '/' et '-' sont trouves, la fonction
//retourne FALSE
int TOOLS_isCall(const char * CallSign)
{
  int	iDigit = FALSE;

  if( CallSign == NULL )
    return FALSE;

  if( strlen(CallSign) > 9 )
    return FALSE;

  while( *CallSign )
  {
    if( isdigit (*CallSign) )
      iDigit = TRUE;
    else if( ! isupper (*CallSign) && *CallSign != '/' && *CallSign != '-' )
      return FALSE;

    CallSign++;
  }/*End FOR*/

  //Y avait-il un chiffre ?
  if( iDigit )
    return TRUE;
  else
    return FALSE;
}

//------------------------------------------------------------------------
//------ Copie de fichier vers un .BAK -----------------------------------
//------------------------------------------------------------------------
//La fonction retourne TRUE si succes
int TOOLS_makeBak(char * szFileName)
{
  char	szBak[MAXPATH];
  FILE *fOrg;
  FILE *fDest;
  int	nData;
  char *pszPtr;

  //Creer le nom de fichier .BAK
  strcpy(szBak, szFileName);
  pszPtr = strchr(szBak, '.');
  if( pszPtr )
	strcpy(pszPtr, ".bak");
  else
	strcat(szBak,  ".bak");

  //Ouvrir les fichiers
  fOrg = fopen(szFileName, "rb");

  if( ! fOrg )			//Le fichier n'a pas pu tre ouvert
  {
    perror("fopen in TOOLS_makeBak (fOrg)");
    return FALSE;
  }

  fDest = fopen(szBak, "wb");

  if( ! fDest )			//Le fichier n'a pas pu tre ouvert
  {
    perror("fopen in MAIL_makeBak (fDest)");
    fclose(fOrg);
    return FALSE;
  }

  while( (nData = fgetc(fOrg)) != EOF )
    fputc(nData, fDest);

  fclose (fOrg);
  fclose (fDest);

  return TRUE;
}

//------------------------------------------------------------------------
//------ Calcule la difference entre deux time_t -------------------------
//------------------------------------------------------------------------
void TOOLS_diffTime(time_t first, time_t second, int * nDays, int * nHours, int * nMin)
{
  double	dDiff = difftime(second, first);
  long          lDiff = (long) (dDiff / 60L);	/*Differences en minutes*/

  *nDays  = (int) (lDiff / 1440L);	/*Nombre de jours*/
  lDiff  %= 1440L;			/*Reste en minutes*/

  *nHours = (int) (lDiff / 60L);	/*Nombre d'heures*/

  *nMin   = (int) (lDiff % 60L);	/*Reste en minutes*/
}

//------------------------------------------------------------------------
//------ Secure - atoi - Accepte un pointeur NULL et retourne 0 ----------
//------------------------------------------------------------------------
#undef 	atoi(ptr) //Ne pas rinventer la recursivit...
unsigned int TOOLS_atoi(char * ptr)
{
  if( ptr == NULL )
    return 0;
  else
    return( atoi(ptr) );
}

/* -----------------------------------------------------------------------
   ------ Definition d'une fonction stricmp sous linux -------------------
   -----------------------------------------------------------------------*/
#ifdef LINUX
int TOOLS_stricmp(char * ptr1, char * ptr2)
{
	return strcasecmp(ptr1, ptr2);
}
#endif

/*------------------------------------------------------------------------
  ------ Convertir une frequence ou une bande en un entier represantant --
  ------ la bande de frequence (voir aussi DX_checkFrequency  ------------
  ------------------------------------------------------------------------
  La fonction accepte : 2km, 160m...2m, 70cm...1cm, 6mm une une frequence
  dans la plage specifiee
  Retour : bande ou 0 si erreur
*/
unsigned long TOOLS_frequency2bits(char * pszFrequency)
{
	char * ptr;
	float  fBand;

	/* Rechercher la premiere partie non numerique */
	ptr = pszFrequency;
	while(*ptr && isdigit(*ptr))
		ptr++;

	if( *ptr == SNULL )
	{
		/* ne comporte pas de chaine de caractere, c'est
		   une frequence */
		return DX_checkFrequency((unsigned long) (atof(pszFrequency) * 
			10000.0));
	}

	/* Le choix entre km, m, cm et mm (la bande est convertie en mm) */
	fBand = atof(pszFrequency);
	if( ! stricmp(ptr, "km") )
		fBand *= 1000000.0;
	else if( ! stricmp(ptr, "m") )
		fBand *= 1000.0;
	else if( ! stricmp(ptr, "cm") )
		fBand *= 10.0;
	else if( stricmp(ptr, "mm") )
		return 0;	/* pas trouve : erreur de syntaxe */

	if( fBand == 2000000.0 ) return USERS_2KM;
	if( fBand ==  160000.0 ) return USERS_160M;
	if( fBand ==   80000.0 ) return USERS_80M;
	if( fBand ==   40000.0 ) return USERS_40M;
	if( fBand ==   30000.0 ) return USERS_30M;
	if( fBand ==   20000.0 ) return USERS_20M;
	if( fBand ==   17000.0 ) return USERS_17M;
	if( fBand ==   15000.0 ) return USERS_15M;
	if( fBand ==   12000.0 ) return USERS_12M;
	if( fBand ==   10000.0 ) return USERS_10M;
	if( fBand ==    6000.0 ) return USERS_6M;
	if( fBand ==    4000.0 ) return USERS_4M;
	if( fBand ==    2000.0 ) return USERS_2M;
	if( fBand ==    1350.0 ) return USERS_135CM;
	if( fBand ==     700.0 ) return USERS_70CM;
	if( fBand ==     340.0 ) return USERS_34CM;
	if( fBand ==     230.0 ) return USERS_23CM;
	if( fBand ==     130.0 ) return USERS_13CM;
	if( fBand ==      50.0 ) return USERS_5CM;
	if( fBand ==      30.0 ) return USERS_3CM;
	if( fBand ==      10.0 ) return USERS_1CM;
	if( fBand ==       6.0 ) return USERS_6MM;

	return 0;
}

/*-----------------------------------------------------------------------
  ------ Convertir un int (cf fonction precedente) en une chaine --------
  -----------------------------------------------------------------------*/
char * TOOLS_bits2strBand(unsigned long lBand, char * pszBuffer)
{
	int nIndex;
	static char * pszBand[] = { "2km", "160m", "80m", "40m", "30m",
				    "20m", "17m",  "15m", "12m", "10m",
				    "6m",  "4m",   "2m",  "135cm", "70cm",
				    "34cm", "23cm", "13cm", "5cm", "3cm",
				    "1cm", "6mm", "SSB", "CW", "RTTY",
				    "?" };

	/* Rechercher ... */
	for(nIndex = 0; nIndex < 25; nIndex++)
	{
		if( lBand == 1L )
			break;
		lBand = lBand >> 1;
	}

	strcpy(pszBuffer, pszBand[nIndex]);
	return pszBuffer;
}

/*-----------------------------------------------------------------------
  ------ Chercher le mode en fonction de la frequence -------------------
  -----------------------------------------------------------------------*/
unsigned long TOOLS_mode2bits(float fFrequency)
{
	FILE * fPtr;
	char szBuffer[1024];
	char szFrequency[1024];
	char *ptr;
	unsigned long lCurrentMode = USERS_SSB | USERS_CW | USERS_RTTY;
	float fFreq1;
	float fFreq2;

	fPtr = fopen(MODE_FILE, "rt");
	if( ! fPtr )
	{
		perror("fopen in TOOLS_getMode");
		return lCurrentMode;
	}

	while( fgets(szBuffer, sizeof szBuffer, fPtr) )
	{
		sscanf(szBuffer, "%s", szFrequency);
		strupr(szFrequency);

		if( szFrequency[0] == '#' )
			continue;

		if( ! strcmp(szFrequency, "[SSB]") )
		{
			lCurrentMode = USERS_SSB;
			continue;
		}

		if( ! strcmp(szFrequency, "[CW]") )
		{
			lCurrentMode = USERS_CW;
			continue;
		}

		if( ! strcmp(szFrequency, "[RTTY]") )
		{
			lCurrentMode = USERS_RTTY;
			continue;
		}

		ptr = strchr(szFrequency, '-');
		if( ptr == NULL )
			continue;

		*ptr++ = SNULL;

		fFreq1 = atof(szFrequency);
		fFreq2 = atol(ptr);

		if( fFreq1 <= fFrequency && fFrequency <= fFreq2 )
		{
			fclose(fPtr);
			return lCurrentMode;
		}
	}

	fclose(fPtr);

	/* Pas trouve, on retourne TOUS les modes */
	return USERS_SSB | USERS_CW | USERS_RTTY;
}

/*------------------------------------------------------------------------
  ------ Convertir ^^ -> ^ dans une chaine de caractere ------------------
  ------------------------------------------------------------------------*/
char * TOOLS_PCQuote2to1(char * pszBuffer)
{
	char * ptr = pszBuffer;

	while( (ptr = strchr(ptr, '^')) != NULL )
	{
		if( *(ptr + 1) == '^' )
			memmove(ptr, ptr + 1, strlen(ptr));
		ptr++;
	}

	return pszBuffer;
}

/*------------------------------------------------------------------------
  ------ Convertir ^ -> ^^ dans une chaine de caractere ------------------
  ------------------------------------------------------------------------*/
char * TOOLS_PCQuote1to2(char * pszBuffer)
{
	char * ptr = pszBuffer;

	while( (ptr = strchr(ptr, '^')) != NULL )
	{
		memmove(ptr + 1, ptr, strlen(ptr) + 1);
		*ptr = '^';
		ptr += 2;
	}

	return pszBuffer;
}

/*------------------------------------------------------------------------
  ------ Enleve d'une chaine tout les caracteres qui ne sont ni ----------
  ------ pas des codes ascii affichables (y compris les espaces) ---------
  ------------------------------------------------------------------------*/
char* TOOLS_removeNonAscii(const char * pszString, char * pszBuffer)
{
	char * ptr = pszBuffer;

	while( *pszString )
	{
		if( *pszString >= 33 && *pszString <= 126 )
			*ptr++ = *pszString;

		pszString++;
	}
	*ptr = SNULL;

	return pszBuffer;
}

/* This function returns the numbers of seconds since January, 1st 1970 */
time_t TOOLS_dateHMS(char * pszDate)
{
	struct tm tTmTime;
	int	  index;

	memset (&tTmTime, 0, sizeof (struct tm));

	/* Day */
	if( pszDate[0] == ' ' )
		tTmTime.tm_mday = atoi (pszDate + 1);
	else
		tTmTime.tm_mday = atoi (pszDate);

	/* Month */
	for (index = 0; index < 12; index++)
	{
		if( ! strncmp (pszDate + 3, sDateTable[index], 3) )
		{
			tTmTime.tm_mon = index;
			break;
		}
	} /* End FOR */

	/* Year */
	tTmTime.tm_year = atoi	(pszDate + 9);

	return (mktime (&tTmTime));
}

