// windows portage of dxnet - TELNET common functions - (c) f5mzn
// This code is designed to be compiled both on windows and linux

#include <alloc.h>
#include <stdio.h>
#include <string.h>
#include "define.h"
#include "tools.h"

static int TELNET_nIsOpen = FALSE;

/*-----------------------------------------------------------------------------------------
  ------ Verifie le password pour une connection telnet -----------------------------------
  -----------------------------------------------------------------------------------------
*/
int TELNET_isPasswordOk(char *call, char *str)
{
	FILE *fptr;
	int ok = 0;
	char ligne[80];
	char callsign[256];
	char password[256];
	char withoutssid[256];

	fptr = fopen (PASSWORD_FILE, "r");
	if (fptr == NULL)
		return (0);
		
	strcpy(withoutssid, call);
	TOOLS_removeSsid(withoutssid);

	while (fgets (ligne, sizeof (ligne), fptr))
	{
		sscanf (ligne, "%s %s", callsign, password);
		
		if( ! stricmp(call, callsign) && ! stricmp(str, password) )
		{
			ok = 1;
			break;
		}
		
		if( strchr(callsign, '-') )
			continue;
			
		if( ! stricmp(withoutssid, callsign) && ! stricmp(str, password) )
		{
			ok = 1;
			break;
		}			
	}

	fclose (fptr);
	return (ok);
}

/*-----------------------------------------------------------------------------------------
  ------ Verifie si c'est la premiere connection ------------------------------------------
  -----------------------------------------------------------------------------------------
  retourne 1 si c'est la premiere connexion SAUF si l'acces n'est pas ouvert
*/
int TELNET_isFirstConnection(char* call)
{
	int first = 1;
	FILE *fptr;
	char ligne[80];
	char callsign[256];
	char password[256];
	char withoutssid[256];

	if( TELNET_nIsOpen == FALSE )
		return 0;

	fptr = fopen (PASSWORD_FILE, "r");
	if (fptr == NULL)
		return 0;
		
	strcpy(withoutssid, call);
	TOOLS_removeSsid(withoutssid);

	while (fgets (ligne, sizeof (ligne), fptr))
	{
		sscanf (ligne, "%s %s", callsign, password);
		
		if( ! stricmp(call, callsign) )
		{
			first = 0;
			break;
		}

		if( strchr(callsign, '-') )
			continue;
			
		if( ! stricmp(withoutssid, callsign) )
		{
			first = 0;
			break;
		}
	}

	fclose (fptr);
	return first;
}

/*-----------------------------------------------------------------------------------------
  ------ Ouvrir ou fermer l'acces telnet --------------------------------------------------
  -----------------------------------------------------------------------------------------
*/
int TELNET_openAccess(int nIsOpen)
{
	TELNET_nIsOpen = nIsOpen;

	return nIsOpen;
}

/*-----------------------------------------------------------------------------------------
  ------ Retourne TRUE si l'acces telnet est ouvert ---------------------------------------
  -----------------------------------------------------------------------------------------
*/
int TELNET_isOpen(void)
{
	return TELNET_nIsOpen;
}
