#ifdef WIN32
#include <windows.h>
#endif

#include <alloc.h>
#include <string.h>
#include <dir.h>
#include <stdio.h>
#include <dos.h>
#ifndef DOS
#include <keyboard.h>
#endif
#include "define.h"
#include "streams.h"
#include "buffers.h"
#include "message.h"
#include "protocol.h"
#include "hops.h"
#include "node.h"
#include "users.h"
#include "set.h"
#include "tools.h"
#include "log.h"
#include "motd.h"
#include "switch.h"
#include "mail.h"
#include "usercmd.h"
#include "password.h"
#include "commands.h"
#include "system.h"
#include "time.h"
#include "filter.h"
#include "dos.h"
#include "medit.h"

//------ Variables globales ------------------------------------------------
char  	STREAMS_lang[MAX_STREAMS];
char	STREAMS_callsign[MAX_STREAMS][10];
char	STREAMS_level[MAX_STREAMS + RCMD_VIRTSTREAM];
int	STREAMS_iDiddle[MAX_STREAMS];

extern  char	PROTOCOL_linkType[65];
extern	char	PROTOCOL_initDone[65];
extern  char	SCRIPT_fileName[65][9];
extern	int		SCRIPT_fromStream[MAX_STREAMS];
extern 	char	PROTOCOL_badCRC[65];
extern  unsigned char	HOPS_In[65][256];
extern	unsigned char	HOPS_Out[65][256];
extern	char   *MSG_pParams[10];
extern	unsigned long	MAIL_lFwdMsgNumber[MAX_STREAMS];

extern  tUser    * pUser;
extern  tUserCfg * pUserCfg;

extern char	*PARAMS_adjacentNodes;
extern char	*PARAMS_sysop;
extern char	*PARAMS_logs;
extern char 	*PARAMS_blackCalls;
extern char 	*PARAMS_ssid;
extern int	 PARAMS_iDefaultDiddle;

//--------------------------------------------------------------------------
//------ Connexion d'une station -------------------------------------------
//--------------------------------------------------------------------------
void STREAMS_connect(int StreamNum, char * CallSign)
{
  int	index;
  char	sNodeCall[11];
  char	sSysop[11];
  char	sUserCall[11];
  char	sSsid[5];
  extern int PARAMS_nCFilter;
  extern unsigned long 	COMMANDS_statut[MAX_STREAMS];
  int   nFlags;

  //Sous linux, une connexion sortant gnre une connexion entrante
  if( STREAMS_level[StreamNum] & LEVEL_linkSetup )
	return;

  COMMANDS_statut[StreamNum] = 0;

  /* Verifier tout de suite si c'est un indicatif liste noire ...  */
  strcpy(sUserCall, CallSign);

  /* Sans SSID Specifique ? */
  if( ! strchr(sUserCall, '-') )	/* SSID -0, qu'il faut ajouter */
	strcat(sUserCall, "-0");

  if( SET_check(PARAMS_blackCalls, sUserCall) )
  {
	/* Deconnecter immediatement */
	SWITCH_discSwitch(StreamNum);
	return;
  }

  /* Avec SSID specifique */
  TOOLS_removeSsid(sUserCall);
  if( SET_check(PARAMS_blackCalls, sUserCall) )
  {
	/* Deconnecter immediatement */
	SWITCH_discSwitch(StreamNum);
	return;
  }/*End IF*/

  /* Mettre a jour la variable Diddle */
  STREAMS_iDiddle[StreamNum] = PARAMS_iDefaultDiddle;

  /* Acceder a la config utilisateur pour s'assurer qu'uncun buffer n'est
     ouvert. */
  USERS_getRecord(StreamNum);
  if( pUserCfg->pBuffer )      		/* Un buffer est-il ouvert en memoire ? */
	free( pUserCfg->pBuffer );	/* Oui ... le fermer */

  memset(pUserCfg, 0, sizeof(*pUserCfg));		/* Tout initialiser */
  pUserCfg->lConnectedDateTime = TOOLS_whatDateTime();	/* Heure et date de connexion */
  USERS_updateLocalConfig(StreamNum);			/* Updater les modifs */

  strcpy(STREAMS_callsign[StreamNum], CallSign);
  
  /* Virrer le SSID s'il est egal a zero dans STREAMS_callsign */
  if( TOOLS_whatSsid( STREAMS_callsign[StreamNum] ) == 0 )
	TOOLS_removeSsid( STREAMS_callsign[StreamNum] );

  /* Est-ce un Cluster ? */
  if( SET_check(PARAMS_adjacentNodes, STREAMS_callsign[StreamNum]) )
  {
	extern int 	FirstStream;	/*switch.cpp*/
	extern int 	LastStream;	/*switch.cpp*/

	char	szBuffer[256];

	/* Verifier que cet indicatif (exact) n'est pas deja connecte */
	for(index = FirstStream; index <= LastStream; index++)
	{
		if( index == StreamNum )
			continue;

		if( ! strcmp(CallSign, STREAMS_callsign[index]) )
		{
			char * msg = "You can't connect twice\r";

			/* Deconnecter ! */
			SWITCH_sendFrame(StreamNum, msg, strlen(msg));
			delay(1000);
			SWITCH_discSwitch(StreamNum);
			STREAMS_callsign[StreamNum][0] = SNULL;
			return;
		}

	}

	HOPS_readFile(StreamNum, CallSign);		/* Lire le fichier de config des hop count */

	/* Transmettre la liste des clusters connectes */
	PROTOCOL_sendConnectedNodeList(StreamNum);

	/* Transmettre le request init (PC18) */
	sprintf(szBuffer, "DxNet v%s", VERSION);
	if( HOPS_fix(StreamNum, NULL, 0, PCCLULINK, HOPS_OUT, 100) )
		BUFFERS_printBuff(StreamNum, OUT, "PC18^%s <CLU-%s>^%d^\n", szBuffer, VERSION_CLU, VERSION_INT);
	else
		BUFFERS_printBuff(StreamNum, OUT, "PC18^%s^%d^\n", szBuffer, VERSION_INT);

	STREAMS_level[StreamNum] = LEVEL_cluster;
	PROTOCOL_linkType[StreamNum] = PAVILLON;
	PROTOCOL_initDone[StreamNum] = 0;
	PROTOCOL_badCRC[StreamNum]   = 0;
	BUFFERS_printBuff(BUFFER_SCREEN1, OUT, "Channel %d> %s joinning the cluster.\n", StreamNum, CallSign);
	MAIL_lFwdMsgNumber[StreamNum] = 0L;	/* Pour les forward sortants */
	STREAMS_iDiddle[StreamNum]    = 300; 	/* PC50 : le 1er a 5 minutes, les suivants seront a 15 minutes */

	/* TERMINE ! */
	return;
  }

  //Virrer, si besoin, le SSID de la station
  sprintf(sSsid, "%d", TOOLS_whatSsid(CallSign));
  if( ! SET_check(PARAMS_ssid, sSsid) )
    TOOLS_removeSsid(CallSign);

  /*Cet indicatif est-il dj connect au cluster ?*/
  for(index = 0; index < 16; index++)
  {
	int	nStream;
	int	nSsid;
	char	szNodeCall[16];
	extern int 	FirstStream;	/*switch.cpp*/
	extern int 	LastStream;	/*switch.cpp*/

	nStream = NODE_searchUser (CallSign, NODE_CHECKSSID_YES, szNodeCall);
	if( nStream < FirstStream || nStream > LastStream || *szNodeCall )
		break;	/*Peut-etre connecte, mais pas ici !*/
	/*Indicatif deja connecte - Augmenter de 1 le SSID*/
	nSsid = TOOLS_whatSsid (CallSign);
	if( ++nSsid > 15 )
	  nSsid = 0;
	TOOLS_removeSsid(CallSign);
	TOOLS_addSsid(CallSign, nSsid);
  }

  STREAMS_level[StreamNum] = LEVEL_user;

  //Lire la config utilisateur
  USERS_openRecord(StreamNum, CallSign);
  pUserCfg->lConnectedDateTime = TOOLS_whatDateTime();	//Heure et date de connexion
  USERS_updateLocalConfig(StreamNum);			//Updater les modifs

  //Dterminer la langue
  STREAMS_lang[StreamNum] = pUser->byLanguage;

  //Ajouter cette nouvelle station dans la table
  NODE_newUser(NODE_LOCALCONNECT, StreamNum, "", CallSign, 0);

  //Dclarer l'utilisateur en SET/HERE
  NODE_getNodeCall(0, 0, sNodeCall);
  NODE_setUserFlag(sNodeCall, CallSign, PROTOCOL_USER_HERE);

  //Mmoriser sans le SSID
  strcpy(STREAMS_callsign[StreamNum], CallSign);

  //Accueillir la nouvelle station
  BUFFERS_printBuff(StreamNum, OUT, "[MZN-%s]\n", VERSION);

  /* Gestion des filtrages WW */
  nFlags = USERS_getFlags(StreamNum);
  FILTER_setUser(StreamNum, nFlags);

  /*CFilter*/
  if( PARAMS_nCFilter )
  {
    if( PARAMS_nCFilter == 3 )	/*CFILTER on - pas de password demande*/
    {
      char szPass[256];

      if( ! PASSWORD_getPass(sUserCall, szPass) )
      {
	/*Call non declare -> RX seulement*/
	STREAMS_ctext (StreamNum);
	SYSTEM_showFile(StreamNum, CFILTER_FILE);
	STREAMS_level[StreamNum] |= LEVEL_user_RXonly;
      }
      else
      {
	STREAMS_ctext (StreamNum);
      }
    }
    else if( PASSWORD_sendKey(StreamNum, sUserCall) )
    {
      if( PARAMS_nCFilter == 1 )
	COMMANDS_statut[StreamNum] |= COMMANDS_statutWaitCFilter1;
      else
	COMMANDS_statut[StreamNum] |= COMMANDS_statutWaitCFilter2;
    }
    else
    {
      if( PARAMS_nCFilter == 1 )	/*Deconnecter l'utilisateur*/
      {
	SYSTEM_showFile(StreamNum, CFILTER_FILE);
	COMMANDS_statut[StreamNum] = COMMANDS_statutWillDisconnect;
      }
      else
      {
	STREAMS_ctext (StreamNum);
	SYSTEM_showFile(StreamNum, CFILTER_FILE);
	STREAMS_level[StreamNum] |= LEVEL_user_RXonly;
      }
    }
  }
  else
  {
    STREAMS_ctext (StreamNum);
  }

  /*Est-ce un sysop ?*/
  strcpy(sSysop, CallSign);

  /*Chercher d'abord pour un SSID donn*/
  if( ! strchr(sSysop, '-') )
    strcat(sSysop, "-0");	/*Ajouter le SSID -0 si besoin*/
  if( SET_check(PARAMS_sysop, sSysop) )
    STREAMS_level[StreamNum] |= LEVEL_sysopD;	/*Sysop dclar*/

  /*Chercher maintenant sans tenir compte du SSID*/
  TOOLS_removeSsid(sSysop);
  if( SET_check(PARAMS_sysop, sSysop) )
    STREAMS_level[StreamNum] |= LEVEL_sysopD;	/*Sysop dclar*/

  /* Message pour la console */
  BUFFERS_printBuff(BUFFER_SCREEN1, OUT, "Channel %d> Connected to %s\n", StreamNum, CallSign);

  /* Message pour les utilisateurs locaux ... */
  USERS_sendUserLoginAnnouncement(StreamNum, CallSign, MSG67);

}

//--------------------------------------------------------------------------
//------ Envoyer le texte de connection a l'utilisateur --------------------
//--------------------------------------------------------------------------
void STREAMS_ctext(int StreamNum)
{
	extern time_t	MAIN_timeStart;
	int	iNodes,
		iLocalUsers,
		iTotalUsers,
		iMaxUsers;
	int   	iDays,
		iHours,
		iMin;
	unsigned long	dwNewMail;
	char	szUserCall[16];

	/*Indicatif de l'utilisateur*/
	strcpy(szUserCall, STREAMS_callsign[StreamNum]);

	/*Ligne Cluster*/
	NODE_getConfig(iNodes, iLocalUsers, iTotalUsers, iMaxUsers);
	TOOLS_diffTime(MAIN_timeStart, time(NULL), &iDays, &iHours, &iMin);
	BUFFERS_printBuff(StreamNum, OUT,
		"Cluster: %d nodes, %d local / %d total users - Max users %d Uptime %dd %02d:%02d\n",
		iNodes, iLocalUsers, iTotalUsers, iMaxUsers,
		iDays, iHours, iMin);

	/*CTEXT (fichier langage)*/
	MSG_send(StreamNum, CTEXT);

	/*Mot du jour*/
	MOTD_send(StreamNum, STREAMS_lang[StreamNum]);

	/*Y a t-il de nouveaux messages ?*/
	dwNewMail = MAIL_isNew(szUserCall);
	if( dwNewMail )
	{
		char szNewMail[256];

		sprintf(szNewMail, "%ld", dwNewMail);
		MSG_pParams[1] = szNewMail;
		MSG_send(StreamNum, MSG55);
	}

	/*User command*/
	USERCMD_run(StreamNum);

	/*Est-ce un nouvel utilisateur ? (on le sait si le prenom est inconnu)*/
	if( ! strcmp(pUser->sName, pUser->sCallSign) )
		MSG_send(StreamNum, MSG12);

	/*Envoyer le prompt*/
	MSG_send(StreamNum, PROMPT);

	/*Transmettre le protocol aux adjacents*/
	if( StreamNum >=  1 && StreamNum <= 64 )
		PROTOCOL_sendNewLocalUser(szUserCall, PROTOCOL_USER_HERE);
}

/*-------------------------------------------------------------------------
  ------ Deconnexion d'une station ----------------------------------------
  -------------------------------------------------------------------------*/
void STREAMS_disconnect(int StreamNum)
{
	char  szCallSign[16];
	int   index;
	char  szDate1[16];
	char  szDate2[16];
	char  szTime1[16];
	char  szTime2[16];

#ifdef DOS
	DOS_clean(StreamNum);
#endif
	MEDIT_clean(StreamNum);

	/* Date et Heure de connexion */
	USERS_getRecord(StreamNum);
	TOOLS_dateTime_Long2Str(szDate1, szTime1, pUserCfg->lConnectedDateTime);

	/* Date et Heure de deconnexion */
	TOOLS_whatDate(szDate2);
	TOOLS_whatTime(szTime2);
	
	/* Remmetre a zero les flags USERS_NODX et USERS_NOANNOUCEMENTS */
	pUser->iFlags &= ~USERS_NOANNOUNCEMENTS;
	pUser->iFlags &= ~USERS_NODX;
  
  	/* Updater le nombre de connection, la date de la derniere connection,
	   le nombre de connexions et les flags */	
  	USERS_saveRecord(StreamNum);

	/* Est-ce un link setup ? */
	if( STREAMS_level[StreamNum] & LEVEL_linkSetup )
	{
		BUFFERS_printBuff(SCRIPT_fromStream[StreamNum], OUT,
			"*** Link disconnected with %s on stream %d.\n",
			SCRIPT_fileName[StreamNum], StreamNum);
		MSG_send(SCRIPT_fromStream[StreamNum], MSG1);
	} /*End IF*/

	/* Est-ce un Cluster ou un utilisateur (pour prevenir les adjacents) ? */
	if( STREAMS_level[StreamNum] == LEVEL_cluster )
	{
		int nHops;

		/* Rechercher tous les indicatifs des clusters connectes sur
		   ce stream et les enlever de la table */
		for(index = 0; index < NODE_MAXANODE; index++)
		{
			NODE_getNodeCall(StreamNum, index, szCallSign);

			if( szCallSign[0] == SNULL )
				continue;	/* Personne ... */

			/* Prevenir les adjacents */
			if( HOPS_isExternal(StreamNum) )
				nHops = HOPS_fix(StreamNum, NULL, 0, PCEXTERNAL, HOPS_IN, 100);
			else
				nHops = HOPS_fix(StreamNum, NULL, StreamNum, PC21, HOPS_IN, 100);

			PROTOCOL_nodeDisconnect(StreamNum, szCallSign,
				PROTOCOL_REASON_STR2, PROTOCOL_REASON_INT2,
				nHops);

			if( index != 0 )
			{
				/* Ne pas enlever le premier tout
				   de suite, car il est indispensable pour
				   les fonctions loop filters */
				NODE_deleteNode(StreamNum, szCallSign);

				/* NODE_deleteNode decalant d'un cran les
				   nodes, decrementer index */
				index--;
			}

			BUFFERS_printBuff(BUFFER_SCREEN1, OUT,
				"Node logged out : %s\n", szCallSign);

		}

		/* Effacer le premier cluster (cf plus haut) */
		NODE_getNodeCall(StreamNum, 0, szCallSign);
		NODE_deleteNode(StreamNum, szCallSign);

		/* Enregistrer la deconnexion dans le log */
		if( SET_check(PARAMS_logs, LOG_NODE_STR) )
		{
			LOG_write(LOG_NODE_FILE, LOG_DATE_NO,
				"%s %sZ > %s %sZ : %s\n", szDate1, szTime1,
				szDate2, szTime2, STREAMS_callsign[StreamNum]);
		}
	}
	else if( STREAMS_level[StreamNum] != LEVEL_discByOp )
	{
		if( STREAMS_callsign[StreamNum][0] )
		{
			/* Afficher un message sur la console */
			BUFFERS_printBuff(BUFFER_SCREEN1, OUT,
				"Channel %d> Disconnected from %s\n",
				StreamNum, STREAMS_callsign[StreamNum]);
			USERS_sendUserLoginAnnouncement(StreamNum,
				STREAMS_callsign[StreamNum], MSG68);

			/* Enlever l'utilisateur de la table */
			NODE_deleteUser(StreamNum, "",
				STREAMS_callsign[StreamNum]);

			/* Prevenir les adjacents */
			PROTOCOL_deleteLocalUser(STREAMS_callsign[StreamNum]);

			/* Enregistrer la deconnexion dans le log */
			if( SET_check(PARAMS_logs, LOG_USER_STR) )
			{
				LOG_write(LOG_USER_FILE, LOG_DATE_NO,
					"%s %sZ > %s %sZ : %s\n", szDate1,
					szTime1, szDate2, szTime2,
					STREAMS_callsign[StreamNum]);
			}
		}/*End IF*/
	}/*End IF*/

	STREAMS_level[StreamNum] 	= 0;	 /* Initialiser le level */
	STREAMS_callsign[StreamNum][0] 	= SNULL; /* Effacer l'indicatif */
	PROTOCOL_linkType[StreamNum]	= 0;	 /* Initialiser le type de link */
	PROTOCOL_initDone[StreamNum] 	= 0;     /* Pour les fonction HOPS ... */
	SCRIPT_fileName[StreamNum][0]	= SNULL; /* Effacer le nom du fichier script (ou cas ou il existerait) */
	HOPS_In [StreamNum][PCAS_USER] 	= 0;
	HOPS_Out[StreamNum][PCAS_USER] 	= 0;

	/* Vider et fermer le buffer */
	BUFFERS_close(StreamNum);

	/* Acceder a la config utilisateur pour s'assurer qu'uncun buffer
	   n'est ouvert */
	USERS_getRecord(StreamNum);
	if( pUserCfg->pBuffer )			/* Un buffer est-il ouvert en memoire ? */
		free( pUserCfg->pBuffer );	/* Oui ... le fermer */
	memset(pUserCfg, 0, sizeof(*pUserCfg));	/* Tout initialiser */
	USERS_updateLocalConfig(StreamNum);	/* Updater les modifs */
}

//--------------------------------------------------------------------------
//------ Initialisation ----------------------------------------------------
//--------------------------------------------------------------------------
void STREAMS_init(void)
{
  int index;

  for(index = 1; index < MAX_STREAMS; index++)
  {
    STREAMS_level[index] 	= 0;
    STREAMS_callsign[index][0]	= 0;

    /* Streams_level pour les remote commands */
    STREAMS_level[index + RCMD_VIRTSTREAM] = LEVEL_user | LEVEL_sysopV | LEVEL_sysopD;
  }

  strcpy(STREAMS_callsign[0],  "NOCALL");
  strcpy(STREAMS_callsign[65], "NOCALL");

  STREAMS_level[65] = LEVEL_user + LEVEL_sysopV + LEVEL_sysopD;	//Dfinir la console locale (F2) en tant que SYSOP Dclar et Valid
  STREAMS_level[0]  = LEVEL_sysopV + LEVEL_sysopD;		//Dfinir la console locale (F2) en tant que SYSOP Dclar et Valid
}
