#include <alloc.h>
//#include <time.h>
#include <string.h>
#include <stdio.h>
#include "mail.h"
#include "dx.h"
#include "announce.h"
#include "wwv.h"
#include "wcy.h"
#include "purg.h"
#include "buffers.h"
#include "define.h"
#include "tools.h"

/* ----------------------------------------------------------------------
   ------ Purge la base de donnees des mails ----------------------------
   ----------------------------------------------------------------------
   Retourne TRUE si OK
*/
int PURG_mail(int StreamNum, int nPrivDelete, int nBullDelete)
{
	FILE *	fDirMes;
	FILE *	fDirOld;
	char	szBin[256];
	char	szOld[256];
	BYTE 	byDeleteMsg;
	DirMesStruct	tDirMes;
	int	nDeletedCount = 0;

	/* Preparer les noms de fichiers */
	strcpy(szBin, MAIL_DIRMES_FILE);
	strcpy(szOld, MAIL_DIRMES_FILE);
	strcpy(szOld + strlen(szOld) - 4, ".old");

	fDirMes = fopen (szBin, "rb");
	if( ! fDirMes )	/* Error opening the file */
	{
		perror ("fopen in PURG_mail -> dirmes.bin");
		fcloseall();
		return FALSE;
	}

	fDirOld = fopen (szOld, "w+b");
	if( ! fDirOld )	/* Error opening the file */
	{
		perror ("fopen in PURG_mail -> dirmes.old");
		fcloseall();
		return FALSE;
	}

	/* Copy dirmes.bin in dirmes.old */
	BUFFERS_addBuff(StreamNum, "Creating dirmes.old ...\n", OUT);
	for (;;)
	{
		if( ! fread(&tDirMes, sizeof (tDirMes), 1, fDirMes) )
			break;	/* EOF */

		fwrite(&tDirMes, sizeof(tDirMes), 1, fDirOld);
	}
	BUFFERS_addBuff(StreamNum, "Done\n", OUT);

	/* Reouvrir le fichier dirmes.bin mais en ecriture cette fois */
	fclose (fDirMes);
	fDirMes = fopen (szBin, "wb");
	if( ! fDirMes )	/* Error opening the file */
	{
		perror ("fopen in PURG_mail -> dirmes.bin");
		fcloseall();
		return FALSE;
	}


	/* Pointer a nouveu dirmes.old en debut de fichier */
	fseek (fDirOld, 0L, SEEK_SET);

	for (;;)
	{
		byDeleteMsg = FALSE;	/* Reset the flag */

		if( ! fread (&tDirMes, sizeof (tDirMes), 1, fDirOld) )
			break;	/* EOF */

		/* Is the mail killed ? */
		if( tDirMes.cStatut == STATUT_K )
		{
			/* Delete the message file */
			byDeleteMsg = TRUE;
		}
		else
		{
			time_t	tMsgTime;

			tMsgTime = TOOLS_dateHMS(tDirMes.szDate);

			/* Is the message to be deleted ? */
			if( tDirMes.cType == 'P' )
			{
				if( difftime(time (NULL), tMsgTime) > (86400 * nPrivDelete) )
				byDeleteMsg = TRUE;
			}
			else
			{
				if( difftime(time (NULL), tMsgTime) > (86400 * nBullDelete) )
				byDeleteMsg = TRUE;
			}/* End IF */
		}/* End IF */

		if( byDeleteMsg && ! tDirMes.byNoAutoDelete)
		{
			char	szMsg[256];
			/* Delete the mail */
			BUFFERS_printBuff(StreamNum, OUT,
				"Deleting message #%ld ...\n", tDirMes.dwNumber);
			sprintf(szMsg, "%sm%07ld.msg", MAIL_PATH, tDirMes.dwNumber);
			unlink(szMsg);

			nDeletedCount++;
		}
		else
		{
			/* Copy the header */
			fwrite(&tDirMes, sizeof (tDirMes), 1, fDirMes);
		}/*End IF*/
	}/*End FOR*/

	fclose (fDirOld);
	fclose (fDirMes);

	BUFFERS_printBuff(StreamNum, OUT,
		"Complete : %ld mails purged\n", nDeletedCount);

	return TRUE;
}

/* ----------------------------------------------------------------------
   ------ Purge la base de donnees DX -----------------------------------
   ----------------------------------------------------------------------
   Retourne TRUE si OK
*/
int PURG_dx(int StreamNum, int nDelDays)
{
	FILE *	fBinFile;
	FILE *	fOldFile;
	char	szBin[256];
	char	szOld[256];
	long	lSpotNum    = 0L;
	long	lDelSpotNum = 0L;
	DXSPOT	tDxSpot;

	strcpy (szOld, szBin);
	strcpy (szOld + strlen (szOld) - 4, ".old");

	/* Preparer les noms de fichiers */
	strcpy(szBin, DX_FILE);
	strcpy(szOld, DX_FILE);
	strcpy(szOld + strlen(szOld) - 4, ".old");

	/* Create a bak file */
	/* Open the files */
	fBinFile = fopen (szBin, "rb");
	if( ! fBinFile )	/* Error opening the file */
	{
		perror ("fopen in PURG_dx -> dx.bin");
		fcloseall();
		return FALSE;
	}

	fOldFile = fopen (szOld, "w+b");
	if( ! fOldFile )	/* Error opening the file */
	{
		perror ("fopen in PURG_dx -> dx.old");
		fcloseall();
		return FALSE;
	}

	/* Copy dx.bin -> dx.old */
	BUFFERS_addBuff(StreamNum, "Creating dx.old\n", OUT);
	for(;;)
	{
		if( ! fread (&tDxSpot, sizeof (tDxSpot), 1, fBinFile) )
			break;	/* EOF */
		fwrite (&tDxSpot, sizeof (tDxSpot), 1, fOldFile);
	}/* End FOR */
	BUFFERS_addBuff(StreamNum, "Done\n", OUT);

	fclose(fBinFile);
	fclose(fOldFile);

	fBinFile = fopen (szBin, "wb");
	if( ! fBinFile )	/* Error opening the file */
	{
		perror ("fopen in PURG_dx -> dx.bin");
		fcloseall();
		return FALSE;
	}

	fOldFile = fopen (szOld, "rb");
	if( ! fOldFile )	/* Error opening the file */
	{
		perror ("fopen in PURG_dx -> dx.old");
		fcloseall();
		return FALSE;
	}

	for (;;)
	{
		time_t SpotTime;

		if( ! fread (&tDxSpot, sizeof (tDxSpot), 1, fOldFile) )
			break;	/* EOF */

		/* Is this spot to be killed ? */
		SpotTime = TOOLS_dateHMS(tDxSpot.szDate);
		if( difftime (time (NULL), SpotTime) < (86400L * (double) nDelDays) )
		{
			/* No, copy it */
			fwrite(&tDxSpot, sizeof (tDxSpot), 1, fBinFile);
			lSpotNum++;
		}
		else
		{
			/* Yes, do not copy it */
			lDelSpotNum++;
		} /* End IF */
	} /* End FOR  */

	fclose (fOldFile);
	fclose (fBinFile);

	BUFFERS_printBuff(StreamNum, OUT,
		"Complete : %ld spots left, %ld deleted.\n",
		lSpotNum, lDelSpotNum);

	return TRUE;
}

/* ----------------------------------------------------------------------
   ------ Purge la base de donnees ANNONCES -----------------------------
   ----------------------------------------------------------------------
   Retourne TRUE si OK
*/
int PURG_announce(int StreamNum, int nDelDays)
{
	FILE *	fBinFile;
	FILE *	fOldFile;
	int	index;
	long	lSpotNum    = 0L;
	long	lDelSpotNum = 0L;
	char	szBin[256];
	char	szOld[256];
	ANNOUNCE tAnnounce;

	strcpy (szOld, szBin);
	strcpy (szOld + strlen (szOld) - 4, ".old");

	/* Preparer les noms de fichiers */
	strcpy(szBin, ANNOUNCE_FILE);
	strcpy(szOld, ANNOUNCE_FILE);
	strcpy(szOld + strlen(szOld) - 4, ".old");

	/* Create a bak file */
	/* Open the files */
	fBinFile = fopen (szBin, "rb");
	if( ! fBinFile )	/* Error opening the file */
	{
		perror ("fopen in PURG_announce -> announce.bin");
		fcloseall();
		return FALSE;
	}

	fOldFile = fopen (szOld, "w+b");
	if( ! fOldFile )	/* Error opening the file */
	{
		perror ("fopen in PURG_announce -> announce.old");
		fcloseall();
		return FALSE;
	}

	/* Copy dx.bin -> dx.old */
	BUFFERS_addBuff(StreamNum, "Creating announce.old\n", OUT);
	for(;;)
	{
		if( ! fread (&tAnnounce, sizeof (tAnnounce), 1, fBinFile) )
			break;	/* EOF */
		fwrite (&tAnnounce, sizeof (tAnnounce), 1, fOldFile);
	}/* End FOR */
	BUFFERS_addBuff(StreamNum, "Done\n", OUT);

	fclose(fBinFile);
	fclose(fOldFile);

	fBinFile = fopen (szBin, "wb");
	if( ! fBinFile )	/* Error opening the file */
	{
		perror ("fopen in PURG_announce -> announce.bin");
		fcloseall();
		return FALSE;
	}

	fOldFile = fopen (szOld, "rb");
	if( ! fOldFile )	/* Error opening the file */
	{
		perror ("fopen in PURG_announce -> announce.old");
		fcloseall();
		return FALSE;
	}

	for (;;)
	{
		char   szDate[16];
		char   szTime[16];
		time_t SpotTime;

		if( ! fread (&tAnnounce, sizeof (tAnnounce), 1, fOldFile) )
			break;	/* EOF */

		/* Is this announcement to be killed ? */
		TOOLS_dateTime_Long2Str (szDate, szTime, tAnnounce.lDateTime);
		SpotTime = TOOLS_dateHMS(szDate);
		if( difftime (time (NULL), SpotTime) < (86400L * (double) nDelDays) )
		{
			/* No, copy it */
			fwrite(&tAnnounce, sizeof (tAnnounce), 1, fBinFile);
			lSpotNum++;
		}
		else
		{
			/* Yes, do not copy it */
		  	lDelSpotNum++;
		} /* End IF */
	} /* End FOR  */

	fclose (fOldFile);
	fclose (fBinFile);

	BUFFERS_printBuff(StreamNum, OUT,
		"Complete : %ld announcements left, %ld deleted.\n",
		lSpotNum, lDelSpotNum);

	return TRUE;
}

/* ----------------------------------------------------------------------
   ------ Purge la base de donnees WWV ----------------------------------
   ----------------------------------------------------------------------
   Retourne TRUE si OK
*/
int PURG_wwv(int StreamNum, int nDelDays)
{
	FILE *	fBinFile;
	FILE *	fOldFile;
	char	szBin[256];
	char	szOld[256];
	long	lSpotNum    = 0L;
	long	lDelSpotNum = 0L;
	WWVSPOT tWWVSpot;

	strcpy (szOld, szBin);
	strcpy (szOld + strlen (szOld) - 4, ".old");

	/* Preparer les noms de fichiers */
	strcpy(szBin, WWV_FILE);
	strcpy(szOld, WWV_FILE);
	strcpy(szOld + strlen(szOld) - 4, ".old");

	/* Create a bak file */
	/* Open the files */
	fBinFile = fopen (szBin, "rb");
	if( ! fBinFile )	/* Error opening the file */
	{
		perror ("fopen in PURG_wwv -> wwv.bin");
		fcloseall();
		return FALSE;
	}

	fOldFile = fopen (szOld, "w+b");
	if( ! fOldFile )	/* Error opening the file */
	{
		perror ("fopen in PURG_wwv -> wwv.old");
		fcloseall();
		return FALSE;
	}

	/* Copy dx.bin -> dx.old */
	BUFFERS_addBuff(StreamNum, "Creating wwv.old\n", OUT);
	for(;;)
	{
		if( ! fread (&tWWVSpot, sizeof (WWVSPOT), 1, fBinFile) )
			break;	/* EOF */
		fwrite (&tWWVSpot, sizeof (WWVSPOT), 1, fOldFile);
	}/* End FOR */
	BUFFERS_addBuff(StreamNum, "Done\n", OUT);

	fclose(fBinFile);
	fclose(fOldFile);

	fBinFile = fopen (szBin, "wb");
	if( ! fBinFile )	/* Error opening the file */
	{
		perror ("fopen in PURG_wwv -> wwv.bin");
		fcloseall();
		return FALSE;
	}

	fOldFile = fopen (szOld, "rb");
	if( ! fOldFile )	/* Error opening the file */
	{
		perror ("fopen in PURG_wwv -> wwv.old");
		fcloseall();
		return FALSE;
	}

	for (;;)
	{
		time_t SpotTime;

		if( ! fread (&tWWVSpot, sizeof (WWVSPOT), 1, fOldFile) )
			break;	/* EOF */

		/* Is this spot to be killed ? */
		SpotTime = TOOLS_dateHMS(tWWVSpot.szDate);
		if( difftime (time (NULL), SpotTime) < (86400L * (double) nDelDays) )
		{
		  /* No, copy it */
		  fwrite(&tWWVSpot, sizeof (WWVSPOT), 1, fBinFile);
		  lSpotNum++;
		}
		else
		{
		  /* Yes, do not copy it */
		  lDelSpotNum++;
		} /* End IF */
	} /* End FOR  */

	fclose (fOldFile);
	fclose (fBinFile);

	BUFFERS_printBuff(StreamNum, OUT,
		"Complete : %ld wwv spots left, %ld deleted.\n",
		lSpotNum, lDelSpotNum);

	return TRUE;
}

/* ----------------------------------------------------------------------
   ------ Purge la base de donnees WCY ----------------------------------
   ----------------------------------------------------------------------
   Retourne TRUE si OK
*/
int PURG_wcy(int StreamNum, int nDelDays)
{
	FILE *	fBinFile;
	FILE *	fOldFile;
	char	szBin[256];
	char	szOld[256];
	long	lSpotNum    = 0L;
	long	lDelSpotNum = 0L;
	WCYSPOT tWCYSpot;

	strcpy (szOld, szBin);
	strcpy (szOld + strlen (szOld) - 4, ".old");

	/* Preparer les noms de fichiers */
	strcpy(szBin, WCY_FILE);
	strcpy(szOld, WCY_FILE);
	strcpy(szOld + strlen(szOld) - 4, ".old");

	/* Create a bak file */
	/* Open the files */
	fBinFile = fopen (szBin, "rb");
	if( ! fBinFile )	/* Error opening the file */
	{
		perror ("fopen in PURG_wcy -> wcy.bin");
		fcloseall();
		return FALSE;
	}

	fOldFile = fopen (szOld, "w+b");
	if( ! fOldFile )	/* Error opening the file */
	{
		perror ("fopen in PURG_wcy -> wcy.old");
		fcloseall();
		return FALSE;
	}

	/* Copy dx.bin -> dx.old */
	BUFFERS_addBuff(StreamNum, "Creating wcy.old\n", OUT);
	for(;;)
	{
		if( ! fread (&tWCYSpot, sizeof (WCYSPOT), 1, fBinFile) )
			break;	/* EOF */
		fwrite (&tWCYSpot, sizeof (WCYSPOT), 1, fOldFile);
	}/* End FOR */
	BUFFERS_addBuff(StreamNum, "Done\n", OUT);

	fclose(fBinFile);
	fclose(fOldFile);

	fBinFile = fopen (szBin, "wb");
	if( ! fBinFile )	/* Error opening the file */
	{
		perror ("fopen in PURG_wcy -> wcy.bin");
		fcloseall();
		return FALSE;
	}

	fOldFile = fopen (szOld, "rb");
	if( ! fOldFile )	/* Error opening the file */
	{
		perror ("fopen in PURG_wcy -> wcy.old");
		fcloseall();
		return FALSE;
	}

	for (;;)
	{
		time_t SpotTime;

		if( ! fread (&tWCYSpot, sizeof (WCYSPOT), 1, fOldFile) )
			break;	/* EOF */

		/* Is this spot to be killed ? */
		SpotTime = TOOLS_dateHMS(tWCYSpot.szDate);
		if( difftime (time (NULL), SpotTime) < (86400L * (double) nDelDays) )
		{
		  /* No, copy it */
		  fwrite(&tWCYSpot, sizeof (WCYSPOT), 1, fBinFile);
		  lSpotNum++;
		}
		else
		{
		  /* Yes, do not copy it */
		  lDelSpotNum++;
		} /* End IF */
	} /* End FOR  */

	fclose (fOldFile);
	fclose (fBinFile);

	BUFFERS_printBuff(StreamNum, OUT,
		"Complete : %ld wcy spots left, %ld deleted.\n",
		lSpotNum, lDelSpotNum);

	return TRUE;
}

