#ifndef PROTOCOL_H
#define PROTOCOL_H

#include "define.h"

#define PAVILLON	0
#define CLU_LINK	1

#define CL(x)		(x)

#define PROTOCOL_INIT_NOTSTART	0
#define PROTOCOL_INIT_DO	1
#define	PROTOCOL_INIT_DONE	2

#define FLAG_SOFTWAREUNKNOWN	1
#define FLAG_PACKETCLUSTER      2
#define FLAG_CLUSSE		3
#define FLAG_DXNET		4

#define BIT0 	1
#define BIT1	2
#define BIT2	4
#define BIT3	8
#define BIT4	16
#define BIT5	32
#define BIT6	64
#define BIT7	128

#define PROTOCOL_REASON_INT0	0
#define PROTOCOL_REASON_STR0	"Shutdown"
#define PROTOCOL_REASON_INT1	1
#define PROTOCOL_REASON_STR1	"Disconnected by operator"
#define PROTOCOL_REASON_INT2	2
#define PROTOCOL_REASON_STR2	"Hard disconnect"

#define PROTOCOL_ALL		0

#define PROTOCOL_USER_HERE		BIT0
#define PROTOCOL_USER_CONF		BIT1
#define PROTOCOL_USER_CLUSTERCONF       BIT2

#define PROTOCOL_TALK_BELL	BIT0

#define PROTOCOL_PING_ASK	1
#define PROTOCOL_PING_ANSWER	0

#define PROTOCOL_OK		0
#define PROTOCOL_BADCALL	1
#define PROTOCOL_BADARGNUMBER	2
#define PROTOCOL_USERUNKNOWN	3
#define PROTOCOL_NODEUNKNOWN	4
#define PROTOCOL_BADFREQUENCY	5
#define PROTOCOL_UNKNOWNERROR	6
#define PROTOCOL_BADMSGNUMBER	7
#define PROTOCOL_BADUSERCOUNT	8
#define PROTOCOL_STROVERFLOW	9
#define PROTOCOL_BADSIZE	10
#define PROTOCOL_BADCRC		11
#define PROTOCOL_UNKNOWN	12
#define PROTOCOL_LOOP		13

#define PROTOCOL_DX		1
#define PROTOCOL_ANNOUNCEMENT	2
#define PROTOCOL_CONFERENCE	3
#define PROTOCOL_EXIT		4
#define PROTOCOL_WWV		5
#define PROTOCOL_RCMD		6
#define PROTOCOL_MISC		7
#define PROTOCOL_WCY		8

#define PPARAM	128

void 	PROTOCOL_sendProt(int StreamNum, char * pszOriginatedPC, int Pc, char * Pavillon, char * CluLink, int Hops, int CluLinkSize, int ToStream, int nWAZ);
void	PROTOCOL_do(int StreamNum, char * Cmd);
void 	PROTOCOL_pavillon(int StreamNum, char * Cmd);
void 	PROTOCOL_cluLink(int StreamNum, char * Cmd);
void 	PROTOCOL_sendInit(int StreamNum);
void 	PROTOCOL_cluLink(int StreamNum, char * Cmd);
void	PROTOCOL_nodeDisconnect(int StreamNum, char * NodeCall, char * sReason, int iReason, int Hops);
int 	PROTOCOL_addPascalString(char * Dest, char * Org, unsigned int Pos);
char  * PROTOCOL_readPascalString(char * Dest, char * Org, int nMaxSize);
char  * PROTOCOL_readPascalString(char * Dest, char * Org);
void 	PROTOCOL_sendNewLocalUser(char * UserCall, unsigned char Flag);
void 	PROTOCOL_deleteUser(int StreamNum, char * NodeCall, char * UserCall, int Hops);
void 	PROTOCOL_deleteLocalUser(char * UserCall);
void 	PROTOCOL_sendDx(int StreamNum, char * NodeCall, char * UserCall, unsigned long Frequency, char * Date, char * Time, char * DxCall, char * Comments, int Hops);
void 	PROTOCOL_sendUserConfig(int StreamNum, char * FromNode, char * FromUser, char * String, int Data, int Hops);
void 	PROTOCOL_sendAnnounce(int StreamNum, char * FromNode, char * FromUser, char * ToNode, unsigned long DateTime, char Flag, char * String, int Hops);
int 	PROTOCOL_sendTalk(int StreamNum, char * FromNode, char * FromUser, char * ToNode, char * ToUser, char * String, char Flag, unsigned long DateTime, int Hops);
#if 0
A EFFACER APRES LA RELEASE 3.5
void 	PROTOCOL_sendUserFlag(int StreamNum, char * NodeCall, char * UserCall, char Flag, int Type, int Hops);
#endif
int 	PROTOCOL_sendUserFlag(int StreamNum, char * pszFromPC, char * pszFromUser, int nType, int nIsEnable, int nHops);
int 	PROTOCOL_ping(int StreamNum, char * FromNode, char * ToNode, int PingFlag, int Hops);
void 	PROTOCOL_sendWwv(int StreamNum, char * NodeCall, char * UserCall, int SFI, int A, int K, char * Date, char * Time, char * Forecast, int Hops);
void	PROTOCOL_sendSubject(int StreamNum, char * ToNode, char * FmNode, char * Recipient, char * Sender, char * Date, char * Time, int Private, char * Subject, int NumOfLines, char * StartNode, BYTE RetReceipt);
void 	PROTOCOL_sendAckSubject(int StreamNum, char * ToNode, char * FmNode, unsigned long MesNum);
void	PROTOCOL_sendText(int StreamNum, char * ToNode, char * FmNode, unsigned long MesNum, char * Text);
void 	PROTOCOL_sendAckText(int StreamNum, char * ToNode, char * FmNode, unsigned long MesNum);
void 	PROTOCOL_sendAckCompleteText(int StreamNum, char * ToNode, char * FmNode, unsigned long MesNum);
void	PROTOCOL_sendCompleteText(int StreamNum, char * FmNode, char * ToNode, unsigned long MesNum);
void	PROTOCOL_abortForwarding(int StreamNum);
void 	PROTOCOL_userCount(int StreamNum, char * sFromNode, int iToAll, unsigned short iUserCount, int iHops);
int 	PROTOCOL_dbRequest(int StreamNum, char * szFromNode, char * szToNode, int nUserStream, char * szQualifier, char * szKey, char * szFromUser);
void 	PROTOCOL_dbResponse(int StreamNum, char * szFromNode, char * szToNode, int nUserStream, char * szInfo);
void 	PROTOCOL_dbComplete(int StreamNum, char * szFromNode, char * szToNode, int nUserStream);
void 	PROTOCOL_cluLink(int StreamNum, char * pszCluLink);
void 	PROTOCOL_sendConnectedNodeList(int StreamNum);
int 	PROTOCOL_rCmd(int StreamNum, char * pszFromPC, char * pszToPC, char * pszUser, char * pszCmd);
int 	PROTOCOL_rCmdResponse(int StreamNum, char * pszFromPC, char * pszToPC, char * pszUser, char * pszResponse);
int 	PROTOCOL_sendExplicitDisconnect(int StreamNum, char * pszToPC, char * pszReason);
int 	PROTOCOL_rcvExplicitDisconnect(int StreamNum, char * pszFromPC, char * pszReason, int nHops);
int 	PROTOCOL_clusterStreamDisconnected(int StreamNum, char * pszReason, int nHops);
void 	PROTOCOL_sendTalkProt(int StreamNum, char * szFromNode, char * szFromUser, char * szToNode, char * szToUser, char * szString, char Flag, unsigned long lDateTime, int nExternal, int nHops);
int 	PROTOCOL_WWVDX_mergeRequest(int StreamNum, char * pszFromPC, char * pszToPC, int nMRdx, int nMRwwv);
int 	PROTOCOL_DXMergeInfo(int StreamNum, char * pszOriginatedPC, char * pszToPC, char * pszLogger, unsigned long lFrequency, char * pszDate, char * pszTime, char * pszDxCall, char * pszComments);
int 	PROTOCOL_WWVMergeInfo(int StreamNum, char * pszOriginatedPC, char * pszToPC, char * pszLogger, int nSFI, int nA, int nK, char * pszDate, char * pszTime, char * pszForecast);
int 	PROTOCOL_sendClusterConfLogin(int StreamNum, char * pszFromPC, char * pszFromUser, int nHops);
int	PROTOCOL_sendClusterConfLogout(int StreamNum, char * pszFromPC, char * pszFromUser, int nHops);
int 	PROTOCOL_sendClusterConferenceMessage(int StreamNum, char * pszFromPC, char * pszFromUser, char * pszMessage, int nHops);
int 	PROTOCOL_sendForwardingAbort(int StreamNum, char * pszToPC, char * pszFromPC, unsigned long lMesNum);
void 	PROTOCOL_sendWcy(int StreamNum,char* pszDate, char* pszTime, int nSFI, int nA, int nK, int nExpK, int nR, char* pszSA, char* pszGMF, char* pszAurora, char* pszLogger, char* pszFromPC, int nHops);

unsigned int PROTOCOL_setCluLink(char * CluLink, unsigned char ProtNum);

#endif