#include <alloc.h>
#include <stdio.h>
#include <stdlib.h>
#include "params.h"
#include "define.h"

//-------------------------------------------------------------------------
//------ Variables globales -----------------------------------------------
//-------------------------------------------------------------------------

char * 	PARAMS_adjacentNodes;
char * 	PARAMS_sysop;
char * 	PARAMS_logs;
char * 	PARAMS_blackCalls;
char * 	PARAMS_ssid;

long   	PARAMS_lTz = 0L;

int	PARAMS_iDefaultDiddle = -1;
int	PARAMS_iSetDxSsid     = 0;
int	PARAMS_nCFilter       = 0;
	/* 0 : Pas de filtre de connexion
	   1 : Filtre de connexion actif / Systeme ferme
	   2 : Filtre de connexion actif / Read Only*/
int	PARAMS_nIsMonitorOn = TRUE;

long	PARAMS_lDxRejectBefore  = 1800L;	/* secondes */
long	PARAMS_lDxRejectAfter   = 900L;
long	PARAMS_lAnnDupeAllowed  = 86400L;	/* secondes */

//------ Initialisation des paramtres du node ----------------------------
void PARAMS_init(void)
{
  PARAMS_adjacentNodes = (char *) malloc(256);
  PARAMS_sysop         = (char *) malloc(256);
  PARAMS_logs	       = (char *) malloc(256);
  PARAMS_blackCalls    = (char *) malloc(256);
  PARAMS_ssid	       = (char *) malloc(256);

  if( ! PARAMS_adjacentNodes ||
      ! PARAMS_sysop         ||
      ! PARAMS_logs          ||
      ! PARAMS_blackCalls    ||
      ! PARAMS_ssid             )
  {
    printf("*** Error in PARAMS.CPP : not enough memory to allocate buffers.\n");
    exit(EXIT_FAILURE);
  }

  *PARAMS_adjacentNodes = SNULL;
  *PARAMS_sysop		= SNULL;
  *PARAMS_logs		= SNULL;
  *PARAMS_blackCalls	= SNULL;
  *PARAMS_ssid		= SNULL;
}

