#include <alloc.h>
#include <string.h>
#include <stdlib.h>
#include "language.h"
#include "buffers.h"
#include "message.h"
#include "node.h"
#include "define.h"
#include "tools.h"
#include "users.h"
#include "help.h"
#include "mail.h"

/* Liste des variables
	%D	Date	JJ-MMM-YYYY
	%d	Date	JJ-MMM
	%H	Heure
	%I	Prnom de l'utilisateur
	%L	Numero du dernier message recu
	%l	Langue de l'utilisateur
	%O	Indicatif du serveur
	%o	indicatif du serveur SANS SSID
	%U	Indicatif de l'OM connect
	%u	indicatif de l'OM connecte SANS SSID
	%x      Date of the last connection (format 01-Apr-2000)
	%y      Time of the last connection (format 01:02)
	%Z 	Dernier message liste par l'OM
	%0-%9	Variables temporaires (commande et paramtres taps par l'utilisateur)
*/

extern 	char  	STREAMS_lang[MAX_STREAMS];
extern  char	STREAMS_callsign[MAX_STREAMS][10];
extern  tUser * pUser;


char    *MSG_pParams[10];

//---------------------------------------------------------------------------
//------ Envoyer un message -------------------------------------------------
//---------------------------------------------------------------------------
//La liste des messages se trouve dans le fichier MESSAGE.H
void MSG_send(int StreamNum, int Line)
{
  char sBuffer[256];

  //Lire le message (en faisant attention aux remote commands)
  if( StreamNum >= 0 && StreamNum <= 65 )
  	LANG_getMessage(STREAMS_lang[StreamNum], Line, sBuffer);
else
	LANG_getMessage(0, Line, sBuffer);

  //Remplacer les variables
  MSG_insertVar(StreamNum, sBuffer);

  //Ajouter dans le buffer
  BUFFERS_addBuff(StreamNum, sBuffer, OUT);
}

//---------------------------------------------------------------------------
//------ Insrer les variables ----------------------------------------------
//---------------------------------------------------------------------------
void MSG_insertVar(int StreamNum, char * String)
{
  char * pPtr;
  char sVariable[256];

  if( StreamNum >= RCMD_VIRTSTREAM )
	  StreamNum = 65;

  //Parcourir la chaine, en cherchant les variables
  while( (pPtr = strchr(String, '%')) != NULL )
  {
    //-- Date actuelle '10-Oct-1997' --
    if( pPtr[1] == 'D' )
    {
      TOOLS_whatDate(sVariable);
    }
    //-- Date actuelle '10-Oct' --
    else if( pPtr[1] == 'd' )
    {
      TOOLS_whatDate(sVariable);
      //Virrer l'annee
      sVariable[6] = SNULL;
    }
    //-- Heure 14:15 --
    else if( pPtr[1] == 'H' )
    {
      TOOLS_whatTime( sVariable );

      //Insrer un ':' entre les heures et les minutes
      sVariable[5] = SNULL;
      sVariable[4] = sVariable[3];
      sVariable[3] = sVariable[2];
      sVariable[2] = ':';
    }
    //-- L'indicatif du serveur --
    else if( pPtr[1] == 'O' )
    {
      char sNodeCall[11];
      strcpy(sVariable, NODE_getNodeCall(0, 0, sNodeCall));
    }

    //-- L'indicatif du serveur SANS SSID --
    else if( pPtr[1] == 'o' )
    {
      char sNodeCall[11];
      strcpy(sVariable, NODE_getNodeCall(0, 0, sNodeCall));

      TOOLS_removeSsid(sVariable);
    }

    //-- Langue dfinie --
    else if( pPtr[1] == 'l' )
    {
      char sBuffer[256];
      /* Pour les remote commands */
      if( StreamNum >= 0 && StreamNum <= 65 )
      {
      	   strcpy(sVariable, LANG_getMessage(STREAMS_lang[StreamNum], LANGUAGE,
	   	 sBuffer));
      }
      else
      	   strcpy(sVariable, LANG_getMessage(1, LANGUAGE, sBuffer));
      	
      TOOLS_removeN(sVariable);
    }

    //-- Variables temporaires --
    else if( pPtr[1] >= '0' && pPtr[1] <= '9' )
    {
      int iTemp = atoi(pPtr+1);

      //Au cas ou %9 pointe sur un NULL ...
      if( MSG_pParams[9] == NULL )
	MSG_pParams[9] = MSG_pParams[1];

      if( iTemp >= 0 && iTemp <= 9 )
	strcpy(sVariable, MSG_pParams[iTemp]);

      //Convertir la commande en majuscule (les paramtres restent tels quels)
      if( iTemp == 0 )
	strupr(sVariable);
    }

    //-- Prnom de l'OM connect --
    else if( pPtr[1] == 'I' )
    {
      //Charger la config de l'utilisateur
      USERS_getRecord(StreamNum);
      strcpy(sVariable, pUser->sName);
    }

    //-- Numero du dernier message recu --
    else if( pPtr[1] == 'L' )
    {
      sprintf(sVariable, "%ld", MAIL_lastNum());
    }

    //-- Indicatif de l'OM connect --
    else if( pPtr[1] == 'U' )
    {
      strcpy(sVariable, STREAMS_callsign[StreamNum]);
    }

    //-- Indicatif de l'OM connect SANS SSID--
    else if( pPtr[1] == 'u' )
    {
      strcpy(sVariable, STREAMS_callsign[StreamNum]);

      TOOLS_removeSsid(sVariable);
    }

    //-- Date de la derniere connexion--
    else if( pPtr[1] == 'x' )
    {
	char szDate[16];
	char szTime[16];

	/* Charger la config de l'utilisateur */
	USERS_getRecord(StreamNum);

	/* Convertir et copier la date */
	TOOLS_dateTime_Long2Str(szDate, szTime, pUser->lLastConnect);
	strcpy(sVariable, szDate);
    }

    //-- Heure de la derniere connexion --
    else if( pPtr[1] == 'y' )
    {
	char szDate[16];
	char szTime[16];

	/* Charger la config de l'utilisateur */
	USERS_getRecord(StreamNum);

	/* Convertir et copier la date */
	TOOLS_dateTime_Long2Str(szDate, szTime, pUser->lLastConnect);
	strcpy(sVariable, szTime);
	sVariable[2] = ':';
	strcpy(sVariable + 3, szTime + 2);
    }

    //-- Dernier message liste par l'utilisateur --
    else if( pPtr[1] == 'Z' )
    {
      //Charger la config utilisateur
      USERS_getRecord(StreamNum);
      sprintf(sVariable, "%ld", pUser->lLastMsg);
    }

    //-- Inconnu --
    else
      strcpy(sVariable, " ");

    //-- Insrer la variable, en s'assurant que la longueur totale --
    //-- de la chaine n'excedera pas 255 caractres -------------------
    if( (strlen(String) + strlen(sVariable)) < 256 )
    {
      //inverser les deux chaines
      strrev( pPtr );
      strrev( sVariable );

      //ajouter  la suite
      String[ strlen(String) - 2] = SNULL;
      strcat(String, sVariable);

      //remettre dans l'ordre initial
      strrev( pPtr );
    }
  }
}

//---------------------------------------------------------------------------
//------ Rcuprer un message -----------------------------------------------
//---------------------------------------------------------------------------
//La liste des messages se trouve dans le fichier MESSAGE.H
char * MSG_get(int StreamNum, int Line, char * Buffer)
{
  //Lire le message (en faisant attention aux remote commands)
  if( StreamNum >= 0 && StreamNum <= 65 )
  	LANG_getMessage(STREAMS_lang[StreamNum], Line, Buffer);
else
  	LANG_getMessage(1, Line, Buffer);

  //Remplacer les variables
  MSG_insertVar(StreamNum, Buffer);

  //Retourner le pointeur
  return Buffer;
}
