#ifndef MEDIT_H
#define MEDIT_H

#include <dir.h>
extern "C" {
#include "memory.h"
}

typedef struct _MEDIT_DATA
{
	char     pszFileName[MAXPATH];
	mem_hand memHandle;
	int      nLineCount;
	int      nCurrentLine;
} MEDIT_DATA;

void MEDIT_init(void);
int  MEDIT_start(int StreamNum, char * pszFileName);
int  MEDIT_load(int StreamNum);
int  MEDIT_commands(int StreamNum, char * pszInput);
int  MEDIT_display(int StreamNum);
void MEDIT_prompt(int StreamNum);
void MEDIT_clean(int StreamNum);
void MEDIT_delete(int StreamNum, int nCount);
void MEDIT_replace(int StreamNum, char * pszString);
void MEDIT_insert(int StreamNum, char * pszString);
void MEDIT_insert2end(int StreamNum, char * pszString);
int  MEDIT_save(int StreamNum);
void MEDIT_help(int StreamNum);

#endif