#include <bios.h>
#include <alloc.h>
#include <process.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <conio.h>
#include <time.h>
#include <dos.h>
#include "define.h"
#include "display.h"
#include "keyboard.h"
#include "symbol.h"
#include "console.h"
#include "switch.h"
#include "buffers.h"
#include "main.h"
#include "language.h"
#include "commands.h"
#include "message.h"
#include "autoproc.h"
#include "streams.h"
#include "params.h"
#include "script.h"
#include "node.h"
#include "config.h"
#include "protocol.h"
#include "argv.h"
#include "tools.h"
#include "protocol.h"
#include "users.h"
#include "database.h"
#include "ping.h"
#include "log.h"
#include "term.h"
#include "spy.h"
#include "ltimeout.h"
#include "medit.h"
#include "fbbsrv.h"
#ifdef WIN32
#include "agw.h"
#endif

#ifdef DOS
extern "C" {
#include "com.h"
}
#include "dos.h"
#endif

//------ Augmentation de la taille de la pile -------------------------------
#ifdef DOS
extern unsigned _stklen = 16384U;
#endif

//------ Variables globales ------
time_t	MAIN_timeStart;
#ifdef DOS
int	MAIN_bpqBuffLeft = 0;
#endif

extern int FirstStream;		//Dfinie dans SWITCH.CPP
extern int LastStream;		//Dfinie dans SWITCH.CPP

extern	unsigned long COMMANDS_statut[MAX_STREAMS];

extern char STREAMS_callsign[MAX_STREAMS][10];	//Definie dans STREAMS.CPP
extern char	STREAMS_level[MAX_STREAMS];			//idem
extern char	PROTOCOL_linkType[65];				//Definie dans PROTOCOL.CPP
extern	int	SCRIPT_fromStream[MAX_STREAMS];		//Y compris la console (F2)
extern char SCRIPT_fileName[65][9];			//Limite a 8 caracteres (+NULL), l'extension .FWD tant ajout chaque fois
extern	int	SCRIPT_timer[65];
extern	int	COMMANDS_iExitCode;
extern  int	STREAMS_iDiddle[MAX_STREAMS];
extern	int	PARAMS_iDefaultDiddle;
extern	int	MAIL_nTimeOut[MAX_STREAMS];
extern	unsigned long 	MAIL_lFwdMsgNumber[MAX_STREAMS];
extern  int PARAMS_nIsMonitorOn;

//---------------------------------------------------------------------------
//------ Cette fonction est appellee avant de quitter DxNet -----------------
//---------------------------------------------------------------------------
void MAIN_ExitDxNet(void)
{
  //------ Terminer le programme ------
	SWITCH_exitPcFlex();	// Quitter le kernel PcFlex
#ifdef DOS
	CON_restoreMode();	// Restaurer l'ecran initial
	COM_setLocal();	// Deconnecter le port COM
#endif
	printf("DxNet terminated normally.\n");
}

//---------------------------------------------------------------------------
//------ gestion des evenements CONSOLE (clavier) ---------------------------
//---------------------------------------------------------------------------
//Avant d'appeler cette fonction, il est necessaire de s'assurer qu'une
//touche a bien ete frappee -bioskey(1)-
void MAIN_console(void)
{
  static char 	SysopInputStr[80];
  static int  	SysopInputPos = 0;
  static char 	SwitchInputStr[80];
  static int  	SwitchInputPos = 0;
  int  		RetChar;

  DISP_PutStat();

  switch( DISP_GetActiveScreen() )
  {
	case SCREEN2 :
	  RetChar = ScanKeyboard(SysopInputStr, SysopInputPos, 79);
	  //Le sysop a-t-il valid la saisie ?
	  if( RetChar == CR )
	  {
	    //ajouter la commande dans le buffer d'entree
	    BUFFERS_printBuff(BUFFER_SCREEN2, IN, "%s\r", SysopInputStr);

	    //reinitialiser les variables
	    SysopInputStr[0] = SNULL;
	    SysopInputPos    = 0;
	  }
#ifndef WIN32
	  DISP_PutsInputString(SCREEN2, SysopInputStr, SysopInputPos);
#endif
	break;

	case SCREEN3 :
	  RetChar = ScanKeyboard(SwitchInputStr, SwitchInputPos, 79);
	  //Le sysop a-t-il valid la saisie ?
	  if( RetChar == CR )
	  {
	    //envoyer la ligne au module de gestion du terminal
#ifdef DOS
	    TERM_put(SwitchInputStr);
#endif
	    //reinitialiser les variables
	    SwitchInputStr[0] = SNULL;
	    SwitchInputPos    = 0;
	  }
	  DISP_PutsInputString(SCREEN3, SwitchInputStr, SwitchInputPos);

	break;

	default :
	  RetChar = getkey();
  }

  switch( RetChar )
  {
	case PGUPKEY :
	  DISP_StatRowUp();
	  break;

	case PGDNKEY :
	  DISP_StatRowDown();
	  break;

	case F1 :
	  DISP_SetActiveScreen( SCREEN1 );
	  break;

	case F2 :
	  DISP_SetActiveScreen( SCREEN2 );
	  break;

	case F3 :
	  DISP_SetActiveScreen( SCREEN3 );
	  break;

	case F4 :
	  DISP_SetActiveScreen( SCREEN4 );
	  break;
   }/* End SWITCH */
}

//--------------------------------------------------------------------------
//------ LOOP - L'ensemble du fonctionnement de DxNet se passe ICI ---------
//--------------------------------------------------------------------------
void MAIN_loop(void)
{
	static int 	StreamNum;
	static int   	index;
	static int 	job = TRUE;
	static char	Buffer[16384];

	static int	Secondes = -1,
				OldSecondes = -1;

	static int	iBuffSize;

	static char ConnectedCall[11];

	/* Boucle Principale (repetee a l'infini) */
	for(;;)
	{
		/* Liberer du temps machine sous LINUX */
#ifndef DOS
		if( ! job )
		{
			/* Attendre un evenement */
			while( SWITCH_wait(10) == 0 && OldSecondes == TOOLS_whatSec() );
		}
#endif
		job = FALSE;

		/* Port redirige : y a t-il des caracteres */
#ifdef DOS
		if( COM_getRow(Buffer) )
		{
			int nConsole = COM_getConsoleNum();

			switch( nConsole )
			{
			case 2 : /* Console 2 */
				/* Executer la commande */
				CMD_execute(BUFFER_SCREEN2, Buffer);

				/* Afficher un echo sur la console */
				strcat(Buffer, "\n");
				if( Buffer[0] != 127 )	/* 127 : Id MACRO */
					DISP_PutsConsole(SCREEN2, Buffer, COLOR_IN);
				break;

			case 3 : /* console 3 (terminal) */
				/* Executer la commande */
				TERM_put(Buffer);
				break;
			}
		}
#endif

		for(StreamNum = FirstStream; StreamNum <= LastStream; StreamNum++)
		{
			/* ------ Gerer les evenements console --------------------------------- */

			/* Detecter l'appuis sur une touche */
			if( bioskey(1) )
			{
				MAIN_console();
				job = TRUE;
			}

			/* Y a t-il une commande a xcuter pour la fenetre PROGRAM (F1) ? */
			if( BUFFERS_getRow(BUFFER_SCREEN1, Buffer, IN) )
			{
				CMD_execute(BUFFER_SCREEN1, Buffer);		//Executer la commande
				strcat(Buffer, "\n");				//Retour charriot
				if( Buffer[0] != 127 )	/* 127 : Id MACRO */
					DISP_PutsConsole(SCREEN1, Buffer, COLOR_IN);	//Afficher un echo de la commande sur l'cran
				job = TRUE;
			}

			//Y a t-il quelque chose  afficher dans la fentre PROGRAM (F1) ?
			if( BUFFERS_getBloc(BUFFER_SCREEN1, Buffer, OUT) )
			{
				DISP_PutsConsole(SCREEN1, Buffer, COLOR_OUT);
				job = TRUE;
			}

			/* Y a t-il une commande a executer pour la fenetre CONSOLE (F2) ? */
			if( BUFFERS_getRow(BUFFER_SCREEN2, Buffer, IN) )
			{
				CMD_execute(BUFFER_SCREEN2, Buffer);		//Executer la commande
				strcat(Buffer, "\n");				//Retour charriot
				if( Buffer[0] != 127 )	/* 127 : Id MACRO */
					DISP_PutsConsole(SCREEN2, Buffer, COLOR_IN);	//Afficher un echo de la commande sur l'cran
				job = TRUE;
			}

			/* Y a t-il quelque chose a afficher dans la fenetre CONSOLE (F2) ? */
			if( BUFFERS_getBloc(BUFFER_SCREEN2, Buffer, OUT) )
			{
				DISP_PutsConsole(SCREEN2, Buffer, COLOR_OUT);

				/* Port redirige ? */
#ifdef DOS
				if( COM_getConsoleNum() == 2 )
					COM_puts(Buffer);
#endif
				job = TRUE;
			}

			/* Gerer les evenements utilisateurs */
			/* Si le Stream est connecte, traiter les buffers IN et OUT */

			/* Y a t-il des caracteres en attente dans le SWITCH pour ce stream ? */
			iBuffSize = SWITCH_getFrame(StreamNum, Buffer);
			if( iBuffSize )
			{
				/* Peut-etre est-ce pour le terminal (version DOS uniquement) */
#ifdef DOS
				if( StreamNum == TERM_conStream() )
				{
					TOOLS_R2N(Buffer);
					/* Placer une SNULL a la fin de la chaine (car la fonction 
					  SWITCH ne le retourne pas */
					Buffer[iBuffSize] = SNULL;
					DISP_PutsConsole(SCREEN3, Buffer, COLOR_OUT);
				}
				else
					BUFFERS_addBuff_sized(StreamNum, Buffer, IN, iBuffSize);
#else
				BUFFERS_addBuff_sized(StreamNum, Buffer, IN, iBuffSize);
#endif
				job = TRUE;
			}

			/* Y a t-il une commande a executer dans le stream ? */
			if( BUFFERS_getRow(StreamNum, Buffer, IN) )
			{
				/* Aiguillage */
				if( STREAMS_level[StreamNum] & LEVEL_user )				/* Utilisateur */
					CMD_execute(StreamNum, Buffer);
				else if( STREAMS_level[StreamNum] & LEVEL_linkSetup )	/* Link Setup */
					SCRIPT_do(StreamNum, Buffer);
				else if( STREAMS_level[StreamNum] & LEVEL_cluster )     /* Cluster */
				{
					/* Si le protocol est un CluLink, ajouter un '\n' a la fin
					de la la chaine, car ce caractere n'est pas envoye a 
					l'emission */
					PROTOCOL_do(StreamNum, Buffer);

					/* Reset du link timeout */
					LTIMEOUT_reset(StreamNum);
				}
				job = TRUE;
			}

			/* Y a t-il quelque chose en attente a envoyer au switch ? */
#ifndef DOS
			iBuffSize = BUFFERS_getBloc(StreamNum, Buffer, OUT);
#else
			if( SWITCH_getUnack(StreamNum) < 8 )
				iBuffSize = BUFFERS_getBloc(StreamNum, Buffer, OUT);
			else
				iBuffSize = 0;
#endif

			if( iBuffSize )
			{
				/* Remplacer les '\n' par des '\r' sauf s'il s'agit d'une trame
				   CluLink */
				if( PROTOCOL_linkType[StreamNum] != CLU_LINK )
					TOOLS_N2R(Buffer);

				SWITCH_sendFrame(StreamNum, Buffer, iBuffSize);

				/* Initialiser la variable Diddle (sauf si c'est un cluster) */
				if( ! (STREAMS_level[StreamNum] & LEVEL_cluster) )
					STREAMS_iDiddle[StreamNum] = PARAMS_iDefaultDiddle;

				job = TRUE;
			}

			/* Nouvel evenement sur le Stream ? */
			switch( SWITCH_getStatut(StreamNum) )
			{
			case NONE :
				/* Donc ne fait rien */
				break;

			case CONNECTED :
				/* Qui a connecte le SWITCH ? */
				SWITCH_getCall(StreamNum, ConnectedCall);
				STREAMS_connect(StreamNum, ConnectedCall);
				job = TRUE;
				break;

			case DISCONNECTED :
#ifdef DOS
				if( StreamNum == TERM_conStream() )
					TERM_disconnect();
				else
					STREAMS_disconnect(StreamNum);
#else
				/* Verifier si un indicatif est connu */
				STREAMS_disconnect(StreamNum);
#endif
				job = TRUE;
				break;
			}

			/* Afficher le monitoring (DOS) */
			if( PARAMS_nIsMonitorOn && SWITCH_rawRx(1, Buffer) )
			{
#ifdef DOS
				/*Gestion des spy*/
				SPY_frame (Buffer);
#endif
				DISP_PutsConsole(MONITOR, Buffer, OUT);
				job = TRUE;
			}

			/* Faut-il deconnecter le stream ? */
			if( COMMANDS_statut[StreamNum] & COMMANDS_statutDisconnect )
			{
				/* Deconnecter si toutes les trames en attente ont ete ACKed */
				if( SWITCH_getUnack(StreamNum) == 0 )
				{
					SWITCH_discSwitch( StreamNum );

					/* Pour que le stream puisse etre a nouveau connecte ... */
					COMMANDS_statut[StreamNum] = COMMANDS_statutInit;
					job = TRUE;
				}
			}

			/* Faudra t-il deconnecter ce stream lors de la prochaine boucle ? */
			if( COMMANDS_statut[StreamNum] & COMMANDS_statutWillDisconnect )
			{
				COMMANDS_statut[StreamNum] &= ~COMMANDS_statutWillDisconnect;
				COMMANDS_statut[StreamNum] |= COMMANDS_statutDisconnect;
			}

			/*  ShutDown ? */
			if( COMMANDS_statut[0] & COMMANDS_statutShutDown )
			{
				int iCanDo = TRUE;
				job = TRUE;

				/* Ballayer les streams */
				for(index = FirstStream; index <= LastStream; index++)
				{
					/* Le stream est-il tjrs connecte ? */
					if( SWITCH_conStat(index) )
					{
						iCanDo = FALSE;
						job    = FALSE; 
						break;
					}
				}

				/* Si un stream est tjrs connecte -> ne pas quitter */
				if( iCanDo == TRUE )
				{
					if( COMMANDS_iExitCode )
						exit( COMMANDS_iExitCode );
					else
						exit(EXIT_SUCCESS);
				}
			}

			/*  Seconde ? */
			Secondes = TOOLS_whatSec();

			/* La seconde a t-elle changee depuis la derniere fois ? */
			if( Secondes != OldSecondes )
			{
#ifdef DOS
				/* gestion des buffers sous BPQ */
				if( (Secondes % 10 == 0 ) && MAIN_bpqBuffLeft > 0 && ! SWITCH_isPcFlexNet())
				{
					if( SWITCH_getBufferLeft() < MAIN_bpqBuffLeft )
						exit(9);
				}
#endif

#ifdef WIN32
				/* sortir du mode idle de AGW (si besoin) */
				if( Secondes == 0 || Secondes == 30 )
					AGW_goOutOfIdleState();
#endif
				/* Afficher la barre de statut */
				DISP_PutStat();

				/* Lancement des process automatiques - Declanchements aux
				   secondes rondes (ou a la prochaine seconde qui suit
				   un passage a zero en cas de depassement) */
				if( Secondes < OldSecondes )
					AUTOPROC_do();

				/* Timeout des scripts de connexion 
				   ansi que le Diddle */
				for(index = FirstStream; index <= LastStream; index++)
				{
					if( STREAMS_level[index] & LEVEL_linkSetup )
					{
						if( --SCRIPT_timer[index] <= 0 )	/* Timeout ? */
						{
							BUFFERS_printBuff(SCRIPT_fromStream[index], OUT, "*** Link setup timeout with %s on stream %d.\n", SCRIPT_fileName[index], index);
							MSG_send(SCRIPT_fromStream[index], MSG1);
							SWITCH_discSwitch(index);
							STREAMS_disconnect(index);
						}
					}
					else if( STREAMS_level[index] ) /* Seulement s'il y a quelqu'un de connecte */
					{
						if( (STREAMS_level[index] & LEVEL_cluster) )
						{
							int  nLTimeout;

							/* Link timeout (cluster) */
							nLTimeout = LTIMEOUT_inc(index);

							switch(nLTimeout)
							{
							case LTIMEOUT_PING :
							{
								char szBuffer[128];
								char szClusterCall[16];
			
								NODE_getNodeCall(index, 0, szClusterCall);

								/* transmetre un PING */
								sprintf(szBuffer, "ping %s", szClusterCall);
								CMD_execute(0, szBuffer);
							}
								break;

							case LTIMEOUT_DISCONNECT :
								/* deconnecter */
								BUFFERS_printBuff(0, OUT,
									"*** Link timeout with %s on stream %d.\n",
								STREAMS_callsign[index], index);
								SWITCH_discSwitch(index);
								STREAMS_disconnect(index);
								break;

							default:
								/* ex : LTIMEOUT_OK */
								break;
							}

							/* Forward timeout ? */
							if( MAIL_lFwdMsgNumber[index] && --MAIL_nTimeOut[index] <= 0 )
							{
								/* OUI */
								MAIL_lFwdMsgNumber[index] = 0L;
								PROTOCOL_abortForwarding(index);
							}
						}

						if( STREAMS_iDiddle[index] != -1 && STREAMS_level[index] != LEVEL_term )	/* -1 signifie que la commande est sur off */
						{
							if( --STREAMS_iDiddle[index] <= 0 )	/* Faut-il envoyer un diddle packet ? */
							{
								/* Oui, et il faut aussi reinitialiser la variable diddle */
								if( STREAMS_level[index] & LEVEL_cluster )
								{
									char sNodeCall[16];
									/* Call du cluster */
									NODE_getNodeCall(0, 0, sNodeCall);
									PROTOCOL_userCount(index, sNodeCall, FALSE, 0, 100);
									STREAMS_iDiddle[index] = 900;		/*15 minutes*/
								}
								else
								{
									MSG_send(index, MSG41);	/* transmettre le diddle */
									STREAMS_iDiddle[index] = PARAMS_iDefaultDiddle;
								}
							}
						}
					}
				}
				/* Actualiser */
				OldSecondes = Secondes;
			}
		} 
	}
}

//--------------------------------------------------------------------------
//------ Fonction principale -----------------------------------------------
//--------------------------------------------------------------------------
int main(int Argc, char * Argv[])
{
	int 	_FirstStream 	= 1;
	int 	_LastStream 	= 64;
	int 	_ApplMask 	= 1;
	int 	iScreenSize;
#ifndef DOS
	int   port;
#endif
#ifdef WIN32
	char AGW_szHostAddr[256];
	int  AGW_nPort;	
#endif

	extern int PROTOCOL_nFixedInit;

	printf("DxNet started.\n");

	/* Convertir le fichier users.bin vers usercfg.bin */
	/************************************************************************/
	/******* Cette partie sera a virrer a partir de la revision 3.6 *********/
	/************************************************************************/
	FILE * fptr_old;
	FILE * fptr_new;
#ifdef LINUX
	char * pszOldFileName = "system/bin/users.bin";
#else
	char * pszOldFileName = "system\\bin\\users.bin";
#endif
	if( (fptr_old = fopen(pszOldFileName, "rb")) != NULL )
	{
		tUser_old    user_old;
		tUser	     user_new;

		printf("Converting old users.bin to the new format in userscfg.bin ...\n");
		fptr_new = fopen(USERS_FILE, "wb");
		if( ! fptr_new )
		{
			printf("Unable to create 'system\\bin\\userscfg.bin'");
			exit(0);
		}

		while(fread(&user_old, sizeof user_old, 1, fptr_old) == 1 )
		{
			memset(&user_new, sizeof user_new, 0);
			memcpy(&user_new, &user_old, sizeof user_old);
			user_new.lBandsOff = 0L;
			fwrite(&user_new, sizeof user_new, 1, fptr_new);
		}

		fclose(fptr_old);
		fclose(fptr_new);

		/* Creer un .bak de l'ancien fichier et effacer */
		TOOLS_makeBak(pszOldFileName);
		unlink(pszOldFileName);
	}

	//------ Lecture des Arguments ------
	_FirstStream = ARGV_get(Argc, Argv, "-fs");
	if( _FirstStream == -1 )
		_FirstStream = 1;

	_LastStream = ARGV_get(Argc, Argv, "-ls");
	if( _LastStream == -1 )
		_LastStream = 64;

	_ApplMask = ARGV_get(Argc, Argv, "-appl");
	if( _ApplMask == -1 )
		_ApplMask = 1;

	iScreenSize = ARGV_get(Argc, Argv, "-s");
	if( iScreenSize != 43 && iScreenSize != 50 )
		iScreenSize = 25;

	if( ARGV_get(Argc, Argv, "-moff") != -1 )
		PARAMS_nIsMonitorOn = FALSE;

	if( ARGV_get(Argc, Argv, "-noinit") != -1 )
		PROTOCOL_nFixedInit = FALSE;

#ifndef DOS
	/* Specifique a linux et a windows */
	if( (port = ARGV_get(Argc, Argv, "-p")) == -1 )
		port = 3287;
#endif

#ifdef DOS
	/* Specifique a DOS */
	MAIN_bpqBuffLeft = ARGV_get(Argc, Argv, "-bpql");
#endif

#ifdef WIN32
	char szBuffer[256];
	/* HostAddr et portnum pour le AGW pe */
	if( ARGV_getStr(Argc, Argv, "-agw=", szBuffer) )
	{
		char* token;
		int   index = 0;

		AGW_nPort = 8000;	/* valeur par defaut */
		token = strtok(szBuffer, " :");
		while(token)
		{
			switch(index++)
			{
			case 0 :
				strcpy(AGW_szHostAddr, token);
				break;
			case 1 :
				AGW_nPort = atoi(token);
				break;
			default :
				break;
			}
			token = strtok(NULL, " :");
		}
	}
	else
	{
		strcpy(AGW_szHostAddr, "127.0.0.1");
		AGW_nPort = 8000;
	}

	printf("AGWpe : %s:%d\n", AGW_szHostAddr, AGW_nPort);
#endif

	//------ Initialiser la table des streams ------
	BUFFERS_init();

	//------ Initialiser le SWITCH packet ------
	if( ! SWITCH_initSwitch(_FirstStream, _LastStream, _ApplMask) )
	{
#ifdef DOS
		printf("*** Error : can't find either G8BPQ switch nor PcFlexNet kernel.\n");
#endif
		exit(EXIT_FAILURE);
	}

#ifdef WIN32
	if( ! AGW_connectPE(AGW_szHostAddr, AGW_nPort) )
		printf("SV2AGW packet engine not found : program enters idled mode\n");
#endif
  
  /* Initialition du serveur console */
#ifndef DOS
	if( FBBSRV_initOrb(port) == 0 )
  		exit(EXIT_FAILURE);
#endif

	//------ Initialiser la table des langues et des Helps ------
	LANG_init();

	//------ Initialiser les databases --------------------------
	DATABASE_init();

	printf("Starting DxNet...\n");
	delay(1000);

	//------ Initialiser les crans ------
	DISP_InitDisplay( iScreenSize );

	//------ Initialiser les paramtres du serveur ------
	if( ! USERS_init() )
	{
		printf("*** Error : not enough memory to allocate the users buffers.\n");
		exit(EXIT_FAILURE);
	}
	PARAMS_init();
	STREAMS_init();
	SCRIPT_init();
	NODE_init();
	COMMANDS_init();
	PING_init();
	MEDIT_init();
#ifdef DOS
	TERM_init();
	DOS_init();
#endif

	//------ Heure du lancement de DxNet ------
	MAIN_timeStart = time(NULL);

	//------ Lire le fichier de configuration (SYSTEM\DXNET.CFG) ------
	CONFIG_init();
  
	//------ Lancer DxNet ------
	atexit( MAIN_ExitDxNet );
	MAIN_loop();

	return 0;
}
