#include <alloc.h>
#include "ltimeout.h"
#include "define.h"

static int LTIMEOUT_nTotal[MAX_STREAMS];
static int LTIMEOUT_nBeforePing[MAX_STREAMS];
static int LTIMEOUT_nCounter[MAX_STREAMS];

/*------------------------------------------------------------------------
  ------ Initialisation --------------------------------------------------
  ------------------------------------------------------------------------*/
void LTIMEOUT_init(int StreamNum)
{
	LTIMEOUT_nTotal[StreamNum]      = -1;
	LTIMEOUT_nBeforePing[StreamNum] = -1;
}

/*------------------------------------------------------------------------
  ------ Definition pour un link -----------------------------------------
  ------------------------------------------------------------------------*/
void LTIMEOUT_set(int StreamNum, int nTotal, int nBeforePing)
{
	LTIMEOUT_nTotal[StreamNum]      = nTotal;
	LTIMEOUT_nBeforePing[StreamNum] = nBeforePing;
	LTIMEOUT_nCounter[StreamNum]    = 0;
}

/*------------------------------------------------------------------------
  ------ Incremente le compteur de 1 seconde -----------------------------
  ------------------------------------------------------------------------
  Retour : LTIMEOUT_OK         -> n'a rien a faire
	   LTIMEOUT_PING       -> il faut envoyer un ping
	   LTIMEOUT_DISCONNECT -> il faut deconnecter                     */
int LTIMEOUT_inc(int StreamNum)
{
	extern char STREAMS_level[MAX_STREAMS];

	if( ! (STREAMS_level[StreamNum] & LEVEL_cluster ) )
        	return LTIMEOUT_OK;

	if( LTIMEOUT_nTotal[StreamNum] == -1 )
		return LTIMEOUT_OK;

	if( ++LTIMEOUT_nCounter[StreamNum] == LTIMEOUT_nBeforePing[StreamNum] )
		return LTIMEOUT_PING;
	else if( LTIMEOUT_nCounter[StreamNum] >= LTIMEOUT_nTotal[StreamNum] )
		return LTIMEOUT_DISCONNECT;

	return LTIMEOUT_OK;
}

/*------------------------------------------------------------------------
  ------ Reset du compteur -----------------------------------------------
  ------------------------------------------------------------------------*/
void LTIMEOUT_reset(int StreamNum)
{
	LTIMEOUT_nCounter[StreamNum] = 0;
}

