#include <alloc.h>
#include <stdio.h>
#include <stdarg.h>
#include <dir.h>
#include <string.h>
#include "define.h"
#include "log.h"
#include "tools.h"

/* Ces fonctions enregistrent un log des activites du serveur              */

//---------------------------------------------------------------------------
//------ LOG_write ----------------------------------------------------------
//---------------------------------------------------------------------------
//La fonction retourne TRUE si le log a pu etre enregistre, et FALSE sinon
int LOG_write(char * FileName, int Date, char * String, ...)
{
  va_list     	args;
  char 		sBuf[512];
  char		sDate[15];
  char		sTime[10];
  char		sFileName[MAXPATH];

  FILE	     *fPtr;

  //Lire les arguments
  va_start(args, String);
  vsprintf(sBuf, String, args);
  va_end(args);

  //Preparer le nom de fichier
  sprintf(sFileName, "%s%02d%02d.log", FileName, TOOLS_whatYear(), TOOLS_whatMonth());

  //Ouvrir le fichier en ajout
  fPtr = fopen(sFileName, "at");

  if( ! fPtr )
  {
    perror("fopen in LOG_write");
    return FALSE;	//Le fichier n'a pas pu etre ouvert
  }

  //Ecriture de la chaine
  if( Date == LOG_DATE_YES )	//Faut-il dater l'info ?
    fprintf(fPtr, "%s <%sZ> : ", TOOLS_whatDate(sDate), TOOLS_whatTime(sTime));

  fputs(sBuf, fPtr);

  //Fermeture du fichier et retour
  fclose (fPtr);
  return TRUE;
}

//--------------------------------------------------------------------------
//------ Enregistrer l'heure dans un fichier -------------------------------
//--------------------------------------------------------------------------
//Cette fonction est utilisee sous DOS pour connaitre l'heure d'un plantage
#ifdef DEBUG_LOG_
void LOG_saveTime(void)
{
  FILE *fPtr;

  fPtr = fopen(LOG_TIME_FILE, "wt");

  if( ! fPtr )
  {
    perror("fopen in LOG_saveTime");
    return;	//PB ouverture du fichier
  }

  fprintf(fPtr, "%04d%02d", TOOLS_whatTime(), TOOLS_whatSec());

  fclose (fPtr);
}
#endif

//--------------------------------------------------------------------------
//------ Enregistrer un marqueur pour indiquer ou en est le programme ------
//--------------------------------------------------------------------------
#ifdef DEBUG_MARK_
void LOG_saveMarker(char * String)
{
  FILE *fPtr;

  fPtr = fopen(LOG_MARKER_FILE, "wt");

  if( ! fPtr )
  {
    perror("fopen in LOG_saveMarker");
    return;   	//PB ouverture du fichier
  }

  fputs(String, fPtr);

  fclose (fPtr);
}
#endif