#include <alloc.h>
#include <math.h>
#include <stdio.h>
#include <stdlib.h>
#include "tools.h"
#include "locator.h"
#include "define.h"


/* Constantes */
#define PI 3.141592654
#define P  40076.59
#define K  (PI/180)
#define L  (180/PI)
#define M  (PI/2)

/* Variables globales */
double m_d, m_ad;

/*-------------------------------------------------------------------------
  ------ Verifier la valmidite d'un locator WW ----------------------------
  -------------------------------------------------------------------------*/
int LOCATOR_isValidWW(char * szLocator)
{
  /* Verification de la validite du locator */
  if(szLocator[0] < 'A' || szLocator[0] > 'Z' || szLocator[1] < 'A' || szLocator[1] > 'Z')
    return FALSE;

  if(szLocator[2] < '0' || szLocator[2] > '9' || szLocator[3] < '0' || szLocator[3] > '9')
    return FALSE;

  if(szLocator[4] < 'A' || szLocator[4] > 'X' || szLocator[5] < 'A' || szLocator[5] > 'X')
    return FALSE;

  return TRUE;	/* Semble OK */
}

/*-------------------------------------------------------------------------
  ------ Conversion d'un locator WW vers latitude/longitude ---------------
  -------------------------------------------------------------------------
  pszLocator  : locator a convertir
  coordinates : retour (coordonnees)                                       */

void LOCATOR_locator2coordinates(char * pszLocator, LOCATOR_COORDINATES * coordinates)
{
	/* Calculs des coordonnees en degres */
	coordinates->doLong = (pszLocator[0] - 65) * 20 - 180     +
			      (pszLocator[2] - 48) * 2            +
			      (pszLocator[4] - 65) * 0.0833333333 +
						     0.0416666666;

	coordinates->doLat  = (pszLocator[1] - 65) * 10 - 90      +
			      (pszLocator[3] - 48)                +
			      (pszLocator[5] - 65) * 0.0416666666 +
						     0.0208333333;
}

/*-------------------------------------------------------------------------
  ------ Conversion d'un locator WW vers latitude/longitude (pavillon) ----
  -------------------------------------------------------------------------
  pszLocator     : locator a convertir
  pavCoordinates : retour (coordonnees)                                    */

void LOCATOR_locator2pavCoordinates(char * pszLocator, LOCATOR_PAVCOORDINATES * pavCoordinates)
{
	LOCATOR_COORDINATES coordinates;

	LOCATOR_locator2coordinates(pszLocator, &coordinates);
	LOCATOR_coordinates2pavillon(coordinates, pavCoordinates);
}

/*-------------------------------------------------------------------------
  ------ Conversion latitude/longitude vers locator WW --------------------
  -------------------------------------------------------------------------*/
char * LOCATOR_coordinates2locator(LOCATOR_COORDINATES coordinates, char * pszLocator)
{
	double e;
	double n;

	/* Longitude */
	e = coordinates.doLong + 180;

	pszLocator[0] = (char) (e / 20);
	e = e - 20 * (double) pszLocator[0];
	pszLocator[0] += 65;

	pszLocator[2] = (char) (e / 2);
	e = e - 2 * (double) pszLocator[2];
	pszLocator[2] += 48;

	pszLocator[4] = (char) (e * 60.0) / 5;
	pszLocator[4] += 65;

	/* Latitude */
	n = coordinates.doLat + 90;

	pszLocator[1] = (char) (n / 10);
	n = n - 10 * (double) pszLocator[1];
	pszLocator[1] += 65;

	pszLocator[3] = (char) n;
	n = n - (double) pszLocator[3];
	pszLocator[3] += 48;

	pszLocator[5] = (char) (n * 120.0) / 5;
	pszLocator[5] += 65;

	/* SNULL de fin de chaine */
	pszLocator[6] = SNULL;

	return pszLocator;
}

/*-------------------------------------------------------------------------
  ------ Conversion latitude/longitude (pavillon) vers locator WW ---------
  -------------------------------------------------------------------------*/
char * LOCATOR_pavCoordinates2locator(LOCATOR_PAVCOORDINATES pavCoordinates, char * pszLocator)
{
	LOCATOR_COORDINATES coordinates;

	/* Conversion */
	LOCATOR_pavillon2coordinates(pavCoordinates, &coordinates);

	/* Calcul ... */
	return LOCATOR_coordinates2locator(coordinates, pszLocator);
}

/*-------------------------------------------------------------------------
  --- Conversion latitude/longitude (PROTOCOLE pavillon) vers locator WW --
  -------------------------------------------------------------------------*/
/* Retourne TRUE si OK et FALSE sinon */
int LOCATOR_pavStr2locator(char * pszPavString, char * pszLocator)
{
	char arg[6][256];
	LOCATOR_PAVCOORDINATES pavCoordinates;

	/* Lire les infos */
	if( sscanf(pszPavString, "%s %s %s %s %s %s", arg[0], arg[1],
	    arg[2], arg[3], arg[4], arg[5]) != 6 )
	{
		/* Probleme sur le nombre d'arguments */
		return FALSE;
	}

	pavCoordinates.nLatDegrees  = atoi(arg[0]);
	pavCoordinates.nLatMinutes  = atoi(arg[1]);
	pavCoordinates.nLatN        = (*arg[2] == 'N' ? TRUE : FALSE);
	pavCoordinates.nLongDegrees = atoi(arg[3]);
	pavCoordinates.nLongMinutes = atoi(arg[4]);
	pavCoordinates.nLongE       = (*arg[5] == 'E' ? TRUE : FALSE);

	/* Convertir en locator */
	LOCATOR_pavCoordinates2locator(pavCoordinates, pszLocator);

	return TRUE;
}

/*-------------------------------------------------------------------------
  ------ Convertir lat/long vers le format pavillon -----------------------
  -------------------------------------------------------------------------
  coordinates    : coordonnees a convertir
  pavCoordinates : retour (coordonnees)                                    */

void LOCATOR_coordinates2pavillon(LOCATOR_COORDINATES coordinates, LOCATOR_PAVCOORDINATES * pavCoordinates)
{
	/* Longitude : E / W ? */
	if( coordinates.doLong < 0 )
	{
		pavCoordinates->nLongE = FALSE;
		coordinates.doLong = -coordinates.doLong;
	}
	else
		pavCoordinates->nLongE = TRUE;

	/* Longitude : Degres */
	pavCoordinates->nLongDegrees = (int) coordinates.doLong;
	coordinates.doLong -= pavCoordinates->nLongDegrees;
	coordinates.doLong *= 60;

	/* Longitude : Minutes */
	pavCoordinates->nLongMinutes = (int) coordinates.doLong;
	coordinates.doLong -= pavCoordinates->nLongMinutes;
//	coordinates.doLong *= 60;

	/* Latitude : E / W ? */
	if( coordinates.doLat < 0 )
	{
		pavCoordinates->nLatN = FALSE;
		coordinates.doLat = -coordinates.doLat;
	}
	else
		pavCoordinates->nLatN = TRUE;

	/* Latitude : Degres */
	pavCoordinates->nLatDegrees = (int) coordinates.doLat;
	coordinates.doLat -= pavCoordinates->nLatDegrees;
	coordinates.doLat *= 60;

	/* Latitude : Minutes */
	pavCoordinates->nLatMinutes = (int) coordinates.doLat;
	coordinates.doLat -= pavCoordinates->nLatMinutes;
//	coordinates.doLat *= 60;
}

/*-------------------------------------------------------------------------
  ------ Convertir le format pavillon vers Lat/long -----------------------
  -------------------------------------------------------------------------*/
void LOCATOR_pavillon2coordinates(LOCATOR_PAVCOORDINATES pavCoordinates, LOCATOR_COORDINATES * coordinates)
{
	/* Longitude */
	coordinates->doLong = (double) pavCoordinates.nLongDegrees  +
			      (double) pavCoordinates.nLongMinutes  / 60.0;

	if( pavCoordinates.nLongE == FALSE )
		coordinates->doLong = -coordinates->doLong;

	/* Latitude */
	coordinates->doLat  = (double) pavCoordinates.nLatDegrees  +
			      (double) pavCoordinates.nLatMinutes  / 60.0;

	if( pavCoordinates.nLatN == FALSE )
		coordinates->doLat = -coordinates->doLat;
}


/*-------------------------------------------------------------------------
  ------ Calcul de la distance --------------------------------------------
  -------------------------------------------------------------------------*/
int LOCATOR_distance(LOCATOR_COORDINATES tFrom, LOCATOR_COORDINATES tTo)
{
	double	z;
	double	cos_d, cos_ad;
	double	distance;

	/* Conversions en radians (C calcule, par defaut, en radians) */
	tFrom.doLat  *= K;
	tFrom.doLong *= K;
	tTo.doLat    *= K;
	tTo.doLong   *= K;

	z = tTo.doLong - tFrom.doLong;

	cos_d  = cos(z) * cos(tFrom.doLat) * cos(tTo.doLat) +
		     sin(tFrom.doLat) * sin(tTo.doLat);
	cos_ad = cos(z) * cos(tFrom.doLat) * cos(tTo.doLat + 0.000150) +
		     sin(tFrom.doLat) * sin(tTo.doLat + 0.000150);

	m_d  = acos (cos_d);
	m_ad = acos (cos_ad);

	distance  = m_d * L;			/* Conv radians -> degres */
	distance *= 111.200000;
	distance  = floor( distance + 0.5);	/* On arrondit */

	return (int) distance;
}

/*-------------------------------------------------------------------------
  ------ Calcul de l'azimut -----------------------------------------------
  -------------------------------------------------------------------------*/
/* IMPERATIF : il faut d'abord appeler la fonction LOCATOR_distance */
int LOCATOR_azimut(LOCATOR_COORDINATES tFrom, LOCATOR_COORDINATES tTo)
{
	double z;
	double sin_a, sin_ap;
	double azimut, azimut_p;

	/* Conversions en radians (C calcule, par defaut, en radians) */
	tFrom.doLat  *= K;
	tFrom.doLong *= K;
	tTo.doLat    *= K;
	tTo.doLong   *= K;

	/* Coordonnees identique ? repondre que Az = 0 */
	if( tFrom.doLat == tTo.doLat && tFrom.doLong == tTo.doLong )
		return 0;

	z = tTo.doLong - tFrom.doLong;

	sin_a    = sin(z) * cos(tTo.doLat) / sin(m_d);
	sin_ap   = sin(z) * cos(tTo.doLat + 0.000150) / sin(m_ad);
	azimut   = asin(sin_a);
	azimut_p = asin(sin_ap);
	azimut   *= L; /* Conv radians -> degres */
	azimut_p *= L; /* Id */

	/* Test d'ambiguite de cadran */
	if( fabs(azimut_p) > fabs(azimut) )
	{
		if( azimut > 0)
			azimut = 180 - azimut;
		else
			azimut = -(azimut + 180);
	}

	/* Si azimut = 180 pile poil */
	if( (azimut == 0.0) && (tTo.doLat < tFrom.doLat) )
	{
		if( azimut > 0)
			azimut = 180 - azimut;
		else
			azimut = -(azimut + 180);
	}

	if( azimut < 0)
		azimut += 360;

	azimut = floor (azimut + 0.5); /* On arrondit et on prend la val. abs. */

	return (int) azimut;
}

