#include <alloc.h>
#include <stdio.h>
#include <stdlib.h>
#include <dir.h>
#include <string.h>
#include <conio.h>
#include <dos.h>
#include "language.h"
#include "define.h"
#include "mill.h"
#include "tools.h"
extern "C" {
#include "memory.h"
}

//--------------------------------------------------------------------------
//------ Variables globales ------------------------------------------------
//--------------------------------------------------------------------------
mem_hand LangHandle[MAX_LANG];		//Maximum de MAX_LANG (normallement 10) langues alloues
char	 LANG_file[MAX_LANG][81];       //Nom de fichiers LANG - 80 caractres au maximum pour chauqe nom de fichier

//--------------------------------------------------------------------------
//------ Initialisation des messages courants ------------------------------
//--------------------------------------------------------------------------
void LANG_init(void)
{
  int 	index;
  int	Done = FALSE;
  char 	FileName[MAXPATH];
  char 	Line[LANG_LINE_SIZE+1];
  char 	Buffer[LANG_LINE_SIZE+1];
  int	Msg;
  int   PosX, PosY;
  FILE *fPtr;

  //Dfinir la stratgie d'allocation (la mmoire conventionnelle n'est jamais utilise)
  setXMstrat("XEV");

  //Ouvrir le fichier de configuration, et le lire
  fPtr = fopen(LANGUAGE_CFG_FILE, "rt");
  if( ! fPtr )
  {
    perror("fopen in LANG_init");
    return;	//Fichier absent ou PB d'ouverture
  }

  //Initialiser le tableau des fichiers language
  for(index = 0; index < MAX_LANG; index++)
    *LANG_file[index] = SNULL;

  //Lire le fichier de config des langues
  for(index = 0; index < MAX_LANG; index++)
  {
    //Lire un ligne ...
    if( ! fgets(Line, 255, fPtr) )
      break;

    //Pas plus de 80 caracteres sous linux, et 8 sous DOS et virrer les CRLF
#ifdef DOS
    TOOLS_maxLength(Line, 8);
#else
    TOOLS_maxLength(Line, 80);
#endif
    TOOLS_removeNR(Line);

    //Sortir si la ligne est vide ...
    if( *Line == SNULL )
      break;

    strcpy(LANG_file[index], Line);
  }/*End FOR*/

  fclose( fPtr );

  //Dclarer les buffers, les initialiser et les charger
  for(index = 0; index < MAX_LANG; index++)
  {
//    sprintf(FileName, "%slang%d.txt", LANGUAGE_PATH, index + 1);
    sprintf(FileName, "%s%s.txt", LANGUAGE_PATH, LANG_file[index]);
    Done = FALSE;

    //------ Tenter d'ouvrir le fichier ------
    fPtr = fopen(FileName, "rt");
    if( ! fPtr )
      return;

    //Rserver la mmoire
    LangHandle[index] = xalloc(LANG_LINE_SIZE, LANG_MAX_LINE);

    if( LangHandle[index] ) //Le buffer a t-il pu etre ouvert ?
    {
      int nMsgNbr;

      //Mode X_FAST (permet de gagner du temps)
      SetReadMode(LangHandle[index], X_FAST);

      printf("Allocating memory for LANG%d (%s) [%s] ... Reading file ... ", index + 1, LANG_file[index], mem_type(LangHandle[index]));

      //Initialiser les variables
      Msg = -1;
      Buffer[0] = SNULL;
      PosX = wherex();
      PosY = wherey();

      //Initialiser toute la table des messages
      for(nMsgNbr = 0; nMsgNbr < LANG_MAX_LINE; nMsgNbr++)
      {
	sprintf(Buffer, "*** Error : Missing MSG%d message in %s%s.txt.\n", nMsgNbr, LANGUAGE_PATH, LANG_file[index]);
	xput((byte*)Buffer, nMsgNbr, LangHandle[index]);
      }

      //------ Lire le fichier LANGUAGE et mmoriser les messages ------
      do
      {
	//Lire une ligne
	if( ! fgets(Line, 255, fPtr) )
	  Done = TRUE;

	//Sous linux, enlever les '\r'
	#ifdef LINUX
	  TOOLS_removeR(Line);
	#endif

	//:LANGUAGE est un alias de MSG0
	if( ! strncmp(Line, ":LANG", 5) )
	  strcpy(Line, ":MSG0");

	//Est-ce un nouveau bloc ?
	if( ! strncmp(Line, ":MSG", 4) )
	{
	  char   szFileName[256];
	  FILE * fOver;

	  /* Y a t-il un message specifique */
	  sprintf(szFileName, "%s%s.%d", LANGUAGE_PATH, LANG_file[index], Msg);
	  fOver = fopen(szFileName, "rt");
	  if( fOver )
	  {
		char   szLine[256];

		/* Oui : remplacer le message par defaut */
		strcpy(Buffer, "");
		while( fgets(szLine, 255, fOver) )
		{
			if( (strlen(szLine) + strlen(Buffer)) >= LANG_LINE_SIZE)
			{
				printf("\n*** Error : bloc is too large in %s.\n", szFileName);
				fclose( fPtr );
				fclose( fOver );
				exit(EXIT_FAILURE);
			}

			strcat(Buffer, szLine);
		}

		fclose(fOver);
	  }

	  //Mmoriser la ligne qui vient d'tre lue
	  if( Msg >= 0 && Msg <= LANG_MAX_LINE)
	    xput((byte*)Buffer, Msg, LangHandle[index]);

	  //Sauvegarder le nouveau numro de message et vider le buffer
	  Msg = atoi( Line + 4 );
	  Buffer[0] = SNULL;

	  //Faire tourner la roue
#ifdef DOS
	  MILL_turn(PosX, PosY);
	  delay(50); //Juste pour la beaute !...
#endif
	}
	else //Fin atteinte ?
	if( ! strncmp(Line, ":END", 4) )
	{
	  if( Msg >= 0 && Msg <= LANG_MAX_LINE)
	    xput((byte*)Buffer, Msg, LangHandle[index]);
	  Done = TRUE;
	}
	else //Commentaire ?
	if( Line[0] == '#' )
	{
	  //ne fait rien - ignore tout simplement...
	}
	else //Ligne trop longue ?
	if( (strlen(Buffer) + strlen(Line)) >= LANG_LINE_SIZE )
	{
	  printf("\n*** Error : Line too long in MSG #%d.\n", Msg);
	  fclose( fPtr );
	  exit(EXIT_FAILURE);
	}
	else //Ajouter la nouvelle ligne  la suite
	{
	  strcat(Buffer, Line);
	}/*End IF*/
      }while( ! Done );

      //la lecture du fichier est termine
      gotoxy(PosX, PosY);
      printf("Done.\n");
    }
    else
    {
      printf("*** Error : Not enough memory - can't continue.\n");
      fclose( fPtr );
      exit(EXIT_FAILURE);
    }/*End IF*/

    //Fermer le fichier
    fclose(fPtr);

  }/*End FOR*/
}

//---------------------------------------------------------------------------
//------ Lecture d'un message -----------------------------------------------
//---------------------------------------------------------------------------
char * LANG_getMessage(int Language, int Line, char * Buffer)
{
  char * Ptr;

  if( Language >= 0 && Language < 10 && LangHandle[Language] )
  {
    Ptr = (char*) xget(Line, LangHandle[Language]);

    strcpy(Buffer, Ptr);
  }
  else
  {
    strcpy(Buffer, "*** Error : Language undefined.\n");
  }/*End IF*/

  return Buffer;
}

//---------------------------------------------------------------------------
//------ Y a t-il une langue de dfinie ? -----------------------------------
//---------------------------------------------------------------------------
int LANG_isDefined(int Language)
{
  if( Language >= 0 && Language < 10 && LangHandle[Language] )
    return TRUE;
  else
    return FALSE;
}
