#include <alloc.h>
#include <conio.h>
#include <stdio.h>
#include <dos.h>
#include <string.h>
#include <mem.h>
#include "symbol.h"
#include "define.h"
#include "term.h"


//---------------------------------------------------------------------------
//------ Dtecte si une touche du clavier  t frapp, et retourne son -----
//------ code ASCII ---------------------------------------------------------
//---------------------------------------------------------------------------
unsigned int getkey(void)
{
  union REGS regs;
  int lo, hi;

  if( ! kbhit() )
    return( 0 );

  regs.h.ah = 0X00; //Afin de dtecter les touches F11 et F12
  int86( 0X16, &regs, &regs);

  lo = regs.x.ax & 0X00FF;
  hi = (regs.x.ax & 0XFF00) >> 8;

  if (lo == 224) //touches curseurs grises - traitement id aux autres
    lo = 0;
  return( (lo == 0) ? hi + 256 : lo);
}

//---------------------------------------------------------------------------
//------ Edite une saisie ---------------------------------------------------
//------ La fonction retourne le code de la touche qui a t saisie ---------
//---------------------------------------------------------------------------
int ScanKeyboard(char * string, int &pos, int maxlength)
{
  int len = strlen(string);
  int c;
//  int LastLen = len;

  //S'assurer que pos n'est pas suprieur  la longueur de la chaine
  if( pos > strlen(string) )
    pos = strlen(string);

  //Une touche a-t-elle t frappe ?
  c = getkey();

  //Si oui, traiter la touche
  if( c )
  {
    switch(c)
    {
      case HOMEKEY :
	pos = 0;
	break;

      case ENDKEY :
	pos = len;
	break;

      case LEFTKEY :
	if (pos > 0)
	  pos--;
	break;

      case RIGHTKEY :
	if (pos < len)
	  pos++;
	break;

      case BS :
	if (pos > 0)
	{
	  movmem(&string[pos], &string[pos -1], len - pos + 1);
	  pos--;
	  len--;
	}
	break;

      case DELKEY :
	if (pos < len)
	{
	  movmem(&string[pos + 1], &string[pos], len - pos);
	  len--;
	}
	break;

      case CR :
	break;

      case UPKEY :
	break;

      case DOWNKEY :
	break;

      case ESC :
	string[0] = SNULL;
	len = 0;
	pos = 0;
	break;

      case CCR :
	break;

      case PGUPKEY :
	break;

      case PGDNKEY :
	break;

      default :
	if ( (len < maxlength) && (c < 256) && (c != TAB)) //Filtrage
	{
	  memmove(&string[pos + 1], &string[pos], len - pos + 1);
	  len++;
	  string[pos++] = c;
	}
	break;
    }/* fin de switch*/
  }/*end if*/

  return c ;

}/* Fin ScanKeyboard */
