#include <alloc.h>
#include <string.h>
#include <stdio.h>
#include <dir.h>
#include <stdlib.h>
#include <string.h>
#include <ctype.h>
#include "tools.h"
#include "define.h"
#include "hops.h"
#include "commands.h"
#include "buffers.h"
#include "log.h"
#include "node.h"
#include "filter.h"
#include "ltimeout.h"
#include "users.h"
#include "protocol.h"
unsigned char	HOPS_In[65][256];	  /* 255 hops (10-60), un par stream */
unsigned char	HOPS_Out[65][256];	  /* 255 hops (10-60), un par stream */

int HOPS_nLFilterEnabled = FALSE;

/* Liste des commandes
	Talk			Talk		PC10
	Dx info			DX		PC11
	Annoucement		Announcement	PC12
	Conference in/out	CONFerence	PC13 PC14 PC15
	Add/delete user		USER		PC16 PC17
	Add/delete node		NODE		PC19 PC21
	WWVinfo			WWV		PC23
	WCY/info		WCY		PC73 (it works only if
						      ENHanced_prot is ON)
	Here status info	USTatus		PC24
	DX/WWV merge request	MREQuest	PC25
	Dx merge info		MDX		PC26
	WWV merge info		MWWV		PC27
	Mail forwarding		MAIL		PC28 to PC33, PC40,
						PC42, PC43, PC49
	Remote commands		RCOMmands	PC34, PC35, PC36
	User info		UINfo		PC41
	Remote DB request	DATAbase	PC44 to PC48
	Update user count	UCOunt		PC50
	Ping			PIng		PC51



   Special commands
	ENHanced command
*/

//Commande non documentee (shhhht)
//				asuser

struct
{
  char	sNodeCall[11];
  int	iPC16;
  int	iPC19;
  int	iPC50;
} HopsStruct;

/*-----------------------------------------------------------------------
  ------ Erreur dans le fichier script : prevenir tous les sysops -------
  -----------------------------------------------------------------------*/
void HOPS_error2sysop(char * pszFileName, char * pszLine, int nLine)
{
	char szBuffer[256];

	/* Enlever les "-1 -1" qui avaient t rajoutes */
	pszLine[strlen(pszLine) - 6] = SNULL;

	sprintf(szBuffer,
	"*** Syntax error in config file '%s' in line %d :\n-> %s\n",
	pszFileName, nLine, pszLine);

	/* Transmettre a tous les sysops */
	USERS_sendAll(szBuffer, USERS_SYSOP, PROTOCOL_MISC, -1);
}

//--------------------------------------------------------------------------
//------ Lecture du fichier CFG (en autres, HOPS) associ au cluster -------
//--------------------------------------------------------------------------
void HOPS_readFile(int StreamNum, char * NodeCall)
{
  FILE *fPtr;
  int	index;
  char  sFileName[MAXPATH];
  char  sLine[81];
  char  sCmd[81];
  char  sArg[81];
  int	InOut = HOPS_OUT;
  int	iLengthCmd;
  int	iHOPS;
  int	iExternal = FALSE;
  int   nLines = 0;

  int	iPC[15];

  /* Charger les valeurs par dfaut */
  for(index = 8; index < 52; index++)
  {
	HOPS_In [StreamNum][index]  = 99;
	HOPS_Out[StreamNum][index] = 99;
  }

  /* Initialiser le filtre */
  FILTER_init(StreamNum);

  /* Initialiser le timeout */
  LTIMEOUT_init(StreamNum);

  HOPS_In [StreamNum][PCAS_USER] = 0;
  HOPS_Out[StreamNum][PCAS_USER] = 0;

  HOPS_In [StreamNum][PCEXTERNAL] = 0;
  HOPS_Out[StreamNum][PCEXTERNAL] = 0;

  /* DX/WWV Merge request */
  HOPS_In[StreamNum][PC_MRDX]  = 0;
  HOPS_In[StreamNum][PC_MRWWV] = 0;

  /* WCY infos */
  HOPS_In [StreamNum][PC73] = 99;
  HOPS_Out[StreamNum][PC73] = 99;

  /* Enhanced remote command */
  HOPS_In [StreamNum][PC84] = 99;
  HOPS_Out[StreamNum][PC84] = 99;
  HOPS_In [StreamNum][PC85] = 99;
  HOPS_Out[StreamNum][PC85] = 99;


  iPC[0] = -1;

  //Nom du fichier
  strcpy(sFileName, HOPS_PATH);
  strcat(sFileName, NodeCall);
  TOOLS_removeSsid( sFileName );
  strcat(sFileName, ".cfg");
#ifdef LINUX
  strlwr(sFileName);			/* compatibilit standard LINUX */
#else
  strupr(sFileName);
#endif

  fPtr = fopen(sFileName, "rt");

  //Si le fichier n'existe pas ...
  if( ! fPtr )
    return;

  //Lire le fichier
  while( fgets(sLine, 80, fPtr) )	/* Jusqu'a EOF */
  {
    nLines++;
    strlwr( sLine );
    TOOLS_removeN( sLine );

    //Extraire les paramtres
    strcat(sLine, " -1 -1");	    	//En cas de chaine vide, pour ne pas planter sscanf
    sscanf(sLine, "%s %s", sCmd, sArg);

    if( sCmd[0] == '#' )
	continue;

    //Longueur de la commande
    iLengthCmd = strlen( sCmd );

    //Lecture de iHOPS
    if( ! strcmp(sArg, "on") )
      iHOPS = 100;
    else
      iHOPS = atoi( sArg );

    //Init de iPC (au cas ou la ligne ne correspondrait pas a une commande)
    iPC[0] = -1;

    //[in] et [out] dans le fichier .CFG ??
    if( ! strcmp(sCmd, "[in]") )
	InOut = HOPS_IN;

    else if( ! strcmp(sCmd, "[out]") )
	InOut = HOPS_OUT;

    else if( COMMANDS_check("filter", sCmd, iLengthCmd, 4) )
	FILTER_set(StreamNum, (InOut == HOPS_IN ? FILTER_IN : FILTER_OUT), sLine + iLengthCmd + 1);

    else if( COMMANDS_check("timeout", sCmd, iLengthCmd, 4) )
    {
	int nValue1;
	int nValue2;

	if( sscanf(sLine, "%s %d %d", sCmd, &nValue1, &nValue2) == 3 )
	{
		if( nValue1 > 0 && nValue2 > 0 )
			LTIMEOUT_set(StreamNum, nValue1 + nValue2, nValue1);
		else
			HOPS_error2sysop(sFileName, sLine, nLines);
	}
    }
    else if( COMMANDS_check("mrwwv", sCmd, iLengthCmd, 3) )
    {
	int nValue = -1;

	/* WWV merge request */
	if( isdigit(sArg[0]) )
		nValue = atoi(sArg);

	if( nValue >= 0 || nValue <= 10 )
		HOPS_In[StreamNum][PC_MRWWV] = nValue;
	else
		HOPS_error2sysop(sFileName, sLine, nLines);
    }
    else if( COMMANDS_check("mrdx", sCmd, iLengthCmd, 3) )
    {
	int nValue = -1;

	/* DX merge request */
	if( isdigit(sArg[0]) )
		nValue = atoi(sArg);

	if( nValue >= 0 || nValue <= 10 )
		HOPS_In[StreamNum][PC_MRDX] = nValue;
	else
		HOPS_error2sysop(sFileName, sLine, nLines);
    }

    /* Peut-tre est-ce pour un protocole ... */
    else if( iHOPS >= 0 && iHOPS <= 100 )
    {
      //**** Talk - PC10 ****
      if( COMMANDS_check("talk", sCmd, iLengthCmd, 1) )
      {
	iPC[0] = PC10;
	iPC[1] = -1;
      }
      //**** DX spot - PC11 ****
      else if( ! strcmp("dx", sCmd) )
      {
	iPC[0] = PC11;
	iPC[1] = -1;
      }
      //**** Annonce - PC12 ****
      else if( COMMANDS_check("announcement", sCmd, iLengthCmd, 1) )
      {
	iPC[0] = PC12;
	iPC[1] = -1;
      }
      //**** UserStatus - PC13, PC14 ****
      else if( COMMANDS_check("conference", sCmd, iLengthCmd, 4) )
      {
	iPC[0] = PC13;
	iPC[1] = PC14;
	iPC[2] = PC15;
	iPC[3] = -1;
      }
      //**** UserLogin & UserLogout - PC16 & PC17 ****
      else if( ! strcmp("user", sCmd) )
      {
	iPC[0] = PC16;
	iPC[1] = PC17;
	iPC[2] = -1;
      }
      //**** NodeLogin & NodeLogout - PC19 & PC21 ****
      else if( ! strcmp("node", sCmd) )
      {
	iPC[0] = PC19;
	iPC[1] = PC21;
	iPC[2] = -1;
      }
      //**** WWV - PC23 ****
      else if( ! strcmp("wwv", sCmd) )
      {
	iPC[0] = PC23;
	iPC[1] = -1;
      }
      //**** WCY - PC73 ****
      else if( ! strcmp("wcy", sCmd) )
      {
	iPC[0] = PC73;
	iPC[1] = -1;
      }
      //**** UserStatus - PC13, PC14 ****
      else if( COMMANDS_check("ustatus", sCmd, iLengthCmd, 3) )
      {
	iPC[0] = PC24;
	iPC[1] = -1;
      }
      //**** DX/WWV merge request - PC25 ****
      else if( COMMANDS_check("mrequest", sCmd, iLengthCmd, 4) )
      {
	iPC[0] = PC25;
	iPC[1] = -1;
      }
      //**** DX merge info - PC26 ****
      else if( ! strcmp("mdx", sCmd) )
      {
	iPC[0] = PC26;
	iPC[1] = -1;
      }
      //**** WWV merge info - PC27 ****
      else if( ! strcmp("mwwv", sCmd) )
      {
	iPC[0] = PC27;
	iPC[1] = -1;
      }
      //**** Mail forwarding - PC28, PC29, PC30, PC31, PC32, PC33, PC40, PC42, PC43, PC49 ****
      else if( ! strcmp("mail", sCmd) )
      {
	iPC[0] = PC28;
	iPC[1] = PC29;
	iPC[2] = PC30;
	iPC[3] = PC31;
	iPC[4] = PC32;
	iPC[5] = PC33;
	iPC[6] = PC40;
	iPC[7] = PC42;
	iPC[8] = PC43;
	iPC[9] = PC49;
	iPC[10] = -1;
      }
      //**** Remote commands ****
      else if( COMMANDS_check("rcommands", sCmd, iLengthCmd, 4) ||
	       ! strcmp("rcmd", sCmd) )
      {
	iPC[0] = PC34;
	iPC[1] = PC35;
	iPC[2] = PC84;
	iPC[3] = PC85;
	iPC[4] = -1;
      }
      //**** User Info - PC41
      else if( COMMANDS_check("uinfo", sCmd, iLengthCmd, 3) )
      {
	iPC[0] = PC41;
	iPC[1] = -1;
      }
      //**** Database - PC44, PC45, PC46, PC47, PC48 ****
      else if( COMMANDS_check("database", sCmd, iLengthCmd, 4) )
      {
	iPC[0] = PC44;
	iPC[1] = PC45;
	iPC[2] = PC46;
	iPC[3] = PC47;
	iPC[4] = PC48;
	iPC[5] = -1;
      }
      //**** UserCount - PC50 ****
      else if( COMMANDS_check("ucount", sCmd, iLengthCmd, 3) )
      {
	iPC[0] = PC50;
	iPC[1] = -1;
      }
      //**** Ping - PC51 ****
      else if( COMMANDS_check("ping", sCmd, iLengthCmd, 2) )
      {
	iPC[0] = PC51;
	iPC[1] = -1;
      }
      else if( COMMANDS_check("clulink", sCmd, iLengthCmd, 3) )
      {
	HOPS_In[StreamNum][PCCLULINK]  = (unsigned char) iHOPS;
	HOPS_Out[StreamNum][PCCLULINK] = (unsigned char) iHOPS;
      }
      //**** cas d'un protocol external ****
      else if( ! strcmp(sCmd, "external") )
      {
	HOPS_In[StreamNum][PCEXTERNAL]  = (unsigned char) iHOPS;
	HOPS_Out[StreamNum][PCEXTERNAL] = (unsigned char) iHOPS;

	if( iHOPS )
	  iExternal = TRUE;
      }
      else if( COMMANDS_check("asuser", sCmd, iLengthCmd, 3) )
      {
	HOPS_In [StreamNum][PCAS_USER] = (unsigned char) iHOPS;
	HOPS_Out[StreamNum][PCAS_USER] = (unsigned char) iHOPS;
      }
      else if( COMMANDS_check("enhanced_protocol", sCmd, iLengthCmd, 3) )
      {
	HOPS_In [StreamNum][PC_ENHANCED] = (unsigned char) iHOPS;
	HOPS_Out[StreamNum][PC_ENHANCED] = (unsigned char) iHOPS;
      }
      else
      {
	HOPS_error2sysop(sFileName, sLine, nLines);
      }/*End IF*/
    }/*End IF*/

    //Charger les valeurs
    if( iPC[0] != -1 )
    {
      for(index = 0; index < 15; index++)
      {
	if( iPC[index] == -1 )
	  break;		//Fin atteinte, sortir

	if( InOut == HOPS_IN )
	  HOPS_In[StreamNum][iPC[index]]  = (unsigned char) iHOPS;
	else
	  HOPS_Out[StreamNum][iPC[index]] = (unsigned char) iHOPS;
      }/*End FOR*/
    }/*End IF*/

  }/*End WHILE*/

  if( iExternal )
  {
	if( HOPS_In[StreamNum][PC19] == 0 )
		HOPS_In [StreamNum][PC19] = 1; 	/* Pour accepter le call de l'adjacent */
      	HOPS_Out[StreamNum][PC19] = 0;    /* NodeAdd */

      	HOPS_In [StreamNum][PC21] = 0;	/* NodeDelete */
      	HOPS_Out[StreamNum][PC21] = 0;

      	HOPS_In [StreamNum][PC16] = 0;	/* UserLogin */
      	HOPS_Out[StreamNum][PC16] = 0;

      	HOPS_In [StreamNum][PC17] = 0;	/* UserLogout */
      	HOPS_Out[StreamNum][PC17] = 0;

      	HOPS_In [StreamNum][PC24] = 0;	/* User status */
      	HOPS_Out[StreamNum][PC24] = 0;
  }

  fclose( fPtr );
}

//---------------------------------------------------------------------------
//------ Determiner le HOPS pour ce stream ----------------------------------
//---------------------------------------------------------------------------
int HOPS_fix(int StreamNum, char * pszClusterCall, int nFromStream, int PC, int Direction, int Hops)
{
	int nHopsLFilter;

	/* Pour que les PC73s soient autorises, il faut que enhanced_prot
	   soit valide */
	if( Hops == PC73 && ! HOPS_isEnhanced(StreamNum) )
		return 0;

	if( Hops <= 0 || Hops > 100)
		return 0;		/* Mauvais hop counts */

	/* Ne pas dcrmenter si la direction est IN */
	if( Direction != HOPS_IN )
		Hops--;

	if( (nHopsLFilter = HOPS_lFilterFix(StreamNum, pszClusterCall, nFromStream, PC, Direction)) != -1 )
	{
		/* Retourner le plus petit */
		return (Hops < nHopsLFilter) ? Hops : nHopsLFilter;
	}

	if( Direction == HOPS_IN )
	{
		if( Hops > HOPS_In[StreamNum][PC] )
			Hops = HOPS_In[StreamNum][PC];
	}
	else
	{
		if( Hops > HOPS_Out[StreamNum][PC] )
			Hops = HOPS_Out[StreamNum][PC];
	}

  	return Hops;
}

//----------------------------------------------------------------------------
//------ Updater les valeurs des Hops pour PC16/17, PC19/21 et PC50----------
//----------------------------------------------------------------------------
void HOPS_updateHops(char * NodeCall, int Hops, int Pc)
{
  FILE *fPtr;
  int	Done = FALSE;
  long	lFilePos;
  char  szMyNodeCall[16];

  /* Pas pour moi (cas d'une boucle) */
  NODE_getNodeCall(0, 0, szMyNodeCall);
  if( ! strcmp(szMyNodeCall, NodeCall) )
	return;

  //Ouvrir le fichier
  fPtr = fopen(HOPS_BIN_FILE, "r+b");

  //Si le fichier n'existe pas ...
  if( ! fPtr )
  {
//    if( Pc != PC50 )	//Il n'est pas dans le rseau, donc ne pas enregistrer pour PC50
      HOPS_newHops(NodeCall, Hops, Pc);

    perror("fopen in HOPS_updateHops");
    return;
  }

  //Rechercher l'enregistrement (cela peut-tre long, car le fichier n'est pas index)
  for(;;)
  {
    lFilePos = ftell( fPtr );
    if( fread(&HopsStruct, sizeof(HopsStruct), 1, fPtr) != 1 )
      break;	//Fin de fichier atteinte

    if( ! strcmp(HopsStruct.sNodeCall, NodeCall) )
    {
      //Correspondance trouve
      Done = TRUE;
      break;
    }
  }/*End FOR*/

  //L'enregistrement a t-il t trouv ?
  if( ! Done )
  {
    //Non, le crer
//    if( Pc != PC50 )	//Il n'est pas dans le rseau, donc ne pas enregistrer pour PC50
      HOPS_newHops(NodeCall, Hops, Pc);

    fclose( fPtr );
    return;
  }/*End IF*/

  //Oui, mettre  jour
  switch( Pc )
  {
    case PC16 :
    case PC17 :
      /* Ne pas enregistrer si le hops est suprieur a celui
	 du dernier PC50 recu, car il y a de forte chances pour qu'il ne
	 soit pas valide */
      if( Hops <= HopsStruct.iPC50 )
	HopsStruct.iPC16 = Hops;
      break;

    case PC19 :
    case PC21 :
      /* Ne pas enregistrer si le hops est superieur a celui
	 du dernier PC50 recu, car il y a de forte chances pour qu'il ne
	 soit pas valide */
      if( Hops <= HopsStruct.iPC50 )
	HopsStruct.iPC19 = Hops;
      break;

    case PC50 :
      HopsStruct.iPC50 = Hops;
      break;
  }/*End SWITCH*/

  //Enregistrer
  fseek(fPtr, lFilePos, SEEK_SET);	//Repositioner sur l'enregistrement en cours
  fwrite(&HopsStruct, sizeof(HopsStruct), 1, fPtr);

  //Fermer le fichier
  fclose( fPtr );
}

//----------------------------------------------------------------------------
//------ Crer un enregistrement Hops ----------------------------------------
//----------------------------------------------------------------------------
void HOPS_newHops(char * NodeCall, int Hops, int Pc)
{
  FILE *fPtr;

  //Ouvrir le fichier
  fPtr = fopen(HOPS_BIN_FILE, "a+b");

  //Le fichier n'a pas pu tre ouvert ...
  if( ! fPtr )
  {
    BUFFERS_printBuff(BUFFER_SCREEN1, OUT, "*** Error accessing the file %s.\n", HOPS_BIN_FILE);
    perror("fopen in HOPS_newHops");
    return;
  }

  //Pour faire plus b
  memset(&HopsStruct, 0, sizeof(HopsStruct));
  //Mettre  jour
  strcpy(HopsStruct.sNodeCall, NodeCall);
  HopsStruct.iPC16 = 100;
  HopsStruct.iPC19 = 100;
  HopsStruct.iPC50 = 100;

  switch( Pc )
  {
    case PC16 :
    case PC17 :
      HopsStruct.iPC16 = Hops;
      break;

    case PC19 :
    case PC21 :
      HopsStruct.iPC19 = Hops;
      break;

    case PC50 :
      HopsStruct.iPC50 = Hops;
      break;
  }/*End SWITCH*/

  //Enregistrer en fin de fichier
  fwrite(&HopsStruct, sizeof(HopsStruct), 1, fPtr);

  //Fermer le fichier
  fclose( fPtr );
}

//---------------------------------------------------------------------------
//------ Lecture d'un enregistrement ----------------------------------------
//---------------------------------------------------------------------------
//La fonction retourne FALSE si l'enregistrement n'a pas t trouv, ou si
//le fichier n'a pas pu tre ouvert
//NodeCall : indicatif  rechercher - si NodeCall est vide, la fonction pointe sur l'enregistrement Pos
//Pos	   : si NodeCall est vide (""), Pos indique le numro de l'enregistrement  retourner
//Pc16	   : int retournant le hop count pour PC16/17
//Pc19	   : int retournant le hop count pour PC19/21
//Pc50	   : int retournant le hop count pour PC50
int HOPS_getHops(char * NodeCall, int Pos, int & Pc16, int & Pc19, int & Pc50)
{
  FILE *fPtr;
  long	lFilePos;

  fPtr = fopen(HOPS_BIN_FILE, "rb");

  //Le fichier existe t-il ?
  if( ! fPtr )
    return FALSE;	//NON

  if( *NodeCall )	//Recherche un indicatif ?
  {
    //Oui ...
    //Rechercher l'enregistrement (cela peut-tre long, car le fichier n'est pas index)
    for(;;)
    {
      if( fread(&HopsStruct, sizeof(HopsStruct), 1, fPtr) != 1 )
      {
	fclose( fPtr );

	return FALSE; 	//Fin de fichier atteinte - l'indicatif n'a pas t trouv
      }

      if( ! strcmp(HopsStruct.sNodeCall, NodeCall) )
      {
	Pc16 = HopsStruct.iPC16;
	Pc19 = HopsStruct.iPC19;
	Pc50 = HopsStruct.iPC50;

	fclose( fPtr );

	return TRUE;	//Trouv
      }
    }/*End FOR*/
  }

  //Non ... positionner le pointeur de fichier sur Pos

  //Vrifier qu'on ne pointe pas en dehors du fichier (faut faire ainsi pour contrer un defaut de msdos)
  lFilePos = sizeof(HopsStruct) * (long ) Pos;	//Calcul de la position
  fseek(fPtr, 0L, SEEK_END);			//Se placer en fin de fichier
  if( lFilePos >= ftell( fPtr ) )		//Vrifier s'il y a dpassement
  {
    fclose( fPtr );
    return FALSE;	//Oui
  }

  //Positionner
  fseek(fPtr, lFilePos, SEEK_SET);

  //Lire
  if( fread(&HopsStruct, sizeof(HopsStruct), 1, fPtr) != 1 )
  {
    fclose( fPtr );
    return FALSE;	//Problme lors de la lecture
  }

  //Passer les valeurs et retourner
  strcpy(NodeCall, HopsStruct.sNodeCall);
  Pc16 = HopsStruct.iPC16;
  Pc19 = HopsStruct.iPC19;
  Pc50 = HopsStruct.iPC50;

  fclose( fPtr );
  return TRUE;
}

//--------------------------------------------------------------------------
//------ Retourne le hops probable pour un cluster -------------------------
//--------------------------------------------------------------------------
//Si le cluster n'a pas t trouv dans la liste, la fonction retourne 99
#pragma argsused
int HOPS_probable(char * NodeCall)
{
  return 99;	//Dans l'attente de faire mieux !
}

//--------------------------------------------------------------------------
//------ Est-ce un link external ? -----------------------------------------
//--------------------------------------------------------------------------
int HOPS_isExternal(int StreamNum)
{
  if( HOPS_In[StreamNum][PCEXTERNAL] )
    return TRUE;
  else
    return FALSE;
}

//--------------------------------------------------------------------------
//------ Retourne le HOPS d'un protocole entrant ---------------------------
//--------------------------------------------------------------------------
int HOPS_str2int(int StreamNum, char * pszFromPC, char* pszHops, int nProtocol)
{
	char	szHops[16];
	strcpy(szHops, pszHops);

	int nHops = atoi(szHops + 1);
	int nRet  = HOPS_fix(StreamNum, pszFromPC, 0, nProtocol, HOPS_IN, nHops);

        return nRet;
}

//--------------------------------------------------------------------------
//------ Retourne le HOPS d'un protocole entrant ---------------------------
//--------------------------------------------------------------------------
int HOPS_char2int(int StreamNum, char * pszFromPC, char cHops, int nProtocol)
{
	return HOPS_fix(StreamNum, pszFromPC, 0, nProtocol, HOPS_IN, (int) cHops);
}

/*-----------------------------------------------------------------------
  ------ Retourne la valeur du DX merge request -------------------------
  -----------------------------------------------------------------------*/
int HOPS_getMRdxCount(int StreamNum)
{
	return HOPS_In[StreamNum][PC_MRDX];
}

/*-----------------------------------------------------------------------
  ------ Retourne la valeur du WWV merge request ------------------------
  -----------------------------------------------------------------------*/
int HOPS_getMRwwvCount(int StreamNum)
{
	return HOPS_In[StreamNum][PC_MRWWV];
}

/*-----------------------------------------------------------------------
  ------ Lire le fichier de configuration speciale (*.SPE) --------------
  -----------------------------------------------------------------------
  Retour : hop count defini par le ConfigLFilter ou -1 si pas trouve
*/
int HOPS_lFilterFix(int StreamNum, char * pszClusterCall, int nFromStream, int nPC, int nDirection)
{
	char szAdjacent[16];

	if( HOPS_nLFilterEnabled == FALSE || nPC < PC10 )
		return -1;

	NODE_getNodeCall(StreamNum, 0, szAdjacent);
	if( szAdjacent[0] == SNULL )	/* link setup ? */
	{
		extern char STREAMS_callsign[MAX_STREAMS][10];

		/* C'est une connexion sortante, dans
		   ce cas, l'indicatif est copie dans
		   STREAMS_callSign */
		strcpy(szAdjacent, STREAMS_callsign[StreamNum]);
	}
	/* Rechercher la regle dans le fichier */
	return HOPS_searchLFilter(szAdjacent, pszClusterCall, nFromStream, nPC, nDirection);
}

/*-----------------------------------------------------------------------
  ------ Rechercher le hop count defini pour un cluster dans le .LF -----
  -----------------------------------------------------------------------
  Retour : hops ou -1 si pas trouve
*/
int HOPS_searchLFilter(char * pszAdjacent, char * pszClusterCall, int nFromStream, int nPC, int nDirection)
{
	char szFileName[MAXPATH];
	char szBuffer[1024];
	char szArg[5][1024];
	int  nHops;
	int  nBestFoundHops = -1;
	int  nCurrentDirection = -1;
	int  nArg;
	int  nLine = 0;
	int  nLengthCmd;
	FILE * fPtr;

	/* Ouvrir le fichier */
	sprintf(szFileName, "%s%s", LFILTER_PATH, pszAdjacent);
	TOOLS_removeSsid(szFileName);
	strlwr(szFileName);
	strcat(szFileName, ".lf");

	fPtr = fopen(szFileName, "rt");
	if( ! fPtr )
		return -1;	/* Fichier inexistant */

	while( fgets(szBuffer, sizeof(szBuffer), fPtr) )
	{
		nLine++;

		if( szBuffer[0] == '\n' )
			continue;

		strupr(szBuffer);

		/* Lire la chaine */
		nArg = sscanf(szBuffer, "%s %s %s %s %s", szArg[0], szArg[1],
			      szArg[2], szArg[3], szArg[4]);

		if( *szArg[0] == '#' )
			continue;	/* Comment line */

		if( nArg == 1 )
		{
			if( ! strcmp(szArg[0], "[IN]") )
				nCurrentDirection = HOPS_IN;
			else if( ! strcmp(szArg[0], "[OUT]") )
				nCurrentDirection = HOPS_OUT;
			else if( ! strcmp(szArg[0], "[REJECT]") )
				nCurrentDirection = HOPS_REJECT;
			else
			{
				/* Erreur : commande inconnue */
				HOPS_error2sysop(szFileName, szBuffer,
						 nLine);
			}

			continue;
		}

		if( nCurrentDirection == HOPS_REJECT )
		{
			if( nDirection == HOPS_IN )
				continue;

			if( nArg < 4 )
			{
				HOPS_error2sysop(szFileName, szBuffer, nLine);
				continue;
			}

			if( nFromStream >= 1 && nFromStream <= 64 )
			{
				extern char STREAMS_callsign[MAX_STREAMS][10];
				char szAdjacent[16];

				NODE_getNodeCall(nFromStream, 0, szAdjacent);
				if( szAdjacent[0] == SNULL )	/* link setup ? */
				{
					/* C'est une connexion sortante, dans
					   ce cas, l'indicatif est copie dans
					   STREAMS_callSign */
					strcpy(szAdjacent, STREAMS_callsign[nFromStream]);
				}

				if( HOPS_isForCall(szArg[0], szAdjacent) )
				{
					fclose(fPtr);

					switch(nPC)
					{
					case PC11 :
						if( nArg >= 1 )
							return atoi(szArg[1]);
						break;
					case PC12 :
						if( nArg >= 2 )
							return atoi(szArg[2]);
						break;
					case PC23 :
						if( nArg >= 3 )
							return atoi(szArg[3]);
						break;

					case PC73 :
						if( nArg >= 4 )
							return atoi(szArg[4]);
						break;
					}
					return 0;
				}
			}
			continue;
		}

		if( nArg > 3 )
		{
			/* Erreur dans le fichier */
			HOPS_error2sysop(szFileName, szBuffer, nLine);
			continue;
		}

		if( pszClusterCall == NULL )
			continue;

		if( ! strcmp(szArg[1], "OFF") )
			nHops = 0;
		else if( ! isdigit(*szArg[1]) )
		{
			/* Erreur, valeur numerique attendue ... */
			HOPS_error2sysop(szFileName, szBuffer, nLine);
			continue;
		}
		else
			nHops = atoi(szArg[1]);

		if( nCurrentDirection != nDirection )
			continue;

		/* Selon la commande ... */
		nLengthCmd = strlen(szArg[0]);

		if( ! strcmp(szArg[0], "*") )
		{
			if( HOPS_isForCall(szArg[2], pszClusterCall) )
				nBestFoundHops = nHops;
			continue;
		}

		if( ! strcmp("DX", szArg[0]) )
		{
			if( nPC == PC11 && HOPS_isForCall(szArg[2], pszClusterCall) )
				nBestFoundHops = nHops;
			continue;
		}

		if( COMMANDS_check("ANNOUNCEMENT", szArg[0], nLengthCmd, 1) )
		{
			if( nPC == PC12 && HOPS_isForCall(szArg[2], pszClusterCall) )
				nBestFoundHops = nHops;
			continue;
		}

		if( ! strcmp("WWV", szArg[0]) )
		{
			if( nPC == PC23 && HOPS_isForCall(szArg[2], pszClusterCall) )
				nBestFoundHops = nHops;
			continue;
		}

		if( ! strcmp("WCY", szArg[0]) )
		{
			if( nPC == PC73 && HOPS_isForCall(szArg[2], pszClusterCall) )
				nBestFoundHops = nHops;
			continue;
		}

		HOPS_error2sysop(szFileName, szBuffer, nLine);
	}

	fclose(fPtr);

	return nBestFoundHops;
}

/*-----------------------------------------------------------------------
  ------ Verifier si l'indicatif pszClusterCall est accepte dans la --------
  ------ chaine pszCallList ---------------------------------------------
  -----------------------------------------------------------------------
  Attention, pszCallList sera modifie par cette fonction
  Retour : TRUE si OK et FALSE sinon                                     */
int HOPS_isForCall(char * pszCallList, char * pszClusterCall)
{
	char * token;

	token = strtok(pszCallList, ":");
	while( token )
	{
		char * pszJoker = strchr(token, '*');

		if( pszJoker )
		{
			int len = (int) (pszJoker - token);

			if( ! strncmp(pszClusterCall, token, len) )
				return TRUE;
		}
		else if( ! strcmp(pszClusterCall, token) )
			return TRUE;

		token = strtok(NULL, ":");
	}

	return FALSE;
}

/*-------------------------------------------------------------------------
  ------ Le link supporte t-il le protocole etendu ?
  -------------------------------------------------------------------------*/
int HOPS_isEnhanced(int StreamNum)
{
	if( HOPS_In[StreamNum][PC_ENHANCED] )
		return TRUE;
	else
		return FALSE;
}
