#include <alloc.h>
#include <string.h>
#include <stdio.h>
#include <dir.h>
#include <conio.h>
#include <dos.h>
#include <process.h>
#include <stdlib.h>
#include "define.h"
#include "help.h"
#include "tools.h"
#include "buffers.h"
#include "message.h"
#include "language.h"

extern 	char  	STREAMS_lang[MAX_STREAMS];
extern	char    *MSG_pParams[10];
extern 	char	 LANG_file[MAX_LANG][81];       //Nom de fichiers LANG - 80 caractres au maximum pour chauqe nom de fichier

//---------------------------------------------------------------------------
//------ Lecture d'un message HELP ------------------------------------------
//---------------------------------------------------------------------------
//La fonction retourne TRUE si le message a t trouv, et FALSE sinon
int HELP_send(int StreamNum, char * Topic)
{
  char	sFileName[MAXPATH];
  char	sLine[256];
  char	sTopic[TOPIC_SIZE];
  int	Done = FALSE;
  FILE *fPtr;

  //Initialisation de sTopic ...
  strlwr( Topic );
  TOOLS_maxLength(Topic, TOPIC_SIZE);
  if( *Topic )
    strcpy(sTopic, Topic);
  else
    strcpy(sTopic, "help");

  //Crer nom de fichier
//  sprintf(sFileName, "%shelp%d.txt", LANGUAGE_PATH, STREAMS_lang[StreamNum] + 1);
  sprintf(sFileName, "%s%s.hlp", LANGUAGE_PATH, LANG_file[(int)STREAMS_lang[StreamNum]]);

  //Ouvrir le fichier HELP, s'il existe
  fPtr = fopen(sFileName, "rt");
  if( ! fPtr )
  {
    BUFFERS_addBuff(StreamNum, "*** Error : Language undefined.\n", OUT);
    perror("fopen in HELP_send");
    return FALSE;
  }/*End IF*/

  //Lire le fichier,  la recherche du sujet
  for(;;)
  {
    //Lire une ligne
    if( ! fgets(sLine, 255, fPtr) )
      break; 				//Fin de fichier atteinte

    //Sous linux, enlever les '\r'
    #ifdef LINUX
      TOOLS_removeR(sLine);
    #endif

    //Est-ce un nouveau bloc ?
    if( sLine[0] == ':' )
    {
      //Fin d'un bloc dj trouv ?
      if( Done )
	break;

      //Ce nouveau bloc est-il le bon ?
      strlwr(sLine);
      TOOLS_removeN(sLine);
      if( ! strcmp(sLine+1, sTopic) )
	Done = TRUE;			//Trouv !
     }
     else if( Done )	//Si le bloc a t trouv, transmettre son contenu
     {
	//Remplacer les variables
	MSG_insertVar(StreamNum, sLine);

	//Ajouter dans le buffer
	BUFFERS_addBuff(StreamNum, sLine, OUT);
     }/*End IF*/
   }/*End FOR*/

   //Fermer le fichier
   fclose( fPtr );

   //Si le bloc a t trouv ...
   if( Done )
     return TRUE;

   //Sinon, s'excuser ...
   strupr( Topic );
   MSG_pParams[1] = Topic;		//Passage de l'argument
   MSG_send(StreamNum, MSG29);		//Afficher le message d'erreur
   return FALSE;
}
