////////////////////////////////////////////////////////////////////////////////////////////
// Portage windows (c) f5mzn   jan 2001
//
// Part of code (c) f6fbb
//

#include <winsock2.h>
#include <alloc.h>
#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include "fbbsrv.h"
#include "switch.h"
#include "users.h"
#include "buffers.h"
#include "filter.h"
#include "streams.h"
#include "set.h"
#include "tools.h"
#include "password.h"
#include "commands.h"
#include "script.h"
#include "protocol.h"

#ifdef LINUX
#include <sys/ioctl.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <netdb.h>
#include <unistd.h>
#endif

#define ORB_WAITINFO	0
#define ORB_WAITPASS	1
#define ORB_CONNECTED	2
#define ORB_DISCONNECT	3

#define ORB_MSGS	1
#define ORB_STATUS	2
#define ORB_NBCNX	4
#define ORB_LISTCNX	8
#define ORB_MONITOR	16
#define ORB_CONSOLE	32
#define ORB_CHANNEL	64
#define ORB_XFBBX	128

#define W_CNST		5

#ifdef WIN32
/* Portage WIN32 */
#define close(x)			closesocket(x)
#define write(x, y, z)		send(x, y, z, 0)
#define socklen_t			int 
#define MyCall				SWITCH_szMyCall
#define read(x, y, z)		recv(x, y, z, 0)
#endif

/* Variables globales */
static int IsConsoleConnected  = FALSE;
OrbClient * client_head = NULL;
int orb_fd = -1;

/* Variables externes */
extern char MyCall[20];

static void orb_send_data (char *buffer, int lg, int mask)
{
	OrbClient *sptr = client_head;

	while (sptr)
	{
		if (sptr->mask & mask)
		{
			switch (mask)
			{
			case ORB_MONITOR:
			case ORB_CONSOLE:
			case ORB_CHANNEL:
				if (((mask == ORB_MONITOR) && (buffer[4] == (char) 0xff)) ||
					((mask == ORB_CONSOLE) && (buffer[4] == 0)))
				{
					write (sptr->fd, buffer, lg);
				}
				if ((mask == ORB_CHANNEL) && (buffer[4] > 0) && (buffer[4] < 0xff))
				{
					if ((sptr->channel == 0) || (sptr->channel == buffer[4]))
						write (sptr->fd, buffer, lg);
				}
				break;
			default:
				write (sptr->fd, buffer, lg);
				break;
			}
		}
		sptr = sptr->next;
	}
}

/*----------------------------------------------------------------------------
  ------ Ajouter un nouveau client a la liste chainee ------------------------
  ----------------------------------------------------------------------------
  Extrait de fbb_orb.c (f6fbb)                                                
  retour = pointeur sur la nouvelle structure OrbClient ou NULL si echec
*/   
static OrbClient *orb_add_client (void)
{
	OrbClient *sptr;

	sptr = (OrbClient*) calloc (1, sizeof (OrbClient));
	if (sptr == NULL)
		return (NULL);

	sptr->next = client_head;
	client_head = sptr;

	return (sptr);
}

/*----------------------------------------------------------------------------
  ------ Supprimer un client de la liste chainee -----------------------------
  ----------------------------------------------------------------------------
  Extrait de fbb_orb.c (f6fbb)                                                
*/   
static void orb_del_client (OrbClient * cptr)
{
	OrbClient *sptr;
	OrbClient *prev;

	prev = NULL;
	sptr = client_head;
	while (sptr)
	{
		if (sptr == cptr)
		{
			if (prev)
				prev->next = sptr->next;
			else
				client_head = sptr->next;
			free (sptr);
			break;
		}
		prev = sptr;
		sptr = sptr->next;
	}
}

/*----------------------------------------------------------------------------
  ------ Accepter une nouvelle connexion d'un client -------------------------
  ----------------------------------------------------------------------------
  Extrait de fbb_orb.c (f6fbb)                                                
  retour = 1 si OK
*/   
int FBBSRV_orb_new_connection (int fd)
{
	int addr_len;
	struct sockaddr_in sock_addr;
	OrbClient *sptr;

	sptr = orb_add_client ();

	addr_len = sizeof (sock_addr);

	sptr->fd = accept (fd, (struct sockaddr *) &sock_addr, 
		(socklen_t*) &addr_len);
	sptr->state = ORB_WAITINFO;

	return (sptr->fd);
}

/*---------------------------------------------------------------------------
 ------ Tente de connecter la console ---------------------------------------
 ----------------------------------------------------------------------------
 Retour : TRUE si OK
*/
static int console_connect (OrbClient * sptr)
{
	int nFlags;					
	
	if( IsConsoleConnected )
		return FALSE;
					
	IsConsoleConnected = TRUE;
									
	/* Charger la config utilisateur pour l'indicatif */
	USERS_openRecord(BUFFER_SCREEN2, sptr->callsign);

	/* Initialiser les filtres */
	nFlags = USERS_getFlags(BUFFER_SCREEN2);
	FILTER_setUser(BUFFER_SCREEN2, nFlags);
					
	/* Envoyer le CTEXT */
	STREAMS_ctext(BUFFER_SCREEN2);
	
	return TRUE;
}

/*---------------------------------------------------------------------------
 ------ Tente de deconnecter la console -------------------------------------
 ----------------------------------------------------------------------------
 Retour : TRUE si OK
*/
static void console_disconnect (void)
{
	int nFlags;					
	extern char STREAMS_callsign[MAX_STREAMS][10];

	IsConsoleConnected = FALSE;
				
	strcpy(STREAMS_callsign[BUFFER_SCREEN2], MyCall);
					
	/* Charger la config utilisateur pour l'indicatif */
	USERS_openRecord(BUFFER_SCREEN2, MyCall);

	/* Initialiser les filtres */
	nFlags = USERS_getFlags(BUFFER_SCREEN2);
	FILTER_setUser(BUFFER_SCREEN2, nFlags);
}

void FBBSRV_orb_process_data (OrbClient * sptr)
{
	extern char * PARAMS_sysop;
	int nb;
	static char buffer[1024];
	static int nbrcv = 0;
	char call[256];
	char pass[256];
	char *ptr;	
	int ok = FALSE;

	nb = read (sptr->fd, buffer + nbrcv, sizeof (buffer) - nbrcv);
	if (nb == -1)
		return;

	if (nb == 0)
	{
		/* Client is disconnected */
		if (sptr->mask & ORB_CONSOLE)
		{
			/* Disconnect from console */
			console_disconnect ();
		}

		close (sptr->fd);
		orb_del_client (sptr);
		nbrcv = 0;
		return;
	}

	nbrcv += nb;

	if ((nbrcv == 3) && (buffer[0] == '\0'))
	{
		int mask;
	     /*	int old_mask = sptr->mask; */
		int ack;

		/*commande */
		switch (buffer[1])
		{
		case 0:
			/* Changement de masque */
			mask = buffer[2] & 0xff;
			if ((mask & ORB_CONSOLE) != (sptr->mask & ORB_CONSOLE))
			{
				if (mask & ORB_CONSOLE)
				{
					/* Console connection */
					if( console_connect (sptr) == TRUE )
					{
						ack = 1;
					}
					else
					{
						ack = 2;
					}
				}
				else
				{
					/* Console deconnection */
					console_disconnect ();
					ack = 0;
				}
				buffer[0] = (char) ORB_XFBBX;
				buffer[1] = 0;
				buffer[2] = 1;
				buffer[3] = 0;
				buffer[4] = ack;
				write (sptr->fd, buffer, 5);
			}
			sptr->mask = mask;
		}
		nbrcv = 0;
		return;
	}

	/* Check if the whole line is received */
	buffer[nbrcv] = '\0';
	if (strchr (buffer, '\n') == NULL)
		return;

	switch (sptr->state)
	{
	case ORB_WAITINFO:

		/* Mask of services */
		sscanf (buffer, "%ld %d %s", &sptr->mask, &sptr->channel, call);
		call[11] = '\0';
		strupr(call);
		strcpy (sptr->callsign, call);
		sptr->cle = time (NULL);
		sprintf (call, "%010ld", sptr->cle);
		write (sptr->fd, call, strlen (call));
		sptr->state = ORB_WAITPASS;
		break;

	case ORB_WAITPASS:
	
		/* L'indicatif est-il declare sysop ?*/
  		strcpy(call, sptr->callsign);

  		/* Chercher d'abord pour un SSID donne*/
  		if( ! strchr(call, '-') )
    			strcat(call, "-0"); /* Ajouter le SSID -0 si besoin */
  		if( SET_check(PARAMS_sysop, call) )
    			ok = TRUE;

  		/* Chercher maintenant sans tenir compte du SSID */
  		TOOLS_removeSsid(call);
  		if( SET_check(PARAMS_sysop, call) )
    			ok = TRUE;

		/* Callsign sans SSID */
		strcpy (call, sptr->callsign);
		if ((ptr = strchr (call, '-')))
			*ptr = '\0';

		/* Password */
		sscanf (buffer, "%s", pass);

		if( ok && PASSWORD_isMDKeyOK(call, pass, sptr->cle) )
		{
			if (sptr->mask & ORB_CONSOLE)
			{
				if( console_connect (sptr) == FALSE )
				{
					char *txt = "Console already connected !\n\n";
					int len = strlen (txt) + 3;

					strcpy (buffer + 7, txt);

					/* Header */
					buffer[0] = ORB_CONSOLE;
					buffer[1] = 0;
					buffer[2] = (len) & 0xff;
					buffer[3] = (len) >> 8;

					buffer[4] = ORB_CONSOLE;
					buffer[5] = W_CNST;
					buffer[6] = 0;

					write (sptr->fd, buffer, len + 4);
					close (sptr->fd);
					orb_del_client (sptr);
				}
			}
			sptr->state = ORB_CONNECTED;
		}
		else
		{
			char *txt = "Callsign/Password error !\n\n";
			int len = strlen (txt) + 3;

			strcpy (buffer + 7, txt);

			/* Header */
			buffer[0] = ORB_CONSOLE;
			buffer[1] = 0;
			buffer[2] = (len) & 0xff;
			buffer[3] = (len) >> 8;

			buffer[4] = ORB_CONSOLE;
			buffer[5] = W_CNST;
			buffer[6] = 0;

			write (sptr->fd, buffer, len + 4);
			close (sptr->fd);
			orb_del_client (sptr);
		}
		break;

	case ORB_CONNECTED:

		if (sptr->mask & ORB_CONSOLE)
		{
			TOOLS_removeNR(buffer);
			CMD_execute(BUFFER_SCREEN2, buffer);
		}

		break;
	}

	nbrcv = 0;
}

/*----------------------------------------------------------------------------
  ------ Initialisation du socket destine aux consoles -----------------------
  ----------------------------------------------------------------------------
  Extrait de fbb_orb.c (f6fbb)                                                 
  Retour : 1 si OK
*/
int FBBSRV_initOrb (int port)
{
	int val;
	int len;
	struct sockaddr_in sock_addr;

	if ((orb_fd = socket (AF_INET, SOCK_STREAM, 0)) < 0)
	{
		perror ("socket_r");
		return (0);
	}

	val = 1;
	len = sizeof (val);
	if (setsockopt (orb_fd, SOL_SOCKET, SO_REUSEADDR, (char *) &val, len) == -1)
	{
		perror ("opn_tcp : setsockopt SO_REUSEADDR");
	}

	sock_addr.sin_family = AF_INET;
	sock_addr.sin_addr.s_addr = 0;
	sock_addr.sin_port = htons (port);

	if (bind (orb_fd, (struct sockaddr *) &sock_addr, sizeof (sock_addr)) != 0)
	{
		perror ("opn_tcp : bind");
		close (orb_fd);
		return (0);
	}

	if (listen (orb_fd, SOMAXCONN) == -1)
	{
		perror ("listen");
		close (orb_fd);
		return (0);
	}
	
	printf("xfbbC/X/W server running on port %d ...\n", port);

	return (1);
}

/*----------------------------------------------------------------------------
  ------ Envoyer des datas a la console --------------------------------------
  ----------------------------------------------------------------------------
  Extrait de fbb_orb.c (f6fbb)                                                 
*/
void FBBSRV_orbWrite (int channel, char *data, int len, int color, int header)
{
	int i, j;
	char *buffer;

	buffer = (char*) malloc (len + 8);
	if (buffer == NULL)
		return;

	for (i = 0, j = 7; i < len; i++)
	{
		if (data[i] == '\n')
			continue;

		if (data[i] == '\r')
			buffer[j++] = '\n';
		else
			buffer[j++] = data[i];
	}

	if (channel == _CONSOLE)
	{
		/* Header */
		buffer[0] = ORB_CONSOLE;
		buffer[1] = 0;
		buffer[2] = (j - 4) & 0xff;
		buffer[3] = (j - 4) >> 8;

		/* Envoie les data de console au client */
		buffer[4] = _CONSOLE;
		buffer[5] = color;
		buffer[6] = header;
		orb_send_data (buffer, j, ORB_CONSOLE);
	}
	else if (channel == _MONITOR)
	{
		/* Header */
		buffer[0] = ORB_MONITOR;
		buffer[1] = 0;
		buffer[2] = (j - 4) & 0xff;
		buffer[3] = (j - 4) >> 8;

		/* Envoie les data de monitoring au client */
		buffer[4] = (char) 0xff;
		buffer[5] = color;
		buffer[6] = header;
		orb_send_data (buffer, j, ORB_MONITOR);
	}
	else
	{
		/* Header */
		buffer[0] = ORB_CHANNEL;
		buffer[1] = 0;
		buffer[2] = (j - 4) & 0xff;
		buffer[3] = (j - 4) >> 8;

		/* Envoie les data de monitoring au client */
		buffer[4] = channel - 1;
		buffer[5] = color;
		buffer[6] = header;
		orb_send_data (buffer, j, ORB_CHANNEL);
	}
	free (buffer);
}

/*---------------------------------------------------------------------------
  ------ SWITCH_isConsoleConnected - Indique si la console est connectee ----
  ------ via TCP/IP ---------------------------------------------------------
  ---------------------------------------------------------------------------*/
int FBBSRV_isConsoleConnected(void)
{
	return IsConsoleConnected;
}

#define LINEMAX STREAMS_level[StreamNum] & LEVEL_cluster ? 66 : 80

/*----------------------------------------------------------------------------
  ------ Transmet le monitoring aux clients fbb ------------------------------
  ----------------------------------------------------------------------------*/
void FBBSRV_monitor(int StreamNum, char * pszString, int nSize, int Direction)
{
	extern char STREAMS_level[MAX_STREAMS];
	extern char STREAMS_callsign[MAX_STREAMS][10];
	extern char PROTOCOL_linkType[65];
	
#if 0
	static char szOldHeader[256];
	
	char szHeader[256];
	char szBuffer[1024];
	int  nChannel;
	int  nIsClulink = FALSE;
	
	if( STREAMS_callsign[StreamNum][0] == '\0' )
		SCRIPT_getLinkSetupCall(StreamNum, szBuffer);
	else
		strcpy(szBuffer, STREAMS_callsign[StreamNum]);
			
	if( Direction == 0 ) /* IN */
		sprintf(szHeader, "%s > %s:\r", szBuffer, MyCall);
	else /* OUT */
		sprintf(szHeader, "%s > %s:\r",	MyCall, szBuffer);
	
	if( STREAMS_level[StreamNum] & LEVEL_cluster || 
	    STREAMS_level[StreamNum] & LEVEL_linkSetup )
		nChannel = _MONITOR;
	else
		nChannel = _ALLCHAN;
		
	if( STREAMS_level[StreamNum] & LEVEL_cluster )
	{
		nChannel = _MONITOR;
		if( PROTOCOL_linkType[StreamNum] == CLU_LINK )
			nIsClulink = TRUE;
	}
	else
		nChannel = _ALLCHAN;
		
	if( strcmp(szOldHeader, szHeader) )
	{
		SWITCH_orbWrite (nChannel, szHeader, strlen(szHeader), 0, 0);
		strcpy(szOldHeader, szHeader);
	}

	if( nIsClulink )
	{
		int  i;
		char *ptr;
		sprintf(szBuffer, "<CLU%03d>", pszString[1]);
		ptr = strchr(szBuffer, '\0');
		for(i = 0; i < nSize; i++)	
		{
			char szByte[16];
			sprintf(szByte, "%02x", (unsigned char) pszString++);
			strupr(szByte);
			*ptr++ = ' ';
			*ptr++ = szByte[0];
			*ptr++ = szByte[1];

		}
		*ptr++ = '\r';
		*ptr++ = '\0';
		
		nSize = strlen(szBuffer);
	}
	else
	{
		strncpy(szBuffer, pszString, nSize);
		szBuffer[nSize] = '\0';
		TOOLS_N2R(szBuffer);
	}
	SWITCH_orbWrite (nChannel, szBuffer, nSize, 3, 0);
#endif

	static int  nPutHeader          = TRUE;
	static int  nMonitorLineSize    = 0;
	static int  nAllChannelLineSize = 0;
	static char szHeaderOld[32];	
	char szBuffer[256];
	char szHeader[32];
	int  len;
	int  index;
	int  nLineMax;
	int  nChannel;
	int  nLineSize = 0;
	
	/* Call du correspondant */
	if( STREAMS_callsign[StreamNum][0] == '\0' )
	{
		SCRIPT_getLinkSetupCall(StreamNum, szBuffer);
		if( szBuffer[0] == '\0' )
			strcpy(szBuffer, "NOCALL");
	}
	else
		strcpy(szBuffer, STREAMS_callsign[StreamNum]);
		
	if( Direction == 0 ) 
		sprintf(szHeader, "%s->", szBuffer);	/* IN */
	else 
		sprintf(szHeader, "%s<-", szBuffer);	/* OUT */
		
	len = strlen(szHeader);
	for(index = len; index < 11; index++)
		szHeader[index] = ' ';
	szHeader[index] = '\0';
		
	if( STREAMS_level[StreamNum] & LEVEL_cluster )
	{
		nChannel = _MONITOR;
		strcat(szHeader, ":");

		if( strcmp(szHeader, szHeaderOld) )
			nLineMax = 66 - nMonitorLineSize;
		else
			nLineMax = 66;
		nMonitorLineSize = 0;
	}
	else
	{
		nChannel = _ALLCHAN;
		strcat(szHeader, "\r");

		if( strcmp(szHeader, szHeaderOld) )
			nLineMax = 80 - nAllChannelLineSize;
		else
			nLineMax = 80;
	}

	for(index = 0; index < nSize; index++)
	{
		if( nPutHeader == TRUE )
		{
			if( nChannel == _ALLCHAN )
			{
				if( strcmp(szHeader, szHeaderOld) )
				{
					FBBSRV_orbWrite(nChannel, szHeader, strlen(szHeader), 3, 0);
					strcpy(szHeaderOld, szHeader);
				}
			}
			else
				FBBSRV_orbWrite(nChannel, szHeader, strlen(szHeader), 3, 0);
			nPutHeader = FALSE;
		}
		
		if( *pszString == '\n' )
			szBuffer[nLineSize++] = '\r';
		else
			szBuffer[nLineSize++] = *pszString;
					
		if( *pszString == '\r' || *pszString == '\n' )
		{
			FBBSRV_orbWrite(nChannel, szBuffer, nLineSize, 3, 0);
			nLineSize = 0;
			nPutHeader = TRUE;
			nLineMax = LINEMAX;
		}
		else if( nLineSize >= nLineMax )
		{
			FBBSRV_orbWrite(nChannel, szBuffer, nLineSize, 3, 0);
			if( nChannel == _ALLCHAN )
				FBBSRV_orbWrite(nChannel, "\r", 1, 3, 0);
			else
				FBBSRV_orbWrite(nChannel, "\r            ", 13, 3, 0);
			nLineSize = 0;
			nLineMax = LINEMAX;
		}
		
		pszString++;
	}
	
	if( nLineSize != 0 )
	{
		FBBSRV_orbWrite(nChannel, szBuffer, nLineSize, 3, 0);

		if( STREAMS_level[StreamNum] & LEVEL_cluster )
			nMonitorLineSize = nLineSize;
		else
			nAllChannelLineSize = nLineSize;
	}

}
