#include <alloc.h>
#include <dos.h>
#include <stdlib.h>
#include <string.h>
#include <dir.h>
#include <io.h>
#include <stdio.h>
#include <fcntl.h>
#include <sys\stat.h>
#include <process.h>
#include "dos.h"
#include "buffers.h"
#include "define.h"
#include "commands.h"
#include "tools.h"
#include "cstatut.h"
#include "medit.h"

#define STDOUT 1
#define STDERR 2

static char * DOS_pszPath[MAX_STREAMS];    	/* Path courrant de l'utilisateur */
static char * DOS_pszFileName[MAX_STREAMS];	/* Nom du fichier lors d'un PUT */
/*------------------------------------------------------------------------
  ------ Initialisation du mode DOS --------------------------------------
  ------------------------------------------------------------------------
  Retour : TRUE si OK et FALSE sinon                                      */
void DOS_init(void)
{
	int i;

	for(i = 0; i < MAX_STREAMS; i++)
	{
		DOS_pszPath[i]     = NULL;
		DOS_pszFileName[i] = NULL;
	}
}


/*------------------------------------------------------------------------
  ------ Entree dans le mode DOS -----------------------------------------
  ------------------------------------------------------------------------
  Retour : TRUE si OK et FALSE sinon                                      */
int DOS_start(int StreamNum)
{
	if( DOS_pszPath[StreamNum] != NULL )
	{
		BUFFERS_addBuff(StreamNum, "DOS_error #1 : please contact f5mzn@imaginet.fr !\n", OUT);
		free(DOS_pszPath[StreamNum]);
	}

	/* Reserver de la memoire pour le path */
	DOS_pszPath[StreamNum] = (char*) malloc(MAXPATH);
	if( DOS_pszPath[StreamNum] == NULL )
	{
		BUFFERS_addBuff(StreamNum, "Not enough memory.\n", OUT);
		return FALSE;
	}

	/* Path courant */
	if( DOS_getCurrentDir(DOS_pszPath[StreamNum]) == -1 )
		return DOS_error(StreamNum);

	/* Affichage du prompt */
	DOS_prompt(StreamNum);

	return TRUE;
}

/*------------------------------------------------------------------------
  ------ Creer le fichier qui va recevoir les lignes de texte suite ------
  ------ a un PUT --------------------------------------------------------
  ------------------------------------------------------------------------
  Retourne TRUE si OK                                                     */
int DOS_put_create(int StreamNum, char * pszFileName)
{
	FILE * fPtr;
	extern unsigned long COMMANDS_statut[MAX_STREAMS];

	/* Reserver la memoire pour le nom de fichier */
	if( DOS_pszFileName[StreamNum] != NULL )
	{
		BUFFERS_addBuff(StreamNum, "DOS_error #2 : please contact f5mzn@imaginet.fr !\n", OUT);
		free(DOS_pszFileName[StreamNum]);
	}

	DOS_pszFileName[StreamNum] = (char*) malloc(strlen(pszFileName) + 1);
	if( DOS_pszFileName[StreamNum] == NULL )
	{
		BUFFERS_addBuff(StreamNum, "Not enough memory.\n", OUT);
		return FALSE;
	}

	strcpy(DOS_pszFileName[StreamNum], pszFileName);

	/* Essayer de creer le fichier */
	fPtr = fopen(pszFileName, "wt");
	if( fPtr == NULL )
	{
		BUFFERS_addBuff(StreamNum, "*** Error : can't create file !\n", OUT);
		free(DOS_pszFileName[StreamNum]);
		return FALSE;
	}
	fclose(fPtr);

	/* Message a l'utilisateur */
	BUFFERS_addBuff(StreamNum, "Type CTRL-Z or /EXit on a single line to end >\n",
			OUT);

	COMMANDS_statut[StreamNum] |= COMMANDS_statutDOS_putfile;
	return TRUE;
}

/*------------------------------------------------------------------------
  ------ Ajouter du texte dans le fichier (commande PUT) -----------------
  ------------------------------------------------------------------------
  Return TRUE si OK                                                       */
int DOS_put_addtext(int StreamNum, char * pszBuffer)
{
	FILE *fPtr;
	extern unsigned long COMMANDS_statut[MAX_STREAMS];

	/* fin de transfert ? */
	if( CSTATUT_isExit(pszBuffer) )
	{
		DOS_put_end(StreamNum);
		return TRUE;
	}

	if( DOS_pszFileName[StreamNum] == NULL )
	{
		BUFFERS_addBuff(StreamNum, "DOS_error #3 : please contact f5mzn@imaginet.fr !\n", OUT);
		COMMANDS_statut[StreamNum] &= ~COMMANDS_statutDOS_putfile;
		return FALSE;
	}

	/* Ouvrir le fichier */
	fPtr = fopen(DOS_pszFileName[StreamNum], "a+t");
	if( fPtr == NULL )
	{
		DOS_put_end(StreamNum);
		return FALSE;
	}

	/* Ajouter la ligne de texte */
	fprintf(fPtr, "%s\n", pszBuffer);

	/* Fermer le fichier et quitter */
	fclose(fPtr);
	return TRUE;
}

/*------------------------------------------------------------------------
  ------ Terminer la reception d'un fichier texte (commande PUT) ---------
  ------------------------------------------------------------------------*/
void DOS_put_end(int StreamNum)
{
	extern unsigned long COMMANDS_statut[MAX_STREAMS];

	/* Liberer le buffer memoire */
	if( DOS_pszFileName[StreamNum] != NULL )
		free(DOS_pszFileName[StreamNum]);

	DOS_pszFileName[StreamNum] = NULL;

	COMMANDS_statut[StreamNum] &= ~COMMANDS_statutDOS_putfile;
}

/*------------------------------------------------------------------------
  ------ Copier le directory courant -------------------------------------
  ------------------------------------------------------------------------
  Retourne -1 si erreur                                                   */
int DOS_getCurrentDir(char * pszDirectory)
{
	strcpy(pszDirectory, "X:\\");
	pszDirectory[0] = 'A' + getdisk();
	return getcurdir(0, pszDirectory + 3);
}

/*------------------------------------------------------------------------
  ------ Sortie du mode DOS ----------------------------------------------
  ------------------------------------------------------------------------*/
void DOS_exit(int StreamNum)
{
	if( DOS_pszPath[StreamNum] == NULL )
		return;

	/* Liberer la memoire */
	free(DOS_pszPath[StreamNum]);
	DOS_pszPath[StreamNum] = NULL;
}


/*------------------------------------------------------------------------
  ------ Affichage du prompt ---------------------------------------------
  ------------------------------------------------------------------------*/
void DOS_prompt(int StreamNum)
{
	BUFFERS_printBuff(StreamNum, OUT, "%s>\n", DOS_pszPath[StreamNum]);
}

/*------------------------------------------------------------------------
  ------ Executer une commande DOS ---------------------------------------
  ------------------------------------------------------------------------*/
int DOS_commands(int StreamNum, char * pszString)
{
	char  szCurrentDir[MAXPATH]; /* Sauvegarde du directory courrant */
	char *pszUserDir;            /* Pointeur vers le repertoire USER */
	char  szCommand[64];
	char *ptr;
	int   nResult = -1;

	extern unsigned long COMMANDS_statut[MAX_STREAMS];

	if( ! (COMMANDS_statut[StreamNum] & COMMANDS_statutDOS_putfile) &&
	    ! (COMMANDS_statut[StreamNum] & COMMANDS_statutMEdit) )
	{
		if( pszString[0] == SNULL )
		{
			/* Chaine vide ... n'a rien a faire ... */
			DOS_prompt(StreamNum);
			return TRUE;
		}

		/* Extraire la commande */
		strncpy(szCommand, pszString, 63);
		TOOLS_maxLength(szCommand, 63);
		ptr = strchr(szCommand, ' ');
		if( ptr )
			*ptr = SNULL;

		/* Fin du mode DOS ? */
		if( ! strcmp(szCommand, "exit") )
		{
			/* Liberer la memoire et sortir du mode DOS */
			DOS_exit(StreamNum);
			return FALSE;
		}
	}

	/* Se placer dans le directory de l'utilisateur */
	pszUserDir = DOS_pszPath[StreamNum];
	DOS_getCurrentDir(szCurrentDir);	/* Sauvegarde du dir courrant */
	if( chdir(pszUserDir) == -1 )
		return DOS_error(StreamNum);

	/* Executer les commandes */
	if( COMMANDS_statut[StreamNum] & COMMANDS_statutDOS_putfile )
	{
		DOS_put_addtext(StreamNum, pszString);
		nResult = 0;
	}
	else if( COMMANDS_statut[StreamNum] & COMMANDS_statutMEdit )
	{
		if( MEDIT_commands(StreamNum, pszString) == FALSE )
			COMMANDS_statut[StreamNum] &= ~COMMANDS_statutMEdit;
		nResult = 0;
	}

	else
	if( ! strcmp(szCommand, "dir")   || ! strcmp(szCommand, "copy")  ||
	    ! strcmp(szCommand, "md")    || ! strcmp(szCommand, "rd")    ||
	    ! strcmp(szCommand, "del")   || ! strcmp(szCommand, "type")  ||
	    ! strcmp(szCommand, "move")  || ! strcmp(szCommand, "mem")   ||
	    ! strcmp(szCommand, "mkdir") || ! strcmp(szCommand, "rmdir") ||
	    ! strcmp(szCommand, "ren")   || ! strcmp(szCommand, "rename")||
	    ! strcmp(szCommand, "cd")    || ! strcmp(szCommand, "type") )
	{
		nResult = DOS_system(StreamNum, pszString);
	}
	else if( ! strcmp(szCommand, "run") && ptr )
	{
		/* Executer une commande autre ... */
		nResult = DOS_system(StreamNum, ++ptr);
	}
	else if( strlen(szCommand) == 2 && szCommand[0] >= 'a'&&
		 szCommand[0] <= 'z' && szCommand[1] == ':' )
	{
		DOS_system(StreamNum, szCommand);
		nResult = 0;
	}
	else if( ! strcmp(szCommand, "get") && ptr )
	{
		char szBuffer[256];

		sprintf(szBuffer, "TYPE %s", ++ptr);
		nResult = DOS_system(StreamNum, szBuffer);
	}
	else if( ! strcmp(szCommand, "put") )
	{
		if( ptr )
			DOS_put_create(StreamNum, ++ptr);
		else
			BUFFERS_addBuff(StreamNum, "Missing file name !\n", OUT);

		nResult = 0;
	}
	else if( COMMANDS_check(szCommand, "medit", strlen(szCommand), 3) )
	{
		if( MEDIT_start(StreamNum, ++ptr) )
			COMMANDS_statut[StreamNum] |= COMMANDS_statutMEdit;
		nResult = 0;
	}

	/* Au cas ou le repertoire aurait change ... */
	DOS_getCurrentDir(pszUserDir);

	/* Retourner au directory d'origine */
	if( chdir(szCurrentDir) == -1 )
		return DOS_error(StreamNum);

	/* Erreur, commande inconnue */
	if( nResult < 0 )
		DOS_system(StreamNum, "-syntax error-");

	if( ! (COMMANDS_statut[StreamNum] & COMMANDS_statutDOS_putfile) &&
	    ! (COMMANDS_statut[StreamNum] & COMMANDS_statutMEdit))
		DOS_prompt(StreamNum);
	return TRUE;
}

/*------------------------------------------------------------------------
  ------ Erreur inantendue ... -------------------------------------------
  ------------------------------------------------------------------------*/
int DOS_error(int StreamNum)
{
	/* Erreur : sortie du mode DOS */
	BUFFERS_addBuff(StreamNum, "Unexpected error !\n", OUT);
	DOS_exit(StreamNum);
	return FALSE;
}

/*------------------------------------------------------------------------
  ------ Appel systeme ---------------------------------------------------
  ------------------------------------------------------------------------*/
int DOS_system(int StreamNum, char * pszCommand)
{
	char *tmpFileNameOUT;	/* nom du fichier temp pour STDOUT */
	char *tmpFileNameERR;	/* nom du fichier temp pour STDOUT */
	int   nExitCode;
	int   fd, fd_out, fd_err;
	int   oldstdout, oldstderr;
	int   i;

	/* Preparer les fichiers temporaires */
	tmpFileNameOUT = tempnam("/tmp", "out");
	if( tmpFileNameOUT == NULL )
		return -1;
	tmpFileNameERR = tempnam("/tmp", "err");
	if( tmpFileNameERR == NULL )
	{
		free( tmpFileNameOUT );
		return -1;
	}


	/* Vrifier que les fichiers temporaires peuvent tre ouverts */
	fd_out = open(tmpFileNameOUT, O_CREAT | O_RDWR, S_IREAD|S_IWRITE);
	fd_err = open(tmpFileNameERR, O_CREAT | O_RDWR, S_IREAD|S_IWRITE);
	if( fd_out < 0 || fd_err < 0 )
	{
		if( fd_out >= 0 )
			close( fd_out );
		if( fd_err >= 0 )
			close( fd_err );
		free(tmpFileNameOUT);
		free(tmpFileNameERR);
		return -1;
	}

	/* Dupliquer un handle pour la sortie standard */
	oldstdout = dup( STDOUT );
	oldstderr = dup( STDERR );

	/* Rediriger la sortie standard */
	dup2(fd_out, STDOUT );
	dup2(fd_err, STDERR );

	/* Fermer les handles */
	close( fd_out );
	close( fd_err );

	/* Executer l'appel systeme */
	nExitCode = system(pszCommand);

	/* Restaurer le handle d'origine et fermer le fichier */
	dup2(oldstdout, STDOUT);
	close(oldstdout);
	dup2(oldstderr, STDERR);
	close(oldstderr);

	/* Renvoyer le retour  l'utilisateur */
	for(i = 0; i < 2; i++)
	{
		char *ptr;

		if( i == 0 )
			ptr = tmpFileNameOUT;
		else
			ptr = tmpFileNameERR;

		if( (nExitCode) >= 0 && (fd = open(ptr, O_RDONLY)) != 0 )
		{
			int  nb;
			char szBuffer[256];

			for(;;)
			{
				nb = read(fd, szBuffer, 250);
				if( nb <= 0 )
					break;
				BUFFERS_addBuff_sized(StreamNum, szBuffer,
						      OUT, nb);
			}

			close( fd );
		}
	}

	/* Retourner */
	unlink(tmpFileNameOUT);
	unlink(tmpFileNameERR);
	free(tmpFileNameOUT);
	free(tmpFileNameERR);
	return nExitCode;
}

/*------------------------------------------------------------------------
  ------ Faire le menage (en cas de deconnexion de l'utilisateur ---------
  ------ par exemple) ----------------------------------------------------
  ------------------------------------------------------------------------*/
void DOS_clean(int StreamNum)
{
	DOS_put_end(StreamNum);
	DOS_exit(StreamNum);
}
