#include <alloc.h>
#include <stdio.h>
#include <string.h>
#include <conio.h>
#include <dos.h>
#include <time.h>
#include "display.h"
#include "console.h"
#include "define.h"
#include "node.h"
#ifdef DOS
extern "C" {
#include "com.h"
}
#endif

extern	long	PARAMS_lTz;

//--------------------------------------------------------------------------
//------ Ce module gre l'affichage des diffrentes fentres sur l'cran ---
//------ de la console -----------------------------------------------------
//--------------------------------------------------------------------------
//
//--------------------------------------------------------------------------
//------ Descriptions des crans et des fonctions associes ----------------
//--------------------------------------------------------------------------
/* 	Ecran 1	(touche F1) : Deux fentres apparaissent  l'cran :

				a) En haut, fentre monitoring (cette
				   fentre est prsente sur tous les
				   crans sauf le n 2)

				-- BARRE DE STATUS --

				b) Les commandes excutes par DxNet

	Ecran 2 (touche F2) : uniquement le monitoring.

	Ecran 3 (touche F3) : Console SYSOP - trois fentres apparaissent
			       l'cran :

				a) En haut, fentre monitoring.

				-- BARRE DE STATUS --

				b) Au milieu, les rponses aux commandes
				   saisies.

				c) En bas, les commandes tapes par
				   le sysop.

	Ecran 4 (touche F4) : Connection au switch - trois fentres
			      apparaissent  l'cran :

				a) En haut, fentre monitoring.

				-- BARRE DE STATUS --

				b) Au milieu, ce qui arrive en provenance
				   du switch.

				c) En bas, les commandes saisies par
				   le sysop.

	Ecran 5 (touche F5) : Ecran noir (mode de veille)

*/

//---------------------------------------------------------------------------
//------ Variables externes -------------------------------------------------
//---------------------------------------------------------------------------
extern int	NODE_iNodes,
		NODE_iLocalUsers,
		NODE_iTotalUsers,
		NODE_iMaxUsers;

//---------------------------------------------------------------------------
//------ Variables globales communes  ce module ----------------------------
//---------------------------------------------------------------------------
int StatPos = 10; 		//Position de la barre de status
int PosX[4] = {0,0,0,0};	//Position courante du curseur
int PosY[4] = {0,0,0,0};	//Position courante du curseur
int MonitorX[4] = {0,0,0,0};	//Position courante du curseur
int MonitorY[4] = {0,0,0,0};	//Position courante du curseur
int CursorX[2]  = {0,0};         //Position VISUELLE du curseur (fentre 2 et 3)
//Ordre des couleurs : RUN-SYSOP-SWITCH-MONITOR-STATUS-INPUT
int ColorBG[6]      = {BLUE,   BLUE,   BLUE,   BLACK, RED,   LIGHTGRAY};
int ColorTXT_Out[6] = {YELLOW, YELLOW, YELLOW, WHITE, WHITE, BLACK};
int ColorTXT_In[6]  = {WHITE,  WHITE,  YELLOW, WHITE, WHITE, BLACK};


//---------------------------------------------------------------------------
//------ Initialisation des crans ------------------------------------------
//---------------------------------------------------------------------------
void DISP_InitDisplay(int LineMode)
{
  int index;
 
  //------ Dfinir le nombre de ligne ------
  switch( LineMode )
  {
    case 43 :
	CON_set43LineMode();
	break;
    case 50 :
	CON_set50LineMode();
	break;
    default :
	CON_set25LineMode();
	break;
  }//END Switch

  //------ Initialiser l'affichage ------
  CON_init();
  for(index = 0; index < 4; index++)
    DISP_PutsConsole(index, "\f", COLOR_IN);

  DISP_PutsInputString(SCREEN2, "", 0);
  DISP_PutsInputString(SCREEN3, "", 0);

}

//---------------------------------------------------------------------------
//------ Afficher une chaine  l'cran --------------------------------------
//---------------------------------------------------------------------------
void DISP_PutsConsole(int Window, char * String, int ColorDirection)
{
  int index;
  int PutCR;
  static int Eol[4];

  /* Port redirige ? */
  if( Window == SCREEN3 && COM_getConsoleNum() == 3 )
	COM_puts(String);

  //Effacer le curseur pour amliorer la qualit de l'affichage
  CON_cursorOff();

  //Il ne faut pas afficher de CR en fin de ligne, pour viter de perdre
  //une ligne dans la fentre monitoring
  PutCR = ( Eol[Window] ? TRUE : FALSE );
  if( String[strlen(String) - 1] == '\n' )
  {
    String[strlen(String) - 1] = SNULL;
    Eol[Window] = TRUE;
  }
  else
  {
    Eol[Window] = FALSE;
  }

  //------ L'affichage du monitoring prsente une particularit ------
  if( Window != MONITOR )
  {
    CON_setActivePage( Window );
    CON_setWindow(0, StatPos+1, 79, CON_screenHeight()-2 );
    CON_gotoxy(PosX[Window], PosY[Window] );

    DISP_SetColor(Window, ColorDirection);

    //Ajouter un CR en dbut de ligne au cas o celui-ci est t strap
    //lors du dernier affichage (en fin de ligne)
    if( PutCR )
      CON_puts( "\n" );

    CON_puts( String );
    PosX[Window] = CON_wherex();
    PosY[Window] = CON_wherey();
  }
  else
  {
    //Dans le cas du monitoring, il faut afficher sur les quatres crans
    for(index = 0; index < 4; index++)
    {
	CON_setActivePage( index );

	//Sur l'cran MONITOR, la fentre prend tout l'cran
	if( index == SCREEN4 )
	  CON_setWindow(0, 0, 79, CON_screenHeight() );
	else
	  CON_setWindow(0, 0, 79, StatPos-1 );

	CON_gotoxy(MonitorX[index], MonitorY[index] );
	DISP_SetColor(Window, ColorDirection);

	//Ajouter un CR en dbut de ligne au cas o celui-ci est t strap
	//lors du dernier affichage (en fin de ligne)
	if( PutCR )
	  CON_puts( "\n" );

	CON_puts( String );
	MonitorX[index] = CON_wherex();
	MonitorY[index] = CON_wherey();
    }	//END For
  }	//END If

  DISP_DispCursor(); //positionner le curseur
}

//--------------------------------------------------------------------------
//------ Dfinir quel cran est actif --------------------------------------
//--------------------------------------------------------------------------
void DISP_SetActiveScreen(int ActiveScreen )
{
  if( ActiveScreen >= 0 && ActiveScreen < 4 )
    CON_setVisualPage( ActiveScreen );

  DISP_DispCursor(); //positionner le curseur
}

//--------------------------------------------------------------------------
//------ Connatre quel cran est actif ------------------------------------
//--------------------------------------------------------------------------
int DISP_GetActiveScreen(void)
{
  return CON_getVisualPage();
}

//--------------------------------------------------------------------------
//------ Afficher la ligne de status ---------------------------------------
//--------------------------------------------------------------------------
void DISP_PutStat(void)
{
  char 		String[80];
  int 		index;
  time_t	timer;
  struct    tm *sdate;

//  int	Heures,
//	Minutes,
//	Secondes;

  //Effacer le curseur pour amliorer la qualit de l'affichage
  CON_cursorOff();
  DISP_SetColor(STATUS, COLOR_OUT);

//  //Quelle est la config ?
//  NODE_getConfig(iNodes, iLocalUsers, iTotalUsers, iMaxUsers);

  //Quelle heure est-il ?
//  _AH = 0x2C;
//  geninterrupt(0x21);
  timer = time(NULL) - PARAMS_lTz;
  sdate = localtime(&timer);

//  sprintf(String, "%02d:%02d:%02d - Cluster %d nodes, %d local / %d total users - Max users %d     ", _CH, _CL, _DH, NODE_iNodes, NODE_iLocalUsers, NODE_iTotalUsers, NODE_iMaxUsers);
  sprintf(String, "%02d:%02d:%02d - Cluster %d nodes, %d local / %d total users - Max users %d     ", sdate->tm_hour, sdate->tm_min, sdate->tm_sec, NODE_iNodes, NODE_iLocalUsers, NODE_iTotalUsers, NODE_iMaxUsers);

  for(index = 0; index < 3; index++)
  {
    CON_setActivePage( index );
    CON_setWindow(0, 0, 79, CON_screenHeight() );
    CON_gotoxy(0, StatPos);
    CON_puts( String );
    CON_clreol();
  }

  DISP_DispCursor(); //positionner le curseur
}

//---------------------------------------------------------------------------
//------ Afficher la chaine de saisie ---------------------------------------
//---------------------------------------------------------------------------
void DISP_PutsInputString(int Window, char * String, int CursorPos)
{
  //Effacer le curseur pour amliorer la qualit de l'affichage
  CON_cursorOff();

  CON_setActivePage( Window );
  CON_setWindow(0, CON_screenHeight()-1, 79, CON_screenHeight() );
  DISP_SetColor(INPUT, COLOR_OUT);

  CON_puts( "\f" );
  CON_puts( String );

  //Positionner le curseur
  if( Window == SCREEN2 )
    CursorX[0] = CursorPos;
  else
  if( Window == SCREEN3 )
    CursorX[1] = CursorPos;

  DISP_DispCursor(); //positionner le curseur
}

//---------------------------------------------------------------------------
//------ Afficher le curseur (si ncessaire) --------------------------------
//---------------------------------------------------------------------------
void DISP_DispCursor(void)
{
  //Afficher le curseur si l'cran actif est SCREEN2 ou SCREEN3
  //et l'effacer sinon
  //Le curseur s'affiche dans la fentre de saisie rserve au sysop
  if( CON_getVisualPage() == SCREEN2 )
  {
    CON_setActivePage( SCREEN2 );
    CON_setWindow(0, CON_screenHeight()-1, 79, CON_screenHeight() );
    CON_gotoxy(CursorX[0], 0);
    CON_setCursor(CON_CURSOR_NORMAL);
  }
  else
  if( CON_getVisualPage() == SCREEN3 )
  {
    CON_setActivePage( SCREEN3 );
    CON_setWindow(0, CON_screenHeight()-1, 79, CON_screenHeight() );
    CON_gotoxy(CursorX[1], 0);
    CON_setCursor(CON_CURSOR_NORMAL);
  }
  else
  {
    CON_cursorOff();
  }
}

//---------------------------------------------------------------------------
//------ Monter la barre de status ------------------------------------------
//---------------------------------------------------------------------------
void DISP_StatRowUp(void)
{
  int index;

  if( StatPos > 0 )
  {
    for(index = 0; index < 3; index++)
    {
      CON_setActivePage(index);
      CON_setWindow(0, 0, 79, CON_screenHeight() );
      CON_gotoxy(0, StatPos);
      DISP_SetColor(index, COLOR_OUT);
      CON_clreol();

      //Faire un scrolling de la partie du milieu de l'cran
      CON_setWindow(0, StatPos, 79, CON_screenHeight()-2 );
      CON_scroll(CON_SCROLL_UP, 1);

      //Faire un scrolling du monitoring
      CON_setWindow(0, 0, 79, StatPos-1 );
      CON_scroll(CON_SCROLL_UP, 1);
      MonitorY[index]--;
    }
    StatPos--;
  }
  DISP_PutStat();
}

//---------------------------------------------------------------------------
//------ Descendre la barre de status ---------------------------------------
//---------------------------------------------------------------------------
void DISP_StatRowDown(void)
{
  int index;
 
  if( StatPos < CON_screenHeight() - 5 )
  {
    for(index = 0; index < 3; index++)
    {
      CON_setActivePage(index);
      CON_setWindow(0, 0, 79, CON_screenHeight() );
      CON_gotoxy(0, StatPos);
      DISP_SetColor(MONITOR, COLOR_OUT);
      CON_clreol();

      //Faire un scrolling de la partie du milieu de l'cran
      if( (PosY[index] + StatPos + 3) < CON_screenHeight() )
      {
	CON_setWindow(0, StatPos, 79, CON_screenHeight()-2 );
	CON_scroll(CON_SCROLL_DOWN, 1);
      }else
	PosY[index]--;

      //Faire un scrolling du monitoring
      CON_setWindow(0, 0, 79, StatPos-1 );
      CON_scroll(CON_SCROLL_DOWN, 1);
      MonitorY[index]++;

    }
    StatPos++;
  }
  DISP_PutStat();
}

//---------------------------------------------------------------------------
//------ Dfinir les couleurs pour cette fentre ----------------------------
//---------------------------------------------------------------------------
void DISP_SetColor(int Window, int ColorDirection)
{
  int Attr;

  if( ColorDirection )	//Message gnr par DxNet (COLOR_OUT)
    Attr = ((ColorBG[Window] & 0x0F) << 4) | (ColorTXT_Out[Window] & 0x0F);
  else			//Message gnr par le SYSOP (COLOR_IN)
    Attr = ((ColorBG[Window] & 0x0F) << 4) | (ColorTXT_In[Window] & 0x0F);

  CON_setAttr( Attr );
  CON_setBackground(Attr, ' ');
}