#include <alloc.h>
#include <dir.h>
#include <stdio.h>
#include <string.h>
#include <dos.h>
#include <stdlib.h>
#include "define.h"
#include "tools.h"
#include "database.h"
#include "message.h"
#include "buffers.h"
#include "users.h"
#include "commands.h"
#include "sys/stat.h"
#include "execute.h"
#include "node.h"
#include "protocol.h"
extern "C" {
#include "memory.h"
}

/* FORMAT DES FICHIERS DE CONFIGURATION
   *** LOCAL.DAT ***
   COMMAND	FILENAME	<CHAIN TO>
   QSL		QSL_NEW		QSL_SDX

   *** UPDATE.DAT
   COMMAND	COMMAND TO UPDATE
   QSL		QSL			#va updater en fait QSL_NEW

*/


//---------------------------------------------------------------------------
//------ Variables globales -------------------------------------------------
//---------------------------------------------------------------------------
tLocal 	*pLocal;
tRemote *pRemote;
tUpdate *pUpdate;

extern tUserCfg * pUserCfg;
extern unsigned long COMMANDS_statut[MAX_STREAMS];


struct
{
  unsigned short Checksum;
  unsigned char	 Offset;
} tRecord;

mem_hand LocalDBHand;
mem_hand RemoteDBHand;
mem_hand UpdateDBHand;

/*Pour savoir a qui adresser la reponse lors d'un remote database request*/
char * DATABASE_pszRemoteDB_FromPC;

//---------------------------------------------------------------------------
//------ Initialisation des databases ---------------------------------------
//---------------------------------------------------------------------------
void DATABASE_init(void)
{
  int 	index;
  char  sLine[256];
  char  sDatabase[81];
  char	sToUpdate[81];
  char  sFileName[81];
  char  sChain[81];
  char  sCluster[81];
  int	iNbArg;
  char *pPtr;

  FILE *fPtr;

  //Rserver les blocs mmoire
  setXMstrat("XEV");
  LocalDBHand  = xalloc ( sizeof(*pLocal),  DB_MAXL);
  RemoteDBHand = xalloc ( sizeof(*pRemote), DB_MAXR);
  UpdateDBHand = xalloc ( sizeof(*pUpdate), DB_MAXU);

  //Memoire suffisante ?
  if( ! LocalDBHand || ! RemoteDBHand || ! UpdateDBHand )
  {
    printf("*** Not enough memory to allocate database buffers\n");
    exit(EXIT_FAILURE);
  }

  //Initialiser les blocs
  for(index = 0; index < DB_MAXL; index++)	//Databases locales
  {
    pLocal  = (tLocal *) xget(index, LocalDBHand);
    memset(pLocal, 0, sizeof(*pLocal));
    xput((unsigned char *) pLocal, index, LocalDBHand);
  }/*End FOR*/

  //Initialiser les blocs
  for(index = 0; index < DB_MAXU; index++)	//Databases UPDATE
  {
    pUpdate = (tUpdate *) xget(index, UpdateDBHand);
    memset(pUpdate, 0, sizeof(*pUpdate));
    xput((byte *) pUpdate, index, UpdateDBHand);
  }/*End FOR*/

  //Initialiser les blocs
  for(index = 0; index < DB_MAXR; index++)	//Databases remote
  {
    pRemote  = (tRemote *) xget(index, RemoteDBHand);
    memset(pRemote, 0, sizeof(*pRemote));
    xput((unsigned char *) pRemote, index, RemoteDBHand);
  }/*End FOR*/


  //------ Initialisation des databases locales -----------------------------
  //Ouvrir le fichier des databases locales
  fPtr = fopen(DATABASE_LOCAL_FILE, "rt");

  //Si le fichier database/local.cfg a t trouv
  if( fPtr )
  {
    for(index = 0; index < DB_MAXL; index++)
    {
      //Lire une ligne dans le fichier
      if( ! fgets(sLine, 255, fPtr) )
	break;	//Fin de fichier atteinte

      TOOLS_removeNR(sLine);
      pLocal = (tLocal *) xget(index, LocalDBHand);

      //Rechercher la position du sujet de la base de donnee
      pPtr = strchr(sLine, '#');
      if( pPtr )
      {
	*pPtr++ = SNULL;
	TOOLS_maxLength(pPtr, 80);	//limiter a 80 caracteres
	strcpy(pLocal->sTopic, pPtr);
      }/*end IF*/

      strlwr(sLine);

      //Lire les lments
      TOOLS_maxLength(sLine, 80);
      iNbArg = sscanf(sLine, "%s %s %s", sDatabase, sFileName, sChain);

      if( iNbArg < 2 )
	break;      //Fin de la liste atteinte

      //Limiter la longueur des chaines
      TOOLS_maxLength(sDatabase, 20);
#ifdef DOS
      TOOLS_maxLength(sFileName, 8);	//limiter a 8 octets sous DOS
#endif
      TOOLS_maxLength(sChain, 20);

      //Mmoriser cette database
      strcpy(pLocal->sDatabase, sDatabase);
      strcpy(pLocal->sFileName, sFileName);

      if( iNbArg == 3 )
	strcpy(pLocal->sChain, sChain);	//Database chaine
      else
	strcpy(pLocal->sChain, "");

      //Afficher sur l'cran ...
      printf("Adding local database %s\n", strupr(sDatabase) );

      //Memoriser les changements
      xput((byte *) pLocal, index, LocalDBHand);

    }/*End FOR*/
    fclose( fPtr );
  }/*End IF*/

  //------ Initialisation des databases update ------------------------------
  //Ouvrir le fichier des databases update
  fPtr = fopen(DATABASE_UPDATE_FILE, "rt");

  //Si le fichier database/update.dat a t trouv
  if( fPtr )
  {
    for(index = 0; index < DB_MAXU; index++)
    {
      //Lire une ligne dans le fichier
      if( ! fgets(sLine, 255, fPtr) )
	break;	//Fin de fichier atteinte

      TOOLS_removeNR(sLine);
      pUpdate = (tUpdate *) xget(index, UpdateDBHand);

      //Rechercher la position du sujet de la base de donnee
      pPtr = strchr(sLine, '#');
      if( pPtr )
      {
	*pPtr++ = SNULL;
	TOOLS_maxLength(pPtr, 80);	//limiter a 80 caracteres
	strcpy(pUpdate->sTopic, pPtr);
      }/*end IF*/

      strlwr(sLine);

      //Lire les lments
      TOOLS_maxLength(sLine, 80);
      iNbArg = sscanf(sLine, "%s %s", sDatabase, sToUpdate);

      if( iNbArg != 2 )
	break;      //Fin de la liste atteinte

      //Limiter la longueur des chaines
      TOOLS_maxLength(sDatabase, 20);
      TOOLS_maxLength(sToUpdate, 20);

      //Mmoriser cette database
      strcpy(pUpdate->sDatabase, sDatabase);
      strcpy(pUpdate->sToUpdate, sToUpdate);

      //Afficher sur l'cran ...
      printf("Allowing database %s to be updated\n", strupr(sDatabase) );

      //Memoriser les changements
      xput((byte *) pUpdate, index, UpdateDBHand);

    }/*End FOR*/
    fclose( fPtr );
  }/*End IF*/

  //------ Initialisation des databases remotes -----------------------------
  //Ouvrir le fichier des databases locales
  fPtr = fopen(DATABASE_REMOTE_FILE, "rt");

  //Si le fichier database/remote.cfg a t trouve
  if( fPtr )
  {
    for(index = 0; index < DB_MAXR; index++)
    {
      //Lire une ligne dans le fichier
      if( ! fgets(sLine, 255, fPtr) )
	break;	//Fin de fichier atteinte

      TOOLS_removeNR(sLine);
      pRemote = (tRemote *) xget(index, RemoteDBHand);

      //Rechercher la position du sujet de la base de donnee
      pPtr = strchr(sLine, '#');
      if( pPtr )
      {
	*pPtr++ = SNULL;
	TOOLS_maxLength(pPtr, 80);	//limiter a 80 caracteres
	strcpy(pRemote->sTopic, pPtr);
      }/*end IF*/

      strlwr(sLine);

      //Lire les lments
      TOOLS_maxLength(sLine, 80);
      iNbArg = sscanf(sLine, "%s %s", sDatabase, sCluster);

      if( iNbArg < 2 )
	break;      //Fin de la liste atteinte

      //Limiter la longueur des chaines
      TOOLS_maxLength(sDatabase, 20);
      TOOLS_maxLength(sCluster, 9);

      //Mmoriser cette database
      strcpy(pRemote->sDatabase, sDatabase);
      strcpy(pRemote->sCluster,  strupr (sCluster) );

      //Afficher sur l'cran ...
      printf("Adding remote database %s\n", strupr(sDatabase) );

      //Memoriser les changements
      xput((byte *) pRemote, index, RemoteDBHand);
    }/*End FOR*/
    fclose( fPtr );
  }/*End IF*/


  //Mode X_FAST : puisqu'acces en lecture uniquement
  SetReadMode(LocalDBHand,  X_FAST);
  SetReadMode(RemoteDBHand, X_FAST);
  SetReadMode(UpdateDBHand, X_FAST);
}

//---------------------------------------------------------------------------
//------ La commande est-elle une database ? --------------------------------
//---------------------------------------------------------------------------
//La fonction retourne TRUE si Database correspondait  une database dclare, et FALSE sinon
//L'accs aux databases remote se fait galement dans ce bloc, mais sans qu'un merge soit possible
int DATABASE_local(int StreamNum, char * Database, char * Entry, int IsLocal)
{
  int	index;
  int	Done = FALSE;

  if( ! *Database )	/*Pas de nom specifie ?*/
    return FALSE;	/*Dans ce cas, inutile d'aller plus loin*/

  strlwr (Database);
  strlwr (Entry);

  //Parcourir la liste des databases locales
chain:
  for(index = 0; index < DB_MAXL; index++)
  {
    pLocal = (tLocal *) xget(index, LocalDBHand);
    if( ! strcmp(pLocal->sDatabase, Database) )
    {
      Done = TRUE;

      //Acces a une base sur CD-ROM ?
      if( ! strcmp(pLocal->sChain, "callbook") )
      {
	//Vrifier que l'utilisateur a bien specifie une entree
	if( *Entry == SNULL )
	{
	  MSG_send(StreamNum, MSG17);
	  return TRUE;
	}/*End IF*/

	//Appeler le programme specifie, et renvoyer la reponse
	//a l'utilisateur
	if( EXECUTE_buckMaster(StreamNum, pLocal->sFileName, strupr(Entry), CALLBOOK_PATH, IsLocal) != -1 )
	    return TRUE;
	  else
	    return FALSE;
      }/*End IF*/

      if( ! DATABASE_search(StreamNum, Entry, index, IsLocal) && * pLocal->sChain )
      {
	//L'entre n'a pas t trouve mais la database est chaine.
	strcpy(Database, pLocal->sChain);	//Copier le nom de la database chaine
	goto chain;				//Retour case dpart ! :-)
      }/*End IF*/
    }/*End IF*/
  }/*End FOR*/

  /*C'est termine si l'acces est en remote*/
  if( IsLocal == DB_REMOTE )
    return Done;

  /*Recherche dans les liste des databases remote*/
  for(index = 0; index < DB_MAXR; index++)
  {
    char sUserCall[16];
    char sNodeCall[16];

    pRemote = (tRemote *) xget(index, RemoteDBHand);
    if( ! strcmp(pRemote->sDatabase, Database) )
    {
      extern char    *MSG_pParams[10];
      extern char     STREAMS_callsign[MAX_STREAMS][10];

      /*Indiquer a l'utiliseur qu'il faut patienter*/
      MSG_pParams[9] = pRemote->sCluster;
      MSG_send(StreamNum, MSG60);

      /*Indicatif du cluster, de l'utilisateur et du destinataire*/
      NODE_getNodeCall(0, 0, sNodeCall);
      strcpy(sUserCall, STREAMS_callsign[StreamNum]);

      if( ! PROTOCOL_dbRequest(0, sNodeCall, pRemote->sCluster, StreamNum,
			     strupr(Database), strupr(Entry), sUserCall) )
      {
	/*Impossible de joindre l'adjacent*/
	MSG_send(StreamNum, MSG61);
	MSG_send(StreamNum, MSG62);
      }
      return TRUE;
    }
  }

  return Done;
}

//---------------------------------------------------------------------------
//------ Rechercher dans la database locale ---------------------------------
//---------------------------------------------------------------------------
//La fonction retourne TRUE si la recherche doit tre stoppe (si l'entre a
//t trouv ou si le fichier database n'existe pas)
int DATABASE_search(int StreamNum, char * Entry, int Database, int IsLocal)
{
  FILE *fFul;
  FILE *fIdx;
  char	sFul[MAXPATH];
  char	sIdx[MAXPATH];
  char	sLine[256];
  int	iKey;
  long  lFnd = 0L;
  long	lPos = 0L;
  unsigned short shChecksum;

  #define SPECIALKEY_MAX 	5
  #define LIS	0
  #define CAL	1
  #define PRE	2
  #define POST	3
  #define NF	4
  char *sKeyTable[SPECIALKEY_MAX] = {"#lis", "#cal", "#pre", "#post", "#nf"};
  long  lKeyTable[SPECIALKEY_MAX] = {0L, 0L, 0L, 0L, 0L};
  unsigned short shKeyTable[SPECIALKEY_MAX];
  for(iKey = 0; iKey < SPECIALKEY_MAX; iKey++)
    shKeyTable[iKey] = DATABASE_checksum( sKeyTable[iKey] );


  //Convertir l'entree en minuscule
  strlwr( Entry );

  //Crer les noms de fichiers
  pLocal = (tLocal *) xget(Database, LocalDBHand);
  sprintf(sFul, "%s%s.ful", DATABASE_PATH, pLocal->sFileName);
  sprintf(sIdx, "%s%s.idx", DATABASE_PATH, pLocal->sFileName);

  //Ouvrir le fichier FUL
  fFul = fopen(sFul, "rt");

  //Vrifier que le .FUL a pu tre ouvert
  if( ! fFul )
  {
    //Non
    if( IsLocal )
      MSG_send(StreamNum, MSG32);	//Requte locale

    return TRUE;			//Stopper la recherche
  }/*End IF*/

  //Ouvrir le fichier IDX
  fIdx = fopen(sIdx, "rb");

  //Y a t-il un fichier d'index (ce n'est pas obligatoire) ?
  if( fIdx )
  {
    //Calculer le checksum de l'entree saisie par l'operateur
    shChecksum = DATABASE_checksum(Entry);

    //Effectuer la recherche dans le fichier d'index
    for(;;)
    {
      if( ! fread(&tRecord, sizeof(tRecord), 1, fIdx) )
	break;	//Fin de fichier atteinte

      lPos += tRecord.Offset; 				//Ajouter l'offset

      //Vrifier les SpecialKeys
      for(iKey = 0; iKey < SPECIALKEY_MAX; iKey++)
      {
	if( tRecord.Checksum == shKeyTable[iKey] )	//Le checksum correspond ?
	{
	  //Vrifier ...
	  fseek(fFul, lPos, SEEK_SET);		  //Pointer dans le fichier
	  if( ! fgets(sLine, 255, fFul) )	  //Lire la ligne
	    break;   //Fin de fichier atteinte
	  strlwr( sLine );
	  TOOLS_removeNR( sLine );
	  if( ! strcmp(sLine, sKeyTable[iKey]) )  //Comparer
	    lKeyTable[iKey] = ftell( fFul );      //Bingo !
	}
      }/*End FOR*/

      //Vrifier l'entree saisie par l'operateur
      if( tRecord.Checksum == shChecksum )
      {
	//Vrifier ...
	fseek(fFul, lPos, SEEK_SET);		//Pointer dans le fichier
	if( ! fgets(sLine, 255, fFul) )	  	//Lire la ligne
	  break;   //Fin de fichier atteinte
	strlwr( sLine );
	TOOLS_removeNR( sLine );
	if( ! strcmp(sLine, Entry) )  		//Comparer
	  lFnd = ftell( fFul );      		//Bingo !
      }/*End IF*/
    }/*End LOOP*/

    fclose( fIdx );
  }
  else
  {
    //Parcourir tout le fichier ... (ce qui peut-tre long !)
    for(;;)
    {
      //Lire une ligne dans le fichier
      if( ! fgets(sLine, 255, fFul) )
	break;	//Fin de fichier atteinte

      strlwr( sLine );
      TOOLS_removeNR( sLine );

      //Rechercher les SpecialKeys
      for(iKey = 0; iKey < SPECIALKEY_MAX; iKey++) //Parcourir la table ...
      {
	if( ! strcmp(sLine, sKeyTable[iKey]) )	   //Comparer
	{
	  lKeyTable[iKey] = ftell( fFul );         //C'est bon !
	  break;
	}
      }/*End FOR*/

      //Comparer avec l'entre saisie par l'utilisateur
      if( ! strcmp(sLine, Entry) )
	lFnd = ftell( fFul );  		//Correspondance avec l'entre saisie

      //Passer  l'enregistrement suivant
      do
      {
	//Lire une ligne dans le fichier
	if( ! fgets(sLine, 255, fFul) )
	  break;   //Fin de fichier atteinte
      } while( strncmp(sLine, "&&", 2) );
    }/*End FOR*/
  }/*End IF*/

  //Envoyer ce qui a t trouv  l'utilisateur

  //L'utilisateur a t-il prcis une entre ?
  if( ! *Entry )
  {
    //Non : transmettre (si trouv) les enregistrements #LIS ou #CAL
    //(#LIS est l'equivalent de #CAL dans les BdD PacketCluster)
    if( lKeyTable[LIS] )
      DATABASE_sendRecord(StreamNum, Entry, fFul, lKeyTable[LIS], IsLocal);
    else if( lKeyTable[CAL] )
      DATABASE_sendRecord(StreamNum, Entry, fFul, lKeyTable[CAL], IsLocal);

    fclose( fFul );
    return TRUE;	//Stopper la recherche
  }/*End IF*/

  //L'enregistrement a t-il t trouv ?
  if( lFnd )
  {
    //Oui : transmettre l'enregistrement

    //Envoyer le prfixe
    DATABASE_sendRecord(StreamNum, Entry, fFul, lKeyTable[PRE], IsLocal);

    //Envoyer l'enregistrement
    DATABASE_sendRecord(StreamNum, Entry, fFul, lFnd, IsLocal);

    //Envoyer le suffixe (POST)
    DATABASE_sendRecord(StreamNum, Entry, fFul, lKeyTable[POST], IsLocal);

    fclose( fFul );
    return TRUE;	//Entree trouvee - stopper la recherche
  }/*End IF*/

  //L'entree n'a pas ete trouvee - Envoyer le NotFound si la liste n'est
  //pas chainee.
  if( ! * pLocal->sChain )
    DATABASE_sendRecord(StreamNum, Entry, fFul, lKeyTable[NF], IsLocal);

  fclose( fFul );
  return FALSE;
}

//---------------------------------------------------------------------------
//------ Envoyer un enregistrement ------------------------------------------
//---------------------------------------------------------------------------
void DATABASE_sendRecord(int StreamNum, char * Entry, FILE * fPtr, long lPos, int IsLocal)
{
  char	sLine[256];
  char *pPtr;

  if( lPos == 0L )
    return;		//Pas d'enregistrement a transmettre ...

  //Pointer dans le fichier
  fseek(fPtr, lPos, SEEK_SET);

  //Requte locale
//  if( IsLocal )
//  {
    for(;;)
    {
      //Lire une ligne dans le fichier
      if( ! fgets(sLine, 255, fPtr) )
	break;	//Fin de fichier atteinte

      TOOLS_removeNR( sLine );

      //Fin de l'enregistrement atteinte ?
      if( ! strncmp(sLine, "&&", 2) )
	break;

      //Insrer la varible %s (entre saisie par l'utilisateur)
      strupr( Entry );
      strrev( Entry );
      while( (pPtr = strstr(sLine, "%s")) != NULL )
      {
	strrev( pPtr );
	sLine[ strlen(sLine) - 2 ] = SNULL;
	strcat(sLine, Entry);
	strrev( pPtr );
      }
      strrev( Entry );

      //Transmettre la ligne a l'utilisateur
      if( IsLocal == DB_REMOTE )
      {
	char szServer[16];

	/*Repondre a un remote database*/
	NODE_getNodeCall(0, 0, szServer);
	PROTOCOL_dbResponse(0, szServer, DATABASE_pszRemoteDB_FromPC,
			    StreamNum, sLine);
      }
      else
      {
	/*Requete locale, repondre directement a l'utilisateur*/
	BUFFERS_printBuff(StreamNum, OUT, "%s\n", sLine);
      }
    }/*End LOOP*/
//  }
//  else	//Remote
//  {
//    //ICI
//  }/*End IF*/
}

//---------------------------------------------------------------------------
//------ Calcul du CheckSum d'une entree ------------------------------------
//---------------------------------------------------------------------------
unsigned short DATABASE_checksum(char * String)
{
  unsigned short shChecksum = 0;
  short		 shPds = 256;
  char          *pPtr = String;

  //Calcul du checksum sur deux octets
  while( *pPtr )
  {
    shChecksum += shPds * (unsigned short) *pPtr++;
    shPds = (shPds == 1 ? 256 : 1);
  }

  return shChecksum;
}

//--------------------------------------------------------------------------
//------ Updater une database ----------------------------------------------
//--------------------------------------------------------------------------
//La fonction retourne FALSE si la database n'est pas dclare.
//La fonction retourne TRUE si la database est declaree, MEME si le fichier database n'existe pas
int DATABASE_update(int StreamNum, char * Database, char * Entry, int IsLocal)
{
  int	index;
  char	sFul[MAXPATH];
  FILE *fFul;

  //Cet update-database est-elle dclare ?
  for(index = 0; index < DB_MAXU; index++)
  {
    pUpdate = (tUpdate *) xget(index, UpdateDBHand);

    if( ! strcmp(pUpdate->sDatabase, Database) )
      break;
  }/*End IF*/

  if( index == DB_MAXU )
    return FALSE;		//Cette database n'est pas declaree

  //Une entree a t-elle ete precisee ?
  if( ! *Entry )
  {
    MSG_send(StreamNum, MSG17);
    return TRUE;
  }/*End IF*/

  //Quelle database faut-il updater ?
  //rechercher parmis les databases locales
  for(index = 0; index < DB_MAXL; index++)
  {
    pLocal = (tLocal *) xget(index, LocalDBHand);
    if( ! strcmp(pLocal->sDatabase, pUpdate->sToUpdate) )
      break;
  }/*End FOR*/

  //La database a updater a t-elle ete trouvee ?
  if( index == DB_MAXL )
  {
    //Non
    if( IsLocal )
      MSG_send(StreamNum, MSG32);

    return TRUE;
  }

  //Ouvrir le fichier
  sprintf(sFul, "%s%s.ful", DATABASE_PATH, pLocal->sFileName);
  fFul = fopen(sFul, "rt");

  //Vrifier que le .FUL a pu tre ouvert (et donc qu'il existe ...)
  if( ! fFul )
  {
    //Non
    if( IsLocal )
      MSG_send(StreamNum, MSG32);	//Requte locale

    return TRUE;			//Stopper la recherche
  }/*End IF*/

  fclose( fFul );

  //Preparer les variables utilisateurs
  strupr( Entry );
  COMMANDS_statut[StreamNum] |= COMMANDS_statutUpdateDB;
  MSG_send(StreamNum, MSG33);

  //Memoriser le nom du fichier qu'il faudra updater
  USERS_getRecord(StreamNum);			//Acceder a la config de l'utilisateur
  strcpy(pUserCfg->sFileName, sFul);		//Copier le nom de la database
  pUserCfg->iBufferLength = 0;			//idem

  //Placer la cle en premiere ligne
  BUFFERS_addTemp(StreamNum, Entry, strlen(Entry));
  BUFFERS_addTemp(StreamNum, "\n\r", 2);

  USERS_updateLocalConfig(StreamNum);   	//Sauvegarder les modifs

  return TRUE;
}

//---------------------------------------------------------------------------
//------ Indexer une database -----------------------------------------------
//---------------------------------------------------------------------------
//La fonction retourne TRUE si la base de donnee a pu etre indexee et FALSE sinon
int DATABASE_index(char * FileName, int CanCreate)
{
  char 	sQualifier[256];
  char 	sFulFileName[MAXPATH];
  char	sIdxFileName[MAXPATH];
  char *pPtr;

  long 			lPos = 0;
  unsigned short 	shCheckSum;
  unsigned short 	shOffset;

  struct stat 		bufstat;


  FILE *fFul;
  FILE *fIdx;

  //------ Creer les noms de fichiers ------
  //Le path a t-il ete specifie ?
  if( ! strchr(FileName, '/') && ! strchr(FileName, '\\') )
    strcpy(sFulFileName, DATABASE_PATH);
  else
    strcpy(sFulFileName, "");

  //Ajouter le nom du fichier au path
  strcat(sFulFileName, FileName);
  strlwr(sFulFileName);

  //Virer l'extension .ful si elle a ete precisee
  pPtr = strstr(sFulFileName, ".ful");
  if( pPtr != NULL )
    *pPtr = SNULL;

  strcpy(sIdxFileName, sFulFileName);

  //Ajouter les extensions (.ful et .idx)
  strcat(sFulFileName, ".ful");
  strcat(sIdxFileName, ".idx");

  //Ouvrir les fichiers et verifier qu'ils existent
  fFul = fopen(sFulFileName, "rt");
  if( ! fFul )
  {
    perror("fopen FUL in DATABASE_index");
    return FALSE;
  }/*End IF*/

  //Le fichier idx existe t-il ?
  if( (stat(sIdxFileName, &bufstat) == -1) && CanCreate == DB_CREATEIDX_NO)
  {
	fclose(fFul);
	return FALSE;	//Le fichier n'existe pas et il ne faut pas le creer
  }

  fIdx = fopen(sIdxFileName, "wb");
  if( ! fIdx )
  {
	fclose(fFul);
	return FALSE;
  }

  for(;;)
  {
    //------ Lecture du pointeur ------
    shOffset = (unsigned short) ( ftell(fFul) - lPos );
    lPos = ftell(fFul);

    //------ Lecture d'une ligne dans la table ------
    if( ! fgets(sQualifier, sizeof(sQualifier), fFul) )
      break;

    TOOLS_removeNR(sQualifier);

    strlwr(sQualifier);

    //------ Calcul du CheckSum ------
    shCheckSum = DATABASE_checksum( sQualifier );

    //------ Ecriture de la structure dans le fichier ------
    //Crer des enregistrements vide avec un offset maximum
    //si l'offset dpasse 255 (char)
    while( shOffset > 255 )
    {
      tRecord.Checksum = 0;
      tRecord.Offset = 255;
      shOffset -= 255;
      fwrite(&tRecord, sizeof(tRecord), 1, fIdx);
    }

    tRecord.Checksum = shCheckSum;
    tRecord.Offset   = (unsigned char) shOffset;
    fwrite(&tRecord, sizeof(tRecord), 1, fIdx);

    //------ Passe au qualifier suivant ------
    while( strcmp(sQualifier, "&&") )
    {
      if( ! fgets(sQualifier, sizeof(sQualifier), fFul) )
	break;
      TOOLS_removeNR(sQualifier);
    } /* end while */
  }/* end while */

  fclose(fIdx);
  fclose(fFul);

  return TRUE;
}

//---------------------------------------------------------------------------
//------ Indiquer la liste des bases de donnees avec un commentaire ---------
//------ eventuel -----------------------------------------------------------
//---------------------------------------------------------------------------
void DATABASE_showList(int StreamNum)
{
  int 	index;
  char  sCmd[21];

  //Databases locales
  MSG_send(StreamNum, MSG36);
  for(index = 0; index < DB_MAXL; index++)
  {
    pLocal  = (tLocal *) xget(index, LocalDBHand);

    //Recopier le nom de la database pour pouvoir le passer en majuscule
    strcpy(sCmd, pLocal->sDatabase);
    strupr(sCmd);

    //N'afficher que les bases pour lesquelles il y a un commentaire
    if( *pLocal->sTopic )
      BUFFERS_printBuff(StreamNum, OUT, "SHow/%-20s %s\n", sCmd, pLocal->sTopic);
  }/*End FOR*/

  //Databases remotes
  for(index = 0; index < DB_MAXR; index++)
  {
    pRemote = (tRemote *) xget(index, RemoteDBHand);

    //Recopier le nom de la database pour pouvoir le passer en majuscule
    strcpy(sCmd, pRemote->sDatabase);
    strupr(sCmd);

    //N'afficher que les bases pour lesquelles il y a un commentaire
    if( *pRemote->sTopic )
      BUFFERS_printBuff(StreamNum, OUT, "SHow/%-20s %s\n", sCmd, pRemote->sTopic);
  }/*End FOR*/

  //Updates
  BUFFERS_addBuff(StreamNum, "\n", OUT);
  MSG_send(StreamNum, MSG37);
  for(index = 0; index < DB_MAXU; index++)
  {
    pUpdate = (tUpdate *) xget(index, UpdateDBHand);

    //Recopier le nom de la database pour pouvoir le passer en majuscule
    strcpy(sCmd, pUpdate->sDatabase);
    strupr(sCmd);

    //N'afficher que les bases pour lesquelles il y a un commentaire
    if( *pUpdate->sTopic )
      BUFFERS_printBuff(StreamNum, OUT, "UPdate/%-20s %s\n", sCmd, pUpdate->sTopic);
  }/*End FOR*/

}

//---------------------------------------------------------------------------
//------ Repondre a un database request -------------------------------------
//---------------------------------------------------------------------------
int DATABASE_remote(int nUserStream, char * pszDatabase, char * pszEntry, char * pszFromPC)
{
  /*Pour savoir a qui router le prototocole*/
  DATABASE_pszRemoteDB_FromPC = pszFromPC;

  /* Vide ? */
  if( ! strcmp(pszEntry, " ") )
    *pszEntry = SNULL;

  /*Interroger la base de donnees locale*/
  return DATABASE_local(nUserStream, pszDatabase, pszEntry, DB_REMOTE);
}
