#include <alloc.h>
#include <string.h>
#include "database.h"
#include "cupdate.h"
#include "define.h"
#include "message.h"

/*-------------------------------------------------------------------------
  ------ Rediriger les commandes UPDATE -----------------------------------
  ------------------------------------------------------------------------
  La fonction return TRUE si la commande a ete executee                   */
#pragma argsused
int CUPDATE_execute(int StreamNum, char * pCmd_p, int nParams, char **pArg, char **pStrArg)
{
  if( *pArg[0] == SNULL )
    return FALSE;

  /* Ne pas autoriser les remote commands */
  if( StreamNum >= RCMD_VIRTSTREAM )
	return FALSE;

  /*Pour l'instant, on ne peut updater que les bases de donnees locales*/
  if( CUPDATE_database(StreamNum, nParams, pArg, pStrArg) )
    return TRUE;

  return FALSE;		/*La commande n'a pas ete trouvee*/
}

/*------------------------------------------------------------------------
  ------ UP/DATABASE -----------------------------------------------------
  ------------------------------------------------------------------------*/
#pragma argsused
int CUPDATE_database(int StreamNum, int nParams, char **pArg, char **pStrArg)
{
  extern char	STREAMS_level[MAX_STREAMS];

  /*Niveau d'utilisateur*/
  if( STREAMS_level[StreamNum] & LEVEL_user_RXonly )
    return FALSE;

  /* Ne pas autoriser les remote commands */
  if( StreamNum >= RCMD_VIRTSTREAM )
	return FALSE;

  if( nParams > 2 )
  {
    MSG_send(StreamNum, MSG58);
    Prompt;
    return TRUE;
  }

  if( DATABASE_update(StreamNum, pArg[0], pArg[1], DB_LOCAL) )
    return TRUE;	/*Commande update OK*/
  else
    return FALSE;
}
