#include <alloc.h>
#include <string.h>
#include <stdio.h>
#include <dir.h>
#include "define.h"
#include "commands.h"
#include "cstatut.h"
#include "password.h"
#include "buffers.h"
#include "message.h"
#include "users.h"
#include "tools.h"
#include "database.h"
#include "symbol.h"
#include "switch.h"
#include "mail.h"
#include "streams.h"
#include "system.h"
#include "dos.h"
#include "medit.h"
#include "protocol.h"
#include "node.h"

/*------------------------------------------------------------------------
  ------ Variables globales ----------------------------------------------
  ------------------------------------------------------------------------*/
extern unsigned long 	COMMANDS_statut[MAX_STREAMS];

/*------------------------------------------------------------------------
  ------ Rediriger les commandes CSTATUT ---------------------------------
  ------------------------------------------------------------------------
  La fonction return TRUE si la commande a ete executee                   */
#pragma argsused
int CSTATUT_execute(int StreamNum, char * pString)
{
  if( COMMANDS_statut[StreamNum] & COMMANDS_statutChangeMOTD )
    return CSTATUT_changeMOTD(StreamNum, pString);

  if( COMMANDS_statut[StreamNum] & COMMANDS_statutChangeUserCMD )
    return CSTATUT_changeUserCMD(StreamNum, pString);

  if( COMMANDS_statut[StreamNum] & COMMANDS_statutEditUser )
    return CSTATUT_editUser(StreamNum, pString);

  if( COMMANDS_statut[StreamNum] & COMMANDS_statutEditUserCreate )
    return CSTATUT_editUserCreate(StreamNum, pString);

  if( COMMANDS_statut[StreamNum] & COMMANDS_statutExitServer )
    return CSTATUT_exitServer(StreamNum, pString);

  if( COMMANDS_statut[StreamNum] & COMMANDS_statutRcvMail )
    return CSTATUT_rcvMail(StreamNum, pString);

  if( COMMANDS_statut[StreamNum] & COMMANDS_statutTalkMode )
    return CSTATUT_talkmode(StreamNum, pString);

  if( COMMANDS_statut[StreamNum] & COMMANDS_statutUpdateDB )
    return CSTATUT_updateDB(StreamNum, pString);

  if( COMMANDS_statut[StreamNum] & COMMANDS_statutWaitCFilter1 )
    return CSTATUT_cFilter1(StreamNum, pString);

  if( COMMANDS_statut[StreamNum] & COMMANDS_statutWaitCFilter2 )
    return CSTATUT_cFilter2(StreamNum, pString);

  if( COMMANDS_statut[StreamNum] & COMMANDS_statutWaitPassword )
    return CSTATUT_password(StreamNum, pString);

  if( COMMANDS_statut[StreamNum] & COMMANDS_statutLocalConf )
    return CSTATUT_localConf(StreamNum, pString);

  if( COMMANDS_statut[StreamNum] & COMMANDS_statutClusterConf )
    return CSTATUT_clusterConf(StreamNum, pString);

  if( COMMANDS_statut[StreamNum] & COMMANDS_meditCreate )
    return CSTATUT_meditCreate(StreamNum, pString);

  if( COMMANDS_statut[StreamNum] & COMMANDS_statutPageWaitCR )
    return CSTATUT_pageWaitCR(StreamNum, pString);

#ifdef DOS
  if( COMMANDS_statut[StreamNum] & COMMANDS_statutDOS )
  {
	if( DOS_commands(StreamNum, pString) == FALSE )
	{
		/* fin du mode DOS */
		COMMANDS_statut[StreamNum] &= ~COMMANDS_statutDOS;
		Prompt;
	}
	return TRUE;
  }
#endif

  if( COMMANDS_statut[StreamNum] & COMMANDS_statutMEdit )
  {
	if( MEDIT_commands(StreamNum, pString) == FALSE )
	{
		/* Fin de MEDIT */
		COMMANDS_statut[StreamNum] &= ~COMMANDS_statutMEdit;
		Prompt;
	}
	return TRUE;
  }

  return FALSE;		/*La commande n'a pas ete trouvee*/
}

/*------------------------------------------------------------------------
  ------ CHANGE MOTD -----------------------------------------------------
  ------------------------------------------------------------------------*/
#pragma argsused
int CSTATUT_changeMOTD(int StreamNum, char * pString)
{
  if( ! CSTATUT_isExit (pString) )
  {
    /*Ajouter la nouvelle entree dans le buffer temporaire*/
    BUFFERS_addTemp(StreamNum, pString, strlen (pString));
    BUFFERS_addTemp(StreamNum, "\n\r", 2);	/*Ajouter le CRLF qui avait disparu  ...*/
  }
  else
  {
    COMMANDS_statut[StreamNum] &= ~COMMANDS_statutChangeMOTD;

    /*Sauver et killer le buffer*/
    BUFFERS_saveTemp(StreamNum);

    MSG_send(StreamNum, MSG39);
    Prompt;
  }
  return TRUE;
}

/*------------------------------------------------------------------------
  ------ CFilter1 --------------------------------------------------------
  ------------------------------------------------------------------------*/
#pragma argsused
int CSTATUT_cFilter1(int StreamNum, char * pString)
{
  extern char	STREAMS_level[MAX_STREAMS];

  /*Vrifier la concordance et valider la connexion si OK*/
  if( PASSWORD_verify(StreamNum, pString) )
  {
    /*Mot de passe correct ...*/
    COMMANDS_statut[StreamNum] &= ~COMMANDS_statutWaitCFilter1;
    STREAMS_level[StreamNum] |= LEVEL_user;
    STREAMS_ctext(StreamNum);
  }
  else
  {
    SYSTEM_showFile(StreamNum, CFILTER_FILE);
    COMMANDS_statut[StreamNum] |= COMMANDS_statutDisconnect;
  }/*End IF*/

  return TRUE;
}

/*------------------------------------------------------------------------
  ------ CFilter2 --------------------------------------------------------
  ------------------------------------------------------------------------*/
#pragma argsused
int CSTATUT_cFilter2(int StreamNum, char * pString)
{
  extern char	STREAMS_level[MAX_STREAMS];

  COMMANDS_statut[StreamNum] &= ~COMMANDS_statutWaitCFilter2;

  /*Vrifier la concordance et valider la connexion si OK*/
  if( PASSWORD_verify(StreamNum, pString) )
  {
    /*Mot de passe correct ...*/
    STREAMS_level[StreamNum] |= LEVEL_user;
    STREAMS_ctext(StreamNum);
  }
  else
  {
    SYSTEM_showFile(StreamNum, CFILTER_FILE);
    STREAMS_ctext(StreamNum);
    STREAMS_level[StreamNum] |= LEVEL_user_RXonly;
  }/*End IF*/

  return TRUE;
}

/*------------------------------------------------------------------------
  ------ CHANGE USER CMD -------------------------------------------------
  ------------------------------------------------------------------------*/
#pragma argsused
int CSTATUT_changeUserCMD(int StreamNum, char * pString)
{
  if( ! CSTATUT_isExit (pString) )
  {
    /*Ajouter la nouvelle entree dans le buffer temporaire*/
    BUFFERS_addTemp(StreamNum, pString, strlen (pString));
    BUFFERS_addTemp(StreamNum, "\n\r", 2);	/*Ajouter le CRLF qui avait disparu  ...*/
  }
  else
  {
    COMMANDS_statut[StreamNum] &= ~COMMANDS_statutChangeUserCMD;

    /*Sauver et killer le buffer*/
    BUFFERS_saveTemp(StreamNum);

    MSG_send(StreamNum, MSG39);
    Prompt;
  }
  return TRUE;
}


/*------------------------------------------------------------------------
  ------ EDIT USER -------------------------------------------------------
  ------------------------------------------------------------------------*/
#pragma argsused
int CSTATUT_editUser(int StreamNum, char * pString)
{
  extern tUserCfg * pUserCfg;
  char *pPtr;
  char *pCmd; 	/*Pointe sur la commande*/
  char *pArg;	/*Pointe sur l'argument*/
  char  sString[256];

  /*Separer la commande de l'argument*/
  TOOLS_maxLength(pString, 255);	/*Par securite*/
  pCmd = pPtr = strcpy(sString, pString);
  while( *pPtr != ' ' && *pPtr != SNULL )
    pPtr++;
  if( *pPtr != SNULL )
    *pPtr++ = SNULL;
  pArg = pPtr;

  /* Lire la config pour cet utilisateur */
  USERS_getRecord   (StreamNum);

  strlwr (pCmd);

  /*Executer la commande*/
  if( ! strcmp(pCmd, "h") )		/*Modifier le Home Node*/
  {
    TOOLS_maxLength(pArg, 9);
    strupr (pArg);
    strcpy (pUserCfg->sHomeNode, pArg);
  }
  else if( ! strcmp(pCmd, "n") )      	/*Modifier le nom*/
  {
    TOOLS_maxLength(pArg, 22);
    strcpy (pUserCfg->sName, pArg);
  }
  else if( ! strcmp(pCmd, "q") ) 	/*Modifier le QTH*/
  {
    TOOLS_maxLength(pArg, 80);
    strcpy (pUserCfg->sQth, pArg);
  }
  else if( ! strcmp(pCmd, "l") )  	/*Modifier le locator*/
  {
    TOOLS_maxLength (pArg, 6);
    strupr (pArg);
    strcpy (pUserCfg->sLocator, pArg);
  }
  else if(! strcmp(pCmd, "wq") )	/*Terminer en enregistrant*/
  {
  	char szEditedUser[16];
	
	strcpy(szEditedUser, pUserCfg->sEditUser);

	/* Nom */
    	USERS_getRecord   (StreamNum);
	
    	USERS_changeConfig(szEditedUser, pUserCfg->sName,     USERS_NAME);

	/* QTH */
        USERS_getRecord   (StreamNum);
    	USERS_changeConfig(pUserCfg->sEditUser, pUserCfg->sQth,      USERS_QTH);

	/* Home node */
    	USERS_getRecord   (StreamNum);
    	USERS_changeConfig(pUserCfg->sEditUser, pUserCfg->sHomeNode, USERS_HOME);

	/* Locator */
    	USERS_getRecord   (StreamNum);	
	USERS_changeConfig(pUserCfg->sEditUser, pUserCfg->sLocator,  USERS_LOCATOR);

    	COMMANDS_statut[StreamNum] &= ~COMMANDS_statutEditUser;
    	BUFFERS_addBuff(StreamNum, "User information saved.\n", OUT);

    	/* Mettre a jour les datas en RAM */
    	USERS_openRecord(StreamNum, szEditedUser);
    
    	Prompt;
    	return TRUE;
  }
  else if(! strcmp(pCmd, "e") )	     	/*Sortir sans enregistrer*/
  {
    COMMANDS_statut[StreamNum] &= ~COMMANDS_statutEditUser;
    BUFFERS_addBuff(StreamNum, "Exit without saving.\n", OUT);
    Prompt;
    return TRUE;
  }

  /*Afficher le contenu des champs*/
  USERS_updateLocalConfig(StreamNum);
  BUFFERS_printBuff(StreamNum, OUT, "Name      : %s\n", pUserCfg->sName);
  BUFFERS_printBuff(StreamNum, OUT, "Home Node : %s\n", pUserCfg->sHomeNode);
  BUFFERS_printBuff(StreamNum, OUT, "Qth       : %s\n", pUserCfg->sQth);
  BUFFERS_printBuff(StreamNum, OUT, "Locator   : %s\n", pUserCfg->sLocator);
  BUFFERS_printBuff(StreamNum, OUT, "Edit user %s (N,H,Q,L,WQ,E) >\n", pUserCfg->sEditUser);

  return TRUE;
}

/*------------------------------------------------------------------------
  ------ EDIT USER - CREATE ? --------------------------------------------
  ------------------------------------------------------------------------*/
#pragma argsused
int CSTATUT_editUserCreate(int StreamNum, char * pString)
{
  extern tUserCfg * pUserCfg;

  if( *pString != 'y' && *pString != 'Y' )
  {
    COMMANDS_statut[StreamNum] &= ~COMMANDS_statutEditUserCreate;
    BUFFERS_addBuff(StreamNum, "Aborted.\n", OUT);
    Prompt;
    return TRUE;
  }

  USERS_getRecord(StreamNum);
  pUserCfg->sName[0]     = SNULL;
  pUserCfg->sHomeNode[0] = SNULL;
  pUserCfg->sQth[0]      = SNULL;
  pUserCfg->sLocator[0]  = SNULL;
  USERS_updateLocalConfig(StreamNum);

  COMMANDS_statut[StreamNum] &= ~COMMANDS_statutEditUserCreate;
  COMMANDS_statut[StreamNum] |= COMMANDS_statutEditUser;

  /*Afficher le contenu des champs*/
  CSTATUT_editUser(StreamNum, "");
  return TRUE;
}

/*------------------------------------------------------------------------
  ------ EXIT SERVER -----------------------------------------------------
  ------------------------------------------------------------------------*/
#pragma argsused
int CSTATUT_exitServer(int StreamNum, char * pString)
{
  COMMANDS_statut[StreamNum] &= ~COMMANDS_statutExitServer;

  /*Le sysop est-il OK pour quitter le serveur ?*/
  if( *pString == 'y' || *pString == 'Y' )
  {
    extern int 	FirstStream;	/*SWITCH.CPP*/
    extern int 	LastStream;     /*SWITCH.CPP*/
    int index;

    /*shutdown demande*/
    COMMANDS_statut[0] = COMMANDS_statutShutDown;

    /*Demander une deconnection sur tous les streams*/
    for(index = FirstStream; index <= LastStream; index++)
	COMMANDS_statut[index] = COMMANDS_statutDisconnect;

    /*Ne plus autoriser de connexion*/
    SWITCH_bpqSetup(0, 0x00, 0x00);

    BUFFERS_addBuff(StreamNum, "Exiting ...\n", OUT);
  }
  else
  {
    BUFFERS_addBuff(StreamNum, "Exiting aborted.\n", OUT);
    Prompt;
  }
  return TRUE;
}

/*------------------------------------------------------------------------
  ------ Conference locale -----------------------------------------------
  ------------------------------------------------------------------------*/
#pragma argsused
int CSTATUT_localConf(int StreamNum, char * pString)
{
  extern char STREAMS_callsign[MAX_STREAMS][10];
  char szText[1024];

  /* Fin du mode conference ? */
  if( CSTATUT_isExit (pString) )
  {
	unsigned char cFlag;

	sprintf(szText, "%s left the conference\n",
		STREAMS_callsign[StreamNum]);
	USERS_sendAll(szText, USERS_LOCALCONF, PROTOCOL_CONFERENCE, -1);

	COMMANDS_statut[StreamNum] &= ~COMMANDS_statutLocalConf;
	Prompt;

	/* Modifier la config en mmoire */
	cFlag  = NODE_getUserFlag(STREAMS_callsign[0],
		STREAMS_callsign[StreamNum]);
	cFlag &= ~PROTOCOL_USER_CONF;
	NODE_setUserFlag(STREAMS_callsign[0], STREAMS_callsign[StreamNum],
		cFlag);

	return TRUE;
  }

  sprintf(szText, "de %s: %s\n", STREAMS_callsign[StreamNum], pString);
  USERS_sendAll(szText, USERS_LOCALCONF, PROTOCOL_CONFERENCE, -1);

  return TRUE;
}

/*------------------------------------------------------------------------
  ------ Conference cluster ----------------------------------------------
  ------------------------------------------------------------------------*/
#pragma argsused
int CSTATUT_clusterConf(int StreamNum, char * pString)
{
  extern char STREAMS_callsign[MAX_STREAMS][10];

  /* Fin du mode conference ? */
  if( CSTATUT_isExit (pString) )
  {
	char szText[256];

	sprintf(szText, "%s@%s left the cluster-wide conference",
		STREAMS_callsign[StreamNum], STREAMS_callsign[0]);
	PROTOCOL_sendClusterConferenceMessage(0, STREAMS_callsign[0],
		STREAMS_callsign[StreamNum], szText, 100);

	PROTOCOL_sendClusterConfLogout(0, STREAMS_callsign[0],
		STREAMS_callsign[StreamNum], 100);

	COMMANDS_statut[StreamNum] &= ~COMMANDS_statutClusterConf;
	Prompt;

	return TRUE;
  }

  PROTOCOL_sendClusterConferenceMessage(0, STREAMS_callsign[0],
	STREAMS_callsign[StreamNum], pString, 100);

  return TRUE;
}

/*------------------------------------------------------------------------
  ------ RCV MAIL --------------------------------------------------------
  ------------------------------------------------------------------------*/
#pragma argsused
int CSTATUT_rcvMail(int StreamNum, char * pString)
{
  char	szFileName[MAXPATH];	/*Nom du fichier temporaire*/
  FILE *fPtr;

  /*Fin d'update ?*/
  if( CSTATUT_isExit (pString) )
  {
    /*Fin d'update : OUI*/

    /*Si c'est au moment du titre -> annuler le message*/
    if( COMMANDS_statut[StreamNum] & COMMANDS_statutWaitTitle )
    {
      COMMANDS_statut[StreamNum] &= ~COMMANDS_statutWaitTitle;
      COMMANDS_statut[StreamNum] &= ~COMMANDS_statutRcvMail;
      MSG_send(StreamNum, MSG46);
      MAIL_delTemp(StreamNum);
      Prompt;
      return TRUE;
    }/*End IF*/

    /*Confirmer la reception du message*/
    COMMANDS_statut[StreamNum] &= ~COMMANDS_statutRcvMail;
    MSG_send(StreamNum, MSG48);
    MAIL_tmp2Msg( StreamNum );
    MAIL_fwd();
    Prompt;
    return TRUE;
  }

  /*Si c'est le titre qui vient d'etre recu*/
  if( COMMANDS_statut[StreamNum] & COMMANDS_statutWaitTitle )
  {
    COMMANDS_statut[StreamNum] &= ~COMMANDS_statutWaitTitle;
    TOOLS_maxLength(pString, 60);	/*Limiter la taille a 60 octets*/
    MSG_send(StreamNum, MSG47);		/*Corps du message*/
  }/*End IF*/

  /*Ouvrir le fichier temporaire*/
  sprintf(szFileName, "%sstream%02d.tmp", MAIL_PATH, StreamNum);
  fPtr = fopen(szFileName, "a+t");
  if( ! fPtr )
  {
    /*Erreur sur l'ouverture du fichier temporaire*/
    perror("fopen in MAIL_rcvRecip");
    COMMANDS_statut[StreamNum] &= ~COMMANDS_statutWaitTitle;
    COMMANDS_statut[StreamNum] &= ~COMMANDS_statutRcvMail;
    MSG_send(StreamNum, MSG46);
    Prompt;
    return TRUE;
  }

  /*Ajouter le nouvelle ligne*/
  fprintf(fPtr, "%s\n", pString);

  fclose (fPtr);
  return TRUE;


}

/*------------------------------------------------------------------------
  ------ TALK MODE -------------------------------------------------------
  ------------------------------------------------------------------------*/
#pragma argsused
int CSTATUT_talkmode(int StreamNum, char * pString)
{
  COMMANDS_talkMode(StreamNum, pString);
  return TRUE;
}

/*------------------------------------------------------------------------
  ------ UPDATE DATABASE -------------------------------------------------
  ------------------------------------------------------------------------*/
#pragma argsused
int CSTATUT_updateDB(int StreamNum, char * pString)
{
  /*Fin d'update ?*/
  if( ! CSTATUT_isExit (pString) )
  {
    /*NON : Ajouter la nouvelle entree dans le buffer temporaire*/
    BUFFERS_addTemp(StreamNum, pString, strlen (pString));
    BUFFERS_addTemp(StreamNum, "\n\r", 2);	//Ajouter le CRLF qui avait disparu  ...
  }
  else
  {
    /*OUI : Updater la base de donnees*/
    extern tUserCfg * pUserCfg;
    FILE     *fPtr;
    long      lPos;
    char sBuffer[256];

    COMMANDS_statut[StreamNum] &= ~COMMANDS_statutUpdateDB;

    /*Ajouter l'update a la fin du fichier*/
    USERS_getRecord (StreamNum);
    fPtr = fopen(pUserCfg->sFileName, "r+t");

    /*Updater le fichier .FUL*/
    if( ! fPtr )
    {
      perror("fopen in database update of CMD_do");
      BUFFERS_addBuff(StreamNum,
		      "Unable to open database : contact the sysop\n", OUT);
      Prompt;
      return TRUE;
    }

    /*Placer le pointeur de fichier juste apres le dernier "&&", ce qui
      devrait normallement correspondre a la fin du fichier*/
    for(lPos = 0L;; lPos--)
    {
      /*Pointer sur le caractere precedent*/
      fseek(fPtr, lPos, SEEK_END);

      if( ftell (fPtr) == 0L )
	break;	/*Debut du fichier atteint*/

      /*&& trouve ?*/
      if( fgetc( fPtr ) == '&' )
      {
	/*Position de la fin du dernier enregistrement trouve*/
	fseek(fPtr, lPos + 1L, SEEK_END); /*SANS CE FSEEK, CA NE FONCTIONNE PAS !!!!*/
	fputc('\n', fPtr);
	break;
      }/*End IF*/
    }/*End FOR*/

    /*Copier le buffer dans le fichier*/
    for(;;)
    {
      int  iLength;
      /*lire une ligne dans le buffer*/
      iLength = BUFFERS_getTemp(StreamNum, sBuffer, 255);

      if( iLength == 0 )
	break;	/*Fin du buffer atteinte*/

      /*Ecrire la ligne dans le fichier*/
      fwrite(sBuffer, iLength, 1, fPtr);
    }/*End FOR/LOOP*/

    /*Ajouter par qui le fichier a ete update*/
    MSG_get(StreamNum, MSG34, sBuffer);
    TOOLS_removeNR(sBuffer);
    strcat(sBuffer, "\n&&\n");
    fwrite(sBuffer, strlen(sBuffer), 1, fPtr);

    /*Fermer le fichier, mettre a jour l'idx*/
    fclose (fPtr);
    DATABASE_index(pUserCfg->sFileName, DB_CREATEIDX_NO);

    /*Killer le buffer !*/
    BUFFERS_killTemp(StreamNum);

    MSG_send(StreamNum, MSG35);
    Prompt;
  }

  return TRUE;
}

/*------------------------------------------------------------------------
  ------ PASSWORD --------------------------------------------------------
  ------------------------------------------------------------------------*/
#pragma argsused
int CSTATUT_password(int StreamNum, char * pString)
{
  extern char	STREAMS_level[MAX_STREAMS];

  COMMANDS_statut[StreamNum] &= ~COMMANDS_statutWaitPassword;

  /*Vrifier la concordance et valider le sysop si OK*/
  if( PASSWORD_verify(StreamNum, pString) )
  {
    /*Mot de passe correct ...*/
    BUFFERS_addBuff(StreamNum, "Ok\n", OUT);
    STREAMS_level[StreamNum] |= LEVEL_sysopV;
  }/*End IF*/

  Prompt;
  return TRUE;
}

/*------------------------------------------------------------------------
  ------ ISEXIT ----------------------------------------------------------
  ------------------------------------------------------------------------
  Retourne TRUE si le debut de la chaine contient /EXit ou CTRL Z                   */
#pragma argsused
int CSTATUT_isExit(char * pString)
{
  char sString[8];

  strncpy(sString, pString, 5);
  sString[5] = SNULL;

  strlwr (sString);

  if( sString[0] == CTRLZ || COMMANDS_check("/exit", sString, strlen (sString), 3) )
    return TRUE;
  else
    return FALSE;
}

/*------------------------------------------------------------------------
  ------ MEDIT CREATE ? --------------------------------------------------
  ------------------------------------------------------------------------*/
#pragma argsused
int CSTATUT_meditCreate(int StreamNum, char * pString)
{
	COMMANDS_statut[StreamNum] &= ~COMMANDS_meditCreate;

	if( *pString != 'y' && *pString != 'Y' )
	{
		/* Quitter le mode edition MEDIT */
		MEDIT_clean(StreamNum);
		COMMANDS_statut[StreamNum] &= ~COMMANDS_statutMEdit;
		Prompt;
	}
	else
	{
		MEDIT_display(StreamNum);
		MEDIT_prompt(StreamNum);
	}

	return TRUE;
}

/*------------------------------------------------------------------------
  ------ MEDIT CREATE ? --------------------------------------------------
  ------------------------------------------------------------------------*/
#pragma argsused
int CSTATUT_pageWaitCR(int StreamNum, char * pString)
{
	extern CHANNEL Stream[MAX_BUFFER+1];

	COMMANDS_statut[StreamNum] &= ~COMMANDS_statutPageWaitCR;

	if( pString[0] == 'a' || pString[0] == 'A' )
	{
		BUFFERS_empty(StreamNum, OUT);
		Prompt;
	}
	Stream[StreamNum].byPageCount = 0;

	return TRUE;
}
