#include <alloc.h>
#include <string.h>
#include <stdlib.h>
#include <time.h>
#include <ctype.h>
#include "define.h"
#include "commands.h"
#include "cset.h"
#include "buffers.h"
#include "node.h"
#include "message.h"
#include "tools.h"
#include "hops.h"
#include "users.h"
#include "set.h"
#include "protocol.h"
#include "language.h"
#include "motd.h"
#include "usercmd.h"
#include "switch.h"		/*Pour le CSET_port de la version LINUX*/
#include "symbol.h"
#include "spy.h"
#include "filter.h"
#include "locator.h"
#include "ufilter.h"
#include "stdio.h"
#include "password.h"
#include "rcmd.h"
#include "telnet.h"

#ifdef DOS
extern "C" {
#include "com.h"
}
#endif

#ifdef LINUX
extern "C" int stime(time_t *t);
#endif


/*-------------------------------------------------------------------------
  ------ Rediriger les commandes SET ------------------------------------
  ------------------------------------------------------------------------
  La fonction return TRUE si la commande a ete executee                   */
#pragma argsused
int CSET_execute(int StreamNum, char * pCmd_p, int nParams, char **pArg, char **pStrArg)
{
	int Length;			/*Longueur de la commande*/

	if( *pArg[0] == SNULL )
		return FALSE;

	/*Longueur de la commande*/
	Length = strlen (pArg[0]);

	if( COMMANDS_check(pArg[0], "annoucements", Length, 1) )
		return CSET_announcements(StreamNum, nParams, pArg, pStrArg);

	if( COMMANDS_check(pArg[0], "ann_age", Length, 5) )
		return CSET_annAge(StreamNum, nParams, pArg, pStrArg);

	if( COMMANDS_check(pArg[0], "beep", Length, 2) )
		return CSET_beep(StreamNum, nParams, pArg, pStrArg);

	if( COMMANDS_check(pArg[0], "blackcall", Length, 5) )
		return CSET_blackcall(StreamNum, nParams, pArg, pStrArg);

	if( COMMANDS_check(pArg[0], "call", Length, 2) )
		return CSET_call(StreamNum, nParams, pArg, pStrArg);

#ifdef DOS
	if( COMMANDS_check(pArg[0], "console", Length, 3) )
		return CSET_console(StreamNum, nParams, pArg, pStrArg);
#endif

	if( COMMANDS_check(pArg[0], "dx_age", Length, 5) )
		return CSET_dxAge(StreamNum, nParams, pArg, pStrArg);

	if( COMMANDS_check(pArg[0], "dx_annoucements", Length, 2) )
		return CSET_dxAnnouncements(StreamNum, nParams, pArg, pStrArg);

	if( COMMANDS_check(pArg[0], "date", Length, 1) )
		return CSET_date(StreamNum, nParams, pArg, pStrArg);

	if( COMMANDS_check(pArg[0], "cfilter", Length, 4) )
		return CSET_cfilter(StreamNum, nParams, pArg, pStrArg);

	if( COMMANDS_check(pArg[0], "diddle", Length, 3) )
		return CSET_diddle(StreamNum, nParams, pArg, pStrArg);

	if( COMMANDS_check(pArg[0], "dxssid", Length, 3) )
		return CSET_dxssid(StreamNum, nParams, pArg, pStrArg);

	if( COMMANDS_check(pArg[0], "filter", Length, 1) )
		return CSET_filter(StreamNum, nParams, pArg, pStrArg);

	if( COMMANDS_check(pArg[0], "here", Length, 2) )
		return CSET_here(StreamNum, nParams, pArg, pStrArg);

	if( COMMANDS_check(pArg[0], "home", Length, 2) )
		return CSET_home(StreamNum, nParams, pArg, pStrArg);

	if( COMMANDS_check(pArg[0], "language", Length, 3) )
		return CSET_language(StreamNum, nParams, pArg, pStrArg);

	if( COMMANDS_check(pArg[0], "ldefault", Length, 4) )
		return CSET_ldefault(StreamNum, nParams, pArg, pStrArg);

	if( COMMANDS_check(pArg[0], "locator", Length, 3) )
		return CSET_locator(StreamNum, nParams, pArg, pStrArg);

	if( COMMANDS_check(pArg[0], "login", Length, 4) )
		return CSET_login(StreamNum, nParams, pArg, pStrArg);

	if( COMMANDS_check(pArg[0], "lfilter", Length, 2) )
		return CSET_lfilter(StreamNum, nParams, pArg, pStrArg);

	if( COMMANDS_check(pArg[0], "logs", Length, 3) )
		return CSET_logs(StreamNum, nParams, pArg, pStrArg);

	if( COMMANDS_check(pArg[0], "motd", Length, 3) )
		return CSET_motd(StreamNum, nParams, pArg, pStrArg);

	if( COMMANDS_check(pArg[0], "monitor", Length, 3) )
		return CSET_monitor(StreamNum, nParams, pArg, pStrArg);

#ifdef DOS
	if( COMMANDS_check(pArg[0], "mycall", Length, 2) )
		return CSET_mycall(StreamNum, nParams, pArg, pStrArg);
#endif

  if( COMMANDS_check(pArg[0], "name", Length, 3) )
    return CSET_name(StreamNum, nParams, pArg, pStrArg);

  if( COMMANDS_check(pArg[0], "noannouncements", Length, 3) )
    return CSET_noAnnouncements(StreamNum, nParams, pArg, pStrArg);

	if( COMMANDS_check(pArg[0], "nobeep", Length, 3) )
		return CSET_nobeep(StreamNum, nParams, pArg, pStrArg);

	if( COMMANDS_check(pArg[0], "nodx_announcements", Length, 3) )
		return CSET_noDxAnnouncements(StreamNum, nParams, pArg, pStrArg);

	if( COMMANDS_check(pArg[0], "nofilter", Length, 3) )
		return CSET_nofilter(StreamNum, nParams, pArg, pStrArg);

	if( COMMANDS_check(pArg[0], "nologin", Length, 3) )
		return CSET_nologin(StreamNum, nParams, pArg, pStrArg);

	if( COMMANDS_check(pArg[0], "nopage", Length, 3) )
		return CSET_noPageLength(StreamNum, nParams, pArg, pStrArg);

	if( COMMANDS_check(pArg[0], "nowwfilter", Length, 3) )
		return CSET_nowwfilter(StreamNum, nParams, pArg, pStrArg);

	if( COMMANDS_check(pArg[0], "node", Length, 1) )
		return CSET_node(StreamNum, nParams, pArg, pStrArg);

	if( COMMANDS_check(pArg[0], "nohere", Length, 3) )
		return CSET_nohere(StreamNum, nParams, pArg, pStrArg);

	if( COMMANDS_check(pArg[0], "noregister", Length, 4) )
		return CSET_noregister(StreamNum, nParams, pArg, pStrArg);

	if( COMMANDS_check(pArg[0], "page", Length, 2) )
		return CSET_pageLength(StreamNum, nParams, pArg, pStrArg);

	if( COMMANDS_check(pArg[0], "pfilter", Length, 2) )
		return CSET_pfilter(StreamNum, nParams, pArg, pStrArg);

	if( COMMANDS_check(pArg[0], "register", Length, 2) )
		return CSET_register(StreamNum, nParams, pArg, pStrArg);

	if( COMMANDS_check(pArg[0], "spot_age", Length, 4) )
		return CSET_dxAge(StreamNum, nParams, pArg, pStrArg);

	if( ! strcmp(pArg[0], "qth") )
		return CSET_qth(StreamNum, nParams, pArg, pStrArg);

#ifndef DOS
	if( COMMANDS_check(pArg[0], "telnet_access", Length, 3) )
		return CSET_telnetAccess(StreamNum, nParams, pArg, pStrArg);
#endif

	if( ! strcmp(pArg[0], "tz") )
		return CSET_tz(StreamNum, nParams, pArg, pStrArg);

#ifdef DOS
	if( ! strcmp(pArg[0], "spy") )
		return CSET_spy(StreamNum, nParams, pArg, pStrArg);
#endif

	if( ! strcmp(pArg[0], "ssid") )
		return CSET_ssid(StreamNum, nParams, pArg, pStrArg);

	if( COMMANDS_check(pArg[0], "sysop", Length, 3) )
		return CSET_sysop(StreamNum, nParams, pArg, pStrArg);

	if( COMMANDS_check(pArg[0], "time", Length, 1) )
		return CSET_time(StreamNum, nParams, pArg, pStrArg);

	if( COMMANDS_check(pArg[0], "usercmd", Length, 5) )
		return CSET_usercmd(StreamNum, nParams, pArg, pStrArg);

#ifndef DOS
	if( ! strcmp(pArg[0], "port") )
		return CSET_port(StreamNum, nParams, pArg, pStrArg);
#endif

	if( COMMANDS_check(pArg[0], "wwfilter", Length, 3) )
		return CSET_wwfilter(StreamNum, nParams, pArg, pStrArg);

	return FALSE;		/*La commande n'a pas ete trouvee*/
}

/*------------------------------------------------------------------------
  ------ SET/ANNOUNCEMENTS -----------------------------------------------
  ------------------------------------------------------------------------*/
#pragma argsused
int CSET_announcements(int StreamNum, int nParams, char **pArg, char **pStrArg)
{
	unsigned int nFlags;
	extern char *MSG_pParams[10];
	char szBuffer[256];

	/* Niveau d'utilisateur remote command */
	if( ! RCMD_isAllowed(StreamNum, RCMD_NOTALLOWED) )
		return FALSE;

	if( nParams != 1 )
	{
		MSG_send(StreamNum, MSG58);	/*Nbr d'arg incorrect*/
		Prompt;
		return TRUE;
	}

	/* Modifier le flag */
	nFlags  = USERS_getFlags (StreamNum);
	nFlags &= ~USERS_NOANNOUNCEMENTS;
	USERS_setFlags(StreamNum, nFlags);

	/* Affichage de confirmation de la commande */
	MSG_get(StreamNum, MSG63, szBuffer); /* valide */
	if( szBuffer[0] ) /* Si buffer non vide */
		szBuffer[strlen(szBuffer) - 1] = SNULL;
	MSG_pParams[9] = szBuffer;
	MSG_send(StreamNum, MSG77);

	Prompt;
	return TRUE;
}

/*------------------------------------------------------------------------
  ------ SET/ANN_AGE ------------------------------------------------------
  ------------------------------------------------------------------------*/
#pragma argsused
int CSET_annAge(int StreamNum, int nParams, char **pArg, char **pStrArg)
{
	extern char	STREAMS_level[MAX_STREAMS];
	extern char    *MSG_pParams[10];
	extern long	PARAMS_lAnnDupeAllowed;

	char   szTime[256];
	long   lTime;

	/* Niveau d'utilisateur */
	if( ! (STREAMS_level[StreamNum] & LEVEL_sysopV) )
		return FALSE;

	/* Niveau d'utilisateur remote command */
	if( StreamNum >= RCMD_VIRTSTREAM && ! RCMD_isAllowed(StreamNum, RCMD_SYSOP) )
		return FALSE;

	if( nParams != 2 )
	{
		MSG_send(StreamNum, MSG58);   /* Nbr d'arg incorrect */
		Prompt;
		return TRUE;
	}

	lTime = TOOLS_parseTime(pArg[1]);

	if( lTime < 0 )
	{
		MSG_pParams[9] = "SET/DX_AGE 1d";
		MSG_pParams[8] = pArg[1];
		MSG_send(StreamNum, MSG74);
		Prompt;
		return TRUE;
	}

	PARAMS_lAnnDupeAllowed = lTime;
	TOOLS_seconds2string(PARAMS_lAnnDupeAllowed,  szTime);

	BUFFERS_printBuff(StreamNum, OUT, "Annonce age : %s\n",
		szTime);

	Prompt;
	return TRUE;
}

/*------------------------------------------------------------------------
  ------ SET/BEEP --------------------------------------------------------
  ------------------------------------------------------------------------*/
#pragma argsused
int CSET_beep(int StreamNum, int nParams, char **pArg, char **pStrArg)
{
	unsigned int iFlags;
	char	       szBuffer[256];
	extern char *MSG_pParams[10];

	/* Niveau d'utilisateur remote command */
	if( ! RCMD_isAllowed(StreamNum, RCMD_NOTALLOWED) )
		return FALSE;

	if( nParams != 1 )
	{
		MSG_send(StreamNum, MSG58);		/*Nbr d'arg incorrect*/
		Prompt;
		return TRUE;
	}

	/*Modifier le flag (NOBEEP a mettre a 0)*/
	iFlags  = USERS_getFlags (StreamNum);
	iFlags &= ~USERS_NOBEEP;
	USERS_setFlags(StreamNum, iFlags);

	/* Affichage de confirmation de la commande */
	BUFFERS_printBuff(StreamNum, OUT, "%c", BELL);
	MSG_get(StreamNum, MSG63, szBuffer); /* valide */
	if( szBuffer[0] ) /* Si buffer non vide */
		szBuffer[strlen(szBuffer) - 1] = SNULL;
	MSG_pParams[9] = szBuffer;
	MSG_send(StreamNum, MSG65);

	Prompt;
	return TRUE;
}

/*------------------------------------------------------------------------
  ------ SET/BLACKCALL ---------------------------------------------------
  ------------------------------------------------------------------------*/
#pragma argsused
int CSET_blackcall(int StreamNum, int nParams, char **pArg, char **pStrArg)
{
	extern char	STREAMS_level[MAX_STREAMS];
	extern char  *PARAMS_blackCalls;

	/*Niveau d'utilisateur*/
	if( ! (STREAMS_level[StreamNum] & LEVEL_sysopV) )
		return FALSE;

	/* Niveau d'utilisateur remote command */
	if( ! RCMD_isAllowed(StreamNum, RCMD_SYSOP) )
		return FALSE;

	if( nParams != 1 )	  /*Seulement si des arguments ont ete donnes*/
		SET_params(PARAMS_blackCalls, pStrArg[1]);

	BUFFERS_printBuff(StreamNum, OUT, "SET/BLACKCALLS :%s\n",
		PARAMS_blackCalls);

	Prompt;
	return TRUE;
}

/*------------------------------------------------------------------------
  ------ SET/CALL --------------------------------------------------------
  ------------------------------------------------------------------------*/
#pragma argsused
int CSET_call(int StreamNum, int nParams, char **pArg, char **pStrArg)
{
	extern char	STREAMS_level[MAX_STREAMS];
	extern char	STREAMS_callsign[MAX_STREAMS][10];
	char	sNodeCall[16];
	int   nFlags;

	/* Niveau d'utilisateur remote command */
	if( ! RCMD_isAllowed(StreamNum, RCMD_NOTALLOWED) )
		return FALSE;

	/*Niveau d'utilisateur*/
	if( ! (STREAMS_level[StreamNum] & LEVEL_sysopV) )
		return FALSE;

	/*Sans argument, affiche le call actuel*/
	if( nParams == 1 )
	{
		BUFFERS_printBuff(StreamNum, OUT, "SET/CALL : %s\n",
			NODE_getNodeCall(0, 0, sNodeCall) );
		Prompt;
		return TRUE;
	}

	/*Nombre d'arguments incorrect*/
	if( nParams > 2 )
	{
		MSG_send(StreamNum, MSG58);
		Prompt;
		return TRUE;
	}

	/*Indicatif en majuscules*/
	strupr (pArg[1]);

	/*Verifier que l'indicatif est valide*/
	if( ! TOOLS_isCall (pArg[1]) )
	{
		MSG_send(StreamNum, MSG18);
		Prompt;
		return TRUE;
	}

	BUFFERS_printBuff(StreamNum, OUT, "SET/CALL : %s\n     was : %s\n",
		    pArg[1],
		    NODE_getNodeCall(0, 0, sNodeCall) );

	NODE_myNodeCall (pArg[1]);
	HOPS_readFile(0, pArg[1]);

	/* Definir ma zone WAZ */
	FILTER_setMyWAZ(pArg[1]);

	strcpy(STREAMS_callsign[0],  pArg[1]); 	/*Indicatif ecran 0*/
	strcpy(STREAMS_callsign[65], pArg[1]);	/*Indicatif ecran 1*/

	/* Charger la config */
	USERS_openRecord(0,  pArg[1]);
	USERS_openRecord(65, pArg[1]);

	/* Initialiser les filtres */
	nFlags = USERS_getFlags(0);
	FILTER_setUser(0, nFlags);
	nFlags = USERS_getFlags(65);
	FILTER_setUser(65, nFlags);

	Prompt;
	return TRUE;
}

/*------------------------------------------------------------------------
  ------ SET/CFILTER -----------------------------------------------------
  ------------------------------------------------------------------------*/
#pragma argsused
int CSET_cfilter(int StreamNum, int nParams, char **pArg, char **pStrArg)
{
	extern char	STREAMS_level[MAX_STREAMS];
	extern int	PARAMS_nCFilter;

	char	*pszString[] = {"- off",
				"- password required - closed system)",
				"- password required - RX only",
				"- no password required - RX only"};

	/* Niveau d'utilisateur remote command */
	if( ! RCMD_isAllowed(StreamNum, RCMD_NOTALLOWED) )
		return FALSE;

	/*Niveau d'utilisateur*/
	if( ! (STREAMS_level[StreamNum] & LEVEL_sysopV) )
		return FALSE;

	/*Test 'theoriquement' inutile*/
	if( PARAMS_nCFilter < 0 || PARAMS_nCFilter > 3 )
		PARAMS_nCFilter = 0;

	/*Sans argument, affiche le mode actuel*/
	if( nParams == 1 )
	{
		BUFFERS_printBuff(StreamNum, OUT, "SET/CFILTER : %d %s\n",
		      PARAMS_nCFilter, pszString[PARAMS_nCFilter]);

		Prompt;
		return TRUE;
	}

	/*Nombre d'arguments incorrect*/
	if( nParams > 2 )
	{
		MSG_send(StreamNum, MSG58);
		Prompt;
		return TRUE;
	}

	/*Parametre*/
	strlwr (pArg[1]);
	if( strcmp(pArg[1], "off") && strcmp(pArg[1], "0") &&
	    strcmp(pArg[1], "1")   && strcmp(pArg[1], "2") &&
	    strcmp(pArg[1], "3") )
	{
		MSG_send(StreamNum, MSG18);
		BUFFERS_addBuff(StreamNum, "SET/CFILTER <n>\n"
			       " n = 0 -> CFILTER off\n"
			       " n = 1 -> CFILTER on / password required - closed system\n"
			       " n = 2 -> CFILTER on / password required - RX only\n"
			       " n = 3 -> CFILTER on / no password required - RX only\n",
			       OUT);
		Prompt;
		return TRUE;
	}

	BUFFERS_printBuff(StreamNum, OUT, "SET/CFILTER : %s %s\n        was : %d %s\n",
		pArg[1], pszString[atoi (pArg[1])],
		PARAMS_nCFilter, pszString[PARAMS_nCFilter]);

	PARAMS_nCFilter = atoi (pArg[1]);

	Prompt;
	return TRUE;
}

#ifdef DOS
/*------------------------------------------------------------------------
  ------ SET/CONSOLE -----------------------------------------------------
  ------------------------------------------------------------------------*/
#pragma argsused
int CSET_console(int StreamNum, int nParams, char **pArg, char **pStrArg)
{
	extern char	STREAMS_level[MAX_STREAMS];
	int		nConsole;
	char		szCommand[16];

	/* Niveau d'utilisateur remote command */
	if( ! RCMD_isAllowed(StreamNum, RCMD_NOTALLOWED) )
		return FALSE;

	/* Niveau d'utilisateur */
	if( ! (STREAMS_level[StreamNum] & LEVEL_sysopV) )
		return FALSE;

	/* Nombre d'arguments incorrect */
	if( nParams < 2 )
	{
		MSG_send(StreamNum, MSG58);
		Prompt;
		return TRUE;
	}

	/* mode local ? */
	if( ! stricmp(pArg[1], "local") || ! stricmp(pArg[2], "local") )
	{
		COM_setLocal();
		BUFFERS_printBuff(StreamNum, OUT, "CONSOLE : local\n");
		Prompt;
		return TRUE;
	}

	/* Numero de console */
	nConsole = atoi(pArg[1]);
	if( nConsole != 2 && nConsole != 3 )
	{
		BUFFERS_addBuff(StreamNum, "*** Error : bad console number.\n", OUT);
		Prompt;
		return TRUE;
	}

	/* Commande */
	TOOLS_maxLength(pArg[2], 15);
	strcpy(szCommand, pArg[2]);
	strlwr(szCommand);
	if( ! strncmp(szCommand, "com", 3) )
	{
		int nComPort;
		int nIRQ;
		int nSpeed;

		/* Numero de port */
		nComPort = atoi(szCommand + 3);
		if( nComPort < 1 || nComPort > 4 )
		{
			BUFFERS_addBuff(StreamNum, "*** Error : bad COM port.\n", OUT);
			Prompt;
			return TRUE;
		}

		/* IRQ */
		if( szCommand[4] == '/' )
		{
			nIRQ = atoi(szCommand + 5);
		}
		else
		{
			if( nComPort == 1 || nComPort == 3 )
				nIRQ = 4;
			else
				nIRQ = 3;
		}

		/* Vitesse */
		if( pArg[3][0] )
		{
			nSpeed = atoi(pArg[3]);
			if( nSpeed != 1200 && nSpeed != 2400 && nSpeed != 4800 &&
			    nSpeed != 9600 && nSpeed != 19200 )
			{
				BUFFERS_addBuff(StreamNum, "*** Error : bad speed.\n", OUT);
				Prompt;
				return TRUE;
			}
		}
		else
		{
			/* Vitesse par defaut */
			nSpeed = 9600;
		}

		if( ! COM_setPort(nConsole, nComPort, nIRQ, nSpeed) )
		{
			/* Impossible d'ouvrir le port */
			BUFFERS_addBuff(StreamNum,
				"*** Hardware error : failed to open the COM port !\n",
				OUT);
			Prompt;
			return TRUE;
		}

		/* Confirmation */
		BUFFERS_printBuff(StreamNum, OUT,
			"CONSOLE #%d : redirected to COM%d, irq%d, %d bauds.\n",
			 nConsole, nComPort, nIRQ, nSpeed);
	}
	else
	{
		/* erreur */
		BUFFERS_addBuff(StreamNum, "*** Error : bad command.\n", OUT);
		Prompt;
		return TRUE;
	}

	Prompt;
	return TRUE;
}
#endif

/*------------------------------------------------------------------------
  ------ SET/DATE ----------------------------------------------------------
  ------------------------------------------------------------------------*/
#pragma argsused
int CSET_date(int StreamNum, int nParams, char **pArg, char **pStrArg)
{
	extern char	STREAMS_level[MAX_STREAMS];
	extern long   PARAMS_lTz;

	char	szBuffer[256];
	char *pszDate = pArg[1];
	char  szYear[16];
	char	szMonth[16];
	char	szDay[16];
	int	nYear;
	int	nMonth;
	int	nDay;
	time_t t;
	struct tm tDate;

	/* Niveau d'utilisateur remote command */
	if( ! RCMD_isAllowed(StreamNum, RCMD_SYSOP) )
		return FALSE;

	/*Niveau d'utilisateur*/
	if( ! (STREAMS_level[StreamNum] & LEVEL_sysopV) )
		 return FALSE;


	if( nParams != 2 )
	{
		MSG_send(StreamNum, MSG58);		/*Nbr d'arg incorrect*/
		Prompt;
		return TRUE;
	}

	/* Verifier la validite de la date */
	if( strlen(pszDate) != 8 )
	{
		MSG_send(StreamNum, MSG18);	/* invalide */
		BUFFERS_addBuff(StreamNum, "Format : YYYYMMDD (e.g. SET/DATE 20000218)\n", OUT);
		Prompt;
		return TRUE;
	}

	/* Extraire la date */
	strcpy(szDay, pszDate + 6);
	nDay = atoi(szDay);

	strcpy(szMonth, pszDate + 4);
	szMonth[2] = SNULL;
	nMonth = atoi(szMonth);

	strcpy(szYear, pszDate);
	szYear[4] = SNULL;
	nYear = atoi(szYear);

	/* Verifier la validite des donnees saisies */
	if( nDay < 1 || nDay > 31 || nMonth < 1 || nMonth > 12 )
	{
		BUFFERS_addBuff(StreamNum, "Bad arguments in date\n", OUT);
		Prompt;
		return TRUE;
	}

	/* Mettre a jour */
	t     = time(NULL) - PARAMS_lTz;
	tDate = *localtime(&t);
	strftime(szBuffer, 255, "%a %b %d, %Y", &tDate);
	BUFFERS_printBuff(StreamNum, OUT, "Date was : %s (%04d.%02d.%02d)\n",
		    szBuffer,
		    nYear,
		    nMonth,
		    nDay);
	tDate.tm_year = nYear - 1900;
	tDate.tm_mon  = nMonth - 1;
	tDate.tm_mday = nDay;
	t = mktime(&tDate) + PARAMS_lTz;
	stime(&t);
	strftime(szBuffer, 255, "%a %b %d, %Y", &tDate);
	BUFFERS_printBuff(StreamNum, OUT, "     now : %s (%04d.%02d.%02d)\n",
		    szBuffer,
		    nYear,
		    nMonth,
		    nDay);

	Prompt;
	return TRUE;
}

/*------------------------------------------------------------------------
  ------ SET/DX_ANNOUNCEMENT ---------------------------------------------
  ------------------------------------------------------------------------*/
#pragma argsused
int CSET_dxAnnouncements(int StreamNum, int nParams, char **pArg, char **pStrArg)
{
	unsigned int nFlags;
	extern char *MSG_pParams[10];
	char szBuffer[256];

	/* Niveau d'utilisateur remote command */
	if( ! RCMD_isAllowed(StreamNum, RCMD_NOTALLOWED) )
		return FALSE;

	if( nParams != 1 )
	{
		MSG_send(StreamNum, MSG58);	/*Nbr d'arg incorrect*/
		Prompt;
		return TRUE;
	}

	/*Modifier le flag */
	nFlags  = USERS_getFlags (StreamNum);
	nFlags &= ~USERS_NODX;
	USERS_setFlags(StreamNum, nFlags);

	/* Affichage de confirmation de la commande */
	MSG_get(StreamNum, MSG63, szBuffer); /* valide */
	if( szBuffer[0] ) /* Si buffer non vide */
		szBuffer[strlen(szBuffer) - 1] = SNULL;
	MSG_pParams[9] = szBuffer;
	MSG_send(StreamNum, MSG76);

	Prompt;
	return TRUE;
}

/*------------------------------------------------------------------------
  ------ SET/DIDDLE ------------------------------------------------------
  ------------------------------------------------------------------------*/
#pragma argsused
int CSET_diddle(int StreamNum, int nParams, char **pArg, char **pStrArg)
{
	extern char	STREAMS_level[MAX_STREAMS];
	extern int	PARAMS_iDefaultDiddle;

	/*Niveau d'utilisateur*/
	if( ! (STREAMS_level[StreamNum] & LEVEL_sysopV) )
		return FALSE;

	/* Niveau d'utilisateur remote command */
	if( ! RCMD_isAllowed(StreamNum, RCMD_SYSOP) )
		return FALSE;

	if( nParams > 2 )
	{
		MSG_send(StreamNum, MSG58);		/*Nbr d'arg incorrect*/
		Prompt;
		return TRUE;
	}

	if( nParams == 2 ) 			/*une valeur ?*/
		PARAMS_iDefaultDiddle = atoi (pArg[1]);

	/*Si le sysop entre la valeur 0, desactiver la commande (-> mettre -1)*/
	if( PARAMS_iDefaultDiddle == 0 )
		PARAMS_iDefaultDiddle = -1;

	BUFFERS_addBuff(StreamNum, "SET/DIDDLE : ", OUT);
	if( PARAMS_iDefaultDiddle > 0 )
		BUFFERS_printBuff(StreamNum, OUT, "%d s\n", PARAMS_iDefaultDiddle);
	else
		BUFFERS_addBuff(StreamNum, "off\n", OUT);

	Prompt;
	return TRUE;
}

/*------------------------------------------------------------------------
  ------ SET/DX_AGE ------------------------------------------------------
  ------------------------------------------------------------------------*/
#pragma argsused
int CSET_dxAge(int StreamNum, int nParams, char **pArg, char **pStrArg)
{
	extern char	STREAMS_level[MAX_STREAMS];
	extern char    *MSG_pParams[10];
	extern long	PARAMS_lDxRejectBefore;
	extern long	PARAMS_lDxRejectAfter;

	int    index;
	int    nAllParams = 0;
	int    nErrorArg  = 0;
	char   szTime1[256];
	char   szTime2[256];

	/* Niveau d'utilisateur */
	if( ! (STREAMS_level[StreamNum] & LEVEL_sysopV) )
		return FALSE;

	/* Niveau d'utilisateur remote command */
	if( ! RCMD_isAllowed(StreamNum, RCMD_NOTALLOWED) )
		return FALSE;

	/* Lecture des infos */
	for(index = 1; index < nParams; index++)
	{
		long lTime = TOOLS_parseTime(pArg[index] + 1);

		if( lTime < 0 )
		{
			/* Mauvaise syntaxe */
			nErrorArg = index;
			break;
		}

		switch( pArg[index][0] )
		{
		case '-' :
			/* Deja defini ? */
			if( nAllParams & 1 )
				nErrorArg = index;
			else
			{
				PARAMS_lDxRejectBefore = lTime;
				nAllParams |= 1;
			}
			break;

		case '+' :
			/* Deja defini ? */
			if( nAllParams & 2 )
				nErrorArg = index;
			else
			{
				PARAMS_lDxRejectAfter = lTime;
				nAllParams |= 2;
			}
			break;

		default :
			nErrorArg = index;
			break;
		}

		if( nErrorArg != 0 )
			break;
	}

	/* Erreur de syntaxe ? */
	if( nErrorArg )
	{
		MSG_pParams[9] = "SET/DX_AGE -60 +15";
		MSG_pParams[8] = pArg[index];
		MSG_send(StreamNum, MSG74);
		Prompt;
		return TRUE;
	}

	/* Tous les arguments sont-ils definis ? */
	if( ! (nAllParams & 3) )
	{
		MSG_send(StreamNum, MSG58); /* Nbr d'arg incorrect */
		Prompt;
		return TRUE;
	}

	TOOLS_seconds2string(PARAMS_lDxRejectBefore, szTime1);
	TOOLS_seconds2string(PARAMS_lDxRejectAfter,  szTime2);

	BUFFERS_printBuff(StreamNum, OUT, "DX spot age : -%s +%s\n",
		szTime1, szTime2);

	Prompt;
	return TRUE;
}

#ifdef DOS
/*------------------------------------------------------------------------
  ------ SET/SPY ---------------------------------------------------------
  ------------------------------------------------------------------------*/
#pragma argsused
int CSET_spy(int StreamNum, int nParams, char **pArg, char **pStrArg)
{
	extern char	STREAMS_level[MAX_STREAMS];
	int	nPort;
	int	nHops;

	/* Niveau d'utilisateur remote command */
	if( ! RCMD_isAllowed(StreamNum, RCMD_NOTALLOWED) )
		return FALSE;

	/*Niveau d'utilisateur*/
	if( ! (STREAMS_level[StreamNum] & LEVEL_sysopV) )
		return FALSE;

	if( nParams == 1 || nParams > 3 )
	{
SPY_ERR:
		BUFFERS_addBuff(StreamNum, "SET/SPY <port> <hops>\n"
			       "<port> : 0-15\n"
			       "<hops> : 0-99\n", OUT);
		Prompt;
		return TRUE;
	}

	strlwr (pArg[1]);
	if( ! strcmp (pArg[1], "off") )
		nPort = -1;
	else
		nPort = atoi (pArg[1]);

	if( nPort != -1 && nParams != 3 )
		goto SPY_ERR;

	nHops = atoi (pArg[2]);

	if( nPort < -1 || nPort > 15 || nHops < 0 || nHops > 99 )
	{
		BUFFERS_addBuff(StreamNum, "*** Error : out of range.\n", OUT);
		goto SPY_ERR;
	}

	SPY_set(nPort, nHops);

	if( nPort != -1 )
		BUFFERS_printBuff(StreamNum, OUT,
		      "SET/SPY activated on port %d. Hop count set to %d\n",
		      nPort, nHops);
	else
		BUFFERS_addBuff(StreamNum, "SET/SPY disabled.\n", OUT);

	Prompt;
	return TRUE;
}
#endif

/*------------------------------------------------------------------------
  ------ SET/DXSSID ------------------------------------------------------
  ------------------------------------------------------------------------*/
#pragma argsused
int CSET_dxssid(int StreamNum, int nParams, char **pArg, char **pStrArg)
{
	extern char	STREAMS_level[MAX_STREAMS];
	extern int	PARAMS_iSetDxSsid;
	int	iDxSsid;

	/* Niveau d'utilisateur remote command */
	if( ! RCMD_isAllowed(StreamNum, RCMD_NOTALLOWED) )
		return FALSE;

	/*Niveau d'utilisateur*/
	if( ! (STREAMS_level[StreamNum] & LEVEL_sysopV) )
		return FALSE;

	if( nParams == 1 )
	{
		BUFFERS_printBuff(StreamNum, OUT, "SET/DXSSID : %s\n", (PARAMS_iSetDxSsid ? "ON" : "OFF"));
		Prompt;
		return TRUE;
	}

	strupr (pArg[1]);

	if( ! strcmp(pArg[1], "ON") )
		iDxSsid = TRUE;   			/*Sur ON*/
	else if( ! strcmp(pArg[1], "OFF") )
		iDxSsid = FALSE;                    /*Sur OFF*/
	else
	{
		MSG_send(StreamNum, MSG18);         /*Erreur*/
		BUFFERS_addBuff(StreamNum, "Example : SET/SSID ON  or  SET/SSID OFF\n", OUT);
		Prompt;
		return TRUE;
	}

	/*Afficher le resultat et memoriser*/
	BUFFERS_printBuff(StreamNum, OUT, "SET/DXSSID : %s\n       was : %s\n",
		    (iDxSsid ? "ON" : "OFF"),
		    (PARAMS_iSetDxSsid ? "ON" : "OFF"));
	PARAMS_iSetDxSsid = iDxSsid;

	Prompt;
	return TRUE;
}

/*------------------------------------------------------------------------
  ------ SET/FILTER ------------------------------------------------------
  ------------------------------------------------------------------------*/
#pragma argsused
int CSET_filter(int StreamNum, int nParams, char **pArg, char **pStrArg)
{
	extern char  *MSG_pParams[10];
	extern tUser *pUser;

	char  szRules[256];
	char *token;
	unsigned long lGenRules;
	unsigned long lRules;
	int   nInvert;

	/* Niveau d'utilisateur remote command */
	if( ! RCMD_isAllowed(StreamNum, RCMD_NOTALLOWED) )
		return FALSE;

	/* Recuperer les parametres de filtrage */
	USERS_getRecord(StreamNum);
	lGenRules = ~(pUser->lBandsOff);

	if( nParams == 1 )
	{
		UFILTER_show(StreamNum, lGenRules);
		Prompt;
		return TRUE;
	}

	if( (lGenRules & USERS_ALLMODES) == USERS_ALLMODES &&
	    (lGenRules & USERS_ALLBANDS) == USERS_ALLBANDS )
		lGenRules = 0L;

	/* Exemple pour les messages d'erreur */
	MSG_pParams[9] = "SET/FILTER HF !WARC !160m CW";

	/* Ajouter les nouvelles regles */
	strcpy(szRules, pStrArg[1]);
	strupr(szRules);
	token = strtok(szRules, " ");
	while(token)
	{
		char * pszRule = token;

		/* Caractere inverse ? */
		if( *pszRule == '!' )
		{
			nInvert = TRUE;
			pszRule++;
		}
		else
			nInvert = FALSE;

		/* Frequence ou Bande */
		if( (lRules = TOOLS_frequency2bits(pszRule)) == 0 )
		{
			/* Ce n'est pas une frequence ... */
			if     (! strcmp(pszRule, "VLF"))
				lRules = USERS_2KM;
			else if(! strcmp(pszRule, "HF"))
				lRules = USERS_160M | USERS_80M | USERS_40M |
					 USERS_30M  | USERS_20M | USERS_17M |
					 USERS_15M  | USERS_12M | USERS_10M;
			else if(! strcmp(pszRule, "WARC"))
				lRules = USERS_30M | USERS_17M | USERS_12M;
			else if(! strcmp(pszRule, "VHF"))
				lRules = USERS_6M | USERS_4M | USERS_2M | USERS_135CM;
			else if(! strcmp(pszRule, "UHF"))
				lRules = USERS_70CM | USERS_34CM | USERS_23CM |
					 USERS_13CM;
			else if(! strcmp(pszRule, "SHF"))
				lRules = USERS_5CM | USERS_3CM | USERS_1CM;
			else if(! strcmp(pszRule, "ALL"))
				lRules = 0xFFFFFFFFL;
			else if(! strcmp(pszRule, "CW"))   lRules |= USERS_CW;
			else if(! strcmp(pszRule, "SSB"))  lRules |= USERS_SSB;
			else if(! strcmp(pszRule, "RTTY")) lRules |= USERS_RTTY;
			else
			{
				MSG_pParams[8] = token;
				MSG_send(StreamNum, MSG74);
				Prompt;
				return TRUE;
			}
		}

		/* Ajouter la regle */
		if( nInvert )
			lGenRules &= ~lRules;
		else
			lGenRules |= lRules;

		token = strtok(NULL, " ");
	}

	if( ! (lGenRules & USERS_ALLMODES) )
		lGenRules |= USERS_ALLMODES;

	UFILTER_show(StreamNum, lGenRules);
	pUser->lBandsOff = ~lGenRules;
	USERS_updateRecord(StreamNum);

	Prompt;
	return TRUE;
}


/*------------------------------------------------------------------------
  ------ SET/HERE --------------------------------------------------------
  ------------------------------------------------------------------------*/
#pragma argsused
int CSET_here(int StreamNum, int nParams, char **pArg, char **pStrArg)
{
	extern char	STREAMS_callsign[MAX_STREAMS][10];
	char		sNodeCall[16];
	char		sUserCall[16];

	/* Niveau d'utilisateur remote command */
	if( ! RCMD_isAllowed(StreamNum, RCMD_NOTALLOWED) )
		return FALSE;

	if( nParams != 1 )
	{
		MSG_send(StreamNum, MSG58);		/*Nbr d'arg incorrect*/
		Prompt;
		return TRUE;
	}

	/*Rcuprer en mmoire les indicatifs du serveur et de l'utilisateur*/
	NODE_getNodeCall(0, 0, sNodeCall);
	strcpy(sUserCall, STREAMS_callsign[StreamNum]);

	/*Transmettre l'info aux adjacents*/
	PROTOCOL_sendUserFlag(0, sNodeCall, sUserCall, PROTOCOL_USER_HERE,
		TRUE, 100);

	/*Message  l'utilisateur*/
	MSG_send(StreamNum, MSG27);

	Prompt;
	return TRUE;
}

/*------------------------------------------------------------------------
  ------ SET/HOME --------------------------------------------------------
  ------------------------------------------------------------------------*/
#pragma argsused
int CSET_home(int StreamNum, int nParams, char **pArg, char **pStrArg)
{
	extern tUser   *pUser;
	char	sNodeCall[16];

	/* Niveau d'utilisateur remote command */
	if( ! RCMD_isAllowed(StreamNum, RCMD_NOTALLOWED) )
		return FALSE;

	if( nParams != 2 )
	{
		MSG_send(StreamNum, MSG17);
		Prompt;
		return TRUE;
	}

	/*Limiter la longueur de l'indicatif : 9 car*/
	TOOLS_maxLength(pArg[1], 9);
	strupr (pArg[1]);

	/*Acceder au bloc utilisateur, mettre a jour et updater*/
	USERS_getRecord (StreamNum);
	strcpy(pUser->sHomeNode, pArg[1]);
	USERS_updateRecord (StreamNum);

	/*Transmettre l'info sur le reseau cluster*/
	NODE_getNodeCall(0, 0, sNodeCall);
	PROTOCOL_sendUserConfig(0, sNodeCall, pUser->sCallSign, pArg[1],
		USERS_HOME, 100);

	MSG_send(StreamNum, MSG16);
	Prompt;
	return TRUE;
}

/*------------------------------------------------------------------------
  ------ SET/LANGUAGE ----------------------------------------------------
  ------------------------------------------------------------------------*/
#pragma argsused
int CSET_language(int StreamNum, int nParams, char **pArg, char **pStrArg)
{
	extern char	STREAMS_lang[MAX_STREAMS];
	extern tUser *pUser;
	int	iLang;
  
	/* Niveau d'utilisateur remote command */
	if( ! RCMD_isAllowed(StreamNum, RCMD_NOTALLOWED) )
		return FALSE;

	/*L'utilisateur  t-il indiqu un numro ?*/
	if( nParams == 2 )
		iLang = atoi (pArg[1]) - 1;	/*Oui : le lire*/
	else
		iLang = STREAMS_lang[StreamNum];	/*Non : prendre l'actuel*/

	if( LANG_isDefined (iLang) )
	{
		/*Ok*/
		STREAMS_lang[StreamNum] = iLang;
		MSG_send(StreamNum, MSG10);

		/*Accder  la config user, et updater*/
		USERS_getRecord(StreamNum);
		pUser->byLanguage = iLang;
		USERS_updateRecord(StreamNum);
	}
	else
	{
		/*Cette langue n'est pas definie*/
		MSG_send(StreamNum, MSG11);
	}/*End IF*/

	Prompt;
	return TRUE;
}

/*------------------------------------------------------------------------
  ------ SET/LDEFAULT ----------------------------------------------------
  ------------------------------------------------------------------------*/
#pragma argsused
int CSET_ldefault(int StreamNum, int nParams, char **pArg, char **pStrArg)
{
	extern char	STREAMS_level[MAX_STREAMS];
	extern char	USERS_defaultLanguage;
	int	iLang;

	/* Niveau d'utilisateur remote command */
	if( ! RCMD_isAllowed(StreamNum, RCMD_NOTALLOWED) )
		return FALSE;

	/*Niveau d'utilisateur*/
	if( ! (STREAMS_level[StreamNum] & LEVEL_sysopV) )
		return FALSE;

	/*Le sysop a t-il indiqu un numro ?*/
	if( nParams == 2 )
		iLang = atoi (pArg[1]) - 1;				/*Oui : le lire*/
	else
		iLang = (unsigned int) USERS_defaultLanguage;       /*Non : prendre l'actuel*/

	if( LANG_isDefined (iLang) )
	{
		/*Ok*/
		USERS_defaultLanguage = (unsigned char) iLang;
		BUFFERS_printBuff(StreamNum, OUT, "Default language : %d.\n", iLang + 1);
	}
	else
	{
		/*Cette langue n'est pas definie*/
		MSG_send(StreamNum, MSG11);
	}/*End IF*/

	Prompt;
	return TRUE;
}

/*------------------------------------------------------------------------
  ------ SET/LOCATOR -----------------------------------------------------
  ------------------------------------------------------------------------*/
#pragma argsused
int CSET_locator(int StreamNum, int nParams, char **pArg, char **pStrArg)
{
	extern tUser   *pUser;
	char sNodeCall[16];

	/* Niveau d'utilisateur remote command */
	if( ! RCMD_isAllowed(StreamNum, RCMD_NOTALLOWED) )
		return FALSE;

	/*L'utilisateur  t-il indiqu le locator ?*/
	if( nParams != 2 )
	{
		/*Message d'erreur*/
		MSG_send(StreamNum, MSG58);

		Prompt;
		return TRUE;
	}

	strupr (pArg[1]);

	/* Test validite locator */
	if( ! LOCATOR_isValidWW(pArg[1]) )
	{
		MSG_send(StreamNum, MSG18);

		Prompt;
		return TRUE;
	}

	/*Accder au bloc user et updater*/
	USERS_getRecord(StreamNum);
	strcpy(pUser->sLocator, pArg[1]);
	USERS_updateRecord(StreamNum);

	/*Transmettre l'info sur le reseau cluster*/
	NODE_getNodeCall(0, 0, sNodeCall);
	PROTOCOL_sendUserConfig(0, sNodeCall, pUser->sCallSign,
		pArg[1], USERS_LOCATOR, 100);

	/*Afficher le message*/
	MSG_send(StreamNum, MSG15);

	Prompt;
	return TRUE;
}

/*------------------------------------------------------------------------
  ------ SET/LOGIN -------------------------------------------------------
  ------------------------------------------------------------------------*/
#pragma argsused
int CSET_login(int StreamNum, int nParams, char **pArg, char **pStrArg)
{
	unsigned int iFlags;
	char	       szBuffer[256];
	extern char *MSG_pParams[10];

	/* Niveau d'utilisateur remote command */
	if( ! RCMD_isAllowed(StreamNum, RCMD_NOTALLOWED) )
		return FALSE;

	if( nParams != 1 )
	{
		MSG_send(StreamNum, MSG58);		/*Nbr d'arg incorrect*/
		Prompt;
		return TRUE;
	}

	/*Modifier le flag (NOLOGIN a mettre a 0)*/
	iFlags  = USERS_getFlags (StreamNum);
	iFlags &= ~USERS_NOLOGIN;
	USERS_setFlags(StreamNum, iFlags);

	/* Affichage de confirmation de la commande */
	MSG_get(StreamNum, MSG63, szBuffer); /* valide */
	if( szBuffer[0] ) /* Si buffer non vide */
		szBuffer[strlen(szBuffer) - 1] = SNULL;
	MSG_pParams[9] = szBuffer;
	MSG_send(StreamNum, MSG66);

	Prompt;
	return TRUE;
}

/*------------------------------------------------------------------------
  ------ SET/LOGS --------------------------------------------------------
  ------------------------------------------------------------------------*/
#pragma argsused
int CSET_logs(int StreamNum, int nParams, char **pArg, char **pStrArg)
{
	extern char	STREAMS_level[MAX_STREAMS];
	extern char  *PARAMS_logs;

	/* Niveau d'utilisateur remote command */
	if( ! RCMD_isAllowed(StreamNum, RCMD_NOTALLOWED) )
		return FALSE;

	/*Niveau d'utilisateur*/
	if( ! (STREAMS_level[StreamNum] & LEVEL_sysopV) )
		return FALSE;

	if( nParams != 1 )	  /*Seulement si des arguments ont ete donnes*/
		SET_params(PARAMS_logs, pStrArg[1]);

	BUFFERS_printBuff(StreamNum, OUT, "SET/LOGS :%s\n", PARAMS_logs);

	Prompt;
	return TRUE;
}

/*------------------------------------------------------------------------
  ------ SET/LFILTER -----------------------------------------------------
  ------------------------------------------------------------------------*/
#pragma argsused
int CSET_lfilter(int StreamNum, int nParams, char **pArg, char **pStrArg)
{
	extern char	STREAMS_level[MAX_STREAMS];
	extern int	HOPS_nLFilterEnabled;
	int	        nIsEnabled;

	/* Niveau d'utilisateur remote command */
	if( ! RCMD_isAllowed(StreamNum, RCMD_NOTALLOWED) )
		return FALSE;

	/*Niveau d'utilisateur*/
	if( ! (STREAMS_level[StreamNum] & LEVEL_sysopV) )
		return FALSE;

	if( nParams == 1 )
	{
		BUFFERS_printBuff(StreamNum, OUT, "SET/LFILTER : %s\n", (HOPS_nLFilterEnabled ? "ON" : "OFF"));
		Prompt;
		return TRUE;
	}

	strupr (pArg[1]);

	if( ! strcmp(pArg[1], "ON") )
		nIsEnabled = TRUE;   	      	/*Sur ON*/
	else if( ! strcmp(pArg[1], "OFF") )
		nIsEnabled = FALSE;             /*Sur OFF*/
	else
	{
		MSG_send(StreamNum, MSG18);	/*Erreur*/
		BUFFERS_addBuff(StreamNum, "Example : SET/LFILTER ON  or  SET/LFILTER OFF\n", OUT);
		Prompt;
		return TRUE;
	}

	/*Afficher le resultat et memoriser*/
	BUFFERS_printBuff(StreamNum, OUT, "SET/LFILTER : %s\n        was : %s\n",
		(nIsEnabled ? "ON" : "OFF"),
		(HOPS_nLFilterEnabled ? "ON" : "OFF"));
	HOPS_nLFilterEnabled = nIsEnabled;

	Prompt;
	return TRUE;
}

/*------------------------------------------------------------------------
  ------ SET/MOTD --------------------------------------------------------
  ------------------------------------------------------------------------*/
#pragma argsused
int CSET_motd(int StreamNum, int nParams, char **pArg, char **pStrArg)
{
	extern char	STREAMS_level[MAX_STREAMS];
	extern char	STREAMS_lang[MAX_STREAMS];

	/* Niveau d'utilisateur remote command */
	if( ! RCMD_isAllowed(StreamNum, RCMD_NOTALLOWED) )
		return FALSE;

	/*Niveau d'utilisateur*/
	if( ! (STREAMS_level[StreamNum] & LEVEL_sysopV) )
		return FALSE;

	if( nParams == 1 )
		MOTD_change(StreamNum, STREAMS_lang[StreamNum] + 1);
	else
		MOTD_change(StreamNum, atoi (pArg[1]));

	return TRUE;
}

/*------------------------------------------------------------------------
  ------ SET/MONITOR -----------------------------------------------------
  ------------------------------------------------------------------------*/
#pragma argsused
int CSET_monitor(int StreamNum, int nParams, char **pArg, char **pStrArg)
{
	extern char	STREAMS_level[MAX_STREAMS];
	extern int	PARAMS_nIsMonitorOn;
	int		nIsEnabled;

	/* Niveau d'utilisateur remote command */
	if( ! RCMD_isAllowed(StreamNum, RCMD_NOTALLOWED) )
		return FALSE;

	/*Niveau d'utilisateur*/
	if( ! (STREAMS_level[StreamNum] & LEVEL_sysopV) )
		return FALSE;

	if( nParams == 1 )
	{
		BUFFERS_printBuff(StreamNum, OUT, "SET/MONITOR : %s\n",
			(PARAMS_nIsMonitorOn ? "ON" : "OFF"));
		Prompt;
		return TRUE;
	}

	strupr (pArg[1]);

	if( ! strcmp(pArg[1], "ON") )
		nIsEnabled = TRUE;		/*Sur ON*/
	else if( ! strcmp(pArg[1], "OFF") )
		nIsEnabled = FALSE;            	/*Sur OFF*/
	else
	{
		MSG_send(StreamNum, MSG18);     /*Erreur*/
		BUFFERS_addBuff(StreamNum, "Example : SET/MONITOR ON  or  SET/MONITOR OFF\n", OUT);
		Prompt;
		return TRUE;
	}

	/* Afficher le resultat et memoriser */
	BUFFERS_printBuff(StreamNum, OUT, "SET/MONITOR : %s\n        was : %s\n",
		(nIsEnabled ? "ON" : "OFF"), (PARAMS_nIsMonitorOn ? "ON" : "OFF"));

	PARAMS_nIsMonitorOn = nIsEnabled;

	Prompt;
	return TRUE;
}


#ifdef DOS
/*------------------------------------------------------------------------
  ------ SET/MYCALL ------------------------------------------------------
  ------------------------------------------------------------------------*/
#pragma argsused
int CSET_mycall(int StreamNum, int nParams, char **pArg, char **pStrArg)
{
	extern char	TERM_myCall[11];  /*L'indicatif du terminal*/
	extern char	STREAMS_level[MAX_STREAMS];

	/* Niveau d'utilisateur remote command */
	if( ! RCMD_isAllowed(StreamNum, RCMD_NOTALLOWED) )
		return FALSE;

	/*Niveau d'utilisateur*/
	if( ! (STREAMS_level[StreamNum] & LEVEL_sysopV) )
		return FALSE;

	if( nParams == 1 )
	{
		/*Si aucun parametre de precise, se contenter d'afficher le call*/
		BUFFERS_printBuff(StreamNum, OUT, "MyCall : %s\n", TERM_myCall);
		Prompt;
		return TRUE;
	}

	if( nParams > 2 )
	{
		/*Nombre d'arguments incorrect*/
		MSG_send(StreamNum, MSG58);
		Prompt;
		return TRUE;
	}

	TOOLS_maxLength(pArg[1], 9);
	strupr (pArg[1]);

	if( ! TOOLS_isCall(pArg[1]) )
	{
		/*Argument incorrect*/
		MSG_send(StreamNum, MSG18);
		Prompt;
		return TRUE;
	}

	/*Afficher et memoriser le nouveau call*/
	BUFFERS_printBuff(StreamNum, OUT, "MyCall : %s\n   Was : %s\n", pArg[1], TERM_myCall);
	strcpy(TERM_myCall, pArg[1]);

	Prompt;
	return TRUE;
}
#endif

/*------------------------------------------------------------------------
  ------ SET/NAME --------------------------------------------------------
  ------------------------------------------------------------------------*/
#pragma argsused
int CSET_name(int StreamNum, int nParams, char **pArg, char **pStrArg)
{
	extern tUser   *pUser;
	char sNodeCall[16];

	/* Niveau d'utilisateur remote command */
	if( ! RCMD_isAllowed(StreamNum, RCMD_NOTALLOWED) )
		return FALSE;

	/*L'utilisateur  t-il indiqu le prenom ?*/
	if( nParams == 1 )
	{
		MSG_send(StreamNum, MSG58);
		Prompt;
		return TRUE;
	}

	/*Longueur limitee a 22*/
	TOOLS_maxLength(pStrArg[1], 22);

	/*Accder au bloc user et updater*/
	USERS_getRecord(StreamNum);
	strcpy(pUser->sName, pStrArg[1]);
	USERS_updateRecord(StreamNum);

	/*Transmettre l'info sur le reseau cluster*/
	NODE_getNodeCall(0, 0, sNodeCall);
	PROTOCOL_sendUserConfig(0, sNodeCall, pUser->sCallSign,
			  pStrArg[1], USERS_NAME, 100);

	/*Afficher le message*/
	MSG_send(StreamNum, MSG13);

	Prompt;
	return TRUE;
}

/*------------------------------------------------------------------------
  ------ SET/NODE --------------------------------------------------------
  ------------------------------------------------------------------------*/
#pragma argsused
int CSET_node(int StreamNum, int nParams, char **pArg, char **pStrArg)
{
	extern char  *PARAMS_adjacentNodes;
	extern char	STREAMS_level[MAX_STREAMS];

	/* Niveau d'utilisateur remote command */
	if( ! RCMD_isAllowed(StreamNum, RCMD_SYSOP) )
		return FALSE;

	/*Niveau d'utilisateur*/
	if( ! (STREAMS_level[StreamNum] & LEVEL_sysopV) )
		return FALSE;

	if( nParams != 1 )	  /*Seulement si des arguments ont ete donnes*/
		SET_params(PARAMS_adjacentNodes, pStrArg[1]);

	BUFFERS_printBuff(StreamNum, OUT, "SET/NODE :%s\n", PARAMS_adjacentNodes);

	Prompt;
	return TRUE;
}

/*------------------------------------------------------------------------
  ------ SET/NOANNOUNCEMENTS ---------------------------------------------
  ------------------------------------------------------------------------*/
#pragma argsused
int CSET_noAnnouncements(int StreamNum, int nParams, char **pArg, char **pStrArg)
{
	unsigned int nFlags;
	extern char *MSG_pParams[10];
	char szBuffer[256];

	/* Niveau d'utilisateur remote command */
	if( ! RCMD_isAllowed(StreamNum, RCMD_NOTALLOWED) )
		return FALSE;

	if( nParams != 1 )
	{
		MSG_send(StreamNum, MSG58);	/*Nbr d'arg incorrect*/
		Prompt;
		return TRUE;
	}

	/*Modifier le flag */
	nFlags  = USERS_getFlags (StreamNum);
	nFlags |= USERS_NOANNOUNCEMENTS;
	USERS_setFlags(StreamNum, nFlags);

	/* Affichage de confirmation de la commande */
	MSG_get(StreamNum, MSG64, szBuffer); /* devalide */
	if( szBuffer[0] ) /* Si buffer non vide */
		szBuffer[strlen(szBuffer) - 1] = SNULL;
	MSG_pParams[9] = szBuffer;
	MSG_send(StreamNum, MSG77);

	Prompt;
	return TRUE;
}

/*------------------------------------------------------------------------
  ------ SET/NOBEEP ------------------------------------------------------
  ------------------------------------------------------------------------*/
#pragma argsused
int CSET_nobeep(int StreamNum, int nParams, char **pArg, char **pStrArg)
{
	unsigned int iFlags;
	char         szBuffer[256];
	extern char *MSG_pParams[10];

	/* Niveau d'utilisateur remote command */
	if( ! RCMD_isAllowed(StreamNum, RCMD_NOTALLOWED) )
		return FALSE;

	if( nParams != 1 )
	{
		MSG_send(StreamNum, MSG58);		/*Nbr d'arg incorrect*/
		Prompt;
		return TRUE;
	}

	/*Modifier le flag (NOBEEP a mettre a 1)*/
	iFlags  = USERS_getFlags (StreamNum);
	iFlags |= USERS_NOBEEP;
	USERS_setFlags(StreamNum, iFlags);

	/* Affichage de confirmation de la commande */
	MSG_get(StreamNum, MSG64, szBuffer); /* valide */
	if( szBuffer[0] ) /* Si buffer non vide : enlever CR */
		szBuffer[strlen(szBuffer) - 1] = SNULL;
	MSG_pParams[9] = szBuffer;
	MSG_send(StreamNum, MSG65);

	Prompt;
	return TRUE;
}

/*------------------------------------------------------------------------
  ------ SET/NODX_ANNOUNCEMENT ---------------------------------------------
  ------------------------------------------------------------------------*/
#pragma argsused
int CSET_noDxAnnouncements(int StreamNum, int nParams, char **pArg, char **pStrArg)
{
	unsigned int nFlags;
	extern char *MSG_pParams[10];
	char szBuffer[256];

	/* Niveau d'utilisateur remote command */
	if( ! RCMD_isAllowed(StreamNum, RCMD_NOTALLOWED) )
		return FALSE;

	if( nParams != 1 )
	{
		MSG_send(StreamNum, MSG58);	/*Nbr d'arg incorrect*/
		Prompt;
		return TRUE;
	}

	/*Modifier le flag */
	nFlags  = USERS_getFlags (StreamNum);
	nFlags |= USERS_NODX;
	USERS_setFlags(StreamNum, nFlags);

	/* Affichage de confirmation de la commande */
	MSG_get(StreamNum, MSG64, szBuffer); /* devalide */
	if( szBuffer[0] ) /* Si buffer non vide */
		szBuffer[strlen(szBuffer) - 1] = SNULL;
	MSG_pParams[9] = szBuffer;
	MSG_send(StreamNum, MSG76);

	Prompt;
	return TRUE;
}

/*------------------------------------------------------------------------
  ------ SET/NOFILTER ----------------------------------------------------
  ------------------------------------------------------------------------*/
#pragma argsused
int CSET_nofilter(int StreamNum, int nParams, char **pArg, char **pStrArg)
{
	extern tUser *pUser;
	extern char  *MSG_pParams[10];
	char   szBuffer[256];

	/* Niveau d'utilisateur remote command */
	if( ! RCMD_isAllowed(StreamNum, RCMD_NOTALLOWED) )
		return FALSE;

	if( nParams != 1 )
	{
		MSG_send(StreamNum, MSG58);		/*Nbr d'arg incorrect*/
		Prompt;
		return TRUE;
	}

	/* Recuperer les parametres de filtrage et updater */
	USERS_getRecord(StreamNum);
	pUser->lBandsOff = 0L;
	USERS_updateRecord(StreamNum);

	/* Affichage de confirmation de la commande */
	MSG_get(StreamNum, MSG64, szBuffer); /* devalide */
	if( szBuffer[0] ) /* Si buffer non vide : enlever CR */
		szBuffer[strlen(szBuffer) - 1] = SNULL;
	MSG_pParams[9] = szBuffer;
	MSG_send(StreamNum, MSG75);

	Prompt;
	return TRUE;
}



/*------------------------------------------------------------------------
  ------ SET/NOHERE ------------------------------------------------------
  ------------------------------------------------------------------------*/
#pragma argsused
int CSET_nohere(int StreamNum, int nParams, char **pArg, char **pStrArg)
{
	extern char	STREAMS_callsign[MAX_STREAMS][10];
	char		sNodeCall[16];
	char		sUserCall[16];

	/* Niveau d'utilisateur remote command */
	if( ! RCMD_isAllowed(StreamNum, RCMD_NOTALLOWED) )
		return FALSE;

	if( nParams != 1 )
	{
		MSG_send(StreamNum, MSG58);		/*Nbr d'arg incorrect*/
		Prompt;
		return TRUE;
	}

	/*Rcuprer en mmoire les indicatifs du serveur et de l'utilisateur*/
	NODE_getNodeCall(0, 0, sNodeCall);
	strcpy(sUserCall, STREAMS_callsign[StreamNum]);

	/*Transmettre l'info aux adjacents*/
	PROTOCOL_sendUserFlag(0, sNodeCall, sUserCall, PROTOCOL_USER_HERE,
		FALSE, 100);

	/*Message  l'utilisateur*/
	MSG_send(StreamNum, MSG28);

	Prompt;
	return TRUE;
}

/*------------------------------------------------------------------------
  ------ SET/NOLOGIN -----------------------------------------------------
  ------------------------------------------------------------------------*/
#pragma argsused
int CSET_nologin(int StreamNum, int nParams, char **pArg, char **pStrArg)
{
	unsigned int iFlags;
	char         szBuffer[256];
	extern char *MSG_pParams[10];

	/* Niveau d'utilisateur remote command */
	if( ! RCMD_isAllowed(StreamNum, RCMD_NOTALLOWED) )
		return FALSE;

	if( nParams != 1 )
	{
		MSG_send(StreamNum, MSG58);		/*Nbr d'arg incorrect*/
		Prompt;
		return TRUE;
	}

	/*Modifier le flag (NOLOGIN a mettre a 1)*/
	iFlags  = USERS_getFlags (StreamNum);
	iFlags |= USERS_NOLOGIN;
	USERS_setFlags(StreamNum, iFlags);

	/* Affichage de confirmation de la commande */
	MSG_get(StreamNum, MSG64, szBuffer); /* devalide */
	if( szBuffer[0] ) /* Si buffer non vide : enlever CR */
		szBuffer[strlen(szBuffer) - 1] = SNULL;
	MSG_pParams[9] = szBuffer;
	MSG_send(StreamNum, MSG66);

	Prompt;
	return TRUE;
}

/*------------------------------------------------------------------------
  ------ SET/NOPAGE ------------------------------------------------------
  ------------------------------------------------------------------------*/
#pragma argsused
int CSET_noPageLength(int StreamNum, int nParams, char **pArg, char **pStrArg)
{
	extern char *   MSG_pParams[10];
	extern tUser*   pUser;
	char		szBuffer[256];

	/* Niveau d'utilisateur remote command */
	if( ! RCMD_isAllowed(StreamNum, RCMD_NOTALLOWED) )
		return FALSE;

	/* L'utilisateur  t-il indiqu un numro ? */
	if( nParams != 1 )
	{
		MSG_send(StreamNum, MSG58);
		Prompt;
		return TRUE;
	}

	/* Mettre a jour */
	USERS_getRecord(StreamNum);
	pUser->byPage = 0;
	USERS_updateRecord(StreamNum);

	MSG_get(StreamNum, MSG64, szBuffer); /* devalide */
	if( szBuffer[0] ) /* Si buffer non vide */
		szBuffer[strlen(szBuffer) - 1] = SNULL;
	MSG_pParams[9] = szBuffer;
	MSG_send(StreamNum, MSG79);

	Prompt;
	return TRUE;
}


/*------------------------------------------------------------------------
  ------ SET/NOREGISTER --------------------------------------------------
  ------------------------------------------------------------------------*/
#pragma argsused
int CSET_noregister(int StreamNum, int nParams, char **pArg, char **pStrArg)
{
	extern char	STREAMS_level[MAX_STREAMS];

	/* Niveau d'utilisateur remote command */
	if( ! RCMD_isAllowed(StreamNum, RCMD_NOTALLOWED) )
		return FALSE;

	/*Niveau d'utilisateur*/
	if( ! (STREAMS_level[StreamNum] & LEVEL_sysopV) )
		return FALSE;

	if( nParams != 2 )
	{
		MSG_send(StreamNum, MSG58);
		Prompt;
		return TRUE;
	}

	if( ! PASSWORD_noRegister(pArg[1]) )
	{
		BUFFERS_printBuff(StreamNum, OUT, "*** No entry found for %s.\n",
			strupr(pArg[1]));
	}
	else
		BUFFERS_addBuff(StreamNum, "Done.\n", OUT);

	Prompt;
	return TRUE;
}

/*------------------------------------------------------------------------
  ------ SET/NOWWFILTER --------------------------------------------------
  ------------------------------------------------------------------------*/
#pragma argsused
int CSET_nowwfilter(int StreamNum, int nParams, char **pArg, char **pStrArg)
{
	unsigned int nFlags;
	char	       szBuffer[256];
	extern char *MSG_pParams[10];

	/* Cette commande n'existe que si SET/PFILTER est active */
	if( ! FILTER_isEnabled() )
		return FALSE;

	/* Niveau d'utilisateur remote command */
	if( ! RCMD_isAllowed(StreamNum, RCMD_NOTALLOWED) )
		return FALSE;

	/* S'il y a des arguments */
	if( nParams != 1 )
	{
		MSG_send(StreamNum, MSG58);		/*Nbr d'arg incorrect*/
		Prompt;
		return TRUE;
	}

	/* Tout autoriser */
	nFlags  = USERS_getFlags (StreamNum);
	nFlags &= ~(USERS_FILTER_NA | USERS_FILTER_SA | USERS_FILTER_EU |
		    USERS_FILTER_AS | USERS_FILTER_OC | USERS_FILTER_AF);

	/* Mettre a jour les flags */
	USERS_setFlags(StreamNum, nFlags);

	/* Mettre a jour la table des filtres */
	FILTER_init(StreamNum);	/* Pas de filtres */

	/* Affichage de confirmation de la commande */
	MSG_get(StreamNum, MSG64, szBuffer); /* devalide */
	if( szBuffer[0] ) /* Si buffer non vide : enlever CR */
		szBuffer[strlen(szBuffer) - 1] = SNULL;
	MSG_pParams[9] = szBuffer;
	MSG_send(StreamNum, MSG69);

	Prompt;
	return TRUE;
}

/*------------------------------------------------------------------------
  ------ SET/PAGE --------------------------------------------------------
  ------------------------------------------------------------------------*/
#pragma argsused
int CSET_pageLength(int StreamNum, int nParams, char **pArg, char **pStrArg)
{
	extern char *   MSG_pParams[10];
	extern tUser*   pUser;
	int		nPage;
	char		szBuffer[256];

	/* Niveau d'utilisateur remote command */
	if( ! RCMD_isAllowed(StreamNum, RCMD_NOTALLOWED) )
		return FALSE;

	/* L'utilisateur  t-il indiqu un numro ? */
	if( nParams == 1 )
	{
		/* Pas d'argument : se contenter d'afficher */
		USERS_getRecord(StreamNum);
		nPage = (int) pUser->byPage;
	}
	else
	{
		if( nParams != 2 )
		{
			MSG_send(StreamNum, MSG58);
			Prompt;
			return TRUE;
		}

		nPage = atoi(pArg[1]);

		if( nPage < 0 || nPage > 255 || ! isdigit(pArg[1][0]) )
		{
			MSG_pParams[9] = "SET/PAGE n (0 <= n <= 255)";
			MSG_pParams[8] = pArg[1];
			MSG_send(StreamNum, MSG74);
			Prompt;
			return TRUE;
		}
	}

	/* Mettre a jour */
	USERS_getRecord(StreamNum);
	pUser->byPage = (BYTE) nPage;
	USERS_updateRecord(StreamNum);

	if( nPage == 0 )
		MSG_get(StreamNum, MSG64, szBuffer); /* devalide */
	else
		sprintf(szBuffer, "%d ", nPage);
	if( szBuffer[0] ) /* Si buffer non vide */
		szBuffer[strlen(szBuffer) - 1] = SNULL;
	MSG_pParams[9] = szBuffer;
	MSG_send(StreamNum, MSG79);

	Prompt;
	return TRUE;
}

/*------------------------------------------------------------------------
  ------ SET/PFILTER -----------------------------------------------------
  ------------------------------------------------------------------------*/
#pragma argsused
int CSET_pfilter(int StreamNum, int nParams, char **pArg, char **pStrArg)
{
	extern char	STREAMS_level[MAX_STREAMS];
	extern int	FILTER_nIsEnabled;
	int	        nIsEnabled;

	/* Niveau d'utilisateur remote command */
	if( ! RCMD_isAllowed(StreamNum, RCMD_NOTALLOWED) )
		return FALSE;

	/*Niveau d'utilisateur*/
	if( ! (STREAMS_level[StreamNum] & LEVEL_sysopV) )
		return FALSE;

	if( nParams == 1 )
	{
		BUFFERS_printBuff(StreamNum, OUT, "SET/PFILTER : %s\n", (FILTER_nIsEnabled ? "ON" : "OFF"));
		Prompt;
		return TRUE;
	}

	strupr (pArg[1]);

	if( ! strcmp(pArg[1], "ON") )
		nIsEnabled = TRUE;   	      	/*Sur ON*/
	else if( ! strcmp(pArg[1], "OFF") )
		nIsEnabled = FALSE;             /*Sur OFF*/
	else
	{
		MSG_send(StreamNum, MSG18);     /*Erreur*/
		BUFFERS_addBuff(StreamNum, "Example : SET/PFILTER ON  or  SET/PFILTER OFF\n", OUT);
		Prompt;
		return TRUE;
	}

	/*Afficher le resultat et memoriser*/
	BUFFERS_printBuff(StreamNum, OUT, "SET/PFILTER : %s\n        was : %s\n",
		    (nIsEnabled ? "ON" : "OFF"),
		    (FILTER_nIsEnabled ? "ON" : "OFF"));
	FILTER_nIsEnabled = nIsEnabled;

	Prompt;
	return TRUE;
}

/*------------------------------------------------------------------------
  ------ SET/REGISTER ----------------------------------------------------
  ------------------------------------------------------------------------*/
#pragma argsused
int CSET_register(int StreamNum, int nParams, char **pArg, char **pStrArg)
{
	extern char	STREAMS_level[MAX_STREAMS];

	/* Niveau d'utilisateur remote command */
	if( ! RCMD_isAllowed(StreamNum, RCMD_NOTALLOWED) )
		return FALSE;

	/*Niveau d'utilisateur*/
	if( ! (STREAMS_level[StreamNum] & LEVEL_sysopV) )
		return FALSE;

	if( nParams != 3 )
	{
		MSG_send(StreamNum, MSG58);
		Prompt;
		return TRUE;
	}

	if( ! PASSWORD_register(pArg[1], pStrArg[2]) )
		BUFFERS_addBuff(StreamNum, "*** Unnable to create a new entry.\n", OUT);
	else
		BUFFERS_addBuff(StreamNum, "Done.\n", OUT);
	Prompt;
	return TRUE;
}

/*------------------------------------------------------------------------
  ------ SET/QTH ---------------------------------------------------------
  ------------------------------------------------------------------------*/
#pragma argsused
int CSET_qth(int StreamNum, int nParams, char **pArg, char **pStrArg)
{
	extern tUser   *pUser;
	char sNodeCall[16];

	/* Niveau d'utilisateur remote command */
	if( ! RCMD_isAllowed(StreamNum, RCMD_NOTALLOWED) )
		return FALSE;

	/*L'utilisateur  t-il indiqu le qth ?*/
	if( nParams == 1 )
	{
		MSG_send(StreamNum, MSG58);
		Prompt;
		return TRUE;
	}

	/*Longueur limitee a 22*/
	TOOLS_maxLength(pStrArg[1], 80);

	/*Accder au bloc user et updater*/
	USERS_getRecord(StreamNum);
	strcpy(pUser->sQth, pStrArg[1]);
	USERS_updateRecord(StreamNum);

	/*Transmettre l'info sur le reseau cluster*/
	NODE_getNodeCall(0, 0, sNodeCall);
	PROTOCOL_sendUserConfig(0, sNodeCall, pUser->sCallSign,
		pStrArg[1], USERS_QTH, 100);

	/*Afficher le message*/
	MSG_send(StreamNum, MSG14);

	Prompt;
	return TRUE;
}

/*------------------------------------------------------------------------
  ------ SET/TZ ----------------------------------------------------------
  ------------------------------------------------------------------------*/
#pragma argsused
int CSET_tz(int StreamNum, int nParams, char **pArg, char **pStrArg)
{
	extern char	STREAMS_level[MAX_STREAMS];
	extern long 	PARAMS_lTz;

	/* Niveau d'utilisateur remote command */
	if( ! RCMD_isAllowed(StreamNum, RCMD_NOTALLOWED) )
		return FALSE;

	/*Niveau d'utilisateur*/
	if( ! (STREAMS_level[StreamNum] & LEVEL_sysopV) )
		return FALSE;

	if( nParams > 2 ) 	/*Pas plus d'1 arg*/
	{
		MSG_send(StreamNum, MSG58);
		Prompt;
		return TRUE;
	}

	if( nParams == 2 )	/*Si un arg a ete precise*/
		PARAMS_lTz = atol (pArg[1]) * 3600L;

	BUFFERS_printBuff(StreamNum, OUT, "SET/TZ : %ld\n", PARAMS_lTz / 3600L);

	Prompt;
	return TRUE;
}

/*------------------------------------------------------------------------
  ------ SET/SSID --------------------------------------------------------
  ------------------------------------------------------------------------*/
#pragma argsused
int CSET_ssid(int StreamNum, int nParams, char **pArg, char **pStrArg)
{
	extern char	STREAMS_level[MAX_STREAMS];
	extern char  *PARAMS_ssid;

	/* Niveau d'utilisateur remote command */
	if( ! RCMD_isAllowed(StreamNum, RCMD_NOTALLOWED) )
		return FALSE;

	/*Niveau d'utilisateur*/
	if( ! (STREAMS_level[StreamNum] & LEVEL_sysopV) )
		return FALSE;

	if( nParams != 1 )		/*Seulement si des arguments ont ete donnes*/
		SET_params(PARAMS_ssid, pStrArg[1]);

	BUFFERS_printBuff(StreamNum, OUT, "SET/SSID :%s\n", PARAMS_ssid);

	Prompt;
	return TRUE;
}

/*------------------------------------------------------------------------
  ------ SET/SYSOP -------------------------------------------------------
  ------------------------------------------------------------------------*/
#pragma argsused
int CSET_sysop(int StreamNum, int nParams, char **pArg, char **pStrArg)
{
	extern char	STREAMS_level[MAX_STREAMS];
	extern char    *PARAMS_sysop;

	/* Niveau d'utilisateur remote command */
	if( ! RCMD_isAllowed(StreamNum, RCMD_NOTALLOWED) )
		return FALSE;

	/*Niveau d'utilisateur*/
	if( ! (STREAMS_level[StreamNum] & LEVEL_sysopV) )
		return FALSE;

	if( nParams != 1 )		/*Seulement si des arguments ont ete donnes*/
		SET_params(PARAMS_sysop, pStrArg[1]);

	BUFFERS_printBuff(StreamNum, OUT, "SET/SYSOP :%s\n", PARAMS_sysop);

	Prompt;
	return TRUE;
}

#ifndef DOS
/*------------------------------------------------------------------------
  ------ SET/TELNET ------------------------------------------------------
  ------------------------------------------------------------------------*/
#pragma argsused
int CSET_telnetAccess(int StreamNum, int nParams, char **pArg, char **pStrArg)
{
	extern char	STREAMS_level[MAX_STREAMS];

	/* Niveau d'utilisateur remote command */
	if( ! RCMD_isAllowed(StreamNum, RCMD_NOTALLOWED) )
		return FALSE;

	/*Niveau d'utilisateur*/
	if( ! (STREAMS_level[StreamNum] & LEVEL_sysopV) )
		return FALSE;

	if( nParams > 2 )
	{
		MSG_send(StreamNum, MSG58);		/*Nbr d'arg incorrect*/
		Prompt;
		return TRUE;
	}

	strupr(pArg[1]);

	if( nParams == 2 )
	{
		int nOld = TELNET_isOpen();
		int Length = strlen(pArg[1]);

		if( COMMANDS_check(pArg[1], "OPEN", Length, 1) )
			TELNET_openAccess(TRUE);
		else if( COMMANDS_check(pArg[1], "CLOSE", Length, 1) )
			TELNET_openAccess(FALSE);
		else
		{
			MSG_send(StreamNum, MSG18);
			Prompt;
			return TRUE;
		}

		BUFFERS_printBuff(StreamNum, OUT, "TELNET access was : %s\n              now : %s\n",
			nOld ? "OPEN" : "CLOSE", TELNET_isOpen() ? "OPEN" : "CLOSE");
	}
	else
	{
		BUFFERS_printBuff(StreamNum, OUT, "TELNET access is : %s\n",
			TELNET_isOpen() ? "OPEN" : "CLOSE");
	}

	Prompt;
	return TRUE;
}
#endif


/*------------------------------------------------------------------------
  ------ SET/TIME ----------------------------------------------------------
  ------------------------------------------------------------------------*/
#pragma argsused
int CSET_time(int StreamNum, int nParams, char **pArg, char **pStrArg)
{
	extern char   STREAMS_level[MAX_STREAMS];
	extern long   PARAMS_lTz;

	char	szBuffer[256];
	char *pszTime = pArg[1];
	char  szHour[16];
	char	szMin[16];
	char	szSec[16];
	int	nHour;
	int	nMin;
	int	nSec;
	time_t t;
	struct tm tTime;
	int	nTimeLength = strlen(pszTime);

	/* Niveau d'utilisateur remote command */
	if( ! RCMD_isAllowed(StreamNum, RCMD_SYSOP) )
		return FALSE;

	/*Niveau d'utilisateur*/
	if( ! (STREAMS_level[StreamNum] & LEVEL_sysopV) )
		return FALSE;

	if( nParams != 2 )
	{
		MSG_send(StreamNum, MSG58);		/*Nbr d'arg incorrect*/
		Prompt;
		return TRUE;
	}

	/* Verifier la validite de l'heure */
	if( nTimeLength != 4 && nTimeLength != 6 )
	{
		MSG_send(StreamNum, MSG18);	/* invalide */
		BUFFERS_addBuff(StreamNum, "Format : HHMMSS (e.g. SET/TIME 231400)\n", OUT);
		Prompt;
		return TRUE;
	}

	/* Extraire l'heure */
	if( nTimeLength == 6 )
	{
		strcpy(szSec, pszTime + 4);
		nSec = atoi(szSec);
	}
	else
		nSec = 0;

	strcpy(szMin, pszTime + 2);
	szMin[2] = SNULL;
	nMin = atoi(szMin);

	strcpy(szHour, pszTime);
	szHour[2] = SNULL;
	nHour = atoi(szHour);

	/* Verifier la validite des donnees saisies */
	if( nHour < 0 || nHour > 23 || nMin < 0 || nMin > 59 || nSec < 0 || nSec > 59 )
	{
		BUFFERS_addBuff(StreamNum, "Bad arguments in time\n", OUT);
		Prompt;
		return TRUE;
	}

	/* Mettre a jour */
	t     = time(NULL) - PARAMS_lTz;
	tTime = *localtime(&t);
	strftime(szBuffer, 255, "%X", &tTime);
	BUFFERS_printBuff(StreamNum, OUT, "Time was : %s\n", szBuffer);
	tTime.tm_hour = nHour;
	tTime.tm_min  = nMin;
	if( nTimeLength == 6 )
		tTime.tm_sec = nSec;
	t = mktime(&tTime) + PARAMS_lTz;
	stime(&t);
	strftime(szBuffer, 255, "%X", &tTime);
	BUFFERS_printBuff(StreamNum, OUT, "     now : %s\n", szBuffer);

	Prompt;
	return TRUE;
}


/*------------------------------------------------------------------------
  ------ SET/USERCMD -----------------------------------------------------
  ------------------------------------------------------------------------*/
#pragma argsused
int CSET_usercmd(int StreamNum, int nParams, char **pArg, char **pStrArg)
{
	extern char	STREAMS_level[MAX_STREAMS];

	/* Niveau d'utilisateur remote command */
	if( ! RCMD_isAllowed(StreamNum, RCMD_NOTALLOWED) )
		return FALSE;

	/*Rx only ?*/
	if( STREAMS_level[StreamNum] & LEVEL_user_RXonly )
		return FALSE;

	USERCMD_upload(StreamNum);
	return TRUE;
}


#ifndef DOS
/*------------------------------------------------------------------------
  ------ SET/PORT (commande linux) ---------------------------------------
  ------------------------------------------------------------------------*/
#pragma argsused
int CSET_port(int StreamNum, int nParams, char **pArg, char **pStrArg)
{
	extern char	STREAMS_level[MAX_STREAMS];
	int	        index;

	/* Niveau d'utilisateur remote command */
	if( ! RCMD_isAllowed(StreamNum, RCMD_NOTALLOWED) )
		return FALSE;

	/*Niveau d'utilisateur*/
	if( ! (STREAMS_level[StreamNum] & LEVEL_sysopV) )
		return FALSE;

	BUFFERS_addBuff(StreamNum, "SET/PORT :", OUT);

	for(index = 1; index < MAX_ARG; index++)
	{
		if (pArg[index][0])
		{
			BUFFERS_printBuff(StreamNum, OUT, " %s", pArg[index]);
			SWITCH_addPort (pArg[index]);
		}/*End IF*/
	}

	BUFFERS_addBuff(StreamNum, "\n", OUT);
	Prompt;
	return TRUE;
}
#endif

/*------------------------------------------------------------------------
  ------ SET/WWFILTER ----------------------------------------------------
  ------------------------------------------------------------------------*/
#pragma argsused
int CSET_wwfilter(int StreamNum, int nParams, char **pArg, char **pStrArg)
{
	unsigned int nFlags;
	char	       szBuffer[256];
	extern char *MSG_pParams[10];

	/* Cette commande n'existe que si SET/PFILTER est active */
	if( ! FILTER_isEnabled() )
		return FALSE;

	/* Niveau d'utilisateur remote command */
	if( ! RCMD_isAllowed(StreamNum, RCMD_NOTALLOWED) )
		return FALSE;

	/* Lecture des flags */
	nFlags  = USERS_getFlags(StreamNum);

	/* S'il y a des arguments */
	if( nParams > 1 )
	{
		char * token;
		char   buf[256];

		/* Initialiser les flags (tout autoriser) */
		nFlags &= ~(USERS_FILTER_NA | USERS_FILTER_SA | USERS_FILTER_EU |
			    USERS_FILTER_AS | USERS_FILTER_OC | USERS_FILTER_AF);

		/* Lecture des argulents */
		strcpy(buf, pStrArg[1]);
		strupr(buf);

		token = strtok(buf, " ");

		while( token )
		{
			if( ! strcmp(token, "NA") )
				nFlags |= USERS_FILTER_NA;
			else if( ! strcmp(token, "SA") )
				nFlags |= USERS_FILTER_SA;
			else if( ! strcmp(token, "EU") )
				nFlags |= USERS_FILTER_EU;
			else if( ! strcmp(token, "AS") )
				nFlags |= USERS_FILTER_AS;
			else if( ! strcmp(token, "OC") )
				nFlags |= USERS_FILTER_OC;
			else if( ! strcmp(token, "AF") )
				nFlags |= USERS_FILTER_AF;
			else
			{
				/* Argument incorrect */
				strcpy(pArg[1], token);
				MSG_send(StreamNum, MSG18);
				Prompt;
				return TRUE;
			}
			token = strtok(NULL, " ");
		}

		/* Mettre a jour les flags */
		USERS_setFlags(StreamNum, nFlags);
	}
	else
	{
		/* Pas d'arguments : verifier que des filtres sont deja
		   definis (sans etre forcement actives) */
		if( ! (nFlags & (USERS_FILTER_NA | USERS_FILTER_SA |
			 USERS_FILTER_EU | USERS_FILTER_AS |
			 USERS_FILTER_AS | USERS_FILTER_AF)) )
		{
			MSG_send(StreamNum, MSG17);
			Prompt;
			return TRUE;
		}
	}

	/* Affichage de confirmation de la commande */
	FILTER_flags2str(nFlags, szBuffer);
	MSG_pParams[9] = szBuffer;
	MSG_send(StreamNum, MSG69);
	Prompt;

	/* Mettre a jour la table de filtrage */
	FILTER_set(StreamNum, FILTER_USER, szBuffer);

	return TRUE;
}

