#include <alloc.h>
#include <stdio.h>
#include "define.h"
#include "node.h"
#include "hops.h"
#include "coninit.h"
#include "streams.h"
#include "protocol.h"
#include "buffers.h"
#include "clulink.h"
#include "tools.h"

extern char STREAMS_level[MAX_STREAMS];
extern char PROTOCOL_linkType[65];

/* Ce fichier contient une liste d'outils utilises pour etablir les
   protocoles PC16 et PC19 envoyes lors d'une init de connexion */

/* ----------------------------------------------------------------------
   ------ Effacer les fichiers temporaires ------------------------------
   ----------------------------------------------------------------------*/
void CONINIT_delTempFile(void)
{
	char	 szFileName[256];

	for(int index = 1; index <= 99; index++)
	{
		/* Fichiers PC19 */
		sprintf(szFileName, "%spc19_%02d.tmp", TEMP_PATH, index);
		unlink(szFileName);

		/* Fichier PC16 */
		sprintf(szFileName, "%spc16.tmp", TEMP_PATH);
		unlink(szFileName);
	}
}

/* ----------------------------------------------------------------------
   ------ Creer les fichiers temporaires, hops par hops, pour les -------
   ------ les clusters connectes ----------------------------------------
   ----------------------------------------------------------------------*/
void CONINIT_createHopsTmpFile(int nStreamNum)
{
	int	nNodeStream;
	int	nNodePos;
	int	nPc16;
	int	nPc19;
	int	nPc50;
	/* char	szFileName[256]; */
	char	szNodeCall[16];

	/* Faire le menage (par securite, car ceci aurait deja du
	   etre fait) */
	CONINIT_delTempFile();

	/* Si c'est un external link, il suffit de creer un seul fichier
	   pc19 contenant l'indicatif du MON cluster */
	nPc19 = HOPS_fix(nStreamNum, NULL, nStreamNum, PCEXTERNAL, HOPS_OUT, 100);
	if( nPc19 )
	{
		NODE_getNodeCall(0, 0, szNodeCall);
		CONINIT_printFile(szNodeCall, 0, 0, /*nPc16*/0, nPc19);
		return;
	}

	/* Parcourir tous les streams */
	for(nNodeStream = 0; nNodeStream <= 64; nNodeStream++)
	{
		/* Est-ce un cluster ou MYCALL ? */
		if( nNodeStream != 0 && ! (STREAMS_level[nNodeStream] & LEVEL_cluster) )
			continue; /* Non ! */

		/* Pas de ping-pong ... */
		if( nNodeStream == nStreamNum )
			continue;

//		/* Faut il rejeter pour ce cluster ? */
//		if( ! HOPS_wizardFix(nStreamNum, NULL, nNodeStream, PC19, HOPS_OUT) )
//			continue;

		/* Parcourir toutes les positions de ce stream */
		for( nNodePos = 0; nNodePos < NODE_MAXANODE; nNodePos++)
		{
			/* Indicatif du cluster */
			NODE_getNodeCall(nNodeStream, nNodePos, szNodeCall);

			if( szNodeCall[0] == SNULL )
				continue;	/* Pas d'indicatif */

			/* Hop count pour ce cluster ? */
			if( HOPS_getHops(szNodeCall, 0, nPc16, nPc19, nPc50) )
			{
				/* Le cluster a ete trouve ds la liste */

				/* Cas particulier pour MYCALL */
				if( nNodeStream == 0 && nNodePos == 0 )
					nPc16 = nPc19 = 100;

				CONINIT_printFile(szNodeCall, nNodeStream,
					nNodePos,
					HOPS_fix(nStreamNum, NULL, nNodeStream, PC16, HOPS_OUT, nPc16),
					HOPS_fix(nStreamNum, NULL, nNodeStream, PC19, HOPS_OUT, nPc19));
			}
			else
			{
				/* Le cluster n'a pas ete trouve dans la liste,
				   alors dans le doute, en envoie le maximum */
				CONINIT_printFile(szNodeCall, nNodeStream,
					nNodePos,
					HOPS_fix(nStreamNum, NULL, nNodeStream, PC16, HOPS_OUT, 100),
					HOPS_fix(nStreamNum, NULL, nNodeStream, PC19, HOPS_OUT, 100));
			}
		}
	}
}

/* ----------------------------------------------------------------------
   ------ Ecrire la liste des clusters avec leur hops dans le fichier ---
   ------ temporaire tmp\coniniXX.tmp ainsi que le PC16 dans le fichier -
   ------ tmp\pc16.tmp --------------------------------------------------
   ----------------------------------------------------------------------*/
void CONINIT_printFile(char * pszNodeCall, int nNodeStream, int nNodePos, int nPc16, int nPc19)
{
	FILE   *fPtr;
	char	szFileName[256];

	/* Ouvrir le fichier PC19 */
	sprintf(szFileName, "%spc19_%02d.tmp", TEMP_PATH, nPc19);
	fPtr = fopen(szFileName, "a+t");

	/* Le fichier n'a pas pu tre ouvert ... */
	if( ! fPtr )
	{
		perror("fopen in CONINIT_printFile (1) - maybe 'dxnet/tmp' directory does not exist");
		return;
	}

	/* Ecrire ... */
	fprintf(fPtr, "%s %d %d\n", pszNodeCall, nNodeStream, nNodePos);

	fclose(fPtr);

	/* Enregistrer maintenant le hops du PC16, si celui-ci n'est
	   pas nul */
	if( nPc16 == 0 )
		return;	/* Termine */

	/* OUvrir le fichier PC16 */
	sprintf(szFileName, "%spc16.tmp", TEMP_PATH);
	fPtr = fopen(szFileName, "a+t");

	/* Le fichier n'a pas pu tre ouvert ... */
	if( ! fPtr )
	{
		perror("fopen in CONINIT_printFile (2) - maybe 'dxnet/tmp' directory does not exist");
		return;
	}

	/* Ecrire ... */
	fprintf(fPtr, "%s %d %d %d\n", pszNodeCall, nNodeStream, nNodePos, nPc16);

	fclose(fPtr);
}

/* ------------------------------------------------------------------------
   ------ Envoyer toutes les trames d'initialisation PC19 et PC16 ---------
   ------------------------------------------------------------------------ */
void CONINIT_sendInitProtocols(int nStreamNum)
{
	/* Preparer les fichiers temporaires */
	CONINIT_createHopsTmpFile(nStreamNum);

	/* Transmettre les PC19 */
	CONINIT_sendPC19(nStreamNum);

	/* Transmettre les PC16 */
	CONINIT_sendPC16(nStreamNum);
}

/* ------------------------------------------------------------------------
   ------ Envoyer les PC19 ------------------------------------------------
   ------------------------------------------------------------------------ */
void CONINIT_sendPC19(int nStreamNum)
{
	int	nHops;
	int	nNodeStream;
	int	nNodePos;
	char	szNodeCall[256];
	char	szFileName[256];
	FILE   *fPtr;
	char	szVersionString[64];
	unsigned short shVersion;
	int	nCount;
	char    szCluLink[1024];
	int	nCluLinkPos = 0;
	char	cFlag;

	/* Ouvrir les fichiers temporaires, hops par hops, et traiter le
	   contenu afin d'envoyer les protocoles avec un hop count
	   correct */

	for(nHops = 99; nHops > 0; nHops--)
	{
		sprintf(szFileName, "%spc19_%02d.tmp", TEMP_PATH, nHops);
		fPtr = fopen(szFileName, "rt");

		if( ! fPtr )
			continue;	/* Pas de fichier a ouvrir */

		nCount = 0;

		/* Lire les lignes, une a unes */
		for(;;)
		{
			if( fscanf(fPtr, "%s %d %d", szNodeCall, &nNodeStream, &nNodePos) != 3 )
			{
				/* Fin de fichier atteinte */
				fclose(fPtr);

				/* Transmettre le protocole */
				if( nCount != 0 )
				{
					if( PROTOCOL_linkType[nStreamNum] == PAVILLON )
					{
						/* Pavillon */
						BUFFERS_printBuff(nStreamNum, OUT, "H%d^\n", nHops);
					}
					else
					{
						/* Longueur du protocole */
						if( nCluLinkPos == 0 )
							return;	/* Anormal : erreur qq part */
						CLULINK_putSize(szCluLink, nCluLinkPos - 2);
						szCluLink[0] |= CL_BROADCAST;	/* Trame BROADCAST */
						BUFFERS_addBuff_sized(nStreamNum, szCluLink, OUT, nCluLinkPos);
					}
					nCount = 0;
				}

				/* Sortir de la boucle infinie */
				break;
			}

			/* Lecture du numro de version et du Flag */
			cFlag = NODE_getNodeFlag(nNodeStream, nNodePos);
			NODE_getNodeVersion(nNodeStream, nNodePos, szVersionString);

			/* Envoyer le protocole */
			if( PROTOCOL_linkType[nStreamNum] == PAVILLON )
			{
				/* C'est du Pavillon */
				if( nCount == 0 )
					BUFFERS_addBuff(nStreamNum, "PC19^", OUT);

				BUFFERS_printBuff(nStreamNum, OUT, "%c^%s^%c^%s^", (cFlag & BIT6 ? '1' : '0'),
						  szNodeCall,
						  (cFlag & BIT7 ? '1' : '0'),
						  szVersionString);

				if( nCount++ == 12 )
				{
					BUFFERS_printBuff(nStreamNum, OUT, "H%d^\n", nHops);
					nCount = 0;
				}
			}
			else
			{
				/* C'est du clulink */
				if( nCount == 0 )
				{
					/* Debut de la trame */
					nCluLinkPos = PROTOCOL_setCluLink(szCluLink, CL(1));
					szCluLink[4] = (BYTE) nHops;
				}

				/* Ajouter l'indicatif */
				nCluLinkPos = PROTOCOL_addPascalString(szCluLink, szNodeCall, nCluLinkPos);
				/* Ajouter le node flag */
				szCluLink[nCluLinkPos++] = cFlag;
				/* Ajouter numero de version */
				shVersion = (unsigned short) atoi(szVersionString);
				nCluLinkPos = CLULINK_addShort(szCluLink, &shVersion, nCluLinkPos);

				/* Transmettre par blocs de 12 */
				if( nCount++ == 12 )
				{
					/* Longueur du protocole */
					CLULINK_putSize(szCluLink, nCluLinkPos - 2);
					szCluLink[0] |= CL_BROADCAST;	/* Trame BROADCAST */
					BUFFERS_addBuff_sized(nStreamNum, szCluLink, OUT, nCluLinkPos);
					nCount = 0;
				}
			} /* Fin "envoyer le protocole" */
		} /* End LOOP */
	} /* End FOR */
}

/* ------------------------------------------------------------------------
   ------ Envoyer les PC16 ------------------------------------------------
   ------------------------------------------------------------------------ */
void CONINIT_sendPC16(int nStreamNum)
{
	FILE   *fPtr;
	char	szFileName[256];

	/* Ouvrir le fichier pc16.tmp et parcourir les lignes unes
	   a unes */
	sprintf(szFileName, "%spc16.tmp", TEMP_PATH);
	fPtr = fopen(szFileName, "rt");
	if( ! fPtr )
		return;

	for(;;)
	{
		char	szNodeCall[256];
		int	nNodeStream;
		int	nNodePos;
		int	nHops;
		int	nUserPos;
		char	szUserCall[16];
		char    szCluLink[1024];
		int	nCluLinkPos = 0;
		int	nCount = 0;
		char	cFlag;

		/* Lire une ligne dans le fichier */
		if( fscanf(fPtr, "%s %d %d %d", szNodeCall, &nNodeStream, &nNodePos, &nHops) != 4 )
			break;	/* Fin du fichier */

		/* Envoyer la liste des utilisateurs pour ce cluster */
		nCount = 0;

		for(nUserPos = 1; nUserPos <= 64; nUserPos++)
		{
			/* Lire l'indicatif de l'utilisateur */
			NODE_getUserCall(nNodeStream, nNodePos, nUserPos, szUserCall);

			if( szUserCall[0] == SNULL )
				continue;	/* Pas d'utilisateur */

			/* User Flag */
			cFlag = NODE_getUserFlag(nNodeStream, nNodePos, nUserPos);

			if( PROTOCOL_linkType[nStreamNum] == PAVILLON )
			{
				/* C'est du PAVILLON */
				if( nCount == 0 )
					BUFFERS_printBuff(nStreamNum, OUT, "PC16^%s^", szNodeCall);

				BUFFERS_printBuff(nStreamNum, OUT, "%s %c %c^", szUserCall, (cFlag & PROTOCOL_USER_CLUSTERCONF ? '*' : '-'), (cFlag & PROTOCOL_USER_HERE ? '1' : '0') );

				if( nCount++ == 16 )
				{
					BUFFERS_printBuff(nStreamNum, OUT, "H%d^\n", nHops);
					nCount = 0;
				}
			}
			else
			{
				/* C'est du CluLink */
				if( nCount == 0 )
				{
					/* Debut du protocol */
					nCluLinkPos = PROTOCOL_setCluLink(szCluLink, CL(3));
					szCluLink[4] = (BYTE) nHops;

					/* Ajouter l'indicatif du node */
					nCluLinkPos = PROTOCOL_addPascalString(szCluLink, szNodeCall, nCluLinkPos);
				}

				/* Ajouter l'indicatif de l'utilisateur */
				nCluLinkPos = PROTOCOL_addPascalString(szCluLink, szUserCall, nCluLinkPos);
				/*Ajouter le user flag */
				szCluLink[nCluLinkPos++] = cFlag;

				if( nCount++ == 16 )
				{
					/* Longueur du protocole */
					CLULINK_putSize(szCluLink, nCluLinkPos - 2);
					szCluLink[0] |= CL_BROADCAST;	/* Trame BROADCAST */
					BUFFERS_addBuff_sized(nStreamNum, szCluLink, OUT, nCluLinkPos);
					nCount = 0;
				}
			} /* End IF */
		} /* End FOR */

		/* Transmettre le protocol */
		if( nCount != 0 )
		{
			if( PROTOCOL_linkType[nStreamNum] == PAVILLON )
			{
				/* PAVILLON */
				BUFFERS_printBuff(nStreamNum, OUT, "H%d^\n", nHops);
			}
			else
			{
				/* CluLink */
				CLULINK_putSize(szCluLink, nCluLinkPos - 2);
				szCluLink[0] |= CL_BROADCAST;	/* Trame BROADCAST */
				BUFFERS_addBuff_sized(nStreamNum, szCluLink, OUT, nCluLinkPos);
			}

			nCount = 0;
		}
	} /* End LOOP */

	fclose (fPtr);
}
