#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include "compress.h"

int COMPRESS_bit[8] = {1, 2, 4, 8, 16, 32, 64, 128};

//---------------------------------------------------------------------------
//------ Compresse un indicatif en transformant les octets en mots de -------
//------ 6 bits -------------------------------------------------------------
//---------------------------------------------------------------------------
//La fonction retourne le nombre d'octets de CompressedCall
int COMPRESS_compressCall(char * CallSign, char * CompressedCall)
{
  char *pPtr;
  int  	BitPos = 0;
  int	Size;

  pPtr = CallSign;

  //------ Convertir les caractres de l'indicatif dans un double ------
  while( *pPtr )
  {
    if( *pPtr >= 'A' && *pPtr <= 'Z' )
      BitPos = COMPRESS_addChar(BitPos, *pPtr - 64, CompressedCall);//1-26

    else if( *pPtr >= '0' && *pPtr <= '9' )
      BitPos = COMPRESS_addChar(BitPos, *pPtr - 21, CompressedCall);//27-37

    else if( *pPtr == '-' )//SSID
      BitPos = COMPRESS_addChar(BitPos, atoi(pPtr+1) + 38, CompressedCall);//38-53

    pPtr++;
  };/*End WHILE*/

  Size = (BitPos / 8);
  if( BitPos % 8 )
    Size++;
  CompressedCall[Size] = NULL;

  return BitPos;
}

int COMPRESS_uncompressCall(char * CompressedCall, char * CallSign, int Size)
{
  int index1;
  int index2;
  int iBitPos = 0;

  char Char;
  char sSsid[4];

  for(index1 = 0; index1 < Size / 6; index1++)
  {
    Char = 0;

    for(index2 = 0; index2 < 6; index2++)
      Char += COMPRESS_getBit(iBitPos++, CompressedCall) * COMPRESS_bit[index2];

    if( Char >= 1 && Char <= 26 )			//C'est une lettre
      CallSign[index1] = Char + 64;

    else if( Char >= 27 && Char <= 37 )	//C'est un chiffre
      CallSign[index1] = Char + 21;

    else if( Char >= 38 )		//C'est le SSID
    {
      sprintf(sSsid, "-%d", (int) Char - 38);
      CallSign[index1] = NULL;
      strcat(CallSign, sSsid);
      return strlen(CallSign);
    }

    else
      break;

  }/*End FOR*/

  CallSign[index1] = NULL;

  return strlen(CallSign);
}

//---------------------------------------------------------------------------
//------ Placer un bit (Bit) dans la chaine String  la position BitPos -----
//---------------------------------------------------------------------------
void COMPRESS_putBit(int BitPos, int Bit, char * String)
{
  int iStrPos;
  int iBitNum;

  iStrPos = BitPos / 8;
  iBitNum = BitPos % 8;

  //Initialiser l'octet, s'il est nouveau
  if( iBitNum == 0 )
    String[iStrPos] = 0;

  String[iStrPos] += COMPRESS_bit[iBitNum] * Bit;
}

//---------------------------------------------------------------------------
//------ Lire un bit dans la chaine String  la position BitPos -------------
//---------------------------------------------------------------------------
int COMPRESS_getBit(int BitPos, char * String)
{
  int iStrPos;
  int iBitNum;

  iStrPos = BitPos / 8;
  iBitNum = BitPos % 8;

  return (String[iStrPos] & COMPRESS_bit[iBitNum] ? 1 : 0);
}

//---------------------------------------------------------------------------
//------ Ajouter un mot de 6 bits (Char) dans String  la position BitPos ---
//---------------------------------------------------------------------------
int COMPRESS_addChar(int BitPos, char Char, char * String)
{
  int 	index;
  int	Bit;

  for(index = 0; index < 6; index++)
  {
    Bit  = Char % 2;
    Char = Char / 2;
    COMPRESS_putBit(BitPos++, Bit, String);
  }

  return BitPos;
}