#include <alloc.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include "streams.h"
#include "define.h"
#include "symbol.h"
#include "message.h"
#include "cstatut.h"
#include "cmisc.h"
#include "cset.h"
#include "cshow.h"
#include "cupdate.h"
#include "execute.h"
#include "tools.h"
#include "buffers.h"
#include "message.h"
#include "commands.h"
#include "users.h"
#include "node.h"
#include "protocol.h"
#include "macro.h"

unsigned long 	COMMANDS_statut[MAX_STREAMS];
int		COMMANDS_iExitCode = 0;

char *pArg[MAX_ARG];		/*Liste des arguments*/
char *pStrArg[MAX_ARG];		/*Liste des chaines d'arguments*/

/*-------------------------------------------------------------------------
  ------ Initialiser ------------------------------------------------------
  -------------------------------------------------------------------------*/
void COMMANDS_init(void)
{
  int index;

  for(index = 0; index < MAX_STREAMS; index++)
    COMMANDS_statut[index] = 0L;

  /*Reserver de la memoire pour les arguments*/
  for(index = 0; index < MAX_ARG; index++)
  {
    pArg[index] = (char *) farmalloc (128);

    if( pArg[index] == NULL )
    {
      printf("COMMANDS_init : Not enough memory\n");
      exit (EXIT_FAILURE);
    }
  }
}

//--------------------------------------------------------------------------
//------ Vrifier si c'est cette commande qui a t saisie -----------------
//--------------------------------------------------------------------------
//Retourne TRUE si la commande a t indentifie
int COMMANDS_check(char * Cmd, char * ToCheck, int ToCheckLength, int MinLength)
{
  if( ! strncmp(Cmd, ToCheck, ToCheckLength) && ToCheckLength >= MinLength )
    return TRUE;
  else
    return FALSE;
}

/*------------------------------------------------------------------------
  ------ Extraire la commande et les arguments ---------------------------
  ------------------------------------------------------------------------
  Retourne le nombre de parametres                                        */
int CMD_extract(char * pString, char * pCmd, char * pPrefix, char * pSuffix, char **pArg, char ** pStrArg)
{
  char * pPtr1;
  char * pPtr2;
  int	 index;
  int	 nParams;		/*nombre de parametres*/

  for(index = 0; index < MAX_ARG; index++)
  {
    *pArg[index]    = SNULL;
     pStrArg[index] = NULL;
  }

  /*Virrer les premiers espaces, s'ils existent*/
  while( *pString == SPACE && *pString != SNULL )
    pString++;

  if( *pString == SNULL )
    return 0;
  else
    nParams = 1;

  /*Extraire la commande (qui ne doit pas excder 127 caracteres*/
  strncpy(pCmd, pString, 127);	/*Eviter les effets de bords*/
  pCmd[127] = SNULL;

  pPtr1 = pCmd;

  while( *pPtr1 != SPACE && *pPtr1 != SNULL )	/*Rechercher le separateur*/
    pPtr1++;

  if( *pPtr1 != SNULL )				/*Sera utile pour la lecture*/
    pString = pPtr1 + 1;                        /*des arguments*/
  else
    pString = pPtr1;

  *pPtr1 = SNULL;

  /*Toutes les commandes sont gerees en minuscules*/
  strlwr (pCmd);

  /*Extraire le prefixe*/
  pPtr1 = pCmd;
  pPtr2 = pPrefix;

  while( *pPtr1 != '/' && *pPtr1 != SNULL )
    *pPtr2++ = *pPtr1++;
  *pPtr2 = SNULL;

  /*Extraire le suffixe*/
  pPtr2  = pSuffix;

  if( *pPtr1 == '/' )	  			/*Passer le '/'*/
    pPtr1++;

  while( *pPtr1 != SNULL )
    *pPtr2++ = *pPtr1++;
  *pPtr2 = SNULL;

  /*Extraire les arguments*/
  pPtr1 = pString;

  /*Le premier argument correspond au suffixe de la commande*/
  if( *pSuffix )
    strcpy(pArg[0], pSuffix);
//  else
//    strcpy(pArg[0], pPrefix);	/*Sinon, c'est le prefixe*/
  pStrArg[0] = pArg[0];

  /*Lire les autres*/
  for(index = 1; index < MAX_ARG; index++)
  {
    int	iPos;

    if( ! * pPtr1 )			/*Si fin de chaine non atteinte ?*/
      break;

    nParams++;

    /*pStrArg*/
    pStrArg[index] = pPtr1;      	/*Pointeur sur la chaine*/

    /*pArg*/
    for(iPos = 0; iPos < 127; iPos++)	/*Prendre UN seul paramtre, MAX 127*/
    {
      if( *pPtr1 == SNULL )		/*Fin de chaine atteinte ?*/
      {
	pArg[index][iPos] = SNULL;
	break;
      }

      if( *pPtr1 != SPACE )		/*Espace ?*/
	pArg[index][iPos] = * pPtr1;	/*Non, copier*/
      else
      {					/*Oui, terminer*/
	pArg[index][iPos] = SNULL;
	while( * ++pPtr1 == SPACE );	/*Au cas ou l'utilisateur aurait*/
	  break;                        /*entre un espace en trop*/
      }

      pPtr1++;
    }/*End FOR*/
  }/*End FOR*/

  return nParams;
}

/*------------------------------------------------------------------------
  ------ Executer une commande -------------------------------------------
  ------------------------------------------------------------------------*/
void CMD_execute(int StreamNum, char * pString)
{
  extern char  *MSG_pParams[10];
  extern char	STREAMS_level[MAX_STREAMS];
  char	sCmd[128];		/*Commande entiere*/
  char  sCmd_p[128];		/*Prefixe de la commande*/
  char  sCmd_s[128];		/*Suffixe de la commande*/

  int	nParams;		/*nombre de parametres*/

  int	Length_p;		/*Longueur du prefixe de la commande*/

  int	index;			/*Pour les boucles FOR*/

  /*Executer selon les statuts du cannal*/
  if( StreamNum < RCMD_VIRTSTREAM && CSTATUT_execute(StreamNum, pString) )
    return;

  /*Extraire la commande et les arguments*/
  nParams = CMD_extract(pString, sCmd, sCmd_p, sCmd_s, pArg, pStrArg);

  /* Excuter une commande (si elle existe) dans le rpertoire \EXTCMD*/
  if( EXECUTE_command(StreamNum, sCmd, (pStrArg[1] != NULL ? pStrArg[1] : ""),
		      EXTCMD_PATH) != -1 )
  {
    Prompt;
    return;
  }/*End IF*/

  /* Executer une macro (si elle existe) dans le repertoire \EXTCMD */
  if( MACRO_command(StreamNum, sCmd, (pStrArg[1] != NULL ? pStrArg[1] : ""),
		    EXTCMD_PATH) != -1 )
  {
	Prompt;
	return;
  }


  /* Executer une commande ou une macro SYSOP (si elle existe) dans le
     rpertoire \SYSCMD */
  if( STREAMS_level[StreamNum] & LEVEL_sysopV )
  {
	if( EXECUTE_command(StreamNum, sCmd, (pStrArg[1] != NULL ? pStrArg[1] : ""),
			  SYSCMD_PATH) != -1 )
	{
		Prompt;
		return;
	}

	if( MACRO_command(StreamNum, sCmd, (pStrArg[1] != NULL ? pStrArg[1] : ""),
		    SYSCMD_PATH) != -1 )
	{
		Prompt;
		return;
	}
  }/*End IF*/

  /* Enlever l'identificateur d'une commande MACRO */
  if( sCmd[0] == 127 )	/* 127 : Id MACRO */
  {
	memmove(sCmd, sCmd + 1, strlen(sCmd));
	memmove(sCmd_p, sCmd_p + 1, strlen(sCmd_p));
  }

  /* Aucune commande a executer ? */
  if( nParams == 0 )
  {
    Prompt;
    return;
  }

  /*Passer la commande et les params au module MESSAGE.CPP*/
  MSG_pParams[0] = sCmd;
  MSG_pParams[9] = pStrArg[1];
  for(index = 1; index <= 8; index++)
    MSG_pParams[index] = pArg[index];

  /*Longueurs des chaines de la commande*/
  Length_p = strlen (sCmd_p);	/*Prfixe de la commande (ex : SHOW/dx)*/

  /*Diriger les commandes*/
  if( COMMANDS_check(sCmd_p, "show", Length_p, 2) )
    if( CSHOW_execute(StreamNum, sCmd_p, nParams, pArg, pStrArg) )
      return;

  if( COMMANDS_check(sCmd_p, "set", Length_p, 2) )
    if( CSET_execute(StreamNum, sCmd_p, nParams, pArg, pStrArg) )
      return;

  if( COMMANDS_check(sCmd_p, "update", Length_p, 2) )
    if( CUPDATE_execute(StreamNum, sCmd_p, nParams, pArg, pStrArg) )
      return;

  if( CMISC_execute(StreamNum, sCmd_p, nParams, pArg, pStrArg) )
    return;

  MSG_send(StreamNum, MSG2);	//Message d'erreur
  Prompt;

}

//---------------------------------------------------------------------------
//------ Diriger un talk ----------------------------------------------------
//---------------------------------------------------------------------------
void COMMANDS_talkMode(int StreamNum, char * String)
{
  extern 	tUserCfg * pUserCfg;
  extern char	STREAMS_callsign[MAX_STREAMS][10];
  char sExit[6];
  char sBuffer[256];
  char sNodeCall[11];
  char sUserCall[11];
  char sToUser[11];
  char sToNode[11];

  //Rcuprer en mmoire les indicatifs de l'utilisateur et du serveur
  NODE_getNodeCall(0, 0, sNodeCall);
  strcpy(sUserCall, STREAMS_callsign[StreamNum]);

  //Mettre  jour la structure
  USERS_getRecord( StreamNum );

  //Copier ToNode et ToUser (struct. pUserLocalConfig) pour les protger
  //d'une eventuelle modification dans PROTOCOL_sendTalk
  strcpy(sToUser, pUserCfg->sTalkToUser);
  strcpy(sToNode, pUserCfg->sTalkToNode);

  //L'utilisateur vient-il te terminer le talk ?
  strncpy(sExit, String, 5);	//Combine, car UNIX ne semble pas supporter stricmp
  sExit[5] = SNULL;
  strlwr( sExit );
  if( String[0] == CTRLZ || COMMANDS_check("/exit", sExit, strlen(sExit), 3) )
  {
    //Fin du mode Talk
    MSG_send(StreamNum, MSG26);        	//Pour l'utilisateur local
    Prompt;
    MSG_get(StreamNum, MSG26, sBuffer); //Pour le destinataire
    TOOLS_removeNR( sBuffer );
    PROTOCOL_sendTalk(0, sNodeCall, sUserCall, sToNode, sToUser, sBuffer, PROTOCOL_TALK_BELL, TOOLS_whatDateTime(), 100);

    COMMANDS_statut[StreamNum] &= ~COMMANDS_statutTalkMode;
  }
  else
  {
    if( ! PROTOCOL_sendTalk(0, sNodeCall, sUserCall, sToNode, sToUser, String, PROTOCOL_TALK_BELL, TOOLS_whatDateTime(), 100) )
    {
      //L'utilisateur a dconnect - fin du mode talk
      extern char    *MSG_pParams[10];
      MSG_pParams[1] = sToUser;
      MSG_send(StreamNum, MSG26);
      MSG_send(StreamNum, MSG23);
      Prompt;

      COMMANDS_statut[StreamNum] -= COMMANDS_statutTalkMode;
    }/*End IF*/
  }/*End IF*/
}

//--------------------------------------------------------------------------
//------ Envoyer le tableau des HOPS (pour la commande SH/HOPS) -----------
//--------------------------------------------------------------------------
void COMMANDS_sendHops(int StreamNum, char * NodeCall, int Pc16, int Pc19, int Pc50, int nCR)
{
  BUFFERS_printBuff(StreamNum, OUT, "%-10s", NodeCall);

  if( Pc16 != 100 )
    BUFFERS_printBuff(StreamNum, OUT, "H%02d     ", Pc16);
  else
    BUFFERS_printBuff(StreamNum, OUT, "%3s     ", "---");

  if( Pc19 != 100 )
    BUFFERS_printBuff(StreamNum, OUT, "H%02d     ", Pc19);
  else
    BUFFERS_printBuff(StreamNum, OUT, "%3s     ", "---");

  if( Pc50 != 100 )
    BUFFERS_printBuff(StreamNum, OUT, "H%02d", Pc50);
  else
    BUFFERS_printBuff(StreamNum, OUT, "%3s", "---");

  if( nCR )
    BUFFERS_printBuff(StreamNum, OUT, "\n");
}

