#include <alloc.h>
#include <string.h>
#include <dir.h>
#include <stdlib.h>
#include <ctype.h>
#include "define.h"
#include "commands.h"
#include "buffers.h"
#include "users.h"
#include "switch.h"
#include "message.h"
#include "cmisc.h"
#include "node.h"
#include "announce.h"
#include "protocol.h"
#include "tools.h"
#include "script.h"
#include "streams.h"
#include "dx.h"
#include "mail.h"
#include "help.h"
#include "database.h"
#include "ping.h"
#include "password.h"
#include "clulink.h"
#include "locator.h"
#include "process.h"
#include "rcmd.h"
#include "purg.h"
#ifdef DOS
#include "dos.h"
#endif
#include "medit.h"

/*------------------------------------------------------------------------
  ------ Rediriger les commandes MISC ------------------------------------
  ------------------------------------------------------------------------
  La fonction return TRUE si la commande a ete executee                   */
#pragma argsused
int CMISC_execute(int StreamNum, char * pCmd_p, int nParams, char **pArg, char **pStrArg)
{
	int Length;			/*Longueur de la commande*/

	/*Longueur de la commande*/
	Length = strlen (pCmd_p);

//  /*Interrogation d'une base de donnees locale ?*/
//  if( DATABASE_local(StreamNum, pArg[0], pArg[1], DB_LOCAL) )
//  {
//    /*Commande database OK*/
//    Prompt;
//    return TRUE;
//  }

	if( COMMANDS_check(pCmd_p, "announce", Length, 1) )
		return CMISC_announce(StreamNum, nParams, pArg, pStrArg);

	if( COMMANDS_check(pCmd_p, "bye", Length, 1) )
		return CMISC_bye(StreamNum, nParams, pArg, pStrArg);

	if( COMMANDS_check(pCmd_p, "conference", Length, 4) )
		return CMISC_conference(StreamNum, nParams, pArg, pStrArg);

	if( COMMANDS_check(pCmd_p, "connect", Length, 1) )
		return CMISC_connect(StreamNum, nParams, pArg, pStrArg);

	if( COMMANDS_check(pCmd_p, "convert", Length, 4) )
		return CMISC_convert(StreamNum, nParams, pArg, pStrArg);

	if( COMMANDS_check(pCmd_p, "disconnect", Length, 2) )
		return CMISC_discconnect(StreamNum, nParams, pArg, pStrArg);

#ifdef DOS
	if( ! strcmp(pCmd_p, "dos") )
		return CMISC_dos(StreamNum, nParams, pArg, pStrArg);
#endif

	if( ! strcmp(pCmd_p, "dx") )
		return CMISC_dx(StreamNum, nParams, pArg, pStrArg);

	if( ! strcmp(pCmd_p, "eu") )
		return CMISC_edituser(StreamNum, nParams, pArg, pStrArg);

	if( ! strcmp(pCmd_p, "exit") )
		return CMISC_exit(StreamNum, nParams, pArg, pStrArg);

	if( ! strcmp(pCmd_p, "fa") )
		return CMISC_fa(StreamNum, nParams, pArg, pStrArg);

	if( ! strcmp(pCmd_p, "fb") )
		return CMISC_fb(StreamNum, nParams, pArg, pStrArg);

	if( ! strcmp(pCmd_p, "fd") )
		return CMISC_fd(StreamNum, nParams, pArg, pStrArg);

	if( COMMANDS_check(pCmd_p, "forward", Length, 2) )
		return CMISC_forward(StreamNum, nParams, pArg, pStrArg);

	if( COMMANDS_check(pCmd_p, "fwd", Length, 2) )
		return CMISC_fwd(StreamNum, nParams, pArg, pStrArg);

	if( COMMANDS_check(pCmd_p, "help", Length, 1) )
		return CMISC_help(StreamNum, nParams, pArg, pStrArg);

	if( COMMANDS_check(pCmd_p, "ifnnode", Length, 4) )
		return CMISC_ifnnode(StreamNum, nParams, pArg, pStrArg);

	if( COMMANDS_check(pCmd_p, "ifnode", Length, 4) )
		return CMISC_ifnode(StreamNum, nParams, pArg, pStrArg);

	if( ! strcmp(pCmd_p, "index") )
		return CMISC_index(StreamNum, nParams, pArg, pStrArg);

	if( COMMANDS_check(pCmd_p, "information", Length, 1) )
		return CMISC_information(StreamNum, nParams, pArg, pStrArg);

	if( COMMANDS_check(pCmd_p, "init", Length, 1) )
		return CMISC_init(StreamNum, nParams, pArg, pStrArg);

	if( COMMANDS_check(pCmd_p, "kill", Length, 1) )
		return CMISC_kill(StreamNum, nParams, pArg, pStrArg);

	if( COMMANDS_check(pCmd_p, "list", Length, 1) )
		return CMISC_list(StreamNum, nParams, pArg, pStrArg);

	if( ! strcmp(pCmd_p, "ll") )
		return CMISC_ll(StreamNum, nParams, pArg, pStrArg);

	if( ! strcmp(pCmd_p, "lm") )
		return CMISC_lm(StreamNum, nParams, pArg, pStrArg);

	if( ! strcmp(pCmd_p, "ln") )
		return CMISC_ln(StreamNum, nParams, pArg, pStrArg);

	if( COMMANDS_check(pCmd_p, "medit", Length, 3) )
		return CMISC_medit(StreamNum, nParams, pArg, pStrArg);

	if( COMMANDS_check(pCmd_p, "purge", Length, 2) )
		return CMISC_purge(StreamNum, nParams, pArg, pStrArg);

	if( COMMANDS_check(pCmd_p, "ping", Length, 2) )
		return CMISC_ping(StreamNum, nParams, pArg, pStrArg);

	if( COMMANDS_check(pCmd_p, "rcmd", Length, 2) )
		return CMISC_rcmd(StreamNum, nParams, pArg, pStrArg);

	if( ! strcmp(pCmd_p, "quit") )			/*QUIT du serveur*/
		CMISC_quit(StreamNum, nParams, pArg, pStrArg);	/*Ne retourne rien*/

	if( COMMANDS_check(pCmd_p, "quit", Length, 1) )       /*Quit utilisateur*/
		return CMISC_bye(StreamNum, nParams, pArg, pStrArg);

	if( COMMANDS_check(pCmd_p, "read", Length, 1) )
		return CMISC_read(StreamNum, nParams, pArg, pStrArg);

	if( COMMANDS_check(pCmd_p, "send", Length, 1) )
		return CMISC_send(StreamNum, nParams, pArg, pStrArg, 0);

	if( ! strcmp(pCmd_p, "sp") )
		return CMISC_send(StreamNum, nParams, pArg, pStrArg, 1);

	if( ! strcmp(pCmd_p, "sb") )
		return CMISC_send(StreamNum, nParams, pArg, pStrArg, 2);

	if( COMMANDS_check(pCmd_p, "shutdown", Length, 4) )
		return CMISC_shutdown(StreamNum, nParams, pArg, pStrArg);

	if( COMMANDS_check(pCmd_p, "sysop", Length, 2) )
		return CMISC_sysop(StreamNum, nParams, pArg, pStrArg);

	if( COMMANDS_check(pCmd_p, "talk", Length, 1) )
		return CMISC_talk(StreamNum, nParams, pArg, pStrArg);

	if( ! strcmp(pCmd_p, "wwv") )
		return CMISC_wwv(StreamNum, nParams, pArg, pStrArg);

	if( ! strcmp(pCmd_p, "?") )
		return CMISC_help(StreamNum, nParams, pArg, pStrArg);

	return FALSE;		/*La commande n'a pas ete trouvee*/
}

/*------------------------------------------------------------------------
  ------ ANNOUNCE --------------------------------------------------------
  ------------------------------------------------------------------------*/
#pragma argsused
int CMISC_announce(int StreamNum, int nParams, char **pArg, char **pStrArg)
{
	extern char	STREAMS_callsign[MAX_STREAMS][10];
	char 	sRecipient[32];
	char	sNodeCall[16];
	char	sUserCall[16];
	char	cFlag = 0;
	extern char	STREAMS_level[MAX_STREAMS];

	/* Niveau d'utilisateur remote command */
	if( ! RCMD_isAllowed(StreamNum, RCMD_NOTALLOWED) )
		return FALSE;

	/*RX only ?*/
	if( STREAMS_level[StreamNum] & LEVEL_user_RXonly )
		return FALSE;

	if( nParams == 1 )
	{
		MSG_send(StreamNum, MSG17);
		Prompt;
		return TRUE;
	}

	/*Indicatif du cluster et de l'utilisateur*/
	NODE_getNodeCall(0, 0, sNodeCall);
	strcpy(sUserCall, STREAMS_callsign[StreamNum]);

	/*A qui faut-il distribuer cette annonce ?*/
	if( *pArg[0] == SNULL )
	{
		/*Annonce locale*/
		strcpy(sRecipient, "LOCAL");
		cFlag = (char) ANNOUNCE_LOCAL;
	}
	else if( COMMANDS_check(pArg[0], "full", strlen (pArg[0]), 1) )
	{
		/*Annonce generale*/
		strcpy(sRecipient, "*");
		cFlag = ANNOUNCE_ALL;
	}
	else if( COMMANDS_check(pArg[0], "sysop", strlen (pArg[0]), 2) )
	{
		/*Annonce destinee aux sysops*/
		strcpy(sRecipient, "*");
		cFlag = ANNOUNCE_TOSYSOP;
	}
	else
	{
		/*L'adresser a un cluster en particulier*/
		strcpy (sRecipient, pArg[0]);
		strupr (sRecipient);

		if( NODE_isNodeConnected (sRecipient) != 0 )
		{
			/*Cluster connecte : OK*/
			cFlag = ANNOUNCE_TOCLUSTER;
		}
		else
		{
			/*Cluster non connecte : afficher erreur*/
			extern char    *MSG_pParams[10];

			MSG_pParams[1] = sRecipient;
			MSG_send(StreamNum, MSG19);
		}
	}

	if( cFlag )	/*si cFlag = 0, ne pas traiter*/
	{
		/*Transmettre l'annonce aux adjacents et l'afficher*/
		PROTOCOL_sendAnnounce(0, sNodeCall, sUserCall, sRecipient,
			  TOOLS_whatDateTime(), cFlag, pStrArg[1], 100);
	}

	Prompt;
	return TRUE;
}

/*------------------------------------------------------------------------
  ------ BYE -------------------------------------------------------------
  ------------------------------------------------------------------------*/
#pragma argsused
int CMISC_bye(int StreamNum, int nParams, char **pArg, char **pStrArg)
{
	extern unsigned long 	COMMANDS_statut[MAX_STREAMS];

	/* Niveau d'utilisateur remote command */
	if( ! RCMD_isAllowed(StreamNum, RCMD_NOTALLOWED) )
		return FALSE;

	if( StreamNum == 0 || StreamNum == 65 )
		return FALSE;

	MSG_send(StreamNum, MSG21);
	COMMANDS_statut[StreamNum] = COMMANDS_statutDisconnect;
	return TRUE;
}

/*------------------------------------------------------------------------
  ------ CONNECT ---------------------------------------------------------
  ------------------------------------------------------------------------*/
#pragma argsused
int CMISC_connect(int StreamNum, int nParams, char **pArg, char **pStrArg)
{
	extern char	STREAMS_level[MAX_STREAMS];
	char	sScriptName[MAXPATH];
	int	iOpenStatut;
	int	iScriptStream = StreamNum;	/*utilise par SCRIPT_open*/

	/* Niveau d'utilisateur remote command */
	if( ! RCMD_isAllowed(StreamNum, RCMD_SYSOP) )
		return FALSE;

	/*Niveau d'utilisateur*/
	if( ! (STREAMS_level[StreamNum] & LEVEL_sysopD) )
		return FALSE;

	if( nParams != 2 )
	{
		if( nParams == 1 )
			BUFFERS_addBuff(StreamNum, "*** Error : missing callsign.\n", OUT);
		else
			MSG_send(StreamNum, MSG58);
		Prompt;
		return TRUE;
	}

	strcpy (sScriptName, pArg[1]);
	strupr (sScriptName);

#ifdef DOS
	/*Sous DOS, limiter le nom de fichier a huits caracteres*/
	TOOLS_maxLength(sScriptName, 8);
#endif

	/*Ouvrir le stream*/
	iOpenStatut = SCRIPT_open(iScriptStream, sScriptName);

	switch( iOpenStatut )
	{
	case SCRIPT_OK :
		BUFFERS_printBuff(StreamNum, OUT,
			"Connection to %s in progress on stream %d.\n",
			sScriptName, iScriptStream);
		 break;

	case SCRIPT_NOTFOUND :
		BUFFERS_printBuff(StreamNum, OUT,
			"*** Error : can't found the script file for %s.\n",
			sScriptName);
		 break;

	case SCRIPT_FULL :
		BUFFERS_addBuff(StreamNum, "*** Error : all streams are in use.\n", OUT);
		break;

	case SCRIPT_TWICE :
		if( StreamNum != 0 )
		{
			BUFFERS_addBuff(StreamNum,
				"*** Script connection failed : can't connect twice.\n",
				OUT);
		}
		else
			return TRUE;	/* Pas de prompt */
		break;

	case SCRIPT_ALREADYCONNECTED :
		if( StreamNum != 0 )
		{
			BUFFERS_addBuff(StreamNum,
				"*** Script connection aborted : station already connected to the cluster.\n",
				OUT);
		}
		else
			return TRUE;	/* Pas de prompt */
		break;
	}/*End SWITCH*/

	Prompt;
	return TRUE;
}

/*------------------------------------------------------------------------
  ------ CONFERENCE ------------------------------------------------------
  ------------------------------------------------------------------------*/
#pragma argsused
int CMISC_conference(int StreamNum, int nParams, char **pArg, char **pStrArg)
{
	extern char	STREAMS_callsign[MAX_STREAMS][10];
	extern unsigned long 	COMMANDS_statut[MAX_STREAMS];

	char szText[256];

	/* Niveau d'utilisateur remote command */
	if( ! RCMD_isAllowed(StreamNum, RCMD_NOTALLOWED) )
		return FALSE;

	if( COMMANDS_statut[StreamNum] & COMMANDS_statutLocalConf ||
	    COMMANDS_statut[StreamNum] & COMMANDS_statutClusterConf )
		return FALSE;

	/* Conference locale ou cluster-wide ? */
	if( *pArg[0] )
	{
		char szBuffer[256];

		/* conference cluster-wide */
		if( ! COMMANDS_check(pArg[0], "full", strlen(pArg[0]), 1) )
			return FALSE;	/* erreur dans le /full */

		/* Informer les adjacents */
		PROTOCOL_sendClusterConfLogin(0, STREAMS_callsign[0],
			STREAMS_callsign[StreamNum], 100);

		/* Informer les utilisateurs (AK1A ne le fait pas automatiquement) */
		sprintf(szBuffer, "%s@%s entering the cluster-wide conference",
			STREAMS_callsign[StreamNum], STREAMS_callsign[0]);
		PROTOCOL_sendClusterConferenceMessage(0, STREAMS_callsign[0],
		STREAMS_callsign[StreamNum], szBuffer, 100);

		COMMANDS_statut[StreamNum] |= COMMANDS_statutClusterConf;

		MSG_send(StreamNum, MSG73);
	}
	else
	{
		unsigned char cFlag;

		/* Conference locale */
		sprintf(szText, "%s entering the local conference\n",
			STREAMS_callsign[StreamNum]);
		USERS_sendAll(szText, USERS_LOCALCONF, PROTOCOL_CONFERENCE, -1);

		COMMANDS_statut[StreamNum] |= COMMANDS_statutLocalConf;
		MSG_send(StreamNum, MSG72);

		/* Modifier la config en mmoire */
		cFlag  = NODE_getUserFlag(STREAMS_callsign[0],
			STREAMS_callsign[StreamNum]);
		cFlag |= PROTOCOL_USER_CONF;
		NODE_setUserFlag(STREAMS_callsign[0], STREAMS_callsign[StreamNum],
			cFlag);
	}

	return TRUE;
}

/*------------------------------------------------------------------------
  ------ CONVERT ---------------------------------------------------------
  ------------------------------------------------------------------------*/
#pragma argsused
int CMISC_convert(int StreamNum, int nParams, char **pArg, char **pStrArg)
{

	/* Niveau d'utilisateur remote command */
	if( ! RCMD_isAllowed(StreamNum, RCMD_USER) )
		return FALSE;

	/* CONV/L2C ? */
	if( ! strcmp(pArg[0], "l2c") ) /* locator -> coordonnees */
	{
		LOCATOR_PAVCOORDINATES pavCoordinates;
		char szLocator[8];

		/* Verifier le nombre de parametres */
		if( nParams != 2 )
		{
			if( nParams == 1 )
				MSG_send(StreamNum, MSG17);	/*Necessite 1 arg*/
			else
				MSG_send(StreamNum, MSG58);	/*Nbr d'arg incorrect*/
			Prompt;
			return TRUE;
		}

		/* Traitement argument locator */
		TOOLS_maxLength(pArg[1], 6);
		strcpy(szLocator, pArg[1]);
		strupr(szLocator);

		/* Verifier la validite du locator */
		if( ! LOCATOR_isValidWW(szLocator) )
		{
			MSG_send(StreamNum, MSG18);
			Prompt;
			return TRUE;
		}

		/* Calculer */
		LOCATOR_locator2pavCoordinates(szLocator, &pavCoordinates);

		/* Afficher */
		BUFFERS_printBuff(StreamNum, OUT,
			  "Latitude  : %02d %02d' %c\nLongitude : %02d %02d' %c\n",
			  pavCoordinates.nLatDegrees,
			  pavCoordinates.nLatMinutes,
			  (pavCoordinates.nLatN ? 'N' : 'S'),
			  pavCoordinates.nLongDegrees,
			  pavCoordinates.nLongMinutes,
			  (pavCoordinates.nLongE ? 'E' : 'W') );
		Prompt;
		return TRUE;
	}

	/* CONV/C2L ? */
	if( ! strcmp(pArg[0], "c2l") ) /* coordonnees -> locator */
	{
		LOCATOR_PAVCOORDINATES pavCoordinates;
		extern char *MSG_pParams[10];
		char         szLocator[16];

		/* Exemple pour les messages d'erreur */
		MSG_pParams[9] = "CONV/C2L 48 51 N 2 14 W";

		/* Verifier le nombre de parametres */
		if( nParams != 7 )
		{
			MSG_send(StreamNum, MSG70);	/*Nbr d'arg incorrect*/
			Prompt;
			return TRUE;
		}

		/* Verifier les parametres */
		strupr(pArg[3]);
		strupr(pArg[6]);
		if( ! isdigit(*pArg[1]) || ! isdigit(*pArg[2]) ||
		    ! isdigit(*pArg[4]) || ! isdigit(*pArg[5]) ||
		    ( strcmp(pArg[3], "N") && strcmp(pArg[3], "S") ) ||
		    ( strcmp(pArg[6], "E") && strcmp(pArg[6], "W") ) )
		{
			/* Erreur dans un argument */
			MSG_send(StreamNum, MSG70);
			Prompt;
			return TRUE;
		}

		/* Latitude */
		pavCoordinates.nLatDegrees = atoi(pArg[1]);
		pavCoordinates.nLatMinutes = atoi(pArg[2]);
		strupr(pArg[3]);
		if( *pArg[3] == 'N' )
			pavCoordinates.nLatN = TRUE;
		else
			pavCoordinates.nLatN = FALSE;

		/* Longitude */
		pavCoordinates.nLongDegrees = atoi(pArg[4]);
		pavCoordinates.nLongMinutes = atoi(pArg[5]);
		strupr(pArg[6]);
		if( *pArg[6] == 'E' )
			pavCoordinates.nLongE = TRUE;
		else
			pavCoordinates.nLongE = FALSE;


		LOCATOR_pavCoordinates2locator(pavCoordinates, szLocator);

		/* Afficher la repone */
		BUFFERS_printBuff(StreamNum, OUT, "%s\n", szLocator);

		Prompt;
		return TRUE;
	}

	/* Commande CONVERT/??? inconnue */
	return FALSE;
}

/*------------------------------------------------------------------------
  ------ DISCONNECT ------------------------------------------------------
  ------------------------------------------------------------------------*/
#pragma argsused
int CMISC_discconnect(int StreamNum, int nParams, char **pArg, char **pStrArg)
{
	extern int 	FirstStream;	/*switch.cpp*/
	extern int 	LastStream;	/*switch.cpp*/
	extern char	STREAMS_level[MAX_STREAMS];
	extern char	STREAMS_callsign[MAX_STREAMS][10];
	int nLength;

	/* Niveau d'utilisateur remote command */
	if( ! RCMD_isAllowed(StreamNum, RCMD_SYSOP) )
		return FALSE;

	/*Niveau d'utilisateur*/
	if( ! (STREAMS_level[StreamNum] & LEVEL_sysopV) )
		return FALSE;

	if( nParams > 2 )
	{
		MSG_send(StreamNum, MSG58);
		BUFFERS_addBuff(StreamNum, "DISC <call>, DISC/ALL, DISC/FORCED <call>, DISC/<stream>\n", OUT);
		Prompt;
		return TRUE;
	}

	nLength = strlen(pArg[0]);

	/*Deconnecter tout le monde, ou juste un stream ?*/
	if( nLength && ! strncmp("all", pArg[0], nLength) )
	{
		int index;

		/*Deconnecter tout le monde*/
		for(index = FirstStream; index <= LastStream; index++)
		{
			STREAMS_disconnect(index);
			SWITCH_discSwitch (index);
		}/*End FOR*/
		BUFFERS_addBuff(StreamNum, "All channels are being disconnected.\n", OUT);
	}
	else if( (nLength && ! strncmp("forced", pArg[0], nLength) ) || nLength == 0 )
	{
		int 	iStream;
		char	szUserCall[16];
		char	szNodeCall[16];

		if( nParams != 2 ) /*Nombre d'arguments incorrect*/
		{
			MSG_send(StreamNum, MSG17);
			Prompt;
			return TRUE;
		}

		strcpy (szUserCall, TOOLS_maxLength (pArg[1], 10));
		strupr (szUserCall);

		iStream = NODE_searchUser (szUserCall, NODE_CHECKSSID_YES, szNodeCall);

		/* Leve de doute au cas ou c'est un cluster qu'on veut deconnecter */
		if( iStream >= FirstStream || iStream <= LastStream && *szNodeCall)
		{
			int	iStreamOfNode;
			int	iNodePos;

			if( NODE_isNodeConnected(szUserCall, &iStreamOfNode, &iNodePos) )
			{
				if( iNodePos == 0 )
				{
					iStream     = iStreamOfNode;
					*szNodeCall = SNULL;
				}
			}
		}

		if( iStream >= FirstStream && iStream <= LastStream && ! *szNodeCall )
		{
			BUFFERS_printBuff (StreamNum, OUT,
				"%s on channel %d is being disconnected.\n", szUserCall, iStream);

			/* Mode non FORCED : Est-ce un cluster ? */
			if( (STREAMS_level[iStream] & LEVEL_cluster) && nLength == 0 )
			{
				/* Transmettre un PC39 et informer les adjacents */
				char szBuffer[256];
				char szCall[256];

				NODE_getNodeCall(0, 0, szCall);
				sprintf(szBuffer, "Disconnected by operator at %s", szCall);
				PROTOCOL_sendExplicitDisconnect(StreamNum, szUserCall, szBuffer);
				NODE_deleteNode(iStream, szUserCall);
				STREAMS_level   [iStream]    = LEVEL_discByOp;
				STREAMS_callsign[iStream][0] = SNULL;
			}
			else
			{
				STREAMS_disconnect(iStream);
				SWITCH_discSwitch (iStream);
				STREAMS_callsign[iStream][0] = SNULL;
				STREAMS_level   [iStream]    = 0;
			}
		}
		else
		{
			BUFFERS_printBuff (StreamNum, OUT,
				"*** Error : %s in not a valid callsign or is not connected.\n",
				szUserCall);
		}
	}
	else
	{
		int iStream = atoi (pArg[0]);

		if( iStream < FirstStream || iStream > LastStream )
			BUFFERS_addBuff(StreamNum, "*** Error : out of range.\n", OUT);
		else
		{
			BUFFERS_printBuff (StreamNum, OUT,
				"Channel %d is being disconnected.\n", iStream);
			STREAMS_disconnect(iStream);
			SWITCH_discSwitch (iStream);
			STREAMS_callsign[iStream][0] = SNULL;
			STREAMS_level   [iStream]    = 0;
		}
	}/*End IF*/

	Prompt;
	return TRUE;
}

/*------------------------------------------------------------------------
  ------ DOS -------------------------------------------------------------
  ------------------------------------------------------------------------*/
#ifdef DOS
#pragma argsused
int CMISC_dos(int StreamNum, int nParams, char **pArg, char **pStrArg)
{
	extern char		STREAMS_level[MAX_STREAMS];
	extern unsigned long 	COMMANDS_statut[MAX_STREAMS];

	/* Niveau d'utilisateur remote command */
	if( ! RCMD_isAllowed(StreamNum, RCMD_NOTALLOWED) )
		return FALSE;

	/* Niveau d'utilisateur */
	if( ! (STREAMS_level[StreamNum] & LEVEL_sysopV) )
		return FALSE;

	/* Verifier le nombre de prametres */
	if( nParams != 1 )
	{
		MSG_send(StreamNum, MSG58);
		Prompt;
		return TRUE;
	}

	BUFFERS_addBuff(StreamNum, "Type EXIT to return to DxNet . . .\n\n",
			OUT);

	/* Entree dans le mode DOS */
	if( DOS_start(StreamNum) )
		COMMANDS_statut[StreamNum] |= COMMANDS_statutDOS;

	return TRUE;
}
#endif

/*------------------------------------------------------------------------
  ------ DX --------------------------------------------------------------
  ------------------------------------------------------------------------*/
#pragma argsused
int CMISC_dx(int StreamNum, int nParams, char **pArg, char **pStrArg)
{
	unsigned long lFrequency;
	int		iDxCallPos;
	extern char	STREAMS_level[MAX_STREAMS];

	/* Niveau d'utilisateur remote command */
	if( ! RCMD_isAllowed(StreamNum, RCMD_NOTALLOWED) )
		return FALSE;

	/*RX only ?*/
	if( STREAMS_level[StreamNum] & LEVEL_user_RXonly )
		return FALSE;

	if( nParams < 3 )
	{
		MSG_send(StreamNum, MSG8);
		Prompt;
		return TRUE;
	}

	/*La frquence est-elle en premire ou deuxime position ?*/
	/*(on ajoute 0.000001 pour corriger un bug sous linux)*/
	if( atol (pArg[2]) > atol (pArg[1]) )
	{
		lFrequency = (unsigned long) (atof (pArg[2]) * 10.0 + 0.000001);
		iDxCallPos = 1;
	}
	else
	{
		lFrequency = (unsigned long) (atof (pArg[1]) * 10.0 + 0.000001);
		iDxCallPos = 2;
	}

	strupr (pArg[iDxCallPos]);

	/*Frequence valide ?*/
	if( DX_checkFrequency (lFrequency) )
	{
		extern char	STREAMS_callsign[MAX_STREAMS][10];
		extern int	PARAMS_iSetDxSsid;
		char sNodeCall[16];
		char sUserCall[16];
		char sDate[16];
		char sTime[8];

		/*Rcuprer en mmoire les indicatifs du logger et du serveur*/
		NODE_getNodeCall(0, 0, sNodeCall);
		strcpy(sUserCall, STREAMS_callsign[StreamNum]);

		/*Enleve le SSID si SET/DXSSID est a OFF*/
		if( ! PARAMS_iSetDxSsid )
			TOOLS_removeSsid (sUserCall);

		/*L'utilisateur a peut-etre demande a ce qu'un indicatif special
		  soit utilise en tant que logger*/
		if( *pArg[0] )
		{
			strupr (pArg[0]);

			if( ! TOOLS_isCall (pArg[0]) )
			{
				extern char    *MSG_pParams[10];

				MSG_pParams[1] = pArg[0];
				MSG_send(StreamNum, MSG18);
				Prompt;
				return TRUE;
			}

			TOOLS_maxLength(pArg[0], 9);
			strcpy(sUserCall, pArg[0]);
		}

		/*Date et heure*/
		TOOLS_whatDate (sDate);
		TOOLS_whatTime (sTime);

		/*Transmettre le DX sur le reseau cluster*/
		if( nParams > 3 )
			PROTOCOL_sendDx(0, sNodeCall, sUserCall, lFrequency, sDate, sTime,
				pArg[iDxCallPos], pStrArg[3], 100);
		else
			PROTOCOL_sendDx(0, sNodeCall, sUserCall, lFrequency, sDate, sTime,
				 pArg[iDxCallPos], " ", 100);

	}
	else
	{
		MSG_send(StreamNum, MSG5);	/*Erreur dans la frequence*/
	}/*End IF*/

	Prompt;
	return TRUE;
}

/*------------------------------------------------------------------------
  ------ EDITUSER --------------------------------------------------------
  ------------------------------------------------------------------------*/
#pragma argsused
int CMISC_edituser(int StreamNum, int nParams, char **pArg, char **pStrArg)
{
	extern unsigned long COMMANDS_statut[MAX_STREAMS];
	extern tUserCfg * pUserCfg;
	char sUserEdit[16];
	extern char	STREAMS_level[MAX_STREAMS];

	/* Niveau d'utilisateur remote command */
	if( ! RCMD_isAllowed(StreamNum, RCMD_NOTALLOWED) )
		return FALSE;

	/*RX only ?*/
	if( STREAMS_level[StreamNum] & LEVEL_user_RXonly )
		return FALSE;

	if( nParams != 1 )
	{
		extern char	STREAMS_level[MAX_STREAMS];
		extern char	STREAMS_callsign[MAX_STREAMS][10];
		char 	szArg1[16];	/*Pout le test precedent, linux ne supportant
				  pas stricmp*/

		TOOLS_maxLength(pArg[1], 9);
		strcpy (szArg1, pArg[1]);
		strupr (szArg1);
    

		/*N'autoriser que l'edition de sa propre config sauf si l'utilisateur*/
		/*est un sysop*/
		if( nParams != 2 || ( ! (STREAMS_level[StreamNum] & LEVEL_sysopV) &&
			    strcmp(STREAMS_callsign[StreamNum], szArg1)) )
		{
			MSG_send(StreamNum, MSG58);
			Prompt;
			return TRUE;
		}/*End IF*/
	}

	/*Indicatif a editer ?*/
	if( ! *pArg[1] )
	{
		extern char	STREAMS_callsign[MAX_STREAMS][10];

		/*Il n'y en a pas*/
		strcpy(sUserEdit, STREAMS_callsign[StreamNum]);
	}
	else
	{
		/*Oui, lequel est-ce ?*/
		TOOLS_maxLength (pArg[1], 6);
		strcpy (sUserEdit, pArg[1]);
		strupr (sUserEdit);
	}

	TOOLS_removeSsid(sUserEdit);
	USERS_getRecord(StreamNum);
	strcpy(pUserCfg->sEditUser, sUserEdit);

	/*Rechercher l'utilisateur dans la base de donnees USER*/
	if( USERS_isExist(sUserEdit) )
	{
		/*Si l'utilisateur existe*/
		USERS_get(sUserEdit, pUserCfg->sHomeNode, USERS_HOME);
		USERS_get(sUserEdit, pUserCfg->sName,     USERS_NAME);
		USERS_get(sUserEdit, pUserCfg->sQth,      USERS_QTH);
		USERS_get(sUserEdit, pUserCfg->sLocator,  USERS_LOCATOR);

		BUFFERS_printBuff(StreamNum, OUT, "Editing user %s.\n", sUserEdit);
		COMMANDS_statut[StreamNum] |= COMMANDS_statutEditUser;
		BUFFERS_addBuff(StreamNum, "\r", IN);
	}
	else
	{
		/*Sinon*/
		BUFFERS_printBuff(StreamNum, OUT,
		      "No entry in user database for %s. Create (Y/N) ?\n",
		      sUserEdit);
		COMMANDS_statut[StreamNum] |= COMMANDS_statutEditUserCreate;
	}

	USERS_updateLocalConfig(StreamNum);

	Prompt;
	return TRUE;
}

/*------------------------------------------------------------------------
  ------ EXIT ------------------------------------------------------------
  ------------------------------------------------------------------------*/
#pragma argsused
int CMISC_exit(int StreamNum, int nParams, char **pArg, char **pStrArg)
{
	extern char	STREAMS_level[MAX_STREAMS];
	extern int	COMMANDS_iExitCode;
	extern unsigned long 	COMMANDS_statut[MAX_STREAMS];
	int	iExitCode;

	/* Niveau d'utilisateur remote command */
	if( ! RCMD_isAllowed(StreamNum, RCMD_NOTALLOWED) )
		return FALSE;

	/*Niveau d'utilisateur*/
	if( ! (STREAMS_level[StreamNum] & LEVEL_sysopV) )
		return FALSE;

	if( ! *pArg[0] )
	{
		/*L'utilisateur a oublie de precise le code de sortie*/
		BUFFERS_addBuff(StreamNum, "***Error : missing exit code.\n", OUT);
		Prompt;
		return TRUE;
	}

	iExitCode = atoi (pArg[0]);

	/*Verifier le code*/
	if( iExitCode < 1 || iExitCode > 9 )
	{
		/*Erreur*/
		BUFFERS_addBuff(StreamNum, "*** Error : exit code out of range (1-9).\n", OUT);
		Prompt;
		return TRUE;
	}

	/*Envoyer un message aux utilisateurs connectes*/
	if( pStrArg[1] != NULL )
		USERS_sendAll(pStrArg[1], USERS_EXCEPTCONSOLE, PROTOCOL_EXIT, -1);	/*MSG specifie par sysop*/
	else
	{
		USERS_sendAll("Cluster shutdown...\nYou are going to be disconnected.\n",
		USERS_EXCEPTCONSOLE, PROTOCOL_EXIT, -1);
	}

	/*Quel est le code de sortie ?*/
	COMMANDS_iExitCode = iExitCode;
	BUFFERS_printBuff(StreamNum, OUT,
		    "*** Exiting DxNet with error code %d (Y/N) ?\n",
		    COMMANDS_iExitCode);
	COMMANDS_statut[StreamNum] |= COMMANDS_statutExitServer;

	return TRUE;
}

/*------------------------------------------------------------------------
  ------ FA --------------------------------------------------------------
  ------------------------------------------------------------------------*/
#pragma argsused
int CMISC_fa(int StreamNum, int nParams, char **pArg, char **pStrArg)
{
	extern char	STREAMS_level[MAX_STREAMS];
	unsigned long dwNumber;

	/* Niveau d'utilisateur remote command */
	if( ! RCMD_isAllowed(StreamNum, RCMD_SYSOP) )
		return FALSE;

	/*Niveau d'utilisateur*/
	if( ! (STREAMS_level[StreamNum] & LEVEL_sysopD) )
		return FALSE;

	if( nParams != 3 )
	{
		MSG_send(StreamNum, MSG58);
		Prompt;
		return TRUE;
	}

	dwNumber = atol (pArg[1]);

	if( ! MAIL_isMailExist (dwNumber) )
	{
		/*Impossible de queue un message qui n'existe pas*/
		BUFFERS_printBuff(StreamNum, OUT,
		      "*** Error : message #%ld does not exist.\n",
		      dwNumber);
	}
	else if( dwNumber != 0L )
	{
		strupr (pArg[2]);

		/*Essayer de retirer de la file d'attente*/
		if( MAIL_queue(pArg[2], dwNumber) )
			BUFFERS_printBuff(StreamNum, OUT, "Message #%ld @%s queued.\n", dwNumber, pArg[2]);
		else
			BUFFERS_printBuff(StreamNum, OUT, "Unable to queue message #%ld @%s.\n", dwNumber, pArg[2]);
	}
	else
	{
		/*Erreur quelque part*/
		BUFFERS_addBuff(StreamNum, "*** Error : incorrect arguments (FA <#msg> <@Callsign>).\n", OUT);
	}

	Prompt;
	return TRUE;
}

/*------------------------------------------------------------------------
  ------ FB --------------------------------------------------------------
  ------------------------------------------------------------------------*/
#pragma argsused
int CMISC_fb(int StreamNum, int nParams, char **pArg, char **pStrArg)
{
	extern char	STREAMS_level[MAX_STREAMS];

	/* Niveau d'utilisateur remote command */
	if( ! RCMD_isAllowed(StreamNum, RCMD_SYSOP) )
		return FALSE;

	/*Niveau d'utilisateur*/
	if( ! (STREAMS_level[StreamNum] & LEVEL_sysopD) )
		return FALSE;

	if( nParams > 2 )
		MSG_send(StreamNum, MSG58);	/*Pas plus d'un parametre*/
	else
		MAIL_viewQueue(StreamNum, pArg[1]);

	Prompt;
	return TRUE;
}

/*------------------------------------------------------------------------
  ------ FD --------------------------------------------------------------
  ------------------------------------------------------------------------*/
#pragma argsused
int CMISC_fd(int StreamNum, int nParams, char **pArg, char **pStrArg)
{
	extern char	STREAMS_level[MAX_STREAMS];
	unsigned long dwNumber;

	/* Niveau d'utilisateur remote command */
	if( ! RCMD_isAllowed(StreamNum, RCMD_SYSOP) )
		return FALSE;

	/*Niveau d'utilisateur*/
	if( ! (STREAMS_level[StreamNum] & LEVEL_sysopD) )
		return FALSE;

	if( nParams != 3 )
	{
		MSG_send(StreamNum, MSG58);
		Prompt;
		return TRUE;
	}

	dwNumber = atol (pArg[1]);

	if( dwNumber != 0L )
	{
		strupr (pArg[2]);

		if( MAIL_deQueue(pArg[2], dwNumber) )
			BUFFERS_printBuff(StreamNum, OUT, "Message #%ld @%s dequeued.\n", dwNumber, pArg[2]);
		else
			BUFFERS_printBuff(StreamNum, OUT, "Unable to dequeue the message #%ld @%s.\n", dwNumber, pArg[2]);
	}
	else
	{
		BUFFERS_addBuff(StreamNum, "*** Error : incorrect arguments (FD <#msg> <@Callsign>.\n", OUT);
	}

	Prompt;
	return TRUE;
}

/*------------------------------------------------------------------------
  ------ FORWARD ---------------------------------------------------------
  ------------------------------------------------------------------------*/
#pragma argsused
int CMISC_forward(int StreamNum, int nParams, char **pArg, char **pStrArg)
{
	extern char	STREAMS_level[MAX_STREAMS];

	/* Niveau d'utilisateur remote command */
	if( ! RCMD_isAllowed(StreamNum, RCMD_SYSOP) )
		return FALSE;

	/* Niveau d'utilisateur */
	if( ! (STREAMS_level[StreamNum] & LEVEL_sysopV) )
		return FALSE;

	/* FOrward/Opernam ? */
	if( COMMANDS_check(pArg[0], "opernam", strlen(pArg[0]), 1) )
	{
		char  szNodeCall[16];
		char  szUserCall[16];
		tUser user;

		/* Verifier le nombre de parametres */
		if( nParams != 2 )
		{
			MSG_send(StreamNum, MSG58);
			Prompt;
			return TRUE;
		}

		/* Mettre en forme l'indicatif */
		TOOLS_maxLength(pArg[1], 9);
		strcpy(szUserCall, pArg[1]);
		TOOLS_removeSsid(szUserCall);
		strupr(szUserCall);

		/* Transmettre les infos sur le reseau cluster */
		NODE_getNodeCall(0, 0, szNodeCall);
		if( ! USERS_getConfig(szUserCall, &user) )
		{
			/* L'utilisateur n'existe pas */
			MSG_send(StreamNum, MSG31);
			Prompt;
			return TRUE;
		}

		/* Prenom de l'utilisateur */
		if( strcmp(user.sName, szUserCall) )
		{
			PROTOCOL_sendUserConfig(0, szNodeCall, szUserCall,
					user.sName, USERS_NAME, 100);
		}

		/* QTH de l'utilisateur */
		if( user.sQth[0] )
		{
			PROTOCOL_sendUserConfig(0, szNodeCall, szUserCall,
					user.sQth, USERS_QTH, 100);
		}

		/* Home node de l'utilisateur */
		if( user.sHomeNode[0] )
		{
			PROTOCOL_sendUserConfig(0, szNodeCall, szUserCall,
					user.sHomeNode, USERS_HOME, 100);
		}

		/* Coordonnees */
		if( user.sLocator[0] )
		{
			PROTOCOL_sendUserConfig(0, szNodeCall, szUserCall,
					user.sLocator, USERS_LOCATOR, 100);
		}

		Prompt;
		return TRUE;
	}

	/* Commande FORWARD/??? inconnue */
	return FALSE;
}


/*------------------------------------------------------------------------
  ------ FWD -------------------------------------------------------------
  ------------------------------------------------------------------------*/
#pragma argsused
int CMISC_fwd(int StreamNum, int nParams, char **pArg, char **pStrArg)
{
	extern char	STREAMS_level[MAX_STREAMS];
	unsigned long dwNumber = 0L;
	char		szRoute[16];

	/* Niveau d'utilisateur remote command */
	if( ! RCMD_isAllowed(StreamNum, RCMD_SYSOP) )
		return FALSE;

	/*Niveau d'utilisateur*/
	if( ! (STREAMS_level[StreamNum] & LEVEL_sysopD) )
		return FALSE;

	switch( nParams )
	{
	case 3 :
		dwNumber = atol (pArg[1]);
		strcpy(szRoute, TOOLS_maxLength(pArg[2], 9));

		if( dwNumber == 0L )
		{
			BUFFERS_addBuff(StreamNum,
				"*** Error : incorrect message number.\n",
				OUT);
			Prompt;
			return TRUE;
		}
		break;

	case 2 :
		dwNumber = 0L;
		strcpy(szRoute, TOOLS_maxLength(pArg[1], 9));
		break;

	case 1 :
		dwNumber = 0;
		strcpy(szRoute, "");
		break;

	default :
		MSG_send(StreamNum, MSG58);
		break;
	}/*End SWITCH*/

	if( nParams >= 1 && nParams <= 3 ) 	/*Nombre d'arg OK - fwd lance*/
	{
		BUFFERS_addBuff(StreamNum, "Starting forward ...\n", OUT);
		MAIL_fwd(szRoute, dwNumber, StreamNum);
	}

	Prompt;
	return TRUE;
}

/*------------------------------------------------------------------------
  ------ HELP ------------------------------------------------------------
  ------------------------------------------------------------------------*/
#pragma argsused
int CMISC_help(int StreamNum, int nParams, char **pArg, char **pStrArg)
{
	/* Niveau d'utilisateur remote command */
	if( ! RCMD_isAllowed(StreamNum, RCMD_USER) )
		return FALSE;

	if( nParams < 3 )
		HELP_send(StreamNum, pArg[1]);
	else
		MSG_send(StreamNum, MSG58);

	Prompt;
	return TRUE;
}

/*------------------------------------------------------------------------
  ------ IFNNODE ----------------------------------------------------------
  ------------------------------------------------------------------------*/
#pragma argsused
int CMISC_ifnnode(int StreamNum, int nParams, char **pArg, char **pStrArg)
{
	extern char	STREAMS_level[MAX_STREAMS];
	extern int 	LastStream;	/*switch.cpp*/

	int  nStream;
	int  nNodePos;
	char szNodeCall[16];
	char * pLookingFor = strupr(pArg[1]);
	int  done = FALSE;

	/* Niveau d'utilisateur remote command */
	if( ! RCMD_isAllowed(StreamNum, RCMD_NOTALLOWED) )
		return FALSE;

	/* Niveau d'utilisateur */
	if( ! (STREAMS_level[StreamNum] & LEVEL_sysopV) )
		return FALSE;

	if( nParams < 3 )
	{
		MSG_send(StreamNum, MSG58);
		Prompt;
		return TRUE;
	}

	/* Rechercher dans la liste des nodes */
	for(nStream = 0; nStream <= LastStream && done == FALSE; nStream++)
	{
		for(nNodePos = 0; nNodePos < NODE_MAXANODE; nNodePos++ )
		{
			/* Indicatif du node sur le stream */
			NODE_getNodeCall(nStream, nNodePos, szNodeCall);

			if( strcmp(szNodeCall, pLookingFor) )
				continue;

			done = TRUE;
			break;
		}
	}

	if( done == FALSE )
		CMD_execute(StreamNum, pStrArg[2]);

	return TRUE;
}

/*------------------------------------------------------------------------
  ------ IFNODE ----------------------------------------------------------
  ------------------------------------------------------------------------*/
#pragma argsused
int CMISC_ifnode(int StreamNum, int nParams, char **pArg, char **pStrArg)
{
	extern char	STREAMS_level[MAX_STREAMS];
	extern int 	LastStream;	/*switch.cpp*/

	int  nStream;
	int  nNodePos;
	char szNodeCall[16];
	char * pLookingFor = strupr(pArg[1]);
	int  done = FALSE;

	/* Niveau d'utilisateur remote command */
	if( ! RCMD_isAllowed(StreamNum, RCMD_NOTALLOWED) )
		return FALSE;

	/* Niveau d'utilisateur */
	if( ! (STREAMS_level[StreamNum] & LEVEL_sysopV) )
		return FALSE;

	if( nParams < 3 )
	{
		MSG_send(StreamNum, MSG58);
		Prompt;
		return TRUE;
	}

	/* Rechercher dans la liste des nodes */
	for(nStream = 0; nStream <= LastStream && done == FALSE; nStream++)
	{
		for(nNodePos = 0; nNodePos < NODE_MAXANODE; nNodePos++ )
		{
			/* Indicatif du node sur le stream */
			NODE_getNodeCall(nStream, nNodePos, szNodeCall);

			if( strcmp(szNodeCall, pLookingFor) )
				continue;

			done = TRUE;
			break;
		}
	}

	if( done == TRUE )
		CMD_execute(StreamNum, pStrArg[2]);

	return TRUE;

}

/*------------------------------------------------------------------------
  ------ INDEX -----------------------------------------------------------
  ------------------------------------------------------------------------
  Creer le fichier d'index d'une base de donnees                          */
#pragma argsused
int CMISC_index(int StreamNum, int nParams, char **pArg, char **pStrArg)
{
	extern char	STREAMS_level[MAX_STREAMS];
	char	 sIdxName[MAXPATH];
	char	*pPtr;

	/* Niveau d'utilisateur remote command */
	if( ! RCMD_isAllowed(StreamNum, RCMD_NOTALLOWED) )
		return FALSE;

	/*Niveau d'utilisateur*/
	if( ! (STREAMS_level[StreamNum] & LEVEL_sysopD) )
		return FALSE;

	if( nParams != 2 )
	{
		if( nParams == 1 )
			MSG_send(StreamNum, MSG17);	/*Necessite 1 arg*/
		else
			MSG_send(StreamNum, MSG58);	/*Nbr d'arg incorrect*/
		Prompt;
		return TRUE;
	}

	strcpy (sIdxName, pArg[1]);
	strlwr (sIdxName);

	/*Enlever le .IDX ou le .FUL, si le sysop l'a indique*/
	pPtr = strchr(sIdxName, '.');
	if( pPtr )
		*pPtr = SNULL;

	/*Creer le fichier d'index*/
	if( DATABASE_index (sIdxName, DB_CREATEIDX_YES) )
		BUFFERS_printBuff(StreamNum, OUT,
		      "Database index file %s.IDX updated.\n",
		      strupr (sIdxName) );
	else
		BUFFERS_printBuff(StreamNum, OUT,
		      "*** Error : unable to create index file %s.IDX\n",
		      strupr (sIdxName) );

	Prompt;
	return TRUE;
}

/*------------------------------------------------------------------------
  ------ INFORMATION -----------------------------------------------------
  ------------------------------------------------------------------------*/
#pragma argsused
int CMISC_information(int StreamNum, int nParams, char **pArg, char **pStrArg)
{
	/* Niveau d'utilisateur remote command */
	if( ! RCMD_isAllowed(StreamNum, RCMD_USER) )
		return FALSE;

	if( nParams == 1 )
		MSG_send(StreamNum, MSG4);	/*Information*/
	else
		MSG_send(StreamNum, MSG58);

	Prompt;
	return TRUE;
}

/*------------------------------------------------------------------------
  ------ INIT ------------------------------------------------------------
  ------------------------------------------------------------------------*/
#pragma argsused
int CMISC_init(int StreamNum, int nParams, char **pArg, char **pStrArg)
{
	extern char STREAMS_level[MAX_STREAMS];
	extern char PROTOCOL_linkType[65];
	int  	nStreamOfNode;
	int	nNodePos;
	char *pszNodeCall = strupr(pArg[1]);
	char  szMyNodeCall[16];
	char	szBuffer[256];

	/* Niveau d'utilisateur remote command */
	if( ! RCMD_isAllowed(StreamNum, RCMD_SYSOP) )
		return FALSE;

	/* Niveau d'utilisateur */
	if( ! (STREAMS_level[StreamNum] & LEVEL_sysopD) )
		return FALSE;

	if( nParams != 2 )
	{
		MSG_send(StreamNum, MSG17);	/* Necessite 1 arg */
		Prompt;
		return TRUE;
	}

	/* Est-ce bien un indicatif qui a ete indique ? */
	if( ! TOOLS_isCall(pszNodeCall) )
	{
		/* Non */
		MSG_send(StreamNum, MSG18);
		Prompt;
		return TRUE;
	}

	/* Recherche du stream de l'adjacent */
	if( ! NODE_isNodeConnected(pszNodeCall, &nStreamOfNode, &nNodePos) )
	{
		/* L'adjacent n'est pas connecte */
		MSG_send(StreamNum, MSG19);
		Prompt;
		return TRUE;
	}

	/* Est un adjacent immediat ? */
	if( nStreamOfNode == 0 || nNodePos != 0 )
	{
		/* Non */
		BUFFERS_printBuff(StreamNum, OUT,
			  "*** Error : %s is not an adjacent cluster.\n",
			  pszNodeCall);
		Prompt;
		return TRUE;
	}

	/* Informer les adjacents */
	NODE_getNodeCall(0, 0, szMyNodeCall);
	sprintf(szBuffer, "Link init request by %s", szMyNodeCall);
	PROTOCOL_clusterStreamDisconnected(nStreamOfNode, szBuffer, -1);

	/* Envoyer une trame d'init */
	PROTOCOL_sendConnectedNodeList(nStreamOfNode);

	/* Transmettre le request init (PC18) */
	if( PROTOCOL_linkType[nStreamOfNode] == PAVILLON )
	{
		/* Trame pavillon */
		BUFFERS_printBuff(nStreamOfNode, OUT, "PC18^DxNet v%s^%d^\n",
			  VERSION, VERSION_INT);
	}
	else
	{
		/* Trame CluLink */
		char 	szCluLink[256];
		int     nCluLinkPos;

		nCluLinkPos = PROTOCOL_setCluLink(szCluLink, CL(60));
		CLULINK_putSize(szCluLink, nCluLinkPos - 2);
		BUFFERS_addBuff_sized(nStreamOfNode, szCluLink, OUT, nCluLinkPos);
	}

	Prompt;
	return TRUE;
}

/*------------------------------------------------------------------------
  ------ KILL ------------------------------------------------------------
  ------------------------------------------------------------------------*/
#pragma argsused
int CMISC_kill(int StreamNum, int nParams, char **pArg, char **pStrArg)
{
	extern char STREAMS_level[MAX_STREAMS];
	extern char STREAMS_callsign[MAX_STREAMS][10];
	extern char STREAMS_level[MAX_STREAMS];

	/* Niveau d'utilisateur remote command */
	if( ! RCMD_isAllowed(StreamNum, RCMD_SYSOP) )
		return FALSE;


	/*RX only ?*/
	if( STREAMS_level[StreamNum] & LEVEL_user_RXonly )
		return FALSE;

	if( nParams != 2 )
	{
		if( nParams == 1 )
			MSG_send(StreamNum, MSG17);	/*Necessite 1 arg*/
		else
			MSG_send(StreamNum, MSG58);	/*Nbr d'arg incorrect*/
		Prompt;
		return TRUE;
	}

	MAIL_kill(StreamNum, atol (pArg[1]), STREAMS_callsign[StreamNum],
		STREAMS_level[StreamNum]);

	Prompt;
	return TRUE;
}

/*------------------------------------------------------------------------
  ------ LIST ------------------------------------------------------------
  ------------------------------------------------------------------------*/
#pragma argsused
int CMISC_list(int StreamNum, int nParams, char **pArg, char **pStrArg)
{
	extern char STREAMS_level[MAX_STREAMS];
	extern tUser    * pUser;
	unsigned long	dwFromNumber = 0L;
	unsigned long	dwToNumber   = 0L;
	unsigned long	dwLastListed;
	char *		pszPtr;

	/* Niveau d'utilisateur remote command */
	if( ! RCMD_isAllowed(StreamNum, RCMD_USER) )
		return FALSE;

	if( nParams > 2 )
	{
		MSG_send(StreamNum, MSG58);	/*Nbr d'arg incorrect*/
		Prompt;
		return TRUE;
	}

	if( nParams == 1 )
	{
		/*Pas d'arguments, lister les nouveaux messages*/
		USERS_getRecord(StreamNum);
		dwFromNumber   = pUser->lLastMsg + 1; /*Incrementer pour ne pas
					    relister dernier message liste*/
		dwToNumber     = 0L;
	}
	else
	{
		pszPtr = strchr(pArg[1], '-');
		if( pszPtr )
		{
			/*Lire le dernier message a lister*/
			dwToNumber   = atol (pszPtr+1);
			/*Lire le premier message a lister*/
			dwFromNumber = atol (pArg[1]);
		}

		if( dwFromNumber >= dwToNumber || dwToNumber == 0L )
		{
			/*Erreur dans les numeros de message*/
			MSG_send(StreamNum, MSG18);
			Prompt;
			return TRUE;
		}/*End IF*/
	}

	/*Lister les messages*/
	dwLastListed = MAIL_list(StreamNum, "", "", "", "", dwFromNumber,
		dwToNumber, STREAMS_level[StreamNum], 0L);

	/*Sauvegarder la config utilisateur*/
	if( dwToNumber == 0L ) /*Sauf si l'utilisateur a entre "L n1-n2"*/
	{
		if( dwLastListed )   /*Ca arrive lorsqu'il n'y avait pas de nouveau msg*/
		{
			pUser->lLastMsg = dwLastListed;
			/*Updater l'information user*/
			USERS_updateRecord(StreamNum);
		}
		else
		{
			/*Pas de nouveau message*/
			MSG_send(StreamNum, MSG53);
		}
	}
	else if( ! dwLastListed )
	{
		/*Aucun message a lister (si l'utilisateur a tape "L n1-n2")*/
		MSG_send(StreamNum, MSG54);
	}/*End IF*/

	Prompt;
	return TRUE;
}

/*------------------------------------------------------------------------
  ------ LL --------------------------------------------------------------
  ------------------------------------------------------------------------*/
#pragma argsused
int CMISC_ll(int StreamNum, int nParams, char **pArg, char **pStrArg)
{
	extern char STREAMS_level[MAX_STREAMS];
	unsigned long	dwLastMsg;
	unsigned long dwNtoList;
	unsigned long	dwArg;

	/* Niveau d'utilisateur remote command */
	if( ! RCMD_isAllowed(StreamNum, RCMD_USER) )
		return FALSE;

	if( nParams != 2 )
	{
		if( nParams == 1 )
			MSG_send(StreamNum, MSG17);
		else
			 MSG_send(StreamNum, MSG58);

		Prompt;
		return TRUE;
	}

	dwArg = atol (pArg[1]);

	if( dwArg == 0L )	/*Erreur dans l'argument*/
	{
		MSG_send(StreamNum, MSG18);
		Prompt;
		return TRUE;
	}

	dwLastMsg  = MAIL_lastNum() + 1L;

	/*Verifier qu'il n'y a pas depassement*/
	if( dwLastMsg > dwArg )
		dwNtoList = dwArg;
	else
		dwNtoList = dwLastMsg;

	/*Lister les messages*/
	MAIL_list(StreamNum, "", "", "", "", dwLastMsg,
		dwLastMsg, STREAMS_level[StreamNum], dwNtoList);

	Prompt;
	return TRUE;
}

/*------------------------------------------------------------------------
  ------ LM --------------------------------------------------------------
  ------------------------------------------------------------------------*/
#pragma argsused
int CMISC_lm(int StreamNum, int nParams, char **pArg, char **pStrArg)
{
	extern char STREAMS_level[MAX_STREAMS];
	extern char STREAMS_callsign[MAX_STREAMS][10];
	char	sUserCall[16];

	/* Niveau d'utilisateur remote command */
	if( ! RCMD_isAllowed(StreamNum, RCMD_USER) )
		return FALSE;

	if( nParams != 1 )
	{
		MSG_send(StreamNum, MSG58);
		Prompt;
		return TRUE;
	}

	strcpy(sUserCall, STREAMS_callsign[StreamNum]);
	TOOLS_removeSsid (sUserCall);

	/*Lister les messages*/
	if( ! MAIL_list(StreamNum, sUserCall, "", "", "", 0L, 0L,
		STREAMS_level[StreamNum], 0L) )
	MSG_send(StreamNum, MSG54);

	Prompt;
	return TRUE;
}

/*------------------------------------------------------------------------
  ------ LN --------------------------------------------------------------
  ------------------------------------------------------------------------*/
#pragma argsused
int CMISC_ln(int StreamNum, int nParams, char **pArg, char **pStrArg)
{
	extern char STREAMS_callsign[MAX_STREAMS][10];
	char	sUserCall[16];

	/* Niveau d'utilisateur remote command */
	if( ! RCMD_isAllowed(StreamNum, RCMD_USER) )
		return FALSE;

	if( nParams != 1 )
	{
		MSG_send(StreamNum, MSG58);
		Prompt;
		return TRUE;
	}

	strcpy(sUserCall, STREAMS_callsign[StreamNum]);
	TOOLS_removeSsid (sUserCall);

	/*Lister les messages*/
	if( ! MAIL_list(StreamNum, sUserCall, "", "", "", 0L, 0L, 0, 0L) )
		MSG_send(StreamNum, MSG54);

	Prompt;
	return TRUE;
}

/*------------------------------------------------------------------------
  ------ MEDIT -----------------------------------------------------------
  ------------------------------------------------------------------------*/
#pragma argsused
int CMISC_medit(int StreamNum, int nParams, char **pArg, char **pStrArg)
{
	extern char          STREAMS_level[MAX_STREAMS];
	extern unsigned long COMMANDS_statut[MAX_STREAMS];

	/* Niveau d'utilisateur remote command */
	if( ! RCMD_isAllowed(StreamNum, RCMD_NOTALLOWED) )
		return FALSE;

	/* Niveau d'utilisateur */
	if( ! (STREAMS_level[StreamNum] & LEVEL_sysopD) )
		return FALSE;

	if( nParams != 2 )
	{
		MSG_send(StreamNum, MSG17);	/* Necessite 1 arg */
		Prompt;
		return TRUE;
	}

	if( MEDIT_start(StreamNum, pArg[1]) )
		COMMANDS_statut[StreamNum] |= COMMANDS_statutMEdit;	/* OK */
	else
		Prompt;		/* Erreur */

	return TRUE;
}

/*------------------------------------------------------------------------
  ------ PURG ------------------------------------------------------------
  ------------------------------------------------------------------------*/
#pragma argsused
int CMISC_purge(int StreamNum, int nParams, char **pArg, char **pStrArg)
{
	extern char          STREAMS_level[MAX_STREAMS];
	extern char *MSG_pParams[10];
	int nLength = strlen(pArg[0]);

	/* Niveau d'utilisateur remote command */
	if( ! RCMD_isAllowed(StreamNum, RCMD_NOTALLOWED) )
		return FALSE;

	/* Niveau d'utilisateur */
	if( ! (STREAMS_level[StreamNum] & LEVEL_sysopV) )
		return FALSE;

	/* Mail */
	if( COMMANDS_check(pArg[0], "mail", nLength, 1) )
	{
		int nPersoDay = -1;
		int nBullDay  = -1;

		/* En cas d'erreur ... */
		MSG_pParams[9] = "PURG/MAIL d=30 b=30";

		for(int index = 1; index < nParams; index++)
		{
			strlwr(pArg[index]);

			if( ! strncmp(pArg[index], "p=", 2) )
			{
				if( nPersoDay == -1 )
				{
					nPersoDay = atoi(pArg[index] + 2);
					continue;
				}
			}

			if( ! strncmp(pArg[index], "b=", 2) )
			{
				if( nBullDay == -1 )
				{
					nBullDay = atoi(pArg[index] + 2);
					continue;
				}
			}

			MSG_pParams[8] = pArg[index];
			MSG_send(StreamNum, MSG74);
			return TRUE;
		}

		if( nPersoDay < 0 )
			nPersoDay = 30;
		if( nBullDay < 0 )
			nBullDay = 30;

		BUFFERS_printBuff(StreamNum, OUT,
			"PURG/MAIL d=%d b=%d\nPurging mail database in progress ...\n",
			nPersoDay,
			nBullDay);

		if( ! PURG_mail(StreamNum, nPersoDay, nBullDay) )
			BUFFERS_addBuff(StreamNum, "Fatal error : aborted\n", OUT);

		Prompt;
		return TRUE;
	}

	/* DX */
	if( COMMANDS_check(pArg[0], "dx", nLength, 1) )
	{
		int nDayLeft = 30;

		if( nParams > 2 )
		{
			MSG_send(StreamNum, MSG58);
			Prompt;
			return TRUE;
		}

		if( nParams == 2 )
		{
			nDayLeft = atoi(pArg[1]);

			if( nDayLeft == 0 )
			{
				MSG_send(StreamNum, MSG18);
				Prompt;
				return TRUE;
			}
		}


		BUFFERS_printBuff(StreamNum, OUT,
			"PURG/DX %d\nPurging DX database in progress ...\n",
			nDayLeft);

		if( ! PURG_dx(StreamNum, nDayLeft) )
			BUFFERS_addBuff(StreamNum, "Fatal error : aborted\n", OUT);

		Prompt;
		return TRUE;
	}

	/* Annonces */
	if( COMMANDS_check(pArg[0], "annonce", nLength, 1) )
	{
		int nDayLeft = 30;

		if( nParams > 2 )
		{
			MSG_send(StreamNum, MSG58);
			Prompt;
			return TRUE;
		}

		if( nParams == 2 )
		{
			nDayLeft = atoi(pArg[1]);

			if( nDayLeft == 0 )
			{
				MSG_send(StreamNum, MSG18);
				Prompt;
				return TRUE;
			}
		}


		BUFFERS_printBuff(StreamNum, OUT,
			"PURG/ANNOUNCE %d\nPurging announce database in progress ...\n",
			nDayLeft);

		if( ! PURG_announce(StreamNum, nDayLeft) )
			BUFFERS_addBuff(StreamNum, "Fatal error : aborted\n", OUT);

		Prompt;
		return TRUE;
	}

	/* WWV */
	if( COMMANDS_check(pArg[0], "wwv", nLength, 2) )
	{
		int nDayLeft = 30;

		if( nParams > 2 )
		{
			MSG_send(StreamNum, MSG58);
			Prompt;
			return TRUE;
		}

		if( nParams == 2 )
		{
			nDayLeft = atoi(pArg[1]);

			if( nDayLeft == 0 )
			{
				MSG_send(StreamNum, MSG18);
				Prompt;
				return TRUE;
			}
		}


		BUFFERS_printBuff(StreamNum, OUT,
			"PURG/WWV %d\nPurging WWV database in progress ...\n",
			nDayLeft);

		if( ! PURG_wwv(StreamNum, nDayLeft) )
			BUFFERS_addBuff(StreamNum, "Fatal error : aborted\n", OUT);

		Prompt;
		return TRUE;
	}

	/* WCY */
	if( COMMANDS_check(pArg[0], "wcy", nLength, 2) )
	{
		int nDayLeft = 30;

		if( nParams > 2 )
		{
			MSG_send(StreamNum, MSG58);
			Prompt;
			return TRUE;
		}

		if( nParams == 2 )
		{
			nDayLeft = atoi(pArg[1]);

			if( nDayLeft == 0 )
			{
				MSG_send(StreamNum, MSG18);
				Prompt;
				return TRUE;
			}
		}


		BUFFERS_printBuff(StreamNum, OUT,
			"PURG/WCY %d\nPurging WCY database in progress ...\n",
			nDayLeft);

		if( ! PURG_wcy(StreamNum, nDayLeft) )
			BUFFERS_addBuff(StreamNum, "Fatal error : aborted\n", OUT);

		Prompt;
		return TRUE;
	}

	/* Commande PURG/??? inconnue */
	return FALSE;
}


/*------------------------------------------------------------------------
  ------ PING --------------------------------------------------------------
  ------------------------------------------------------------------------*/
#pragma argsused
int CMISC_ping(int StreamNum, int nParams, char **pArg, char **pStrArg)
{
	extern char STREAMS_callsign[MAX_STREAMS][10];
	char	sNodeCall[16];
	char	sUserCall[16];
	extern char	STREAMS_level[MAX_STREAMS];

	/* Niveau d'utilisateur remote command */
	if( ! RCMD_isAllowed(StreamNum, RCMD_NOTALLOWED) )
		return FALSE;

	/* Rx only ? */
	if( STREAMS_level[StreamNum] & LEVEL_user_RXonly )
		return FALSE;

	if( nParams != 2 )
	{
		if( nParams == 1 )
			MSG_send(StreamNum, MSG17);
		else
			MSG_send(StreamNum, MSG58);
		Prompt;
		return TRUE;
	}

	/*Indicatif du call pinge, du cluster et de l'utilisateur ?*/
	TOOLS_maxLength(pArg[1], 9);
	strupr (pArg[1]);
	NODE_getNodeCall(0, 0, sNodeCall);
	strcpy(sUserCall, STREAMS_callsign[StreamNum]);

	if( ! TOOLS_isCall(pArg[1]) )
	{
		MSG_send(StreamNum, MSG18);
		Prompt;
		return TRUE;
	}

	/* Ne pas autoriser le auto-pings */
	if( ! strcmp(sNodeCall, pArg[1]) )
	{
		BUFFERS_addBuff(StreamNum, "*** Unable to ping to yourself ...\n", OUT);
		Prompt;
		return TRUE;
	}

	if( PROTOCOL_ping(0, sNodeCall, pArg[1], PROTOCOL_PING_ASK, 100) )
	{
		int iRetVal = PING_add(StreamNum, pArg[1], sUserCall);

		switch( iRetVal )
		{
		case PING_OK :
			BUFFERS_printBuff(StreamNum, OUT, "Ping %s ...\n", pArg[1]);
			break;

		case PING_DUPE :
			BUFFERS_printBuff(StreamNum, OUT, "*** Error : ping already in progress to %s.\nTry again later.\n", pArg[1]);
			break;

		case PING_FULL :
			BUFFERS_printBuff(StreamNum, OUT, "*** Error : too much pings already in progress.\nTry again later.\n");
			break;
		}/*End SWITCH*/
	}
	else
		BUFFERS_printBuff(StreamNum, OUT, "*** Error : %s is not a cluster or is not connected.\n", pArg[1]);

	Prompt;
	return TRUE;
}

/*------------------------------------------------------------------------
  ------ RCMD ------------------------------------------------------------
  ------------------------------------------------------------------------*/
#pragma argsused
int CMISC_rcmd(int StreamNum, int nParams, char **pArg, char **pStrArg)
{
	extern char	STREAMS_level[MAX_STREAMS];
	extern char 	STREAMS_callsign[MAX_STREAMS][10];

	char	szToPC[16];
	char	szFromPC[16];
	char  szFmUser[16];

	/* Niveau d'utilisateur remote command */
	if( ! RCMD_isAllowed(StreamNum, RCMD_NOTALLOWED) )
		return FALSE;

	/*Niveau d'utilisateur*/
	if( ! (STREAMS_level[StreamNum] & LEVEL_sysopV) )
		return FALSE;

	/* Verifier le nombre de parametres */
	if( nParams == 1 || pArg[0][0] == SNULL )
	{
		MSG_send(StreamNum, MSG58);
		Prompt;
		return TRUE;
	}

	/* Indicatif du serveur */
	NODE_getNodeCall(0, 0, szFromPC);

	/* Indicatif du correspondant */
	TOOLS_maxLength(pArg[0], 15);
	strcpy(szToPC, pArg[0]);
	strupr(szToPC);

	/* Executer la remote commands */
	strcpy(szFmUser, STREAMS_callsign[StreamNum]);
	if( ! PROTOCOL_rCmd(StreamNum, szFromPC, szToPC, szFmUser, pStrArg[1]) )
	{
		/* Cluster pas connecte */
		extern char *MSG_pParams[10];

		MSG_pParams[1] = szToPC;
		MSG_send(StreamNum, MSG19);
	}

	Prompt;
	return TRUE;
}

/*------------------------------------------------------------------------
  ------ QUIT (SERVEUR) --------------------------------------------------
  ------------------------------------------------------------------------*/
#pragma argsused
int CMISC_quit(int StreamNum, int nParams, char **pArg, char **pStrArg)
{
	if( StreamNum == 0 || StreamNum == 65 )
		exit (EXIT_SUCCESS);

	return FALSE;
}

/*------------------------------------------------------------------------
  ------ READ --------------------------------------------------------
  ------------------------------------------------------------------------*/
#pragma argsused
int CMISC_read(int StreamNum, int nParams, char **pArg, char **pStrArg)
{
	extern char STREAMS_level[MAX_STREAMS];
	extern char STREAMS_callsign[MAX_STREAMS][10];
	unsigned long	dwNumber;

	if( nParams != 2 )
	{
		if( nParams == 1 )
			MSG_send(StreamNum, MSG17);
		else
			MSG_send(StreamNum, MSG58);
		Prompt;
		return TRUE;
	}

	dwNumber = atol (pArg[1]);

	if( dwNumber == 0L )	/*Erreur dans l'argument*/
	{
		MSG_send(StreamNum, MSG18);
		Prompt;
		return TRUE;
	}

	MAIL_read(StreamNum, dwNumber, STREAMS_callsign[StreamNum],
		STREAMS_level[StreamNum]);

	Prompt;
	return TRUE;
}

/*------------------------------------------------------------------------
  ------ SEND ------------------------------------------------------------
  ------------------------------------------------------------------------*/
#pragma argsused
int CMISC_send(int StreamNum, int nParams, char **pArg, char **pStrArg, int iType)
{
	char szType[8];
	BYTE byRetReceipt;
	extern char	STREAMS_level[MAX_STREAMS];

	/* Niveau d'utilisateur remote command */
	if( ! RCMD_isAllowed(StreamNum, RCMD_NOTALLOWED) )
		return FALSE;

	if( nParams == 1 )
	{
		MSG_send(StreamNum, MSG58);
		Prompt;
		return TRUE;
	}

	/*Rx only ?*/
	if( STREAMS_level[StreamNum] & LEVEL_user_RXonly )
	{
		char szRecipient[256];

		strcpy (szRecipient, pArg[1]);
		strlwr (szRecipient);

		if( strcmp(szRecipient, "sysop") )
		{
			MSG_send(StreamNum, MSG59);
			return TRUE;
		}
	}

	/*Message perso ou buletin ?*/
	switch( iType )
	{
	case 1 :	/*Message PERSO*/
		strcpy(szType, "SP");
		break;

	case 2 :	/*Bulletin*/
		strcpy(szType, "SB");
		break;

	default :	/*On ne sait pas*/
		strcpy(szType, "S");
		break;
	}

	/*Faut il un demander un return receipt ?*/
	if( ! strcmp(pArg[0], "rr") )
		byRetReceipt = TRUE;
	else
		byRetReceipt = FALSE;

	if( MAIL_rcvRecip(StreamNum, szType, pStrArg[1], byRetReceipt, FALSE) )
	{
		extern unsigned long 	COMMANDS_statut[MAX_STREAMS];
		/*Le message a pu etre cree*/
		MSG_send(StreamNum, MSG45);
		COMMANDS_statut[StreamNum] |= COMMANDS_statutRcvMail;
		COMMANDS_statut[StreamNum] |= COMMANDS_statutWaitTitle;
	}
	else
	{
		/*Erreur quelconque ...*/
		BUFFERS_addBuff(StreamNum, "*** System error : contact the sysop.\n", OUT);
	}/*End IF*/

	return TRUE;
}

/*------------------------------------------------------------------------
  ------ SHUTdown --------------------------------------------------------
  ------------------------------------------------------------------------*/
#pragma argsused
int CMISC_shutdown(int StreamNum, int nParams, char **pArg, char **pStrArg)
{
	extern int 	FirstStream;	/*switch.cpp*/
	extern int 	LastStream;	/*switch.cpp*/
	extern unsigned long 	COMMANDS_statut[MAX_STREAMS];
	int index;

	/*Niveau d'utilisateur - commande console UNIQUEMENT*/
	if( StreamNum != 0 && StreamNum != 65 )
		return FALSE;

	/*Annoncer au serveur qu'un shutdown est demande*/
	COMMANDS_statut[0] = COMMANDS_statutShutDown;

	/*Indiquer sur la console que le shutdown est en cours*/
	BUFFERS_addBuff(StreamNum, "Shutdown in progress ...\n", OUT);

	/*Envoyer un message aux utilisateurs connectes*/
	if( pStrArg[1] == NULL )
	{
		USERS_sendAll("Cluster shutdown...\nYou are going to be disconnected.\n",
		PROTOCOL_EXIT, USERS_EXCEPTCONSOLE, -1);
	}
	else
		USERS_sendAll(pStrArg[1], USERS_EXCEPTCONSOLE, PROTOCOL_EXIT, -1);

	/*Demander une deconnection sur tous les streams*/
	for(index = FirstStream; index <= LastStream; index++)
		COMMANDS_statut[index] = COMMANDS_statutDisconnect;

	/*Ne plus autoriser de connexion*/
	SWITCH_bpqSetup(0, 0x00, 0x00);

	Prompt;
	return TRUE;
}

/*------------------------------------------------------------------------
  ------ SYSOP -----------------------------------------------------------
  ------------------------------------------------------------------------*/
#pragma argsused
int CMISC_sysop(int StreamNum, int nParams, char **pArg, char **pStrArg)
{
	extern char STREAMS_level[MAX_STREAMS];
	extern char STREAMS_callsign[MAX_STREAMS][10];
	extern unsigned long 	COMMANDS_statut[MAX_STREAMS];
	char sUserCall[16];

	/* Niveau d'utilisateur remote command */
	if( ! RCMD_isAllowed(StreamNum, RCMD_NOTALLOWED) )
		return FALSE;

	if( ! (STREAMS_level[StreamNum] & LEVEL_sysopD) )
		return FALSE;

	if( nParams != 1 )
	{
		MSG_send(StreamNum, MSG58);
		Prompt;
		return TRUE;
	}

	/*Indicatif de l'utilisateur ?*/
	strcpy(sUserCall, STREAMS_callsign[StreamNum]);

	/*Envoyer la clef*/
	if( PASSWORD_sendKey(StreamNum, sUserCall) )
		COMMANDS_statut[StreamNum] |= COMMANDS_statutWaitPassword;
	else
		BUFFERS_addBuff(StreamNum, "*** Error : password file not found.\n", OUT);

	 return TRUE;
}

/*------------------------------------------------------------------------
  ------ TALK ------------------------------------------------------------
  ------------------------------------------------------------------------*/
#pragma argsused
int CMISC_talk(int StreamNum, int nParams, char **pArg, char **pStrArg)
{
	char sToCluster[16];
	char *pString;
	extern char	STREAMS_level[MAX_STREAMS];

	/* Niveau d'utilisateur remote command */
	if( ! RCMD_isAllowed(StreamNum, RCMD_NOTALLOWED) )
		return FALSE;

	/*Rx only ?*/
	if( STREAMS_level[StreamNum] & LEVEL_user_RXonly )
		return FALSE;

	if( nParams == 1 )
	{
		MSG_send(StreamNum, MSG58);
		Prompt;
		return TRUE;
	}

	/*Verifier que le TALK est bien adresse a un indicatif*/
	strupr (pArg[1]);
	if( ! TOOLS_isCall (pArg[1]) )
	{
		MSG_send(StreamNum, MSG18);
		Prompt;
		return TRUE;
	}

	/*Si le cluster du destinataire est precise*/
	if( ! strcmp(pArg[2], ">") /*&& TOOLS_isCall (pArg[3])*/ )
	{
		TOOLS_maxLength(pArg[3], 9);	/*Limiter la longueur*/
		strcpy (sToCluster, strupr (pArg[3]));
		strupr (sToCluster);
		pString = pStrArg[4];               /*Texte adresse au destinataire*/
	}
	else
	{
		strcpy(sToCluster, "");
		pString = pStrArg[2];		/*Texte adresse au destinataire*/
	}/*End IF*/

	/*Verifier que le cluster (s'il a ete indique) du destinataire est connecte*/
	if( *sToCluster && ! NODE_isNodeConnected (sToCluster) )
	{
		/*N'est pas connecte*/
		extern char    *MSG_pParams[10];

		MSG_pParams[1] = sToCluster;
		MSG_send(StreamNum, MSG19);
	}
	else
	{
		extern char STREAMS_callsign[MAX_STREAMS][10];
		char sUserCall[16];
		char sNodeCall[16];

		/*Indicatif du cluster, de l'utilisateur et du destinataire*/
		NODE_getNodeCall(0, 0, sNodeCall);
		strcpy(sUserCall, STREAMS_callsign[StreamNum]);
		TOOLS_maxLength(pArg[1], 9);

		/*Ne pas autoriser les auto-talks*/
		if( ! strcmp(sUserCall, pArg[1]) )
		{
			BUFFERS_addBuff(StreamNum,
				"*** self talk not allowed.\n", OUT);
			Prompt;
			return TRUE;
		}

		/*Talk d'une ligne, ou mode talk ?*/
		if( pString == NULL )
		{
			/*Mode TALK*/
			extern unsigned long 	COMMANDS_statut[MAX_STREAMS];
			char	sBuffer[256];

			MSG_get(StreamNum, MSG25, sBuffer);	/*Avertir le destinataire*/
			TOOLS_removeNR (sBuffer);
			pString = sBuffer;			/*Ce qu'il faudra adresser immediatement*/

			/*Transmettre au destinataire*/
			if( PROTOCOL_sendTalk(0, sNodeCall, sUserCall, sToCluster, pArg[1],
				pString, PROTOCOL_TALK_BELL,
				TOOLS_whatDateTime(), 100) )
			{
				/*Destinataire trouve : valider le mode talk*/
				extern tUserCfg * pUserCfg;

				MSG_send(StreamNum, MSG24);		/*Pour l'expediteur*/

				/*Mmoriser le call du destinataire et eventuellement celui de son cluster*/
				USERS_getRecord (StreamNum);
				strcpy(pUserCfg->sTalkToNode, sToCluster);
				strcpy(pUserCfg->sTalkToUser, pArg[1]);
				USERS_updateLocalConfig (StreamNum);

				/*Valider le mode TALK*/
				COMMANDS_statut[StreamNum] |= COMMANDS_statutTalkMode;
			}
			else
			{
				/*L'utilisateur n'a pas ete trouve*/
				MSG_send(StreamNum, MSG23);
			}/*End IF*/
		}
		else
		{
			/*TALK d'une ligne*/
			if( ! PROTOCOL_sendTalk(0, sNodeCall, sUserCall, sToCluster, pArg[1],
			      pString, PROTOCOL_TALK_BELL,
			      TOOLS_whatDateTime(), 100) )
			MSG_send(StreamNum, MSG23);	/*L'utilisateur n'a pas ete trouve*/
		}/*End IF*/
	}

	Prompt;
	return TRUE;
}

/*------------------------------------------------------------------------
  ------ WWV -------------------------------------------------------------
  ------------------------------------------------------------------------*/
#pragma argsused
int CMISC_wwv(int StreamNum, int nParams, char **pArg, char **pStrArg)
{
	extern char STREAMS_callsign[MAX_STREAMS][10];
	extern char	STREAMS_level[MAX_STREAMS];

	/* Niveau d'utilisateur remote command */
	if( ! RCMD_isAllowed(StreamNum, RCMD_NOTALLOWED) )
		return FALSE;

	/*Rx only ?*/
	if( STREAMS_level[StreamNum] & LEVEL_user_RXonly )
		return FALSE;

	char  sTime[8];
	char  sDate[16];
	char	sNodeCall[16];
	char	sUserCall[16];
	int	index;
	int	iSFI = -1;	/*-1 indique que la variable n'a pas ete mise a jour*/
	int 	iA   = -1;
	int 	iK   = -1;

	if( nParams < 5 )	/*Six parametres sont attendus*/
	{
		MSG_send(StreamNum, MSG43);
		Prompt;
		return TRUE;
	}

	/* lecture de SF, A, et K */
	for(index = 1; index < 4; index++)
	{
		strlwr (pArg[index]);

		if( ! strncmp (pArg[index], "sfi=", 4) )
			iSFI = atoi (pArg[index] + 4 );
		else if( ! strncmp (pArg[index], "a=",   2) )
			iA   = atoi (pArg[index] + 2 );
		else if( ! strncmp (pArg[index], "k=",   2) )
			iK   = atoi (pArg[index] + 2 );
	}/*End FOR*/

	/*Verifier que les valeurs sont OK*/
	if( iSFI < 0 || iSFI > 500 ||
	    iA   < 0 || iA   > 400 ||
	    iK   < 0 || iK   >   9 )
	{
		/*Erreur ...*/
		MSG_send(StreamNum, MSG43);
		Prompt;
		return TRUE;
	}

	/*Indicatifs du cluster et de l'utilisateur*/
	NODE_getNodeCall(0, 0, sNodeCall);
	strcpy(sUserCall, STREAMS_callsign[StreamNum]);

	/*L'utilisateur a peut-etre demande a ce qu'un indicatif special
	  soit utilise en tant que logger*/
	if( *pArg[0] )
	{
		strupr (pArg[0]);

		if( ! TOOLS_isCall (pArg[0]) )
		{
			extern char    *MSG_pParams[10];

			MSG_pParams[1] = pArg[0];
			MSG_send(StreamNum, MSG18);
			Prompt;
			return TRUE;
		}

		TOOLS_maxLength(pArg[0], 9);
		strcpy(sUserCall, pArg[0]);
	}

	TOOLS_removeSsid (sUserCall);

	/*Date et Heure*/
	TOOLS_whatDate(sDate);
	TOOLS_whatTime(sTime);

	/*Transmettre le spot WWV*/
	PROTOCOL_sendWwv(StreamNum, sNodeCall, sUserCall, iSFI, iA, iK, sDate,
		sTime, pStrArg[4], 100);

	Prompt;
	 return TRUE;
}
