#define MAX_BUFFER 	65 	//nombre de cannaux actifs (64 pour BPQ + 1 pour la console)
#ifdef WIN32
 #ifdef IN
 #undef IN
 #endif
 #ifdef OUT
 #undef OUT
 #endif
#endif
#define IN  0	/* Buffer IN */
#define OUT 1	/* Buffer OUT */

#include "define.h"

#define BUFFER_SCREEN1	0
#define BUFFER_SCREEN2	65

//------ Declarations ------------------------------------------------------
typedef struct 
{
  char far *   pBuffer[2]; /* Deux buffers sont ouverts (IN et OUT) */
  unsigned int nSize[2];
  BYTE         byPageCount;
} CHANNEL;

//------ Prototypes --------------------------------------------------------
void	BUFFERS_init(void);
int 	BUFFERS_openBuff(int StreamNum, char * String, int Direction, int StrSize);
int 	BUFFERS_addBuff(int StreamNum, char * String, int Direction);
int 	BUFFERS_getRow(int StreamNum, char * String, int Direction);
int 	BUFFERS_getBloc(int StreamNum, char * String, int Direction);
int 	BUFFERS_printBuff(int StreamNum, int Direction, char * String, ...);
int 	BUFFERS_addBuff_sized(int StreamNum, char * String, int Direction, int StrSize);
void	BUFFERS_close(int StreamNum);

void 	BUFFERS_addTemp(int StreamNum, char * String, int Size);
int 	BUFFERS_getTemp(int StreamNum, char * String, int MaxSize);
void 	BUFFERS_killTemp(int StreamNum);
int 	BUFFERS_saveTemp(int StreamNum);
void 	BUFFERS_empty(int StreamNum, int nDirection);

