#include <alloc.h>
#include <stdio.h>
#include <string.h>
#include "define.h"
#include "tools.h"
#include "announce.h"

//--------------------------------------------------------------------------
//------ Ajouter une annonce dans le fichier d'annonce ---------------------
//--------------------------------------------------------------------------
void ANNOUNCE_add(char * FromNode, char * ToWho, char * FromUser, char Flag, char * String, unsigned long DateTime)
{
  FILE * fPtr;
  ANNOUNCE Announce;

  //Ouvrir le fichier et placer la nouvelle annonce  la fin
  fPtr = fopen(ANNOUNCE_FILE, "a+b");

  if( ! fPtr )	//Le fichier n'a pas pu tre ouvert
  {
    perror("fopen in ANNOUNCE_add");
    return;
  }/*End IF*/

  //Limiter la longueur des champs
  TOOLS_maxLength(ToWho, 20);
  TOOLS_maxLength(String, 255);

  //Prparer les champs de l'enregistrement
  memset(&Announce, 0, sizeof(Announce));	//Pour rendre le fichier plus clean
  strcpy(Announce.sFromNode, FromNode);
  strcpy(Announce.sToWho,    ToWho);
  strcpy(Announce.sFromUser, FromUser);
  strcpy(Announce.sString,  String);
  Announce.cFlag     = Flag;
  Announce.lDateTime = DateTime;

  //Enregistrer l'annonce  la fin du fichier
  fwrite(&Announce, sizeof(Announce), 1, fPtr);

  fclose(fPtr);
}

//--------------------------------------------------------------------------
//------ Charger une annonce du fichier annonce ----------------------------
//--------------------------------------------------------------------------
//La fonction returne TRUE si l'annonce  pu tre lue
int ANNOUNCE_get(int Pos, char * FromNode, char * ToWho, char * FromUser, char * Flag, char * String, unsigned long * DateTime)
{
  FILE *fPtr;
  long	lOffset;
  ANNOUNCE Announce;

  //Ouvrir le fichier
  fPtr = fopen(ANNOUNCE_FILE, "rb");

  if( ! fPtr )	//Le fichier n'a pas pu tre ouvert
    return FALSE;

  //Se placer  la fin du fichier
  fseek(fPtr, 0L, SEEK_END);

  //Remonter de Pos enregistrements
  lOffset = (long) Pos * (long) sizeof(Announce);
  if( lOffset > ftell(fPtr) )
  {
    fclose( fPtr );
    return FALSE;
  }
  fseek(fPtr, -lOffset, SEEK_CUR);

  //Extraire les champs
  fread(&Announce, sizeof(Announce), 1, fPtr);

  //Passer les champs aux variables
  strcpy(FromNode, Announce.sFromNode);
  strcpy(ToWho,    Announce.sToWho);
  strcpy(FromUser, Announce.sFromUser);
  strcpy(String,   Announce.sString);
  *Flag     = Announce.cFlag;
  *DateTime = Announce.lDateTime;

  //Fermer le fichier et retourner
  fclose(fPtr);
  return TRUE;
}

/*---------------------------------------------------------------------------
  ------ Rechercher si l'annonce est un double ------------------------------
  ---------------------------------------------------------------------------
  La fonction retourne TRUE si l'annonce est double */
int ANNOUNCE_isDupe(char * FromNode, char * ToWho, char * FromUser, char * String, unsigned long DateTime)
{
	#define	NLAST	4000L

	extern long PARAMS_lAnnDupeAllowed;

	FILE   *fPtr;
	long	lOffset;
	long	lFileSize;
	int	index;
	char	szLogger[16];
	char 	szBuffer1[256];
	char	szBuffer2[256];
	ANNOUNCE Announce;
	/* Recherche de DUPE a effectuer qqs le SSID du logger */
	strcpy(szLogger, FromUser);
	TOOLS_removeSsid(szLogger);

	/* Ouvrir le fichier */
	fPtr = fopen(ANNOUNCE_FILE, "rb");

	if( ! fPtr )	/* Impossible d'ouvrir */
	{
		perror("fopen in ANNOUNCE_isDupe");
		return FALSE;
	}

	/* Placer le pointeur de fichier NLAST spots en arriere */
	fseek(fPtr, 0L, SEEK_END);			/* Fin du fichier */
	lFileSize = ftell(fPtr);

	/* Tester chacune des annonces */
	TOOLS_removeNonAscii(String, szBuffer1);
	for(index = 1; index < NLAST; index++)
	{
		/* Positionner le pointeur de fichier */
		lOffset = (long) index * sizeof(Announce);
		if( lOffset > lFileSize )
			break;
		fseek(fPtr, -lOffset, SEEK_END);

		/* Lecture enregistrement */
		if( ! fread(&Announce, sizeof(Announce), 1, fPtr) )
			break;	/* EOF */

		/* Temps max de recherche depasse ? ... */
		if( TOOLS_diffDateTime(DateTime, Announce.lDateTime) >= (double) PARAMS_lAnnDupeAllowed )
			break;

		/* Comparer ... */
		TOOLS_removeNonAscii(Announce.sString, szBuffer2);
		TOOLS_removeSsid(Announce.sFromUser);	/* Qqs le SSID du logger */
		if( ! strcmp(FromNode, Announce.sFromNode) &&
		    ! strcmp(ToWho, Announce.sToWho)       &&
		    ! strcmp(szLogger, Announce.sFromUser) &&
		    ! strcmp(szBuffer1, szBuffer2) )
		{
			fclose(fPtr);
			return TRUE;
		}

	}/* End FOR */

	/* Fermer le fichier et retourner */
	fclose( fPtr );
	return FALSE;
}