#include <dos.h>
#include <string.h>
#include <stdlib.h>
#include <stdio.h>
#include <ctype.h>
#include <windows.h>
#include "define.h"
#include "flexappl.h"
#include "switch.h"
#include "symbol.h"
#include "tools.h"
#include "buffers.h"
#include "agw.h"
#include "fbbsrv.h"
#include "protocol.h"
#include "telnet.h"
#include "password.h"

//---------------------------------------------------------------------------
//------ Variables globales -------------------------------------------------
//---------------------------------------------------------------------------
int FirstStream =   1;
int LastStream  =	64;
extern QSO AGW_qso[65];
char   SWITCH_szMyCall[20] = "NOCALL";

static SOCKET SWITCH_telnetSock = NULL;
static char *TelnetInit = "\377\374\001\000Telnet Initialisation string";
static char *Hello = "%s\r%s DxNet. TELNET access\r\r%s";
static char *Callsign = "Callsign : ";
static char *Password = "Password : ";
static char *Logon = "\rLogon Ok\r\r";
static char *FirstConnection = "\r\rThis is your first connection to this DxCluster.\rPlease choose a password.\r\r";

/* Prototypes des fonctions statiques */
static int  SWITCH_acceptTelnetConnection();
static void SWITCH_readTelnet(int StreamNum);
static void SWITCH_telnetConnect(int StreamNum, char* pszToString);
static int  SWITCH_telnetCheck(int StreamNum, char *buffer, int ilen);

/*--------------------------------------------------------------------------
  ------ Initialiser le SWITCH packet --------------------------------------
  --------------------------------------------------------------------------
  Retourne TRUE si AGW pe est present
*/
int SWITCH_initSwitch(int _FirstStream, int _LastStream, int ApplMask)
{
	WORD    wVersionRequested = 2;
	WSADATA wsaData;
	int     nRet;

	/* start winsock library */
	nRet = WSAStartup(wVersionRequested, &wsaData);
	if (nRet)
	{
		OutputDebugString("NO WINSOCK LIBRARY!\n");
		WSACleanup();
		return FALSE;
	}

	/* Check WinSock version */
	if (wsaData.wVersion != wVersionRequested)
	{
		OutputDebugString("WinSock version not supported");
		WSACleanup();
		return FALSE;
	}

	return TRUE;
}

/*--------------------------------------------------------------------------
  ------ wait - waits until an event or timeout ----------------------------
  --------------------------------------------------------------------------
*/
int SWITCH_wait(int delay)
{
	extern SOCKET AGW_socket;
	extern orb_fd;
	extern OrbClient * client_head;
	TIMEVAL timeout;
	int ret;
	OrbClient * sptr;
	int index;

	fd_set sock_read;
	fd_set sock_excp;

	FD_ZERO(&sock_read);
	FD_ZERO(&sock_excp);

	if( AGW_socket != NULL )
	{
		FD_SET(AGW_socket, &sock_read);
		FD_SET(AGW_socket, &sock_excp);
	}

	/* Clients console */
	if( orb_fd >= 0 )
	{
		FD_SET (orb_fd, &sock_read);
		sptr = client_head;
		while (sptr)
		{
			FD_SET(sptr->fd, &sock_read);
			sptr = sptr->next;
		}
	}

	if( SWITCH_telnetSock != NULL )
	{
		FD_SET(SWITCH_telnetSock, &sock_read);
		FD_SET(SWITCH_telnetSock, &sock_excp);
		for(index = 1; index <= 64; index++)
		{
			if( AGW_qso[index].nFlags & AGW_TELNET )
				FD_SET(AGW_qso[index].nTelnetSocket, &sock_read);
		}

	}

	/* attendre un evenement */
	timeout.tv_usec = 0;
	timeout.tv_sec  = 1;
	ret = select(0, &sock_read, NULL, &sock_excp, &timeout);

	/* gestion des erreur */
	if( ret == SOCKET_ERROR )
	{
		OutputDebugString("SOCKET ERROR in SWITCH_wait : select\n");
	}

	if( ret == 0 )
		return 0;

	if( AGW_socket != NULL )
	{
		if( FD_ISSET(AGW_socket, &sock_read) )
			AGW_readEvent();

		if( FD_ISSET(AGW_socket, &sock_excp) )
			OutputDebugString("AGW PE socket exception\n"); 
	}

	if (FD_ISSET (orb_fd, &sock_read))
	{
		/* Nouvelle connection client */
		FBBSRV_orb_new_connection (orb_fd);
	}

	sptr = client_head;
	while (sptr)
	{
		/* On sauvegarde le next car le pointeur de client peut etre
		   libere pendant le traitement en cas de deconnexion */
		OrbClient *ptemp = sptr->next;

		if (FD_ISSET (sptr->fd, &sock_read))
		{
			FBBSRV_orb_process_data (sptr);
		}
		sptr = ptemp;
	}

	/* Nouvelle connexion telnet ? */
	if( SWITCH_telnetSock != NULL )
	{
		if( FD_ISSET(SWITCH_telnetSock, &sock_read) )
			SWITCH_acceptTelnetConnection();
		if( FD_ISSET(SWITCH_telnetSock, &sock_excp) )
		{
			closesocket(SWITCH_telnetSock);
			SWITCH_telnetSock = NULL;
			OutputDebugString("TELNET socket exception\n"); 
		}

		for(index = 1; index <= 64; index++)
		{
			if( AGW_qso[index].nFlags & AGW_TELNET && FD_ISSET(AGW_qso[index].nTelnetSocket, &sock_read) )
				SWITCH_readTelnet(index);
		}
	}

	return ret;
}

/*--------------------------------------------------------------------------
  ------ Parametrer le numero du port telnet -------------------------------
  --------------------------------------------------------------------------
*/
void SWITCH_addPort(char * pszPort)
{
	int   val;
	int   tcp_port;
	char* p_name;
	int   addrlen;
	struct sockaddr_in SockAddrInet;

	strlwr(pszPort);

	if( strncmp(pszPort, "inet:", 5) )
		return;

	if( (SWITCH_telnetSock = socket(AF_INET, SOCK_STREAM, 0)) == SOCKET_ERROR )
	{
		perror ("socket");
		return;
	}

	val = 1;
	addrlen = sizeof (val);
	if( (setsockopt(SWITCH_telnetSock, SOL_SOCKET, SO_REUSEADDR, (char *) &val, addrlen)) == SOCKET_ERROR )
	{
		perror ("opn_tcp : setsockopt SO_REUSEADDR");
	}

	p_name = strrchr(pszPort, ':');
	if( p_name )
		tcp_port = atoi( p_name + 1);
	else
		tcp_port = 23;

	SockAddrInet.sin_family = AF_INET;
	SockAddrInet.sin_port = htons(tcp_port);
	SockAddrInet.sin_addr.S_un.S_addr = 0;

	addrlen = sizeof (struct sockaddr_in);

	if( bind(SWITCH_telnetSock, (struct sockaddr *) &SockAddrInet, addrlen) == SOCKET_ERROR )
	{
		perror ("bind");
		closesocket(SWITCH_telnetSock);
		return;
	}

	if( listen(SWITCH_telnetSock, SOMAXCONN) == SOCKET_ERROR )
	{
		perror ("listen");
		closesocket(SWITCH_telnetSock);
		return;
	}
}

//---------------------------------------------------------------------------
//------ Initialiser BPQ (si ncessaire) ------------------------------------
//---------------------------------------------------------------------------
void SWITCH_bpqSetup(int Mask, int Flag1, int Flag2)
{
 
}

//---------------------------------------------------------------------------
//------ Initialise les masques et flags d'application ----------------------
//---------------------------------------------------------------------------
void SWITCH_bpqSetAppl(int StreamNum, int Mask, int Flag)
{

}

//--------------------------------------------------------------------------
//------ class g8bpq - get_statut ------------------------------------------
//--------------------------------------------------------------------------
//Retourne l'etat du canal : NONE pas de changement
//                           1 connection
//                           2 deconnection
//et initialise l'ack de test de statut (#5) pour G8BPQ
int SWITCH_getStatut(int StreamNum)
{

	if( AGW_qso[StreamNum].nFlags & AGW_NEW_INCOMING_CONNECTION )
	{
		AGW_qso[StreamNum].nFlags &= ~AGW_NEW_INCOMING_CONNECTION;
		return 1;
	}
	else if( AGW_qso[StreamNum].nFlags & AGW_NEW_INCOMING_DISCONNECT )
	{
		ZeroMemory(&AGW_qso[StreamNum], sizeof QSO);
		return 2;
	}

	return NONE;
}

//--------------------------------------------------------------------------
//------ ack_statut - A appeler aprs chaque appel de int 5 ----------------
//--------------------------------------------------------------------------
//Cette fonction est utilisee par SWITCH_getStat()
void SWITCH_ackStatut(int StreamNum)
{
 
}

//--------------------------------------------------------------------------
//------ get_frame ---------------------------------------------------------
//--------------------------------------------------------------------------
//Lit et retourne dans buffer le contenu du cannal StreamNum
//La fonction retourne la longueur de la chaine
int SWITCH_getFrame(int StreamNum, char * buffer)
{
	/* Inexploite dans la version windows */
	return 0;
}

//--------------------------------------------------------------------------
//------ send_frame --------------------------------------------------------
//--------------------------------------------------------------------------
//Transmet le contenu de buffer dans le cannal StreamNum
void SWITCH_sendFrame(int StreamNum, char * buffer, int Size)
{
	if( AGW_qso[StreamNum].nFlags & AGW_TELNET )
	{
		extern char PROTOCOL_linkType[65];
		char *buf = (char *) malloc (Size * 2);
		char *pbuf = buf;
		int   i, ilen;

		/* transforme cr -> crlf ... Pas de binaire ! */
		/* Modif F5MZN Nov 8, 2000 : sauf en mode
		   clulink ou la on ne touche a rien ! */
		if( PROTOCOL_linkType[StreamNum] != CLU_LINK )	
		{
			for (i = 0, ilen = 0; i < Size; i++, ilen++)
			{
				*pbuf++ = *buffer;
				if (*buffer == '\r')
				{
					*pbuf++ = '\n';
					++ilen;
				}
				++buffer;
			}
		}
		send(AGW_qso[StreamNum].nTelnetSocket, buf, ilen, 0);
		free(buf);
	}
	else
		AGW_sendFrame(StreamNum, buffer, Size);
}

//--------------------------------------------------------------------------
//------ get_call ----------------------------------------------------------
//--------------------------------------------------------------------------
//Retourne dans call_sign l'indicatif connecte au cannal streamnum
void SWITCH_getCall(int StreamNum, char* pszCallSign)
{
	if( StreamNum == 0 )
		strcpy(pszCallSign, SWITCH_szMyCall);
	else if( StreamNum < 0 || StreamNum > 64)
		return;

	strcpy(pszCallSign, AGW_qso[StreamNum].szCallSign);
}

//--------------------------------------------------------------------------
//------ con_state - Le stream est-il connect ? ---------------------------
//--------------------------------------------------------------------------
//Retourne 1 si le stream est connect
int SWITCH_conStat(int StreamNum)
{
	if( AGW_qso[StreamNum].szCallSign[0] && ! (AGW_qso[StreamNum].nFlags & AGW_TRY_TO_CONNECT) )
		return 1;
	else
		return 0;
}

//--------------------------------------------------------------------------
//------ con_switch - Connecte le stream au switch -------------------------
//--------------------------------------------------------------------------
void SWITCH_conSwitch(int StreamNum)
{
 
}

//--------------------------------------------------------------------------
//------ disc_switch - Deconnecte le stream du switch ----------------------
//--------------------------------------------------------------------------
void SWITCH_discSwitch(int StreamNum)
{
	if( AGW_qso[StreamNum].nFlags & AGW_TELNET )
	{
		AGW_qso[StreamNum].nFlags |= AGW_DISCONNECTED;
		closesocket(AGW_qso[StreamNum].nTelnetSocket);
	}
	else
		AGW_disconnect(StreamNum);
}

//--------------------------------------------------------------------------
//------ add_callsign ------------------------------------------------------
//--------------------------------------------------------------------------
void SWITCH_addCall(int start, char * buffer, char * string)
{

}

//---------------------------------------------------------------------------
//------ IsAllowed ----------------------------------------------------------
//---------------------------------------------------------------------------
int SWITCH_isAllowed(int StreamNum)
{
	return TRUE;
}

//--------------------------------------------------------------------------
//------ Monitoring --------------------------------------------------------
//--------------------------------------------------------------------------
//Monitoring
int SWITCH_rawRx(int streamnum, char * pszBuffer)
{
	return 0;
}

//---------------------------------------------------------------------------
//------ Is PcFlex ----------------------------------------------------------
//---------------------------------------------------------------------------
int SWITCH_isPcFlexNet(void)
{
	return TRUE;
}

//---------------------------------------------------------------------------
//------ SetMyCall ----------------------------------------------------------
//---------------------------------------------------------------------------
void SWITCH_setMyCall(char * pszCallSign)
{
	strcpy(SWITCH_szMyCall, pszCallSign);
	AGW_registerCallSign(pszCallSign);
}

//--------------------------------------------------------------------------
//------ Connecter un indicatif via PcFlexNet ------------------------------
//--------------------------------------------------------------------------
//Retourne TRUE si le switch est un PcFlexNet
int SWITCH_connectFlex(int StreamNum, char * pszToCall)
{
	if( ! strnicmp(pszToCall, "inet", 4) )
		SWITCH_telnetConnect(StreamNum, pszToCall);
	else
		AGW_connect(StreamNum, pszToCall);

	return TRUE;
}

//--------------------------------------------------------------------------
//------ Connecter un indicatif via PcFlexNet ------------------------------
//--------------------------------------------------------------------------
//Retourne TRUE si le switch est un PcFlexNet
int SWITCH_connectFlex(int streamnum, char * pszFromCall, char * pszToCall)
{
	return 0;
}

//--------------------------------------------------------------------------
//------ Retourne le nombre de trames qui n'ont pas encore t ACKed -------
//--------------------------------------------------------------------------
int SWITCH_getUnack(int StreamNum)
{
	if( AGW_qso[StreamNum].nFlags & AGW_TELNET )
		return 0;

	/* une demande de UNACK est elle deja en cours ? */
	if( AGW_qso[StreamNum].nFlags & AGW_UNACK_REQUEST )
	{
		/* OUI : peut-on deconnecter ? */
		if( AGW_qso[StreamNum].nFlags & AGW_OK_TO_DISCONNECT )
			return 0;
	}
	else
	{
		/* NON : effectuer une demande */
		AGW_qso[StreamNum].nFlags |= AGW_UNACK_REQUEST;		
	}
	
	AGW_getOutstandingFrameOnStream(StreamNum);
	return 1;
}

//--------------------------------------------------------------------------
//------ Retourne le nombre de buffer dispos dans le switch BPQ ------------
//--------------------------------------------------------------------------
int SWITCH_getBufferLeft()
{
	return 0;
}

//--------------------------------------------------------------------------
//------ Quitter le kernel PcFlex ------------------------------------------
//--------------------------------------------------------------------------
void SWITCH_exitPcFlex(void)
{
}

/*-----------------------------------------------------------------------------------------
  ------ Accepte une connection telnet ----------------------------------------------------
  -----------------------------------------------------------------------------------------
  Retourne TRUE si OK et FALSE sinon
*/
static int SWITCH_acceptTelnetConnection()
{
	int index;
	int addr_len;
	struct sockaddr_in sock_addr;

	/* Chercher le premier stream libre */
	for(index = 1; index <= 64; index++)
	{
		if( AGW_qso[index].szCallSign[0] == '\0' )
			break;
	}
	if( index == 65 )
		return FALSE;

	addr_len = sizeof sock_addr;
	AGW_qso[index].nTelnetSocket  = accept(SWITCH_telnetSock, (struct sockaddr *) &sock_addr, &addr_len);
	AGW_qso[index].nTelnetState   = WAITCALL;
	AGW_qso[index].nFlags         = AGW_TELNET;
	AGW_qso[index].nPasswdFailure = 3;
	strcpy(AGW_qso[index].szCallSign, "NOCALL");
	BUFFERS_printBuff(index, OUT, Hello, TelnetInit, SWITCH_szMyCall, Callsign);

	return TRUE;
}

static void SWITCH_readTelnet(int StreamNum)
{
	extern char PROTOCOL_linkType[65];
	int i;
	int ilen;
	char buffer[4096];
	char *pbuf = buffer;
	char szBuffer[256];
	int  nb;

	nb = recv(AGW_qso[StreamNum].nTelnetSocket, buffer, 4095, NULL);
	if( nb <= 0 )
	{
#ifdef _DEBUG
		if( nb == SOCKET_ERROR )
			OutputDebugString("Socket error - stream is going to be disconnected");
#endif
		/* deconnection du socket */
		AGW_qso[StreamNum].nFlags |= AGW_DISCONNECTED;
		return;
	}

	/* transforme crlf -> cr ... Pas de binaire ! */
	/* Modif F5MZN Nov 8, 2000 : sauf en mode
	   clulink ou la on ne touche a rien ! */
	if( PROTOCOL_linkType[StreamNum] != CLU_LINK )
	{
		for (i = 0, ilen = 0; i < nb; ++i)
		{
			if ((buffer[i] == '\r') && (buffer[i + 1] == '\n'))
				*pbuf++ = buffer[i++];
			else if ((buffer[i] == '\n') && (buffer[i + 1] == '\r'))
				*pbuf++ = buffer[++i];
			else if( buffer[i] == '\0' )
				continue;
			else
				*pbuf++ = buffer[i];
			ilen++;
		}
	}

	switch( AGW_qso[StreamNum].nTelnetState )
	{
	case WAITCALL :
	case WAITPASS :
		if( *buffer < 128 )
		{
			/* TOOLS_removeN(buffer); */
			BUFFERS_addBuff_sized(StreamNum, buffer, IN, ilen);
		}
					
		while( (ilen = BUFFERS_getRow(StreamNum, szBuffer, IN)) )
		{
			char *ptr = szBuffer;

			while( *ptr != 0 && *ptr < 32 )
				ptr++;
			
			nb = SWITCH_telnetCheck(StreamNum, ptr, ilen);
		}
		nb = 0;	

	default :
		BUFFERS_addBuff_sized(StreamNum, buffer, IN, ilen);
		break;
	}		
}

/*-----------------------------------------------------------------------------------------
  ------ Connexion sortante en telnet -----------------------------------------------------
  -----------------------------------------------------------------------------------------
*/
void SWITCH_telnetConnect(int StreamNum, char* pszToString)
{
	u_long InetAddr;
	struct hostent *host;
	struct sockaddr_in SockAddrInet;
	char* token;
	char* pszToCall   = "";
	char* pszHostAddr = "";
	int   nHostPortNum = 23;	/* by default */
	int   index = 0;

	token = strtok(pszToString, " \t");
	while( token )
	{
		switch(index++)
		{
		case 0 :	/* inet */
			break;

		case 1 :	/* to_call */
			pszToCall = token;
			break;

		case 2 :	/* host addr */
			pszHostAddr = token;
			break;

		case 3 :	/* port num */
			nHostPortNum = atoi(token);
			break;

		default :	/* too much args */
			BUFFERS_printBuff(StreamNum, IN, "*** failure with %s : syntax error in script file",
				pszToCall);
			return;
		}

		token = strtok(NULL, " \t");			
	}

	strcpy(AGW_qso[StreamNum].szCallSign, pszToCall);
	AGW_qso[StreamNum].nFlags = AGW_TRY_TO_CONNECT | AGW_TELNET;

	/* create the address suitable for winsock */
	InetAddr = inet_addr(pszHostAddr);
	if (InetAddr == INADDR_NONE) /* this means that address is a name like www.dxnet.free.fr */
	{
		host = gethostbyname(pszHostAddr); /* in case that we need a dns to get the address */
		if( host ) 
			InetAddr = *((u_long *)host->h_addr_list[0]);
	}

	/* create a sockaddress structure */
	SockAddrInet.sin_family = AF_INET;
	SockAddrInet.sin_port = htons(nHostPortNum);
	SockAddrInet.sin_addr.S_un.S_addr = InetAddr;

	/* Create the socket */
	if( (AGW_qso[StreamNum].nTelnetSocket = socket(AF_INET, SOCK_STREAM, IPPROTO_TCP)) == INVALID_SOCKET )
	{
		BUFFERS_printBuff(StreamNum, IN, "*** failure with %s : can't create a socket\r",
			pszToCall);
		return;
	}

	/* NOW connect to the socket */
	if( connect(AGW_qso[StreamNum].nTelnetSocket, (struct sockaddr*)& SockAddrInet, sizeof(SockAddrInet)) == SOCKET_ERROR )
	{
			BUFFERS_printBuff(StreamNum, IN, "*** failure with %s : unable to connect to distant host\r",
				pszToCall);
			closesocket(AGW_qso[StreamNum].nTelnetSocket);
			return;
	}

	AGW_qso[StreamNum].nFlags		= AGW_TELNET;
	AGW_qso[StreamNum].nTelnetState = CONNECT;
	BUFFERS_printBuff(StreamNum, IN, "*** Connected to (inet) %s\r", pszToCall);
}

/*-----------------------------------------------------------------------------------------
  ------ Gestion du password pour une connexion entrante telnet ---------------------------
  -----------------------------------------------------------------------------------------
*/
static int SWITCH_telnetCheck(int StreamNum, char *buffer, int ilen)
{
	switch( AGW_qso[StreamNum].nTelnetState )
	{
	case WAITCALL:
		buffer[ilen] = '\0';
		TOOLS_removeNR (buffer);
		strupr (buffer);
		/* Recupere l'indicatif */
		while ((ilen) && (*buffer <= ' '))
		{
			++buffer;
		}

		ilen = strlen (buffer);

		/* Modif F5MZN : 16 oct 1999 */
		if ( ! TOOLS_isCall (buffer) ) 
		{
			if (--AGW_qso[StreamNum].nPasswdFailure <= 0)
			{
				SWITCH_discSwitch (StreamNum);
			}
			else
				BUFFERS_printBuff(StreamNum, OUT, Callsign);
			return 0;
		}

		TOOLS_maxLength(buffer, 10);
		strcpy(AGW_qso[StreamNum].szCallSign, buffer);

		if( TELNET_isFirstConnection(buffer) )
		{
			BUFFERS_printBuff (StreamNum, OUT, FirstConnection);
			AGW_qso[StreamNum].nFlags |= AGW_FIRST_TELNET_CONNECTION;
		}

		BUFFERS_printBuff (StreamNum, OUT, Password);
		AGW_qso[StreamNum].nTelnetState = WAITPASS;
		AGW_qso[StreamNum].nPasswdFailure = 3;
		return 0;

	case WAITPASS:
		buffer[ilen] = '\0';
		TOOLS_removeNR (buffer);
		/* Recupere l'indicatif */
		while ((ilen) && (*buffer <= ' '))
		{
			++buffer;
			--ilen;
		}

		if( AGW_qso[StreamNum].nFlags & AGW_FIRST_TELNET_CONNECTION )
		{
			/* Premiere connexion sur un acces ouvert - enregistrer le
			   mot de passe */
			char szWithoutSsid[20];

			strcpy(szWithoutSsid, AGW_qso[StreamNum].szCallSign);
			TOOLS_removeSsid(szWithoutSsid);			
			PASSWORD_register(szWithoutSsid, buffer);

			AGW_qso[StreamNum].nFlags &= ~AGW_FIRST_TELNET_CONNECTION;
		}
		else
		{
			/* Checks the password for the callsign */
			if (!TELNET_isPasswordOk (AGW_qso[StreamNum].szCallSign, buffer))
			{
				if (--AGW_qso[StreamNum].nPasswdFailure <= 0)
				{
					SWITCH_discSwitch (StreamNum);
					return (0);
				}
				else
					BUFFERS_printBuff (StreamNum, OUT, Password);
				return 0;
			}
		}

		/* Connection accepted */
		AGW_qso[StreamNum].nTelnetState = CONNECT;
		BUFFERS_printBuff (StreamNum, OUT, Logon);
		AGW_qso[StreamNum].nFlags |= AGW_NEW_INCOMING_CONNECTION;
		return 0;

	default:
		return (ilen);
	}
}