
// ==========================================
//
// F6FBB 09/97 Portage DxNet F5MZN sous LINUX
//
// ==========================================

#include <alloc.h>
#include <stdio.h>
#include <ctype.h>
#include <string.h>
#include <unistd.h>
#include <termios.h>
// #include <sys/ioctl.h>
// #include <sys/types.h>
#include <dos.h>
#include <time.h>
#include "console.h"
#include "display.h"
#include "fbbsrv.h"
#include "tools.h"
#include "switch.h"

#define SCREEN2	1

int stdin_valid = 1;

/* Reverses a string */

char *strrev (char *str)
{
	char c;
	int i;
	int len = strlen (str) - 1;

	for (i = 0; i < len; i++, --len)
	{
		c = str[len];
		str[len] = str[i];
		str[i] = c;
	}
	return (str);
}

char *strupr (char *str)
{
	char *s = str;

	while (*s)
	{
		if (islower (*s))
			*s = toupper (*s);
		++s;
	}
	return (str);
}

char *strlwr (char *str)
{
	char *s = str;

	while (*s)
	{
		if (isupper (*s))
			*s = tolower (*s);
		++s;
	}
	return (str);
}

void gotoxy (int, int)
{
}

int wherex (void)
{
	return (1);
}

int wherey (void)
{
	return (1);
}

void delay (int)
{
}

int putch (int c)
{
	putchar (c);
	fflush (stdout);
	return (c);
}

void DISP_PutsConsole (int nScreen, char *str, int)
{
#ifdef WIN32
	char * buffer;

	/* sortie console locale */
	buffer = (char*) malloc(strlen(str) + 1);
	if( buffer )
	{
		strcpy(buffer, 	str);
		TOOLS_removeBell(buffer);
		fputs(buffer, stdout);
		fflush (stdout);
		free(buffer);
	}

	if( FBBSRV_isConsoleConnected() )
	{
		if( str[0] == 'c' && str[1] == ' ' )
			return;	/* ne pas afficher les 'connect' */
		TOOLS_N2R(str);
		FBBSRV_orbWrite(_CONSOLE, str, strlen(str), 3, 0);
	}			
#else
	if( nScreen == SCREEN2 && FBBSRV_isConsoleConnected() )
	{
		/* Pour la console ORB ... */
		TOOLS_N2R(str);		
		int len = strlen(str);
		FBBSRV_orbWrite (_CONSOLE, str, len, 0, 0);		
	}
	else
	{
		/* Sortie locale */
		fputs(str, stdout);
		fflush (stdout);
		if( nScreen == SCREEN1 && FBBSRV_isConsoleConnected() )
		{
			if( str[0] == 'c' && str[1] == ' ' )
				return;	/* ne pas afficher les 'connect' */
			TOOLS_N2R(str);
			FBBSRV_orbWrite(_CONSOLE, str, strlen(str), 3, 0);
		}			
		
	}
#endif
}

void DISP_InitDisplay (int)
{
}

void DISP_PutStat(void)
{
}

int DISP_GetActiveScreen(void)
{
	return(SCREEN2);
}

void DISP_PutsInputString(int nScreen, char *str, int lg)
{
	/* Pas d'echo vers la console */
	if( nScreen != SCREEN2 || ! FBBSRV_isConsoleConnected() )
	{
		str[lg] = '\0';
		puts (str);
		fflush (stdout);
	}
}

void DISP_StatRowUp(void)
{
}

void DISP_StatRowDown(void)
{
}

void DISP_SetActiveScreen(int)
{
}

void CON_restoreMode (void)
{
}

unsigned int getkey(void)
{
	return(getchar());
}

int bioskey(int)
{
//	int ret;
//	int val = 0;
//
//	ret = ioctl(0, FIONREAD, &val);
//	if (ret != 0)
//	{
//		// Erreur sur stdin -> Devalide la lecture clavier 
//		stdin_valid = 0;
//	}	
//	return(val);
	return 0;
}

int ScanKeyboard(char *str, int &pos, int max)
{
//	int nb;
//
//	nb = read(0, str+pos, max-pos);
//	str[pos+nb-1] = '\0';
//	return('\r');
	return 0;
}

void stime(time_t* t)
{
	// Ne fait rien pour l'instant ! Cette fonction devra etre supportee rapidement !
}
