// windows portage of dxnet - AGW pe interface - (c) f5mzn
// Part of code is (c) sv2agw

#include <winsock2.h>
#include "agw.h"
#include "buffers.h"
#include "users.h"
#include "tools.h"

///////////////////////////////////////////////////////////////////////////////////////////
// Variables globales
SOCKET AGW_socket = NULL;
QSO	   AGW_qso[65];

static char AGW_szHostAddr[256];
static int  AGW_nPort;

//static WSAEVENT SockEvent;
//static WSAEVENT EventArray[WSA_MAXIMUM_WAIT_EVENTS];
//static int NumEvents;

///////////////////////////////////////////////////////////////////////////////////////////
// Essaye de connecter le PE
//
// Retourne TRUE si OK

int AGW_connectPE(char* pszHostAddr, int nAGWPEPort)
{
	static BOOL bFirstCall = TRUE;
	u_long InetAddr;
	struct hostent *host;
	struct sockaddr_in SockAddrInet;

	if( bFirstCall )
	{
		strcpy(AGW_szHostAddr, pszHostAddr);
		AGW_nPort = nAGWPEPort;
		bFirstCall = FALSE;
		ZeroMemory(AGW_qso, sizeof AGW_qso);
	}

	//create the address suitable for winsock
	InetAddr = inet_addr(pszHostAddr);
	if (InetAddr == INADDR_NONE)// this means that address is a name like www.agw.org
	{
		host = gethostbyname(pszHostAddr);// in case that we need a dns to get the address
		if( host ) 
			InetAddr = *((u_long *)host->h_addr_list[0]);
	}

	//create a sockaddress structure
	SockAddrInet.sin_family = AF_INET;
	SockAddrInet.sin_port = htons(nAGWPEPort);
	SockAddrInet.sin_addr.S_un.S_addr = InetAddr;

	//Create the socket
	AGW_socket = socket(AF_INET, SOCK_STREAM, IPPROTO_TCP);
	if( AGW_socket == INVALID_SOCKET ) 
	{
		OutputDebugString("ERROR SOCKET1");//we must abort
		return FALSE;
	}

	//NOW connect the socket
	int Err = connect(AGW_socket, (struct sockaddr*)& SockAddrInet, sizeof(SockAddrInet));
	if( Err == SOCKET_ERROR )
	{
		if (WSAGetLastError() != WSAEWOULDBLOCK) // the socket will notify us later
		{
			//it is  a fatal error
			closesocket(AGW_socket);
			AGW_socket = NULL;
			return FALSE;
		}
	}

	return TRUE;
}

////////////////////////////////////////////////////////////////////////////////////////
// Lire un evenement sur le socket

void AGW_readEvent(void)
{
	char  szBuffer[4096];
	char* pszData;
	AGWHEADER * AgwHeader;

	int nHowManyCharsWait;
	int nHowManyCharsRead;
	int nSize;
	int index;
	int stream;

	if( AGW_socket == NULL )
		return;

	//check how many characters are waiting in the socket for reading
	nHowManyCharsWait = recv(AGW_socket, szBuffer, 4096, MSG_PEEK);
	if( nHowManyCharsWait == SOCKET_ERROR )
	{
		OutputDebugString("AGW_readEvent socket error - #1");
		AGW_goToIdleState();
		return;
	}

	if( nHowManyCharsWait == 0 )
	{
		/* disconnected from AGW pe*/
		AGW_goToIdleState();
		return;
	}

	if( nHowManyCharsWait < sizeof AGWHEADER )
		return;	/* header is not complete yet */

	AgwHeader = (AGWHEADER*) szBuffer;
	pszData   = szBuffer + sizeof AGWHEADER;

	if( nHowManyCharsWait < (int) (AgwHeader->nDataLen + sizeof(AGWHEADER)) )
		return;	/* frame not complete, it will be read later */

	/* Read header + datas */
	nSize = AgwHeader->nDataLen + sizeof AGWHEADER;
	nHowManyCharsRead = recv(AGW_socket, szBuffer, nSize, NULL);
	if( nHowManyCharsRead == SOCKET_ERROR )
	{
		OutputDebugString("AGW_readEvent socket error - #2");
		AGW_goToIdleState();
		return;
	}

	/* what kind of data ? */
	switch( LOWORD(AgwHeader->lDataKind) )
	{
	case 'C' :	/* connection */
		if( strstr(pszData, "With") )
		{
			/* Outgoing connection */
			if( (stream = AGW_searchStream((char*) AgwHeader->szCallFrom)) == -1 )
				return;	/* station not found */

			AGW_qso[stream].nFlags = 0; //AGW_CONNECTION_DONE;
			BUFFERS_printBuff(stream, IN, "*** Connected to %s\r", AgwHeader->szCallFrom);
		}
		else
		{
			/* Incoming connection */
			/* search for a free stream */
			for(index = 1 ; index <= 64; index++)
			{
				if( AGW_qso[index].szCallSign[0] == '\0' )
					break;
			}

			if( index == 65 )
			{
				/* no free stream available : disconnect immediatly = busy */
				AGW_send(AgwHeader->nPort, 'd', 
					(char*) AgwHeader->szCallTo, (char*)AgwHeader->szCallFrom, 0, 
					NULL, NULL, 0);
				return;
			}

			/* accept connection */
			AGW_qso[index].nFlags = AGW_NEW_INCOMING_CONNECTION;
			AGW_qso[index].nPort  = AgwHeader->nPort;
			strcpy(AGW_qso[index].szCallSign, (char*) AgwHeader->szCallFrom);
		}
		break;

	case 'v' :	/* connect via */
		break;

	case 'd' :	/* deconnection */
		/* look for the stream the station is connected to */
		if( (stream = AGW_searchStream((char*) AgwHeader->szCallFrom)) == -1 )
			return;	/* station not found */

		AGW_qso[stream].nFlags |= AGW_NEW_INCOMING_DISCONNECT;
		break;

	case 'D' :	/* rcv datas */
		if( (stream = AGW_searchStream((char*) AgwHeader->szCallFrom)) == -1 )
			return;	/* station not found */
		BUFFERS_addBuff_sized(stream, pszData, IN, AgwHeader->nDataLen);
		break;

	case 'Y' :	/* outstanding frame on stream */
		if( (stream = AGW_searchStream((char*) AgwHeader->szCallTo)) == -1 )
			return;		/* station not found */
		/* Has it been requested ? */
		if( ! (AGW_qso[stream].nFlags & AGW_UNACK_REQUEST) )
			return;		/* no : ignore */
		
		/* can disconnect ? */
		if( (int) *pszData == 0 )
			AGW_qso[stream].nFlags |= AGW_OK_TO_DISCONNECT;
		break;
			

	default :
		/* unknown or not implemented yet */
		break;
	}
}

////////////////////////////////////////////////////////////////////////////////////////////
// Send a frame to AGW PE
//
// nDataSize = size of szData  -  nDataSize = -1 means that the function must check the 
//             length of szData

static void AGW_send(int nPort, int nDataKind, char* pszCallFrom, char* pszCallTo, int nDigiCount, char** pszDigiTable, char* pszData, int nDataSize)
{
	char* pszBuffer;
	char* ptr;
	AGWHEADER * AgwHeader;
	int   nSize;
	int   ret;
	int   nDigiStringLen;

	if( AGW_socket == NULL )
		return;

	/* data size */
	if( nDataSize == -1 )
		nDataSize = strlen(pszData);

	/* digi string size */
	nDigiStringLen = (nDigiCount ? nDigiCount * 10 + 1 : 0);

	/* total size of the frame to be sent */
	nSize = sizeof(AGWHEADER) + nDataSize + nDigiStringLen;
	pszBuffer = (char*) malloc(nSize + 1);
	if( pszBuffer == NULL )
		return;	

	AgwHeader = (AGWHEADER*) pszBuffer;
	ZeroMemory(AgwHeader, sizeof AGWHEADER);

	AgwHeader->nPort     = nPort;
	AgwHeader->lDataKind = MAKELONG(nDataKind, 0);
	strcpy((char*) AgwHeader->szCallFrom, pszCallFrom);
	strcpy((char*) AgwHeader->szCallTo,   pszCallTo);
	AgwHeader->nDataLen  = nDataSize + nDigiStringLen;

	ptr = pszBuffer + sizeof AGWHEADER;

	/* Add digipeaters, if any */
	if( nDigiCount )
	{
		*ptr++ = (char) nDigiCount;
		for(int index = 0; index < nDigiCount; index++)
		{
			strcpy(ptr, pszDigiTable[index]);
			ptr += 10;
		}
	}

	/* Add pszData to the end */
	if( pszData != NULL )
		MoveMemory(ptr, pszData, nDataSize);

	/* Send now to AGW PE via the socket */
	ret = send(AGW_socket, pszBuffer, nSize, 0);
	if( ret == SOCKET_ERROR )
	{
		OutputDebugString("AGW_sendFrame : socket error");
		AGW_goToIdleState();
	}

	free(pszBuffer);
}

////////////////////////////////////////////////////////////////////////////////////////////
// Register callsign

void AGW_registerCallSign(char* pszCallSign)
{
	static char szOldCallSign[10];
	static BOOL bFirst = FALSE;

	if( bFirst == FALSE )
	{
		/* First time this function is called, no callsign registred yet */
		bFirst = TRUE;
	}
	else
	{
		/* Unregister the old callsign */
		AGW_send(0, 'x', szOldCallSign, "", 0, NULL, NULL, 0);
	}

	AGW_send(0, 'X', pszCallSign, "", 0, NULL, NULL, 0);
	strcpy(szOldCallSign, pszCallSign);
}



////////////////////////////////////////////////////////////////////////////////////////////
// Entrer en mode idle - une erreur est certainement survenue

void AGW_goToIdleState(void)
{
	if( AGW_socket == NULL )
		return;

	USERS_sendAll("Disconnected from SV2AGW packet engine : program enters idled mode\n", USERS_SYSOP, 0, -1);
	closesocket(AGW_socket);
	AGW_socket = NULL;
}

////////////////////////////////////////////////////////////////////////////////////////////
// Sortir du mode idle - si possible !

void AGW_goOutOfIdleState(void)
{
	extern char SWITCH_szMyCall[20];
	if( AGW_socket != NULL )
		return;	/* not in idle state */

	if( ! AGW_connectPE(AGW_szHostAddr, AGW_nPort) )
		return;

	/* Register again the callsign because it has been lost during the idle mode */
	AGW_send(0, 'X', SWITCH_szMyCall, "", 0, NULL, NULL, 0);

	USERS_sendAll("SV2AGW packet engine found : program leaves idled mode\n", USERS_SYSOP, 0, -1);	
}

////////////////////////////////////////////////////////////////////////////////////////////
// Rechercher sur quel stream un utilisateur est connecte
//
// La fonction retourne -1 si pas trouve 

static int AGW_searchStream(char* pszCallSign)
{
	for(int stream = 1; stream <= 64; stream++)
	{
		if( ! strcmp(pszCallSign, AGW_qso[stream].szCallSign) )
			return stream;
	}

	return -1;
}

////////////////////////////////////////////////////////////////////////////////////////////
// Envoyer une trame packet

void AGW_sendFrame(int StreamNum, char* pszString, int nSize)
{
	extern char SWITCH_szMyCall[10];

	if( StreamNum < 1 || StreamNum > 64 )
		return;

	AGW_send(AGW_qso[StreamNum].nPort, 'D', SWITCH_szMyCall, AGW_qso[StreamNum].szCallSign, 
		0, NULL, pszString, nSize);
}

////////////////////////////////////////////////////////////////////////////////////////////
// Deconnecter un stream

void AGW_disconnect(int StreamNum)
{
	extern char SWITCH_szMyCall[10];

	if( StreamNum < 1 || StreamNum > 64 )
		return;

	/* deconnecter ! */
	AGW_send(AGW_qso[StreamNum].nPort, 'd', SWITCH_szMyCall, AGW_qso[StreamNum].szCallSign, 
		0, NULL, NULL, 0);
	AGW_qso[StreamNum].nFlags = AGW_DISCONNECTED;
	
}

////////////////////////////////////////////////////////////////////////////////////////////
// Demander le nombre de trames qui doivent etre transmises

void AGW_getOutstandingFrameOnStream(int StreamNum)
{
	extern char SWITCH_szMyCall[10];

	if( StreamNum < 1 || StreamNum > 64 )
		return;

	AGW_send(AGW_qso[StreamNum].nPort, 'Y', SWITCH_szMyCall, AGW_qso[StreamNum].szCallSign, 
		0, NULL, NULL, 0);
}

////////////////////////////////////////////////////////////////////////////////////////////
// Connecter a une station via AGW pe

void AGW_connect(int StreamNum, char* pszToString)
{
	extern char SWITCH_szMyCall[10];

	char* token;
	int	  index = 0;
	int	  nPort;
	int   nViaCount = 0;
	char* pszToCall;
	char* pszViaList[7];

	if( StreamNum < 1 || StreamNum > 64 )
		return;

	strupr(pszToString);
	TOOLS_removeNR(pszToString);

	token = strtok(pszToString, " ,");
	while( token )
	{
		TOOLS_maxLength(token, 9);

		switch(index)
		{
		case 0 :
			nPort = atoi(token) - 1;
			if( nPort < 0 || nPort > 100)
				nPort = 0;
			break;

		case 1 :
			pszToCall = token;
			break;

		default :
			pszViaList[nViaCount++] = token;
			break;
		}
		
		if( index++ == 9 )
			break;
		token = strtok(NULL, " ,");
	}

	if( index < 2 )
		return;

	strcpy(AGW_qso[StreamNum].szCallSign, pszToCall);
	AGW_qso[StreamNum].nPort  = nPort;
	AGW_qso[StreamNum].nFlags = AGW_TRY_TO_CONNECT;

	if( nViaCount )
		AGW_send(nPort, 'v', SWITCH_szMyCall, pszToCall, nViaCount, pszViaList, NULL, 0);
	else
		AGW_send(nPort, 'C', SWITCH_szMyCall, pszToCall, 0, NULL, NULL, 0);
}