
(* ---------------------------------------------------------------
Title         Q&D Set VGA Character Generator
Author        PhG
Overview      self-explanatory !
Notes         
              minimal error messages and checking, etc.
              ugly results (cursor shape and position) :
              because of nd7 cursor utility ? bah, who cares ?
Bugs          cursor is not always correct !
Wish List

--------------------------------------------------------------- *)

MODULE CharGen;

IMPORT Lib;
IMPORT Str;
IMPORT IO;
IMPORT SYSTEM;

(*
if imported and not used, ugly size penalty anyway !
IMPORT Graph;
*)

FROM QD_Box IMPORT str80, str2, cmdInit, cmdShow, cmdStop, delim,
Work, video, Ltrim, Rtrim, UpperCase, LowerCase, ReplaceChar,
ChkEscape, Waitkey, WaitkeyDelay, Flushkey, IsRedirected, chkJoker,
isOption, GetOptIndex, GetLongCard, GetString, CharCount, same,
aR, aH, aS, aD, aA, everything, isDirectory, fixDirectory,
str128, str256, Animation, allfiles, Belongs, FixAE, CodePhonetic,
CodeSoundex, CodeSoundexOrg, isReadOnly, LtrimBlanks, RtrimBlanks,
getStrIndex, cmdSHOW,BiosWaitkey,BiosWaitkeyShifted,BiosFlushkey,
str1024, isoleItemS, dmpTTX, str2048, Elapsed, TerminalReadString,
getDosVersion, DosVersion, warning95, runningWindows,
aV, reallyeverything;

FROM IO IMPORT WrStr, WrLn;

(* ------------------------------------------------------------ *)

CONST
    ProgEXEname   = "CHARGEN";
    ProgTitle     = "Q&D Set VGA Character Generator";
    ProgVersion   = "v1.0a";
    ProgCopyright = "by PhG";
    Banner        = ProgTitle+" "+ProgVersion+" "+ProgCopyright;
    cr = CHR(13);
    lf = CHR(10);

(* ------------------------------------------------------------ *)

CONST
    errNone         = 0;
    errHelp         = 1;
    errTooManyParms = 2;
    errOption       = 3;
    errParm         = 4;
    errCard         = 5;
    errVGA          = 6;

PROCEDURE abort (e : CARDINAL; einfo : ARRAY OF CHAR);
CONST
    nl = cr+lf;
    (*
     00000000011111111112222222222333333333344444444445555555555666666666677777777778
     1...'....0....'....0....'....0....'....0....'....0....'....0....'....0....'....0
    *)
    helpmsg =
    Banner+nl+
    nl+
    "Syntax : "+ProgEXEname+" [-c] [-v] < 25 | 28 | 43 | 50 | 8x16 | 8x14 | 8x8 >"+nl;
VAR
    S : str256;
BEGIN
    CASE e OF
    | errHelp :
        WrStr(helpmsg);
    | errTooManyParms :
        S:="Too many parameters !";
    | errOption :
        Str.Concat(S,"Illegal ",einfo);
        Str.Append(S," option !");
    | errParm :
        Str.Concat(S,"Illegal ",einfo);
        Str.Append(S," parameter !");
    | errCard :
        S := "This program requires a VGA card !";
    | errVGA :
        Str.Concat(S,einfo,"-lines mode does not seem to be available !");
    ELSE
        S := "This is illogical, Captain !";
    END;
    IF (e <> errNone) AND (e <> errHelp) THEN
        WrStr(ProgEXEname+" : ");
        WrStr(S);
        WrLn;
    END;
    Lib.SetReturnCode(SHORTCARD(e));
    HALT;
END abort;

(* ------------------------------------------------------------ *)

CONST
    MONO = BYTE(7); (* monochrome *)
CONST
    sb = 040H; (* segBiosData *)
VAR
    biosCurrentVideoMode  [sb:049H] : BYTE;

PROCEDURE isMonoMode ():BOOLEAN;
BEGIN
    RETURN (biosCurrentVideoMode = MONO);
END isMonoMode;

PROCEDURE resetCharGen (setpattern,vres,lines : CARDINAL;
                        changeshape,DEBUG : BOOLEAN):BOOLEAN;
CONST
    videoBIOS = 10H;
    block     = 00H; (* block to load must be 0, else ugly results ! *)
VAR
    R : SYSTEM.Registers;
    columns,displaymode,activepage:SHORTCARD;
    cursorstart,cursorend,cursorcolumn,cursorrow:SHORTCARD;
    fontheight [0040H:0085H] : CARDINAL;

    oldscanlines : CARDINAL;
    newscanlines : CARDINAL;
    newcursorstart,newcursorend:CARDINAL;
BEGIN
    IF lines # 25 THEN
        IF isMonoMode() THEN RETURN FALSE; END;
    END;

    CASE vres OF
    | 200: vres:=00;
    | 350: vres:=01;
    | 400: vres:=02;
    END;

    oldscanlines := fontheight;

    R.AH := 0FH;           (* get current video mode *)
    Lib.Intr(R,videoBIOS);
    columns     := R.AH;
    displaymode := R.AL;   (* bit 7 can be ON if previous mode setting was so *)
    activepage  := R.BH;

    R.AH := 03H;           (* get cursor position and size *)
    R.BH := activepage;
    Lib.Intr(R,videoBIOS);
    cursorstart := R.CH;
    cursorend   := R.CL;
    cursorcolumn:= R.DL;
    cursorrow   := R.DH;

    R.AH := 12H;           (* select vertical resolution vga *)
    R.BL := 30H;
    R.AL := SHORTCARD(vres);        (* 0=200, 1=350, 2=400 *)
    Lib.Intr(R,videoBIOS);          (* al=$12 if function supported *)
    IF R.AL # 12H THEN RETURN FALSE; END;

    R.AH := 00H;           (* set video mode *)
    R.AL := displaymode;
    Lib.Intr(R,videoBIOS);

    R.AX := setpattern;
    R.BL := SHORTCARD(block);
    Lib.Intr(R,videoBIOS);

    (*
    R.AX := 1130H;         (* get font information *)
    R.BL := 00H;           (* dummy, just in case : get int $1F pointer *)
    Lib.Intr(R,videoBIOS);
    scanlines := SHORTCARD(R.CX);  (* pixels per char, same as $0040:0085 (word) *)
    *)
    newscanlines := fontheight;

    newcursorstart := (newscanlines * CARDINAL(cursorstart)) DIV oldscanlines;
    newcursorend   := (newscanlines * CARDINAL(cursorend  )) DIV oldscanlines;

    IF DEBUG THEN
        WrStr("oldscanlines   ");IO.WrCard(oldscanlines,3);
        WrStr("    newscanlines   ");IO.WrCard(newscanlines,3);WrLn;
        WrStr("cursorstart    ");IO.WrShtCard(cursorstart,3);
        WrStr("    newcursorstart ");IO.WrCard(newcursorstart,3);WrLn;
        WrStr("cursorend      ");IO.WrShtCard(cursorend,3);
        WrStr("    newcursorend   ");IO.WrCard(newcursorend,3);WrLn;
    END;

    IF changeshape THEN
        R.AH := 01H;           (* set text-mode cursor shape *)
        R.CH := SHORTCARD(newcursorstart);
        R.CL := SHORTCARD(newcursorend);
        Lib.Intr(R,videoBIOS);
    END;

    RETURN TRUE;
END resetCharGen;

(* ------------------------------------------------------------ *)

VAR
    parmcount,i,opt     : CARDINAL;
    S,R                 : str128;
    pattern,vres        : CARDINAL;
    verbose,changeshape : BOOLEAN;
    state     : (waiting, gotmode);
    info      : str80;
    rc        : BOOLEAN;
    lines     : CARDINAL;
    DEBUG     : BOOLEAN;
(*
    v         : Graph.VideoConfig;
*)
BEGIN
    Lib.DisableBreakCheck();

    WrLn; (* required here now *)

    DEBUG       := FALSE;
    verbose     := FALSE;
    changeshape := FALSE;
    state       := waiting;

    parmcount := Lib.ParamCount();
    IF parmcount=0 THEN abort(errHelp,"");END;

    FOR i := 1 TO parmcount DO (* for future extension ! *)
        Lib.ParamStr(S,i);
        Str.Copy(R,S);
        UpperCase(R);
        IF isOption(R)=TRUE THEN
            opt := GetOptIndex(R,"?"+delim+"H"+delim+"HELP"+delim+
                                 "V"+delim+"VERBOSE"+delim+
                                 "C"+delim+"CURSOR"+delim+
                                 "DEBUG");
            CASE opt OF
            | 1,2,3: abort(errHelp,"");
            | 4,5 :   verbose     := TRUE;
            | 6,7:    changeshape := TRUE;
            | 8:      DEBUG       := TRUE;
            ELSE
                abort(errOption,S); (* could be errHelp, eh eh ! *)
            END;
        ELSE
            CASE state OF
            | waiting:
                Str.Prepend(R,"-"); (* fake option *)
                opt := GetOptIndex(R,"8X8"+delim+"50"+delim+
                                     "8X14"+delim+"28"+delim+
                                     "8X16"+delim+"25"+delim+
                                     "43");
                CASE opt OF
                | 1,2 :
                    pattern := 1112H; (* 8x8 ROM DBL-dot patterns EGA/VGA *)
                    info    := "50";
                    vres    := 400;
                    lines   := 50;
                | 3,4 :
                    pattern := 1111H; (* 8x14 ROM monochrome patterns EGA/VGA *)
                    info    := "28";
                    vres    := 400;
                    lines   := 28;
                | 5,6 :
                    pattern := 1114H; (* 8x16 ROM VGA *)
                    info    := "25";
                    vres    := 400;
                    lines   := 25;
                | 7:
                    pattern := 1112H; (* 8x8 ROM DBL-dot patterns EGA/VGA *)
                    info    := "43";
                    vres    := 350;
                    lines   := 43;
                ELSE
                    abort(errParm,S);
                END;
                INC(state);
            | gotmode:
                abort(errTooManyParms,"");
            END;
        END;
    END;
    IF state=waiting THEN abort(errHelp,"");END;

    (*
    well, everyone is supposed to have at least a vga card !
    Graph.GetVideoConfig(v);
    IF v.adapter # Graph._VGA THEN abort(errCard,""); END;
    *)

    (* pattern MUST be $111x because $110x does NOT work : Matrox strikes again ! *)
    (* block other than 0 is a no-no *)

    rc:=resetCharGen(pattern,vres,lines,changeshape,DEBUG); (* clear screen then reset chargen *)
    IF rc=FALSE THEN abort (errVGA,info);END;

    IF verbose THEN
        WrStr("Display now set to ");
        WrStr(info);
        WrStr(" lines !");
        WrLn;
    END;

    abort(errNone,"");
END CharGen.
