(* ---------------------------------------------------------------
Title         Q&D Weird entries lister
Author        who cares ?
Overview      see help
Usage         see help
Notes         alas, XDIR does not provide a +v switch !
              see //FIX
Bugs          yet another TS one :
              Lib.ParamStr() "fixes"
                  -o:" "
              to
                  -o:

              concatenating "" to a string constant forces a 0c !

              one cannot trust anyone ! never ! not even oneself (or so little)

              TS makeallpath() reinserts a dot even if e does not contain one !

              program becomes too spaghetticode !
              structure is really ugly : Code Police required !

Wish List     probably useless but :
              -d = directories
              -p = full path

              egjlmpqtxy

             check spec is only legal DOS chars ?

--------------------------------------------------------------- *)

MODULE DirWeird;

IMPORT Lib;
IMPORT FIO;
IMPORT Str;

IMPORT IO;

FROM Storage IMPORT ALLOCATE, DEALLOCATE, Available;

FROM IO IMPORT WrStr, WrLn;

FROM QD_Box IMPORT str80, str2, cmdInit, cmdShow, cmdStop, delim,
Work, video, Ltrim, Rtrim, UpperCase, LowerCase, ReplaceChar,
ChkEscape, Waitkey, WaitkeyDelay, Flushkey, IsRedirected, chkJoker,
isOption, GetOptIndex, GetLongCard, GetLongInt, GetString, CharCount,
same, aR, aH, aS, aD, aA, everything, isDirectory, fixDirectory,
str128, str256, Animation, allfiles, Belongs, FixAE, CodePhonetic,
CodeSoundex, CodeSoundexOrg, isReadOnly, LtrimBlanks, RtrimBlanks,
getStrIndex, cmdSHOW,BiosWaitkey,BiosWaitkeyShifted,BiosFlushkey,
str1024, isoleItemS, dmpTTX, str2048, Elapsed, TerminalReadString,
getDosVersion, DosVersion, warning95, runningWindows,
aV, reallyeverything, chkClassicTextMode, setClassicTextMode,
AltAnimation, str16, getCurrentDirectory, setReadWrite, setReadOnly,
getFileSize, verifyString, str4096, unfixDirectory,
animShow, animSHOW, animAdvance, animEnd, animClear,
animInit, animGetSdone, anim, cleantabs, UpperCaseAlt, LowerCaseAlt,
completedInit, completedShow, completedSHOW, completedEnd, completed,
removeDups, isValidHDunit, removePhantoms, removeFloppies,
getCDROMunits, getCDROMletters, removeCDROMs, getAllHDunits,
getAllLegalUnits;

FROM QD_LFN IMPORT path9X, huge9X, findDataRecordType,
unicodeConversionFlagType, w9XchangeDir,
w9XgetDOSversion, w9XgetTrueDOSversion, w9XisWindowsEnh, w9XisMSDOS7,
w9XfindFirst, w9XfindNext, w9XfindClose, w9XgetCurrentDirectory,
w9XlongToShort, w9XshortToLong, w9XtrueName, w9XchangeDir,
w9XmakeDir, w9XrmDir, w9Xrename, w9XopenFile, w9XcloseFile,
w9XsupportLFN;

(* ------------------------------------------------------------ *)

TYPE
    pathtype = path9X;

CONST
    firstPath               = 1;   (* was 0, but 1 required by Lib.QSort and by firstPath-1 of course ! *)
    maxPath                 = 5000; (* // 7500 *)
    sMaxPath                = "5000";

CONST
    LFNacceptable        = " ";
(*
    DOSacceptableOLD     = "_-$!";
    DOSacceptable        = "_-$!&(){}[]~"; (* v1.1 fix *)
    lfnSpecificOLD    = (* "_- !&(){}[]  ',+";   *)   "_-!&(){}[] ',+";
    lfnSpecific          = "_-$!&(){}[]~ ',+.";
*)
    DOSacceptable        = "_-$!(){}";
    lfnSpecific          = "_-$!(){} ',+.";
CONST
    digits               = "0123456789";
    lettersLows          = "abcdefghijklmnopqrstuvwxyz";
    lettersCaps          = "ABCDEFGHIJKLMNOPQRSTUVWXYZ";
    alphaSet             = lettersCaps; (* /FIX before v1.0i, was +lettersLows *)
    alphanumSet          = digits+alphaSet;
    alphanumplusSet      = digits+alphaSet+DOSacceptable;
    alphanumBlankPlusSet = digits+alphaSet+DOSacceptable+LFNacceptable;
    lfnSet               = alphanumSet+lfnSpecific;
CONST
    msgAlphaSet             = "[A..Z]";
    msgAlphaNumSet          = "[A..Z0..9]";
    msgAlphaNumPlusSet      = "[A..Z0..9"+DOSacceptable+"]";
    msgAlphaNumBlankPlusSet = "[A..Z0..9"+DOSacceptable+LFNacceptable+"]";
    msgLFNset               = "[A..Z0..9"+lfnSpecific+"]";
    dospat                  = "????????.??? f8.e3";
    msgLowerCaseSet         = "[a..z]";

TYPE
    scanmodetype =    (scandefault,scanattrib,
                      scanAlpha,scanAlphanum,
                      scanAlphanumplus,scanAlphanumBlankPlus,
                      scanlfn,scanonly,scanNotDOSpat,scanDOSpatFit,
                      scanF8,scanE3,scanLowerCase);

CONST
    ProgEXEname   = "DIRWEIRD";
    ProgTitle     = "Q&D Weird entries lister";
    ProgVersion   = "v1.1a";
    ProgCopyright = "by PhG";
    Banner        = ProgTitle+" "+ProgVersion+" "+ProgCopyright;

CONST
    errNone           = 0;
    errHelp           = 1;
    errOption         = 2;
    errBadSpec        = 3;
    errTooManyDirs    = 4;
    errTooManyParms   = 5;
    errNeedSpec       = 6;
    errNonsense       = 7;
    errUseless        = 8;
    errNotHere        = 9;
    errUserNeeded     = 10;
    errStorage        = 11;
    errAborted        = 12;
    errWin9Xonly      = 13;
    errLC             = 14;
    errRange          = 15;

(* ------------------------------------------------------------ *)

PROCEDURE abort (e : CARDINAL; einfo : ARRAY OF CHAR);
CONST
(*
 00000000011111111112222222222333333333344444444445555555555666666666677777777778
 1...'....0....'....0....'....0....'....0....'....0....'....0....'....0....'....0
*)
    nl=CHR(13)+CHR(10);
    msghelp=
Banner+nl+
nl+
"Syntax 1 : "+ProgEXEname+" <[u:]\[path]>... [option]..."+nl+
"Syntax 2 : "+ProgEXEname+" <[u:]\[path]>... <-azfbwcdj> [option]..."+nl+
"Syntax 3 : "+ProgEXEname+" <[u:]\[path]>... <-o> <-u:$> [option]..."+nl+
"Syntax 4 : "+ProgEXEname+" <[u:]\[path]>... <-n:#|-e:#> [option]..."+nl+
nl+
"-h        entries with Hidden attribute set"+nl+
"-s        entries with System attribute set"+nl+
"-v        entries with Volume attribute set"+nl+
"-r        entries with Read-Only attribute set"+nl+
"-a        entries containing chars not found in "+msgAlphaSet+nl+
"-z|-aa    entries containing chars not found in "+msgAlphaNumSet+nl+
"-f|-aaa   entries containing chars not found in "+msgAlphaNumPlusSet+nl+
"-b|-aaaa  entries containing chars not found in "+msgAlphaNumBlankPlusSet+nl+
"-w|-aaaaa entries containing chars not found in "+msgLFNset+nl+
"-o[:$]    entries containing chars found in -u:$ string (-o:$ = -o -u:$)"+nl+
"-c        entries whose name does not fit "+dospat+" DOS pattern"+nl+
"-d        entries whose name fits "+dospat+" DOS pattern"+nl+
"-j        entries containing chars found in "+msgLowerCaseSet+" (-k forced)"+nl+
"-u:$      user-defined allowed characters (may be enclosed with double quotes)"+nl+
"-n:#      entries whose name's length is equal to or longer than value"+nl+
"-e:#      entries whose extension's length is equal to or longer than value"+nl+
"-k        do not force allowed character sets and filenames to lowercase"+nl+
"-u        display filenames in uppercase (ignored for LFNs)"+nl+
"-n        scan specified directory only (no recursion)"+nl+
"-i        inverse results"+nl+
"-lfn      disable LFN support even if available (display ONLY !)"+nl+
nl+
"a) If no attribute is specified, scanning defaults to -h -s -v options."+nl+
"b) With -<a|z|f|b|w|c|d|j|o> options, all files are scanned"+nl+
"   whatever their attributes, including directories."+nl+
"c) Unless -k option was specified, character matching ignores"+nl+
'   both case and accentuation ("e"="E"=""="", etc.).'+nl+
"d) Both name and extension are scanned."+nl+
"e) This program will not process more than "+sMaxPath+" directories."+nl+
"f) Note LFN support is limited to display."+nl+
"g) With Novell DOS 7, -v option lists all files kept by DELWATCH."+nl+
"h) From Win9X, matching directory entries may be listed more than once."+nl+
nl+
"Example : "+ProgEXEname+" \ /a /u:_-$!@~[]"+nl;

VAR
    S : str256;
BEGIN
    CASE e OF
    | errHelp :
        WrStr(msghelp);
    | errOption :
        Str.Concat(S,"Illegal ",einfo);
        Str.Append(S," option !");
    | errBadSpec :
        Str.Concat(S,"Illegal ",einfo);
        Str.Append(S," directory specification !");
    | errTooManyDirs :
        Str.Concat(S,"Too many directories in ",einfo);
        Str.Append(S," unit !");
    | errTooManyParms :
        S := "Too many directories specified !";
    | errNeedSpec :
        S := "No directory specified !";
    | errNonsense: (* long msg *)
        S := "-n:#, -e:#, -a, -z, -f, -b, -w, -c, -d, -j and -o options"+nl+"are mutually exclusive !";
    | errUseless: (* long msg *)
        S := "-h, -s, -v and -r options are not needed with"+nl+" -a, -z, -f, -b, -w, -c, -d or -o options !";
    | errNotHere:
        S := "-u:$ option is a nonsense without -a, -z, -f, -b, -w or -o !";
    | errUserNeeded:
        S := "-o option requires -u:$ option !";
    | errStorage:
        Str.Concat(S,"Storage.ALLOCATE() failure while trying to store this string !",nl);
        Str.Append(S,'("');Str.Append(S,einfo);Str.Append(S,'")');
    | errAborted:
        S := "Aborted by user !";
    | errWin9Xonly:
        S := "~ option is a nonsense without LFN support !";
        Str.Subst(S,"~",einfo);
    | errLC:
        Str.Concat(S,"Illegal ",einfo);Str.Append(S," value !");
    | errRange:
        Str.Concat(S,einfo," is out of expected [0..260] range !");
    ELSE
        S := "This is illogical, Captain !";
    END;
    CASE e OF
    | errNone, errHelp : ;
    ELSE
        WrStr(ProgEXEname+" : ");WrStr(S);WrLn;
    END;
    Lib.SetReturnCode(SHORTCARD(e));
    HALT;
END abort;

(* ------------------------------------------------------------ *)
(* ------------------------------------------------------------ *)

CONST
    dot         = ".";
    dotdot      = dot+dot;
    star        = "*";
    stardotstar = star+dot+star;
    backslash   = "\";
    colon       = ":";
    netslash    = backslash+backslash;
    dquote      = '"';
    singlequote = "'";
    blank       = " ";

(* ------------------------------------------------------------ *)

TYPE
    ptrToEntry = POINTER TO pathEntrytype;
    pathEntrytype  = RECORD
        slen : SHORTCARD;
        string:CHAR; (* variable length *)
    END;
VAR (* globerk to keep compiler happy *)
    Path      : ARRAY[firstPath..maxPath] OF ptrToEntry;

PROCEDURE freePathList ( last:CARDINAL );
VAR
    i,len,needed:CARDINAL;
BEGIN
    FOR i:=firstPath TO last DO
         IF Path[i] # NIL THEN
             len := CARDINAL(Path[i]^.slen);
             needed := SIZE(pathEntrytype)-SIZE(CHAR)+len;
             DEALLOCATE(Path[i],needed);
         END;
    END;
END freePathList;

(* ------------------------------------------------------------ *)

PROCEDURE fixDirPath (VAR S : ARRAY OF CHAR);
VAR
    len : CARDINAL;
BEGIN
    len := Str.Length(S);
    IF len = 0 THEN
        Str.Copy(S,backslash);
    ELSE
        IF S[len-1] # backslash THEN
            Str.Append(S,backslash);
        END;
    END;
END fixDirPath;

PROCEDURE isDirEntry (S : ARRAY OF CHAR) : BOOLEAN;
BEGIN
    IF same(S,dot) THEN RETURN TRUE; END;
    RETURN same(S,dotdot);
END isDirEntry;

PROCEDURE getentry (i:CARDINAL; VAR R : ARRAY OF CHAR);
CONST
    nullchar=CHR(0);
VAR
    len:CARDINAL;
BEGIN
    len := CARDINAL(Path[i]^.slen);
    Lib.FastMove( ADR(Path[i]^.string),ADR(R),len);
    R[len]:=nullchar; (* REQUIRED safety ! *)
END getentry;

PROCEDURE setentry (i:CARDINAL; S : ARRAY OF CHAR  ) : BOOLEAN ;
VAR
    len,needed:CARDINAL;
BEGIN
    len    := Str.Length(S);
    needed := SIZE(pathEntrytype)-SIZE(CHAR)+len;
    IF Available(needed) THEN
        ALLOCATE(Path[i],needed);
        Path[i]^.slen := SHORTCARD(len);
        Lib.FastMove( ADR(S),ADR(Path[i]^.string),len);
    ELSE
        Path[i]:=NIL;
    END;
    RETURN (Path[i] # NIL);
END setentry;

PROCEDURE doDir (root : ARRAY OF CHAR;eyecandy:BOOLEAN;
                 VAR index:CARDINAL;VAR err:BOOLEAN);
VAR
    path    : str128;
    S       : str128;
    entry   : FIO.DirEntry;
    found   : BOOLEAN;
BEGIN
    IF index > maxPath THEN
        err:=TRUE;
        RETURN;
    END;
    fixDirPath(root); (* add required "\" here *)
(* WrStr("Dir  ");WrCard(index,8);WrStr(" : ");WrStr(root);WrLn; *)
    IF setentry(index,root)=FALSE THEN
        err:=TRUE;
        RETURN;
    END;

    Str.Copy(path,root);
    (* fixDirPath(path); (* add required \ *) was done a few lines earlier *)
    Str.Append(path,stardotstar); (* root\*.* *)

    found := FIO.ReadFirstEntry(path,everything,entry);
    WHILE found DO
        IF eyecandy THEN Work(cmdShow); END;
        Str.Copy(S,root);
        fixDirPath(S);
        Str.Append(S,entry.Name); (* root\f8e3 *)
        IF isDirEntry(entry.Name)=FALSE THEN (* skip . and .. *)
            IF (aD IN entry.attr) THEN
                INC(index);
                doDir(S,eyecandy,index,err);
            END;
        END;
        found :=FIO.ReadNextEntry(entry);
    END;
END doDir;

PROCEDURE BuildPathList (rootdir : ARRAY OF CHAR) : CARDINAL;
CONST
    msg1 = "Building list of directories for ";
VAR
    found    : BOOLEAN;
    i        : CARDINAL;
    prompt   : str128;
    error    : BOOLEAN;
BEGIN
    Str.Concat(prompt,msg1,rootdir);

    video (prompt,TRUE);
    Work(cmdInit);

    i        := firstPath;
    error    := FALSE;

    doDir(rootdir,TRUE,i,error);

    Work(cmdStop);
    video (prompt,FALSE);
    IF error THEN i:=MAX(CARDINAL); END;
    RETURN i;
END BuildPathList;

PROCEDURE retrieveentry ( i:CARDINAL):str128;
VAR
    R:str128;
BEGIN
    getentry(i,R);
    RETURN R;
END retrieveentry;

PROCEDURE shortToLFN (VAR longform:pathtype;dosform:ARRAY OF CHAR);
VAR
    rc:CARDINAL;
    shortform:pathtype;
BEGIN
    Str.Copy(shortform,dosform);
    IF w9XshortToLong(shortform,rc,longform)=FALSE THEN
        Str.Copy(longform,shortform); (* hide problem *)
    END;
END shortToLFN;

PROCEDURE LFNtoShort (VAR dosform:pathtype;longform:pathtype);
VAR
    rc:CARDINAL;
    LFNform:pathtype;
BEGIN
    Str.Copy(LFNform,longform);
    IF w9XlongToShort (LFNform, rc,dosform)=FALSE THEN
         Str.Copy(dosform,LFNform); (* hide problem *)
    END;
END LFNtoShort;

(* ------------------------------------------------------------ *)
(* ------------------------------------------------------------ *)

PROCEDURE dbgstr (dbg:BOOLEAN;S1,S2:ARRAY OF CHAR   );
CONST
    wimax = 20;
VAR
    i:CARDINAL;
BEGIN
    IF dbg THEN
        WrStr("// ");
        WrStr(S1);
        FOR i:=Str.Length(S1)+1 TO wimax DO WrStr(" ");END;
        WrStr(": ");
        WrStr(S2);WrLn;
    END;
END dbgstr;

(* ------------------------------------------------------------ *)
(* ------------------------------------------------------------ *)

PROCEDURE isAlpha (c : CHAR) : BOOLEAN;
BEGIN
    IF Str.CharPos(lettersCaps,c)=MAX(CARDINAL) THEN
        RETURN FALSE;
    ELSE
        RETURN TRUE;
    END;
END isAlpha;

PROCEDURE fbool (tf:BOOLEAN;ST,SF:ARRAY OF CHAR ):str80;
VAR
    R:str80;
BEGIN
    IF tf THEN
        Str.Copy(R,ST);
    ELSE
        Str.Copy(R,SF);
    END;
    RETURN R;
END fbool;

PROCEDURE fmtAttr (attr:FIO.FileAttr) : str80;
VAR
    S : str80;
BEGIN
    Str.Copy   (S, fbool((aD IN attr), "D", "-"));
    Str.Append (S, fbool((aR IN attr), "R", "-"));
    Str.Append (S, fbool((aH IN attr), "H", "-"));
    Str.Append (S, fbool((aS IN attr), "S", "-"));
    Str.Append (S, fbool((aA IN attr), "A", "-"));
    Str.Append (S, fbool((aV IN attr), "V", "-"));
    Str.Lows(S); (* prettier display ! *)
    RETURN S;
END fmtAttr;

PROCEDURE scanName(allowed: ARRAY OF CHAR; basepath:ARRAY OF CHAR;
                   useLFN,ucase,keeporgcase,inverse,DEBUG:BOOLEAN;
                   scanmode:scanmodetype;attribs:FIO.FileAttr;
                   vmini:CARDINAL;
                   VAR count:LONGCARD);
CONST
    f8len = 8;
    e3len = 3; (* remove dot first ! *)
VAR
    found    : BOOLEAN;
    entry    : FIO.DirEntry;
    spec     : str128;
    S        : str1024; (* longer than LFN *)
    FN       : str128;
    slen,strcount,i,j,absent,present : CARDINAL;
    u,d,n,e,longform,str:pathtype;
    dmp:BOOLEAN;
BEGIN
    dbgstr(DEBUG,"allowed 1",allowed);
    IF NOT(keeporgcase) THEN LowerCase(allowed); END;
    dbgstr(DEBUG,"allowed 2",allowed);
    fixDirPath(basepath);
    Str.Copy(spec,basepath);
    Str.Append(spec,stardotstar);

    (*
    //FIXME
    we scan for dir entries too though it's not SO bright an idea here
    from Win9X, dirs with funny chars may be listed more than once
    *)

    found := FIO.ReadFirstEntry(spec,reallyeverything,entry);
    WHILE found DO
        IF useLFN THEN
            Str.Concat(FN,basepath,entry.Name);
            shortToLFN(longform, FN);
            Lib.SplitAllPath(longform, u,d,n,e);
        ELSE
            Str.Copy(S, entry.Name);
            Lib.SplitAllPath(S,u,d,n,e);
        END;
        (* Lib.MakeAllPath(S,"","",n,e); *)
        Str.Subst(e,dot,""); (* str.Delete(e,0,1) too *)

        dbgstr(DEBUG,"n",n);
        dbgstr(DEBUG,"e",e);

        CASE scanmode OF
        | scanattrib:
            dmp:= ( (attribs * entry.attr) # FIO.FileAttr{} ); (* set intersection *)
        | scanAlpha, scanAlphanum, scanAlphanumplus, scanAlphanumBlankPlus,
          scanLowerCase,scanlfn,scanonly :
            absent :=0;
            present:=0;
            strcount:=0;
            FOR j:=1 TO 2 DO
                CASE j OF
                | 1 : str:=n;
                | 2 : str:=e;
                END;
                IF NOT (keeporgcase) THEN LowerCase(str);END;
                slen   :=Str.Length(str);
                INC(strcount,slen);
                FOR i:=1 TO slen DO
                    IF Belongs(allowed,str[i-1]) THEN
                        INC(present);
                    ELSE
                        INC(absent);
                    END;
                END;
            END;
            CASE scanmode OF
            | scanonly,scanLowerCase: dmp := (present # 0);
            ELSE
                                      dmp := (absent # 0);
            END;
        | scanF8:                           (* -n:# *)
            dmp:= ( Str.Length(n) >= vmini );
        | scanE3:                           (* -e:# *)
            dmp:= ( Str.Length(e) >= vmini );
        | scanNotDOSpat:
            dmp:= ( (Str.Length(n)>f8len) OR (Str.Length(e) > e3len) );
        | scanDOSpatFit:
            dmp:= ( (Str.Length(n)>f8len) OR (Str.Length(e) > e3len) );
            dmp:=NOT(dmp);
        ELSE
            dmp:=FALSE; (* should never happen *)
        END;

        IF inverse THEN dmp:=NOT(dmp); END;

        IF dmp THEN
            Str.Copy(S,  fmtAttr(entry.attr) );
            Str.Append(S,"  ");
            Str.Concat(FN,basepath,entry.Name);
            IF useLFN THEN
                shortToLFN(longform, FN);
                IF (aD IN entry.attr) THEN fixDirectory(longform);END;
                Str.Append(S,dquote);
                Str.Append(S,longform);
                Str.Append(S,dquote);
            ELSE
                IF ucase THEN
                    ; (* leave it as is *)
                ELSE
                   LowerCase(FN);
                END;
                IF (aD IN entry.attr) THEN fixDirectory(FN);END;
                Str.Append(S,FN);
            END;
            WrStr(S); WrLn;
            INC(count);
        END;
        found:=FIO.ReadNextEntry(entry);
    END;
END scanName;

(* ------------------------------------------------------------ *)
(* ------------------------------------------------------------ *)

PROCEDURE quoted (S:str128  ):str128;
BEGIN
    Str.Prepend(S,dquote);
    Str.Append(S,dquote);
    RETURN S;
END quoted;

PROCEDURE quotedLFN (S:pathtype  ):pathtype;
BEGIN
    Str.Prepend(S,dquote);
    Str.Append(S,dquote);
    RETURN S;
END quotedLFN;

PROCEDURE fixQuotedString (VAR S:ARRAY OF CHAR);
VAR
    n,len:CARDINAL;
BEGIN
    n:=0;
    IF Str.Match(S,dquote+"*"+dquote) THEN INC(n);END;
    IF Str.Match(S,singlequote+"*"+singlequote) THEN INC(n);END;
    IF n # 0 THEN
        Str.Delete(S,0,1); (* first doublequote *)
        len:=Str.Length(S);
        Str.Delete(S,len-1,1);
    END;
END fixQuotedString;

(*
    default and R are already directory fixed and in uppercase
*)

PROCEDURE chkLegalSpec (VAR R:ARRAY OF CHAR;
                       LFNhere:BOOLEAN;defaultdir:ARRAY OF CHAR):BOOLEAN;
VAR
    rc,i:CARDINAL;
    u,d,n,e:str128; (* "u:" "\*\" "" "" *)
    longform,dosform:pathtype;
BEGIN
    fixQuotedString(R);
    IF same(R,dot) THEN Str.Copy(R,defaultdir);END;
    fixDirectory(R); (* add trailing \ if required *)
    IF chkJoker(R) THEN RETURN FALSE; END;
    IF Str.Pos(R,netslash) # MAX(CARDINAL) THEN RETURN FALSE; END;
    CASE CharCount(R,colon) OF
    | 0 : ;
    | 1 : IF Str.CharPos(R,colon) # 1 THEN RETURN FALSE; END; (* only "?:*" allowed *)
    ELSE
        RETURN FALSE;
    END;
    Str.Copy(longform,R);
    IF LFNhere THEN
        LFNtoShort(dosform, longform);
        Str.Copy(R,dosform);
        UpperCase(R);
        (*
        FOR i := 1 TO Str.Length(R) DO
            IF Belongs(alphanumplusSet+backslash+colon,R[i-1])=FALSE THEN RETURN FALSE;END;
        END;
        *)
    END;
    IF Str.Match(R,"?:\*") THEN RETURN TRUE;END;
    IF Str.Match(R,"\*") THEN
        Str.Prepend(R,colon);
        Str.Prepend(R,defaultdir[0]);
        RETURN TRUE;
    END;
    Str.Prepend(R,defaultdir);

    RETURN TRUE;
END chkLegalSpec;


(* ------------------------------------------------------------ *)

PROCEDURE getCli (VAR S : ARRAY OF CHAR);
CONST
    nullchar = CHR(0);
VAR
    i : CARDINAL;
BEGIN
    i := 0;
    LOOP
        S[i] := Lib.CommandLine^[i];
        IF S[i] = nullchar THEN EXIT; END;
        INC(i);
    END;
    cleantabs(S); (* always remove tabs *)
END getCli;

PROCEDURE argc (cli : ARRAY OF CHAR; clean : BOOLEAN) : CARDINAL;
VAR
    state    : (empty,intoken,instring);
    cliLen   : CARDINAL;
    cliPos   : CARDINAL;
    argCount : CARDINAL;
    ch       : CHAR;
    code     : CARDINAL;
    arg      : str128;
    sdelim   : CARDINAL;
BEGIN
    IF clean THEN
        LtrimBlanks(cli);
        RtrimBlanks(cli);
    END;
    cliLen   := Str.Length(cli);
    cliPos   := 1;
    argCount := 0;
    state    := empty;
    LOOP
        IF cliPos > cliLen THEN EXIT; END;
        ch := cli[cliPos-1];
        code := ORD(ch);
        CASE state OF
        | empty :
            IF ( (code = ORD(dquote)) OR (code=ORD(singlequote)) ) THEN
                sdelim:= code;
                state := instring;        (* begin new string *)
                Str.Copy(arg,ch);
                INC(argCount);
            ELSIF code > ORD(blank) THEN  (* quote already trapped *)
                state := intoken;         (* begin new token *)
                Str.Copy(arg,ch);
                INC(argCount);
            END;
        | intoken :
            IF ( (code = ORD(dquote)) OR (code=ORD(singlequote)) ) THEN (* quote in token *)
                sdelim:= code; (* fix *)
                state := instring;        (* if string in parameter *)
                Str.Append(arg,ch);
            ELSIF code > ORD(blank) THEN
                Str.Append(arg,ch);
            ELSE
                state := empty;           (* end of token *)
            END;
        | instring :
            IF code = sdelim THEN
                Str.Append(arg,ch);
                state := empty;           (* end of string *)
            ELSIF code > ORD(blank) THEN
                Str.Append(arg,ch);
            ELSE
                Str.Append(arg,blank);    (* remove TAB and controls if any *)
            END;
        END;
        INC(cliPos);
    END;
    RETURN argCount;
END argc;

PROCEDURE argv (VAR argument : ARRAY OF CHAR;
                cli : ARRAY OF CHAR; n : CARDINAL; clean:BOOLEAN);
VAR
    state    : (empty,intoken,instring);
    cliLen   : CARDINAL;
    cliPos   : CARDINAL;
    argCount : CARDINAL;
    ch     : CHAR;
    code     : CARDINAL;
    arg      : str128;
    sdelim   : CARDINAL;
BEGIN
    IF ( (n < 1) OR (n > argc(cli,clean)) ) THEN
        Str.Copy(argument,"");
        RETURN;
    END;
    IF clean THEN
        LtrimBlanks(cli);
        RtrimBlanks(cli);
    END;
    cliLen   := Str.Length(cli);
    cliPos   := 1;
    argCount := 0;
    state    := empty;
    LOOP
        IF cliPos > cliLen THEN EXIT; END;
        ch := cli[cliPos-1];
        code := ORD(ch);
        CASE state OF
        | empty :
            IF n = argCount THEN EXIT; END; (* argV$ test *)
            IF ( (code = ORD(dquote)) OR (code=ORD(singlequote)) ) THEN
                sdelim:= code;
                state := instring;        (* begin new string *)
                Str.Copy(arg,ch);
                INC(argCount);
            ELSIF code > ORD(blank) THEN  (* quote already trapped *)
                state := intoken;         (* begin new token *)
                Str.Copy(arg,ch);
                INC(argCount);
            END;
        | intoken :
            IF ( (code = ORD(dquote)) OR (code=ORD(singlequote)) ) THEN (* quote in token *)
                sdelim:= code; (* fix *)
                state := instring;        (* if string in parameter *)
                Str.Append(arg,ch);
            ELSIF code > ORD(blank) THEN
                Str.Append(arg,ch);
            ELSE
                state := empty;           (* end of token *)
            END;
        | instring :
            IF code = sdelim THEN
                Str.Append(arg,ch);
                state := empty;           (* end of string *)
            ELSIF code > ORD(blank) THEN
                Str.Append(arg,ch);
            ELSE
                Str.Append(arg,blank);    (* remove TAB and controls if any *)
            END;
        END;
        INC(cliPos);
    END;
    Str.Copy(argument,arg);
END argv;

(* ------------------------------------------------------------ *)
(* ------------------------------------------------------------ *)

PROCEDURE newcmd (VAR cmd:scanmodetype; specified:scanmodetype  ):BOOLEAN;
VAR
     ok:BOOLEAN;
BEGIN
     ok:=TRUE;
     IF cmd=scandefault THEN
          cmd:=specified;
     ELSIF cmd=specified THEN
          ;
     ELSE
         ok:=FALSE;
     END;
     RETURN ok;
END newcmd;

PROCEDURE chkRange ( v:LONGCARD ):BOOLEAN;
CONST
    maxLFN = 260;
BEGIN
    IF v < 0 THEN RETURN FALSE;END;
    IF v > maxLFN THEN RETURN FALSE;END;
    RETURN TRUE;
END chkRange;

PROCEDURE val2str (v:LONGCARD ; wi:CARDINAL;padchar:CHAR):str16;
VAR
    R:str16;
    ok:BOOLEAN;
    i:CARDINAL;
BEGIN
    Str.CardToStr(v,R,10,ok);
    IF ok=FALSE THEN R:="???";END;
    FOR i:=Str.Length(R)+1 TO wi DO Str.Prepend(R,padchar);END;
    RETURN R;
END val2str;

PROCEDURE wrbool (tf:BOOLEAN;T,F:ARRAY OF CHAR   );
BEGIN
    IF tf THEN
        WrStr(T);
    ELSE
        WrStr(F);
    END;
END wrbool;

(* ------------------------------------------------------------ *)
(* ------------------------------------------------------------ *)

CONST
    prefix             = "::: ";
    msgDOSpatFit       = "names fitting "+dospat+" DOS pattern";
    msgNotDOSpat       = "names not fitting "+dospat+" DOS pattern";
    msgAttrib          = "files with any valid attribute";
    msgInCharset       = "names with characters absent from specified sets";
    msgLC              = "names with at least one lowercase character";
    msgUser            = "names with at least one user-defined character";
CONST
    msgCondition       = prefix+"Match condition  : ";
    msgInverse         = prefix+"Inverse results  : ";
    msgAllowed         = prefix+"Character set    : ";
    msgUserAllowed     = prefix+"User-defined set : ";
CONST
    msgAttr            = prefix+"Valid attributes :";  (* +1 space *)
    msgForceLowerCase  = prefix+"Forced lowercase : ";
    msgRecurse         = prefix+"Recursive scan   : ";
    msgScanned         = prefix+"Directory ~     : ";  (* 2 digits *)
    msgMatching        = prefix+"Matching entries : ";
CONST
    msgF8len           = "name with length equal or longer than ~";
    msgE3len           = "extension with length equal or longer than ~";

CONST
    firstSpec = 1;
    maxSpec   = 16; (* was A..Z at most *)
VAR
    i, j, parmcount,opt : CARDINAL;
    cli,S,R             : pathtype;
    sAllowed,sUserAllowed,sCondition:str128;
    spec            : ARRAY [firstSpec..maxSpec] OF pathtype;
    lastSpec        : CARDINAL;
    dircount        : CARDINAL;
    foundcount,prevfoundcount : LONGCARD; (* was CARDINAL *)
    wanted          : FIO.FileAttr;
    keeporgcase,uppercase,inverse,recurse,terse,useLFN,LFNhere,DEBUG: BOOLEAN;
    stdset,allowed,userallowed : str128;
    currdrive       : SHORTCARD;
    currdir         : str128;
    defaultdir      : str128;
    lastPath        : CARDINAL;
    scanmode        : scanmodetype;
    v               : LONGCARD;
BEGIN
    (* Lib.DisableBreakCheck(); *)
    FIO.IOcheck := FALSE;

    WrLn; (* here now for ulterior help, error, etc. display *)

    lastSpec    := firstSpec-1;
    wanted      := FIO.FileAttr{};
    scanmode    := (scandefault);
    uppercase   := FALSE;
    keeporgcase := FALSE;
    recurse     := TRUE;
    inverse     := FALSE;
    useLFN      := TRUE;
    userallowed := "";
    terse       := FALSE;
    DEBUG       := FALSE;

    v           := 0;   (* useless safety *)

    getCli(cli);

    parmcount := argc(cli,TRUE); (* was Lib.ParamCount() *)
    IF parmcount=0 THEN abort(errHelp,""); END;

    currdrive := FIO.GetDrive(); (* 1=A, etc. *)
    FIO.GetDir(currdrive,currdir); (* we could use 0 for default drive *)
    (* we have unit letter and "\xxx" directory now *)

    Str.Copy(defaultdir,CHR(ORD("A")-1+currdrive));
    Str.Append(defaultdir,colon);
    Str.Append(defaultdir,currdir);
    UpperCase(defaultdir); (* probably useless *)
    fixDirectory(defaultdir);      (* add required trailing "\" *)


    FOR i := 1 TO parmcount DO
        (* v1.0h fix
        Lib.ParamStr(S,i);
        RtrimBlanks(S); (* yet another TopSpeed bug ! *)
        *)
        argv(S,cli,i,TRUE);
        Str.Copy(R,S);
        UpperCase(R);
        IF isOption(R) THEN
            opt := GetOptIndex(R,"?"+delim+"HELP"+delim+
                                 "H"+delim+"HIDDEN"+delim+
                                 "S"+delim+"SYSTEM"+delim+
                                 "V"+delim+"VOLUME"+delim+
                                 "R"+delim+"READONLY"+delim+
                                 "U"+delim+"UPPERCASE"+delim+
                                 "A"+delim+"ALPHA"+delim+
                                 "Z"+delim+"AA"+delim+
                                 "N"+delim+"NORECURSION"+delim+
                                 "U:"+delim+"USER:"+delim+
                                 "O"+delim+"ONLY"+delim+
                                 "L"+delim+"LFN"+delim+
                                 "W"+delim+"AAAAA"+delim+
                                 "O:"+delim+"ONLY:"+delim+
                                 "K"+delim+"KEEPORGCASE"+delim+
                                 "F"+delim+"AAA"+delim+
                                 "C"+delim+"NOTDOS"+delim+
                                 "B"+delim+"AAAA"+delim+
                                 "N:"+delim+"NAME:"+delim+"F8:"+delim+
                                 "E:"+delim+"EXTENSION:"+delim+"E3:"+delim+
                                 "D"+delim+"DOS"+delim+
                                 "J"+delim+"LOWERCASE"+delim+
                                 "I"+delim+"INVERSE"+delim+
                                 "T"+delim+"TERSE"+delim+
                                 "DEBUG"
                              );
            CASE opt OF
            | 1,2 : abort(errHelp,"");
            | 3,4 : INCL( wanted,aH );
            | 5,6 : INCL( wanted,aS );
            | 7,8 : INCL( wanted,aV );
            | 9,10: INCL( wanted,aR );
            |11,12: uppercase    := TRUE;
            |13,14: IF newcmd(scanmode,scanAlpha)=FALSE THEN abort(errNonsense,"");END;
            |15,16: IF newcmd(scanmode,scanAlphanum)=FALSE THEN abort(errNonsense,"");END;
            |17,18: recurse      := FALSE;
            |19,20: GetString(S,userallowed);
                    fixQuotedString(userallowed);
            |21,22: IF newcmd(scanmode,scanonly)=FALSE THEN abort(errNonsense,"");END;
            |23,24: useLFN       := FALSE;
            |25,26: IF newcmd(scanmode,scanlfn)=FALSE THEN abort(errNonsense,"");END;

            |27,28: GetString(S,userallowed);
                    fixQuotedString(userallowed);
                    IF newcmd(scanmode,scanonly)=FALSE THEN abort(errNonsense,"");END;
            |29,30: keeporgcase:=TRUE;
            |31,32: IF newcmd(scanmode,scanAlphanumplus)=FALSE THEN abort(errNonsense,"");END;

            |33,34: IF newcmd(scanmode,scanNotDOSpat)=FALSE THEN abort(errNonsense,"");END;
            |35,36: IF newcmd(scanmode,scanAlphanumBlankPlus)=FALSE THEN abort(errNonsense,"");END;
            |37,38,39: IF newcmd(scanmode,scanF8)=FALSE THEN abort(errNonsense,"");END;
                       IF GetLongCard(R,v)=FALSE THEN abort(errLC,S);END;
                       IF chkRange(v)=FALSE THEN abort(errRange,S);END;
            |40,41,42: IF newcmd(scanmode,scanE3)=FALSE THEN abort(errNonsense,"");END;
                       IF GetLongCard(R,v)=FALSE THEN abort(errLC,S);END;
                       IF chkRange(v)=FALSE THEN abort(errRange,S);END;
            |43,44: IF newcmd(scanmode,scanDOSpatFit)=FALSE THEN abort(errNonsense,"");END;
            |45,46: IF newcmd(scanmode,scanLowerCase)=FALSE THEN abort(errNonsense,"");END;
                    keeporgcase:=TRUE;
            |47,48: inverse:=TRUE;
            |49,50: terse:=TRUE;
            |51:    DEBUG:=TRUE;
            ELSE
                abort(errOption,S);
            END;
        ELSE
            INC(lastSpec);
            IF lastSpec > maxSpec THEN abort(errTooManyParms,""); END;
            Str.Copy( spec[lastSpec] , S );
       END;
    END;
    IF lastSpec < firstSpec THEN abort(errNeedSpec,"");END;

    LFNhere:=w9XsupportLFN();
    useLFN := ( useLFN AND LFNhere );
    FOR i:=firstSpec TO lastSpec DO
         Str.Copy(S, spec[i]);
         (* change shortform S according to defaultdir if needed *)
         IF chkLegalSpec(S,LFNhere,defaultdir) = FALSE THEN abort(errBadSpec,quotedLFN(S)); END;
         Str.Copy( spec[i] , S );
    END;

    CASE scanmode OF
    | scanAlpha, scanAlphanum, scanAlphanumplus, scanAlphanumBlankPlus,
      scanF8, scanE3, scanlfn, scanonly,scanNotDOSpat,scanDOSpatFit,scanLowerCase :
        IF scanmode = scanonly THEN
            IF same(userallowed,"") THEN abort(errUserNeeded,"");END;
        END;
        IF wanted # FIO.FileAttr{} THEN abort(errUseless,"");END;
        wanted := reallyeverything;
    | scandefault:
        IF same(userallowed,"")=FALSE THEN abort(errNotHere,"");END;
        IF wanted = FIO.FileAttr{} THEN wanted:= FIO.FileAttr{aH,aS,aV}; END;
        scanmode:=scanattrib;
    END;

    CASE scanmode OF
    | scanNotDOSpat :
        IF useLFN=FALSE THEN abort(errWin9Xonly,"-c");END;
    | scanDOSpatFit :
        IF useLFN=FALSE THEN abort(errWin9Xonly,"-d");END;
    | scanLowerCase:
        ; (* IF useLFN=FALSE THEN abort(errWin9Xonly,"-j");END; what about hexeditor, eh ! *)
    END;

    (*
    WrStr(Banner);WrLn;
    WrLn;
    *)

    (* v may contain 0 or vmini *)

    CASE scanmode OF
    | scanAlpha:             stdset:=alphaSet;
    | scanAlphanum :         stdset:=alphanumSet;
    | scanAlphanumplus :     stdset:=alphanumplusSet;
    | scanAlphanumBlankPlus: stdset:=alphanumBlankPlusSet;
    | scanlfn :              stdset:=lfnSet;
    | scanonly :             stdset:=userallowed;
    | scanLowerCase:         stdset:=lettersLows;
    ELSE
                             stdset :="";
                             allowed:=""; (* scanF8,scanE3,scanNotDOSpat,scanDOSpatFit,scanattrib *)
    END;
    Str.Concat(allowed,stdset,userallowed);

    (* show conditions *)

  IF NOT(terse) THEN
    WrStr(msgCondition);
    CASE scanmode OF
    | scanF8:        S:=msgF8len; Str.Subst(S,"~",val2str(v,1,blank));
    | scanE3:        S:=msgE3len; Str.Subst(S,"~",val2str(v,1,blank));
    | scanDOSpatFit: S:=msgDOSpatFit;
    | scanNotDOSpat: S:=msgNotDOSpat;
    | scanattrib:    S:=msgAttrib;
    | scanLowerCase: S:=msgLC;
    | scanonly:      S:=msgUser;
    ELSE
                     S:=msgInCharset;
    END;
    WrStr(S);WrLn;

    WrStr(msgInverse);wrbool(inverse,"yes","no");WrLn;

    Str.Concat(sAllowed,msgAllowed,quoted(stdset));
    Str.Concat(sUserAllowed,msgUserAllowed,quoted(userallowed));
    WrStr(sAllowed);WrLn;
    WrStr(sUserAllowed);WrLn;

    WrStr(msgAttr);
    IF (aH IN wanted) THEN WrStr(" hidden"); END;
    IF (aS IN wanted) THEN WrStr(" system"); END;
    IF (aV IN wanted) THEN WrStr(" volume"); END;
    IF (aR IN wanted) THEN WrStr(" read-only"); END;
    WrLn;
    WrStr(msgForceLowerCase);wrbool( NOT(keeporgcase),"yes","no");WrLn;
    WrStr(msgRecurse);wrbool(recurse,"yes","no");WrLn;
    FOR i := firstSpec TO lastSpec DO
        S:=msgScanned;
        IF lastSpec = firstSpec THEN
            R:="  ";
        ELSE
            Str.Copy(R,val2str( LONGCARD(i),2,blank ));
        END;
        Str.Subst(S,"~",R);
        WrStr(S);
        IF useLFN THEN WrStr(dquote);END;
        WrStr(spec[i]);
        IF useLFN THEN WrStr(dquote);END;
        WrLn;
    END;
    WrLn;
  END;
    foundcount := 0;

    FOR i := firstSpec TO lastSpec DO
        prevfoundcount := foundcount;
        Str.Copy(S,spec[i]);
        IF recurse THEN
            dircount := BuildPathList(S);
            IF dircount=MAX(CARDINAL) THEN abort(errTooManyDirs,S);END;
        ELSE
            dircount := 1;
            IF setentry(1, S)=FALSE THEN abort(errStorage,S);END;
        END;
        FOR j := 1 TO dircount DO
            scanName (allowed,retrieveentry(j),
                      useLFN,uppercase,keeporgcase,inverse,DEBUG,
                      scanmode,wanted,  CARDINAL(v),   foundcount);
            IF ChkEscape() THEN
                IF recurse THEN freePathList(dircount);END;
                abort(errAborted,"");
            END;
        END;
        IF foundcount # prevfoundcount THEN
            IF NOT(terse) THEN WrLn; END;
        END;
    END;

    IF recurse THEN freePathList(dircount);END;

  IF NOT(terse) THEN
    WrStr(msgMatching); IO.WrLngCard(foundcount,1);WrLn;
  END;

    abort(errNone,"");
END DirWeird.




(*

set _d_=d:\z
set _t_=old
set _p_=c:\bat\dirweird

%_p_% \ /a       > %_d_%\%_t_%a
%_p_% \ /aa      > %_d_%\%_t_%aa
%_p_% \ /aaa     > %_d_%\%_t_%aaa
%_p_% \ /aaaa    > %_d_%\%_t_%aaaa
%_p_% \ /aaaaa   > %_d_%\%_t_%aaaaa
%_p_% \ /c       > %_d_%\%_t_%c
%_p_% \ /d       > %_d_%\%_t_%d
%_p_% \ /j       > %_d_%\%_t_%j
%_p_% \ /n:2     > %_d_%\%_t_%n2
%_p_% \ /e:2     > %_d_%\%_t_%e2
%_p_% \ /o:~     > %_d_%\%_t_%otilde

set _d_=d:\z
set _t_=new
set _p_=c:\modula\dirweird

%_p_% \ /a       > %_d_%\%_t_%a
%_p_% \ /aa      > %_d_%\%_t_%aa
%_p_% \ /aaa     > %_d_%\%_t_%aaa
%_p_% \ /aaaa    > %_d_%\%_t_%aaaa
%_p_% \ /aaaaa   > %_d_%\%_t_%aaaaa
%_p_% \ /c       > %_d_%\%_t_%c
%_p_% \ /d       > %_d_%\%_t_%d
%_p_% \ /j       > %_d_%\%_t_%j
%_p_% \ /n:2     > %_d_%\%_t_%n2
%_p_% \ /e:2     > %_d_%\%_t_%e2
%_p_% \ /o:~     > %_d_%\%_t_%otilde

set _p_=
set _t_=
set _d_=


*)

