(* ---------------------------------------------------------------
Title         Q&D Directories Compare
Overview      see help
Usage         see help
Notes         very, very, very quick & dirty... :-(
              minimal error messages and checking, etc.
              original filename was DIRCOMP, but there's already
              an utility with this very filename, so...
              note FIO.DirEntry.PathTail is [0..12],
              while our f8e3 is [0..8+1+3-1] i.e. [0..11] !
Bugs
Wish List     show size, date, time too ?

--------------------------------------------------------------- *)

MODULE DComp;

IMPORT Lib;
IMPORT FIO;
IMPORT Str;
IMPORT SYSTEM;
IMPORT IO;

FROM IO IMPORT WrStr, WrLn;

FROM Storage IMPORT Available,ALLOCATE,DEALLOCATE;

FROM QD_Box IMPORT str80, str2, cmdInit, cmdShow, cmdStop, delim,
Work, video, Ltrim, Rtrim, UpperCase, LowerCase, ReplaceChar,
ChkEscape, Waitkey, WaitkeyDelay, Flushkey, IsRedirected, chkJoker,
isOption, GetOptIndex, GetLongCard, GetLongInt, GetString, CharCount,
same, aR, aH, aS, aD, aA, everything, isDirectory, fixDirectory,
str128, str256, Animation, allfiles, Belongs, FixAE, CodePhonetic,
CodeSoundex, CodeSoundexOrg, isReadOnly, LtrimBlanks, RtrimBlanks,
getStrIndex, cmdSHOW,BiosWaitkey,BiosWaitkeyShifted,BiosFlushkey,
str1024, isoleItemS, dmpTTX, str2048, Elapsed, TerminalReadString,
getDosVersion, DosVersion, warning95, runningWindows,
aV, reallyeverything, chkClassicTextMode, setClassicTextMode,
AltAnimation, str16, getCurrentDirectory, setReadWrite, setReadOnly,
getFileSize, verifyString, str4096, unfixDirectory,
animShow, animSHOW, animAdvance, animEnd, animClear,
animInit, animGetSdone, anim, cleantabs, UpperCaseAlt, LowerCaseAlt,
completedInit, completedShow, completedSHOW, completedEnd, completed,
removeDups, isValidHDunit, removePhantoms, removeFloppies,
getCDROMunits, getCDROMletters, removeCDROMs, getAllHDunits,
getAllLegalUnits;

FROM QD_LFN IMPORT path9X, huge9X, findDataRecordType,
unicodeConversionFlagType, w9XchangeDir,
w9XgetDOSversion, w9XgetTrueDOSversion, w9XisWindowsEnh, w9XisMSDOS7,
w9XfindFirst, w9XfindNext, w9XfindClose, w9XgetCurrentDirectory,
w9XlongToShort, w9XshortToLong, w9XtrueName, w9XchangeDir,
w9XmakeDir, w9XrmDir, w9Xrename, w9XopenFile, w9XcloseFile,
w9XsupportLFN;

FROM QD_File IMPORT pathtype, w9XnothingRequired,
fileOpenRead, fileOpen, fileExists, fileIsRO, fileSetRW, fileSetRO,
fileErase, fileCreate, fileRename, fileGetFileSize, fileGetFileStamp,
fileIsDirectorySpec, fileClose;

(* ------------------------------------------------------------ *)

CONST
    cr              = CHR(13);
    lf              = CHR(10);
    nl              = cr+lf;
    backslash       = "\";
    star            = "*";
    dot             = ".";
    dotdot          = "..";
    colon           = ":";
    stardotstar     = "*.*";
    dquote          = '"';
    nullchar        = CHR(0);
    maxpadwidth     = 80;
    FROZEN          = TRUE;
CONST
    chRedirIn       = "<";
    chRedirOut      = ">";
    chNewIn         = "[";
    chNewOut        = "]";
CONST
    ProgEXEname     = "DCOMP";
    ProgTitle       = "Q&D Directories Compare";
    ProgVersion     = "v1.0k";
    ProgCopyright   = "by PhG";
    Banner          = ProgTitle+" "+ProgVersion+" "+ProgCopyright;

CONST
    errNone         = 0;
    errHelp         = 1;
    errOption       = 2;
    errParameter    = 3;
    errMissing      = 4;
    errSyntax       = 5;
    errBadDir       = 6;
    errSameDirs     = 7;
    errTooManyMatches=8; (* storage ALLOCATE failure *)
    errEitherOr     = 9;
    errEitherOrDel  = 10;
    errList         = 11;
    errListCmd      = 12;
    errUnique       = 13;
    errEitherBiggerOrSame = 14;
    errEitherNewerOrSame  = 15;
    errBadInt             = 16;
    errRangeInt           = 17;
    errDelVerbose         = 18;

(* ------------------------------------------------------------ *)

PROCEDURE abort (e : CARDINAL; einfo : ARRAY OF CHAR);
CONST
(*
 00000000011111111112222222222333333333344444444445555555555666666666677777777778
 1...'....0....'....0....'....0....'....0....'....0....'....0....'....0....'....0
*)

errmsg =
Banner+nl+
nl+
"Syntax : "+ProgEXEname+" <directory1> <directory2> [option]..."+nl+
nl+
"This program compares two directories for common and unique filenames."+nl+
nl+
"-c[c] list filenames common to both directories"+nl+
"      (-cc = add DEL prefix and format display for batch)"+nl+
"-u    list filenames unique in each directory"+nl+
"-l[l] list filenames from <dir1> without match in <dir2>"+nl+
"      for later use by Novell DOS or DR-DOS XCOPY or MOVE commands"+nl+
"      (-ll = list filenames without directory prefix)"+nl+
"-z    match using filesizes too (default is to match using filenames only)"+nl+
"-n[n] list <dir1> files newer than <dir2> files (-c forced, -nn = -n -b)"+nl+
"-b[b] list <dir1> files bigger than <dir2> files (-c forced, -bb = -b -n)"+nl+
"-a    alternate filename display (DOS only)"+nl+
"-w:#  padding formatting value"+nl+
"-v    verbose listing"+nl+
"-p    prefix filenames with directory"+nl+
"-x    disable LFN support even if available"+nl+
nl+
"Default options : -c -u."+nl+
nl+
"Examples : "+ProgEXEname+" c:\bat f:\backup\bat /u"+nl+
"           "+ProgEXEname+" c:\z\newbat c:\bat /c /n /b"+nl;

VAR
    S : str256;
BEGIN
    CASE e OF
    | errHelp :
        WrStr(errmsg);
    | errOption:
        Str.Concat(S,"Unknown ",einfo);Str.Append(S," option !");
    | errParameter:
        Str.Concat(S,einfo," parameter is one too many !");
    | errMissing:
        Str.Concat(S,"Missing ",einfo);Str.Append(S," !");
    | errSyntax :
        S:="Illegal syntax !";
    | errBadDir:
        Str.Concat(S,"Illegal or not found ",einfo);Str.Append(S," directory specification !");
    | errSameDirs:
        S:= "<directory1> and <directory2> must be different !";
    | errTooManyMatches :
        Str.Concat(S,"Too many files match ",einfo);
        Str.Append(S,stardotstar+" specification !");
    | errEitherOr:
        S :="-p and -a options are mutually exclusive !";
    | errEitherOrDel:
        S :="-p and -cc options are mutually exclusive !";
    | errList:
        Str.Concat(S,einfo," option is a nonsense with -l option !");
    | errListCmd:
        S:="-l option support optional -z option only !";
    | errUnique:
        Str.Concat(S,einfo," option is a nonsense with -u option !");
    | errEitherBiggerOrSame:
        S := "-z and -b options are mutually exclusive !";
    | errEitherNewerOrSame:
        S := "-z and -n options are mutually exclusive !";
    | errBadInt:
        Str.Concat(S,"Illegal ",einfo);Str.Append(S," value !");
    | errRangeInt:
        Str.Concat(S,"Out of range ",einfo);Str.Append(S," value !");
    | errDelVerbose:
        S := "-v option is a nonsense with -cc option !";
    ELSE
        S := "This is illogical, Captain !";
    END;
    CASE e OF
    | errNone,errHelp: ;
    ELSE
        WrStr(ProgEXEname+" : ");WrStr(S);WrLn;
    END;
    Lib.SetReturnCode(SHORTCARD(e));
    HALT;
END abort;

(* ------------------------------------------------------------ *)
(* ------------------------------------------------------------ *)

TYPE
    pFname = POINTER TO fnameType;
    fnameType = RECORD
        next      : pFname;
        fsize     : LONGCARD;
        fdate     : CARDINAL;
        ftime     : CARDINAL;
        slen      : SHORTCARD;
        str       : CHAR;
    END;

PROCEDURE initList (VAR anchor : pFname );
BEGIN
    anchor := NIL;
END initList;

PROCEDURE freeFileList (anchor : pFname);
VAR
    needed : CARDINAL;
    p      : pFname;
BEGIN
    (* p:=anchor; *)
    WHILE anchor # NIL DO
        needed := SIZE(fnameType) - SIZE(anchor^.str) + CARDINAL(anchor^.slen);
        p := anchor^.next;
        DEALLOCATE(anchor,needed);
        anchor:=p;
    END
END freeFileList;

PROCEDURE buildNewPtr (VAR anchor,p:pFname; len:CARDINAL):BOOLEAN;
VAR
    needed : CARDINAL;
BEGIN
    needed := SIZE(fnameType) - SIZE(p^.str) + len;
    IF Available(needed)=FALSE THEN RETURN FALSE; END;
    IF anchor = NIL THEN
        ALLOCATE(anchor,needed);
        p:=anchor;
    ELSE
        p:=anchor;
        WHILE p^.next # NIL DO
            p:=p^.next;
        END;
        ALLOCATE(p^.next,needed);
        p:=p^.next;
    END;
    p^.next := NIL;
    RETURN TRUE;
END buildNewPtr;

(* assume p is valid *)

PROCEDURE getfilenameentry (VAR S : pathtype; p:pFname);
VAR
    len:CARDINAL;
BEGIN
    len := CARDINAL(p^.slen);
    Lib.FastMove( ADR(p^.str),ADR(S),len);
    S[len] := nullchar; (* REQUIRED safety ! *)
END getfilenameentry;

PROCEDURE getdataentry (VAR fsize:LONGCARD; VAR fdate,ftime:CARDINAL; p:pFname);
BEGIN
    fsize := p^.fsize;
    fdate := p^.fdate;
    ftime := p^.ftime;
END getdataentry;

(* ------------------------------------------------------------ *)

PROCEDURE isReservedEntry (S:ARRAY OF CHAR) : BOOLEAN;
BEGIN
    IF same(S,dot) THEN RETURN TRUE; END;
    RETURN same(S,dotdot);
END isReservedEntry;

(* no recursion here *)

PROCEDURE buildFileList (VAR anchor:pFname;useLFN:BOOLEAN;orgspec:pathtype):CARDINAL;
VAR
    count:CARDINAL; (* should do ! *)
    ok,found:BOOLEAN;
    unicodeconversion:unicodeConversionFlagType;
    w9Xentry : findDataRecordType;
    w9Xhandle,errcode:CARDINAL;
    entry : FIO.DirEntry;
    dosattr:FIO.FileAttr;
    spec,entryname:pathtype;
    len : CARDINAL;
    pp:pFname;
    fsize:LONGCARD;
    stampdate,stamptime:CARDINAL;
BEGIN
    Str.Concat(spec,orgspec,stardotstar);
    count:=0;
    IF useLFN THEN
        found := w9XfindFirst (spec,SHORTCARD(everything),SHORTCARD(w9XnothingRequired),
                              unicodeconversion,w9Xentry,w9Xhandle,errcode);
    ELSE
        found := FIO.ReadFirstEntry(spec,everything,entry);
    END;
    WHILE found DO
        IF useLFN THEN
            Str.Copy(entryname,w9Xentry.fullfilename);
        ELSE
            Str.Copy(entryname,entry.Name);
        END;
        IF isReservedEntry (entryname) = FALSE THEN (* skip "." AND ".." *)
            IF useLFN THEN
                dosattr:=FIO.FileAttr(w9Xentry.attr AND 0FFH);
                fsize     := w9Xentry.fsize.lo; (* no file should be more than 4Gb anyway ;-) *)
                (*
                QD_LFN calls win9XfindFirst requiring DOS format
                DOS date/time values in low double-word of file time QWORD
                (date is high word, time is low word of double-word)
                darn, it's not creation field but lastmod seems ok
                *)
                stampdate := CARDINAL(w9Xentry.lastmod.lo >> 16);
                stamptime := CARDINAL(w9Xentry.lastmod.lo AND 0FFFFH);
            ELSE
                dosattr   := entry.attr;
                fsize     := entry.size;
                stampdate := entry.date;
                stamptime := entry.time;
            END;

            IF NOT (aD IN dosattr) THEN
                (* if file has no extension, add it as a marker *)
                IF Str.RCharPos(entryname,".")=MAX(CARDINAL) THEN
                    Str.Append(entryname,".");
                END;
                len:=Str.Length(entryname);
                IF buildNewPtr(anchor,pp,len)=FALSE THEN
                    IF useLFN THEN ok:=w9XfindClose(w9Xhandle,errcode); END;
                    RETURN MAX(CARDINAL); (* errStorage *)
                END;
                INC(count);
                pp^.slen      := SHORTCARD(len);
                pp^.fsize     := fsize;
                pp^.fdate     := stampdate;
                pp^.ftime     := stamptime;
                Lib.FastMove ( ADR(entryname),ADR(pp^.str),len );
            END;
        END;
        IF useLFN THEN
            found :=w9XfindNext(w9Xhandle, unicodeconversion,w9Xentry,errcode);
        ELSE
            found :=FIO.ReadNextEntry(entry);
        END;
    END;
    IF useLFN THEN ok:=w9XfindClose(w9Xhandle,errcode); END;
    RETURN count;
END buildFileList;

PROCEDURE doGetCurrentDir (useLFN:BOOLEAN;drive:SHORTCARD;
                          VAR unit:str2; VAR current:pathtype);
VAR
    rc:CARDINAL;
    longform:pathtype;
BEGIN
    Str.Copy(unit, CHR(ORD("A")+drive-1) );
    Str.Append(unit,colon);

    FIO.GetDir(drive,current); (* \path without u: nor trailing \ except at root *)
    IF current[1] # colon THEN Str.Prepend(current,unit); END; (* safety *)
    IF useLFN THEN
        IF w9XshortToLong(current,rc,longform) THEN (* if error, keep DOS current *)
            Str.Copy(current,longform);
        END;
    END;
    (* LFN function seems to always return "u:\*" form except at root *)
    IF current[1] = colon THEN Str.Delete(current,0,2);END; (* safety *)
    fixDirectory(current);
END doGetCurrentDir;

PROCEDURE nice (useLFN:BOOLEAN;S:pathtype):pathtype;
VAR
    R:pathtype;
BEGIN
    IF useLFN THEN
        Str.Concat(R,dquote,S);
        Str.Append(R,dquote);
    ELSE
        Str.Copy(R,S);
    END;
    RETURN R;
END nice;

PROCEDURE pad (wi:INTEGER; VAR S:ARRAY OF CHAR );
VAR
    i:CARDINAL;
BEGIN
    FOR i:=Str.Length(S)+1 TO ABS(wi) DO
        IF wi < 0 THEN
            Str.Prepend(S," ");
        ELSE
            Str.Append(S," ");
        END;
    END;
END pad;

(* ------------------------------------------------------------ *)
(* ------------------------------------------------------------ *)

PROCEDURE using (n : CARDINAL; digits : CARDINAL; pad : CHAR) : str80;
VAR
    ok   : BOOLEAN;
    v    : LONGCARD;
    len  : CARDINAL;
    S    : str80;
BEGIN
    v := LONGCARD(n);
    Str.CardToStr(v,S,10,ok);
    len := Str.Length(S);
    LOOP
        IF Str.Length(S) >= digits THEN EXIT; END;
        Str.Prepend(S,pad);
    END;
    RETURN S;
END using;

PROCEDURE fmtSize (v:LONGCARD;pad,sep:CHAR):str16;
CONST
    field = 10+3; (* "#,###,###,###" *) (* what if file is one giga+, eh ? *)
VAR
    S,R   : str16;
    len,i : CARDINAL;
    ok  : BOOLEAN;
    ch  : CHAR;
BEGIN
    Str.CardToStr(v,S,10,ok);
    len:=Str.Length(S);
    R := "";
    FOR i := 1 TO len DO
        Str.Prepend(R,S[len-i]);
        IF i < len THEN
            IF (i MOD 3) = 0 THEN
                Str.Prepend(R,sep);
            END;
        END;
    END;
    LOOP
        IF INTEGER(Str.Length(R)) >= ABS(field) THEN EXIT; END;
        IF field < 0 THEN
            Str.Append(R,pad);  (* right alignment *)
        ELSE
            Str.Prepend(R,pad);
        END;
    END;
    RETURN R;
END fmtSize;

(*
Year stored relative to 1980 (ex. 1988 stores as 8)
    year      month    day   

 F E D C B A 9 8 7 6 5 4 3 2 1 0   <-- Bit Number
*)

PROCEDURE fmtDate (dmy:CARDINAL) : str16;
CONST
    yyMask=BITSET{9..15};
    yyShft=9;
    mmMask=BITSET{5..8};
    mmShft=5;
    ddMask=BITSET{0..4};
    ddShft=0;
    baseyear=1980;
    minmm = 1;
    maxmm = 12;
VAR
    R: str16;
    d,m,y:CARDINAL;
BEGIN
    y := CARDINAL(BITSET(dmy) * yyMask) >> yyShft;
    m := CARDINAL(BITSET(dmy) * mmMask) >> mmShft;
    d := CARDINAL(BITSET(dmy) * ddMask) >> ddShft;
    INC(y,baseyear);

    IF ((m < minmm) OR (m > maxmm)) THEN m := 13; END;

    R:="~-~-~";

    Str.Subst(R, "~" , using(d,2,"0"));
    Str.Subst(R, "~" , using(m,2,"0"));
    Str.Subst(R, "~" , using(y,4,"0"));

    RETURN R;
END fmtDate;

(*
Seconds are 0 to 29 -- DOS stores nearest even / 2
  hours    minutes   seconds 

 F E D C B A 9 8 7 6 5 4 3 2 1 0   <-- Bit Number
*)

PROCEDURE fmtTime (timedata:CARDINAL) : str16;
CONST
    hhMask=BITSET{11..15};
    hhShft=11;
    mmMask=BITSET{5..10};
    mmShft=5;
    ssMask=BITSET{0..4};
    ssShft=0;
VAR
    h,m,s : CARDINAL;
    R : str16;
BEGIN
    h := CARDINAL(BITSET(timedata) * hhMask) >> hhShft;
    m := CARDINAL(BITSET(timedata) * mmMask) >> mmShft;
    s := CARDINAL(BITSET(timedata) * ssMask) >> ssShft;
    s := s << 1; (* FIXED ! yes, yes, "* 2" works too... *)

    R := "~:~:~";
    Str.Subst(R, "~" , using(h,2," ") );
    Str.Subst(R, "~" , using(m,2,"0") );
    Str.Subst(R, "~" , using(s,2,"0") );

    RETURN R;
END fmtTime;

PROCEDURE fmtdata ( p:pFname ):str80;
VAR
    R:str80;
    fsize:LONGCARD;
    fdate,ftime:CARDINAL;
BEGIN
    getdataentry (fsize, fdate,ftime,   p);
    (* "#.###.###.###  jj-mm-yyyy  hh:mm:ss  " *)
    R := "~  ~  ~  ";
    Str.Subst (R, "~" , fmtSize(fsize," ",dot) );
    Str.Subst (R, "~" , fmtDate(fdate) );
    Str.Subst (R, "~" , fmtTime(ftime) );
    RETURN R;
END fmtdata;

PROCEDURE fmtdatadirect (fsize,stamp:LONGCARD ):str80;
VAR
    R : str80;
    fdate,ftime:CARDINAL;
BEGIN
    fdate := CARDINAL ( stamp >> 16 );
    ftime := CARDINAL ( stamp AND 0000FFFFH );
    R := "~  ~  ~  ";
    Str.Subst (R, "~" , fmtSize(fsize," ",dot) );
    Str.Subst (R, "~" , fmtDate(fdate) );
    Str.Subst (R, "~" , fmtTime(ftime) );
    RETURN R;
END fmtdatadirect;

(* ------------------------------------------------------------ *)
(* ------------------------------------------------------------ *)

PROCEDURE procDir (VAR R : pathtype;
                   useLFN:BOOLEAN;unit:str2;defaultDir:pathtype):BOOLEAN ;
BEGIN
    CASE R[0] OF
    | dot:
        IF same(R,dot) THEN Str.Concat(R,unit,defaultDir);END;
    | star:
        IF same(R,dot) THEN Str.Concat(R,unit,defaultDir);END;
    | backslash:
        Str.Prepend(R,unit);
    END;
    unfixDirectory(R);
    IF fileIsDirectorySpec(useLFN,R)=FALSE THEN RETURN FALSE;END;
    IF chkJoker(R) THEN RETURN FALSE;END;
    fixDirectory(R);
    RETURN TRUE;
END procDir;

CONST
    wipadf8e3 = -(8+1+3);
    padsep    = " : ";

PROCEDURE padf8e3 (wi:INTEGER; S:ARRAY OF CHAR; VAR R:ARRAY OF CHAR);
VAR
    u,d,f8,e3:str128;
    i : CARDINAL;
BEGIN
    Lib.SplitAllPath(S,u,d,f8,e3); (* e3 can be 0,1,2,3 ! *)
    IF same(e3,"") THEN Str.Append(e3,".");END;
    FOR i := (Str.Length(e3)+1) TO (3+1) DO
        Str.Append(e3," ");
    END;
    Str.Concat(R,f8,e3);
    FOR i:=(Str.Length(R)+1) TO ABS(wi) DO
        IF wi < 0 THEN
            Str.Prepend(R," ");
        ELSE
            Str.Append(R," ");
        END;
    END;
END padf8e3;

PROCEDURE fmtFilename (useLFN,alternate:BOOLEAN;padwidth:LONGCARD;VAR R:pathtype);
VAR
    S : pathtype;
BEGIN
    IF useLFN THEN
        Str.Copy(R, nice(useLFN,R) );
    ELSE
        IF NOT(alternate) THEN
            Str.Copy(S,R);
            padf8e3 (wipadf8e3,S,R);
        END;
    END;
    pad( INTEGER(padwidth), R);
END fmtFilename;

(*
Year stored relative to 1980 (ex. 1988 stores as 8)
    year      month    day   

 F E D C B A 9 8 7 6 5 4 3 2 1 0   <-- Bit Number

Seconds are 0 to 29 -- DOS stores nearest even / 2
  hours    minutes   seconds 

 F E D C B A 9 8 7 6 5 4 3 2 1 0   <-- Bit Number
*)

PROCEDURE chkMatch (VAR RR:str80;
                   DEBUG,usecommon,useLFN,
                   chksamefsize,commonnewer,commonbigger:BOOLEAN;
                   ptr:pFname;R:pathtype):BOOLEAN;
VAR
    match,newer,bigger:BOOLEAN;
    reffsize,refstamp:LONGCARD;
    reffdate:CARDINAL;
    refftime:CARDINAL;
    fsize   : LONGCARD;
    stamp   : LONGCARD;
BEGIN
    match := fileExists(useLFN,R);
    IF match THEN
        getdataentry(reffsize,reffdate,refftime, ptr);
        refstamp:=LONGCARD ( reffdate ) ;
        refstamp:=(refstamp << 16) + LONGCARD(refftime);
        (*
        IF DEBUG THEN
            WrStr("// ");IO.WrLngCard(reffsize,16);
            IO.WrLngHex(refstamp,10); WrLn;
        END;
        *)
        fsize:=fileGetFileSize(useLFN,R); (* always *)
        stamp:=fileGetFileStamp(useLFN,R);

        Str.Copy(RR, fmtdatadirect(fsize,stamp) );

        IF chksamefsize THEN
            match:=( fsize=reffsize );
        ELSE
            IF usecommon THEN
                (*
                IF DEBUG THEN
                    WrStr("-- ");IO.WrLngCard(fsize,16);
                    IO.WrLngHex(stamp,10); WrLn;
                END;
                *)
                IF commonnewer THEN
                    newer := ( refstamp > stamp );
(* IF DEBUG THEN IF newer THEN WrStr("newer");WrLn;END; END; *)
                    match := ( match AND newer );
                END;
                IF commonbigger THEN
                    bigger:= ( reffsize > fsize );
(* IF DEBUG THEN IF bigger THEN WrStr("bigger");WrLn;END; END; *)
                    match := ( match AND bigger );
                END;
            END;
        END;
    END;
    RETURN match;
END chkMatch;

(* ------------------------------------------------------------ *)
(* ------------------------------------------------------------ *)

CONST
    prefix            = "::: ";
    prefixbatch       = "REM ";
    smsgDir1          = "<directory1> : ";
    smsgDir2          = "<directory2> : ";
    smsgCommon        = "Filenames common to both directories...";
    smsgUnique        = "Filenames unique in each directory...";
    sDel              = "DEL ";
    smsgCommonSize    = "Filenames+filesizes common to both directories...";
    smsgUniqueSize    = "Filenames+filesizes unique in each directory...";
CONST
    smsgCommonNewer   = "<dir1> filenames newer than their <dir2> matches";
    smsgCommonBigger  = "<dir1> filenames bigger than their <dir2> matches";
    smsgCommonNewerBigger="<dir1> filenames newer and bigger than their <dir2> matches";
    smsgCannotHappen  = "This CANNOT happen !";
TYPE
    listoptions      = (common,unique,list);
    setOfListOptions = SET OF listoptions;
CONST
    firstParm = 1;
    maxParm   = 2;
VAR
    parm : ARRAY[firstParm..maxParm] OF pathtype;
    parmcount,i,opt,lastparm,countFile:CARDINAL;
    S,R:pathtype;
    defaultDir,source,target:pathtype;
    useLFN:BOOLEAN;
    alternate,prefixed,delcmd,canonicalform : BOOLEAN; (* yes, should be a state with enumeration *)
    verboselist,chksamefsize,commonnewer,commonbigger,DEBUG : BOOLEAN;
    listmode : setOfListOptions;
    msgDir1,msgDir2,msgCommon,msgUnique:str128;
    ptr,anchor:pFname;
    match:BOOLEAN;
    defaultUnit:str2;
    padwidth:LONGINT;
    sFdata : str80;
BEGIN
    Lib.DisableBreakCheck();
    FIO.IOcheck := FALSE;
    WrLn;

    alternate     := FALSE;
    prefixed      := FALSE;
    delcmd        := FALSE;
    chksamefsize  := FALSE;
    useLFN        := TRUE;
    commonnewer   := FALSE;
    commonbigger  := FALSE;
    verboselist   := FALSE;
    padwidth      := 0;
    DEBUG         := FALSE;

    listmode := setOfListOptions{};

    lastparm  := firstParm-1;
    parmcount := Lib.ParamCount();
    IF parmcount=0 THEN abort(errHelp,"");END;

    FOR i := 1 TO parmcount DO
        Lib.ParamStr(S,i); cleantabs(S);
        Str.Copy(R,S);
        UpperCaseAlt(R); (* damn accented LFNs *)
        cleantabs(R); (* try and fix Yet Another TopSpeed bug ! *)
        IF isOption(R) THEN
            opt := GetOptIndex (R, "?"+delim+"H"+delim+"HELP"+delim+
                                   "A"+delim+"ALTERNATE"+delim+
                                   "C"+delim+"COMMON"+delim+"BOTH"+delim+
                                   "U"+delim+"UNIQUE"+delim+"ONLY"+delim+
                                   "P"+delim+"PREFIX"+delim+
                                   "DEBUG"+delim+"DBG"+delim+
                                   "CC"+delim+
                                   "L"+delim+"LIST"+delim+
                                   "LL"+delim+
                                   "Z"+delim+"SIZE"+delim+
                                   "X"+delim+"LFN"+delim+
                                   "N"+delim+"NEWER"+delim+
                                   "B"+delim+"BIGGER"+delim+
                                   "NN"+delim+"NB"+delim+"BB"+delim+"BN"+delim+
                                   "W:"+delim+"WIDTH:"+delim+
                                   "V"+delim+"VERBOSE"
                               );
            CASE opt OF
            | 1,2,3     : abort(errHelp,"");
            | 4,5       : alternate := TRUE; (* raw listing *)
            | 6,7,8     : INCL(listmode,common);delcmd:=FALSE;
            | 9,10,11   : INCL(listmode,unique);
            |12,13      : prefixed:=TRUE;
            |14,15      : DEBUG:=TRUE;
            |16         : INCL(listmode,common);delcmd:=TRUE;
            |17,18      : INCL(listmode,list); canonicalform:=TRUE;
            |19         : INCL(listmode,list); canonicalform:=FALSE;
            |20,21      : chksamefsize:=TRUE;
            |22,23      : useLFN:=FALSE;
            |24,25      : INCL(listmode,common); commonnewer :=TRUE;
            |26,27      : INCL(listmode,common); commonbigger:=TRUE;
            |28,29,30,31: INCL(listmode,common); commonnewer :=TRUE;
                                                 commonbigger:=TRUE;
            |32,33      : IF GetLongInt(R,padwidth)=FALSE THEN abort(errBadInt,S);END;
                          IF ABS(padwidth) > maxpadwidth THEN abort(errRangeInt,S);END;
            |34,35      : verboselist := TRUE;
            ELSE
                abort(errOption,S); (* could be errHelp, eh eh ! *)
            END;
        ELSE
            INC(lastparm);
            IF lastparm > maxParm THEN abort(errParameter,S);END;
            Str.Copy(parm[lastparm],R);
        END;
    END;
    (* check nonsense *)
    CASE lastparm OF
    | 0 : abort(errMissing,"<directory1> and <directory2> specifications");
    | 1 : abort(errMissing,"<directory2> specification");
    | 2 :
          Str.Copy(source,parm[1]);
          Str.Copy(target,parm[2]);
          IF listmode=setOfListOptions{} THEN
              listmode:=setOfListOptions{common,unique};
          END;
    ELSE
          abort(errSyntax,"");
    END;

    IF (alternate AND prefixed) THEN abort(errEitherOr,"");END;
    IF (delcmd AND prefixed) THEN abort(errEitherOrDel,"");END;

    IF (common IN listmode) THEN
        IF chksamefsize THEN
            IF commonbigger THEN abort(errEitherBiggerOrSame,"");END;
            IF commonnewer  THEN abort(errEitherNewerOrSame,"");END;
        END;
    END;
    IF (unique IN listmode) THEN
        IF commonnewer  THEN abort(errUnique,"-n[n]");END;
        IF commonbigger THEN abort(errUnique,"-b[b]");END;
    END;
    IF (list IN listmode) THEN
        IF listmode <> setOfListOptions{list} THEN abort(errListCmd,"");END;
        IF alternate    THEN abort(errList,"-a");END;
        IF prefixed     THEN abort(errList,"-p");END;
        IF delcmd       THEN abort(errList,"-cc");END;

        IF commonnewer  THEN abort(errList,"-n[n]");END;
        IF commonbigger THEN abort(errList,"-b[b]");END;
    END;
    IF verboselist THEN
        IF delcmd THEN abort(errDelVerbose,"");END;
    END;

    useLFN := ( useLFN AND w9XsupportLFN() );

    doGetCurrentDir (useLFN, FIO.GetDrive(), defaultUnit,defaultDir);

    IF procDir(source,useLFN,defaultUnit,defaultDir)=FALSE THEN abort(errBadDir,source);END;
    IF procDir(target,useLFN,defaultUnit,defaultDir)=FALSE THEN abort(errBadDir,target);END;
    IF same(source,target) THEN abort(errSameDirs,""); END;

    IF delcmd THEN
        S:=prefixbatch;
    ELSE
        S:=prefix;
    END;
    Str.Concat(msgDir1,S,smsgDir1);
    Str.Concat(msgDir2,S,smsgDir2);
    IF delcmd THEN
        ReplaceChar(msgDir1,chRedirIn ,chNewIn);
        ReplaceChar(msgDir1,chRedirOut,chNewOut);
        ReplaceChar(msgDir2,chRedirIn ,chNewIn);
        ReplaceChar(msgDir2,chRedirOut,chNewOut);
    END;
    IF chksamefsize THEN
        Str.Concat(msgCommon,S,smsgCommonSize);
        Str.Concat(msgUnique,S,smsgUniqueSize);
    ELSE
        IF commonnewer THEN
            IF commonbigger THEN
                Str.Concat(msgCommon,S,smsgCommonNewerBigger);
                Str.Concat(msgUnique,S,smsgCannotHappen);
            ELSE
                Str.Concat(msgCommon,S,smsgCommonNewer);
                Str.Concat(msgUnique,S,smsgCannotHappen);
            END;
        ELSE
            IF commonbigger THEN
                Str.Concat(msgCommon,S,smsgCommonBigger);
                Str.Concat(msgUnique,S,smsgCannotHappen);
            ELSE
                Str.Concat(msgCommon,S,smsgCommon);
                Str.Concat(msgUnique,S,smsgUnique);
            END;
        END;
    END;

    IF NOT(list IN listmode) THEN

        IF delcmd THEN WrStr(S);END;(* "rem " *)

        WrStr(Banner);WrLn;
        WrLn;

        WrStr(msgDir1);WrStr(nice(useLFN,source));WrLn;
        WrStr(msgDir2);WrStr(nice(useLFN,target));WrLn;
        WrLn;

    END;

    (*
        cleverness could lead to memory storage allocate failure :
        therefore, we'll just reread directories the Q&D way !
    *)

    IF (common IN listmode) THEN
        initList(anchor);
        countFile :=buildFileList(anchor,useLFN,source);
        IF countFile=MAX(CARDINAL) THEN abort(errTooManyMatches,source);END; (* let DOS handle deallocation *)

        WrStr(msgCommon);WrLn;
        WrLn;

        opt:=0;
        ptr:=anchor;
        WHILE ptr # NIL DO
            getfilenameentry(S, ptr);
            Str.Concat(R,target,S);
            match := chkMatch( sFdata,
                               DEBUG,TRUE,useLFN,
                               chksamefsize,commonnewer,commonbigger,ptr,R);
            IF match THEN

                IF delcmd THEN WrStr(sDel);END;

                IF prefixed THEN
                    IF verboselist THEN WrStr( fmtdata(ptr) ); END;
                    getfilenameentry(S, ptr);
                    Str.Prepend(S,source);
                    WrStr(nice(useLFN,S)); WrLn;
                    IF (commonnewer OR commonbigger)=FALSE THEN
                        IF verboselist THEN WrStr( sFdata );END;
                        WrStr(nice(useLFN,R));WrLn;
                    END;
                ELSE
                    IF verboselist THEN WrStr( fmtdata(ptr) ); END;
                    fmtFilename(useLFN,alternate,padwidth,S);
                    WrStr(S); WrLn;
                    IF verboselist THEN WrStr( sFdata ); WrLn; END;
                END;
                INC(opt);
            END;
            ptr:=ptr^.next;
        END;
        freeFileList(anchor);

        (* newline only if required *)
        IF ( (opt # 0) AND (unique IN listmode) ) THEN WrLn; END;
    END;

    IF (unique IN listmode) THEN
        initList(anchor);
        countFile :=buildFileList(anchor,useLFN,source);
        IF countFile=MAX(CARDINAL) THEN abort(errTooManyMatches,source);END; (* let DOS handle deallocation *)

        WrStr(msgUnique);WrLn;
        WrLn;
        opt:=0;
        ptr:=anchor;
        WHILE ptr # NIL DO
            getfilenameentry(S, ptr);
            Str.Concat(R,target,S);
            match:=chkMatch ( sFdata,
                              DEBUG,FALSE,useLFN,
                              chksamefsize,commonnewer,commonbigger,ptr,R);
            IF NOT(match) THEN
                IF prefixed THEN
                    IF verboselist THEN WrStr( fmtdata(ptr) );END;
                    getfilenameentry(S, ptr);
                    Str.Prepend(S,source);
                    WrStr(nice(useLFN,S)); WrLn;
                ELSE
                    IF verboselist THEN WrStr( fmtdata(ptr) );END;
                    fmtFilename(useLFN,alternate,padwidth,S);
                    WrStr(S);
                    WrStr(" in "); WrStr(nice(useLFN,source));WrLn;
                END;
                INC(opt);
            END;
            ptr:=ptr^.next;
        END;
        freeFileList(anchor);

        (* newline only if required *)
        IF opt # 0 THEN WrLn; END;

        initList(anchor);
        countFile := buildFileList(anchor,useLFN,target);
        IF countFile=MAX(CARDINAL) THEN abort(errTooManyMatches,target);END; (* let DOS handle deallocation *)

        opt:=0;
        ptr:=anchor;
        WHILE ptr # NIL DO
            getfilenameentry(S, ptr);
            Str.Concat(R,source,S);
            match:=chkMatch ( sFdata,
                              DEBUG,FALSE,useLFN,
                              chksamefsize,commonnewer,commonbigger,ptr,R);
            IF NOT(match) THEN
                IF prefixed THEN
                    IF verboselist THEN WrStr( fmtdata(ptr) );END;
                    getfilenameentry(S, ptr);
                    Str.Prepend(S,target);
                    WrStr(nice(useLFN,S)); WrLn;
                ELSE
                    IF verboselist THEN WrStr( fmtdata(ptr) );END;
                    fmtFilename(useLFN,alternate,padwidth,S);
                    WrStr(S);
                    WrStr(" in "); WrStr(nice(useLFN,target));WrLn;
                END;
                INC(opt);
            END;
            ptr:=ptr^.next;
        END;
        freeFileList(anchor);
    END;

    IF (list IN listmode) THEN
        initList(anchor);
        countFile :=buildFileList(anchor,useLFN,source);
        IF countFile=MAX(CARDINAL) THEN abort(errTooManyMatches,source);END; (* let DOS handle deallocation *)

        ptr:=anchor;
        WHILE ptr # NIL DO
            getfilenameentry(S, ptr);
            Str.Concat(R,target,S);
            match:=chkMatch ( sFdata,
                              DEBUG,FALSE,useLFN,
                              chksamefsize,commonnewer,commonbigger,ptr,R);
            IF NOT(match) THEN
                IF canonicalform THEN
                    getfilenameentry(S, ptr);
                    Str.Prepend(S,source);
                END;
                IF verboselist THEN WrStr( fmtdata(ptr) );END;
                WrStr(nice(useLFN,S)); WrLn;
            END;
            ptr:=ptr^.next;
        END;
        freeFileList(anchor);
    END;

    abort(errNone,"");
END DComp.

