
(* ---------------------------------------------------------------
Title         Q&D PC2MAC
Author        PhG
Overview      self-explanatory !
Notes         minimal error messages and checking, etc.
Bugs
Wish List	  tsk tsk...

--------------------------------------------------------------- *)

MODULE PC2MAC;

IMPORT IO;
IMPORT FIO;
IMPORT Str;
IMPORT Lib;

FROM QD_Box IMPORT str80, str2, cmdInit, cmdShow, cmdStop, delim,
Work, video, Ltrim, Rtrim, UpperCase, LowerCase, ReplaceChar,
ChkEscape, Waitkey, WaitkeyDelay, Flushkey, IsRedirected, chkJoker,
isOption, GetOptIndex, GetLongCard, GetLongInt, GetString, CharCount,
same, aR, aH, aS, aD, aA, everything, isDirectory, fixDirectory,
str128, str256, Animation, allfiles, Belongs, FixAE, CodePhonetic,
CodeSoundex, CodeSoundexOrg, isReadOnly, LtrimBlanks, RtrimBlanks,
getStrIndex, cmdSHOW,BiosWaitkey,BiosWaitkeyShifted,BiosFlushkey,
str1024, isoleItemS, dmpTTX, str2048, Elapsed, TerminalReadString,
getDosVersion, DosVersion, warning95, runningWindows,
aV, reallyeverything, chkClassicTextMode, setClassicTextMode,
AltAnimation, str16, getCurrentDirectory, setReadWrite,
getFileSize, verifyString;

FROM FIO IMPORT FIXEDLIBS;

(* ------------------------------------------------------------ *)

TYPE
    CharDef   = RECORD
                Code     : BYTE;
                Flag     : CHAR;
                MapChar  : BYTE;
                MetaChar : BYTE;
                END;
    CharTable = ARRAY [0..255] OF CharDef;

CONST
    TpcTOmac  = CharTable(
    CharDef(000H, "=", 000H,  " "),
    CharDef(001H, "=", 001H,  " "),
    CharDef(002H, "=", 002H,  " "),
    CharDef(003H, "=", 003H,  " "),
    CharDef(004H, "=", 004H,  " "),
    CharDef(005H, "=", 005H,  " "),
    CharDef(006H, "=", 006H,  " "),
    CharDef(007H, "=", 007H,  " "),
    CharDef(008H, "=", 008H,  " "),
    CharDef(009H, "!", 009H,  " "),
    CharDef(00AH, "!", 00AH,  " "),
    CharDef(00BH, "=", 00BH,  " "),
    CharDef(00CH, "=", 00CH,  " "),
    CharDef(00DH, "!", 00DH,  " "),
    CharDef(00EH, "=", 00EH,  " "),
    CharDef(00FH, "=", 00FH,  " "),
    CharDef(010H, "=", 010H,  " "),
    CharDef(011H, "=", 011H,  " "),
    CharDef(012H, "=", 012H,  " "),
    CharDef(013H, "=", 013H,  " "),
    CharDef(014H, "!", 0A6H, 0A6H),
    CharDef(015H, "!", 0A4H, 0A4H),
    CharDef(016H, "=", 016H,  " "),
    CharDef(017H, "=", 017H,  " "),
    CharDef(018H, "=", 018H,  " "),
    CharDef(019H, "=", 019H,  " "),
    CharDef(01AH, "=", 01AH,  " "),
    CharDef(01BH, "=", 01BH,  " "),
    CharDef(01CH, "=", 01CH,  " "),
    CharDef(01DH, "=", 01DH,  " "),
    CharDef(01EH, "=", 01EH,  " "),
    CharDef(01FH, "=", 01FH,  " "),
    CharDef(020H, "=",  " ",  " "),
    CharDef(021H, "=",  "!",  " "),
    CharDef(022H, "!",  '"',  '"'),
    CharDef(023H, "=",  "#",  " "),
    CharDef(024H, "=",  "$",  " "),
    CharDef(025H, "=",  "%",  " "),
    CharDef(026H, "=",  "&",  " "),
    CharDef(027H, "=",  "'",  " "),
    CharDef(028H, "=",  "(",  " "),
    CharDef(029H, "=",  ")",  " "),
    CharDef(02AH, "=",  "*",  " "),
    CharDef(02BH, "=",  "+",  " "),
    CharDef(02CH, "=",  ",",  " "),
    CharDef(02DH, "=",  "-",  " "),
    CharDef(02EH, "=",  ".",  " "),
    CharDef(02FH, "=",  "/",  " "),
    CharDef(030H, "=",  "0",  " "),
    CharDef(031H, "=",  "1",  " "),
    CharDef(032H, "=",  "2",  " "),
    CharDef(033H, "=",  "3",  " "),
    CharDef(034H, "=",  "4",  " "),
    CharDef(035H, "=",  "5",  " "),
    CharDef(036H, "=",  "6",  " "),
    CharDef(037H, "=",  "7",  " "),
    CharDef(038H, "=",  "8",  " "),
    CharDef(039H, "=",  "9",  " "),
    CharDef(03AH, "=",  ":",  " "),
    CharDef(03BH, "=",  ";",  " "),
    CharDef(03CH, "=",  "<",  " "),
    CharDef(03DH, "=",  "=",  " "),
    CharDef(03EH, "=",  ">",  " "),
    CharDef(03FH, "=",  "?",  " "),
    CharDef(040H, "=",  "@",  " "),
    CharDef(041H, "=",  "A",  " "),
    CharDef(042H, "=",  "B",  " "),
    CharDef(043H, "=",  "C",  " "),
    CharDef(044H, "=",  "D",  " "),
    CharDef(045H, "=",  "E",  " "),
    CharDef(046H, "=",  "F",  " "),
    CharDef(047H, "=",  "G",  " "),
    CharDef(048H, "=",  "H",  " "),
    CharDef(049H, "=",  "I",  " "),
    CharDef(04AH, "=",  "J",  " "),
    CharDef(04BH, "=",  "K",  " "),
    CharDef(04CH, "=",  "L",  " "),
    CharDef(04DH, "=",  "M",  " "),
    CharDef(04EH, "=",  "N",  " "),
    CharDef(04FH, "=",  "O",  " "),
    CharDef(050H, "=",  "P",  " "),
    CharDef(051H, "=",  "Q",  " "),
    CharDef(052H, "=",  "R",  " "),
    CharDef(053H, "=",  "S",  " "),
    CharDef(054H, "=",  "T",  " "),
    CharDef(055H, "=",  "U",  " "),
    CharDef(056H, "=",  "V",  " "),
    CharDef(057H, "=",  "W",  " "),
    CharDef(058H, "=",  "X",  " "),
    CharDef(059H, "=",  "Y",  " "),
    CharDef(05AH, "=",  "Z",  " "),
    CharDef(05BH, "=",  "[",  " "),
    CharDef(05CH, "=",  "\",  " "),
    CharDef(05DH, "=",  "]",  " "),
    CharDef(05EH, "=",  "^",  " "),
    CharDef(05FH, "=",  "_",  " "),
    CharDef(060H, "=",  "`",  " "),
    CharDef(061H, "=",  "a",  " "),
    CharDef(062H, "=",  "b",  " "),
    CharDef(063H, "=",  "c",  " "),
    CharDef(064H, "=",  "d",  " "),
    CharDef(065H, "=",  "e",  " "),
    CharDef(066H, "=",  "f",  " "),
    CharDef(067H, "=",  "g",  " "),
    CharDef(068H, "=",  "h",  " "),
    CharDef(069H, "=",  "i",  " "),
    CharDef(06AH, "=",  "j",  " "),
    CharDef(06BH, "=",  "k",  " "),
    CharDef(06CH, "=",  "l",  " "),
    CharDef(06DH, "=",  "m",  " "),
    CharDef(06EH, "=",  "n",  " "),
    CharDef(06FH, "=",  "o",  " "),
    CharDef(070H, "=",  "p",  " "),
    CharDef(071H, "=",  "q",  " "),
    CharDef(072H, "=",  "r",  " "),
    CharDef(073H, "=",  "s",  " "),
    CharDef(074H, "=",  "t",  " "),
    CharDef(075H, "=",  "u",  " "),
    CharDef(076H, "=",  "v",  " "),
    CharDef(077H, "=",  "w",  " "),
    CharDef(078H, "=",  "x",  " "),
    CharDef(079H, "=",  "y",  " "),
    CharDef(07AH, "=",  "z",  " "),
    CharDef(07BH, "=",  "{",  " "),
    CharDef(07CH, "=",  "|",  " "),
    CharDef(07DH, "=",  "}",  " "),
    CharDef(07EH, "=",  "~",  " "),
    CharDef(07FH, "?",  " ", 0C6H),
    CharDef(080H, "=", 082H,  " "),
    CharDef(081H, "=", 09FH,  " "),
    CharDef(082H, "=", 08EH,  " "),
    CharDef(083H, "=", 089H,  " "),
    CharDef(084H, "=", 08AH,  " "),
    CharDef(085H, "=", 088H,  " "),
    CharDef(086H, "=", 08CH,  " "),
    CharDef(087H, "=", 08DH,  " "),
    CharDef(088H, "=", 090H,  " "),
    CharDef(089H, "=", 091H,  " "),
    CharDef(08AH, "=", 08FH,  " "),
    CharDef(08BH, "=", 095H,  " "),
    CharDef(08CH, "=", 094H,  " "),
    CharDef(08DH, "=", 093H,  " "),
    CharDef(08EH, "=", 080H,  " "),
    CharDef(08FH, "=",  "A",  " "),
    CharDef(090H, "=", 083H,  " "),
    CharDef(091H, "=", 0BEH,  " "),
    CharDef(092H, "=", 0AEH,  " "),
    CharDef(093H, "=", 099H,  " "),
    CharDef(094H, "=", 09AH,  " "),
    CharDef(095H, "=", 098H,  " "),
    CharDef(096H, "=", 09EH,  " "),
    CharDef(097H, "=", 09DH,  " "),
    CharDef(098H, "=", 0D8H,  " "),
    CharDef(099H, "=", 085H,  " "),
    CharDef(09AH, "=", 086H,  " "),
    CharDef(09BH, "=", 0A2H,  " "),
    CharDef(09CH, "=", 0A3H,  " "),
    CharDef(09DH, "=", 0B4H,  " "),
    CharDef(09EH, "?",  " ",  "."),
    CharDef(09FH, "=", 0C4H,  " "),
    CharDef(0A0H, "=", 087H,  " "),
    CharDef(0A1H, "=", 092H,  " "),
    CharDef(0A2H, "=", 097H,  " "),
    CharDef(0A3H, "=", 09CH,  " "),
    CharDef(0A4H, "=", 096H,  " "),
    CharDef(0A5H, "=", 084H,  " "),
    CharDef(0A6H, "=", 0BBH,  " "),
    CharDef(0A7H, "=", 0BCH,  " "),
    CharDef(0A8H, "=", 0C0H,  " "),
    CharDef(0A9H, "?",  " ",  "~"),
    CharDef(0AAH, "=", 0C2H,  " "),
    CharDef(0ABH, "?",  " ",  "H"),
    CharDef(0ACH, "?",  " ",  "Q"),
    CharDef(0ADH, "=", 0C1H,  " "),
    CharDef(0AEH, "=", 0C7H,  " "),
    CharDef(0AFH, "=", 0C8H,  " "),
    CharDef(0B0H, "@",  " ",  " "),
    CharDef(0B1H, "@",  " ",  " "),
    CharDef(0B2H, "@",  " ",  " "),
    CharDef(0B3H, "@",  " ",  " "),
    CharDef(0B4H, "@",  " ",  " "),
    CharDef(0B5H, "@",  " ",  " "),
    CharDef(0B6H, "@",  " ",  " "),
    CharDef(0B7H, "@",  " ",  " "),
    CharDef(0B8H, "@",  " ",  " "),
    CharDef(0B9H, "@",  " ",  " "),
    CharDef(0BAH, "@",  " ",  " "),
    CharDef(0BBH, "@",  " ",  " "),
    CharDef(0BCH, "@",  " ",  " "),
    CharDef(0BDH, "@",  " ",  " "),
    CharDef(0BEH, "@",  " ",  " "),
    CharDef(0BFH, "@",  " ",  " "),
    CharDef(0C0H, "@",  " ",  " "),
    CharDef(0C1H, "@",  " ",  " "),
    CharDef(0C2H, "@",  " ",  " "),
    CharDef(0C3H, "@",  " ",  " "),
    CharDef(0C4H, "@",  " ",  " "),
    CharDef(0C5H, "@",  " ",  " "),
    CharDef(0C6H, "@",  " ",  " "),
    CharDef(0C7H, "@",  " ",  " "),
    CharDef(0C8H, "@",  " ",  " "),
    CharDef(0C9H, "@",  " ",  " "),
    CharDef(0CAH, "@",  " ",  " "),
    CharDef(0CBH, "@",  " ",  " "),
    CharDef(0CCH, "@",  " ",  " "),
    CharDef(0CDH, "@",  " ",  " "),
    CharDef(0CEH, "@",  " ",  " "),
    CharDef(0CFH, "@",  " ",  " "),
    CharDef(0D0H, "@",  " ",  " "),
    CharDef(0D1H, "@",  " ",  " "),
    CharDef(0D2H, "@",  " ",  " "),
    CharDef(0D3H, "@",  " ",  " "),
    CharDef(0D4H, "@",  " ",  " "),
    CharDef(0D5H, "@",  " ",  " "),
    CharDef(0D6H, "@",  " ",  " "),
    CharDef(0D7H, "@",  " ",  " "),
    CharDef(0D8H, "@",  " ",  " "),
    CharDef(0D9H, "@",  " ",  " "),
    CharDef(0DAH, "@",  " ",  " "),
    CharDef(0DBH, "@",  " ",  " "),
    CharDef(0DCH, "@",  " ",  " "),
    CharDef(0DDH, "@",  " ",  " "),
    CharDef(0DEH, "@",  " ",  " "),
    CharDef(0DFH, "@",  " ",  " "),
    CharDef(0E0H, "?",  " ",  "a"),
    CharDef(0E1H, "=", 0A7H,  " "),
    CharDef(0E2H, "?",  " ",  "G"),
    CharDef(0E3H, "=", 0B9H,  " "),
    CharDef(0E4H, "=", 0B7H,  " "),
    CharDef(0E5H, "?",  " ",  "s"),
    CharDef(0E6H, "=", 0B5H,  " "),
    CharDef(0E7H, "?",  " ",  "t"),
    CharDef(0E8H, "?",  " ",  "F"),
    CharDef(0E9H, "?",  " ",  "h"),
    CharDef(0EAH, "=", 0BDH,  " "),
    CharDef(0EBH, "=", 0B6H,  " "),
    CharDef(0ECH, "=", 0B0H,  " "),
    CharDef(0EDH, "=", 0AFH,  " "),
    CharDef(0EEH, "?",  " ",  "E"),
    CharDef(0EFH, "?",  " ",  "U"),
    CharDef(0F0H, "?",  " ",  "="),
    CharDef(0F1H, "=", 0B1H,  " "),
    CharDef(0F2H, "=", 0B3H,  " "),
    CharDef(0F3H, "=", 0B2H,  " "),
    CharDef(0F4H, "?",  " ",  "("),
    CharDef(0F5H, "?",  " ",  ")"),
    CharDef(0F6H, "=", 0D6H,  " "),
    CharDef(0F7H, "=", 0C5H,  " "),
    CharDef(0F8H, "=", 0A2H,  " "),
    CharDef(0F9H, "=", 013H,  " "),
    CharDef(0FAH, "=", 0D7H,  " "),
    CharDef(0FBH, "=", 0C3H,  " "),
    CharDef(0FCH, "?",  " ",  "n"),
    CharDef(0FDH, "?",  " ",  "2"),
    CharDef(0FEH, "=", 0A5H,  " "),
    CharDef(0FFH, "=",  "",  "_"));

(* ------------------------------------------------------------ *)

CONST
    IObufferSize  = (8 * 512) + FIO.BufferOverhead;
VAR
    FileNameIn  : str128;
    FileNameOut : str128;
    HandleIn    : FIO.File;
    HandleOut   : FIO.File;
    BufferIn    : ARRAY [1..IObufferSize] OF BYTE;
    BufferOut   : ARRAY [1..IObufferSize] OF BYTE;
VAR
    Ch     : CHAR;
    index  : CARDINAL;
    NewCh  : CHAR; (* sent to output *)
    ChFlag : CHAR;

(* ------------------------------------------------------------ *)

CONST
    ErrHead = "PC2MAC : ";
    ExtIn   = ".ASC";
    ExtOut  = ".MAC";
    Gremlin = 0C0H;       (* inverted question mark in MAC ASCII *)
    Graphic = "+";
TYPE
    ErrCode = (ErrAlready,ErrMissing,ErrWildcard,
               ErrAsk,ErrSwitch,ErrSyntax);
CONST
    Errors  = "Output file already exists !|"+
              "Input file does not exist !|"+
              "No wildcard allowed in filename !|"+
              "No input file specified !|"+
              "Unknown option specified !|"+
              "Syntax error !";

    Title   = "Q&D PC2MAC v1.0a by PhG";
    Help    =
"CR|"+
Title+"|"+
"CR|"+
"Syntax : PC2MAC InFile["+ExtIn+"] [-o] [-sp] [-qm]|"+
"CR|"+
"-sp  Section and paragraph symbols are control characters|"+
"     in the PC ASCII set. Use this switch if you want PC2MAC|"+
"     to convert them to normal characters in the Mac ASCII|"+
"     set (default is letting them as control characters).|"+
"-qm  Use this switch if you want PC2MAC to convert|"+
"     quotations marks to the special set used in Mac ASCII.|"+
"CR|"+
'Characters which are illegal or without equivalent become "",|'+
'graphic characters of the PC ASCII set become "+",|'+
"LF are ignored.|"+
"CR|"+
"Converted file will have "+ExtOut+" extension.|";

PROCEDURE CrLf (  );
BEGIN
    IO.WrLn;
END CrLf;

PROCEDURE Print (S : ARRAY OF CHAR);
BEGIN
    IO.WrStr(S);
END Print;

PROCEDURE PrintCr (S : ARRAY OF CHAR);
BEGIN
    Print(S);
    CrLf;
END PrintCr;

(* ------------------------------------------------------------ *)

PROCEDURE Abort (e : ErrCode);
VAR
    str : str128;
BEGIN
    Str.ItemS(str,Errors,'|',CARDINAL(e));
    Str.Prepend(str,ErrHead);
    CrLf;
    PrintCr (str);
    Lib.SetReturnCode (1);
    HALT;
END Abort;

PROCEDURE AbortHelp;
VAR
    str : str128;
    i   : CARDINAL;
BEGIN
    i := 0;
    LOOP
        Str.ItemS(str,Help,"|",i);
        IF Str.Compare (str,"") = 0 THEN EXIT END;
        IF Str.Compare (str,"CR") = 0 THEN
            CrLf;
        ELSE
            PrintCr (str);
        END;
        INC (i);
    END;
    Lib.SetReturnCode (1);
    HALT;
END AbortHelp;

(* ------------------------------------------------------------ *)

VAR
    FlagOverwrite : BOOLEAN;
    FlagMarks     : BOOLEAN; (* quotation marks *)
    FlagTranspose : BOOLEAN; (* section and paragraph *)

PROCEDURE SetDefaultFlags;
BEGIN
    FlagOverwrite := FALSE;
    FlagMarks     := FALSE;
    FlagTranspose := FALSE;
END SetDefaultFlags;

PROCEDURE DoOptionO;
BEGIN
    FlagOverwrite := TRUE;
END DoOptionO;

VAR
    DquoteStatus : BOOLEAN;

PROCEDURE DoOptionQM;
BEGIN
    FlagMarks    := TRUE;
    DquoteStatus := FALSE; (* will be reversed : TRUE = open, FALSE = close *)
END DoOptionQM;

PROCEDURE DoOptionSP;
BEGIN
    FlagTranspose := TRUE;
END DoOptionSP;

(* ------------------------------------------------------------ *)


PROCEDURE ParseFlag (VAR parm : ARRAY OF CHAR) : BOOLEAN;
CONST
    MaxFlags  = 11;
    CmdFlags  = "?,-?,/?,-H,/H,-O,/O,-QM,/QM,-SP,/SP";
TYPE
    ProcArray = ARRAY [0..MaxFlags-1] OF PROC;
CONST
    Action    = ProcArray (
                AbortHelp,AbortHelp,AbortHelp,
                AbortHelp,AbortHelp,
                DoOptionO,DoOptionO,
                DoOptionQM,DoOptionQM,
                DoOptionSP,DoOptionSP);
CONST
    Separator = ",";
VAR
    str : str128;
    i   : CARDINAL;
    op  : PROC;
BEGIN
    i := 0;
    LOOP
        Str.ItemS (str,CmdFlags,Separator,i);
        IF Str.Compare (parm,str) = 0 THEN
            op := Action[i];
            op;
            RETURN TRUE;                        (* action taken ok *)
        END;
        INC (i);
        IF i = MaxFlags THEN
            CASE parm[0] OF
                | "-","/" : Abort (ErrSwitch);  (* bad switch *)
            END;
            RETURN FALSE;                       (* maybe a filename here *)
        END;
    END;
END ParseFlag;

(* ------------------------------------------------------------ *)

PROCEDURE ParseCLI (VAR In : ARRAY OF CHAR);
VAR
    MaxParms : CARDINAL;
    i        : CARDINAL;
    option   : str128;
    legal    : BOOLEAN;
    FileHere : BOOLEAN;
BEGIN
    FileHere := FALSE;
    MaxParms := Lib.ParamCount ();
    IF MaxParms = 0 THEN
        AbortHelp;                              (* no parameter so help *)
    END;
    FOR i := 1 TO MaxParms DO
        Lib.ParamStr (option,i);
        Str.Caps (option);
        legal := ParseFlag (option);
        IF legal = FALSE THEN                   (* maybe a filename here *)
            IF FileHere = FALSE THEN
                Str.Copy (In,option);
                FileHere := TRUE;               (* allow only one filename *)
            ELSE
                Abort (ErrSyntax);
            END;
        END;
    END;
    IF FileHere = FALSE THEN
        Abort (ErrAsk);
    END;
END ParseCLI;

PROCEDURE CheckNames (VAR In  : ARRAY OF CHAR;
                      VAR Out : ARRAY OF CHAR);
VAR
    i : CARDINAL;
BEGIN
    IF Str.Pos (In, "*") <> MAX(CARDINAL) THEN
        Abort (ErrWildcard);
    END;
    IF Str.Pos (In, "?") <> MAX(CARDINAL) THEN
        Abort (ErrWildcard);
    END;
    Str.Copy (Out,In);
    i := Str.CharPos (In,".");
    IF i = MAX(CARDINAL) THEN
        Str.Append (In,ExtIn);                  (* add default extension *)
    ELSE
        Str.Slice (Out,Out,0,i);
    END;
    Str.Append (Out,ExtOut);
    IF NOT FIO.Exists (In) THEN
        Abort (ErrMissing);
    END;
    IF FlagOverwrite = FALSE THEN
        IF FIO.Exists (Out) THEN
            Abort (ErrAlready);
        END;
    END;
END CheckNames;

(* ------------------------------------------------------------ *)

CONST
    TAB            = CHAR (009H);
    LF             = CHAR (00AH); (* no linefeed for MAC ASCII *)
    CR             = CHAR (00DH);
    ParagraphPC    = CHAR (014H);
    SectionPC      = CHAR (015H);
    DquotePC       = '"';  (* 022H *)
    openDquoteMAC  = CHAR (0D2H);
    closeDquoteMAC = CHAR (0D3H);

PROCEDURE DoDquote;
BEGIN
    IF FlagMarks = TRUE THEN
        DquoteStatus := NOT DquoteStatus;
        CASE DquoteStatus OF
            | TRUE  : NewCh := openDquoteMAC;
            | FALSE : NewCh := closeDquoteMAC;
        END;
    END;
END DoDquote;

PROCEDURE DoTranspose;
BEGIN
    IF FlagTranspose = FALSE THEN
        NewCh := Ch;
    END;
END DoTranspose;

(* ------------------------------------------------------------ *)

BEGIN
    SetDefaultFlags;
    ParseCLI (FileNameIn);
    CheckNames (FileNameIn,FileNameOut);
    FIO.IOcheck := FALSE;
    HandleIn := FIO.OpenRead (FileNameIn);
    FIO.AssignBuffer (HandleIn,BufferIn);
    HandleOut := FIO.Create (FileNameOut);
    FIO.AssignBuffer (HandleOut,BufferOut);
    CrLf;
    PrintCr (Title);
    LOOP
        Ch := FIO.RdChar (HandleIn);
        IF FIO.EOF THEN EXIT; END;
        index := ORD (Ch);
        NewCh := CHAR (TpcTOmac[index].MapChar); (* MUST be done HERE *)
        ChFlag := CHAR (TpcTOmac[index].Flag);
            CASE ChFlag OF
                | "=" : FIO.WrChar (HandleOut,NewCh); (* send verbatim *)
                | "?" : NewCh := CHAR(Gremlin);
                        FIO.WrChar (HandleOut,NewCh);
                | "@" : NewCh := CHAR(Graphic);
                        FIO.WrChar (HandleOut,NewCh);
                | "!" : CASE Ch OF
                            | TAB         : FIO.WrChar (HandleOut,NewCh);
                            | CR          : FIO.WrChar (HandleOut,NewCh);
                            | DquotePC    : DoDquote;
                                            FIO.WrChar (HandleOut,NewCh);
                            | ParagraphPC : DoTranspose;
                                            FIO.WrChar (HandleOut,NewCh);
                            | SectionPC   : DoTranspose;
                                            FIO.WrChar (HandleOut,NewCh);
                            | LF          : ;
                        END;
            END;
    END;
    FIO.Flush (HandleOut);
    FIO.Close (HandleOut);
    FIO.Close (HandleIn);
    Lib.SetReturnCode (0);
END PC2MAC.

