(* ---------------------------------------------------------------
Title         Q&D CRLF
Author        PhG
Overview      fix CR/LF from Unix and the like...
Usage         see help
Notes         very, very, very quick & dirty... :-(
              minimal error messages and checking, etc.
              trimming is best left to TRIM
Bugs          doFixCRLFCRLF() does not remove CRLFCRLF at start of text
Wish List     -cr and -lf to change EOF sequence ?

--------------------------------------------------------------- *)

MODULE CRLF;

IMPORT Lib;
IMPORT FIO;
IMPORT Str;
IMPORT IO;

FROM IO IMPORT WrStr, WrLn;

FROM Storage IMPORT ALLOCATE,DEALLOCATE,Available;

FROM QD_Box IMPORT str80, str2, cmdInit, cmdShow, cmdStop, delim,
Work, video, Ltrim, Rtrim, UpperCase, LowerCase, ReplaceChar,
ChkEscape, Waitkey, WaitkeyDelay, Flushkey, IsRedirected, chkJoker,
isOption, GetOptIndex, GetLongCard, GetLongInt, GetString, CharCount,
same, aR, aH, aS, aD, aA, everything, isDirectory, fixDirectory,
str128, str256, Animation, allfiles, Belongs, FixAE, CodePhonetic,
CodeSoundex, CodeSoundexOrg, isReadOnly, LtrimBlanks, RtrimBlanks,
getStrIndex, cmdSHOW,BiosWaitkey,BiosWaitkeyShifted,BiosFlushkey,
str1024, isoleItemS, dmpTTX, str2048, Elapsed, TerminalReadString,
getDosVersion, DosVersion, warning95, runningWindows,
aV, reallyeverything, chkClassicTextMode, setClassicTextMode,
AltAnimation, str16, getCurrentDirectory, setReadWrite, setReadOnly,
getFileSize, verifyString, str4096, unfixDirectory,
animShow, animSHOW, animAdvance, animEnd, animClear,
animInit, animGetSdone, anim, cleantabs, UpperCaseAlt, LowerCaseAlt,
completedInit, completedShow, completedSHOW, completedEnd, completed,
removeDups, isValidHDunit, removePhantoms, removeFloppies,
getCDROMunits, getCDROMletters, removeCDROMs, getAllHDunits,
getAllLegalUnits;

FROM QD_LFN IMPORT path9X, huge9X, findDataRecordType,
unicodeConversionFlagType, w9XchangeDir,
w9XgetDOSversion, w9XgetTrueDOSversion, w9XisWindowsEnh, w9XisMSDOS7,
w9XfindFirst, w9XfindNext, w9XfindClose, w9XgetCurrentDirectory,
w9XlongToShort, w9XshortToLong, w9XtrueName, w9XchangeDir,
w9XmakeDir, w9XrmDir, w9Xrename, w9XopenFile, w9XcloseFile,
w9XsupportLFN;

FROM QD_File IMPORT pathtype, w9XnothingRequired,
fileOpenRead, fileOpen, fileExists, fileIsRO, fileSetRW, fileSetRO,
fileErase, fileCreate, fileRename, fileGetFileSize, fileIsDirectorySpec;

(* ------------------------------------------------------------ *)

CONST
    DEBUG = FALSE;
CONST
    ProgEXEname   = "CRLF";
    ProgTitle     = "Q&D CRLF";
    ProgVersion   = "v1.1k";
    ProgCopyright = "by PhG";
    Banner        = ProgTitle+" "+ProgVersion+" "+ProgCopyright;
CONST
    nullchar      = 0C; (* CHR(0) *)
    dot           = ".";
    dotdot        = dot+dot;
    dquote        = '"';
CONST
    twirldot      = "." ; (* was CHR(249) but it's ugly with vindoze *)
    extBAK        = ".BK!";
    extCOM        = ".COM";
    extEXE        = ".EXE";
    extDLL        = ".DLL";
    extOVR        = ".OVR";
    extOVL        = ".OVL";
    extDRV        = ".DRV";
    extZIP        = ".ZIP";
    extARJ        = ".ARJ";
    extLZH        = ".LZH";
    skippedextensions = extBAK+delim+extCOM+delim+extEXE+delim+
                        extDLL+delim+extOVR+delim+extOVL+delim+extDRV+delim+
                        extZIP+delim+extARJ+delim+extLZH;
CONST
    errNone         = 0;
    errHelp         = 1;
    errOption       = 2;
    errTooManyParms = 3;
    errMissingName  = 4;
    errTooManyFiles = 5;
    errNoMatch      = 6;
    errBadExt       = 7;
    errConflict     = 8;
    errUserAborted  = 255;

(* ------------------------------------------------------------ *)

PROCEDURE abort (e : CARDINAL; einfo : ARRAY OF CHAR);
CONST
    cr=CHR(13);
    lf=CHR(10);
    nl=cr+lf;
(*
 00000000011111111112222222222333333333344444444445555555555666666666677777777778
 1...'....0....'....0....'....0....'....0....'....0....'....0....'....0....'....0
*)
    helpmsg=
Banner+nl+
nl+
"Syntax : "+ProgEXEname+" <file(s)> [-r|-p[p]|-l[l]] [-q] [-x]"+nl+
nl+
"This program fixes CR ($0d) and LF ($0a) text file line separators."+nl+
"For safety, original is kept with "+extBAK+" extension."+nl+
nl+
"  -r   remove CRLFCRLF sequences"+nl+
"  -p   pack all CRLF sequences"+nl+
"  -pp  leave only first CRLFCRLF sequence"+nl+
"  -l   read each line as a 4096 characters string, keeping only non-empty ones"+nl+
"  -ll  same as -l but leaving only first CRLFCRLF sequence (first empty line)"+nl+
"  -q   quiet mode"+nl+
"  -x   disable LFN support even if available"+nl+
nl+
"a) "+skippedextensions+" files will be ignored."+nl+
'b) Many HTML files contain CRCRLF sequences : first run "'+ProgEXEname+'", then "'+ProgEXEname+' -r".'+nl;

VAR
    S : str256;
BEGIN
    CASE e OF
    | errHelp :
        WrStr(helpmsg);
    | errOption :
        Str.Concat(S,"Unknown ",einfo);
        Str.Append(S," option !");
    | errTooManyParms :
        Str.Concat(S,"Uneeded ",einfo);
        Str.Append(S," parameter !");
    | errMissingName :
        S := "Missing file specification !";
    | errTooManyFiles :
        Str.Concat(S,'Too many files match "',einfo);
        Str.Append(S,'" specification ');
    | errNoMatch :
        Str.Concat(S,'No legal file matches "',einfo);
        Str.Append(S,'" specification !');
    | errBadExt :
        S:="File extension would prevent file(s) from being processed !";
    | errConflict:
        S:="Please specify only one processing command !";
    | errUserAborted:
        S := "Aborted by user !";
    ELSE
        S := "This is illogical, Captain !";
    END;
    CASE  e OF
    | errNone, errHelp:
        ;
    ELSE
        WrStr(ProgEXEname+" : "); WrStr(S); WrLn;
    END;
    Lib.SetReturnCode(SHORTCARD(e));
    HALT;
END abort;

(* ------------------------------------------------------------ *)
(* ------------------------------------------------------------ *)

PROCEDURE legalextension (S,skipthem:ARRAY OF CHAR):BOOLEAN;
VAR
    e3 : str16;
    n:CARDINAL;
    rc:BOOLEAN;
BEGIN

    Str.Caps(S); (* ah, lowercase LFNs... *)

    rc:=TRUE;
    n:=0;
    LOOP
        isoleItemS(e3, skipthem,delim,n);
        IF same(e3,"") THEN EXIT; END;
        IF Str.Pos(S,e3) # MAX(CARDINAL) THEN rc:=FALSE;EXIT; END;
        INC(n);
    END;
    RETURN rc;
END legalextension;

(* ------------------------------------------------------------ *)

TYPE
    pFname = POINTER TO fnameType;
    fnameType = RECORD
        next      : pFname;
        slen      : SHORTCARD;
        str       : CHAR;
    END;

PROCEDURE initList (VAR anchor : pFname );
BEGIN
    anchor := NIL;
END initList;

PROCEDURE freeList (anchor : pFname);
VAR
    needed : CARDINAL;
    p      : pFname;
BEGIN
    (* p:=anchor; *)
    WHILE anchor # NIL DO
        needed := SIZE(fnameType) - SIZE(anchor^.str) + CARDINAL(anchor^.slen);
        p := anchor^.next;
        DEALLOCATE(anchor,needed);
        anchor:=p;
    END
END freeList;

PROCEDURE buildNewPtr (VAR anchor,p:pFname; len:CARDINAL):BOOLEAN;
VAR
    needed : CARDINAL;
BEGIN
    needed := SIZE(fnameType) - SIZE(p^.str) + len;
    IF Available(needed)=FALSE THEN RETURN FALSE; END;
    IF anchor = NIL THEN
        ALLOCATE(anchor,needed);
        p:=anchor;
    ELSE
        p:=anchor;
        WHILE p^.next # NIL DO
            p:=p^.next;
        END;
        ALLOCATE(p^.next,needed);
        p:=p^.next;
    END;
    p^.next := NIL;
    RETURN TRUE;
END buildNewPtr;

(* assume p is valid *)

PROCEDURE getStr (VAR S : pathtype; p:pFname);
VAR
    len:CARDINAL;
BEGIN
    len := CARDINAL(p^.slen);
    Lib.FastMove( ADR(p^.str),ADR(S),len);
    S[len] := nullchar; (* REQUIRED safety ! *)
END getStr;

(* ------------------------------------------------------------ *)

PROCEDURE isReservedEntry (S:ARRAY OF CHAR) : BOOLEAN;
BEGIN
    IF same(S,dot) THEN RETURN TRUE; END;
    RETURN same(S,dotdot);
END isReservedEntry;

PROCEDURE buildFileList (VAR anchor:pFname;
                        useLFN:BOOLEAN;spec:pathtype;skipext:ARRAY OF CHAR):CARDINAL;
VAR
    count:CARDINAL; (* should do ! *)
    ok,found:BOOLEAN;
    unicodeconversion:unicodeConversionFlagType;
    w9Xentry : findDataRecordType;
    w9Xhandle,errcode:CARDINAL;
    entry : FIO.DirEntry;
    dosattr:FIO.FileAttr;
    entryname:pathtype;
    len : CARDINAL;
    pp:pFname;
    includeme:BOOLEAN;
BEGIN
    count:=0;
    IF useLFN THEN
        found := w9XfindFirst (spec,SHORTCARD(everything),SHORTCARD(w9XnothingRequired),
                              unicodeconversion,w9Xentry,w9Xhandle,errcode);
    ELSE
        found := FIO.ReadFirstEntry(spec,everything,entry);
    END;
    WHILE found DO
        IF useLFN THEN
            Str.Copy(entryname,w9Xentry.fullfilename);
        ELSE
            Str.Copy(entryname,entry.Name);
        END;
        includeme := NOT( isReservedEntry(entryname) ); (* skip "." and ".." *)
        includeme := includeme AND legalextension(entryname,skipext);
        IF includeme THEN
            IF useLFN THEN
                dosattr:=FIO.FileAttr(w9Xentry.attr AND 0FFH);
            ELSE
                dosattr:=entry.attr;
            END;
            IF NOT (aD IN dosattr) THEN
                (* if file has no extension, add it as a marker *)
                IF Str.RCharPos(entryname,".")=MAX(CARDINAL) THEN
                    Str.Append(entryname,".");
                END;
                len:=Str.Length(entryname);
                IF buildNewPtr(anchor,pp,len)=FALSE THEN
                    IF useLFN THEN ok:=w9XfindClose(w9Xhandle,errcode); END;
                    RETURN MAX(CARDINAL); (* errStorage *)
                END;
                INC(count);
                pp^.slen      := SHORTCARD(len);
                Lib.FastMove ( ADR(entryname),ADR(pp^.str),len );
            END;
        END;
        IF useLFN THEN
            found :=w9XfindNext(w9Xhandle, unicodeconversion,w9Xentry,errcode);
        ELSE
            found :=FIO.ReadNextEntry(entry);
        END;
    END;
    IF useLFN THEN ok:=w9XfindClose(w9Xhandle,errcode); END;
    RETURN count;
END buildFileList;

(* ------------------------------------------------------------ *)
(* ------------------------------------------------------------ *)

CONST
    ioBufferSize    = (8 * 512) + FIO.BufferOverhead;
    firstBufferByte = 1;
    lastBufferByte  = ioBufferSize;
TYPE
    ioBuffer  = ARRAY [firstBufferByte..lastBufferByte] OF BYTE;
VAR
    bufferIn : ioBuffer;
    bufferOut: ioBuffer;

CONST
    CR = CHR(13);
    LF = CHR(10);
    CR_LF = CR+LF;
CONST
    msgWait = "please wait...";
    steps   = 10;

(* ------------------------------------------------------------ *)

PROCEDURE doFixCRs (useLFN,verbose:BOOLEAN; source,target:pathtype;maxSequence : CARDINAL );
VAR
    hndIn : FIO.File;
    hndOut: FIO.File;
    got   : CARDINAL;
    ch	  : CHAR;
    last  : CHAR;
    status: (waiting,wasCR);
    sequence:CARDINAL;
    fsize,portion,lastportion,currportion,addr : LONGCARD;
BEGIN

    IF verbose THEN
        animInit(steps, "[", "]", twirldot, "", "\/" );
        fsize:= fileGetFileSize(useLFN,source);
        portion:=fsize DIV LONGCARD(steps); INC(portion); (* avoid DIV 0 ! *)
        lastportion := LONGCARD(steps+1);
    ELSE
        video(msgWait,TRUE);
    END;


    hndIn :=fileOpenRead(useLFN,source);
    FIO.AssignBuffer(hndIn,bufferIn);
    hndOut:=fileCreate(useLFN,target);
    FIO.AssignBuffer(hndOut,bufferOut);
    FIO.EOF:=FALSE;
    status:=waiting;

    CASE maxSequence OF
    | 1 : sequence := 1; (* v1.1j -p fix *)
    | 2 : sequence := 0;
    ELSE
          sequence := 0;
    END;

    LOOP
        IF FIO.EOF=TRUE THEN EXIT; END;
        got:=FIO.RdBin(hndIn,ch,1);
        IF got # 1 THEN EXIT;END;
        CASE status OF
        | waiting :
            CASE ch OF
            | CR :
                status:=wasCR;
            ELSE
                FIO.WrChar(hndOut,ch);
                sequence:=0;
            END;
        | wasCR :
            CASE ch OF
            | LF :
                IF sequence < maxSequence THEN
                    FIO.WrChar(hndOut,CR);
                    FIO.WrChar(hndOut,LF);
                END;
                INC(sequence);
                status:=waiting;
            ELSE
                FIO.WrChar(hndOut,CR); (* was pending *)
                FIO.WrChar(hndOut,ch);
                sequence:=0;
                status:=waiting;
            END;
        END;
        IF verbose THEN
            addr:=FIO.GetPos(hndIn);
            anim(animShow);
            currportion:=addr DIV portion;
            IF currportion # lastportion THEN
                anim(animAdvance);
                lastportion:=currportion;
            END;
        END;
    END;
    CASE status OF
    | wasCR:     FIO.WrChar(hndOut,CR);
    END;

    FIO.Flush(hndOut);
    FIO.Close(hndOut);
    FIO.Close(hndIn);
    IF verbose THEN
        anim(animEnd);anim(animClear);
    ELSE
        video(msgWait,FALSE);
    END;
END doFixCRs;

(* ------------------------------------------------------------ *)

PROCEDURE doFixCRLFCRLF (useLFN,verbose:BOOLEAN; source,target:pathtype);
VAR
    hndIn : FIO.File;
    hndOut: FIO.File;
    got   : CARDINAL;
    ch	  : CHAR;
    status: (waiting,wasCR,wasCRLF,wasCRLFCR);
    fsize,portion,lastportion,currportion,addr : LONGCARD;
BEGIN
    IF verbose THEN
        animInit(steps, "[", "]", twirldot, "", "\/" );
        fsize:= fileGetFileSize(useLFN,source);
        portion:=fsize DIV LONGCARD(steps); INC(portion); (* avoid DIV 0 ! *)
        lastportion := LONGCARD(steps+1);
    ELSE
        video(msgWait,TRUE);
    END;

    hndIn :=fileOpenRead(useLFN,source);
    FIO.AssignBuffer(hndIn,bufferIn);
    hndOut:=fileCreate(useLFN,target);
    FIO.AssignBuffer(hndOut,bufferOut);
    FIO.EOF:=FALSE;

    status:=waiting;

    LOOP
        IF FIO.EOF=TRUE THEN EXIT; END;
        got:=FIO.RdBin(hndIn,ch,1);
        IF got # 1 THEN EXIT;END;
        CASE status OF
        | waiting :
            IF ch=CR THEN
                status:=wasCR;
            ELSE
                FIO.WrChar(hndOut,ch);
            END;
        | wasCR :
            IF ch=LF THEN
                status:=wasCRLF;
            ELSE
                FIO.WrChar(hndOut,CR);
                FIO.WrChar(hndOut,ch);
                status:=waiting;
            END;
        | wasCRLF :
            IF ch=CR THEN
                status:=wasCRLFCR;
            ELSE
                FIO.WrChar(hndOut,CR);
                FIO.WrChar(hndOut,LF);
                FIO.WrChar(hndOut,ch);
                status:=waiting;
            END;
        | wasCRLFCR :
            IF ch=LF THEN
                FIO.WrChar(hndOut,CR);
                FIO.WrChar(hndOut,LF);
                status:=waiting;
            ELSE
                FIO.WrChar(hndOut,CR);
                FIO.WrChar(hndOut,LF);
                FIO.WrChar(hndOut,CR);
                FIO.WrChar(hndOut,ch);
                status:=waiting;
            END;
        END;
        IF verbose THEN
            addr:=FIO.GetPos(hndIn);
            anim(animShow);
            currportion:=addr DIV portion;
            IF currportion # lastportion THEN
                anim(animAdvance);
                lastportion:=currportion;
            END;
        END;
    END;
    IF status = wasCRLFCR THEN
        FIO.WrChar(hndOut,CR);
        FIO.WrChar(hndOut,LF);
    END;

    FIO.Flush(hndOut);
    FIO.Close(hndOut);
    FIO.Close(hndIn);
    IF verbose THEN
        anim(animEnd);anim(animClear);
    ELSE
        video(msgWait,FALSE);
    END;
END doFixCRLFCRLF;

(* ------------------------------------------------------------ *)

PROCEDURE doProcess (useLFN,verbose:BOOLEAN;source,target:pathtype);
VAR
    hndIn : FIO.File;
    hndOut: FIO.File;
    got   : CARDINAL;
    ch	  : CHAR;
    wasCR : BOOLEAN;
    fsize,portion,lastportion,currportion,addr : LONGCARD;
BEGIN
    IF verbose THEN
        animInit(steps, "[", "]", twirldot, "", "\/" );
        fsize:= fileGetFileSize(useLFN,source);
        portion:=fsize DIV LONGCARD(steps); INC(portion); (* avoid DIV 0 ! *)
        lastportion := LONGCARD(steps+1);
    ELSE
        video(msgWait,TRUE);
    END;

    hndIn :=fileOpenRead(useLFN,source);
    FIO.AssignBuffer(hndIn,bufferIn);
    hndOut:=fileCreate(useLFN,target);
    FIO.AssignBuffer(hndOut,bufferOut);
    FIO.EOF:=FALSE;
    wasCR:=FALSE;
    LOOP
        IF FIO.EOF=TRUE THEN EXIT; END;
        got:=FIO.RdBin(hndIn,ch,1);
        IF got # 1 THEN EXIT;END;

        CASE ch OF
        | CR :
            IF wasCR = TRUE THEN
                FIO.WrChar (hndOut,LF); (* cr LF CR *)
            ELSE
                wasCR := TRUE;
            END;
        | LF :
            IF wasCR = FALSE THEN
                FIO.WrChar (hndOut,CR); (* cr LF *)
            ELSE
                wasCR := FALSE;
            END;
        ELSE
            IF wasCR = TRUE THEN
                FIO.WrChar (hndOut,LF); (* CR LF *)
                wasCR := FALSE;
            END;
        END;
        FIO.WrChar (hndOut,ch);
        IF verbose THEN
            addr:=FIO.GetPos(hndIn);
            anim(animShow);
            currportion:=addr DIV portion;
            IF currportion # lastportion THEN
                anim(animAdvance);
                lastportion:=currportion;
            END;
        END;
    END;
    IF wasCR = TRUE THEN
        FIO.WrChar (hndOut,LF);
    END;
(*
    FIO.WrStr(hndOut,CR_LF); (* just in case ! *)
*)
    FIO.Flush(hndOut);
    FIO.Close(hndOut);
    FIO.Close(hndIn);
    IF verbose THEN
        anim(animEnd);anim(animClear);
    ELSE
        video(msgWait,FALSE);
    END;
END doProcess;

(* ------------------------------------------------------------ *)

PROCEDURE doFixStrings (useLFN,verbose,keepfirstcrlfcrlf:BOOLEAN;source,target:pathtype);
VAR
    hndIn : FIO.File;
    hndOut: FIO.File;
    hugestr:str4096;
    wasempty:BOOLEAN;
    fsize,portion,lastportion,currportion,addr : LONGCARD;
BEGIN
    IF verbose THEN
        animInit(steps, "[", "]", twirldot, "", "\/" );
        fsize:= fileGetFileSize(useLFN,source);
        portion:=fsize DIV LONGCARD(steps); INC(portion); (* avoid DIV 0 ! *)
        lastportion := LONGCARD(steps+1);
    ELSE
        video(msgWait,TRUE);
    END;

    wasempty:=FALSE;

    hndIn :=fileOpenRead(useLFN,source);
    FIO.AssignBuffer(hndIn,bufferIn);
    hndOut:=fileCreate(useLFN,target);
    FIO.AssignBuffer(hndOut,bufferOut);
    FIO.EOF:=FALSE;

    LOOP
        IF FIO.EOF THEN EXIT; END;
        FIO.RdStr(hndIn,hugestr);
        IF Str.Length(hugestr) > 0 THEN
            FIO.WrStr (hndOut,hugestr);  FIO.WrLn(hndOut);
            wasempty:=FALSE;
        ELSE
            IF keepfirstcrlfcrlf THEN
               IF wasempty=FALSE THEN
                   FIO.WrLn(hndOut);
                   wasempty:=TRUE;
               END;
            END;
        END;
        IF verbose THEN
            addr:=FIO.GetPos(hndIn);
            anim(animShow);
            currportion:=addr DIV portion;
            IF currportion # lastportion THEN
                anim(animAdvance);
                lastportion:=currportion;
            END;
        END;
    END;

    FIO.Flush(hndOut);
    FIO.Close(hndOut);
    FIO.Close(hndIn);
    IF verbose THEN
        anim(animEnd);anim(animClear);
    ELSE
        video(msgWait,FALSE);
    END;
END doFixStrings;

PROCEDURE buildPath (VAR path:pathtype; spec:pathtype);
VAR
    u,d,n,e:pathtype;
BEGIN
    Lib.SplitAllPath(spec, u,d,n,e);
    Str.Concat(path, u,d);
    fixDirectory(path); (* safety *)
END buildPath;

(* ------------------------------------------------------------ *)

TYPE
    cmdtype = (cmddefault,doCRLFCRLF,doCRs1,doCRs2,doReadLine,doReadLineAlt);

PROCEDURE newcmd (VAR cmd:cmdtype;newcmd:cmdtype ):BOOLEAN;
VAR
    rc:BOOLEAN;
BEGIN
    rc:=TRUE;
    IF cmd=newcmd THEN RETURN rc;END;
    IF cmd=cmddefault THEN
        cmd:=newcmd;
    ELSE
        rc:=FALSE;
    END;
    RETURN rc;
END newcmd;

CONST
    msgProcessing = "Processing ";
    msgNow = " : ";
    msgOK = "done !";
VAR
    cmd : cmdtype;
VAR
    parmcount : CARDINAL;
    i         : CARDINAL;
    opt       : CARDINAL;
    S,R,spec,path:pathtype;
    found     : BOOLEAN;

    anchor,ptr:pFname;
    p    : CARDINAL;
    countFile : CARDINAL;
    verbose:BOOLEAN;
    state  :(waiting,gotspec);
    useLFN : BOOLEAN;
    userAborted   : BOOLEAN;
BEGIN
    Lib.DisableBreakCheck();
    FIO.IOcheck := FALSE;

    WrLn;

    useLFN  := TRUE;
    verbose := TRUE;
    cmd     := cmddefault;
    state   := waiting;

    parmcount := Lib.ParamCount();
    IF parmcount=0 THEN abort(errHelp,"");END;
    FOR i := 1 TO parmcount DO
        Lib.ParamStr(S,i); cleantabs(S);
        Str.Copy(R,S);
        UpperCase(R);
        IF isOption(R) THEN
            opt := GetOptIndex(R,"?"+delim+"H"+delim+"HELP"+delim+
                                 "R"+delim+"REMOVE"+delim+
                                 "P"+delim+"PACK"+delim+
                                 "PP"+delim+
                                 "Q"+delim+"QUIET"+delim+
                                 "L"+delim+"STRINGMODE"+delim+
                                 "LL"+delim+
                                 "X"+delim+"LFN"
                              );
            CASE opt OF
            | 1,2,3 : abort(errHelp,"");
            | 4,5 :   IF newcmd(cmd,doCRLFCRLF)=FALSE THEN abort(errConflict,"");END;
            | 6,7:    IF newcmd(cmd,doCRs1)=FALSE THEN abort(errConflict,"");END;
            | 8:      IF newcmd(cmd,doCRs2)=FALSE THEN abort(errConflict,"");END;
            | 9,10:   verbose:=FALSE;
            | 11,12:  IF newcmd(cmd,doReadLine)=FALSE THEN abort(errConflict,"");END;
            | 13:     IF newcmd(cmd,doReadLineAlt)=FALSE THEN abort(errConflict,"");END;
            | 14,15:  useLFN := FALSE;
            ELSE
                      abort(errOption,S); (* could be errHelp, eh eh ! *)
            END;
        ELSE
            CASE state OF
            | waiting : Str.Copy(spec,S); UpperCaseAlt(spec); (* keep accents *)
            | gotspec : abort(errTooManyParms,S);
            END;
            INC(state);
        END;
    END;
    (* check nonsense *)

    IF state=waiting THEN abort(errMissingName,""); END;

    IF legalextension (spec,skippedextensions)=FALSE THEN abort(errBadExt,"");END;

    IF same(spec,".") THEN spec:="*.*"; END;
    IF Str.Match(spec,"*\") THEN Str.Append(spec,"*.*"); END;
    IF Str.Match(spec,"*\.") THEN
        i:=Str.Length(spec);
        spec[i-1]:=nullchar;
        Str.Append(spec,"*.*");
    END;

    useLFN := ( useLFN AND w9XsupportLFN() );

    initList(anchor);
    countFile:=buildFileList(anchor,useLFN,spec,skippedextensions);
    IF countFile=MAX(CARDINAL) THEN abort(errTooManyFiles,spec);END; (* errStorage *)
    IF countFile=0 THEN abort(errNoMatch,spec); END;

    buildPath(path,  spec);

    WrStr(Banner);WrLn;
    WrLn;

    userAborted := FALSE;

    ptr:=anchor;
    WHILE ptr # NIL DO
        getStr(R,ptr);
        p := Str.RCharPos(R,dot);
        IF p # MAX(CARDINAL) THEN
            Str.Slice(S,R,0,p);
            Str.Copy(R,S);
        END;
        Str.Append(R,extBAK);
        Str.Prepend(R,path);

        getStr(S,ptr);
        Str.Prepend(S,path);

        IF fileExists(useLFN,R) THEN fileSetRW(useLFN,R);fileErase(useLFN,R); END;
        fileRename(useLFN,S,R);

        WrStr(msgProcessing);
        IF useLFN THEN WrStr(dquote);END;
        WrStr(S);
        IF useLFN THEN WrStr(dquote);END;
        WrStr(msgNow);

        CASE cmd OF
        | cmddefault :   doProcess(useLFN,verbose,R,S); (* yes ! *)
        | doCRLFCRLF :   doFixCRLFCRLF(useLFN,verbose,R,S);       (* -r  *)
        | doCRs1 :       doFixCRs(useLFN,verbose,R,S,1);          (* -p  *)
        | doCRs2 :       doFixCRs(useLFN,verbose,R,S,2);          (* -pp *)
        | doReadLine:    doFixStrings(useLFN,verbose,FALSE,R,S);  (* -l  *)
        | doReadLineAlt: doFixStrings(useLFN,verbose,TRUE,R,S);   (* -ll *)
        END;
        WrStr(msgOK);WrLn;

        userAborted:=ChkEscape();
        IF userAborted THEN
            freeList(anchor); (* cleaner *)
            abort(errUserAborted,"");
        END;

        ptr:=ptr^.next;
    END;

    freeList(anchor);

    abort(errNone,"");
END CRLF.







(*
@echo off

set _p=\bat\crlf
set _n=old

copy foo test
%_p% -r test
copy test %_n%_r

copy foo test
%_p% -p test
copy test %_n%_p

copy foo test
%_p% -pp test
copy test %_n%_pp

copy foo test
%_p% -l test
copy test %_n%_l

copy foo test
%_p% -ll test
copy test %_n%_ll




set _p=crlf
set _n=new

copy foo test
%_p% -r test
copy test %_n%_r

copy foo test
%_p% -p test
copy test %_n%_p

copy foo test
%_p% -pp test
copy test %_n%_pp

copy foo test
%_p% -l test
copy test %_n%_l

copy foo test
%_p% -ll test
copy test %_n%_ll


del test.*


set _e=r
fcomp -i old_%_e% new_%_e%
if errorlevel 255 del old_%_e%
if errorlevel 255 del new_%_e%

set _e=p
fcomp -i old_%_e% new_%_e%
if errorlevel 255 del old_%_e%
if errorlevel 255 del new_%_e%

set _e=pp
fcomp -i old_%_e% new_%_e%
if errorlevel 255 del old_%_e%
if errorlevel 255 del new_%_e%

set _e=l
fcomp -i old_%_e% new_%_e%
if errorlevel 255 del old_%_e%
if errorlevel 255 del new_%_e%

set _e=ll
fcomp -i old_%_e% new_%_e%
if errorlevel 255 del old_%_e%
if errorlevel 255 del new_%_e%
*)

(*


aa



bbbb

ccc
ddd

eeee
fff


gg




hhhhh
ii
*)
