(* ---------------------------------------------------------------
Title         Q&D Extended Dump
Author        PhG
Overview      dec/hex/ascii dump/split/rebuild/patch
Usage         see help
Notes         another complete waste of time...
              isoleItemS wants only one separator, so we need an argv here
              fix while creating : looking for " | " when only " |" was in line !
              yes, when patching, we should check offset against current file size...
              (for now, it increases file at specified offset, but who cares ?)
              is single-stepping when not paging really useful ?
              out of lazyness, doMemory() still has fewer features than doDump()
              checking all irrelevant options for each command would be too much
              (besides, we could just ignore them)
              fixoddold is older rounding upwards, while fixed fixodd rounds downwards
              (note file percentage is rounded according to horizontal byte count)
Wish list     allow change to a read-only file ?
              a variable format string for ouput
              change my favorite dump colors through ini or var ?

              check options filtering according to command !

              one of these days, port our old Apple ][ list code
              even in a minimalist way (LISTDONE false for now)

Bugs

--------------------------------------------------------------- *)

MODULE XD;

IMPORT Lib;
IMPORT FIO;
IMPORT Str;
IMPORT IO;
IMPORT SYSTEM;

FROM FIO IMPORT FIXEDLIBS;

FROM QD_Box IMPORT str80, str2, cmdInit, cmdShow, cmdStop, delim,
Work, video, Ltrim, Rtrim, UpperCase, LowerCase, ReplaceChar,
ChkEscape, Waitkey, WaitkeyDelay, Flushkey, IsRedirected, chkJoker,
isOption, GetOptIndex, GetLongCard, GetLongInt, GetString, CharCount,
same, aR, aH, aS, aD, aA, everything, isDirectory, fixDirectory,
str128, str256, Animation, allfiles, Belongs, FixAE, CodePhonetic,
CodeSoundex, CodeSoundexOrg, isReadOnly, LtrimBlanks, RtrimBlanks,
getStrIndex, cmdSHOW,BiosWaitkey,BiosWaitkeyShifted,BiosFlushkey,
str1024, isoleItemS, dmpTTX, str2048, Elapsed, TerminalReadString,
getDosVersion, DosVersion, warning95, runningWindows,
aV, reallyeverything, chkClassicTextMode, setClassicTextMode,
AltAnimation, str16, getCurrentDirectory, setReadWrite, setReadOnly,
getFileSize, verifyString, str4096, unfixDirectory,
animShow, animSHOW, animAdvance, animEnd, animClear,
animInit, animGetSdone, anim, cleantabs, UpperCaseAlt, LowerCaseAlt,
completedInit, completedShow, completedSHOW, completedEnd, completed,
removeDups, isValidHDunit, removePhantoms, removeFloppies,
getCDROMunits, getCDROMletters, removeCDROMs, getAllHDunits,
getAllLegalUnits;

FROM QD_LFN IMPORT path9X, huge9X, findDataRecordType,
unicodeConversionFlagType, w9XchangeDir,
w9XgetDOSversion, w9XgetTrueDOSversion, w9XisWindowsEnh, w9XisMSDOS7,
w9XfindFirst, w9XfindNext, w9XfindClose, w9XgetCurrentDirectory,
w9XlongToShort, w9XshortToLong, w9XtrueName, w9XchangeDir,
w9XmakeDir, w9XrmDir, w9Xrename, w9XopenFile, w9XcloseFile,
w9XsupportLFN;

FROM QD_File IMPORT pathtype, w9XnothingRequired,
fileOpenRead, fileOpen, fileExists, fileIsRO, fileSetRW, fileSetRO,
fileErase, fileCreate, fileRename, fileGetFileSize, fileIsDirectorySpec;

FROM QD_Text IMPORT
colortype, cursorshapetype, scrolltype,
ff, cr, lf, bs, tab, nl, mincolor, maxcolor,
BW40, CO40, BW80, CO80, CO80x43, CO80x50, MONO,
vesa80x60, vesa132x25, vesa132x43, vesa132x50, vesa132x60,
selectCursorEmulation,
setCursorShape,
handleVesa, setBrightPaper, setBlinkMode,
setFillChar, setFillInk, setFillPaper,
setFillInkPaper, setTxtInk, setTxtPaper, setTxtInkPaper, setWrapMode,
setUseBiosMode, setTabWidth, getScreenData, setWindow,
setMode, restoreMode,
gotoXY, xyToHtabVtab, home, setVisualPage, setActivePage,
scrollWindow, fillTextAttr, cls, writeStr, writeLn, getScreenWidth,
getScreenHeight, getScreenMinX, getScreenMinY, getScreenMaxX, getScreenMaxY,
getMinHtab, getMaxHtab, getMinVtab, getMaxVtab, getUseBiosMode,
getMinHtab, getMaxHtab, getMinVtab, getMaxVtab, getHtab, getVtab,
getWindowWidth, getWindowHeight,
initScreenConsole,
findInkPaperAtStartup, getInkAtStartup, getPaperAtStartup,
setFullScreenWindow, gotoFullScreenXY;

(* ------------------------------------------------------------ *)

CONST
    LISTDONE = FALSE; (* looks like a NeverWare feature now, eh eh... *)

CONST
    (* aliases for our own procedures *)
    WrStr ::= writeStr;
    WrLn  ::= writeLn;

(* full screen window mode set at startup *)

PROCEDURE vidinit ( useBios:BOOLEAN  );
BEGIN
    (* handleVesa; *) (* useless, because we won't change video mode *)
    setUseBiosMode ( useBios );
    findInkPaperAtStartup();
END vidinit;

PROCEDURE colorhelp ();
BEGIN
    setTxtInk(getInkAtStartup());     (* was green *)
    setTxtPaper(getPaperAtStartup()); (* was black *)
    setFillInkPaper(getInkAtStartup(),getPaperAtStartup());
    (*
    setTxtInk(green);
    setTxtPaper(black);
    setFillInkPaper(green,black);
    *)
END colorhelp;

PROCEDURE coloraddr ();
BEGIN
    setTxtInk(white);
    setTxtPaper(black);
    setFillInkPaper(getInkAtStartup(),getPaperAtStartup());
END coloraddr;

PROCEDURE colordata ();
BEGIN
    setTxtInk(yellow);
    setTxtPaper(black);
    setFillInkPaper(getInkAtStartup(),getPaperAtStartup());
END colordata;

PROCEDURE colorascii ();
BEGIN
    setTxtInk(cyan);
    setTxtPaper(black);
    setFillInkPaper(getInkAtStartup(),getPaperAtStartup());
END colorascii;

PROCEDURE colorsep ();
BEGIN
    setTxtInk(red);
    setTxtPaper(black);
    setFillInkPaper(getInkAtStartup(),getPaperAtStartup());
END colorsep;

PROCEDURE colorstatus ();
BEGIN
    (*
    setTxtInk(green);
    setTxtPaper(black);
    *)
    setTxtInk(black);
    setTxtPaper(red);

    setFillInkPaper(getInkAtStartup(),getPaperAtStartup());
END colorstatus;

PROCEDURE getRows (  ):CARDINAL ;
BEGIN
    RETURN getWindowHeight();     (* full screen here *)
END getRows;

PROCEDURE getColumns (  ):CARDINAL ;
BEGIN
    RETURN getWindowWidth();       (* full screen here *)
END getColumns;

(*
PROCEDURE getRows (  ):CARDINAL ;
CONST
    segBIOSdata = 040H;
VAR
    vrows  [segBIOSdata:0084H] : SHORTCARD; (* add 1 *)
BEGIN
    RETURN ( CARDINAL(vrows) +1 ); (* 25, 43, 50, etc. *)
END getRows;

PROCEDURE getColumns (  ):CARDINAL ;
CONST
    segBIOSdata = 040H;
VAR
    vcolumns [segBIOSdata:004AH] : CARDINAL; (* a word *)
BEGIN
    RETURN vcolumns;
END getColumns;
*)

PROCEDURE initRowCounter (VAR rowcounter:CARDINAL; plus:CARDINAL );
CONST
    initrowcounter = 0;
BEGIN
    rowcounter:=initrowcounter;
    INC(rowcounter,plus);
END initRowCounter;

PROCEDURE initColCounter (VAR colcounter:CARDINAL );
CONST
    initcolcounter = 0;
BEGIN
    colcounter:=initcolcounter;
END initColCounter;

(* ------------------------------------------------------------ *)

CONST (* reverse storage logic ! *)
    keyEscape  = 01B00H;
    keySpace   = 02000H;
    keyUp      = 00048H;
    keyDown    = 00050H;
    keyLeft    = 0004BH;
    keyRight   = 0004DH;
    keyPageUp  = 00049H;
    keyPageDown= 00051H;
    (*
    keyMinus   = 02D00H; (* - *)
    keyPlus    = 02B00H; (* + *)
    *)
    keyCR      = 00D00H;
    keyHome    = 00047H;
    keyEnd     = 0004FH;

    key10a     = ORD("1") << 8; key10b    = ORD("&") << 8;
    key20a     = ORD("2") << 8; key20b    = ORD("") << 8;
    key30a     = ORD("3") << 8; key30b    = ORD('"') << 8;
    key40a     = ORD("4") << 8; key40b    = ORD("'") << 8;
    key50a     = ORD("5") << 8; key50b    = ORD("(") << 8;
    key60a     = ORD("6") << 8; key60b    = ORD("-") << 8;
    key70a     = ORD("7") << 8; key70b    = ORD("") << 8;
    key80a     = ORD("8") << 8; key80b    = ORD("_") << 8;
    key90a     = ORD("9") << 8; key90b    = ORD("") << 8;

    keyHelp1   = ORD(",") << 8; keyHelp2  = ORD("?") << 8;
    keyUpperH  = ORD("H") << 8; keyLowerH = ORD("h") << 8;

    keyUpperX  = ORD("X") << 8; keyLowerX = ORD("x") << 8;
    keyUpperW  = ORD("W") << 8; keyLowerW = ORD("w") << 8;
    keyUpperF  = ORD("F") << 8; keyLowerF = ORD("f") << 8;
    keyUpperU  = ORD("U") << 8; keyLowerU = ORD("u") << 8;

    keyUpperP  = ORD("P") << 8; keyLowerP = ORD("p") << 8;
    keyUpperI  = ORD("I") << 8; keyLowerI = ORD("i") << 8;
    keyUpperD  = ORD("D") << 8; keyLowerD = ORD("d") << 8;
    keyUpperA  = ORD("A") << 8; keyLowerA = ORD("a") << 8;

    keyUpperN  = ORD("N") << 8; keyLowerN = ORD("n") << 8;
    keyUpperO  = ORD("O") << 8; keyLowerO = ORD("o") << 8;
    keyUpperS  = ORD("S") << 8; keyLowerS = ORD("s") << 8;
    keyUpperJ  = ORD("J") << 8; keyLowerJ = ORD("j") << 8;

    keyUpperT  = ORD("T") << 8; keyLowerT = ORD("t") << 8;

    keyF1      = 0003BH;
    keyF2      = 0003CH;
    keyF3      = 0003DH;
    keyF4      = 0003EH;
    keyF5      = 0003FH;
    keyF6      = 00040H;
    keyF7      = 00041H;
    keyF8      = 00042H;
    keyF9      = 00043H;
    keyF10     = 00044H;
    keyF11     = 00085H;
    keyF12     = 00086H;

    keyAltP    = 00019H;

CONST
    msgAnykey = "Hit any key to return to previous display... ";
    helpKeys =
"[PageDown][Enter]     move one screen down"+nl+
"[PageUp]              move one screen up"+nl+
"[Down][Right][Space]  move one line down"+nl+
"[Up][Left]            move one line up"+nl+
"[Home][End]           position to start or end of file"+nl+
"[1]..[9]              position to percentage of filesize"+nl+
"[alt-P]               enter new file position"+nl+
"[F9][F10][F12]        display address + data + ASCII (16 bytes per line)"+nl+
"[F8][F11]             display address + ASCII (64 bytes per line)"+nl+
"[X]                   toggle base (hexadecimal or decimal)"+nl+
"[W]                   toggle mode (bytes or words)"+nl+
"[F]                   toggle filter character set (default or less filtered)"+nl+
"[U]                   toggle hexadecimal case (lower or upper)"+nl+
"[P]                   toggle address display"+nl+
"[I]                   toggle binary display"+nl+
"[D]                   toggle data display"+nl+
"[A]                   toggle ASCII display"+nl+
"[N][O][S]             XLAT mode (none, ASCII to OEM, OEM to ASCII)"+nl+
"[J]                   toggle $00 character filtering out in any ASCII display"+nl+
"[F1]..[F6]            4, 8, 16, 32, 64 or 96 bytes per line"+nl+
"[H][?]                help screen"+nl+
"[Esc]                 return to DOS"+nl;

    helpKeysList =
"[PageDown][Enter]     move one screen down"+nl+
"[PageUp]              move one screen up"+nl+
"[Down][Space]         move one line down"+nl+
"[Up]                  move one line up"+nl+
"[Left]                move one tabulation left"+nl+
"[Right]               move one tabulation right"+nl+
"[Home][End]           position to start or end of file"+nl+
"[W]                   toggle wrap mode"+nl+
"[N][O][S]             XLAT mode (none, ASCII to OEM, OEM to ASCII)"+nl+
"[J]                   toggle $00 character filtering out"+nl+
"[X]                   toggle bit 7 (Wordstar mode)"+nl+
"[T]                   toggle tabulation expansion"+nl+
"[H][?]                help screen"+nl+
"[Esc]                 return to DOS"+nl;

(* ------------------------------------------------------------ *)

CONST
    nullchar    = CHR(0);
    diese       = "#";
    semicolon   = ";";
    blank       = " ";      (* 32 = $20 *)
    dquote      = '"';      (* 34 = $22 *)
    colon       = ":";
    dollar      = "$";      (* hex prefix *)

    star        = "*";
    slash       = "/";
    sM2hex      = "H,";

CONST
    ProgEXEname   = "XD";
    ProgTitle     = "Q&D Extended Dump";
    ProgVersion   = "v1.2h";
    ProgCopyright = "by PhG";
    Banner        = ProgTitle+" "+ProgVersion+" "+ProgCopyright;
CONST
    errNone             = 0;
    errHelp             = 1;
    errUnknownOption    = 2;
    errUneededParm      = 3;
    errCmd              = 4;
    errMissingSource    = 5;
    errMissingTarget    = 6;
    errNotFound         = 7;
    errReadonly         = 8;
    errAlreadyExists    = 9;
    errNotFoundTarget   = 10;
    errAborted          = 11;
    errIrrelevant       = 12;
    errBadData          = 13;
    errBadPatch         = 14;
    errNonsense         = 15;
    errMissingSegOfs    = 16;
    errMissingCount     = 17;
    errBadSegOfs        = 18;
    errBadCount         = 19;
    errUneeded          = 20;
    errMissingOffset    = 21;
    errBadLC            = 22;
    errJoker            = 23;
    errJokerTarget      = 24;
    errConflict         = 25;
    errXlat             = 26;
    errSyntaxList       = 27;
    errRedirectionList  = 28;
    errUserFposToFile   = 29;
    errUserFposRange    = 30;
    errHelper           = 64;
VAR
    globalerrorinfo : str256;

PROCEDURE abort (e : CARDINAL; einfo : ARRAY OF CHAR);
CONST
(*
 00000000011111111112222222222333333333344444444445555555555666666666677777777778
 1...'....0....'....0....'....0....'....0....'....0....'....0....'....0....'....0
*)
    helpmsg =
Banner+nl+
nl+
"Syntax 1 : "+ProgEXEname+" [option]... <source> [target]"+nl+
"Syntax 2 : "+ProgEXEname+" -c [option]... <source> <target>"+nl+
"Syntax 3 : "+ProgEXEname+" -p [option]... <source> <target>"+nl+
"Syntax 4 : "+ProgEXEname+" -i[i] [option]... <target> <[$]offset> <:> <data>..."+nl+
"Syntax 5 : "+ProgEXEname+" -x [option]... <[$]segment:offset> <[$]count>"+nl+
(*%T LISTDONE  *)
"Syntax 6 : "+ProgEXEname+" -l[l] [option]... <file>"+nl+
(*%E  *)
nl+
"-c    create <target> from <source> data, ignoring addresses (if any)"+nl+
"-p    patch <target> with <source> data (addresses are required !)"+nl+
"-i[*] patch <target> at file <offset> using <data> (-ii, -i$[$], -ii$[$])"+nl+
'-x    examine memory ("$" is hexadecimal prefix, implicit for offset)'+nl+
(*%T LISTDONE  *)
"-l[l] list <file> (-ll = -l -g)"+nl+
(*%E  *)
nl+
"-#    number of bytes per line : 4, 8, 16, 24 or 32 (default is 16)"+nl+
"-d    assume data is decimal format (default is hexadecimal)"+nl+
"-$[$] assume data is a DOS string (trimmed left and right, -$$ = 0-terminated)"+nl+
"-n    do not display ASCII data after (hexa)decimal data"+nl+
"-r    do not display addresses"+nl+
"-o    overwrite existing target when dumping a <source> or creating a <target>"+nl+
"-u    hexadecimal data in upper case"+nl+
"-m[m] hexadecimal Modula-2 display (-mm = add structure prototype to target)"+nl+
"-a[?] 64 columns ASCII-only display (-aa = -af = -a -f)"+nl+
"-e[?] 64 or 96 columns ASCII-only display (-ee = -ef = -e -f)"+nl+
"-v    verbose"+nl+
"-k    no paging (forced if target specified or if output redirected)"+nl+
"-s    when patching, update date and time stamps"+nl+
(* "-f    fuller ASCII character set"+nl+ *)
"-f    filter out {0,8,9,10,12,13,255} ASCII codes instead of {0..31,255}"+nl+
"-y    remap output from OEM to ASCII (XLAT WIN2PC emulation)"+nl+
"-z    remap output from ASCII to OEM (XLAT PC2WIN emulation)"+nl+
"-j    filter out $00 character in any ASCII display"+nl+
"-b    monochrome BIOS output (no colors, -f ignored when dumping to screen)"+nl+
"-2    insert binary data display (-4 option highly recommended)"+nl+
"-w    display data as words (default is bytes)"+nl+
'-b:#  new base address for dump (default is 0)'+nl+
'-p:#  initial file position for dump ([0..filesize-1], default is 0)'+nl+
(*%T LISTDONE  *)
"-g    when listing, do not wrap lines longer than screen width"+nl+
"-q    when listing, use Wordstar mode (bit 7 cleared)"+nl+
"-!    when listing, do not expand tabulations"+nl+
(*%E  *)
"-t    do not wait for video retrace when paging"+nl+
"-lfn  disable LFN support even if available"+nl+
"-??   more help"+nl+
nl+
"With -c and -p, specified (hexa)decimal byte format must match <source> data."+nl+
"-c option handles hexadecimal data as individual or concatenated bytes."+nl+
"With -i, default format is hexadecimal, unless -d option is specified."+nl+
"With -p, "+'"'+star+'"'+" or "+'"'+slash+'"'+" are treated as the end of <source> data file."+nl+
"With -x, address display format is not segment:offset but linear."+nl+
'-p:# and -b:# options handle decimal or hexadecimal ("$" prefix).'+nl+
"-m[m], -a and -e options override and/or ignore any other conflicting option."+nl+
"For obvious reasons, <source> should not be more than 2Gb long. ;-)"+nl+
"This program does NOT create any backup copy, and it does NOT handle jokers."+nl+
(*%F FIXEDLIBS  *)
nl+
"Unfortunately, thanks (!) to a silly bug in TopSpeed Modula-2 FIO library,"+nl+
"paths are limited to 65 characters (longer ones will NOT be found). :-("+nl+
(*%E *)
"";
    helpmsgplus =
nl+
"Examples : "+ProgEXEname+" -p patch.pat test.exe"+nl+
"           "+ProgEXEname+" -i test.exe 0 : 00 00"+nl+
"           "+ProgEXEname+' -i -$ test.exe 0 : "PhG"'+nl+
"           "+ProgEXEname+" -2 -4 test.exe"+nl+
"           "+ProgEXEname+" -x $40:4A 256"+nl;

VAR
    S : str256;
BEGIN
    colorhelp;
    CASE e OF
    | errHelp :
        WrStr(helpmsg);
    | errUnknownOption :
        Str.Concat(S,"Unknown ",einfo);Str.Append(S," option !");
    | errUneededParm :
        Str.Concat(S,"Uneeded ",einfo);Str.Append(S," parameter !");
    | errCmd :
        S:="-c, -p, -i, -x and -l commands are mutually exclusive !";
    | errMissingSource :
        S:="Missing <source> specification !";
    | errMissingTarget :
        S:="Missing <target> specification !";
    | errNotFound :
        Str.Concat(S,einfo," <source> does not exist !");
    | errReadonly :
        Str.Concat(S,einfo," <target> is read-only !");
    | errAlreadyExists :
        Str.Concat(S,einfo," <target> already exists !");
    | errNotFoundTarget :
        Str.Concat(S,einfo," <target> does not exist !");
    | errAborted:
        S := "Aborted by user !";
    | errIrrelevant:
        Str.Concat(S,einfo," option does not apply to specified command !");
    | errBadData :
        Str.Concat(S,"Problem in data line (illegal value, missing or illegal address) !",nl+nl);
        Str.Append(S,'Check it : "');
        Str.Append(S,globalerrorinfo);
        Str.Append(S,'"');
    | errBadPatch :
        Str.Concat(S,'Illegal "',globalerrorinfo);Str.Append(S,'" patch line !');
    | errNonsense:
        S:="-u is a nonsense with -d format !";
    | errMissingSegOfs:
        S:="Missing <[$]segment:offset> specification !";
    | errMissingCount:
        S:="Missing <[$]count> specification !";
    | errBadSegOfs:
        Str.Concat(S,einfo," <[$]segment:offset> does not make sense !");
    | errBadCount:
        Str.Concat(S,einfo," <[$]count> does not make sense !");
    | errUneeded:
        S := "Uneeded parameters specified !";
    | errMissingOffset:
        S := "Missing <offset> specification !";
    | errBadLC:
        Str.Concat(S,'Illegal "',einfo);Str.Append(S,'" value !');
    | errJoker :
        Str.Concat(S,einfo," <source> should not contain any joker !");
    | errJokerTarget :
        Str.Concat(S,einfo," <target> should not contain any joker !");
    | errConflict:
        S:="-m[m], -a and -e options are mutually exclusive !";
    | errXlat:
        S:="-y and -z options are mutually exclusive !";
    | errSyntaxList:
        Str.Concat(S,"Uneeded ",einfo);Str.Append(S," parameter !");
    | errRedirectionList:
        S:="Redirection is a nonsense with -l command !";
    | errUserFposToFile:
        S:="-p:# is a nonsense when dumping <source> to a file !";
    | errUserFposRange:
        S:="-p:# is out of <source> [0..filesize-1] range !";

    | errHelper:
        WrStr(helpmsg);
        WrStr(helpmsgplus);
        WrStr(nl+
              "Here are keys available while dumping :"+nl+
              nl);
        WrStr(helpKeys);
(*%T LISTDONE  *)
        WrStr(nl+
              "Here are keys available while listing :"+nl+
              nl);
        WrStr(helpKeysList);
(*%E  *)
        e:=errHelp;
    ELSE
        S := "This is illogical, Captain !";
    END;
    CASE e OF
    | errNone,errHelp :
        ; (* nada *)
    ELSE
        WrStr(ProgEXEname+" : "); WrStr(S); WrLn;
    END;
    Lib.SetReturnCode(SHORTCARD(e));
    HALT;
END abort;

(* ------------------------------------------------------------ *)

PROCEDURE sound (freq,duration:CARDINAL);
BEGIN
    Lib.Sound(freq);
    Lib.Delay(duration);
    Lib.NoSound();
END sound;

PROCEDURE buzz (  );
BEGIN
    sound(55,50);
END buzz;

PROCEDURE WaitVGAretrace ();
BEGIN
    WHILE (SYSTEM.In(03DAH) AND 08H) # 0 DO
    END;
    WHILE (SYSTEM.In(03DAH) AND 08H) = 0 DO
    END;
END WaitVGAretrace;

(* ------------------------------------------------------------ *)
(* ------------------------------------------------------------ *)

(* ripped and adapted from old PC2WIN v1.0a dated 29 Apr 00 *)

TYPE
    chardef   = RECORD
                    Code    : BYTE;
                    Flag    : CHAR;
                    MapChar : BYTE;
                END;
    CharTable = ARRAY [0..255] OF chardef;

CONST
    TpcTOwin  = CharTable (
    chardef(000H, "=", 000H),
    chardef(001H, "=", 001H),
    chardef(002H, "=", 002H),
    chardef(003H, "=", 003H),
    chardef(004H, "=", 004H),
    chardef(005H, "=", 005H),
    chardef(006H, "=", 006H),
    chardef(007H, "=", 007H),
    chardef(008H, "=", 008H),
    chardef(009H, "!", 009H),
    chardef(00AH, "=", 00AH),
    chardef(00BH, "=", 00BH),
    chardef(00CH, "=", 00CH),
    chardef(00DH, "=", 00DH),
    chardef(00EH, "=", 00EH),
    chardef(00FH, "=", 00FH),
    chardef(010H, "=", 010H),
    chardef(011H, "=", 011H),
    chardef(012H, "=", 012H),
    chardef(013H, "=", 013H),
    chardef(014H, "!", 0B6H),
    chardef(015H, "!", 0A7H),
    chardef(016H, "=", 016H),
    chardef(017H, "=", 017H),
    chardef(018H, "=", 018H),
    chardef(019H, "=", 019H),
    chardef(01AH, "=", 01AH),
    chardef(01BH, "=", 01BH),
    chardef(01CH, "=", 01CH),
    chardef(01DH, "=", 01DH),
    chardef(01EH, "=", 01EH),
    chardef(01FH, "=", 01FH),
    chardef(020H, "=",  " "),
    chardef(021H, "=",  "!"),
    chardef(022H, "=",  '"'),
    chardef(023H, "=",  "#"),
    chardef(024H, "=",  "$"),
    chardef(025H, "=",  "%"),
    chardef(026H, "=",  "&"),
    chardef(027H, "=",  "'"),
    chardef(028H, "=",  "("),
    chardef(029H, "=",  ")"),
    chardef(02AH, "=",  "*"),
    chardef(02BH, "=",  "+"),
    chardef(02CH, "=",  ","),
    chardef(02DH, "=",  "-"),
    chardef(02EH, "=",  "."),
    chardef(02FH, "=",  "/"),
    chardef(030H, "=",  "0"),
    chardef(031H, "=",  "1"),
    chardef(032H, "=",  "2"),
    chardef(033H, "=",  "3"),
    chardef(034H, "=",  "4"),
    chardef(035H, "=",  "5"),
    chardef(036H, "=",  "6"),
    chardef(037H, "=",  "7"),
    chardef(038H, "=",  "8"),
    chardef(039H, "=",  "9"),
    chardef(03AH, "=",  ":"),
    chardef(03BH, "=",  ";"),
    chardef(03CH, "=",  "<"),
    chardef(03DH, "=",  "="),
    chardef(03EH, "=",  ">"),
    chardef(03FH, "=",  "?"),
    chardef(040H, "=",  "@"),
    chardef(041H, "=",  "A"),
    chardef(042H, "=",  "B"),
    chardef(043H, "=",  "C"),
    chardef(044H, "=",  "D"),
    chardef(045H, "=",  "E"),
    chardef(046H, "=",  "F"),
    chardef(047H, "=",  "G"),
    chardef(048H, "=",  "H"),
    chardef(049H, "=",  "I"),
    chardef(04AH, "=",  "J"),
    chardef(04BH, "=",  "K"),
    chardef(04CH, "=",  "L"),
    chardef(04DH, "=",  "M"),
    chardef(04EH, "=",  "N"),
    chardef(04FH, "=",  "O"),
    chardef(050H, "=",  "P"),
    chardef(051H, "=",  "Q"),
    chardef(052H, "=",  "R"),
    chardef(053H, "=",  "S"),
    chardef(054H, "=",  "T"),
    chardef(055H, "=",  "U"),
    chardef(056H, "=",  "V"),
    chardef(057H, "=",  "W"),
    chardef(058H, "=",  "X"),
    chardef(059H, "=",  "Y"),
    chardef(05AH, "=",  "Z"),
    chardef(05BH, "=",  "["),
    chardef(05CH, "=",  "\"),
    chardef(05DH, "=",  "]"),
    chardef(05EH, "=",  "^"),
    chardef(05FH, "=",  "_"),
    chardef(060H, "=",  "`"),
    chardef(061H, "=",  "a"),
    chardef(062H, "=",  "b"),
    chardef(063H, "=",  "c"),
    chardef(064H, "=",  "d"),
    chardef(065H, "=",  "e"),
    chardef(066H, "=",  "f"),
    chardef(067H, "=",  "g"),
    chardef(068H, "=",  "h"),
    chardef(069H, "=",  "i"),
    chardef(06AH, "=",  "j"),
    chardef(06BH, "=",  "k"),
    chardef(06CH, "=",  "l"),
    chardef(06DH, "=",  "m"),
    chardef(06EH, "=",  "n"),
    chardef(06FH, "=",  "o"),
    chardef(070H, "=",  "p"),
    chardef(071H, "=",  "q"),
    chardef(072H, "=",  "r"),
    chardef(073H, "=",  "s"),
    chardef(074H, "=",  "t"),
    chardef(075H, "=",  "u"),
    chardef(076H, "=",  "v"),
    chardef(077H, "=",  "w"),
    chardef(078H, "=",  "x"),
    chardef(079H, "=",  "y"),
    chardef(07AH, "=",  "z"),
    chardef(07BH, "=",  "{"),
    chardef(07CH, "=",  "|"),
    chardef(07DH, "=",  "}"),
    chardef(07EH, "=",  "~"),
    chardef(07FH, "?",  " "),
    chardef(080H, "=", 0C7H),
    chardef(081H, "=", 0FCH),
    chardef(082H, "=", 0E9H),
    chardef(083H, "=", 0E2H),
    chardef(084H, "=", 0E4H),
    chardef(085H, "=", 0E0H),
    chardef(086H, "=", 0E5H),
    chardef(087H, "=", 0E7H),
    chardef(088H, "=", 0EAH),
    chardef(089H, "=", 0EBH),
    chardef(08AH, "=", 0E8H),
    chardef(08BH, "=", 0EFH),
    chardef(08CH, "=", 0EEH),
    chardef(08DH, "=", 0ECH),
    chardef(08EH, "=", 0C4H),
    chardef(08FH, "=", 0C5H),
    chardef(090H, "=", 0C9H),
    chardef(091H, "=", 0E6H),
    chardef(092H, "=", 0C6H),
    chardef(093H, "=", 0F4H),
    chardef(094H, "=", 0F6H),
    chardef(095H, "=", 0F2H),
    chardef(096H, "=", 0FBH),
    chardef(097H, "=", 0F9H),
    chardef(098H, "=", 0FFH),
    chardef(099H, "=", 0D6H),
    chardef(09AH, "=", 0DCH),
    chardef(09BH, "=", 0A2H),
    chardef(09CH, "=", 0A3H),
    chardef(09DH, "=", 0A5H),
    chardef(09EH, "?",  " "),
    chardef(09FH, "?",  " "),
    chardef(0A0H, "=", 0E1H),
    chardef(0A1H, "=", 0EDH),
    chardef(0A2H, "=", 0F3H),
    chardef(0A3H, "=", 0FAH),
    chardef(0A4H, "=", 0F1H),
    chardef(0A5H, "=", 0D1H),
    chardef(0A6H, "=", 0AAH),
    chardef(0A7H, "=", 0BAH),
    chardef(0A8H, "=", 0BFH),
    chardef(0A9H, "?",  " "),
    chardef(0AAH, "=", 0ACH),
    chardef(0ABH, "=", 0BDH),
    chardef(0ACH, "=", 0BCH),
    chardef(0ADH, "=", 0A1H),
    chardef(0AEH, "=", 0ABH),
    chardef(0AFH, "=", 0BBH),
    chardef(0B0H, "@",  " "),
    chardef(0B1H, "@",  " "),
    chardef(0B2H, "@",  " "),
    chardef(0B3H, "@",  " "),
    chardef(0B4H, "@",  " "),
    chardef(0B5H, "@",  " "),
    chardef(0B6H, "@",  " "),
    chardef(0B7H, "@",  " "),
    chardef(0B8H, "@",  " "),
    chardef(0B9H, "@",  " "),
    chardef(0BAH, "@",  " "),
    chardef(0BBH, "@",  " "),
    chardef(0BCH, "@",  " "),
    chardef(0BDH, "@",  " "),
    chardef(0BEH, "@",  " "),
    chardef(0BFH, "@",  " "),
    chardef(0C0H, "@",  " "),
    chardef(0C1H, "@",  " "),
    chardef(0C2H, "@",  " "),
    chardef(0C3H, "@",  " "),
    chardef(0C4H, "@",  " "),
    chardef(0C5H, "@",  " "),
    chardef(0C6H, "@",  " "),
    chardef(0C7H, "@",  " "),
    chardef(0C8H, "@",  " "),
    chardef(0C9H, "@",  " "),
    chardef(0CAH, "@",  " "),
    chardef(0CBH, "@",  " "),
    chardef(0CCH, "@",  " "),
    chardef(0CDH, "@",  " "),
    chardef(0CEH, "@",  " "),
    chardef(0CFH, "@",  " "),
    chardef(0D0H, "@",  " "),
    chardef(0D1H, "@",  " "),
    chardef(0D2H, "@",  " "),
    chardef(0D3H, "@",  " "),
    chardef(0D4H, "@",  " "),
    chardef(0D5H, "@",  " "),
    chardef(0D6H, "@",  " "),
    chardef(0D7H, "@",  " "),
    chardef(0D8H, "@",  " "),
    chardef(0D9H, "@",  " "),
    chardef(0DAH, "@",  " "),
    chardef(0DBH, "@",  " "),
    chardef(0DCH, "@",  " "),
    chardef(0DDH, "@",  " "),
    chardef(0DEH, "@",  " "),
    chardef(0DFH, "@",  " "),
    chardef(0E0H, "?",  " "),
    chardef(0E1H, "=", 0DFH),
    chardef(0E2H, "?",  " "),
    chardef(0E3H, "?",  " "),
    chardef(0E4H, "?",  " "),
    chardef(0E5H, "?",  " "),
    chardef(0E6H, "=", 0B5H),
    chardef(0E7H, "?",  " "),
    chardef(0E8H, "?",  " "),
    chardef(0E9H, "?",  " "),
    chardef(0EAH, "?",  " "),
    chardef(0EBH, "?",  " "),
    chardef(0ECH, "?",  " "),
    chardef(0EDH, "=", 0D8H),
    chardef(0EEH, "?",  " "),
    chardef(0EFH, "?",  " "),
    chardef(0F0H, "?",  " "),
    chardef(0F1H, "=", 0B1H),
    chardef(0F2H, "?",  " "),
    chardef(0F3H, "?",  " "),
    chardef(0F4H, "?",  " "),
    chardef(0F5H, "?",  " "),
    chardef(0F6H, "=", 0F7H),
    chardef(0F7H, "?",  " "),
    chardef(0F8H, "=", 0B0H),
    chardef(0F9H, "?",  " "),
    chardef(0FAH, "?",  " "),
    chardef(0FBH, "?",  " "),
    chardef(0FCH, "?",  " "),
    chardef(0FDH, "=", 0B2H),
    chardef(0FEH, "?",  " "),
    chardef(0FFH, "=",  " "));

(* ripped and adapted from old WIN2PC v1.0a dated 29 Apr 00 *)

CONST
    TwinTOpc  = CharTable(
    chardef(000H, "=", 000H),
    chardef(001H, "=", 001H),
    chardef(002H, "=", 002H),
    chardef(003H, "=", 003H),
    chardef(004H, "=", 004H),
    chardef(005H, "=", 005H),
    chardef(006H, "=", 006H),
    chardef(007H, "=", 007H),
    chardef(008H, "=", 008H),
    chardef(009H, "!", 009H),
    chardef(00AH, "=", 00AH),
    chardef(00BH, "=", 00BH),
    chardef(00CH, "=", 00CH),
    chardef(00DH, "=", 00DH),
    chardef(00EH, "=", 00EH),
    chardef(00FH, "=", 00FH),
    chardef(010H, "=", 010H),
    chardef(011H, "=", 011H),
    chardef(012H, "=", 012H),
    chardef(013H, "=", 013H),
    chardef(014H, "=", 014H),
    chardef(015H, "=", 015H),
    chardef(016H, "=", 016H),
    chardef(017H, "=", 017H),
    chardef(018H, "=", 018H),
    chardef(019H, "=", 019H),
    chardef(01AH, "=", 01AH),
    chardef(01BH, "=", 01BH),
    chardef(01CH, "=", 01CH),
    chardef(01DH, "=", 01DH),
    chardef(01EH, "=", 01EH),
    chardef(01FH, "=", 01FH),
    chardef(020H, "=",  " "),
    chardef(021H, "=",  "!"),
    chardef(022H, "=",  '"'),
    chardef(023H, "=",  "#"),
    chardef(024H, "=",  "$"),
    chardef(025H, "=",  "%"),
    chardef(026H, "=",  "&"),
    chardef(027H, "=",  "'"),
    chardef(028H, "=",  "("),
    chardef(029H, "=",  ")"),
    chardef(02AH, "=",  "*"),
    chardef(02BH, "=",  "+"),
    chardef(02CH, "=",  ","),
    chardef(02DH, "=",  "-"),
    chardef(02EH, "=",  "."),
    chardef(02FH, "=",  "/"),
    chardef(030H, "=",  "0"),
    chardef(031H, "=",  "1"),
    chardef(032H, "=",  "2"),
    chardef(033H, "=",  "3"),
    chardef(034H, "=",  "4"),
    chardef(035H, "=",  "5"),
    chardef(036H, "=",  "6"),
    chardef(037H, "=",  "7"),
    chardef(038H, "=",  "8"),
    chardef(039H, "=",  "9"),
    chardef(03AH, "=",  ":"),
    chardef(03BH, "=",  ";"),
    chardef(03CH, "=",  "<"),
    chardef(03DH, "=",  "="),
    chardef(03EH, "=",  ">"),
    chardef(03FH, "=",  "?"),
    chardef(040H, "=",  "@"),
    chardef(041H, "=",  "A"),
    chardef(042H, "=",  "B"),
    chardef(043H, "=",  "C"),
    chardef(044H, "=",  "D"),
    chardef(045H, "=",  "E"),
    chardef(046H, "=",  "F"),
    chardef(047H, "=",  "G"),
    chardef(048H, "=",  "H"),
    chardef(049H, "=",  "I"),
    chardef(04AH, "=",  "J"),
    chardef(04BH, "=",  "K"),
    chardef(04CH, "=",  "L"),
    chardef(04DH, "=",  "M"),
    chardef(04EH, "=",  "N"),
    chardef(04FH, "=",  "O"),
    chardef(050H, "=",  "P"),
    chardef(051H, "=",  "Q"),
    chardef(052H, "=",  "R"),
    chardef(053H, "=",  "S"),
    chardef(054H, "=",  "T"),
    chardef(055H, "=",  "U"),
    chardef(056H, "=",  "V"),
    chardef(057H, "=",  "W"),
    chardef(058H, "=",  "X"),
    chardef(059H, "=",  "Y"),
    chardef(05AH, "=",  "Z"),
    chardef(05BH, "=",  "["),
    chardef(05CH, "=",  "\"),
    chardef(05DH, "=",  "]"),
    chardef(05EH, "=",  "^"),
    chardef(05FH, "=",  "_"),
    chardef(060H, "=",  "`"),
    chardef(061H, "=",  "a"),
    chardef(062H, "=",  "b"),
    chardef(063H, "=",  "c"),
    chardef(064H, "=",  "d"),
    chardef(065H, "=",  "e"),
    chardef(066H, "=",  "f"),
    chardef(067H, "=",  "g"),
    chardef(068H, "=",  "h"),
    chardef(069H, "=",  "i"),
    chardef(06AH, "=",  "j"),
    chardef(06BH, "=",  "k"),
    chardef(06CH, "=",  "l"),
    chardef(06DH, "=",  "m"),
    chardef(06EH, "=",  "n"),
    chardef(06FH, "=",  "o"),
    chardef(070H, "=",  "p"),
    chardef(071H, "=",  "q"),
    chardef(072H, "=",  "r"),
    chardef(073H, "=",  "s"),
    chardef(074H, "=",  "t"),
    chardef(075H, "=",  "u"),
    chardef(076H, "=",  "v"),
    chardef(077H, "=",  "w"),
    chardef(078H, "=",  "x"),
    chardef(079H, "=",  "y"),
    chardef(07AH, "=",  "z"),
    chardef(07BH, "=",  "{"),
    chardef(07CH, "=",  "|"),
    chardef(07DH, "=",  "}"),
    chardef(07EH, "=",  "~"),
    chardef(07FH, "x",  " "),
    chardef(080H, "x",  " "),
    chardef(081H, "x",  " "),
    chardef(082H, "x",  " "),
    chardef(083H, "x",  " "),
    chardef(084H, "x",  " "),
    chardef(085H, "x",  " "),
    chardef(086H, "x",  " "),
    chardef(087H, "x",  " "),
    chardef(088H, "x",  " "),
    chardef(089H, "x",  " "),
    chardef(08AH, "x",  " "),
    chardef(08BH, "x",  " "),
    chardef(08CH, "x",  " "),
    chardef(08DH, "x",  " "),
    chardef(08EH, "x",  " "),
    chardef(08FH, "x",  " "),
    chardef(090H, "x",  " "),
    chardef(091H, "=",  "'"),
    chardef(092H, "=",  "'"),
    chardef(093H, "x",  " "),
    chardef(094H, "x",  " "),
    chardef(095H, "x",  " "),
    chardef(096H, "x",  " "),
    chardef(097H, "x",  " "),
    chardef(098H, "x",  " "),
    chardef(099H, "x",  " "),
    chardef(09AH, "x",  " "),
    chardef(09BH, "x",  " "),
    chardef(09CH, "x",  " "),
    chardef(09DH, "x",  " "),
    chardef(09EH, "x",  " "),
    chardef(09FH, "x",  " "),
    chardef(0A0H, "=",  " "),
    chardef(0A1H, "=",  ""),
    chardef(0A2H, "=",  ""),
    chardef(0A3H, "=",  ""),
    chardef(0A4H, "=",  ""),
    chardef(0A5H, "=",  ""),
    chardef(0A6H, "=",  "|"),
    chardef(0A7H, "!", 015H),
    chardef(0A8H, "?",  " "),
    chardef(0A9H, "!",  ""),
    chardef(0AAH, "=",  ""),
    chardef(0ABH, "=",  ""),
    chardef(0ACH, "=",  ""),
    chardef(0ADH, "=",  "-"),
    chardef(0AEH, "!",  ""),
    chardef(0AFH, "!",  "-"),
    chardef(0B0H, "=",  ""),
    chardef(0B1H, "=",  ""),
    chardef(0B2H, "=",  ""),
    chardef(0B3H, "?",  " "),
    chardef(0B4H, "?",  " "),
    chardef(0B5H, "=",  ""),
    chardef(0B6H, "!", 014H),
    chardef(0B7H, "?",  " "),
    chardef(0B8H, "?",  " "),
    chardef(0B9H, "?",  " "),
    chardef(0BAH, "=",  ""),
    chardef(0BBH, "=",  ""),
    chardef(0BCH, "=",  ""),
    chardef(0BDH, "=",  ""),
    chardef(0BEH, "?",  " "),
    chardef(0BFH, "=",  ""),
    chardef(0C0H, "=",  "A"),
    chardef(0C1H, "=",  "A"),
    chardef(0C2H, "=",  "A"),
    chardef(0C3H, "=",  "A"),
    chardef(0C4H, "=",  ""),
    chardef(0C5H, "=",  ""),
    chardef(0C6H, "=",  ""),
    chardef(0C7H, "=",  ""),
    chardef(0C8H, "=",  "E"),
    chardef(0C9H, "=",  ""),
    chardef(0CAH, "=",  "E"),
    chardef(0CBH, "=",  "E"),
    chardef(0CCH, "=",  "I"),
    chardef(0CDH, "=",  "I"),
    chardef(0CEH, "=",  "I"),
    chardef(0CFH, "=",  "I"),
    chardef(0D0H, "?",  " "),
    chardef(0D1H, "=",  ""),
    chardef(0D2H, "=",  "O"),
    chardef(0D3H, "=",  "O"),
    chardef(0D4H, "=",  "O"),
    chardef(0D5H, "=",  "O"),
    chardef(0D6H, "=",  ""),
    chardef(0D7H, "=",  "X"),
    chardef(0D8H, "=",  "O"),
    chardef(0D9H, "=",  "U"),
    chardef(0DAH, "=",  "U"),
    chardef(0DBH, "=",  "U"),
    chardef(0DCH, "=",  ""),
    chardef(0DDH, "=",  "Y"),
    chardef(0DEH, "?",  " "),
    chardef(0DFH, "=",  ""),
    chardef(0E0H, "=",  ""),
    chardef(0E1H, "=",  ""),
    chardef(0E2H, "=",  ""),
    chardef(0E3H, "=",  "a"),
    chardef(0E4H, "=",  ""),
    chardef(0E5H, "=",  ""),
    chardef(0E6H, "=",  ""),
    chardef(0E7H, "=",  ""),
    chardef(0E8H, "=",  ""),
    chardef(0E9H, "=",  ""),
    chardef(0EAH, "=",  ""),
    chardef(0EBH, "=",  ""),
    chardef(0ECH, "=",  ""),
    chardef(0EDH, "=",  ""),
    chardef(0EEH, "=",  ""),
    chardef(0EFH, "=",  ""),
    chardef(0F0H, "?",  " "),
    chardef(0F1H, "=",  ""),
    chardef(0F2H, "=",  ""),
    chardef(0F3H, "=",  ""),
    chardef(0F4H, "=",  ""),
    chardef(0F5H, "=",  "o"),
    chardef(0F6H, "=",  ""),
    chardef(0F7H, "=",  ""),
    chardef(0F8H, "=",  "o"),
    chardef(0F9H, "=",  ""),
    chardef(0FAH, "=",  ""),
    chardef(0FBH, "=",  ""),
    chardef(0FCH, "=",  ""),
    chardef(0FDH, "=",  "y"),
    chardef(0FEH, "?",  " "),
    chardef(0FFH, "=",  ""));

(* we don't care about flag here *)

PROCEDURE remap2ascii (ch:CHAR):CHAR;
BEGIN
    RETURN TwinTOpc[ ORD(ch) ].MapChar;
END remap2ascii;

PROCEDURE remap2oem (ch:CHAR):CHAR;
BEGIN
    RETURN TpcTOwin[ ORD(ch) ].MapChar;
END remap2oem;

(* ------------------------------------------------------------ *)
(* ------------------------------------------------------------ *)

CONST
    UNDEF        = MAX(CARDINAL);
    UNDEFINED    = MAX(LONGCARD);
TYPE
    options      = (decimalbase,overwrite,uppercase,
                    verbose,silent,
                    showaddress,showbinary,showdata,showascii,
                    modula2,paging,samestamp,fullset,words,
                    allowsinglestep,syncvideo,
                    widestmode,forcebios,
                    xlatnone,xlatoemtoascii,xlatasciitooem,unicrap,
                    onlyascii,nowrap,wordstar,packtab,
                    modula2proto,
                    stringdata,stringZ);
    setOfOptions = SET OF options;
    commands     = (dump,create,patch,memory,patchfromCLI,list);
    setOfCommands= SET OF commands;
VAR
    bytesPerLine : CARDINAL;
    dumpMode     : setOfOptions;
    command      : setOfCommands;
    baseaddr     : LONGCARD;
    userfpos     : LONGCARD;

PROCEDURE initDefaults (  );
BEGIN
    bytesPerLine := UNDEF; (* was 16 *)
    dumpMode     := setOfOptions {samestamp,paging,syncvideo,
                                 showaddress,showdata,showascii,
                                 xlatnone}; (* -s disables samestamp, -t disables syncvideo *)
    command      := setOfCommands{dump};
    baseaddr     := UNDEFINED;
    userfpos     := UNDEFINED;
END initDefaults;

(* ------------------------------------------------------------ *)

CONST
    ioBufferSize    = (8 * 512) + FIO.BufferOverhead;
    firstBufferByte = 1;
    lastBufferByte  = ioBufferSize;
TYPE
    ioBuffer  = ARRAY [firstBufferByte..lastBufferByte] OF BYTE;
VAR
    bufferIn : ioBuffer;
    bufferOut: ioBuffer;

(* ------------------------------------------------------------ *)

PROCEDURE PadBina (v : LONGCARD; digits : CARDINAL) : str16;
CONST
    padStr = "0000000000000000"; (* 16 digits *)
VAR
    S : str16;
    R : str16;
    ok : BOOLEAN;
    len,delta : CARDINAL;
BEGIN
    IF digits > 16 THEN digits := 1; END;
    Str.CardToStr (v,S,2,ok);
    len := Str.Length(S);
    IF len > digits THEN digits := len; END;
    delta := digits - len;
    Str.Slice (R,padStr,0,delta);
    Str.Append (R,S);
    RETURN R;
END PadBina;

PROCEDURE PadHex (v : LONGCARD; digits : CARDINAL) : str16;
CONST
    padStr = "0000000000000000"; (* 16 digits *)
VAR
    S : str16;
    R : str16;
    ok : BOOLEAN;
    len,delta : CARDINAL;
BEGIN
    IF digits > 16 THEN digits := 1; END;
    Str.CardToStr (v,S,16,ok);
    len := Str.Length(S);
    IF len > digits THEN digits := len; END;
    delta := digits - len;
    Str.Slice (R,padStr,0,delta);
    Str.Append (R,S);
    RETURN R;
END PadHex;

PROCEDURE PadDec (v : LONGCARD; digits : CARDINAL) : str16;
CONST
    padStr = "                "; (* 16 digits *)
VAR
    S : str16;
    R : str16;
    ok : BOOLEAN;
    len,delta : CARDINAL;
BEGIN
    IF digits > 16 THEN digits := 1; END;
    Str.CardToStr (v,S,10,ok);
    len := Str.Length(S);
    IF len > digits THEN digits := len; END;
    delta := digits - len;
    Str.Slice (R,padStr,0,delta);
    Str.Append (R,S);
    RETURN R;
END PadDec;

(* well... with our writeLn proc, useless except for cr,lf,bs,tab,ff ? *)
(* what about ugly bell ? *)

PROCEDURE charFilter (fullercharset:BOOLEAN; c : CHAR) : CHAR;
BEGIN
    IF fullercharset THEN
        CASE c OF
        | cr,lf,tab,bs,ff :
            RETURN ".";
        | nullchar,CHR(255):
            RETURN ".";
        ELSE
            RETURN c;
        END;
    ELSE
        IF ( (ORD(c) < ORD(blank)) OR (ORD(c) = 255) ) THEN
            RETURN ".";
        ELSE
            RETURN c;
        END;
    END;
END charFilter;

(* ------------------------------------------------------------ *)

(* we use VAR as to go a little faster : nay, not even really faster in fact ! *)

PROCEDURE argc (cli : ARRAY OF CHAR; clean : BOOLEAN) : CARDINAL;
VAR
    state    : (empty,intoken,instring);
    cliLen   : CARDINAL;
    cliPos   : CARDINAL;
    argCount : CARDINAL;
    char     : CHAR;
    code     : CARDINAL;
    arg      : str128;
BEGIN
    IF clean THEN
        LtrimBlanks(cli);
        RtrimBlanks(cli);
    END;
    cliLen   := Str.Length(cli);
    cliPos   := 1;
    argCount := 0;
    state    := empty;
    LOOP
        IF cliPos > cliLen THEN EXIT; END;
        char := cli[cliPos-1];
        code := ORD(char);
        CASE state OF
        | empty :
            IF code = ORD(dquote) THEN
                state := instring;        (* begin new string *)
                Str.Copy(arg,char);
                INC(argCount);
            ELSIF code > ORD(blank) THEN  (* quote already trapped *)
                state := intoken;         (* begin new token *)
                Str.Copy(arg,char);
                INC(argCount);
            END;
        | intoken :
            IF code = ORD(dquote) THEN     (* quote in token *)
                state := instring;        (* if string in parameter *)
                Str.Append(arg,char);
            ELSIF code > ORD(blank) THEN
                Str.Append(arg,char);
            ELSE
                state := empty;           (* end of token *)
            END;
        | instring :
            IF code = ORD(dquote) THEN
                Str.Append(arg,char);
                state := empty;           (* end of string *)
            ELSIF code > ORD(blank) THEN
                Str.Append(arg,char);
            ELSE
                Str.Append(arg,blank);    (* remove TAB and controls if any *)
            END;
        END;
        INC(cliPos);
    END;
    RETURN argCount;
END argc;

PROCEDURE argv (VAR argument : ARRAY OF CHAR;
                cli : ARRAY OF CHAR; n : CARDINAL; clean:BOOLEAN);
VAR
    state    : (empty,intoken,instring);
    cliLen   : CARDINAL;
    cliPos   : CARDINAL;
    argCount : CARDINAL;
    char     : CHAR;
    code     : CARDINAL;
    arg      : str128;
BEGIN
    IF ( (n < 1) OR (n > argc(cli,clean)) ) THEN
        Str.Copy(argument,"");
        RETURN;
    END;
    IF clean THEN
        LtrimBlanks(cli);
        RtrimBlanks(cli);
    END;
    cliLen   := Str.Length(cli);
    cliPos   := 1;
    argCount := 0;
    state    := empty;
    LOOP
        IF cliPos > cliLen THEN EXIT; END;
        char := cli[cliPos-1];
        code := ORD(char);
        CASE state OF
        | empty :
            IF n = argCount THEN EXIT; END; (* argV$ test *)
            IF code = ORD(dquote) THEN
                state := instring;        (* begin new string *)
                Str.Copy(arg,char);
                INC(argCount);
            ELSIF code > ORD(blank) THEN  (* quote already trapped *)
                state := intoken;         (* begin new token *)
                Str.Copy(arg,char);
                INC(argCount);
            END;
        | intoken :
            IF code = ORD(dquote) THEN     (* quote in token *)
                state := instring;        (* if string in parameter *)
                Str.Append(arg,char);
            ELSIF code > ORD(blank) THEN
                Str.Append(arg,char);
            ELSE
                state := empty;           (* end of token *)
            END;
        | instring :
            IF code = ORD(dquote) THEN
                Str.Append(arg,char);
                state := empty;           (* end of string *)
            ELSIF code > ORD(blank) THEN
                Str.Append(arg,char);
            ELSE
                Str.Append(arg,blank);    (* remove TAB and controls if any *)
            END;
        END;
        INC(cliPos);
    END;
    Str.Copy(argument,arg);
END argv;

(* ------------------------------------------------------------ *)

(* note we use IO as QD_Box Waitkey *)

PROCEDURE getKeyboardCode (VAR keycode:CARDINAL):BOOLEAN;
VAR
    c1,c2:CHAR;
BEGIN
    IF IO.KeyPressed()=FALSE THEN RETURN FALSE; END;
    c1 := IO.RdKey();
    IF c1 = CHR(0) THEN
        c2 := IO.RdKey();
    ELSE
        c2 := CHR(0);
    END;
    keycode := (ORD(c1) << 8) + ORD(c2);
    RETURN TRUE;
END getKeyboardCode;

(* ------------------------------------------------------------ *)

PROCEDURE appstat (VAR S:ARRAY OF CHAR; N:str2;tf:BOOLEAN);
VAR
    c:CHAR;
BEGIN
    IF tf THEN
        c:=N[0];
    ELSE
        c:=N[1];
    END;
    Str.Append(S,c);
END appstat;

(* this is a Q&D fix in case status paper would no be black *)

PROCEDURE showstatus (VAR wistat:CARDINAL;colcount:CARDINAL;msg:ARRAY OF CHAR);
VAR
    i : CARDINAL;
    S,Z : str1024; (* oversized but we can have more than 256 chars *)
    doit:BOOLEAN;
BEGIN
    doit:=           (wistat < colcount       );
    doit:= (doit AND (wistat > Str.Length(msg)) );
    IF doit THEN
        FOR i:=1 TO wistat DO
            S[i-1]:=blank;
            Z[i-1]:=bs;
        END;
        S[wistat]:=nullchar;
        Z[wistat]:=nullchar;
        WrStr(S);          (* spaces until width *)
        WrStr(Z);          (* backspaces to beginning of line *)
    END;
    WrStr(msg);
    wistat := 0; (* reinit "nunc et autem" *)
END showstatus;

PROCEDURE fmtstatus (flags:setOfOptions;count:CARDINAL;replaceme:CHAR; msg:ARRAY OF CHAR):str80;
VAR
    R:str80;
    S:str16;
BEGIN
    Str.Copy(R,msg);

    S:="";
    appstat(S,"Xx",(decimalbase IN flags));
    appstat(S,"Ww",(words IN flags));
    appstat(S,"Ff",(fullset IN flags));
    appstat(S,"Uu",(uppercase IN flags));
    appstat(S,"Pp",(showaddress IN flags));
    appstat(S,"Ii",(showbinary IN flags));
    appstat(S,"Dd",(showdata IN flags));
    appstat(S,"Aa",(showascii IN flags));

    appstat(S,"Nn",(xlatnone IN flags));
    appstat(S,"Oo",(xlatasciitooem IN flags));
    appstat(S,"Ss",(xlatoemtoascii IN flags));
    appstat(S,"Jj",(unicrap IN flags));

    Str.Subst(R,replaceme,S);
    Str.Copy(S, PadDec( LONGCARD(count),2) );
    Str.Subst(R,replaceme,S);

    RETURN R;
END fmtstatus;

PROCEDURE initfields (VAR dasize,padbin,padw:CARDINAL;VAR sep:str16;
                     flags:setOfOptions);
BEGIN
    IF (words IN flags) THEN
        dasize := 2;
    ELSE
        dasize := 1;
    END;
    padbin := 8 * dasize; (* word and binary formats never allowed together ! *)

    IF (decimalbase IN flags) THEN
        IF (words IN flags) THEN
            sep:="#####";
        ELSE
            sep:=  "###";
        END;
    ELSE
        IF (words IN flags) THEN
            sep:= "####";
        ELSE
            sep:=   "##";
        END;
    END;
    ReplaceChar(sep,"#"," ");
    padw := Str.Length(sep);
END initfields;

PROCEDURE toggleflag (VAR f: setOfOptions; opt:options);
BEGIN
    IF (opt IN f) THEN
        EXCL(f,opt);
    ELSE
        INCL(f,opt);
    END;
END toggleflag;

PROCEDURE fixodd (VAR a : LONGCARD; wi:LONGCARD);
VAR
    v:LONGCARD;
BEGIN
    v:=(a MOD wi);
    IF v # 0 THEN DEC(a,v);END; (* better rounding *)
END fixodd;

PROCEDURE fixoddold (VAR a : LONGCARD; wi:LONGCARD);
VAR
    v:LONGCARD;
BEGIN
    v:=(a MOD wi);
    IF v # 0 THEN INC(a,wi-v);END;
END fixoddold;

PROCEDURE newoffset (VAR offset:LONGCARD;
                    fsize,bytesPerScreen,octetsParLigne:LONGCARD;percentage:CARDINAL);
CONST
    k100 = LONGREAL(100.0);
VAR
    p : LONGREAL;
BEGIN
    IF fsize <= bytesPerScreen THEN
        offset:=0;
    ELSE
        p:=LONGREAL(fsize) * LONGREAL(percentage) / k100;
        offset := LONGCARD(p);
        fixodd(offset,octetsParLigne );
    END;
END newoffset;

PROCEDURE newcount (bpl:CARDINAL;  VAR n:CARDINAL;VAR lc:LONGCARD);
BEGIN
    n:=bpl;
    lc:=LONGCARD(bpl);
END newcount;

(* ------------------------------------------------------------ *)

PROCEDURE soundLimit (  );
BEGIN
    sound(222,50); (* was 55,300 *)
END soundLimit;

CONST
    hexprefix = dollar;

PROCEDURE getLongCardValue (VAR v:LONGCARD;S:ARRAY OF CHAR):BOOLEAN;
VAR
    p,base:CARDINAL;
    ok:BOOLEAN;
BEGIN
    Str.Caps(S); (* just in case ! *)
    IF Str.Match(S,hexprefix+"*") THEN
        Str.Delete(S,0,1);
        base:=16;
    ELSIF Str.Match(S,"0X*") THEN
        Str.Delete(S,0,2);
        base:=16;
    ELSIF Str.Match(S,"*H") THEN
        p:=Str.Length(S);
        Str.Delete(S,p-1,1);
        base:=16;
    ELSE
        base:=10;
    END;
    v:=Str.StrToCard(S,base,ok);
    RETURN ok;
END getLongCardValue;

PROCEDURE fmtnum (v:LONGCARD;base:CARDINAL;padwi:INTEGER;padchar:CHAR):str16;
VAR
    R:str16;
    ok:BOOLEAN;
    i:CARDINAL;
BEGIN
    Str.CardToStr(v,R,base,ok);
    IF base=16 THEN Str.Lows(R);END;
    FOR i:=Str.Length(R)+1 TO ABS(padwi) DO
        IF padwi < 0 THEN
            Str.Append(R,padchar);
        ELSE
            Str.Prepend(R,padchar);
        END;
    END;
    RETURN R;
END fmtnum;

PROCEDURE fposToPercent(fsize,fpos:LONGCARD):LONGCARD;
VAR
    percentage:LONGREAL; (* huge card here ! *)
    percent:LONGCARD;
BEGIN
    IF fsize <= 1 THEN (* avoid divide by 0 -- 0-length file is already filtered but... *)
        percent    := 0; (* ugly ! *)
    ELSE
        percentage := LONGREAL(fpos+1)*LONGREAL(100.0);
        percentage := percentage / LONGREAL(fsize);
        percent    := VAL(LONGCARD,percentage); (* (fpos*100) DIV (fsize-1) *)
    END;
    RETURN percent;
END fposToPercent;

PROCEDURE percentToFpos (VAR p:LONGCARD; fsize:LONGCARD):BOOLEAN;
VAR
    v:LONGREAL;
BEGIN
    IF p < 0   THEN RETURN FALSE; END; (* never ! *)
    IF p > 100 THEN RETURN FALSE; END;

    IF fsize <= 1 THEN (* avoid divide by 0 -- 0-length file is already filtered but... *)
        p:=0;
    ELSE
        CASE CARDINAL(p) OF
        | 0   : p:=0;
        | 100 : p:=fsize-1;
        ELSE
                v:=LONGREAL(p) / LONGREAL(100.0);
                v:=v * LONGREAL(fsize-1); (* fsize is at least 2 *)
                p:=VAL(LONGCARD,v);
        END;
    END;
    RETURN TRUE;
END percentToFpos;

PROCEDURE enternewoffset (VAR offset:LONGCARD;
                    fsize,octetsParLigne:LONGCARD);
CONST
    placeholder = "~";
    msgIn       = "Enter new value : ";
    msgCurr     = "File position   : $~ / $~ = ~ / ~ = ~%";
VAR
    S: str128;
    percent,lc:LONGCARD;
BEGIN
    (* Flushkey(); *)
    LOOP
        percent:=fposToPercent(fsize,offset);
        S:=msgCurr;
        Str.Subst(S,placeholder, fmtnum(offset,16,8,"0"));
        Str.Subst(S,placeholder, fmtnum(fsize-1,16,8,"0"));
        Str.Subst(S,placeholder, fmtnum(offset,10,1," "));
        Str.Subst(S,placeholder, fmtnum(fsize-1,10,1," "));
        Str.Subst(S,placeholder, fmtnum(percent,10,1," "));
        WrStr(S);WrLn;
        WrLn;
        WrStr(msgIn);TerminalReadString(S);
        LtrimBlanks(S);
        RtrimBlanks(S);
        IF same(S,"") THEN EXIT; END;
        IF Str.Match(S,"*%") THEN
            Str.Subst(S,"%","");
            IF getLongCardValue(lc,S) THEN
                IF percentToFpos(lc,fsize) THEN
                    offset:=lc;
                    fixodd(offset,octetsParLigne );
                    EXIT;
                END;
            END;
        ELSIF getLongCardValue(lc,S) THEN
            IF lc < fsize THEN
                offset:=lc;
                fixodd(offset,octetsParLigne );
                EXIT;
            END;
        END;
        WrLn;
        soundLimit;
        WrLn; (* add another cr *)
    END;
END enternewoffset;

(* ------------------------------------------------------------ *)

(* remember we may need to scan for " |" with nothing after ! *)

CONST
    sepaddrchar = ":";
    lensepaddrchar=1;
    sepaddr     = " "+sepaddrchar+" "; (* warning ! hand made could have a tab !!! *)
CONST
    sepasciibeg = " |"; (* for parsing safety, must be different from sepaddr *)
    sepascii    = sepasciibeg+" ";
    lensepascii = 2+1;
    msgwait     = " : please wait...";
CONST
    binblank = "        "; (* %%%%%%%% = 8 chars *)

PROCEDURE doCmdDump (useLFN:BOOLEAN;flags:setOfOptions;count:CARDINAL;
                    userfpos,baseaddr:LONGCARD;source,target:pathtype):BOOLEAN;
CONST
    placeholder   = "$";
    defaultkbdmsg = "["+placeholder+"]-status  ["+placeholder+"]-width  [H|?]-help : ";
    iNAME  = "; Filename : ";
    iSIZE  = "; Filesize : ";
CONST
    sM2protoOpen = "(* trailing comma after last byte must be removed ! *)"+nl+
                   nl+
                   "CONST"+nl+
                   "    sDataDefSize = ~;"+nl+
                   "TYPE"+nl+
                   "    sDataDefType = ARRAY [0..~-1] OF BYTE;"+nl+
                   "CONST"+nl+
                   "    sDataDef = sDataDefType("+nl;
    sM2protoClose= "    );"+nl;
VAR
    lastRow,lastCol       : CARDINAL;
    rowcount              : CARDINAL;
    singlestep,keychk     : BOOLEAN;
    keycode,wistat,witmp  : CARDINAL;
VAR
    hndIn  : FIO.File;
    hndOut : FIO.File;
    got    : CARDINAL;
    i,iwo  : CARDINAL;
    offset : LONGCARD;
    fsize  : LONGCARD;
    O      : str1024;   (* we may get a pathtype or build a very long string *)
    c      : CHAR;
    tofile : BOOLEAN;
    sep    : str16;
    rc     : BOOLEAN;
    eyecandy : BOOLEAN;
    padw   : CARDINAL;
    padbin : CARDINAL;
    dasize : CARDINAL;
    value  : LONGCARD;
    bytesDumped,bytesPerScreen: LONGCARD;
    octetsParLigne : LONGCARD;
    doreset:BOOLEAN;
    anchor:LONGCARD;
    savoffset:LONGCARD;
    S, sDATA, sASCII, sDATABIN : str256; (* oversized for future extension *)
    sADDR, V                       : str16;
    kbdmsg : str80; (* oversized *)
    keepme,fullercharset :BOOLEAN;
BEGIN
    colorhelp;
    lastCol := getColumns();
    wistat  := 0;
    octetsParLigne := LONGCARD(count); (* easy conversion once for all *)
    rc := TRUE;
    singlestep := FALSE;

    initfields (dasize,padbin,padw,sep,  flags);
    fullercharset := (fullset IN flags);

    tofile := NOT(same(target,""));

    eyecandy := ((verbose IN flags) AND tofile); (* verbose relevant to file only ! *)

    hndIn :=fileOpenRead(useLFN,source);
    FIO.AssignBuffer(hndIn,bufferIn);

    offset := userfpos; (* was :=0 *)
    fixodd (offset,octetsParLigne);   (* round to nearest offset *)
    FIO.Seek(hndIn,offset);

    fsize  :=FIO.Size(hndIn);

    Str.Copy(O,";"+nl);
    Str.Append(O,iNAME);
    IF useLFN THEN Str.Append(O,dquote);END;
    Str.Append(O,source);
    IF useLFN THEN Str.Append(O,dquote);END;
    Str.Append(O,nl);
    Str.Append(O,";"+nl);

    Str.Append(O,iSIZE);Str.Append(O, PadDec(fsize,1)); (* was fsize,2 *)
    Str.Append(O," ($");Str.Append(O, PadHex(fsize,8));Str.Append(O,")"+nl);
    Str.Append(O,";"+nl);

    Str.Append(O,nl);

    IF tofile THEN
        WrStr("Dumping ");
        IF useLFN THEN WrStr(dquote);END;
        WrStr(source);
        IF useLFN THEN WrStr(dquote);END;
        WrStr(" to ");
        IF useLFN THEN WrStr(dquote);END;
        WrStr(target);
        IF useLFN THEN WrStr(dquote);END;
        WrStr(msgwait);WrLn;
        hndOut :=fileCreate(useLFN,target);
        FIO.AssignBuffer(hndOut,bufferOut);
        FIO.WrStr(hndOut,nl);
        FIO.WrStr(hndOut,O);

        IF (modula2proto IN flags) THEN
            S:=sM2protoOpen;
            Str.Subst(S,"~", PadDec(fsize,1));
            Str.Subst(S,"~", PadDec(fsize,1));
            FIO.WrStr(hndOut,S);
        END;

    ELSE
        WrStr(O);
    END;

    IF (paging IN flags) THEN (* // v1.1d *)
        lastRow  := getRows();
        initRowCounter(rowcount,1); (* take status line into account *)
        IF (syncvideo IN flags) THEN WaitVGAretrace(); END;
        cls();
    END;

    IF eyecandy THEN Work(cmdInit);END;

    FIO.EOF := FALSE;
    LOOP
        IF eyecandy THEN Work(cmdShow);END;
        got:=FIO.RdBin(hndIn,S,count);
        IF got = 0 THEN
            IF NOT(paging IN flags) THEN EXIT; END;
        END;
        S[got] := nullchar; (* be sure last byte, if displayed as word, will always be 00xx *)

        sADDR    := "";

        IF (showaddress IN flags) THEN
            IF (decimalbase IN flags) THEN
                V := PadDec(offset+baseaddr,8);
            ELSE
                V := PadHex(offset+baseaddr,8);
                IF (uppercase IN flags)=FALSE THEN LowerCase(V);END;
            END;
            Str.Copy(sADDR,V);
        END;

        sDATA    := "";
        sDATABIN := "";

        i := 1;
        LOOP
            c := S[i-1];
            CASE dasize OF
            | 1: value := LONGCARD(ORD(c));
            | 2: value := LONGCARD(ORD(c))+(LONGCARD(ORD(S[i])) << 8);
            END;
            IF (decimalbase IN flags) THEN
                V := PadDec(value,padw); (* 3 *)
            ELSE
                IF (modula2 IN flags) THEN
                    V := PadHex(value,padw+1); (* prepend "0" 1+2 *)
                    Str.Append(V,sM2hex);
                ELSE
                    V := PadHex(value,padw); (* 2 *)
                    IF (uppercase IN flags)=FALSE THEN LowerCase(V);END;
                END;
            END;
            Str.Append(sDATA,V);

            IF (showbinary IN flags) THEN
                V := PadBina(value,padbin); (* 8 *)
                Str.Append(sDATABIN,V);
            END;

            IF i < (got+1-dasize) THEN (* was i < got *)
                IF NOT (modula2 IN flags) THEN
                    Str.Append(sDATA," ");
                    IF (showbinary IN flags) THEN Str.Append(sDATABIN," "); END;
                END;
            END;

            INC(i,dasize);
            IF i > got THEN EXIT;END;
        END;
        IF (got+dasize-1) < count THEN (* was got < count *)
            i := got+dasize;
            LOOP
                Str.Append(sDATA," ");
                Str.Append(sDATA,sep);   (* $$ or ### *)
                IF (showbinary IN flags) THEN
                    IF NOT (modula2 IN flags) THEN Str.Append(sDATABIN," "); END;
                    FOR iwo:=1 TO dasize DO Str.Append(sDATABIN,binblank); END;
                END;

                INC(i,dasize);
                IF i > count THEN EXIT; END;
            END;
        END;

        sASCII   := "";

        IF (showascii IN flags) THEN
            FOR i := 1 TO got DO
                IF (unicrap IN flags) THEN
                    keepme:=( ( S[i-1] ) # nullchar );
                ELSE
                    keepme:=TRUE;
                END;
                c := charFilter( fullercharset, S[i-1]);

                (* IF (xlatnone IN flags) THEN
                    ;
                ELS *)
                IF (xlatasciitooem IN flags) THEN
                    c:=remap2oem(c);
                ELSIF (xlatoemtoascii IN flags) THEN
                    c:=remap2ascii(c);
                END;

                IF keepme THEN Str.Append(sASCII,c); END;
            END;
        END;

        IF got # 0 THEN
            IF tofile THEN
                Str.Copy(O,"");
                IF (showaddress IN flags) THEN
                    Str.Append(O,sADDR);
                    Str.Append(O,sepaddr);
                END;
                IF (showbinary IN flags) THEN
                    Str.Append(O,sDATABIN);
                    Str.Append(O,sepascii);
                END;
                IF (showdata IN flags) THEN
                    Str.Append(O,sDATA);
                END;
                IF (showascii IN flags) THEN
                    IF (showdata IN flags) THEN
                        Str.Append(O,sepascii);
                    END;
                    Str.Append(O,sASCII);
                END;
                Str.Append(O,nl);
                FIO.WrStr(hndOut,O);
            ELSE
                witmp:=0;
                IF (showaddress IN flags) THEN
                    coloraddr; WrStr(sADDR);
                    colorsep;  WrStr(sepaddr);
                    INC(witmp, Str.Length(sADDR));
                    INC(witmp, Str.Length(sepaddr));
                END;
                IF (showbinary IN flags) THEN
                    colordata; WrStr(sDATABIN);
                    colorsep;  WrStr(sepascii);
                    INC(witmp, Str.Length(sDATABIN));
                    INC(witmp, Str.Length(sepascii));
                END;
                IF (showdata IN flags) THEN
                    colordata; WrStr(sDATA);
                    INC(witmp, Str.Length(sDATA));
                END;
                IF (showascii IN flags) THEN
                    IF (showdata IN flags) THEN
                        colorsep; WrStr(sepascii);
                        INC(witmp, Str.Length(sepascii));
                    END;
                    colorascii; WrStr(sASCII);
                    INC(witmp, Str.Length(sASCII));
                END;
                IF witmp > wistat THEN wistat:=witmp;END;
                colorhelp;
                WrLn;
            END;
        END;

        IF got # count THEN
            IF NOT (paging IN flags) THEN EXIT; END;
        END;

        INC (offset,octetsParLigne); (* got -- we're ready for next row *)

        IF (paging IN flags) THEN (* paging : singlestep ignored *)
            INC(rowcount);
            IF got = count THEN
                doreset:=(rowcount >= lastRow); (* = is enough but "Who knows what evil..." *)
            ELSE
                doreset:=TRUE;
            END;
            IF doreset THEN
                kbdmsg:=fmtstatus(flags,count,placeholder,defaultkbdmsg);
                colorstatus;
                showstatus(wistat, lastCol,kbdmsg); (* video(kbdmsg,TRUE); *)
                Flushkey;
                WHILE getKeyboardCode(keycode)=FALSE DO
                END;
                               (* video(kbdmsg,FALSE); *)
                colorhelp;

                IF (syncvideo IN flags) THEN WaitVGAretrace(); END;
                cls(); (* what is scrollWindow() for, eh ? *)

                (*
                damn... we would have been ashamed to even think of
                such a kludge in the good old Apple ][ 6502 days...
                are we getting so old and so stupid ? yep & yep... :-(
                *)

                (* offset is ready to read next bytes to be displayed *)

                bytesDumped   := octetsParLigne * LONGCARD(rowcount-1); (* "-1" accounts for message line *)
                bytesPerScreen:= octetsParLigne * LONGCARD(lastRow-1);  (* idem *)

                (* compute offset of first byte displayed *)

                IF offset <= bytesDumped THEN
                    anchor:=0;
                ELSE
                    anchor:=offset-bytesDumped;
                    fixodd(anchor,octetsParLigne);
                END;

                savoffset := offset; (* save it before we... *)
                offset    := anchor; (* ... remain at current screen by default *)

                CASE keycode OF
                | keyEscape :                       (* // ok *)
                    EXIT;
                | keyHome:                          (* // ok *)
                    offset:=0;
                | keyEnd:                           (* // ok *)
                    IF fsize <= bytesPerScreen THEN
                        offset:=0;
                    ELSE
                        offset:=fsize-bytesPerScreen;
                        fixoddold(offset,octetsParLigne );
                    END;
                | keyPageDown, keyCR :              (* // ok *)
                    IF savoffset >= fsize THEN (* SAVoffset here *)
                        offset:=anchor; (* already done *)
                    ELSE
                        offset:=savoffset; (* offset of next screen was saved *)
                    END;
                | keyDown, keyRight, keySpace:      (* // ok *)
                    IF savoffset >= fsize THEN (* SAVoffset here *)
                        offset:=anchor; (* already done *)
                    ELSE
                        offset:=anchor+octetsParLigne; (* advance one line *)
                    END;
                | keyPageUp:                        (* // ok *)
                    IF anchor >= bytesPerScreen THEN
                        offset:=anchor-bytesPerScreen;
                    ELSE
                        offset:=0;
                    END;
                | keyUp, keyLeft:                   (* // ok *)
                    IF anchor >= octetsParLigne THEN
                        offset:=anchor-octetsParLigne;
                    ELSE
                        offset:=0;
                    END;

                | key10a,key10b:
                    newoffset(offset, fsize,bytesPerScreen,octetsParLigne,10);
                | key20a,key20b:
                    newoffset(offset, fsize,bytesPerScreen,octetsParLigne,20);
                | key30a,key30b:
                    newoffset(offset, fsize,bytesPerScreen,octetsParLigne,30);
                | key40a,key40b:
                    newoffset(offset, fsize,bytesPerScreen,octetsParLigne,40);
                | key50a,key50b:
                    newoffset(offset, fsize,bytesPerScreen,octetsParLigne,50);
                | key60a,key60b:
                    newoffset(offset, fsize,bytesPerScreen,octetsParLigne,60);
                | key70a,key70b:
                    newoffset(offset, fsize,bytesPerScreen,octetsParLigne,70);
                | key80a,key80b:
                    newoffset(offset, fsize,bytesPerScreen,octetsParLigne,80);
                | key90a,key90b:
                    newoffset(offset, fsize,bytesPerScreen,octetsParLigne,90);

                | keyF9,keyF10,keyF12:
                             newcount (16,count,octetsParLigne);
                             INCL(flags,showaddress);
                             EXCL(flags,showbinary);
                             INCL(flags,showdata);
                             INCL(flags,showascii);
                             EXCL(flags,modula2);
                             initfields (dasize,padbin,padw,sep,  flags);
                | keyF8,keyF11:
                             newcount (64,count,octetsParLigne);
                             INCL(flags,showaddress);
                             EXCL(flags,showbinary);
                             EXCL(flags,showdata);
                             INCL(flags,showascii);
                             EXCL(flags,modula2);
                             initfields (dasize,padbin,padw,sep,  flags);

                | keyUpperX,
                  keyLowerX: toggleflag(flags,decimalbase);
                             initfields (dasize,padbin,padw,sep,  flags);
                | keyUpperW,
                  keyLowerW: toggleflag(flags,words);
                             initfields (dasize,padbin,padw,sep,  flags);
                | keyUpperF,
                  keyLowerF: toggleflag(flags,fullset);
                             initfields (dasize,padbin,padw,sep,  flags);
                | keyUpperU,
                  keyLowerU: toggleflag(flags,uppercase);
                             initfields (dasize,padbin,padw,sep,  flags);
                | keyUpperP,
                  keyLowerP: toggleflag(flags,showaddress);
                             initfields (dasize,padbin,padw,sep,  flags);
                | keyUpperI,
                  keyLowerI: toggleflag(flags,showbinary);
                             initfields (dasize,padbin,padw,sep,  flags);
                | keyUpperD,
                  keyLowerD: toggleflag(flags,showdata);
                             initfields (dasize,padbin,padw,sep,  flags);
                | keyUpperA,
                  keyLowerA: toggleflag(flags,showascii);
                             initfields (dasize,padbin,padw,sep,  flags);

                | keyUpperN,
                  keyLowerN: INCL(flags, xlatnone);
                             EXCL(flags, xlatasciitooem);
                             EXCL(flags, xlatoemtoascii);
                             initfields (dasize,padbin,padw,sep,  flags);
                | keyUpperO,
                  keyLowerO: EXCL(flags, xlatnone);
                             INCL(flags, xlatasciitooem);
                             EXCL(flags, xlatoemtoascii);
                             initfields (dasize,padbin,padw,sep,  flags);
                | keyUpperS,
                  keyLowerS: EXCL(flags, xlatnone);
                             EXCL(flags, xlatasciitooem);
                             INCL(flags, xlatoemtoascii);
                             initfields (dasize,padbin,padw,sep,  flags);
                | keyUpperJ,
                  keyLowerJ: toggleflag(flags,unicrap);

                | keyF1:     newcount( 4,count,octetsParLigne);
                | keyF2:     newcount( 8,count,octetsParLigne);
                | keyF3:     newcount(16,count,octetsParLigne);
                | keyF4:     newcount(32,count,octetsParLigne);
                | keyF5:     newcount(64,count,octetsParLigne);
                | keyF6:     newcount(96,count,octetsParLigne);

                | keyHelp1, keyHelp2, keyUpperH, keyLowerH: (* // ok *)
                    IF (syncvideo IN flags) THEN WaitVGAretrace(); END;
                    cls(); (* what is scrollWindow() for, eh ? *)

                    colorhelp;
                    WrLn;
                    WrStr(helpKeys);
                    WrLn;
                    WrStr(msgAnykey);
                    Flushkey;
                    WHILE getKeyboardCode(keycode)=FALSE DO
                    END;

                    IF (syncvideo IN flags) THEN WaitVGAretrace(); END;
                    cls(); (* what is scrollWindow() for, eh ? *)

                | keyAltP :
                    IF (syncvideo IN flags) THEN WaitVGAretrace(); END;
                    cls(); (* what is scrollWindow() for, eh ? *)

                    colorhelp;
                    WrLn;
                    enternewoffset(offset, fsize,octetsParLigne); (* alt-P 0-based *)

                    IF (syncvideo IN flags) THEN WaitVGAretrace(); END;
                    cls(); (* what is scrollWindow() for, eh ? *)

                ELSE                                (* // ok *)
                    buzz; (* notify user it's not a valid key *)
                END;

                FIO.Seek(hndIn,offset);
                initRowCounter(rowcount,1); (* take status line into account *)

            END;
        ELSIF (allowsinglestep IN flags) THEN (* no paging, no redirection, no target *)
            (* read and process key *)
            IF singlestep THEN
                WHILE getKeyboardCode(keycode)=FALSE DO
                END;
                keychk:=(keycode # keySpace);
                singlestep:=NOT(keychk);
            ELSE
                keychk:=getKeyboardCode(keycode);
            END;
            IF keychk THEN
                CASE keycode OF
                | keySpace      : singlestep:=NOT (singlestep);
                | keyEscape     : rc:=FALSE; EXIT;
                END;
            END;
        ELSE (* redirection or target *)
            IF ChkEscape() THEN rc := FALSE; EXIT; END;
        END;
    END;
    IF eyecandy THEN Work(cmdStop);END;

    IF tofile THEN
        IF rc THEN (* dump was not aborted with escape *)
            IF (modula2proto IN flags) THEN
                FIO.WrStr(hndOut,sM2protoClose);
            END;
        END;

        FIO.Flush(hndOut);
        FIO.Close(hndOut);
    END;
    FIO.Close(hndIn);
    RETURN rc;
END doCmdDump;

(* ------------------------------------------------------------ *)

PROCEDURE bigIncFarAddr (VAR a:FarADDRESS;n:LONGCARD);
VAR
    i,hi,lo:CARDINAL;
BEGIN
    hi := CARDINAL( n >> 16 );
    lo := CARDINAL( n AND 0000FFFFH );
    (* required because ts lib only adds a cardinal *)
    FOR i:=1 TO hi DO
        Lib.IncFarAddr(a , MAX(CARDINAL) );
        Lib.IncFarAddr(a , 1);
    END;
    Lib.IncFarAddr(a, lo);
END bigIncFarAddr;

PROCEDURE PadDecAddr (a:FarADDRESS;n:LONGCARD):str16;
VAR
    S  : str16;
    so : LONGCARD;
    seg,ofs:LONGCARD;
BEGIN
    bigIncFarAddr(a , n);
    so  := LONGCARD(a); (* automagically converted to ssss:oooo *)
    seg := so >> 16;
    ofs := so AND 0000FFFFH;
    so  := seg << 4 + ofs;
    S := PadDec( so ,8);
    RETURN S;
END PadDecAddr;

PROCEDURE PadHexAddr (old:BOOLEAN; a:FarADDRESS;n:LONGCARD):str16;
VAR
    S  : str16;
    so : LONGCARD;
    seg,ofs:LONGCARD;
BEGIN
    bigIncFarAddr(a , n);
    so  := LONGCARD(a); (* automagically converted to ssss:oooo *)
    seg := so >> 16;
    ofs := so AND 0000FFFFH;

    so  := seg << 4 + ofs;

    IF old THEN (* ugly *)
        Str.Concat(S, PadHex( seg,4), colon);
        Str.Append(S,PadHex( ofs,4));
    ELSE
        S:= PadHex(so,8);
    END;
    RETURN S;
END PadHexAddr;

PROCEDURE memRdBin (VAR S:str256;
                   count:CARDINAL;fsize,offset:LONGCARD;a:FarADDRESS):CARDINAL;
VAR
    got:CARDINAL;
    p:LONGCARD;
BEGIN
    bigIncFarAddr(a, offset);
    Lib.FarMove(a,FarADR(S),count); (* always, without caring about hitting a RAM wall *)

    p:=offset+LONGCARD(count);
    IF p > fsize THEN
        got:=CARDINAL( fsize-offset);
    ELSE
        got:=count;
    END;
    RETURN got;
END memRdBin;

(* mostly v1.1e doDump() cut/pasted/adapted, for I'm very, very lazy now :-( Q&D rules ! *)

PROCEDURE doCmdMemory (flags:setOfOptions;count:CARDINAL;
                      memsegment,memoffset:CARDINAL;memcount:LONGCARD):BOOLEAN;
CONST
    placeholder   = "$";
    defaultkbdmsg = "["+placeholder+"]-status  ["+placeholder+"]-width  [H|?]-help : ";
    iSO       = "; (hexadecimal) specified segment:offset = ";
    iHEX      = "; (hexadecimal) ";
    iDEC      = "; (decimal    ) ";
    iADDR     = "address = ";
    iCOUNT    = ", count = ";
    oldfmt    = FALSE;
VAR
    addr:FarADDRESS;
    offset,fsize,anchor,savoffset : LONGCARD; (* simulate a file *)
VAR
    lastRow,lastCol       : CARDINAL;
    rowcount              : CARDINAL;
    singlestep,keychk     : BOOLEAN;
    keycode,wistat,witmp  : CARDINAL;
VAR
    got    : CARDINAL;
    i,iwo  : CARDINAL;
    O      : str1024;   (* we may get a pathtype *)
    c      : CHAR;
    sep    : str16;
    rc     : BOOLEAN;
    padw   : CARDINAL;
    padbin : CARDINAL;
    dasize : CARDINAL;
    value  : LONGCARD;
    bytesDumped,bytesPerScreen: LONGCARD;
    octetsParLigne : LONGCARD;
    doreset:BOOLEAN;
    S, R , sDATA, sASCII, sDATABIN : str256; (* oversized for future extension *)
    sADDR, V                       : str16;
    kbdmsg : str80; (* oversized *)
    keepme,fullercharset : BOOLEAN;
BEGIN
    addr := [memsegment:memoffset]; (* offset=0 *)

    colorhelp;
    lastCol := getColumns();
    wistat  := 0;
    octetsParLigne := LONGCARD(count); (* easy conversion once for all *)
    rc := TRUE;
    singlestep := FALSE;

    initfields (dasize,padbin,padw,sep,  flags);
    fullercharset := (fullset IN flags);

    offset := 0;
    fsize  := memcount;

    Str.Copy(O,";"+nl);

    Str.Append(O,iSO);
    Str.Append(O,PadHex( LONGCARD (memsegment),4));
    Str.Append(O,colon);
    Str.Append(O,PadHex( LONGCARD (memoffset),4) );
    Str.Append(O,nl);

    Str.Append(O,";"+nl);

    Str.Append(O,iHEX);
    Str.Append(O,iADDR);
    Str.Append(O,PadHexAddr( oldfmt, addr, 0 ));
    Str.Append(O,iCOUNT);
    Str.Append(O,PadHex( memcount, 8));
    Str.Append(O,nl);

    Str.Append(O,iDEC);
    Str.Append(O,iADDR);
    Str.Append(O,PadDecAddr( addr, 0 ));
    Str.Append(O,iCOUNT);
    Str.Append(O,PadDec( memcount, 8));
    Str.Append(O,nl);

    Str.Append(O,";"+nl);
    Str.Append(O,nl);

    WrStr(O);

    IF (paging IN flags) THEN (* // v1.1d *)
        lastRow  := getRows();
        initRowCounter(rowcount,1); (* take status line into account *)
        IF (syncvideo IN flags) THEN WaitVGAretrace(); END;
        cls();
    END;

    LOOP
        got:=memRdBin(S,count, fsize,offset,addr);
        IF got = 0 THEN
            IF NOT(paging IN flags) THEN EXIT; END;
        END;
        S[got] := nullchar; (* be sure last byte, if displayed as word, will always be 00xx *)

        sADDR    := "";

        IF (showaddress IN flags) THEN
            IF (decimalbase IN flags) THEN
                V := PadDecAddr(addr,offset);
            ELSE
                V := PadHexAddr(oldfmt, addr,offset);
                IF (uppercase IN flags)=FALSE THEN LowerCase(V);END;
            END;
            Str.Copy(sADDR,V);
        END;

        sDATA    := "";
        sDATABIN := "";

        i := 1;
        LOOP
            c := S[i-1];
            CASE dasize OF
            | 1: value := LONGCARD(ORD(c));
            | 2: value := LONGCARD(ORD(c))+(LONGCARD(ORD(S[i])) << 8);
            END;
            IF (decimalbase IN flags) THEN
                V := PadDec(value,padw); (* 3 *)
            ELSE
                IF (modula2 IN flags) THEN
                    V := PadHex(value,padw+1); (* prepend "0" 1+2 *)
                    Str.Append(V,sM2hex);
                ELSE
                    V := PadHex(value,padw); (* 2 *)
                    IF (uppercase IN flags)=FALSE THEN LowerCase(V);END;
                END;
            END;
            Str.Append(sDATA,V);

            IF (showbinary IN flags) THEN
                V := PadBina(value,padbin); (* 8 *)
                Str.Append(sDATABIN,V);
            END;

            IF i < (got+1-dasize) THEN (* was i < got *)
                IF NOT (modula2 IN flags) THEN
                    Str.Append(sDATA," ");
                    IF (showbinary IN flags) THEN Str.Append(sDATABIN," "); END;
                END;
            END;

            INC(i,dasize);
            IF i > got THEN EXIT;END;
        END;
        IF (got+dasize-1) < count THEN (* was got < count *)
            i := got+dasize;
            LOOP
                Str.Append(sDATA," ");
                Str.Append(sDATA,sep);   (* $$ or ### *)
                IF (showbinary IN flags) THEN
                    IF NOT (modula2 IN flags) THEN Str.Append(sDATABIN," "); END;
                    FOR iwo:=1 TO dasize DO Str.Append(sDATABIN,binblank); END;
                END;

                INC(i,dasize);
                IF i > count THEN EXIT; END;
            END;
        END;

        sASCII   := "";

        IF (showascii IN flags) THEN
            FOR i := 1 TO got DO
                IF (unicrap IN flags) THEN
                    keepme:=( ( S[i-1] ) # nullchar );
                ELSE
                    keepme:=TRUE;
                END;
                c := charFilter( fullercharset, S[i-1]);

                (* IF (xlatnone IN flags) THEN
                    ;
                ELS *)
                IF (xlatasciitooem IN flags) THEN
                    c:=remap2oem(c);
                ELSIF (xlatoemtoascii IN flags) THEN
                    c:=remap2ascii(c);
                END;

                IF keepme THEN Str.Append(sASCII,c); END;
            END;
        END;

        IF got # 0 THEN
                witmp:=0;
                IF (showaddress IN flags) THEN
                    coloraddr; WrStr(sADDR);
                    colorsep;  WrStr(sepaddr);
                    INC(witmp, Str.Length(sADDR));
                    INC(witmp, Str.Length(sepaddr));
                END;
                IF (showbinary IN flags) THEN
                    colordata; WrStr(sDATABIN);
                    colorsep;  WrStr(sepascii);
                    INC(witmp, Str.Length(sDATABIN));
                    INC(witmp, Str.Length(sepascii));
                END;
                IF (showdata IN flags) THEN
                    colordata; WrStr(sDATA);
                    INC(witmp, Str.Length(sDATA));
                END;
                IF (showascii IN flags) THEN
                    IF (showdata IN flags) THEN
                        colorsep; WrStr(sepascii);
                        INC(witmp, Str.Length(sepascii));
                    END;
                    colorascii; WrStr(sASCII);
                    INC(witmp, Str.Length(sASCII));
                END;
                IF witmp > wistat THEN wistat:=witmp;END;
                colorhelp;
                WrLn;
        END;

        IF got # count THEN
            IF NOT (paging IN flags) THEN EXIT; END;
        END;

        INC (offset,octetsParLigne); (* got -- we're ready for next row *)

        IF (paging IN flags) THEN (* paging : singlestep ignored *)
            INC(rowcount);
            IF got = count THEN
                doreset:=(rowcount >= lastRow); (* = is enough but "Who knows what evil..." *)
            ELSE
                doreset:=TRUE;
            END;
            IF doreset THEN
                kbdmsg:=fmtstatus(flags,count,placeholder,defaultkbdmsg);
                colorstatus;
                showstatus(wistat, lastCol,kbdmsg); (* video(kbdmsg,TRUE); *)
                Flushkey;
                WHILE getKeyboardCode(keycode)=FALSE DO
                END;
                               (* video(kbdmsg,FALSE); *)
                colorhelp;

                IF (syncvideo IN flags) THEN WaitVGAretrace(); END;
                cls(); (* what is scrollWindow() for, eh ? *)

                (*
                damn... we would have been ashamed to even think of
                such a kludge in the good old Apple ][ 6502 days...
                are we getting so old and so stupid ? yep & yep... :-(
                *)

                (* offset is ready to read next bytes to be displayed *)

                bytesDumped   := octetsParLigne * LONGCARD(rowcount-1); (* "-1" accounts for message line *)
                bytesPerScreen:= octetsParLigne * LONGCARD(lastRow-1);  (* idem *)

                (* compute offset of first byte displayed *)

                IF offset <= bytesDumped THEN
                    anchor:=0;
                ELSE
                    anchor:=offset-bytesDumped;
                    fixodd(anchor,octetsParLigne);
                END;

                savoffset := offset; (* save it before we... *)
                offset    := anchor; (* ... remain at current screen by default *)

                CASE keycode OF
                | keyEscape :                       (* // ok *)
                    EXIT;
                | keyHome:                          (* // ok *)
                    offset:=0;
                | keyEnd:                           (* // ok *)
                    IF fsize <= bytesPerScreen THEN
                        offset:=0;
                    ELSE
                        offset:=fsize-bytesPerScreen;
                        fixoddold(offset,octetsParLigne );
                    END;
                | keyPageDown, keyCR :              (* // ok *)
                    IF savoffset >= fsize THEN (* SAVoffset here *)
                        offset:=anchor; (* already done *)
                    ELSE
                        offset:=savoffset; (* offset of next screen was saved *)
                    END;
                | keyDown, keyRight, keySpace:      (* // ok *)
                    IF savoffset >= fsize THEN (* SAVoffset here *)
                        offset:=anchor; (* already done *)
                    ELSE
                        offset:=anchor+octetsParLigne; (* advance one line *)
                    END;
                | keyPageUp:                        (* // ok *)
                    IF anchor >= bytesPerScreen THEN
                        offset:=anchor-bytesPerScreen;
                    ELSE
                        offset:=0;
                    END;
                | keyUp, keyLeft:                   (* // ok *)
                    IF anchor >= octetsParLigne THEN
                        offset:=anchor-octetsParLigne;
                    ELSE
                        offset:=0;
                    END;

                | key10a,key10b:
                    newoffset(offset, fsize,bytesPerScreen,octetsParLigne,10);
                | key20a,key20b:
                    newoffset(offset, fsize,bytesPerScreen,octetsParLigne,20);
                | key30a,key30b:
                    newoffset(offset, fsize,bytesPerScreen,octetsParLigne,30);
                | key40a,key40b:
                    newoffset(offset, fsize,bytesPerScreen,octetsParLigne,40);
                | key50a,key50b:
                    newoffset(offset, fsize,bytesPerScreen,octetsParLigne,50);
                | key60a,key60b:
                    newoffset(offset, fsize,bytesPerScreen,octetsParLigne,60);
                | key70a,key70b:
                    newoffset(offset, fsize,bytesPerScreen,octetsParLigne,70);
                | key80a,key80b:
                    newoffset(offset, fsize,bytesPerScreen,octetsParLigne,80);
                | key90a,key90b:
                    newoffset(offset, fsize,bytesPerScreen,octetsParLigne,90);

                | keyF9,keyF10,keyF12:
                             newcount (16,count,octetsParLigne);
                             INCL(flags,showaddress);
                             EXCL(flags,showbinary);
                             INCL(flags,showdata);
                             INCL(flags,showascii);
                             EXCL(flags,modula2);
                             initfields (dasize,padbin,padw,sep,  flags);
                | keyF8,keyF11:
                             newcount (64,count,octetsParLigne);
                             INCL(flags,showaddress);
                             EXCL(flags,showbinary);
                             EXCL(flags,showdata);
                             INCL(flags,showascii);
                             EXCL(flags,modula2);
                             initfields (dasize,padbin,padw,sep,  flags);

                | keyUpperX,
                  keyLowerX: toggleflag(flags,decimalbase);
                             initfields (dasize,padbin,padw,sep,  flags);
                | keyUpperW,
                  keyLowerW: toggleflag(flags,words);
                             initfields (dasize,padbin,padw,sep,  flags);
                | keyUpperF,
                  keyLowerF: toggleflag(flags,fullset);
                             initfields (dasize,padbin,padw,sep,  flags);
                | keyUpperU,
                  keyLowerU: toggleflag(flags,uppercase);
                             initfields (dasize,padbin,padw,sep,  flags);
                | keyUpperP,
                  keyLowerP: toggleflag(flags,showaddress);
                             initfields (dasize,padbin,padw,sep,  flags);
                | keyUpperI,
                  keyLowerI: toggleflag(flags,showbinary);
                             initfields (dasize,padbin,padw,sep,  flags);
                | keyUpperD,
                  keyLowerD: toggleflag(flags,showdata);
                             initfields (dasize,padbin,padw,sep,  flags);
                | keyUpperA,
                  keyLowerA: toggleflag(flags,showascii);
                             initfields (dasize,padbin,padw,sep,  flags);

                | keyUpperN,
                  keyLowerN: INCL(flags, xlatnone);
                             EXCL(flags, xlatasciitooem);
                             EXCL(flags, xlatoemtoascii);
                             initfields (dasize,padbin,padw,sep,  flags);
                | keyUpperO,
                  keyLowerO: EXCL(flags, xlatnone);
                             INCL(flags, xlatasciitooem);
                             EXCL(flags, xlatoemtoascii);
                             initfields (dasize,padbin,padw,sep,  flags);
                | keyUpperS,
                  keyLowerS: EXCL(flags, xlatnone);
                             EXCL(flags, xlatasciitooem);
                             INCL(flags, xlatoemtoascii);
                             initfields (dasize,padbin,padw,sep,  flags);
                | keyUpperJ,
                  keyLowerJ: toggleflag(flags,unicrap);

                | keyF1:     newcount( 4,count,octetsParLigne);
                | keyF2:     newcount( 8,count,octetsParLigne);
                | keyF3:     newcount(16,count,octetsParLigne);
                | keyF4:     newcount(32,count,octetsParLigne);
                | keyF5:     newcount(64,count,octetsParLigne);
                | keyF6:     newcount(96,count,octetsParLigne);

                | keyHelp1, keyHelp2, keyUpperH, keyLowerH: (* // ok *)
                    IF (syncvideo IN flags) THEN WaitVGAretrace(); END;
                    cls(); (* what is scrollWindow() for, eh ? *)

                    colorhelp;
                    WrLn;
                    WrStr(helpKeys);
                    WrLn;
                    WrStr(msgAnykey);
                    Flushkey;
                    WHILE getKeyboardCode(keycode)=FALSE DO
                    END;

                    IF (syncvideo IN flags) THEN WaitVGAretrace(); END;
                    cls(); (* what is scrollWindow() for, eh ? *)

                (*

                BAD IDEA FOR NOW : OFFSET IS NOT ADDR !

                | keyAltP :
                    IF (syncvideo IN flags) THEN WaitVGAretrace(); END;
                    cls(); (* what is scrollWindow() for, eh ? *)

                    colorhelp;
                    WrLn;
                    enternewoffset(offset, fsize,octetsParLigne); (* alt-P 0-based *)

                    IF (syncvideo IN flags) THEN WaitVGAretrace(); END;
                    cls(); (* what is scrollWindow() for, eh ? *)

                *)

                ELSE                                (* // ok *)
                    buzz; (* notify user it's not a valid key *)
                END;

                (* memSeek(offset); *)
                initRowCounter(rowcount,1); (* take status line into account *)

            END;
        ELSIF (allowsinglestep IN flags) THEN (* no paging, no redirection, no target *)
            (* read and process key *)
            IF singlestep THEN
                WHILE getKeyboardCode(keycode)=FALSE DO
                END;
                keychk:=(keycode # keySpace);
                singlestep:=NOT(keychk);
            ELSE
                keychk:=getKeyboardCode(keycode);
            END;
            IF keychk THEN
                CASE keycode OF
                | keySpace      : singlestep:=NOT (singlestep);
                | keyEscape     : rc:=FALSE; EXIT;
                END;
            END;
        ELSE (* redirection or target *)
            IF ChkEscape() THEN rc := FALSE; EXIT; END;
        END;
    END;
    RETURN rc;
END doCmdMemory;

(* ------------------------------------------------------------ *)

(* str256, hex data : "aabbcc..." to "aa bb cc ..." *)

PROCEDURE unpackhex ( VAR S:str256 );
VAR
    R:str256;
    i,n,p : CARDINAL;
    hx:str2;
BEGIN
    IF CharCount(S,blank) # 0 THEN RETURN; END;
    IF CharCount(S,tab)   # 0 THEN RETURN; END;
    n:=Str.Length(S);
    IF ODD (n) THEN RETURN; END;
    R:= "";
    p:=0;
    FOR i := 0 TO (n DIV 2) DO
         hx[0]:=S[p]; INC(p);
         hx[1]:=S[p]; INC(p);
         Str.Append(R,hx);
         IF p < n THEN Str.Append(R,blank);END;
    END;
    Str.Copy(S,R);
END unpackhex;

PROCEDURE doCmdCreate (useLFN:BOOLEAN;flags : setOfOptions;
                      source,target:pathtype):BOOLEAN;
VAR
    hndIn  : FIO.File;
    hndOut : FIO.File;
    S      : str256;
    p      : CARDINAL;
    len    : CARDINAL;
    base   : CARDINAL;
    R          : str16;
    lc         : LONGCARD;
    v          : CARDINAL;
    ok         : BOOLEAN;
    rc         : BOOLEAN;
    eyecandy   : BOOLEAN;
BEGIN
    IF (decimalbase IN flags) THEN
        base := 10;
    ELSE
        base := 16;
    END;
    eyecandy := (verbose IN flags);

    hndIn :=fileOpenRead(useLFN,source);
    FIO.AssignBuffer(hndIn,bufferIn);
    hndOut :=fileCreate(useLFN,target);         (* we begin at $00000000 offset *)
    FIO.AssignBuffer(hndOut,bufferOut);

    WrStr("Creating ");
    IF useLFN THEN WrStr(dquote);END;
    WrStr(target);
    IF useLFN THEN WrStr(dquote);END;
    WrStr(" from ");
    IF useLFN THEN WrStr(dquote);END;
    WrStr(source);
    IF useLFN THEN WrStr(dquote);END;
    WrStr(msgwait);WrLn;

    IF eyecandy THEN Work(cmdInit); END;

    rc := TRUE;

    FIO.EOF := FALSE;
    LOOP
        IF FIO.EOF=TRUE THEN EXIT; END;
        IF eyecandy THEN Work(cmdShow);END;
        FIO.RdStr(hndIn,S);
        Str.Copy(globalerrorinfo,S); (* for possible later use *)
        LtrimBlanks(S);
        RtrimBlanks(S);
        CASE S[0] OF
        | nullchar,diese,semicolon :
            ; (* ignore *)
        | star,slash:
            EXIT; (* ignore remaining data from here : force exit *)
        ELSE
            UpperCase(S); (* in case we had hex in lower case ! *)
            (* for safety, replace all tabs with spaces *)
            ReplaceChar(S,tab,blank);

            p:=Str.Pos(S,sepasciibeg);     (* remove ascii data if present : assume legal " |" *)
            IF p # MAX(CARDINAL) THEN
                S[p]:=nullchar; (* brutal end of string ! *)
            END;
            p:=Str.Pos(S,sepaddrchar);      (* remove offset if present *)
            IF p # MAX(CARDINAL) THEN
                Str.Delete(S,0,p+lensepaddrchar); (* always assume data after separator " : " *)
            END;
            LtrimBlanks(S);
            RtrimBlanks(S);
            IF NOT (decimalbase IN flags) THEN unpackhex(S);END;
            FOR p := 1 TO argc(S,FALSE) DO
                argv(R,S,p,FALSE);
                lc:=Str.StrToCard(R,base,ok);
                IF ( (ok=FALSE) OR (lc > MAX(SHORTCARD)) ) THEN
                    IF eyecandy THEN Work(cmdStop);END;
                    FIO.Flush(hndOut);
                    FIO.Close(hndOut);
                    FIO.Close(hndIn);
                    RETURN FALSE;
                END;
                v := CARDINAL(lc);
                FIO.WrBin(hndOut,CHR(v),1);
            END;

        END;
    END;
    IF eyecandy THEN Work(cmdStop);END;
    FIO.Flush(hndOut);
    FIO.Close(hndOut);
    FIO.Close(hndIn);
    RETURN rc; (* always true here, for errors catched and dealt with earlier *)
END doCmdCreate;

(* ------------------------------------------------------------ *)

PROCEDURE doCmdPatch (useLFN:BOOLEAN;flags : setOfOptions;
                     source,target:pathtype):BOOLEAN;
VAR
    hndIn  : FIO.File;
    hndOut : FIO.File;
    S      : str256;
    p      : CARDINAL;
    len    : CARDINAL;
    base   : CARDINAL;
    R          : str16;
    lc         : LONGCARD;
    v          : CARDINAL;
    ok         : BOOLEAN;
    rc         : BOOLEAN;
    offset     : LONGCARD;
    eyecandy   : BOOLEAN;
    stamp      : LONGCARD;
BEGIN
    IF (decimalbase IN flags) THEN
        base := 10;
    ELSE
        base := 16;
    END;
    eyecandy := (verbose IN flags);

    hndIn :=fileOpenRead(useLFN,source);
    FIO.AssignBuffer(hndIn,bufferIn);
    hndOut :=fileOpen(useLFN,target);         (* we begin at $00000000 offset *)
    FIO.AssignBuffer(hndOut,bufferOut);

    IF (samestamp IN flags) THEN
        stamp:=FIO.GetFileDate(hndOut);
        WrStr("Patching ");
    ELSE
        WrStr("Updating ");
    END;
    IF useLFN THEN WrStr(dquote);END;
    WrStr(target);
    IF useLFN THEN WrStr(dquote);END;
    WrStr(" with ");
    IF useLFN THEN WrStr(dquote);END;
    WrStr(source);
    IF useLFN THEN WrStr(dquote);END;
    WrStr(msgwait);WrLn;

    IF eyecandy THEN Work(cmdInit); END;

    rc:=TRUE;

    FIO.EOF := FALSE;
    LOOP
        IF FIO.EOF=TRUE THEN EXIT; END;
        IF eyecandy THEN Work(cmdShow);END;
        FIO.RdStr(hndIn,S);
        Str.Copy(globalerrorinfo,S); (* for possible later use *)
        LtrimBlanks(S);
        RtrimBlanks(S);
        CASE S[0] OF
        | nullchar,diese,semicolon :
            ; (* ignore line *)
        | star,slash:
            EXIT; (* ignore remaining data from here : force exit *)
        ELSE

            UpperCase(S); (* in case we had hex in lower case ! *)
            (* for safety, replace all tabs with spaces *)
            ReplaceChar(S,tab,blank);

            p:=Str.Pos(S,sepasciibeg);     (* remove ascii data if present -- assume legal " |" *)
            IF p # MAX(CARDINAL) THEN
                S[p]:=nullchar; (* brutal end of string ! *)
            END;
            p:=Str.Pos(S,sepaddrchar);      (* offset MUST be present *)
            IF p = MAX(CARDINAL) THEN rc:=FALSE;EXIT;END;

            (* yes, we should have been less strict here... but fascist design rules ! *)

            Str.Slice(R,S,0,p);            (* R = offset string *)
            Str.Delete(S,0,p+lensepaddrchar);  (* delete offset string from S *)

            RtrimBlanks(R); (* in case we got "$$$$$  :" or the like *)
            offset:=Str.StrToCard(R,base,ok);
            IF ok=FALSE THEN rc:=FALSE; EXIT;END;

            FIO.Seek(hndOut,offset);

            LtrimBlanks(S);
            RtrimBlanks(S);
            FOR p := 1 TO argc(S,FALSE) DO
                argv(R,S,p,FALSE);
                IF same(R,"") THEN EXIT; END;
                lc:=Str.StrToCard(R,base,ok);
                IF ( (ok=FALSE) OR (lc > MAX(SHORTCARD)) ) THEN
                    IF eyecandy THEN Work(cmdStop);END;
                    FIO.Flush(hndOut);
                    FIO.Close(hndOut);
                    FIO.Close(hndIn);
                    RETURN FALSE;
                END;
                v := CARDINAL(lc);
                FIO.WrBin(hndOut,CHR(v),1);
            END;

        END;
    END;
    IF eyecandy THEN Work(cmdStop);END;
    FIO.Flush(hndOut);
    FIO.Close(hndOut);
    FIO.Close(hndIn);

    (* NOW and only NOW, we may update again date and time if needed *)
    IF (samestamp IN flags) THEN
        hndOut:=fileOpen(useLFN,target);
        FIO.SetFileDate(hndOut,stamp);
        FIO.Close(hndOut);
    END;
    RETURN rc;
END doCmdPatch;

(* ------------------------------------------------------------ *)

PROCEDURE padNum (v : LONGCARD; base,digits : CARDINAL;
                  padchar,prefix,suffix:CHAR) : str16;
VAR
    S : str16;
    ok : BOOLEAN;
    i  : CARDINAL;
BEGIN
    digits := digits MOD 16; (* better safe than sorry! *)
    Str.CardToStr (v,S,base,ok); (* assume legal value *)
    FOR i:=Str.Length(S)+1 TO digits DO
        Str.Prepend(S,padchar);
    END;
    Str.Prepend(S,prefix);
    Str.Append(S,suffix);
    RETURN S;
END padNum;

(*
-d -w -s
data is hexadecimal unless -d -- force hex with [$|0x] prefix
data is in bytes unless -w
data can be a DOS string
*)

PROCEDURE doCmdPatchFromCLI (useLFN:BOOLEAN;flags : setOfOptions;
                            target,cli:pathtype):BOOLEAN;
CONST
    firstoctet=1;
    maxoctet  =100; (* should do even for a 256-chars command line ! ;-) *)
VAR
    octet:ARRAY [firstoctet..maxoctet] OF CARDINAL; (* we'll process bytes or words *)
    count,p,base,sz,wh,wd,i,v:CARDINAL;
    offset,stamp,lc,limit:LONGCARD;
    hndOut:FIO.File;
    S,shex,sdec,Z:str256;
    shexa,sdeca,R:str16;
    ok,dmp:BOOLEAN;
BEGIN
    dmp := NOT(silent IN flags);

    Str.Copy(S,cli); (* almost forgot it ! ;-) *)
(* WrStr(S);WrLn; *)
    Str.Copy(globalerrorinfo,S); (* for possible later use *)
    LtrimBlanks(S);
    RtrimBlanks(S);
    ReplaceChar(S,tab,blank); (* for safety, replace all tabs with spaces *)

    p:=Str.Pos(S,sepaddrchar);      (* offset MUST be present *)
    IF p = MAX(CARDINAL) THEN RETURN FALSE;END;
    IF p >= SIZE(R)      THEN RETURN FALSE;END;

    Str.Slice(R,S,0,p);                (* R = offset string *)
    Str.Delete(S,0,p+lensepaddrchar);  (* delete offset string from S *)

    RtrimBlanks(R); (* in case we got "$$$$$  :" or the like *)
    Str.Caps(R);    (* no longer done earlier globally *)
(* WrStr(R);WrLn; *)
    IF R[0]=dollar THEN
        Str.Delete(R,0,1);
        base:=16;
    ELSIF ((R[0]="0") AND (R[1]="X")) THEN
        Str.Delete(R,0,2);
        base:=16;
    ELSE
        IF (decimalbase IN flags) THEN
            base := 10;
        ELSE
            base := 16;
        END;
    END;
    offset:=Str.StrToCard(R,base,ok);
    IF ok=FALSE THEN RETURN FALSE; END;

    Str.Copy( shexa,padNum(offset,16,8,"0","$","") );
    Str.Copy( sdeca,padNum(offset,10,9," ", "","") );
    shex:="";
    sdec:="";

    IF (words IN flags) THEN
        limit:=MAX(CARDINAL);  sz:=SIZE(CARDINAL);  wh:=4; wd:=5; (* words *)
    ELSE
        limit:=MAX(SHORTCARD); sz:=SIZE(SHORTCARD); wh:=2; wd:=3; (* bytes *)
    END;

    LtrimBlanks(S);
    RtrimBlanks(S);

(* WrStr('"');WrStr(S);WrStr('"');WrLn; *)
    IF (stringdata IN flags) THEN
        IF (decimalbase IN flags) THEN
            base:=10;
        ELSE
            base:=16;
        END;
        Z:="";
        FOR i:=1 TO Str.Length(S) DO
            v:=ORD(S[i-1]);
            Str.CardToStr( LONGCARD(v),R,base,ok);
            Str.Append(Z," ");Str.Append(Z,R);
        END;
        IF (stringZ IN flags) THEN Str.Append(Z," $00");END; (* force hex *)
        LtrimBlanks(Z); (* remove leading space *)
        Str.Copy(S,Z);
(* WrStr('"');WrStr(S);WrStr('"');WrLn; *)
    END;

    count:=1-1;
    FOR p := 1 TO argc(S,FALSE) DO
        argv(R,S,p,FALSE);
        Str.Caps(R); (* no longer done earlier globally *)
(* WrStr(R);WrLn; *)
        IF R[0]=dollar THEN
            Str.Delete(R,0,1);
            base:=16;
        ELSIF ((R[0]="0") AND (R[1]="X")) THEN
            Str.Delete(R,0,2);
            base:=16;
        ELSE
            IF (decimalbase IN flags) THEN
                base := 10;
            ELSE
                base := 16;
            END;
        END;
        lc:=Str.StrToCard(R,base,ok);
        IF ok=FALSE THEN RETURN FALSE;END;
        IF lc > limit THEN RETURN FALSE; END;
        INC(count);
        octet[count]:=CARDINAL(lc);
        Str.Append(shex," ");
        Str.Append(sdec," ");
        Str.Append(shex,padNum(lc,16,wh,"0","$",""));
        Str.Append(sdec,padNum(lc,10,wd," ", "",""));
    END;
    IF count=0 THEN RETURN FALSE; END;

    IF dmp THEN
        coloraddr;WrStr(shexa);colorsep;WrStr(" : ");colordata;WrStr(shex);WrLn;
        coloraddr;WrStr(sdeca);colorsep;WrStr(" : ");colordata;WrStr(sdec);WrLn;
        colorhelp;
        WrLn;
    END;

    hndOut :=fileOpen(useLFN,target);         (* we begin at $00000000 offset *)
    FIO.AssignBuffer(hndOut,bufferOut);

    IF (samestamp IN flags) THEN
        stamp:=FIO.GetFileDate(hndOut);
        R:="Patching ";
    ELSE
        R:="Updating ";
    END;
    IF dmp THEN
        WrStr(R);
        IF useLFN THEN WrStr(dquote);END;
        WrStr(target);
        IF useLFN THEN WrStr(dquote);END;
        WrStr(" with data from command line");
        WrStr(msgwait);WrLn;
    END;

    FIO.Seek(hndOut,offset);

    FOR p:=1 TO count DO
        FIO.WrBin(hndOut, octet[p], sz);
    END;

    FIO.Flush(hndOut);
    FIO.Close(hndOut);

    (* NOW and only NOW, we may update again date and time if needed *)
    IF (samestamp IN flags) THEN
        hndOut:=fileOpen(useLFN,target);
        FIO.SetFileDate(hndOut,stamp);
        FIO.Close(hndOut);
    END;

    RETURN TRUE;
END doCmdPatchFromCLI;

(* ------------------------------------------------------------ *)
(* ------------------------------------------------------------ *)

(* getnext getprev *)

PROCEDURE fmtStatusList (flags:setOfOptions;replaceme:CHAR; msg:ARRAY OF CHAR):str80;
VAR
    R:str80;
    S:str16;
BEGIN
    Str.Copy(R,msg);

    S:="";
    appstat(S,"Ww",(nowrap IN flags));
    appstat(S,"Nn",(xlatnone IN flags));
    appstat(S,"Oo",(xlatasciitooem IN flags));
    appstat(S,"Ss",(xlatoemtoascii IN flags));
    appstat(S,"Jj",(unicrap IN flags));
    appstat(S,"Xx",(wordstar IN flags));
    appstat(S,"Tt",(packtab IN flags));

    Str.Subst(R,replaceme,S);

    RETURN R;
END fmtStatusList;

CONST
    txtbufferlen = 4000H; (* small=16384=$4000 else 32768=$8000 *)
    txtbuffermid = (txtbufferlen DIV 2);
    pFirst       = 1-1;
    pMax         = txtbufferlen-1;
    midchar      = txtbuffermid-1+1; (* $?fff+1 *)
VAR
    txtbuffer : ARRAY[pFirst..pMax] OF BYTE; (* cannot be proclocal or we'd have weird compiler problems *)

PROCEDURE resetfpos (VAR pCurr,pLast:CARDINAL; VAR nextfpos:LONGCARD;
                    hndIn:FIO.File);
VAR
    p : LONGREAL;
    got:CARDINAL;
BEGIN
    nextfpos:=0;
    FIO.Seek(hndIn,nextfpos);

    got    := FIO.RdBin(hndIn,txtbuffer[pFirst] ,txtbufferlen);
    pLast  := pFirst+got;
    IF got # 0 THEN DEC(pLast);END;

    INC( nextfpos, LONGCARD(got) );

    pCurr := pFirst;
END resetfpos;

PROCEDURE grabchar (VAR ch:BYTE;VAR pCurr,pLast:CARDINAL;VAR fpos:LONGCARD;
                   grabnext:BOOLEAN ) : BOOLEAN;
VAR
    rc:BOOLEAN;
BEGIN
    rc:=TRUE;
    IF grabnext THEN
        IF pCurr > pLast THEN
            rc:=FALSE;
        ELSE
            ch:=txtbuffer[pCurr];
            INC(pCurr);
        END;
    ELSE
        IF pCurr = pFirst THEN
            rc:=FALSE;
        ELSE
            ch:=txtbuffer[pCurr];
            DEC(pCurr);
        END;
    END;
    RETURN rc;
END grabchar;

PROCEDURE dmpBuffer (VAR pCurr,pLast:CARDINAL; VAR nextfpos:LONGCARD;
                     lastRow,lastCol,tabul,hoffset:CARDINAL;hndIn:FIO.File;flag:setOfOptions);
VAR
    rowcount,colcount: CARDINAL;
    ch:BYTE;
BEGIN
    initRowCounter(rowcount,1); (* 0+1 : we take status line into account *)
    initColCounter(colcount);   (* 0 *)

    LOOP
        IF grabchar( ch, pCurr,pLast,nextfpos, TRUE)=FALSE THEN EXIT;END;

        CASE ch OF
        |  0 : (* unicrap ? *)
            ;
        |  9 : (* tab /// *)
            WrStr(" ");
            INC(colcount);
            IF colcount >= lastCol THEN
                initColCounter(colcount);
                INC(rowcount);
                IF rowcount >= lastRow THEN EXIT; END;
            END;
        | 13 : (* cr *)
            ;
        | 10 : (* lf *)
            WrLn;
            INC(rowcount);
            IF rowcount >= lastRow THEN EXIT; END; (* = is enough but "Who knows what evil..." *)
            initColCounter(colcount);
        ELSE
            WrStr( CHR(ch) );
            INC(colcount);
            IF colcount >= lastCol THEN
                initColCounter(colcount);
                INC(rowcount);
                IF rowcount >= lastRow THEN EXIT; END;
            END;
        END;
    END;

END dmpBuffer;

(* syncvideo xlatasciitooem xlatoemtoascii unicrap nowrap wordstar packtab *)
(* ignore paging and singlestep for obvious reasons *)

PROCEDURE doCmdList (useLFN:BOOLEAN;flags:setOfOptions;source:pathtype);
CONST
    placeholder   = "$";
    defaultkbdmsg = "["+placeholder+"]-status  [H|?]-help : ";
VAR
    nextfpos,fsize:LONGCARD;
    hndIn:FIO.File;
    lastCol,lastRow,keycode,wistat:CARDINAL;
    pLast,pCurr:CARDINAL;
    tabul,hoffset,hshift:CARDINAL;
    kbdmsg : str80; (* oversized *)
    dowrap:BOOLEAN;
BEGIN
    colorhelp;
    lastRow  := getRows();      (* 25 *)
    lastCol  := getColumns ();  (* 80 *)

    tabul    := 8; (* almost standard *)
    hshift   := 8;
    initColCounter(hoffset); (* left/right offset *)

    dowrap := (nowrap IN flags);

    hndIn :=fileOpenRead(useLFN,source);
    FIO.AssignBuffer(hndIn,bufferIn);
    fsize  :=FIO.Size(hndIn);

    resetfpos(pCurr,pLast,nextfpos, hndIn);

    LOOP
        IF (syncvideo IN flags) THEN WaitVGAretrace(); END;
        cls();

        dmpBuffer(pCurr,pLast,nextfpos, lastRow,lastCol,tabul,hoffset,hndIn,flags);

        wistat   := lastCol-1; (* avoid scroll ! *)
        kbdmsg:=fmtStatusList(flags,placeholder,defaultkbdmsg);
        colorstatus;
        showstatus(wistat, lastCol,kbdmsg);

        Flushkey;
        WHILE getKeyboardCode(keycode)=FALSE DO
        END;

        colorhelp;

        CASE keycode OF
        | keyEscape :         EXIT;
        | keyPageDown, keyCR: ;
        | keyPageUp:          ;
        | keyDown, keySpace:  ;
        | keyUp:              ;
        | keyLeft:            ;
        | keyRight:           ;
        | keyHome:            resetfpos(pCurr,pLast,nextfpos, hndIn);
        | keyEnd:             ;

        | keyUpperW,keyLowerW: toggleflag(flags,nowrap);
        | keyUpperN,keyLowerN: INCL(flags, xlatnone);
                               EXCL(flags, xlatasciitooem);
                               EXCL(flags, xlatoemtoascii);
        | keyUpperO,keyLowerO: EXCL(flags, xlatnone);
                               INCL(flags, xlatasciitooem);
                               EXCL(flags, xlatoemtoascii);
        | keyUpperS,keyLowerS: EXCL(flags, xlatnone);
                               EXCL(flags, xlatasciitooem);
                               INCL(flags, xlatoemtoascii);
        | keyUpperJ,keyLowerJ: toggleflag(flags,unicrap);
        | keyUpperX,keyLowerX: toggleflag(flags,wordstar);
        | keyUpperT,keyLowerT: toggleflag(flags,packtab);

        | keyHelp1, keyHelp2, keyUpperH, keyLowerH:
            IF (syncvideo IN flags) THEN WaitVGAretrace(); END;
            cls(); (* what is scrollWindow() for, eh ? *)

            colorhelp;
            WrLn;
            WrStr(helpKeysList);
            WrLn;
            WrStr(msgAnykey);
            Flushkey;
            WHILE getKeyboardCode(keycode)=FALSE DO
            END;
        ELSE
            buzz; (* notify user it's not a valid key *)
        END;
    END;

    FIO.Close(hndIn);
END doCmdList;

(* ------------------------------------------------------------ *)
(* ------------------------------------------------------------ *)

PROCEDURE getCount (S:ARRAY OF CHAR;VAR count:LONGCARD ):BOOLEAN ;
VAR
    base : CARDINAL;
    ok   : BOOLEAN;
BEGIN
    Str.Caps(S); (* important ! *)
    IF S[0]=dollar THEN
        Str.Delete(S,0,1);
        base:=16;
    ELSIF ((S[0]="0") AND (S[1]="X")) THEN
        Str.Delete(S,0,2);
        base:=16;
    ELSE
        base:=10;
    END;
    count:=Str.StrToCard(S,base,ok);
    RETURN ok;
END getCount;

PROCEDURE getSegOfs (S:ARRAY OF CHAR;VAR segment,offset:LONGCARD ):BOOLEAN ;
VAR
    p : CARDINAL;
    R : str128;
BEGIN
    p := Str.CharPos(S,colon);
    IF p = MAX(CARDINAL) THEN RETURN FALSE; END;
    Str.Slice(R,S,0,p);  (* R will contain segment *)
    Str.Delete(S,0,p+1); (* S will contain offset *)
    IF R[0]=dollar THEN Str.Prepend(S,dollar);END;
    IF ((R[0]="0") AND ((R[1]="X") OR (R[1]="x"))) THEN Str.Prepend(S,"0x");END;
    IF getCount(R,segment)=FALSE THEN RETURN FALSE;END;
    IF segment > MAX(CARDINAL) THEN RETURN FALSE; END;
    IF getCount(S,offset)=FALSE THEN RETURN FALSE; END;
    IF offset > MAX(CARDINAL) THEN RETURN FALSE;END;
    RETURN TRUE;
END getSegOfs;

PROCEDURE getLCval (VAR lcval:LONGCARD;S:ARRAY OF CHAR):BOOLEAN;
VAR
    R:str128; (* oversized *)
BEGIN
    GetString(S, R);
    RETURN getCount(R, lcval);
END getLCval;

(* ------------------------------------------------------------ *)
(* ------------------------------------------------------------ *)

PROCEDURE abortIfSpecified (includedOK:BOOLEAN;
                           opt:options; flags:setOfOptions; errmsg:ARRAY OF CHAR);
BEGIN
    IF includedOK THEN
        IF (opt IN flags)=FALSE THEN abort(errIrrelevant,errmsg);END;
    ELSE
        IF (opt IN flags) THEN abort(errIrrelevant,errmsg);END;
    END;
END abortIfSpecified;

(* ------------------------------------------------------------ *)

VAR
    parmcount     : CARDINAL;
    i,opt         : CARDINAL;
    S,R           : pathtype;
    source,target,clipatch : pathtype;
    status        : (waiting,gotsource,gottarget,gotplus);
    segment,offset,memcount: LONGCARD;
    useLFN        : BOOLEAN;
    tofile        : BOOLEAN;
    tmpfsize      : LONGCARD;
BEGIN
    Lib.DisableBreakCheck();
    FIO.IOcheck := FALSE;
    FIO.ShareMode:=FIO.ShareDenyNone; (* very, very important ! *)

    vidinit( IsRedirected() );
    colorhelp; (* global init default *)

    WrLn;

    parmcount := Lib.ParamCount();
    IF parmcount = 0 THEN abort(errHelp,"");END;

    useLFN := TRUE;
    initDefaults;

    status := waiting;
    FOR i := 1 TO parmcount DO
        Lib.ParamStr(S,i); cleantabs(S);
        Str.Copy(R,S);
        UpperCase(R);
        IF isOption(R) THEN
            opt := GetOptIndex(R,"?"+delim+"H"+delim+"HELP"+delim+
                                 "8"+delim+
                                 "16"+delim+
                                 "32"+delim+
                                 "O"+delim+"OVERWRITE"+delim+
                                 "D"+delim+"DEC"+delim+
                                 "N"+delim+"NOASCII"+delim+
                                 "R"+delim+"RAW"+delim+
                                 "C"+delim+"CREATE"+delim+
                                 "P"+delim+"PATCH"+delim+
                                 "U"+delim+"UPPERCASE"+delim+
                                 "V"+delim+"VERBOSE"+delim+
                                 "M"+delim+"MODULA2"+delim+
                                 "24"+delim+
                                 "K"+delim+"NOPAGING"+delim+
                                 "S"+delim+"STAMP"+delim+
                                 "B"+delim+"BIOS"+delim+
                                 "X"+delim+"EXAMINE"+delim+
                                 "F"+delim+"FILTER"+delim+
                                 "2"+delim+"BINARY"+delim+
                                 "4"+delim+
                                 "W"+delim+"WORD"+delim+
                                 "I"+delim+"IMMEDIATE"+delim+
                                 "II"+delim+
                                 "B:"+delim+"BASE:"+delim+
                                 "LFN"+delim+
                                 "T"+delim+"RETRACE"+delim+
                                 "A"+delim+"ASCII"+delim+"ASC"+delim+
                                 "AA"+delim+"AF"+delim+
                                 "E"+delim+"WIDE"+delim+
                                 "EE"+delim+"EF"+delim+
                                 "Y"+delim+"WIN2PC"+delim+
                                 "Z"+delim+"PC2WIN"+delim+
                                 "??"+delim+
                                 "P:"+delim+"POS:"+delim+
                                 "MM"+delim+"M2"+delim+"MOD"+delim+
                                 "J"+delim+"JUNK"+delim+"UNICODE"+delim+
                                 "$"+delim+"STRING"+delim+
                                 "I$"+delim+
                                 "II$"+delim+

                                 "$$"+delim+"STRINGZ"+delim+
                                 "I$$"+delim+
                                 "II$$"+delim+

                                 "L"+delim+"LIST"+delim+
                                 "G"+delim+"NOWRAP"+delim+
                                 "Q"+delim+"WORDSTAR"+delim+
                                 "!"+delim+"PACKTAB"+delim+
                                 "LL"
                              );
            CASE opt OF
            |  1,  2,  3 : abort(errHelp,"");
            |  4         : bytesPerLine := 8;
            |  5         : bytesPerLine := 16;
            |  6         : bytesPerLine := 32;
            |  7,  8     : INCL(dumpMode,overwrite);
            |  9, 10     : INCL(dumpMode,decimalbase);
            | 11, 12     : EXCL(dumpMode,showascii);
            | 13, 14     : EXCL(dumpMode,showaddress);
            | 15, 16     : INCL(command,create);
            | 17, 18     : INCL(command,patch);
            | 19, 20     : INCL(dumpMode,uppercase);
            | 21, 22     : INCL(dumpMode,verbose);
            | 23, 24     : INCL(dumpMode,modula2);
            | 25         : bytesPerLine := 24;
            | 26, 27     : EXCL(dumpMode,paging);    (* later check needed *)
                           INCL(dumpMode,allowsinglestep); (* // is it useful ? *)
            | 28, 29     : EXCL(dumpMode,samestamp);
            | 30, 31     : setUseBiosMode ( TRUE );
                           INCL(dumpMode,forcebios);
            | 32, 33     : INCL(command,memory);
            | 34, 35     : INCL(dumpMode,fullset);
            | 36, 37     : INCL(dumpMode,showbinary);
            | 38         : bytesPerLine := 4;
            | 39,40      : INCL(dumpMode,words);
            | 41,42      : INCL(command,patchfromCLI);
            | 43         : INCL(command,patchfromCLI); INCL(dumpMode,silent);
            | 44,45      : IF getLCval(baseaddr,R)=FALSE THEN abort(errBadLC,S);END;
            | 46         : useLFN := FALSE;
            | 47,48      : EXCL(dumpMode,syncvideo);
            | 49,50,51   : INCL(dumpMode,onlyascii);
            | 52,53      : INCL(dumpMode,onlyascii);
                           INCL(dumpMode,fullset);
            | 54,55      : INCL(dumpMode,onlyascii);
                           INCL(dumpMode,widestmode);
            | 56,57      : INCL(dumpMode,onlyascii);
                           INCL(dumpMode,fullset);
                           INCL(dumpMode,widestmode);
            | 58,59:       IF (xlatasciitooem IN dumpMode) THEN abort(errXlat,"");END;
                           INCL(dumpMode,xlatoemtoascii);
                           EXCL(dumpMode,xlatnone);
            | 60,61:       IF (xlatoemtoascii IN dumpMode) THEN abort(errXlat,"");END;
                           INCL(dumpMode,xlatasciitooem);
                           EXCL(dumpMode,xlatnone);
            | 62         : abort(errHelper,"");
            | 63,64      : IF getLCval(userfpos,R)=FALSE THEN abort(errBadLC,S);END;

            | 65,66,67   : INCL(dumpMode,modula2);
                           INCL(dumpMode,modula2proto);
            | 68,69,70   : INCL(dumpMode,unicrap);

            | 71,72      : INCL(dumpMode,stringdata);
            | 73         : INCL(command,patchfromCLI);INCL(dumpMode,stringdata);
            | 74         : INCL(command,patchfromCLI);INCL(dumpMode,stringdata);INCL(dumpMode,silent);

            | 75,76      : INCL(dumpMode,stringdata);
                           INCL(dumpMode,stringZ);
            | 77         : INCL(command,patchfromCLI);INCL(dumpMode,stringdata);
                           INCL(dumpMode,stringZ);
            | 78         : INCL(command,patchfromCLI);INCL(dumpMode,stringdata);INCL(dumpMode,silent);
                           INCL(dumpMode,stringZ);

(*%T LISTDONE  *)
            | 79,80      : INCL(command,list);
            | 81,82      : INCL(dumpMode,nowrap);
            | 83,84      : INCL(dumpMode,wordstar);
            | 85,86      : INCL(dumpMode,packtab);
            | 87         : INCL(command,list);
                           INCL(dumpMode,nowrap);
(*%E *)
            ELSE
                abort(errUnknownOption,S);
            END;
        ELSE
            CASE status OF
            | waiting:    Str.Copy(source,S); (* was R *)
                          LowerCaseAlt(source);
            | gotsource:  Str.Copy(target,S); (* was R *)
                          LowerCaseAlt(target);
            | gottarget:  (* abort(errUneededParm,S); *)
                          Str.Copy(clipatch,S);
            | gotplus:
                          Str.Append(clipatch," ");Str.Append(clipatch,S);
            END;
            IF status # gotplus THEN INC(status); END;
        END;
    END;

    useLFN := ( useLFN AND w9XsupportLFN() );

    (* force some values for some options *)

    IF (modula2 IN dumpMode) THEN
        IF (onlyascii IN dumpMode) THEN abort(errConflict,"");END;
        EXCL(dumpMode,showaddress);
        EXCL(dumpMode,showbinary);
        EXCL(dumpMode,showascii);
        INCL(dumpMode,uppercase);
        bytesPerLine := 8;
    END;
    IF (onlyascii IN dumpMode) THEN
        IF (modula2 IN dumpMode) THEN abort(errConflict,"");END;
        EXCL(dumpMode,showbinary);
        EXCL(dumpMode,showdata);
        INCL(dumpMode,showascii);
        EXCL(dumpMode,decimalbase);
        IF (widestmode IN dumpMode) THEN
            CASE getColumns() OF
            | 1..80 :  bytesPerLine := 64;
            | 81..132: bytesPerLine := 96;
            ELSE
                       bytesPerLine := 16; (* should NEVER happen ! *)
            END;
        ELSE
            bytesPerLine := 64;
        END;
    END;

    IF command=setOfCommands{dump} THEN
        ; (* ok *)
    ELSIF command=setOfCommands{dump,create} THEN
        EXCL (command,dump);
    ELSIF command=setOfCommands{dump,patch} THEN
        EXCL (command,dump);
    ELSIF command=setOfCommands{dump,memory} THEN
        EXCL (command,dump);
    ELSIF command=setOfCommands{dump,patchfromCLI} THEN
        EXCL (command,dump);
    ELSIF command=setOfCommands{dump,list} THEN
        EXCL (command,dump);
    ELSE
        abort(errCmd,"");
    END;

    (* now, command contains only one... command ! *)

    (* ------------------------------------------------------------ *)

    IF (create IN command) THEN
        CASE status OF
        | waiting:   abort(errMissingSource,"");
        | gotsource: abort(errMissingTarget,"");
        | gottarget: ;
        | gotplus:   abort(errUneeded,"");
        END;
        IF chkJoker(source) THEN abort(errJoker,source);END;
        IF fileExists(useLFN,source)=FALSE THEN abort(errNotFound,source); END;

        IF userfpos # UNDEFINED THEN abort(errIrrelevant,"-p:#");END;
        IF baseaddr # UNDEFINED THEN abort(errIrrelevant,"-b:#");END;
        IF bytesPerLine # UNDEF THEN abort(errIrrelevant,"-#");END;
        abortIfSpecified(FALSE, modula2        , dumpMode,"-m[m]");
        abortIfSpecified(FALSE, onlyascii      , dumpMode,"-a");
        abortIfSpecified(FALSE, widestmode     , dumpMode,"-e");

        abortIfSpecified(FALSE, xlatasciitooem , dumpMode,"-y");
        abortIfSpecified(FALSE, xlatoemtoascii , dumpMode,"-z");
        abortIfSpecified(FALSE, fullset        , dumpMode,"-f");
        abortIfSpecified(FALSE, unicrap        , dumpMode,"-j");
        abortIfSpecified(FALSE, uppercase      , dumpMode,"-u");
        abortIfSpecified(FALSE, showbinary     , dumpMode,"-2");
        abortIfSpecified(FALSE, words          , dumpMode,"-w");
        abortIfSpecified(FALSE, nowrap         , dumpMode,"-g");
        abortIfSpecified(FALSE, wordstar       , dumpMode,"-q");
        abortIfSpecified(FALSE, packtab        , dumpMode,"-!");
        abortIfSpecified(TRUE , syncvideo      , dumpMode,"-t");
        abortIfSpecified(TRUE , samestamp      , dumpMode,"-s");
        abortIfSpecified(TRUE , showascii      , dumpMode,"-n");
        abortIfSpecified(TRUE , showaddress    , dumpMode,"-r");
        abortIfSpecified(TRUE , paging         , dumpMode,"-k");
        abortIfSpecified(FALSE, stringdata     , dumpMode,"-$");

        IF fileExists(useLFN,target) THEN
            IF (overwrite IN dumpMode) THEN
                IF fileIsRO(useLFN,target) THEN abort(errReadonly,target);END;
            ELSE
                abort(errAlreadyExists,target);
            END;
        END;

        IF doCmdCreate(useLFN,dumpMode,source,target)=FALSE THEN abort(errBadData,"");END;
    END;

    (* ------------------------------------------------------------ *)

    IF (patch IN command) THEN
        CASE status OF
        | waiting:   abort(errMissingSource,"");
        | gotsource: abort(errMissingTarget,"");
        | gottarget: ;
        | gotplus:   abort(errUneeded,"");
        END;
        IF chkJoker(source) THEN abort(errJoker,source);END;
        IF fileExists(useLFN,source)=FALSE THEN abort(errNotFound,source); END;

        IF userfpos # UNDEFINED THEN abort(errIrrelevant,"-p:#");END;
        IF baseaddr # UNDEFINED THEN abort(errIrrelevant,"-b:#");END;
        IF bytesPerLine # UNDEF THEN abort(errIrrelevant,"-#");END;
        abortIfSpecified(FALSE, modula2        , dumpMode,"-m[m]");
        abortIfSpecified(FALSE, onlyascii      , dumpMode,"-a");
        abortIfSpecified(FALSE, widestmode     , dumpMode,"-e");

        abortIfSpecified(FALSE, xlatasciitooem , dumpMode,"-y");
        abortIfSpecified(FALSE, xlatoemtoascii , dumpMode,"-z");
        abortIfSpecified(FALSE, fullset        , dumpMode,"-f");
        abortIfSpecified(FALSE, unicrap        , dumpMode,"-j");
        abortIfSpecified(FALSE, uppercase      , dumpMode,"-u");
        abortIfSpecified(FALSE, showbinary     , dumpMode,"-2");
        abortIfSpecified(FALSE, words          , dumpMode,"-w");
        abortIfSpecified(FALSE, nowrap         , dumpMode,"-g");
        abortIfSpecified(FALSE, wordstar       , dumpMode,"-q");
        abortIfSpecified(FALSE, packtab        , dumpMode,"-!");
        abortIfSpecified(TRUE , syncvideo      , dumpMode,"-t");
        abortIfSpecified(TRUE , showascii      , dumpMode,"-n");
        abortIfSpecified(TRUE , showaddress    , dumpMode,"-r");
        abortIfSpecified(TRUE , paging         , dumpMode,"-k");
        abortIfSpecified(FALSE, stringdata     , dumpMode,"-$");

        IF chkJoker(target) THEN abort(errJokerTarget,target);END;
        IF fileExists(useLFN,target)=FALSE THEN abort(errNotFoundTarget,target);END;
        IF fileIsRO(useLFN,target) THEN abort(errReadonly,target);END;

        IF doCmdPatch(useLFN,dumpMode,source,target)=FALSE THEN abort(errBadPatch,"");END;
    END;

    (* ------------------------------------------------------------ *)

    IF (patchfromCLI IN command) THEN
        CASE status OF
        | waiting:   abort(errMissingTarget,"");
        | gotsource: abort(errMissingOffset,"");
        | gottarget: Str.Copy(clipatch,target);
        | gotplus:   Str.Prepend(clipatch," ");Str.Prepend(clipatch,target);
        END;
        Str.Copy(target,source);

        (* IF useLFN THEN abort(errIrrelevant,"-lfn");END; *)
        IF userfpos # UNDEFINED THEN abort(errIrrelevant,"-p:#");END;
        IF baseaddr # UNDEFINED THEN abort(errIrrelevant,"-b:#");END;
        IF bytesPerLine # UNDEF THEN abort(errIrrelevant,"-#");END;
        abortIfSpecified(FALSE, modula2        , dumpMode,"-m[m]");
        abortIfSpecified(FALSE, onlyascii      , dumpMode,"-a");
        abortIfSpecified(FALSE, widestmode     , dumpMode,"-e");

        abortIfSpecified(FALSE, xlatasciitooem , dumpMode,"-y");
        abortIfSpecified(FALSE, xlatoemtoascii , dumpMode,"-z");
        abortIfSpecified(FALSE, fullset        , dumpMode,"-f");
        abortIfSpecified(FALSE, unicrap        , dumpMode,"-j");
        abortIfSpecified(FALSE, uppercase      , dumpMode,"-u");
        abortIfSpecified(FALSE, showbinary     , dumpMode,"-2");
        abortIfSpecified(FALSE, verbose        , dumpMode,"-v");
        abortIfSpecified(FALSE, nowrap         , dumpMode,"-g");
        abortIfSpecified(FALSE, wordstar       , dumpMode,"-q");
        abortIfSpecified(FALSE, packtab        , dumpMode,"-!");
        abortIfSpecified(TRUE , syncvideo      , dumpMode,"-t");
        abortIfSpecified(TRUE , showascii      , dumpMode,"-n");
        abortIfSpecified(TRUE , showaddress    , dumpMode,"-r");
        abortIfSpecified(TRUE , paging         , dumpMode,"-k");

        IF chkJoker(target) THEN abort(errJokerTarget,target);END;
        IF fileExists(useLFN,target)=FALSE THEN abort(errNotFoundTarget,target);END;
        IF fileIsRO(useLFN,target) THEN abort(errReadonly,target);END;

        IF doCmdPatchFromCLI(useLFN,dumpMode,target,clipatch)=FALSE THEN abort(errBadPatch,"");END;
    END;

    (* ------------------------------------------------------------ *)

    IF (memory IN command) THEN
        CASE status OF
        | waiting:   abort(errMissingSegOfs,"");
        | gotsource: abort(errMissingCount,"");
        | gottarget: ;
        | gotplus:   abort(errUneeded,"");
        END;
        (* now parse sef:ofs and count *)
        IF getSegOfs(source,segment,offset)=FALSE THEN abort(errBadSegOfs,source);END;
        IF getCount(target,memcount)=FALSE THEN abort(errBadCount,target);END;
        IF memcount=0 THEN abort(errBadCount,target);END;

        IF userfpos # UNDEFINED THEN abort(errIrrelevant,"-p:#");END;
        IF baseaddr # UNDEFINED THEN abort(errIrrelevant,"-b:#");END;
        abortIfSpecified(FALSE, overwrite      , dumpMode,"-o");
        abortIfSpecified(FALSE, verbose        , dumpMode,"-v");
        abortIfSpecified(FALSE, nowrap         , dumpMode,"-g");
        abortIfSpecified(FALSE, wordstar       , dumpMode,"-q");
        abortIfSpecified(FALSE, packtab        , dumpMode,"-!");
        abortIfSpecified(TRUE , samestamp      , dumpMode,"-s");
        abortIfSpecified(FALSE, stringdata     , dumpMode,"-$");

        IF ( (decimalbase IN dumpMode) AND (uppercase IN dumpMode) ) THEN
            abort(errNonsense,"");
        END;
        IF IsRedirected() THEN
            EXCL(dumpMode,paging); (* ignore paging if output redirected *)
            EXCL(dumpMode,allowsinglestep);
        END;

        (* disable possible -f if dumping to video using BIOS *)

            IF IsRedirected()=FALSE THEN
                IF getUseBiosMode() THEN EXCL(dumpMode,fullset); END;
            END;

        IF bytesPerLine = UNDEF THEN bytesPerLine := 16; END;

        IF doCmdMemory(dumpMode,bytesPerLine, CARDINAL(segment),CARDINAL(offset),memcount)=FALSE THEN abort(errAborted,"");END;
    END;

    (* ------------------------------------------------------------ *)

    IF (list IN command) THEN
        CASE status OF
        | waiting:   abort(errMissingSource,"");
        | gotsource: ;
        | gottarget: abort(errSyntaxList,target);
        | gotplus:   abort(errUneeded,"");
        END;
        IF chkJoker(source) THEN abort(errJoker,source);END;
        IF fileExists(useLFN,source)=FALSE THEN abort(errNotFound,source); END;

        IF userfpos # UNDEFINED THEN abort(errIrrelevant,"-p:#");END;
        IF baseaddr # UNDEFINED THEN abort(errIrrelevant,"-b:#");END;
        IF bytesPerLine # UNDEF THEN abort(errIrrelevant,"-#");END;
        abortIfSpecified(FALSE, modula2        , dumpMode,"-m[m]");
        abortIfSpecified(FALSE, onlyascii      , dumpMode,"-a");
        abortIfSpecified(FALSE, widestmode     , dumpMode,"-e");

        abortIfSpecified(FALSE, fullset        , dumpMode,"-f");
        abortIfSpecified(FALSE, uppercase      , dumpMode,"-u");
        abortIfSpecified(FALSE, decimalbase    , dumpMode,"-d");
        abortIfSpecified(FALSE, overwrite      , dumpMode,"-o");
        abortIfSpecified(FALSE, showbinary     , dumpMode,"-2");
        abortIfSpecified(FALSE, verbose        , dumpMode,"-v");
        abortIfSpecified(FALSE, words          , dumpMode,"-w");
        abortIfSpecified(TRUE , samestamp      , dumpMode,"-s");
        abortIfSpecified(TRUE , showascii      , dumpMode,"-n");
        abortIfSpecified(TRUE , showaddress    , dumpMode,"-r");
        abortIfSpecified(TRUE , paging         , dumpMode,"-k");
        abortIfSpecified(FALSE, stringdata     , dumpMode,"-$");

        IF IsRedirected() THEN abort(errRedirectionList,"");END; (* well... we could accept it *)

        doCmdList(useLFN,dumpMode,source);
    END;

    (* ------------------------------------------------------------ *)

    IF (dump IN command) THEN
        CASE status OF
        | waiting:   abort(errMissingSource,"");
        | gotsource: Str.Copy(target,"");
        | gottarget: ;
        | gotplus:   abort(errUneeded,"");
        END;
        IF chkJoker(source) THEN abort(errJoker,source);END;
        IF fileExists(useLFN,source)=FALSE THEN abort(errNotFound,source); END;

        abortIfSpecified(TRUE , samestamp      , dumpMode,"-s");
        abortIfSpecified(FALSE, nowrap         , dumpMode,"-g");
        abortIfSpecified(FALSE, wordstar       , dumpMode,"-q");
        abortIfSpecified(FALSE, stringdata     , dumpMode,"-$");

        IF ( (decimalbase IN dumpMode) AND (uppercase IN dumpMode) ) THEN
            abort(errNonsense,"");
        END;
        tofile := NOT ( same(target,"") );
        IF tofile THEN
            IF fileExists(useLFN,target) THEN
                IF (overwrite IN dumpMode) THEN
                    IF fileIsRO(useLFN,target) THEN abort(errReadonly,target);END;
                ELSE
                    abort(errAlreadyExists,target);
                END;
            END;
        END;
        (* only doDump takes paging into account *)
        IF ( IsRedirected() OR tofile ) THEN
            EXCL(dumpMode,paging); (* ignore paging if target specified or output redirected *)
            EXCL(dumpMode,allowsinglestep);
        END;

        (* disable possible -f if dumping to video using BIOS *)

        IF NOT( tofile ) THEN
            IF IsRedirected()=FALSE THEN
                IF getUseBiosMode() THEN EXCL(dumpMode,fullset); END;
            END;
        END;

        IF userfpos = UNDEFINED THEN
            userfpos:=0;
        ELSE
            IF tofile THEN abort(errUserFposToFile,"");END;
            IF userfpos > 0 THEN
                tmpfsize:=fileGetFileSize(useLFN,source);
                IF userfpos >= tmpfsize THEN abort(errUserFposRange,"");END;
            END;
        END;

        IF baseaddr = UNDEFINED THEN baseaddr:=0; END;

        IF bytesPerLine = UNDEF THEN bytesPerLine := 16; END;

        IF doCmdDump(useLFN,dumpMode,bytesPerLine,userfpos,baseaddr,source,target)=FALSE THEN abort(errAborted,"");END;
    END;

    (* ------------------------------------------------------------ *)

    abort(errNone,"");
END XD.




(*

@echo off
if "%1"=="" goto syntax
if not "%2"=="" goto syntax
for %%s in (D DUMP C CREATE P PATCH K CLEAN) do if "%1"=="%%s" goto %1
for %%s in (d dump c create p patch k clean) do if "%1"=="%%s" goto %1

:syntax
echo Syntax : ''%0 DUMP'' to dump data to *.dmp files then create *.xd files
echo          ''%0 CREATE'' to create target from modified *.dmp files
echo          ''%0 PATCH'' to patch *.xd files from *.dmp files
echo          ''%0 CLEAN'' to clean all *.dmp and *.xd files
goto end

:dump
:d
echo Creating dumps...

xd xdtest.bat -o -8             08____.dmp
xd xdtest.bat -o -8 -d          08d___.dmp
xd xdtest.bat -o -8 -d -n       08dn__.dmp
xd xdtest.bat -o -8 -d -n -r    08dnr_.dmp
xd xdtest.bat -o -8 -d    -r    08d_r_.dmp
xd xdtest.bat -o -8    -n       08_n__.dmp
xd xdtest.bat -o -8    -n -r    08_nr_.dmp
xd xdtest.bat -o -8    -n -r -u 08_nru.dmp
xd xdtest.bat -o -8       -r    08__r_.dmp
xd xdtest.bat -o -8       -r -u 08__ru.dmp
xd xdtest.bat -o -8          -u 08___u.dmp

xd xdtest.bat -o -16             16____.dmp
xd xdtest.bat -o -16 -d          16d___.dmp
xd xdtest.bat -o -16 -d -n       16dn__.dmp
xd xdtest.bat -o -16 -d -n -r    16dnr_.dmp
xd xdtest.bat -o -16 -d    -r    16d_r_.dmp
xd xdtest.bat -o -16    -n       16_n__.dmp
xd xdtest.bat -o -16    -n -r    16_nr_.dmp
xd xdtest.bat -o -16    -n -r -u 16_nru.dmp
xd xdtest.bat -o -16       -r    16__r_.dmp
xd xdtest.bat -o -16       -r -u 16__ru.dmp
xd xdtest.bat -o -16          -u 16___u.dmp

xd xdtest.bat -o -32             32____.dmp
xd xdtest.bat -o -32 -d          32d___.dmp
xd xdtest.bat -o -32 -d -n       32dn__.dmp
xd xdtest.bat -o -32 -d -n -r    32dnr_.dmp
xd xdtest.bat -o -32 -d    -r    32d_r_.dmp
xd xdtest.bat -o -32    -n       32_n__.dmp
xd xdtest.bat -o -32    -n -r    32_nr_.dmp
xd xdtest.bat -o -32    -n -r -u 32_nru.dmp
xd xdtest.bat -o -32       -r    32__r_.dmp
xd xdtest.bat -o -32       -r -u 32__ru.dmp
xd xdtest.bat -o -32          -u 32___u.dmp

goto create

:create
:c
echo Creating from dumps...

xd -o -c        08____.dmp  08____.xd
xd -o -c -d     08d___.dmp  08d___.xd
xd -o -c -d     08dn__.dmp  08dn__.xd
xd -o -c -d     08dnr_.dmp  08dnr_.xd
xd -o -c -d     08d_r_.dmp  08d_r_.xd
xd -o -c        08_n__.dmp  08_n__.xd
xd -o -c        08_nr_.dmp  08_nr_.xd
xd -o -c        08_nru.dmp  08_nru.xd
xd -o -c        08__r_.dmp  08__r_.xd
xd -o -c        08__ru.dmp  08__ru.xd
xd -o -c        08___u.dmp  08___u.xd

xd -o -c        16____.dmp  16____.xd
xd -o -c -d     16d___.dmp  16d___.xd
xd -o -c -d     16dn__.dmp  16dn__.xd
xd -o -c -d     16dnr_.dmp  16dnr_.xd
xd -o -c -d     16d_r_.dmp  16d_r_.xd
xd -o -c        16_n__.dmp  16_n__.xd
xd -o -c        16_nr_.dmp  16_nr_.xd
xd -o -c        16_nru.dmp  16_nru.xd
xd -o -c        16__r_.dmp  16__r_.xd
xd -o -c        16__ru.dmp  16__ru.xd
xd -o -c        16___u.dmp  16___u.xd

xd -o -c        32____.dmp  32____.xd
xd -o -c -d     32d___.dmp  32d___.xd
xd -o -c -d     32dn__.dmp  32dn__.xd
xd -o -c -d     32dnr_.dmp  32dnr_.xd
xd -o -c -d     32d_r_.dmp  32d_r_.xd
xd -o -c        32_n__.dmp  32_n__.xd
xd -o -c        32_nr_.dmp  32_nr_.xd
xd -o -c        32_nru.dmp  32_nru.xd
xd -o -c        32__r_.dmp  32__r_.xd
xd -o -c        32__ru.dmp  32__ru.xd
xd -o -c        32___u.dmp  32___u.xd

goto end

:patch
:p
echo Not yet implemented !
goto end

:clean
:k
del *.dmp
del *.xd
goto end

:end

*)

(*

\bat\xd tsc.exe             file____.qd
\bat\xd tsc.exe  /f         fileFilt.qd

\bat\xd tsc.exe      /b     file____.bio
\bat\xd tsc.exe  /f  /b     fileFilt.bio

\bat\xd tsc.exe           > red____.qd
\bat\xd tsc.exe  /f       > redFilt.qd

\bat\xd tsc.exe      /b   > red____.bio
\bat\xd tsc.exe  /f  /b   > redFilt.bio

*)

(*
              IRRELEVANT
list                b: #     f a e s   u d o 2 m n r k v w
dump                               s                       g q
memory              b:             s       o           v   g q
create            t b: # y z f a e s j u     2 m n r k   w g q
patch             t b: # y z f a e   j u     2 m n r k   w g q
patchfromcli  lfn t b: # y z f a e   j u     2 m n r k v   g q

     ONLY
-t   dump memory list                              // syncvideo     DEFAULT
-p:# dump                                          // userfpos
-b:# dump                                          // baseaddr
-#   dump memory                                   // bytesPerLine
-y   dump memory list                              // xlatasciitooem
-z   dump memory list                              // xlatoemtoascii
-f   dump memory                                   // fullset
-a   dump memory                                   // onlyascii
-e   dump memory                                   // onlyascii+widestmode
-s                    patch patchfromcli           // samestamp     DEFAULT
-j   dump memory list                              // unicrap
-u   dump memory                                   // uppercase
-d   dump memory      patch patchfromcli create    // decimalbase
-o   dump             patch patchfromcli create    // overwrite
-2   dump memory                                   // showbinary
-m[m]dump memory                                   // modula2
-n   dump memory                                   // showascii     DEFAULT
-r   dump memory                                   // showaddress   DEFAULT
-k   dump memory                                   // paging        DEFAULT
-v   dump             patch              create    // verbose
-w   dump memory            patchfromcli           // words
-g               list
-q               list
-b   ALL                                           // forcebios

note options included as default must be checked with TRUE

note a few CLI options affect many options : therefore,
we check modula2, onlyascii and widestmode FIRST

*)





(*
//TEST


111111111 11111111111111 11111111 1111111 111111111111111 1111111
222 22222222222 222222 22222222222222222222 22222222 2222222222222222 222222222222222222222222222 222222222
3333333 333333333 333333 33333333 33333333 33333333 3333333333
444444444444444444 444444444444444444 44444444444444 444444444444 4444444
5555 55555555555555 5555555555555555555555555 5555555555555555 555555555 55555555555555 5555555555555555555
666666666666 66666666666666666 66666666666666666 666666666 66666
77777 77777777 777777 777 777 777777777 77777777777 777777777 777777777 77777777777777 777
88 88888888 8888888888 888888888888 888888888
999999999 99999 999 9999 999999 999999 999999999999 9999999999999 999999999999 999999999999 99999 9999999
10
11
12
13
14
15
16
17
18
19
202020 2020 20202020 2020202020202020 2020 20 20202020202020 2020 20202020 2020202020202020
21
22
23
24
25
26
27
28
29
30303030 3030 30303030 3030 30 30303030 303030303030 303030 303030 3030303030303030 3030303030 3030
31
32
33
34
35
36
37
38
39
4040 4040 4040404040 4040 40 404040 4040404040 404040404040 404040 4040
41
42
43
44
45
46
47
48
49
50
51
52
53
54
55
56
57
58
59
60
61
62
63
64
65
66
67
68
69

*)

