
(* --------------------------------------------------------------
Title         Q&D Fire Bees demo
Author        PhG
Overview      tsk tsk...
Usage         see help
Notes         
              minimal error messages and checking, etc.
              model should definitely be LARGE
              we needed a third screen as to prevent WorkScreen corruption
              while creating next workscreen !
Bugs

Wish List     tsk tsk... maybe some random color changes

--------------------------------------------------------------- *)

MODULE FireBees;

IMPORT Lib;
IMPORT SYSTEM;
IMPORT IO;
IMPORT Str;
IMPORT BiosIO;
IMPORT MATHLIB;
IMPORT MsMouse;

FROM IO IMPORT WrStr, WrLn;

FROM QD_Box IMPORT str80, str2, cmdInit, cmdShow, cmdStop, delim,
Work, video, Ltrim, Rtrim, UpperCase, LowerCase, ReplaceChar,
ChkEscape, Waitkey, WaitkeyDelay, Flushkey, IsRedirected, chkJoker,
isOption, GetOptIndex, GetLongCard, GetLongInt, GetString, CharCount,
same, aR, aH, aS, aD, aA, everything, isDirectory, fixDirectory,
str128, str256, Animation, allfiles, Belongs, FixAE, CodePhonetic,
CodeSoundex, CodeSoundexOrg, isReadOnly, LtrimBlanks, RtrimBlanks,
getStrIndex, cmdSHOW,BiosWaitkey,BiosWaitkeyShifted,BiosFlushkey,
str1024, isoleItemS, dmpTTX, str2048, Elapsed, TerminalReadString,
getDosVersion, DosVersion, warning95, runningWindows, cleantabs,
aV, reallyeverything, chkClassicTextMode, setClassicTextMode;

FROM Lib IMPORT FarFill,FarWordMove;
FROM Storage IMPORT ALLOCATE;

(* ------------------------------------------------------------ *)
(* ------------------------------------------------------------ *)

CONST
    TSRAND = TRUE ; (* TRUE = M2 random generator, FALSE = homemade *)

CONST
    ProgEXEname   = "FIREBEES";
    ProgTitle     = "Q&D Fire Bees demo";
    ProgVersion   = "v1.0a";
    ProgCopyright = "by PhG";
    Banner        = ProgTitle+" "+ProgVersion+" "+ProgCopyright;

CONST
    errNone           = 0;
    errHelp           = 1;
    errIllegalParm    = 2;
    errUnknownOpt     = 3;
    errRange          = 4;

PROCEDURE abort (e : CARDINAL; einfo : ARRAY OF CHAR);
CONST
    cr         = CHR(13);
    lf         = CHR(10);
    nl         = cr+lf;
CONST
(*
 00000000011111111112222222222333333333344444444445555555555666666666677777777778
 1...'....0....'....0....'....0....'....0....'....0....'....0....'....0....'....0
*)
    helpmsg =
Banner+nl+
nl+
"Syntax : "+ProgEXEname+" [option]..."+nl+
nl+
"  -a    show palette until keypress or 10 seconds"+nl+
"  -z    end on mouseclick too"+nl+
"  -p:#  color palette (0..11=rRGB$/*1230, default is 0, 11=system palette)"+nl+
"  -b:#  number of bees (1..10000, default is 500)"+nl+
"  -wa:# wasp maximum acceleration (1..20, default is 3)"+nl+
"  -wv:# wasp maximum velocity (1..20, default is 6)"+nl+
"  -ba:# bee maximum acceleration (1..20, default is 2)"+nl+
"  -bv:# bee maximum velocity (1..20, default is 3)"+nl+
"  -wb:# wasp minimum distance from border (0..20, default is 2)"+nl+
"  -t:#  threshold probability for a bee to focus on wasp (0..11, default is 4)"+nl+
"  -s    no smoothing, just dots"+nl+
"  -s:#  smoothing rounds (0=same as -s)"+nl+
"  -c    clear history"+nl+
"  -d:#  delay (number of waits for vertical retrace, default is 0)"+nl+
nl+
"[rRGB$/*1230]-palette, [c]-toggle history, [s]-toggle smoothing"+nl+
"[Home|End]-threshold, [Space]-pause, [Escape|Enter]-end"+nl;

VAR
    S : str256;
BEGIN
    CASE e OF
    | errHelp :
        WrStr(helpmsg);
    | errIllegalParm :
        Str.Concat(S,"Illegal ",einfo); Str.Append(S," parameter !");
    | errUnknownOpt :
        Str.Concat(S,"Unknown ",einfo); Str.Append(S," option !");
    | errRange :
        Str.Concat(S,"Value for ",einfo);
        Str.Append(S," not in legal range !");
    ELSE
        S := "This is illogical, Captain !";
    END;
    CASE e OF
    | errNone,errHelp :
        ; (* nada *)
    ELSE
        WrStr(ProgEXEname+" : "); WrStr(S); WrLn;
    END;
    Lib.SetReturnCode(SHORTCARD(e));
    HALT;
END abort;

(* ------------------------------------------------------------ *)
(* ------------------------------------------------------------ *)

CONST
    keyEscape  = 01B00H;
    keySpace   = 02000H;
    keyCR      = 00D00H;
    keyPageUp  = 00049H;
    keyPageDn  = 00051H;
    keyEnd     = 0004FH;
    keyHome    = 00047H;
    keyDivide  = ORD("/") << 8 ;
    keyStar    = ORD("*") << 8 ;
    keydollar  = ORD("$") << 8 ;
    upperR     = ORD("R") << 8 ;
    lowerR     = ORD("r") << 8 ;
    upperG     = ORD("G") << 8 ;
    lowerG     = ORD("g") << 8 ;
    upperB     = ORD("B") << 8 ;
    lowerB     = ORD("b") << 8 ;
    keyLeft    = 0004BH;
    keyRight   = 0004DH;
    lowerS     = ORD("s") << 8 ;
    upperS     = ORD("S") << 8 ;
    lowerC     = ORD("c") << 8 ;
    upperC     = ORD("C") << 8 ;
    key1       = ORD("1") << 8 ;
    key2       = ORD("2") << 8 ;
    key3       = ORD("3") << 8 ;
    key0       = ORD("0") << 8 ;


PROCEDURE value (S:ARRAY OF CHAR;min,max:CARDINAL;VAR r:CARDINAL):BOOLEAN;
VAR
    v : LONGCARD;
BEGIN
    IF GetLongCard(S,v)=FALSE THEN RETURN FALSE; END;
    IF v < LONGCARD(min) THEN RETURN FALSE; END;
    IF v > LONGCARD(max) THEN RETURN FALSE; END;
    r := CARDINAL(v);
    RETURN TRUE;
END value;

PROCEDURE ivalue (S:ARRAY OF CHAR;min,max:INTEGER;VAR r:INTEGER):BOOLEAN;
VAR
    v : LONGINT;
BEGIN
    IF GetLongInt(S,v)=FALSE THEN RETURN FALSE; END;
    IF v < LONGINT(min) THEN RETURN FALSE; END;
    IF v > LONGINT(max) THEN RETURN FALSE; END;
    r := INTEGER(v);
    RETURN TRUE;
END ivalue;

(* ------------------------------------------------------------ *)

(*%T TSRAND *)

PROCEDURE doRandomize (  );
BEGIN
    Lib.RANDOMIZE;
END doRandomize;

PROCEDURE getrndrange (lower,upper:CARDINAL):CARDINAL;
VAR
    range : CARDINAL;
    rnd   : REAL;
BEGIN
    range := upper-lower+1;
    rnd := (REAL(range) * Lib.RAND()) + REAL(lower);
    RETURN CARDINAL(rnd);
END getrndrange;

PROCEDURE getrndrangeint (lower,upper:INTEGER):INTEGER;
VAR
    range : INTEGER;
    rnd   : REAL;
BEGIN
    range := upper-lower+1;
    rnd := (REAL(range) * Lib.RAND()) + REAL(lower);
    RETURN INTEGER(rnd);
END getrndrangeint;

(*%E  *)

(* ------------------------------------------------------------ *)

(*%F TSRAND *)

MODULE alea;
IMPORT Lib;
EXPORT doRandomize,getrndrange;

PROCEDURE XOR (b1,b2 : CARDINAL) : CARDINAL;
BEGIN
    RETURN CARDINAL ( (BITSET (b1) / BITSET (b2)) );
END XOR;

VAR
    seed : INTEGER;

PROCEDURE doRandomize (  );
VAR
    biosTimerTicksSinceMidnightLo [0040H:006CH] : CARDINAL; (* lohi=dword *)
    biosTimerTicksSinceMidnightHi [0040H:006EH] : CARDINAL;
    h,m,s,ss:CARDINAL;
BEGIN
    Lib.GetTime(h,m,s,ss);
    seed := XOR(biosTimerTicksSinceMidnightLo, s);
END doRandomize;

PROCEDURE getrndint ():INTEGER ;
BEGIN
    seed := (seed * 259 + 3) AND 32767;
    RETURN seed; (* [0..32767] *)
END getrndint;

PROCEDURE getrndrange (lower,upper:CARDINAL):CARDINAL;
VAR
    range : CARDINAL;
    v     : CARDINAL;
BEGIN
    range := upper-lower+1;
    v := lower + ( CARDINAL (getrndint()) MOD range );
    RETURN v;
END getrndrange;

PROCEDURE getrndrangeint (lower,upper:INTEGER):INTEGER;
VAR
    range : INTEGER;
    v     : INTEGER;
BEGIN
    range := upper-lower+1;
    v := lower + ( getrndint() MOD range );
    RETURN v;
END getrndrangeint;

END alea;

(*%E *)

(* ------------------------------------------------------------ *)
(* ------------------------------------------------------------ *)

PROCEDURE flushKeyboard (  );
VAR
    c : CHAR;
BEGIN
    LOOP
        IF BiosIO.KeyPressed()=FALSE THEN EXIT; END;
        c := BiosIO.RdKey();
        IF c = CHR(0) THEN c := BiosIO.RdKey(); END;
    END;
END flushKeyboard;

PROCEDURE getKeyboardCode (VAR keycode:CARDINAL):BOOLEAN;
VAR
    c1,c2:CHAR;
BEGIN
    IF BiosIO.KeyPressed()=FALSE THEN RETURN FALSE; END;
    c1 := BiosIO.RdKey();
    IF c1 = CHR(0) THEN
        c2 := BiosIO.RdKey();
    ELSE
        c2 := CHR(0);
    END;
    keycode := (ORD(c1) << 8) + ORD(c2);
    RETURN TRUE;
END getKeyboardCode;

PROCEDURE input (maxWait:LONGINT); (* in seconds *)
VAR
    keycode:CARDINAL;
    h,m,s,ss:CARDINAL;
    start : LONGINT;
    now   : LONGINT;
BEGIN
    Lib.GetTime(h,m,s,ss);
    start := (LONGINT(h)*60+LONGINT(m))*60+LONGINT(s);
    LOOP
        IF getKeyboardCode(keycode) THEN EXIT; END;
        Lib.GetTime(h,m,s,ss);
        now := (LONGINT(h)*60+LONGINT(m))*60+LONGINT(s);
        IF ABS(now-start) > maxWait THEN EXIT; END;
    END;
END input;

PROCEDURE mouseclick (  ):BOOLEAN;
VAR
    msdata:MsMouse.MsData;
BEGIN
    MsMouse.GetStatus(msdata);
    IF msdata.left_pressed THEN RETURN TRUE; END;
    IF msdata.right_pressed THEN RETURN TRUE; END;
    RETURN msdata.middle_pressed;
END mouseclick;

(* ------------------------------------------------------------ *)
(* ------------------------------------------------------------ *)

CONST
    hires       = 13H; (* 320x200x256 *)
    text        = 03H; (* 80x25 *)
    xcount      = 320;
    ycount      = 200;
    xmin        = 0;
    xmax        = xcount-1;
    ymin        = 0;
    ymax        = ycount-1;
    cx          = xcount DIV 2;
    screensize  = xcount * ycount;
    screensizeW =(screensize DIV 2);
TYPE
    screenType = ARRAY [0..screensize-1 +1+xcount] OF BYTE;   (* 320x200=64000 with security *)
VAR
    WorkScreen    : POINTER TO screenType;
    SmoothScreen  : POINTER TO screenType;
    NextWorkScreen: POINTER TO screenType;
VAR
    videoscreen [0A000H:0000H] : ARRAY [0..screensize-1] OF BYTE;
    Ybase                      : ARRAY [ymin..ymax] OF CARDINAL;

(* ------------------------------------------------------------ *)

PROCEDURE initYbase ();
VAR
    i,p:CARDINAL;
BEGIN
    p := 0;
    FOR i := ymin TO ymax DO
        Ybase[i]:=p;
        INC(p,xcount);
    END;
END initYbase;

PROCEDURE setVideoMode (mode:CARDINAL);
VAR
    R : SYSTEM.Registers;
BEGIN
    R.AH := 00H;
    R.AL := BYTE(mode);
    Lib.Intr(R,10H);
END setVideoMode;

PROCEDURE waitVGAretrace ();
BEGIN
    WHILE (SYSTEM.In(03DAH) AND 08H) # 0 DO
    END;
    WHILE (SYSTEM.In(03DAH) AND 08H) = 0 DO
    END;
END waitVGAretrace;

PROCEDURE clearvideoscreen (inkndx:CARDINAL);
BEGIN
    Lib.FarWordFill(FarADR(videoscreen),screensizeW,(inkndx << 8 + inkndx));
END clearvideoscreen;

PROCEDURE clearworkscreen(inkndx:CARDINAL );
BEGIN
    Lib.FarWordFill(FarADR(WorkScreen^),screensizeW,(inkndx << 8 + inkndx));
END clearworkscreen;

PROCEDURE clearsmoothscreen(inkndx:CARDINAL);
BEGIN
    Lib.FarWordFill(FarADR(SmoothScreen^),screensizeW,(inkndx << 8 + inkndx));
END clearsmoothscreen;

PROCEDURE clearnextworkscreen(inkndx:CARDINAL);
BEGIN
    Lib.FarWordFill(FarADR(NextWorkScreen^),screensizeW,(inkndx << 8 + inkndx));
END clearnextworkscreen;

PROCEDURE nextworkscreen2workscreen ();
BEGIN
    FarWordMove(FarADR(NextWorkScreen^),FarADR(WorkScreen^),screensizeW);
END nextworkscreen2workscreen;

PROCEDURE smooth2video();
BEGIN
    waitVGAretrace;
    FarWordMove(FarADR(SmoothScreen^),FarADR(videoscreen),screensizeW);
END smooth2video;

PROCEDURE work2video();
BEGIN
    waitVGAretrace;
    FarWordMove(FarADR(WorkScreen^),FarADR(videoscreen),screensizeW);
END work2video;

PROCEDURE wplot (x,y:CARDINAL;ink:BYTE);
BEGIN
    WorkScreen^[Ybase[y]+x]:=ink;
END wplot;

PROCEDURE splot (x,y:CARDINAL;ink:BYTE);
BEGIN
    SmoothScreen^[Ybase[y]+x]:=ink;
END splot;

(* ------------------------------------------------------------ *)

CONST
    black       = LONGCARD(0000000H);
    white       = LONGCARD(03F3F3FH); (* ega/vga range is $00..$3F *)
    red         = LONGCARD(03F0000H);
    green       = LONGCARD(0003F00H);
    darkgreen   = LONGCARD(0002000H);
    blue        = LONGCARD(000003FH);
    darkblue    = LONGCARD(0000020H);
    cyan        = LONGCARD(0002F3FH);
    yellow      = LONGCARD(03F3F00H);
    darkred     = LONGCARD(0200000H);
    orange      = LONGCARD(02F2F00H);
CONST
    egarange    = 40H;
    mininkindex = 0;
    maxinkindex = 256-1;
    ndxblack    = mininkindex;
    maxcolorindex=egarange-1; (* we use 64 colors palette here *)

PROCEDURE setDAC(index:CARDINAL;red,green,blue:BYTE);
CONST
    DACWriteIndex  = 03C8H;
    DACDataRegister= 03C9H;
BEGIN
    SYSTEM.Out (DACWriteIndex,SHORTCARD(index));
    SYSTEM.Out (DACDataRegister, red);
    SYSTEM.Out (DACDataRegister, green);
    SYSTEM.Out (DACDataRegister, blue);
END setDAC;

PROCEDURE readDACrgb (index:CARDINAL):LONGCARD;
CONST
    DACReadIndex   = 03C7H;
    DACDataRegister= 03C9H;
VAR
    r,g,b:SHORTCARD;
    rgb : LONGCARD;
BEGIN
    SYSTEM.Out (DACReadIndex,SHORTCARD(index));
    r:=SYSTEM.In (DACDataRegister);
    g:=SYSTEM.In (DACDataRegister);
    b:=SYSTEM.In (DACDataRegister);
    rgb := (LONGCARD(r) << 16) + (LONGCARD(g) << 8) + LONGCARD(b);
    RETURN rgb;
END readDACrgb;

PROCEDURE resetdac (index,red,green,blue:CARDINAL);
BEGIN
    setDAC(index,BYTE(red),BYTE(green),BYTE(blue));
END resetdac;

PROCEDURE maxmin (VAR bigger,smaller:INTEGER);
VAR
    tmp:INTEGER;
BEGIN
    IF smaller <= bigger THEN RETURN; END;
    tmp:=bigger;
    bigger:=smaller;
    smaller:=tmp;
END maxmin;

PROCEDURE blend (ndx,count:CARDINAL; startink, endink:LONGCARD);
CONST
    rshift = LONGCARD(16);
    gshift = LONGCARD(8);
VAR
    r1,g1,b1:INTEGER;
    r2,g2,b2:INTEGER;
    r,g,b:INTEGER;
    i : CARDINAL;
BEGIN
    IF count=0 THEN count := 1; END; (* safety to avoid division by 0 ! *)

    r1 := INTEGER (startink >> rshift) MOD egarange;
    g1 := INTEGER (startink >> gshift) MOD egarange;
    b1 := INTEGER (startink          ) MOD egarange;
    r2 := INTEGER (endink   >> rshift) MOD egarange;
    g2 := INTEGER (endink   >> gshift) MOD egarange;
    b2 := INTEGER (endink            ) MOD egarange;

    (* certainly useless but... *)
(*
    maxmin(r2,r1);
    maxmin(g2,g1);
    maxmin(b2,b1);
*)
    FOR i := 1 TO count DO
        r := r1 + ((r2 - r1) * INTEGER(i) ) DIV INTEGER(count);
        g := g1 + ((g2 - g1) * INTEGER(i) ) DIV INTEGER(count);
        b := b1 + ((b2 - b1) * INTEGER(i) ) DIV INTEGER(count);
        IF r < 0 THEN r:=0; END;
        IF g < 0 THEN g:=0; END;
        IF b < 0 THEN b:=0; END;
        IF r >= egarange THEN r:=egarange-1; END;
        IF g >= egarange THEN g:=egarange-1; END;
        IF b >= egarange THEN b:=egarange-1; END;
        setDAC(ndx+i-1,BYTE(r),BYTE(g),BYTE(b));
    END;
END blend;

PROCEDURE normalize (VAR lc:LONGCARD);
VAR
    r,g,b:CARDINAL;
BEGIN
    r := CARDINAL(lc MOD 100H);
    g := CARDINAL(lc DIV 100H) MOD 100H;
    b := CARDINAL(lc DIV 10000H);
    r := r >> 2; (* MOD egarange; *)
    g := g >> 2;
    b := b >> 2;
    lc := LONGCARD(b) << 16 + LONGCARD(g) << 8 + LONGCARD(r);
END normalize;

PROCEDURE genRGB (  ):LONGCARD;
CONST
    dimmest   = 000H;
    brightest = 03FH;
VAR
    r,g,b : CARDINAL;
    bgr : LONGCARD;
BEGIN
    r := getrndrange(dimmest,brightest);
    g := getrndrange(dimmest,brightest);
    b := getrndrange(dimmest,brightest);
    bgr := LONGCARD(b) << 16 + LONGCARD(g) << 8 + LONGCARD(r);
    RETURN bgr;
END genRGB;

TYPE
    fixedpal64type = ARRAY [0..64*3-1] OF BYTE;
CONST
    fixedfirepal = fixedpal64type(
     0, 0, 0,
     1, 0, 0,
     2, 0, 0,
    10, 0, 0,
    18, 0, 0,
    26, 0, 0,
    32, 0, 0,
    36, 0, 0,
    39, 0, 0,
    42, 0, 0,
    46, 1, 0,
    50, 3, 0,
    54, 5, 0,
    58, 7, 0,
    63, 9, 0,
    63,11, 0,
    63,13, 0,
    63,15, 0,
    63,17, 0,
    63,19, 0,
    63,21, 0,
    63,23, 0,
    63,25, 0,
    63,27, 0,
    63,29, 0,
    63,31, 0,
    63,33, 0,
    63,35, 0,
    63,38, 0,
    63,40, 0,
    63,42, 0,
    63,44, 0,
    63,46, 0,
    63,48, 0,
    63,50, 0,
    63,52, 0,
    63,53, 0,
    63,54, 0,
    63,54, 0,
    63,55, 0,
    63,56, 0,
    63,57, 0,
    63,58, 0,
    63,59, 0,
    63,60, 0,
    63,61, 0,
    63,62, 0,
    63,63, 1,
    63,63, 5,
    63,63, 9,
    63,63,12,
    63,63,16,
    63,63,20,
    63,63,23,
    63,63,27,
    63,63,31,
    63,63,34,
    63,63,38,
    63,63,42,
    63,63,45,
    63,63,49,
    63,63,52,
    63,63,56,
    63,63,60);

TYPE
    palettetype = (firepal,rpal,gpal,bpal,
                   rainbowpal,randompal,rndpal,
                   palrouge,palvert,palbleu,palgris,
                   systempal);

PROCEDURE newPalette64 (pal:palettetype);
VAR
    ndx : CARDINAL;
    n   : CARDINAL;
    i   : CARDINAL;
    r,g,b:BYTE;
    ir,ig,ib:CARDINAL;
BEGIN
    waitVGAretrace(); (* reduce noise on screen *)
    CASE pal OF
    | rpal:
        ndx := 0;         n := 2;
        FOR i := 1 TO n DO resetdac(ndx+i-1,00H,00H,00H);END;
        INC(ndx,n);       n := 8;
        blend (ndx,n,black,darkred);
        INC(ndx,n);       n := 19;
        blend (ndx,n,darkred,red);
        INC(ndx,n);       n := 19;
        blend (ndx,n,red,yellow);
        INC(ndx,n);       n := 16;
        blend (ndx,n,yellow,white);
    | gpal:
        ndx := 0;         n := 2;
        FOR i := 1 TO n DO resetdac(ndx+i-1,00H,00H,00H);END;
        INC(ndx,n);       n := 16;
        blend (ndx,n,black,darkgreen);
        INC(ndx,n);       n := 15;
        blend (ndx,n,darkgreen,green);
        INC(ndx,n);       n := 15;
        blend (ndx,n,green,yellow);
        INC(ndx,n);       n := 16;
        blend (ndx,n,yellow,white);
    | bpal:                           (* 2 18 14 30 *)
        ndx := 0;         n := 2;
        FOR i := 1 TO n DO resetdac(ndx+i-1,00H,00H,00H);END;
        INC(ndx,n);       n := 8;
        blend (ndx,n,black,darkblue);
        INC(ndx,n);       n := 8;
        blend (ndx,n,darkblue,blue);
        INC(ndx,n);       n := 20;
        blend (ndx,n,blue,cyan);
        INC(ndx,n);       n := 26;
        blend (ndx,n,cyan,white);
    | firepal:
        FOR ndx:= 0 TO egarange-1 DO
            n := ndx*3;
            setDAC(ndx,fixedfirepal[n],fixedfirepal[n+1],fixedfirepal[n+2]);
        END;
    | rainbowpal:
        ndx := egarange-1;
        FOR ir := 0 TO 63 BY 4 DO
            FOR ig := 0 TO 63 BY 4 DO
                FOR ib := 0 TO 63 BY 12 DO
                    resetdac(ndx,ir,ig,ib);
                    DEC(ndx);
                    (* now prevent artefact *)
                    IF ndx=0 THEN ndx:=egarange-1;END;
                END;
            END;
        END;
    | randompal :
        FOR i := mininkindex TO egarange-1 DO
            setDAC(i,BYTE(getrndrange(0,egarange-1)),BYTE(getrndrange(0,egarange-1)),BYTE(getrndrange(0,egarange-1)));
        END;
    | rndpal:
        i := mininkindex;
        LOOP
            blend(i,8,genRGB(),genRGB());
            INC(i,8);
            IF i >= egarange THEN EXIT;END;
        END;
    | palrouge:
        n := 0;
	    FOR i:=32 TO 64 DO
            r:= BYTE(i) ; g:= 0; b:= 0;
            setDAC(n,r,g,b);setDAC(n+1,r,g,b);INC(n,2);
        END;
    | palvert:
        n := 0;
	    FOR i:=32 TO 64 DO
		    r:= 0; g:= BYTE(i); b:= 0;
            setDAC(n,r,g,b);setDAC(n+1,r,g,b);INC(n,2);
        END;
    | palbleu:
        n := 0;
	    FOR i:=32 TO 64 DO
		    r:= 0; g:= 0; b:= BYTE(i);
            setDAC(n,r,g,b);setDAC(n+1,r,g,b);INC(n,2);
        END;
    | palgris:
        n := 0;
	    FOR i:=32 TO 64 DO
		    r:= BYTE(i); g:= BYTE(i); b:= BYTE(i);
            setDAC(n,r,g,b);setDAC(n+1,r,g,b);INC(n,2);
        END;
    | systempal:
        (* nada ! *)
    END;
    setDAC(ndxblack,00H,00H,00H);    (* safety 0=black *)
    n := maxinkindex-egarange+1;
    blend (egarange,n,black,black);  (* 64..255=black *)
    (* setDAC(maxinkindex,3FH,3FH,3FH); *)
END newPalette64;

PROCEDURE showPalette (maxWaitInSeconds:LONGINT );
VAR
   i    : CARDINAL;
   xpos : CARDINAL;
   ypos : CARDINAL;
   p    : CARDINAL;
BEGIN
   clearvideoscreen(ndxblack); (* index of sky, so black *)
   FOR i := 0 TO 255 DO
       FOR ypos := ymin TO ymax DO
           p := Ybase[ypos] + i; (* was ypos * xcount + i *)
           videoscreen[p]:=BYTE(i);
       END;
   END;
   input (maxWaitInSeconds);
END showPalette;

PROCEDURE smooth ();
VAR
    x,y:CARDINAL;
    ink,inkl,inkr,inku,inkd:CARDINAL;
    inklu,inkld,inkru,inkrd:CARDINAL;
    p,px:CARDINAL;
    pu,pd:CARDINAL;
BEGIN
    FOR y := ymin+1 TO ymax-1 DO
        p := Ybase[y]; (* useless to add +xcount ! -- was xcount * y *)
        FOR x := xmin+1 TO xmax-1 DO
            px := p+x;
            ink  :=CARDINAL(WorkScreen^[px]);             (* x  ,y   *)
            inkl :=CARDINAL(WorkScreen^[px-1]) ;          (* x-1,y   *)
            inkr :=CARDINAL(WorkScreen^[px+1]) ;          (* x+1,y   *)
            inku :=CARDINAL(WorkScreen^[px-xcount]);      (* x  ,y-1 *)
            inkd :=CARDINAL(WorkScreen^[px+xcount]);      (* x  ,y+1 *)
            ink  :=(ink + inkl +inkr + inku + inkd) DIV 5;
            IF ink > mininkindex THEN DEC(ink);END;
            NextWorkScreen^[px]  :=BYTE(ink);
            SmoothScreen^[px]:=BYTE(ink);
        END;
    END;
    nextworkscreen2workscreen;
END smooth;

PROCEDURE smoothalt();
VAR
    x,y:CARDINAL;
    ink,inkl,inkr,inku,inkd:CARDINAL;
    inklu,inkld,inkru,inkrd:CARDINAL;
    p,px:CARDINAL;
    pu,pd:CARDINAL;
BEGIN
    FOR y := ymin+1 TO ymax-1 DO
        p := Ybase[y]; (* useless to add +xcount ! -- was xcount * y *)
        FOR x := xmin+1 TO xmax-1 DO
            px := p+x;
            ink  :=CARDINAL(WorkScreen^[px]);             (* x  ,y   *)
            IF ink > mininkindex THEN DEC(ink);END;
            WorkScreen^[px]  :=BYTE(ink);
            SmoothScreen^[px]:=BYTE(ink);
        END;
    END;
END smoothalt;

(* ------------------------------------------------------------ *)
(* ------------------------------------------------------------ *)

CONST   (* we cheat with coordinates as to ease smoothing at limits *)
    ixmin       = INTEGER(xmin+1);
    ixmax       = INTEGER(xmax-1);
    iymin       = INTEGER(ymin+1);
    iymax       = INTEGER(ymax-1);

CONST
    minBEECOUNT         = 1;
    minWASPACCELERATION = 1;
    minWASPVELOCITY     = 1;
    minBEEACCELERATION  = 1;
    minBEEVELOCITY      = 1;
    minWASPBORDER       = 0;
    minbeestep          = 1;
    minProba            = 1;
CONST
    maxBEECOUNT         = 10000;
    maxWASPACCELERATION =  20;
    maxWASPVELOCITY     =  20;
    maxBEEACCELERATION  =  20;
    maxBEEVELOCITY      =  20;
    maxWASPBORDER       =  20;
    maxbeestep          = maxBEECOUNT;
    maxProba            =  10;
    minSmoothRounds     =  0;
    maxSmoothRounds     =  10;
    minDelay         = 0;
    maxDelay         = 20;
CONST
    defaultBeeCount         = 500;
    defaultWaspAcceleration =   3;
    defaultWaspVelocity     =   6;
    defaultBeeAcceleration  =   2;
    defaultBeeVelocity      =   3;
    defaultWaspBorder       =   2;
    defaultbeestep          =  50;
    beestepstep             =  10;
    defaultProba            =   4;
    defaultSmoothRounds     =   1;
    defaultDelay            = minDelay;
VAR
    BeeCount,SmoothRounds : CARDINAL;
    WaspAcceleration,
    BeeAcceleration,
    WaspBorder : INTEGER;
    WaspVelocity,BeeVelocity:SHORTINT;
    SmoothOn : BOOLEAN;
    xminBorder,xmaxBorder,yminBorder,ymaxBorder:CARDINAL;
    ixminBorder,ixmaxBorder,iyminBorder,iymaxBorder:INTEGER;
    beestep,proba: CARDINAL;
    palette     : palettetype;
    delay       : CARDINAL;

PROCEDURE initDefaults (  );
BEGIN
    BeeCount         := defaultBeeCount         ;
    WaspAcceleration := defaultWaspAcceleration ;
    WaspVelocity     := defaultWaspVelocity     ;
    BeeAcceleration  := defaultBeeAcceleration  ;
    BeeVelocity      := defaultBeeVelocity      ;
    WaspBorder       := defaultWaspBorder       ;
    (* SmoothOn         := defaultSmoothOn         ; *)
    beestep          := defaultbeestep          ;
    proba            := defaultProba            ;
    SmoothRounds     := defaultSmoothRounds     ;
    palette          := firepal                 ;
    delay            := defaultDelay            ;
END initDefaults;

TYPE
    particletype = RECORD
        x,y       : INTEGER; (* coordinates *)
        vx,vy     : SHORTINT; (* velocity *)
    END;
VAR
    wasp: particletype;
    bee : ARRAY [minBEECOUNT..maxBEECOUNT] OF particletype;

PROCEDURE newbee (i:CARDINAL);
BEGIN
        bee[i].x := getrndrange(xmin+1,xmax-1); (* use ixmin,ixmax *)
        bee[i].y := getrndrange(ymin+1,ymax-1); (* use iymin,iymax *)
        LOOP
            bee[i].vx := SHORTINT(getrndrangeint(-BeeAcceleration,+BeeAcceleration));
            bee[i].vy := SHORTINT(getrndrangeint(-BeeAcceleration,+BeeAcceleration));
            (* IF ((bee[i].vx # 0) OR (bee[i].vy # 0)) THEN EXIT; END; *)
            EXIT;
        END;
END newbee;

PROCEDURE initWaspAndBees ();
VAR
    i : CARDINAL;
BEGIN
    (* we cheat with limits in order to ease smoothing at limits *)
    xminBorder := ixmin+WaspBorder;
    xmaxBorder := ixmax-WaspBorder;
    yminBorder := iymin+WaspBorder;
    ymaxBorder := iymax-WaspBorder;

    ixminBorder := INTEGER(xminBorder);
    ixmaxBorder := INTEGER(xmaxBorder);
    iyminBorder := INTEGER(yminBorder);
    iymaxBorder := INTEGER(ymaxBorder);

    wasp.x := getrndrange(xminBorder,xmaxBorder);
    wasp.y := getrndrange(yminBorder,ymaxBorder);
    LOOP
        wasp.vx := SHORTINT (getrndrangeint(-WaspAcceleration,+WaspAcceleration));
        wasp.vy := SHORTINT (getrndrangeint(-WaspAcceleration,+WaspAcceleration));
        (* IF ((wasp.vx # 0) OR (wasp.vy # 0)) THEN EXIT; END; *)
        EXIT;
    END;

    FOR i := minBEECOUNT TO BeeCount DO
        newbee(i);
    END;
END initWaspAndBees;

PROCEDURE animSwarm (waspcolor,beecolor:BYTE );
VAR
    x,y,i:CARDINAL;
    dx,dy,delta:INTEGER;
BEGIN
    INC ( wasp.vx, SHORTINT (getrndrange(-WaspAcceleration,+WaspAcceleration)) );
    INC ( wasp.vy, SHORTINT (getrndrange(-WaspAcceleration,+WaspAcceleration)) );

    IF wasp.vx > WaspVelocity THEN
        wasp.vx := WaspVelocity;
    ELSIF wasp.vx < -WaspVelocity THEN
        wasp.vx := -WaspVelocity;
    END;
    IF wasp.vy > WaspVelocity THEN
        wasp.vy := WaspVelocity;
    ELSIF wasp.vy < -WaspVelocity THEN
        wasp.vy := -WaspVelocity;
    END;

    INC(wasp.x, INTEGER(wasp.vx));
    INC(wasp.y, INTEGER(wasp.vy));

    IF ( (wasp.x < ixminBorder) OR (wasp.x > ixmaxBorder) ) THEN
        wasp.vx := - wasp.vx;
        INC(wasp.x, INTEGER(wasp.vx));
    END;
    IF ( (wasp.y < iyminBorder) OR (wasp.y > iymaxBorder) ) THEN
        wasp.vy := - wasp.vy;
        INC(wasp.y, INTEGER(wasp.vy));
    END;

    x:=CARDINAL(wasp.x);
    y:=CARDINAL(wasp.y);

    wplot(x,y,waspcolor);

    FOR i := minBEECOUNT TO BeeCount DO
        (* avoid compact swarm *)
        IF getrndrange(minProba,maxProba) < proba THEN
            INC ( bee[i].vx, SHORTINT(getrndrange(-BeeAcceleration,+BeeAcceleration)) );
            INC ( bee[i].vy, SHORTINT(getrndrange(-BeeAcceleration,+BeeAcceleration)) );
        ELSE
            dx := wasp.x - bee[i].x;
            dy := wasp.y - bee[i].y;
            delta := ABS(dx) + ABS(dy); (* approximation *)
            IF delta = 0 THEN INC(delta); END;
            dx := dx * BeeAcceleration;
            dy := dy * BeeAcceleration;
            INC(bee[i].vx, SHORTINT(dx DIV delta) );
            INC(bee[i].vy, SHORTINT(dy DIV delta) );
        END;
        IF bee[i].vx > BeeVelocity THEN
            bee[i].vx := BeeVelocity;
        ELSIF bee[i].vx < -BeeVelocity THEN
            bee[i].vx := -BeeVelocity;
        END;
        IF bee[i].vy > BeeVelocity THEN
            bee[i].vy := BeeVelocity;
        ELSIF bee[i].vy < -BeeVelocity THEN
            bee[i].vy := -BeeVelocity;
        END;

        INC(bee[i].x, INTEGER(bee[i].vx));
        INC(bee[i].y, INTEGER(bee[i].vy));

        IF ( (bee[i].x < ixmin) OR (bee[i].x > ixmax) ) THEN
            bee[i].vx := - bee[i].vx;
            INC(bee[i].x, INTEGER(bee[i].vx));
        END;
        IF ( (bee[i].y < iymin) OR (bee[i].y > iymax) ) THEN
            bee[i].vy := - bee[i].vy;
            INC(bee[i].y, INTEGER(bee[i].vy));
        END;

        x:=CARDINAL(bee[i].x);
        y:=CARDINAL(bee[i].y);
        wplot(x,y,beecolor);

    END;

END animSwarm;

(* ------------------------------------------------------------ *)

CONST
    maxWaitInSeconds = LONGINT(10);
VAR
    parmcount   : CARDINAL;
    i           : CARDINAL;
    opt         : CARDINAL;
    S           : str128;
    R           : str128;
    v           : CARDINAL;

    stopmouse   : BOOLEAN;
    showpal     : BOOLEAN;

    keycode     : CARDINAL;
    singlestep  : BOOLEAN;
    chk         : BOOLEAN;
    clear       : BOOLEAN;
    tmpint      : INTEGER;
BEGIN
    Lib.DisableBreakCheck();
    WrLn;                       (* must be here for pretty ulterior display ! *)

    stopmouse    := FALSE;
    showpal      := FALSE;
    clear        := FALSE;

    initDefaults;

    parmcount := Lib.ParamCount();

    FOR i := 1 TO parmcount DO
        Lib.ParamStr(S,i);
        Str.Copy(R,S); cleantabs(R);
        UpperCase(R);
        IF isOption(R) THEN
            opt := GetOptIndex (R, "?"+delim+"H"+delim+"HELP"+delim+
                                   "A"+delim+"SHOWPAL"+delim+
                                   "Z"+delim+"MOUSE"+delim+
                                   "P:"+delim+"PALETTE:"+delim+
                                   "B:"+delim+
                                   "WA:"+delim+
                                   "WV:"+delim+
                                   "BA:"+delim+
                                   "BV:"+delim+
                                   "WB:"+delim+
                                   "S"+delim+"NOSMOOTH"+delim+
                                   "D:"+delim+"DELAY:"+delim+
                                   "C"+delim+"CLEAR"+delim+
                                   "T:"+delim+"THRESHOLD:"+delim+
                                   "S:"+delim+"SMOOTHROUNDS:"
                               );
            CASE opt OF
            | 1,2,3 :
                abort(errHelp,"");
            | 4,5 :
                showpal := TRUE;
            | 6,7:
                stopmouse:=TRUE;
            | 8,9:
                IF value(R,ORD(firepal),ORD(systempal),v)=FALSE THEN
                    abort(errRange,"palette");
                END;
                palette:=palettetype(v);
            | 10:
                IF value(R,minBEECOUNT,maxBEECOUNT,BeeCount)=FALSE THEN
                    abort(errRange,"number of bees");
                END;
            | 11:
                IF ivalue(R,minWASPACCELERATION,maxWASPACCELERATION,WaspAcceleration)=FALSE THEN
                    abort(errRange,"wasp maximum acceleration");
                END;
            | 12:
                IF ivalue(R,minWASPVELOCITY,maxWASPVELOCITY,tmpint)=FALSE THEN
                    abort(errRange,"wasp maximum velocity");
                END;
                WaspVelocity := SHORTINT(tmpint);
            | 13:
                IF ivalue(R,minBEEACCELERATION,maxBEEACCELERATION,BeeAcceleration)=FALSE THEN
                    abort(errRange,"bee maximum acceleration");
                END;
            | 14:
                IF ivalue(R,minBEEVELOCITY,maxBEEVELOCITY,tmpint)=FALSE THEN
                    abort(errRange,"bee maximum velocity");
                END;
                BeeVelocity := SHORTINT(tmpint);
            | 15:
                IF ivalue(R,minWASPBORDER,maxWASPBORDER,WaspBorder)=FALSE THEN
                    abort(errRange,"wasp minimum distance from border");
                END;
            | 16,17:
                SmoothOn := FALSE;
            | 18,19:
                IF value(R,minDelay,maxDelay,delay)=FALSE THEN
                    abort(errRange,"delay");
                END;
            | 20,21:
                clear := TRUE;
            | 22,23:
                IF value(R,minProba-1,maxProba+1,proba)=FALSE THEN
                    abort(errRange,"probability");
                END;
            | 24,25:
                IF value(R,minSmoothRounds,maxSmoothRounds,SmoothRounds)=FALSE THEN
                    abort(errRange,"smoothing");
                END;
            ELSE
                abort(errUnknownOpt,S);
            END;
        ELSE
            abort(errIllegalParm,S);
        END;
    END;

    doRandomize;

    initYbase;
    NEW(WorkScreen);
    NEW(SmoothScreen);
    NEW(NextWorkScreen);

    setVideoMode(hires);
    newPalette64(palette);
    clearvideoscreen(ndxblack);

    IF showpal THEN
        showPalette(maxWaitInSeconds);
        clearvideoscreen(ndxblack);
    END;

    IF stopmouse THEN
        IF MsMouse.Reset()=MAX(INTEGER) THEN
            stopmouse := FALSE;
        END;
    END;

    flushKeyboard;

    clearworkscreen(ndxblack);
    clearsmoothscreen(ndxblack);
    clearnextworkscreen(ndxblack);

    initWaspAndBees();

    singlestep := FALSE;

    SmoothOn := (SmoothRounds # 0); (* no longer in initDefaults *)

    LOOP
        IF clear THEN clearworkscreen(ndxblack); END;
        IF SmoothOn THEN
            animSwarm(maxcolorindex, maxcolorindex);
            FOR i:=1 TO SmoothRounds DO smooth(); END;
        ELSE
            animSwarm(maxcolorindex, maxcolorindex-16);
            smoothalt();
        END;
        FOR i := 1 TO delay DO waitVGAretrace; END;
        smooth2video;

        (* read and process key *)
        IF singlestep THEN
            WHILE getKeyboardCode(keycode)=FALSE DO
            END;
            chk:=(keycode # keySpace);
            singlestep:=NOT(chk);
        ELSE
            chk:=getKeyboardCode(keycode);
        END;
        IF chk THEN
            CASE keycode OF
            | lowerR        : newPalette64(firepal);
            | upperR        : newPalette64(rpal);
            | upperG,lowerG : newPalette64(gpal);
            | upperB,lowerB : newPalette64(bpal);
            | keydollar     : newPalette64(rainbowpal);
            | keyStar       : newPalette64(randompal);
            | keyDivide     : newPalette64(rndpal);
            | key1          : newPalette64(palrouge);
            | key2          : newPalette64(palvert);
            | key3          : newPalette64(palbleu);
            | key0          : newPalette64(palgris);
            | keySpace      : singlestep:=NOT (singlestep);
            | keyEscape     : EXIT;
            | keyCR         : EXIT;
            | upperS,lowerS : SmoothOn:=NOT(SmoothOn);
            | upperC,lowerC : clear:=NOT(clear);
            | keyPageUp     : FOR i:=1 TO beestep DO
                                  IF BeeCount < maxBEECOUNT THEN
                                      INC(BeeCount);
                                      newbee(BeeCount);
                                  END;
                              END;
            | keyPageDn     : FOR i:=1 TO beestep DO
                                  IF BeeCount > minBEECOUNT THEN DEC(BeeCount);END;
                              END;
            | keyLeft       : FOR i:=1 TO beestepstep DO
                                  IF beestep > minbeestep THEN DEC(beestep);END;
                              END;
            | keyRight      : FOR i:= 1 TO beestepstep DO
                                  IF beestep < maxbeestep THEN INC(beestep);END;
                              END;
            | keyHome  : IF proba < (maxProba+1) THEN INC(proba);END;
            | keyEnd :   IF proba > (minProba-1) THEN DEC(proba);END;
            END;
        END;
        IF stopmouse THEN
            IF mouseclick() THEN EXIT; END;
        END;
    END;
    setVideoMode(text);

    CASE BeeCount OF
    | 1..9:       i:=1;
    | 10..99:     i:=2;
    | 100..999:   i:=3;
    | 1000..9999: i:=4;
    ELSE          i:=5;
    END;
    IO.WrCard(BeeCount,i);WrStr(" bees"); WrLn;

    abort(errNone,"");
END FireBees.
