
(* --------------------------------------------------------------
Title         Q&D Particles Fire demo
Author        PhG
Overview      tsk tsk...
Usage         see help
Notes         
              minimal error messages and checking, etc.
              model should definitely be LARGE
Bugs          as for Storm, annoying click when looping
              well, has to do with autoinitialize mode (1CH),
              but probably not worth the trouble (split buffer, isr, etc.)

Wish List     tsk tsk...

--------------------------------------------------------------- *)

MODULE Fire;

IMPORT Lib;
IMPORT SYSTEM;
IMPORT IO;
IMPORT Str;
IMPORT BiosIO;
IMPORT MATHLIB;
IMPORT MsMouse;
IMPORT FIO;
IMPORT Storage;

FROM IO IMPORT WrStr, WrLn, WrHex, WrShtHex, WrCard, WrLngCard;

FROM QD_Box IMPORT str80, str2, cmdInit, cmdShow, cmdStop, delim,
Work, video, Ltrim, Rtrim, UpperCase, LowerCase, ReplaceChar,
ChkEscape, Waitkey, WaitkeyDelay, Flushkey, IsRedirected, chkJoker,
isOption, GetOptIndex, GetLongCard, GetLongInt, GetString, CharCount,
same, aR, aH, aS, aD, aA, everything, isDirectory, fixDirectory,
str128, str256, Animation, allfiles, Belongs, FixAE, CodePhonetic,
CodeSoundex, CodeSoundexOrg, isReadOnly, LtrimBlanks, RtrimBlanks,
getStrIndex, cmdSHOW,BiosWaitkey,BiosWaitkeyShifted,BiosFlushkey,
str1024, isoleItemS, dmpTTX, str2048, Elapsed, TerminalReadString,
getDosVersion, DosVersion, warning95, runningWindows,
aV, reallyeverything, chkClassicTextMode, setClassicTextMode;

FROM Lib IMPORT FarFill,FarWordMove;
FROM Storage IMPORT ALLOCATE;
FROM SYSTEM IMPORT In,Out;

(* ------------------------------------------------------------ *)
(* ------------------------------------------------------------ *)

CONST
    TSRAND        = TRUE; (* TRUE = M2 random generator, FALSE = homemade *)
CONST
    DEBUG         = FALSE;
    sbpro         = TRUE;  (* assume (old) modern card ! *)
    wavBackground = "FIRE.WAV";

CONST
    ProgEXEname   = "FIRE";
    ProgTitle     = "Q&D Particles Fire demo";
    ProgVersion   = "v1.0c";
    ProgCopyright = "by PhG";
    Banner        = ProgTitle+" "+ProgVersion+" "+ProgCopyright;

CONST
    errNone           = 0;
    errHelp           = 1;
    errIllegalParm    = 2;
    errUnknownOpt     = 3;
    errRange          = 4;
    errNeedBoth       = 5;
    errMissingRounds  = 6;
    errNotFound       = 7;
    errSB             = 8;
    errWav            = 9;
    err64K            = 10;
    errAllocate       = 11;

PROCEDURE abort (e : CARDINAL; einfo : ARRAY OF CHAR);
CONST
    cr         = CHR(13);
    lf         = CHR(10);
    nl         = cr+lf;
CONST
    (*
     00000000011111111112222222222333333333344444444445555555555666666666677777777778
     1...'....0....'....0....'....0....'....0....'....0....'....0....'....0....'....0
    *)
    helpmsg =
    Banner+nl+
    nl+
    "Syntax : "+ProgEXEname+" [option]..."+nl+
    nl+
    "  -a    show palette until keypress or 10 seconds"+nl+
    "  -z    end on mouseclick too"+nl+
    "  -p:#  color palette (0..3=rRGB1230, 8=system palette, default is 0)"+nl+
    "  -n:#  number of particles (500..30000, default is 15000)"+nl+
    "  -c    coarser resolution"+nl+
    "  -l:#  lower number of particles"+nl+
    "  -u:#  upper number of particles"+nl+
    "  -r:#  rounds (1..1000)"+nl+
    "  -w:# wind effect (0..10, default is 0)"+nl+
    "  -d    enable double buffering"+nl+
    "  -s    SoundBlaster sound (experimental :  feature !)"+nl+
    nl+
(*%T sbpro *)
    "  Sound requires a SoundBlaster Pro (or compatible) board !"+nl+
(*%E *)
(*%F sbpro *)
    "    Sound requires a SoundBlaster (or compatible) board !"+nl+
(*%E  *)
    nl+
    "[rRGB1230]-palette, [c]-coarseness, [d]-buffering, [Left|Right]-wind"+nl+
    "[PageUp|PageDown|Home|End]-particles, [Space]-pause, [Escape|Enter]-end"+nl;
VAR
    S : str256;
BEGIN
    CASE e OF
    | errHelp :
        WrStr(helpmsg);
    | errIllegalParm :
        Str.Concat(S,"Illegal ",einfo); Str.Append(S," parameter !");
    | errUnknownOpt :
        Str.Concat(S,"Unknown ",einfo); Str.Append(S," option !");
    | errRange :
        Str.Concat(S,"Value for ",einfo);
        Str.Append(S," not in legal range !");
    | errNeedBoth:
        S := "Both lower and upper numbers of particles are needed !";
    | errMissingRounds:
        S := "Number of rounds is needed !";
    | errNotFound :
        Str.Concat(S,einfo," does not exist !");
    | errSB :
        Str.Concat(S,einfo," !");
    | errWav :
        Str.Concat(S,einfo," !");
    | err64K :
        Str.Concat(S,einfo," data would take more than 64 KB !");
    | errAllocate:
        Str.Concat(S,"ALLOCATE() failed loading ",einfo);
        Str.Append(S," !");
    ELSE
        S := "This is illogical, Captain !";
    END;
    CASE e OF
    | errNone,errHelp :
        (* nada *)
    ELSE
        WrStr(ProgEXEname+" : ");
        WrStr(S);
        WrLn;
    END;
    Lib.SetReturnCode(SHORTCARD(e));
    HALT;
END abort;

(* ------------------------------------------------------------ *)
(* ------------------------------------------------------------ *)

PROCEDURE makebase (VAR basepath:ARRAY OF CHAR);
VAR
    u,d,n,e:str128;
BEGIN
    Lib.ParamStr(basepath,0);
    Lib.SplitAllPath(basepath,u,d,n,e);
    Str.Concat(basepath,u,d);
END makebase;

PROCEDURE chkSizeLessThan64K ( S:ARRAY OF CHAR ):BOOLEAN;
VAR
    hnd:FIO.File;
    n:LONGCARD;
BEGIN
    hnd:=FIO.OpenRead(S);
    n:=FIO.Size(hnd);
    FIO.Close(hnd);
    RETURN (n < MAX(CARDINAL)-1);  (* -1 is... added safety *)
END chkSizeLessThan64K;

TYPE
    wavPtrType = POINTER TO BYTE; (* fake pointer to a buffer *)

(* assume size is < 64 Kb ! *)

PROCEDURE loadfile (S:ARRAY OF CHAR;headerlen,len:LONGCARD;VAR ptr:wavPtrType):BOOLEAN;
VAR
    needed:CARDINAL;
    hnd:FIO.File;
    n:CARDINAL;
BEGIN
    needed:=CARDINAL(len);
    IF Storage.Available (needed)=FALSE THEN RETURN FALSE; END;
    Storage.ALLOCATE(ptr,needed);
    hnd:=FIO.OpenRead(S);
    FIO.Seek(hnd,headerlen);
    n := FIO.RdBin(hnd,ptr^,needed);
    FIO.Close(hnd);
    RETURN TRUE;
END loadfile;

(* ------------------------------------------------------------ *)

CONST
    addrSBmixerindex  = 04H;
    addrSBmixervalue  = 05H;
    addrSBreset       = 06H;
    addrSBread        = 0AH;
    addrSBwrite       = 0CH;
    addrSBavailable   = 0EH;
    varBLASTER        = "BLASTER";
VAR
    SBaddr      : CARDINAL;
    SBdma       : CARDINAL;
VAR
    DSPWrite      : CARDINAL;
    DSPmixerIndex : CARDINAL;
    DSPmixerValue : CARDINAL;
    DSPReset      : CARDINAL;
    DSPRead       : CARDINAL;
    DSPAvailable  : CARDINAL;
VAR
    regaddr,regcount,regpage,regmask,regmode,regclear,regstatus:CARDINAL;
    terminal:SHORTCARD;
VAR (* infos from wav header *)
    lenheader:LONGCARD;
    fmt,channels,sampling,bytespersec,frequency : CARDINAL;
    datalen:LONGCARD;

(* ------------------------------------------------------------ *)

(* all use global variable SBaddr as base address *)

PROCEDURE WriteToDSP ( v : SHORTCARD);
BEGIN
    WHILE (In(DSPWrite) AND SHORTCARD(80H)) # SHORTCARD(00H) DO (* till bit 7 = 0 *)
    END;
    Out(DSPWrite,v);
END WriteToDSP;

PROCEDURE WriteDAC ( v:SHORTCARD);
BEGIN
    WriteToDSP (10H); (* direct mode to DAC *)
    WriteToDSP (v);   (* 8-bit sample *)
END WriteDAC;

PROCEDURE SBCardSpeakerOn();
BEGIN
    WriteToDSP (0D1H);
END SBCardSpeakerOn;

PROCEDURE SBCardSpeakerOff();
BEGIN
    WriteToDSP (0D3H);
END SBCardSpeakerOff;

PROCEDURE DMAstop (  );
BEGIN
    WriteToDSP (0D0H);
END DMAstop;

PROCEDURE DMAcontinue ();
BEGIN
    WriteToDSP (0D4H);
END DMAcontinue;


PROCEDURE SBCardReset (  ):BOOLEAN;
BEGIN
    Out (DSPReset,1);
    Lib.Delay(150); (* 0.15 second, 3 micro seconds needed but longer just to be safe *)
    Out (DSPReset,0);
    Lib.Delay(150);

    WHILE (In(DSPAvailable) AND SHORTCARD(80H)) # SHORTCARD(80H) DO (* till bit 7 = 1 *)
    END;

    RETURN ( In(DSPRead) = 0AAH );
END SBCardReset;

(* use globerk *)

PROCEDURE dmaregisters();
BEGIN
CASE SBdma OF
| 0 : regaddr:= 000H ; regcount:= 001H ; regpage:= 087H;
| 1 : regaddr:= 002H ; regcount:= 003H ; regpage:= 083H;
| 2 : regaddr:= 004H ; regcount:= 005H ; regpage:= 081H;
| 3 : regaddr:= 006H ; regcount:= 007H ; regpage:= 082H;
| 4 : regaddr:= 0C0H ; regcount:= 0C2H ; regpage:= 08FH;
| 5 : regaddr:= 0C4H ; regcount:= 0C6H ; regpage:= 08BH;
| 6 : regaddr:= 0C8H ; regcount:= 0CAH ; regpage:= 089H;
| 7 : regaddr:= 0CCH ; regcount:= 0CEH ; regpage:= 08AH;
END;
CASE SBdma OF
| 0,1,2,3 : regmask:= 00AH ; regmode:= 00BH ; regclear:= 00CH ; regstatus:= 008H;
| 4,5,6,7 : regmask:= 0D4H ; regmode:= 0D6H ; regclear:= 0D8H ; regstatus:= 0D0H;
END;
CASE SBdma OF
| 0,4 : terminal:= 001H;
| 1,5 : terminal:= 002H;
| 2,6 : terminal:= 004H;
| 3,7 : terminal:= 008H;
END;
END dmaregisters;

PROCEDURE GoPlayback (buffer:wavPtrType; bufferlen:LONGCARD;
                      channels,frequency:CARDINAL);
VAR
    size:CARDINAL;
    losize,hisize,loaddr,hiaddr,stringpageaddr:SHORTCARD;
    segment,offset,stringaddrword:CARDINAL;
    stringaddr : LONGCARD;
    timeconstant:SHORTCARD;
    dummy:SHORTCARD;
BEGIN
    size   := CARDINAL(bufferlen)-1;
    losize := SHORTCARD(size MOD 256);
    hisize := SHORTCARD(size DIV 256);
    segment        := Seg(buffer^);
    offset         := Ofs(buffer^);
    stringaddr     := 16*LONGCARD(segment)+LONGCARD(offset);
    stringpageaddr := SHORTCARD(stringaddr DIV 65536);
    stringaddrword := CARDINAL(stringaddr MOD 65536);
    loaddr         := SHORTCARD(stringaddrword MOD 256);
    hiaddr         := SHORTCARD(stringaddrword DIV 256);

    Out(regmask,(SHORTCARD(04H) + SHORTCARD(SBdma MOD 4))); (* cmd=set channel before programming it *)
    Out(regclear,00H);                       (* reset internal pointers *)
    Out(regmode,(SHORTCARD(48H) + SHORTCARD(SBdma MOD 4))); (* set mode to read & signal *)
    Out(regaddr, loaddr);         (* bits 0-7 of the 20bit address *)
    Out(regaddr, hiaddr);         (* bits 8-15 of the 20bit address *)
    Out(regpage, stringpageaddr); (* bits 16-19 of the 20bit address *)
    Out(regcount, losize);        (* bits 0-7 of size *)
    Out(regcount, hisize);        (* bits 8-16 of size *)
    Out(regmask,(SHORTCARD(00H) + SHORTCARD(SBdma MOD 4))); (* cmd=enable channel *)

    (* init DAC here *)
    (* set playback frequency *)
    timeconstant := 256 - SHORTCARD( 1000000 DIV LONGCARD(frequency)); (* force longcard for correct result *)

    WriteToDSP (40H);
    WriteToDSP (timeconstant);

    (*%T sbpro *)  (* BEGIN specific to SBpro *)
    Out(DSPmixerIndex,00H); (* reset mixer chip before changes *)
    Out(DSPmixerValue,00H);
    CASE channels OF
    | 1 :
        Out(DSPmixerIndex,0EH);
        Out(DSPmixerValue,SHORTCARD(00H)); (* bypass O/P filter and mono *)
    | 2 :
        Out(DSPmixerIndex,0EH);
        Out(DSPmixerValue,SHORTCARD(02H)); (* stereo *)
    END;
    (*%E  *) (* END specific to SBpro *)

    (* set playback type (only 8-bit DAC for now) *)
    WriteToDSP (14H);
    (* write lsb and msb of datalength-1 *)
    WriteToDSP (losize);
    WriteToDSP (hisize);
    (* make sure DMA is going *)
    dummy:=In(regstatus);
END GoPlayback;

PROCEDURE PlaybackDone():BOOLEAN;
VAR
    dummy:SHORTCARD;
BEGIN
    (* loop until terminal count bit set to 1 *)
    IF (In(regstatus) AND terminal) = terminal THEN (* wait till terminal count bit 7=1 *)
	(* acknowledge the DSP interrupt by reading the DATA AVAILABLE port once *)
	dummy:=In (DSPAvailable);
	(* send EOI to the interrupt controller port 20h just in case *)
	Out (020H, 020H);
	RETURN TRUE;
    ELSE
	RETURN FALSE;
    END;
END PlaybackDone;

(* ------------------------------------------------------------ *)

PROCEDURE BlasterHere (  ):BOOLEAN;
VAR
    S : str128;
BEGIN
    Lib.EnvironmentFind(varBLASTER,S);
    RETURN NOT(same(S,""));
END BlasterHere;

PROCEDURE goodBlasterAddress (VAR addr:CARDINAL):BOOLEAN;
VAR
    S,R : str128;
    p : CARDINAL;
    v : LONGCARD;
    ok:BOOLEAN;
BEGIN
    Lib.EnvironmentFind(varBLASTER,S);
    Str.Caps(S);
    p:=Str.CharPos(S,"A");
    IF p = MAX(CARDINAL) THEN RETURN FALSE; END;
    Str.Delete(S,0,p+1);
    isoleItemS(R,S," ",0);
    v:=Str.StrToCard(R,16,ok);
    IF ok=FALSE THEN RETURN FALSE;END;
    IF v > MAX(CARDINAL) THEN RETURN FALSE;END;
    addr:=CARDINAL(v);
    CASE addr OF
    | 220H,240H,260H,280H: (* only valid addresses $02x0 where x=2,4,6,8 *)
        RETURN TRUE;
    ELSE
        RETURN FALSE;
    END;
END goodBlasterAddress;

PROCEDURE goodBlasterDMA (VAR dma:CARDINAL ):BOOLEAN;
VAR
    S,R : str128;
    p : CARDINAL;
    v : LONGCARD;
    ok:BOOLEAN;
BEGIN
    Lib.EnvironmentFind(varBLASTER,S);
    Str.Caps(S);
    p:=Str.CharPos(S,"D");
    IF p = MAX(CARDINAL) THEN RETURN FALSE; END;
    Str.Delete(S,0,p+1);
    isoleItemS(R,S," ",0);
    v:=Str.StrToCard(R,10,ok);
    IF ok=FALSE THEN RETURN FALSE;END;
    IF v > MAX(CARDINAL) THEN RETURN FALSE;END;
    dma:=CARDINAL(v);
    CASE dma OF
    | 0,1,3: (* dma 8 bits is 0,1,3 *)
        RETURN TRUE;
    ELSE
        RETURN FALSE;
    END;
END goodBlasterDMA;

PROCEDURE chkBlaster (VAR errormsg:ARRAY OF CHAR):BOOLEAN;
BEGIN
    Str.Copy(errormsg,"BLASTER environment variable not set");
    IF BlasterHere()=FALSE THEN RETURN FALSE; END;
    Str.Copy(errormsg,"Bad BLASTER address");
    IF goodBlasterAddress(SBaddr)=FALSE THEN RETURN FALSE; END;
    Str.Copy(errormsg,"Bad BLASTER DMA value");
    IF goodBlasterDMA(SBdma)=FALSE THEN RETURN FALSE; END;

    DSPWrite     := SBaddr + addrSBwrite;
    DSPReset     := SBaddr + addrSBreset;
    DSPRead      := SBaddr + addrSBread;
    DSPAvailable := SBaddr + addrSBavailable;
    DSPmixerIndex:= SBaddr + addrSBmixerindex;
    DSPmixerValue:= SBaddr + addrSBmixervalue;
    (* init DMA register addresses here *)
    dmaregisters();

(*%T DEBUG *)
WrStr("SoundBlaster address : ");WrHex(SBaddr,4);WrLn;
WrStr("SoundBlaster DMA     : ");WrHex(SBdma,4);WrLn;
WrStr("DSPWrite             : ");WrHex(DSPWrite,4);WrLn;
WrStr("DSPReset             : ");WrHex(DSPReset,4);WrLn;
WrStr("DSPRead              : ");WrHex(DSPRead,4);WrLn;
WrStr("DSPAvailable         : ");WrHex(DSPAvailable,4);WrLn;
WrStr("DSPmixerIndex        : ");WrHex(DSPmixerIndex,4);WrLn;
WrStr("DSPmixerValue        : ");WrHex(DSPmixerValue,4);WrLn;
WrLn;
WrStr("regaddr              : ");WrHex(regaddr,4);WrLn;
WrStr("regcount             : ");WrHex(regcount,4);WrLn;
WrStr("regpage              : ");WrHex(regpage,4);WrLn;
WrStr("regmask              : ");WrHex(regmask ,4);WrLn;
WrStr("regmode              : ");WrHex(regmode ,4);WrLn;
WrStr("regclear             : ");WrHex(regclear,4);WrLn;
WrStr("regstatus            : ");WrHex(regstatus   ,4);WrLn;
WrStr("terminal             : ");WrShtHex(terminal     ,4);WrLn;
WrLn;
(*%E  *)

(*%T sbpro *)
    Str.Copy(errormsg,"SoundBlaster Pro card would not reset");
(*%E  *)
(*%F sbpro *)
    Str.Copy(errormsg,"SoundBlaster card would not reset");
(*%E  *)

    RETURN SBCardReset();
END chkBlaster;

TYPE WavHeaderType = RECORD
    rID               : ARRAY [0..3] OF CHAR; (* "RIFF" *)
    rLen              : LONGCARD;             (* length of data chunk *)
    wID               : ARRAY [0..3] OF CHAR; (* "WAVE" *)
    fID               : ARRAY [0..3] OF CHAR; (* "fmt " *)
    fLen              : LONGCARD;
    wFormatTag        : CARDINAL;             (* 1 = pcm, ... *)
    nChannels         : CARDINAL;             (* 1=mono 2 = stereo *)
    nSamplesPerSec    : CARDINAL;             (* playback frequency *)
    unknown1          : CARDINAL;
    nAvgBytesPerSec   : CARDINAL;             (* average bytes / second data should be sent at *)
                                              (* nchannels * nSamplesPerSec * (nbitspersample/8) *)
    unknown2          : CARDINAL;
    nBlockAlign       : CARDINAL;             (* nchannels * (nbitspersample/8) *)
    FormatSpecific    : CARDINAL;
    dID               : ARRAY [0..3] OF CHAR; (* "data" *)
    dLen              : LONGCARD;             (* length of actual data *)
END;

PROCEDURE chkWavHeader (S:ARRAY OF CHAR;VAR errormsg:ARRAY OF CHAR):BOOLEAN;
VAR
    header : WavHeaderType;
    hnd:FIO.File;
    n:CARDINAL;
    filelen:LONGCARD;
BEGIN
    hnd:=FIO.OpenRead(S);
    n:=FIO.RdBin(hnd,header,SIZE(header));
    filelen:=FIO.Size(hnd);
    FIO.Close(hnd);

    lenheader  :=SIZE(header)+header.fLen-16 ; (* kludgy but works! ;-) normal is 16 *)
    fmt        :=header.wFormatTag;
    channels   :=header.nChannels;
    sampling   :=header.nSamplesPerSec;
    bytespersec:=header.nAvgBytesPerSec;

    frequency  :=bytespersec; (* do not feed with sampling?? !!! *)

    datalen    := filelen - lenheader;
(*%T DEBUG *)
WrStr("File               : ");WrStr(S);WrLn;
WrStr("Format             : ");WrCard(fmt,8);WrLn;
WrStr("Channels           : ");WrCard(channels,8);WrLn;
WrStr("Playback frequency : ");WrCard(sampling,8);WrLn;
WrStr("Bytes per second   : ");WrCard(bytespersec,8);WrLn;
WrStr("File length        : ");WrLngCard(filelen,8);WrLn;
WrStr("Header length      : ");WrLngCard(lenheader,8);WrLn;
WrStr("Data length        : ");WrLngCard(datalen,8);WrLn;
WrLn;
(*%E *)
    Str.Concat(errormsg,"Bad header for ",S);
    Str.Caps(header.rID);
    IF same (header.rID,"RIFF")=FALSE THEN RETURN FALSE; END;
    Str.Caps(header.wID);
    IF same (header.wID,"WAVE")=FALSE THEN RETURN FALSE; END;
    Str.Caps(header.fID);
    IF same (header.fID,"FMT ")=FALSE THEN RETURN FALSE; END;
(*%F sbpro  *)
    Str.Concat(errormsg,"Unsupported stereo data for ",S);
    IF channels # 1 THEN RETURN FALSE; END;
(*%E  *)
    Str.Concat(errormsg,"Unsupported WAV format for ",S);
    RETURN (fmt=1);
END chkWavHeader;

(* ------------------------------------------------------------ *)
(* ------------------------------------------------------------ *)

(*%T TSRAND *)

PROCEDURE doRandomize (  );
BEGIN
    Lib.RANDOMIZE;
END doRandomize;

PROCEDURE getrndrange (lower,upper:CARDINAL):CARDINAL;
VAR
    range : CARDINAL;
    rnd   : REAL;
BEGIN
    range := upper-lower+1;
    rnd := (REAL(range) * Lib.RAND()) + REAL(lower);
    RETURN CARDINAL(rnd);
END getrndrange;

PROCEDURE getrndrangeint (lower,upper:INTEGER):INTEGER;
VAR
    range : INTEGER;
    rnd   : REAL;
BEGIN
    range := upper-lower+1;
    rnd := (REAL(range) * Lib.RAND()) + REAL(lower);
    RETURN INTEGER(rnd);
END getrndrangeint;

(*%E  *)

(* ------------------------------------------------------------ *)

(*%F TSRAND *)

MODULE alea;
IMPORT Lib;
EXPORT doRandomize,getrndrange;

PROCEDURE XOR (b1,b2 : CARDINAL) : CARDINAL;
BEGIN
    RETURN CARDINAL ( (BITSET (b1) / BITSET (b2)) );
END XOR;

VAR
    seed : INTEGER;

PROCEDURE doRandomize (  );
VAR
    biosTimerTicksSinceMidnightLo [0040H:006CH] : CARDINAL; (* lohi=dword *)
    biosTimerTicksSinceMidnightHi [0040H:006EH] : CARDINAL;
    h,m,s,ss:CARDINAL;
BEGIN
    Lib.GetTime(h,m,s,ss);
    seed := XOR(biosTimerTicksSinceMidnightLo, s);
END doRandomize;

PROCEDURE getrndint ():INTEGER ;
BEGIN
    seed := (seed * 259 + 3) AND 32767;
    RETURN seed; (* [0..32767] *)
END getrndint;

PROCEDURE getrndrange (lower,upper:CARDINAL):CARDINAL;
VAR
    range : CARDINAL;
    v     : CARDINAL;
BEGIN
    range := upper-lower+1;
    v := lower + ( CARDINAL (getrndint()) MOD range );
    RETURN v;
END getrndrange;

PROCEDURE getrndrangeint (lower,upper:INTEGER):INTEGER;
VAR
    range : INTEGER;
    v     : INTEGER;
BEGIN
    range := upper-lower+1;
    v := lower + ( getrndint() MOD range );
    RETURN v;
END getrndrangeint;

END alea;

(*%E *)

(* ------------------------------------------------------------ *)
(* ------------------------------------------------------------ *)

PROCEDURE flushKeyboard (  );
VAR
    c : CHAR;
BEGIN
    LOOP
        IF BiosIO.KeyPressed()=FALSE THEN EXIT; END;
        c := BiosIO.RdKey();
        IF c = CHR(0) THEN c := BiosIO.RdKey(); END;
    END;
END flushKeyboard;

PROCEDURE getKeyboardCode (VAR keycode:CARDINAL):BOOLEAN;
VAR
    c1,c2:CHAR;
BEGIN
    IF BiosIO.KeyPressed()=FALSE THEN RETURN FALSE; END;
    c1 := BiosIO.RdKey();
    IF c1 = CHR(0) THEN
        c2 := BiosIO.RdKey();
    ELSE
        c2 := CHR(0);
    END;
    keycode := (ORD(c1) << 8) + ORD(c2);
    RETURN TRUE;
END getKeyboardCode;

PROCEDURE input (maxWait:LONGINT); (* in seconds *)
VAR
    keycode:CARDINAL;
    h,m,s,ss:CARDINAL;
    start : LONGINT;
    now   : LONGINT;
BEGIN
    Lib.GetTime(h,m,s,ss);
    start := (LONGINT(h)*60+LONGINT(m))*60+LONGINT(s);
    LOOP
        IF getKeyboardCode(keycode) THEN EXIT; END;
        Lib.GetTime(h,m,s,ss);
        now := (LONGINT(h)*60+LONGINT(m))*60+LONGINT(s);
        IF ABS(now-start) > maxWait THEN EXIT; END;
    END;
END input;

PROCEDURE mouseclick (  ):BOOLEAN;
VAR
    msdata:MsMouse.MsData;
BEGIN
    MsMouse.GetStatus(msdata);
    IF msdata.left_pressed THEN RETURN TRUE; END;
    IF msdata.right_pressed THEN RETURN TRUE; END;
    RETURN msdata.middle_pressed;
END mouseclick;

(* ------------------------------------------------------------ *)
(* ------------------------------------------------------------ *)

CONST
    hires       = 13H; (* 320x200x256 *)
    text        = 03H; (* 80x25 *)
    xcount      = 320;
    ycount      = 200;
    xmin        = 0;
    xmax        = xcount-1;
    ymin        = 0;
    ymax        = ycount-1;
    cx          = xcount DIV 2;
    screensize  = xcount * ycount;
    screensizeW =(screensize DIV 2);
    k           = 2;
    kr          = k+1; (* when creating random[x-k,x+k], use x+kr TO avoid wind from right unwanted artefact *)
    xcountX2    = xcount * k;
TYPE
    screenType = ARRAY [0..screensize-1 +1+xcount] OF BYTE;   (* 320x200=64000 with security *)
VAR
    WorkScreen    : POINTER TO screenType;
    SmoothScreen  : POINTER TO screenType;
    NextWorkScreen: POINTER TO screenType;
VAR
    videoscreen [0A000H:0000H] : ARRAY [0..screensize-1] OF BYTE;
    Ybase                      : ARRAY [ymin..ymax] OF CARDINAL;
(* ------------------------------------------------------------ *)

PROCEDURE initYbase ();
VAR
    i,p:CARDINAL;
BEGIN
    p := 0;
    FOR i := ymin TO ymax DO
        Ybase[i]:=p;
        INC(p,xcount);
    END;
END initYbase;

PROCEDURE setVideoMode (mode:CARDINAL);
VAR
    R : SYSTEM.Registers;
BEGIN
    R.AH := 00H;
    R.AL := BYTE(mode);
    Lib.Intr(R,10H);
END setVideoMode;

PROCEDURE waitVGAretrace ();
BEGIN
    WHILE (SYSTEM.In(03DAH) AND 08H) # 0 DO
    END;
    WHILE (SYSTEM.In(03DAH) AND 08H) = 0 DO
    END;
END waitVGAretrace;

PROCEDURE clearvideoscreen (inkndx:CARDINAL);
BEGIN
    Lib.FarWordFill(FarADR(videoscreen[0]),screensizeW,(inkndx << 8 + inkndx));
END clearvideoscreen;

PROCEDURE clearworkscreen(inkndx:CARDINAL );
BEGIN
    Lib.FarWordFill(FarADR(WorkScreen^),screensizeW,(inkndx << 8 + inkndx));
END clearworkscreen;

PROCEDURE clearsmoothscreen(inkndx:CARDINAL);
BEGIN
    Lib.FarWordFill(FarADR(SmoothScreen^),screensizeW,(inkndx << 8 + inkndx));
END clearsmoothscreen;

PROCEDURE smooth2video();
BEGIN
    waitVGAretrace;
    FarWordMove(FarADR(SmoothScreen^),FarADR(videoscreen[0]),screensizeW);
END smooth2video;

PROCEDURE work2video();
BEGIN
    waitVGAretrace;
    FarWordMove(FarADR(WorkScreen^),FarADR(videoscreen[0]),screensizeW);
END work2video;

PROCEDURE wplot (x,y:CARDINAL;ink:BYTE);
BEGIN
    WorkScreen^[Ybase[y]+x]:=ink;
END wplot;

PROCEDURE splot (x,y:CARDINAL;ink:BYTE);
BEGIN
    SmoothScreen^[Ybase[y]+x]:=ink;
END splot;

PROCEDURE clearnextworkscreen(inkndx:CARDINAL);
BEGIN
    Lib.FarWordFill(FarADR(NextWorkScreen^),screensizeW,(inkndx << 8 + inkndx));
END clearnextworkscreen;

PROCEDURE nextworkscreen2workscreen ();
BEGIN
    FarWordMove(FarADR(NextWorkScreen^),FarADR(WorkScreen^),screensizeW);
END nextworkscreen2workscreen;

(* ------------------------------------------------------------ *)

CONST
    black       = LONGCARD(0000000H);
    white       = LONGCARD(03F3F3FH); (* ega/vga range is $00..$3F *)
    red         = LONGCARD(03F0000H);
    green       = LONGCARD(0003F00H);
    darkgreen   = LONGCARD(0002000H);
    blue        = LONGCARD(000003FH);
    darkblue    = LONGCARD(0000020H);
    cyan        = LONGCARD(0002F3FH);
    yellow      = LONGCARD(03F3F00H);
    darkred     = LONGCARD(0200000H);
    orange      = LONGCARD(02F2F00H);
CONST
    egarange    = 40H;
    mininkindex = 0;
    maxinkindex = 256-1;
    ndxblack    = mininkindex;
    maxcolorindex=egarange-1; (* we use 64 colors palette here *)

PROCEDURE setDAC(index:CARDINAL;red,green,blue:BYTE);
CONST
    DACWriteIndex  = 03C8H;
    DACDataRegister= 03C9H;
BEGIN
    SYSTEM.Out (DACWriteIndex,SHORTCARD(index));
    SYSTEM.Out (DACDataRegister, red);
    SYSTEM.Out (DACDataRegister, green);
    SYSTEM.Out (DACDataRegister, blue);
END setDAC;

PROCEDURE readDACrgb (index:CARDINAL):LONGCARD;
CONST
    DACReadIndex   = 03C7H;
    DACDataRegister= 03C9H;
VAR
    r,g,b:SHORTCARD;
    rgb : LONGCARD;
BEGIN
    SYSTEM.Out (DACReadIndex,SHORTCARD(index));
    r:=SYSTEM.In (DACDataRegister);
    g:=SYSTEM.In (DACDataRegister);
    b:=SYSTEM.In (DACDataRegister);
    rgb := (LONGCARD(r) << 16) + (LONGCARD(g) << 8) + LONGCARD(b);
    RETURN rgb;
END readDACrgb;

PROCEDURE resetdac (index,red,green,blue:CARDINAL);
BEGIN
    setDAC(index,BYTE(red),BYTE(green),BYTE(blue));
END resetdac;

PROCEDURE blend (ndx,count:CARDINAL; startink, endink:LONGCARD);
CONST
    rshift = LONGCARD(16);
    gshift = LONGCARD(8);
VAR
    r1,g1,b1:INTEGER;
    r2,g2,b2:INTEGER;
    r,g,b:INTEGER;
    i : CARDINAL;
BEGIN
    IF count=0 THEN count := 1; END; (* safety to avoid division by 0 ! *)

    r1 := INTEGER (startink >> rshift) MOD egarange;
    g1 := INTEGER (startink >> gshift) MOD egarange;
    b1 := INTEGER (startink          ) MOD egarange;
    r2 := INTEGER (endink   >> rshift) MOD egarange;
    g2 := INTEGER (endink   >> gshift) MOD egarange;
    b2 := INTEGER (endink            ) MOD egarange;

    FOR i := 1 TO count DO
        r := r1 + ((r2 - r1) * INTEGER(i) ) DIV INTEGER(count);
        g := g1 + ((g2 - g1) * INTEGER(i) ) DIV INTEGER(count);
        b := b1 + ((b2 - b1) * INTEGER(i) ) DIV INTEGER(count);
        IF r < 0 THEN r:=0; END;
        IF g < 0 THEN g:=0; END;
        IF b < 0 THEN b:=0; END;
        IF r >= egarange THEN r:=egarange-1; END;
        IF g >= egarange THEN g:=egarange-1; END;
        IF b >= egarange THEN b:=egarange-1; END;
        setDAC(ndx+i-1,BYTE(r),BYTE(g),BYTE(b));
    END;
END blend;

PROCEDURE normalize (VAR lc:LONGCARD);
VAR
    r,g,b:CARDINAL;
BEGIN
    r := CARDINAL(lc MOD 100H);
    g := CARDINAL(lc DIV 100H) MOD 100H;
    b := CARDINAL(lc DIV 10000H);
    r := r >> 2; (* MOD egarange; *)
    g := g >> 2;
    b := b >> 2;
    lc := LONGCARD(b) << 16 + LONGCARD(g) << 8 + LONGCARD(r);
END normalize;

TYPE
    fixedpal64type = ARRAY [0..64*3-1] OF BYTE;
CONST
    fixedfirepal = fixedpal64type(
     0, 0, 0,
     1, 0, 0,
     2, 0, 0,
    10, 0, 0,
    18, 0, 0,
    26, 0, 0,
    32, 0, 0,
    36, 0, 0,
    39, 0, 0,
    42, 0, 0,
    46, 1, 0,
    50, 3, 0,
    54, 5, 0,
    58, 7, 0,
    63, 9, 0,
    63,11, 0,
    63,13, 0,
    63,15, 0,
    63,17, 0,
    63,19, 0,
    63,21, 0,
    63,23, 0,
    63,25, 0,
    63,27, 0,
    63,29, 0,
    63,31, 0,
    63,33, 0,
    63,35, 0,
    63,38, 0,
    63,40, 0,
    63,42, 0,
    63,44, 0,
    63,46, 0,
    63,48, 0,
    63,50, 0,
    63,52, 0,
    63,53, 0,
    63,54, 0,
    63,54, 0,
    63,55, 0,
    63,56, 0,
    63,57, 0,
    63,58, 0,
    63,59, 0,
    63,60, 0,
    63,61, 0,
    63,62, 0,
    63,63, 1,
    63,63, 5,
    63,63, 9,
    63,63,12,
    63,63,16,
    63,63,20,
    63,63,23,
    63,63,27,
    63,63,31,
    63,63,34,
    63,63,38,
    63,63,42,
    63,63,45,
    63,63,49,
    63,63,52,
    63,63,56,
    63,63,60);

TYPE
    palettetype = (firepal,rpal,gpal,bpal,palrouge,
                   palvert,palbleu,palgris,
                   systempal);

PROCEDURE newPalette64 (pal:palettetype);
VAR
    ndx : CARDINAL;
    n   : CARDINAL;
    i   : CARDINAL;
    r,g,b:BYTE;
BEGIN
    waitVGAretrace(); (* reduce noise on screen *)
    CASE pal OF

    | rpal:
        ndx := 0;         n := 2;
        FOR i := 1 TO n DO resetdac(ndx+i-1,00H,00H,00H);END;
        INC(ndx,n);       n := 18;
        blend (ndx,n,black,red);
        INC(ndx,n);       n := 20;
        blend (ndx,n,red,yellow);
        INC(ndx,n);       n := 24;
        blend (ndx,n,yellow,white);
    | gpal:
        ndx := 0;         n := 2;
        FOR i := 1 TO n DO resetdac(ndx+i-1,00H,00H,00H);END;
        INC(ndx,n);       n := 18;
        blend (ndx,n,black,green);
        INC(ndx,n);       n := 16;
        blend (ndx,n,green,yellow);
        INC(ndx,n);       n := 28;
        blend (ndx,n,yellow,white);
    | bpal:
        ndx := 0;         n := 2;
        FOR i := 1 TO n DO resetdac(ndx+i-1,00H,00H,00H);END;
        INC(ndx,n);       n := 18;
        blend (ndx,n,black,blue);
        INC(ndx,n);       n := 14;
        blend (ndx,n,blue,cyan);
        INC(ndx,n);       n := 30;
        blend (ndx,n,cyan,white);

(*
    | rpal:
        ndx := 0;         n := 2;
        FOR i := 1 TO n DO resetdac(ndx+i-1,00H,00H,00H);END;
        INC(ndx,n);       n := 8;
        blend (ndx,n,black,darkred);
        INC(ndx,n);       n := 19;
        blend (ndx,n,darkred,red);
        INC(ndx,n);       n := 19;
        blend (ndx,n,red,yellow);
        INC(ndx,n);       n := 16;
        blend (ndx,n,yellow,white);
    | gpal:
        ndx := 0;         n := 2;
        FOR i := 1 TO n DO resetdac(ndx+i-1,00H,00H,00H);END;
        INC(ndx,n);       n := 16;
        blend (ndx,n,black,darkgreen);
        INC(ndx,n);       n := 15;
        blend (ndx,n,darkgreen,green);
        INC(ndx,n);       n := 15;
        blend (ndx,n,green,yellow);
        INC(ndx,n);       n := 16;
        blend (ndx,n,yellow,white);
    | bpal:                           (* 2 18 14 30 *)
        ndx := 0;         n := 2;
        FOR i := 1 TO n DO resetdac(ndx+i-1,00H,00H,00H);END;
        INC(ndx,n);       n := 8;
        blend (ndx,n,black,darkblue);
        INC(ndx,n);       n := 8;
        blend (ndx,n,darkblue,blue);
        INC(ndx,n);       n := 20;
        blend (ndx,n,blue,cyan);
        INC(ndx,n);       n := 26;
        blend (ndx,n,cyan,white);
*)
    | firepal:
        FOR ndx:= 0 TO egarange-1 DO
            n := ndx*3;
            setDAC(ndx,fixedfirepal[n],fixedfirepal[n+1],fixedfirepal[n+2]);
        END;
    | palrouge:
        n := 0;
	    FOR i:=32 TO 64 DO
            r:= BYTE(i) ; g:= 0; b:= 0;
            setDAC(n,r,g,b);setDAC(n+1,r,g,b);INC(n,2);
        END;
    | palvert:
        n := 0;
	    FOR i:=32 TO 64 DO
		    r:= 0; g:= BYTE(i); b:= 0;
            setDAC(n,r,g,b);setDAC(n+1,r,g,b);INC(n,2);
        END;
    | palbleu:
        n := 0;
	    FOR i:=32 TO 64 DO
		    r:= 0; g:= 0; b:= BYTE(i);
            setDAC(n,r,g,b);setDAC(n+1,r,g,b);INC(n,2);
        END;
    | palgris:
        n := 0;
	    FOR i:=32 TO 64 DO
		    r:= BYTE(i); g:= BYTE(i); b:= BYTE(i);
            setDAC(n,r,g,b);setDAC(n+1,r,g,b);INC(n,2);
        END;
    | systempal:
        (* nada *)
    END;
    setDAC(ndxblack,00H,00H,00H);    (* safety 0=black *)
    n := maxinkindex-egarange+1;
    blend (egarange,n,black,black);  (* 64..255=black *)
    (* setDAC(maxinkindex,3FH,3FH,3FH); *)
END newPalette64;

PROCEDURE showPalette (maxWaitInSeconds:LONGINT );
VAR
   i    : CARDINAL;
   xpos : CARDINAL;
   ypos : CARDINAL;
   p    : CARDINAL;
BEGIN
   clearvideoscreen(ndxblack); (* index of sky, so black *)
   FOR i := 0 TO 255 DO
       FOR ypos := ymin TO ymax DO
           p := Ybase[ypos] + i; (* was ypos * xcount + i *)
           videoscreen[p]:=BYTE(i);
       END;
   END;
   input (maxWaitInSeconds);
END showPalette;

(* ------------------------------------------------------------ *)
(* ------------------------------------------------------------ *)

CONST
    minParticle      = 1;
    maxParticle      = 30000;
    defaultParticle  = 15000;
    particlestep     = 500;
    lowestParticle   = particlestep;

(* if we were using an array of particle type, size would be too limited *)
VAR
    particlex : ARRAY [minParticle..maxParticle] OF CARDINAL;
    particley : ARRAY [minParticle..maxParticle] OF CARDINAL;
    particlec : ARRAY [minParticle..maxParticle] OF BYTE;

PROCEDURE newparticle (i:CARDINAL);
BEGIN
    particlex[i] :=getrndrange(xmin,xmax);
    particley[i] :=getrndrange(ymin,ymax);
    particlec[i] :=BYTE((particley[i] * maxcolorindex) DIV ymax);
END newparticle;

PROCEDURE initParticles (n:CARDINAL );
VAR
    i : CARDINAL;
BEGIN
    FOR i := minParticle TO n DO
        newparticle(i);
    END;
END initParticles;

PROCEDURE burn (n:CARDINAL;wind:INTEGER);
VAR
    i,x,y,p,px,delta:CARDINAL;
    color:BYTE;
    v:INTEGER;
BEGIN
    delta := CARDINAL(ABS(wind));
    FOR i := minParticle TO n DO
        x:=particlex[i];
        y:=particley[i];
        color:=particlec[i];

        wplot(x,y,color);

        IF y > ymin THEN
            (* here we could set some wind but why ? *)
            CASE x OF
            | xmin: x := getrndrange(x,x+1);
            | xmax: x := getrndrange(x-1,x);
            ELSE
                IF wind = 0 THEN
                    x := getrndrange(x-1,x+1);
                ELSIF wind < 0 THEN
                    (* no problem because y always > ymin, so security assured *)
                    x := getrndrange(x-delta,x+1);
                ELSE
                    (* no problem if x > xmax because of security *)
                    x := getrndrange(x-1,x+delta);
                END;
            END;
            DEC(y);
            color:=BYTE((y * maxcolorindex) DIV ymax);
        ELSE
            x    :=getrndrange(xmin,xmax);
            y    :=ymax;
            color:=maxcolorindex;
        END;
        particlex[i]:=x;
        particley[i]:=y;
        particlec[i]:=color;
    END;
END burn;

PROCEDURE smooth (DOUBLEBUFFER:BOOLEAN );
VAR
    x,y:CARDINAL;
    ink,inkl,inkr,inku,inkd:CARDINAL;
    inklu,inkld,inkru,inkrd:CARDINAL;
    p,px:CARDINAL;
BEGIN
    FOR y := ymin+1 TO ymax DO
        p := Ybase[y]; (* useless to add +xcount ! -- was xcount * y *)
        FOR x := xmin+1 TO xmax-1 DO
            px := p+x;
            ink  :=CARDINAL(WorkScreen^[px]);            (* x  ,y   *)
            inku :=CARDINAL(WorkScreen^[px-xcount]);     (* x  ,y-1 *)
            inklu:=CARDINAL(WorkScreen^[px-xcount-1]);   (* x-1,y-1 *)
            inkru:=CARDINAL(WorkScreen^[px-xcount+1]);   (* x+1,y-1 *)
            inkl:=CARDINAL(WorkScreen^[px-1]) ;          (* x-1,y *)
            inkr:=CARDINAL(WorkScreen^[px+1]) ;          (* x+1,y *)
            ink := (ink + inkl +inkr + inku + inklu + inkru) DIV 6;
            IF ink > mininkindex THEN DEC(ink);END;
            IF DOUBLEBUFFER THEN
                NextWorkScreen^[px]:=BYTE(ink);
            ELSE
                WorkScreen^[px]:=BYTE(ink);
            END;
            SmoothScreen^[px]:=BYTE(ink);
        END;

        (* handle dots at limits *)
        px:=p+xmin;
        ink  :=CARDINAL(WorkScreen^[px]);            (* x  ,y   *)
        inku :=CARDINAL(WorkScreen^[px-xcount]);     (* x  ,y-1 *)
        inkru:=CARDINAL(WorkScreen^[px-xcount+1]);   (* x+1,y-1 *)
        inkr:=CARDINAL(WorkScreen^[px+1]) ;          (* x+1,y *)

        inklu:=CARDINAL(WorkScreen^[px-xcount+xmax]);   (* x-1,y-1 i.e. xmax,y-1 *)
        inkl:=CARDINAL(WorkScreen^[px+xmax]) ;        (* x-1,y i.e. xmax,y *)

        ink := (ink + inkl +inkr + inku + inklu + inkru) DIV 6;
        IF ink > mininkindex THEN DEC(ink);END;
        IF DOUBLEBUFFER THEN
            NextWorkScreen^[px]:=BYTE(ink);
        ELSE
            WorkScreen^[px]:=BYTE(ink);
        END;
        SmoothScreen^[px]:=BYTE(ink);

        px:=p+xmax;
        ink  :=CARDINAL(WorkScreen^[px]);            (* x  ,y   *)
        inku :=CARDINAL(WorkScreen^[px-xcount]);     (* x  ,y-1 *)
        inklu:=CARDINAL(WorkScreen^[px-xcount-1]);   (* x-1,y-1 *)
        inkl:=CARDINAL(WorkScreen^[px-1]) ;          (* x-1,y *)

        inkru:=CARDINAL(WorkScreen^[px-xcount-xmax]);   (* x+1,y-1 i.e. xmin,y-1 *)
        inkr:=CARDINAL(WorkScreen^[px-xmax]) ;          (* x+1,y i.e. xmin,y *)

        ink := (ink + inkl +inkr + inku + inklu + inkru) DIV 6;
        IF ink > mininkindex THEN DEC(ink);END;
        IF  DOUBLEBUFFER  THEN
            NextWorkScreen^[px]:=BYTE(ink);
        ELSE
            WorkScreen^[px]:=BYTE(ink);
        END;
        SmoothScreen^[px]:=BYTE(ink);
    END;
    IF DOUBLEBUFFER THEN nextworkscreen2workscreen; END;
END smooth;

(* ------------------------------------------------------------ *)
(* ------------------------------------------------------------ *)

PROCEDURE burnX2 (n:CARDINAL;wind:INTEGER);
VAR
    i,x,y,p,px,delta:CARDINAL;
    color:BYTE;
    v:INTEGER;
BEGIN
    delta := k * CARDINAL(ABS(wind));
    FOR i := minParticle TO n DO
        x:=particlex[i]; x := x - (x MOD k);
        y:=particley[i]; y := y - (y MOD k);
        color:=particlec[i];

        wplot(x,y,color);   wplot(x+1,y,color);
        wplot(x,y+1,color); wplot(x+1,y+1,color);

        IF y > ymin THEN
            (* here we could set some wind but why ? *)
            CASE x OF
            | xmin: x := getrndrange(x,x+kr);
            | xmax: x := getrndrange(x-k,x);
            ELSE
                IF wind=0 THEN
                    x := getrndrange(x-k,x+kr);
                ELSIF wind < 0 THEN
                    (* no problem because y always > ymin, so security assured *)
                    x := getrndrange(x-delta,x+kr);
                ELSE
                    (* no problem if x > xmax because of security *)
                    x := getrndrange(x-k,x+delta);
                END;
            END;
            DEC(y);
            color:=BYTE((y * maxcolorindex) DIV ymax);
        ELSE
            x    :=getrndrange(xmin,xmax);
            y    :=ymax;
            color:=maxcolorindex;
        END;
        particlex[i]:=x;
        particley[i]:=y;
        particlec[i]:=color;
    END;
END burnX2;

PROCEDURE smoothX2 (DOUBLEBUFFER:BOOLEAN);
VAR
    x,y:CARDINAL;
    ink,inkl,inkr,inku,inkd:CARDINAL;
    inklu,inkld,inkru,inkrd:CARDINAL;
    p,px:CARDINAL;
    color:BYTE;
BEGIN
    FOR y := ymin+k+1 TO ymax-k+1 BY k DO
        p := Ybase[y]; (* useless to add +xcount ! -- was xcount * y *)
        FOR x := xmin+k TO xmax-k BY k DO
            px := p+x;
            ink  :=CARDINAL(WorkScreen^[px]);            (* x  ,y   *)
            inku :=CARDINAL(WorkScreen^[px-xcountX2]);     (* x  ,y-k *)
            inklu:=CARDINAL(WorkScreen^[px-xcountX2-k]);   (* x-k,y-k *)
            inkru:=CARDINAL(WorkScreen^[px-xcountX2+k]);   (* x+k,y-k *)
            inkl:=CARDINAL(WorkScreen^[px-k]) ;          (* x-k,y *)
            inkr:=CARDINAL(WorkScreen^[px+k]) ;          (* x+k,y *)
            ink := (ink + inkl +inkr + inku + inklu + inkru) DIV 6;
            IF ink > mininkindex THEN DEC(ink);END;
            color:=BYTE(ink);
            IF DOUBLEBUFFER THEN
                NextWorkScreen^[px]            :=color;
                NextWorkScreen^[px+1]          :=color;
                NextWorkScreen^[px+xcount]     :=color;
                NextWorkScreen^[px+xcount+1]   :=color;
            ELSE
                WorkScreen^[px]            :=color;
                WorkScreen^[px+1]          :=color;
                WorkScreen^[px+xcount]     :=color;
                WorkScreen^[px+xcount+1]   :=color;
            END;
            SmoothScreen^[px]          :=color;
            SmoothScreen^[px+1]        :=color;
            SmoothScreen^[px+xcount]   :=color;
            SmoothScreen^[px+xcount+1] :=color;

        END;

        (* handle dots at limits *)
        px:=p+xmin;
        ink  :=CARDINAL(WorkScreen^[px]);            (* x  ,y   *)
        inku :=CARDINAL(WorkScreen^[px-xcountX2]);   (* x  ,y-k *)
        inkru:=CARDINAL(WorkScreen^[px-xcountX2+k]); (* x+k,y-k *)
        inkr :=CARDINAL(WorkScreen^[px+k]) ;         (* x+k,y *)

        inklu:=CARDINAL(WorkScreen^[px-xcountX2+xmax]); (* x-k,y-k i.e. xmax,y-k *)
        inkl:=CARDINAL(WorkScreen^[px+xmax]) ;          (* x-k,y i.e. xmax,y *)

        ink := (ink + inkl +inkr + inku + inklu + inkru) DIV 6;
        IF ink > mininkindex THEN DEC(ink);END;
        color:=BYTE(ink);
            IF DOUBLEBUFFER THEN
                NextWorkScreen^[px]            :=color;
                NextWorkScreen^[px+1]          :=color;
                NextWorkScreen^[px+xcount]     :=color;
                NextWorkScreen^[px+xcount+1]   :=color;
            ELSE
                WorkScreen^[px]            :=color;
                WorkScreen^[px+1]          :=color;
                WorkScreen^[px+xcount]     :=color;
                WorkScreen^[px+xcount+1]   :=color;
            END;
        SmoothScreen^[px]          :=color;
        SmoothScreen^[px+1]        :=color;
        SmoothScreen^[px+xcount]   :=color;
        SmoothScreen^[px+xcount+1] :=color;

        px:=p+xmax-1; (* -1 is required in order to avoid an artefact at lower left corner *)
        ink  :=CARDINAL(WorkScreen^[px]);            (* x  ,y   *)
        inku :=CARDINAL(WorkScreen^[px-xcountX2]);   (* x  ,y-k *)
        inklu:=CARDINAL(WorkScreen^[px-xcountX2-k]); (* x-k,y-k *)
        inkl:=CARDINAL(WorkScreen^[px-k]) ;          (* x-k,y *)

        inkru:=CARDINAL(WorkScreen^[px-xcountX2-xmax]);   (* x+k,y-k i.e. xmin,y-k *)
        inkr:=CARDINAL(WorkScreen^[px-xmax]) ;            (* x+k,y i.e. xmin,y *)

        ink := (ink + inkl +inkr + inku + inklu + inkru) DIV 6;
        IF ink > mininkindex THEN DEC(ink);END;
        color:=BYTE(ink);
            IF DOUBLEBUFFER THEN
                NextWorkScreen^[px]            :=color;
                NextWorkScreen^[px+1]          :=color;
                NextWorkScreen^[px+xcount]     :=color;
                NextWorkScreen^[px+xcount+1]   :=color;
            ELSE
                WorkScreen^[px]            :=color;
                WorkScreen^[px+1]          :=color;
                WorkScreen^[px+xcount]     :=color;
                WorkScreen^[px+xcount+1]   :=color;
            END;
        SmoothScreen^[px]          :=color;
        SmoothScreen^[px+1]        :=color;
        SmoothScreen^[px+xcount]   :=color;
        SmoothScreen^[px+xcount+1] :=color;
    END;
    IF DOUBLEBUFFER THEN nextworkscreen2workscreen; END;
END smoothX2;

(* ------------------------------------------------------------ *)
(* ------------------------------------------------------------ *)

PROCEDURE value (S:ARRAY OF CHAR;min,max:CARDINAL;VAR r:CARDINAL):BOOLEAN;
VAR
    v : LONGCARD;
BEGIN
    IF GetLongCard(S,v)=FALSE THEN RETURN FALSE; END;
    IF v < LONGCARD(min) THEN RETURN FALSE; END;
    IF v > LONGCARD(max) THEN RETURN FALSE; END;
    r := CARDINAL(v);
    RETURN TRUE;
END value;

PROCEDURE ivalue (S:ARRAY OF CHAR;min,max:INTEGER;VAR r:INTEGER):BOOLEAN;
VAR
    v : LONGINT;
BEGIN
    IF GetLongInt(S,v)=FALSE THEN RETURN FALSE; END;
    IF v < LONGINT(min) THEN RETURN FALSE; END;
    IF v > LONGINT(max) THEN RETURN FALSE; END;
    r := INTEGER(v);
    RETURN TRUE;
END ivalue;

(* ------------------------------------------------------------ *)
(* ------------------------------------------------------------ *)

TYPE
    wavdatatype = RECORD
        headerlen : LONGCARD;
        len       : LONGCARD;
        channels  : CARDINAL;
        frequency : CARDINAL;
        ptr       : wavPtrType;
    END;
VAR
    databackground:wavdatatype;

CONST
    keyEscape  = 01B00H;
    keySpace   = 02000H;
    keyCR      = 00D00H;
    keyPageUp  = 00049H;
    keyPageDn  = 00051H;
    keyEnd     = 0004FH;
    keyHome    = 00047H;
    upperR     = ORD("R") << 8 ;
    lowerR     = ORD("r") << 8 ;
    upperG     = ORD("G") << 8 ;
    lowerG     = ORD("g") << 8 ;
    upperB     = ORD("B") << 8 ;
    lowerB     = ORD("b") << 8 ;
    upperC     = ORD("C") << 8 ;
    lowerC     = ORD("c") << 8 ;
    keyLeft    = 0004BH;
    keyRight   = 0004DH;
    upperD     = ORD("D") << 8 ;
    lowerD     = ORD("d") << 8 ;
    key1       = ORD("1") << 8 ;
    key2       = ORD("2") << 8 ;
    key3       = ORD("3") << 8 ;
    key0       = ORD("0") << 8 ;
CONST
    maxWaitInSeconds = LONGINT(10);
    undefined        = minParticle-1;
    minRound         = 1;
    maxRound         = 1000;
    maxWind          = INTEGER(10);
    minWind          = INTEGER(-maxWind);
    defaultWind      = 0;
VAR
    parmcount   : CARDINAL;
    i           : CARDINAL;
    opt         : CARDINAL;
    S           : str128;
    R           : str128;
    v           : CARDINAL;
VAR
    DOUBLEBUFFER : BOOLEAN; (* if TRUE, we avoid ugly fly effect *)
    palette     : palettetype;
    stopmouse   : BOOLEAN;
    showpal     : BOOLEAN;
    lastParticle: CARDINAL;
    coarse      : BOOLEAN;
    wind        : INTEGER;
    noise       : BOOLEAN;

    keycode     : CARDINAL;
    singlestep  : BOOLEAN;
    chk         : BOOLEAN;

    lowerintensity,upperintensity : CARDINAL;
    motion      : (none,plus,minus);
    lastround   : CARDINAL;
    rounds      : CARDINAL;
    pathBackground : str128;
BEGIN
    Lib.DisableBreakCheck();
    WrLn;                       (* must be here for pretty ulterior display ! *)

    DOUBLEBUFFER := FALSE;
    palette      := firepal;
    stopmouse    := FALSE;
    showpal      := FALSE;
    lastParticle := defaultParticle;
    coarse       := FALSE;
    wind         := defaultWind;
    noise        := FALSE;

    lowerintensity :=undefined;
    upperintensity :=undefined;
    lastround      :=0;

    parmcount := Lib.ParamCount();

    FOR i := 1 TO parmcount DO
        Lib.ParamStr(S,i);
        Str.Copy(R,S);
        UpperCase(R);
        IF isOption(R)=TRUE THEN
            opt := GetOptIndex (R, "?"+delim+"H"+delim+"HELP"+delim+
                                   "A"+delim+"SHOWPAL"+delim+
                                   "Z"+delim+"MOUSE"+delim+
                                   "P:"+delim+"PALETTE:"+delim+
                                   "N:"+delim+"PARTICLES:"+delim+
                                   "C"+delim+"COARSE"+delim+
                                   "L:"+delim+"LOWER:"+delim+
                                   "U:"+delim+"UPPER:"+delim+
                                   "R:"+delim+"ROUNDS:"+delim+
                                   "W:"+delim+"WIND:"+delim+
                                   "D"+delim+"DOUBLEBUFFER"+delim+
                                   "S"+delim+"SOUND"
                               );
            CASE opt OF
            | 1,2,3 :
                abort(errHelp,"");
            | 4,5 :
                showpal := TRUE;
            | 6,7:
                stopmouse:=TRUE;
            | 8,9:
                IF value(R,ORD(firepal),ORD(systempal),v)=FALSE THEN
                    abort(errRange,"palette");
                END;
                palette:=palettetype(v);
            | 10,11:
                IF value(R,lowestParticle,maxParticle,lastParticle)=FALSE THEN
                    abort(errRange,"number of particles");
                END;
            | 12,13:
                coarse:=TRUE;
            | 14,15:
                IF value(R,lowestParticle,maxParticle,lowerintensity)=FALSE THEN
                    abort(errRange,"lower number of particles");
                END;
            | 16,17:
                IF value(R,lowestParticle,maxParticle,upperintensity)=FALSE THEN
                    abort(errRange,"upper number of particles");
                END;
            | 18,19:
                IF value(R,minRound,maxRound,lastround)=FALSE THEN
                    abort(errRange,"rounds");
                END;
            | 20,21:
                IF ivalue(R,minWind,maxWind,wind)=FALSE THEN
                    abort(errRange,"wind");
                END;
            | 22,23:
                DOUBLEBUFFER := TRUE;
            | 24,25:
                noise:=TRUE;
            ELSE
                abort(errUnknownOpt,S);
            END;
        ELSE
            abort(errIllegalParm,S);
        END;
    END;

    IF lowerintensity = undefined THEN
        IF upperintensity = undefined THEN
            motion := none;
        ELSE
            abort(errNeedBoth,"");
        END;
    ELSE
        IF upperintensity = undefined THEN
            abort(errNeedBoth,"");
        ELSE
            IF lastround = 0 THEN abort(errMissingRounds,"");END;
            rounds:=minRound;
            IF lowerintensity > upperintensity THEN
                i:=lowerintensity;
                lowerintensity:=upperintensity;
                upperintensity:=i;
            END;
            IF ABS(upperintensity-lowerintensity+1)<=particlestep THEN
                upperintensity:=lowerintensity+particlestep+1;
                IF upperintensity > maxParticle THEN
                    upperintensity := maxParticle;
                    lowerintensity := upperintensity-particlestep-1;
                END;
            END;
            lastParticle := lowerintensity;
            motion := plus;
        END;
    END;

    IF noise THEN
        IF chkBlaster(S)=FALSE THEN abort(errSB,S); END;
        makebase(S);
        Str.Concat(pathBackground,S,wavBackground);
        IF FIO.Exists(pathBackground)=FALSE THEN abort(errNotFound,pathBackground);END;
        IF chkSizeLessThan64K(pathBackground)=FALSE THEN abort(err64K,pathBackground);END;

        IF chkWavHeader(pathBackground,S)=FALSE THEN abort(errWav,S); END;
        (* retrieve global variables *)
        databackground.headerlen :=lenheader;
        databackground.len       :=datalen;
        databackground.channels  :=channels;
        databackground.frequency :=frequency;
        (* load file in allocated memory *)
        IF loadfile(pathBackground,
                    databackground.headerlen,databackground.len,
                    databackground.ptr)=FALSE THEN
            abort(errAllocate,pathBackground);
        END;

        SBCardSpeakerOn();
        GoPlayback (databackground.ptr,
                    databackground.len,
                    databackground.channels,
                    databackground.frequency);
    END;

    doRandomize;

    initYbase;
    NEW(WorkScreen);
    NEW(SmoothScreen);
    NEW(NextWorkScreen);

    initParticles(lastParticle);

    setVideoMode(hires);
    newPalette64(palette);
    clearvideoscreen(ndxblack);

    IF showpal THEN
        showPalette(maxWaitInSeconds);
        clearvideoscreen(ndxblack);
    END;

    IF stopmouse THEN
        IF MsMouse.Reset()=MAX(INTEGER) THEN
            stopmouse := FALSE;
        END;
    END;

    flushKeyboard;

    clearworkscreen(ndxblack);
    clearsmoothscreen(ndxblack);
    clearnextworkscreen(ndxblack);

    singlestep := FALSE;

    LOOP
        (* screen update *)
        IF coarse THEN
            burnX2(lastParticle,wind);
            smoothX2(DOUBLEBUFFER);
        ELSE
            burn(lastParticle,wind);
            smooth(DOUBLEBUFFER);
        END;
        smooth2video;

        (* auto motion *)
        CASE motion OF
        | none : (* nada *);
        | plus:
            INC(rounds);
            IF rounds>=lastround THEN
                rounds:=minRound;
                FOR i:=1 TO particlestep DO
                    IF lastParticle < upperintensity THEN
                        INC(lastParticle);
                        newparticle(lastParticle);
                    END;
                END;
                IF lastParticle >= upperintensity THEN motion:=minus;END;
            END;
        | minus:
            INC(rounds);
            IF rounds>=lastround THEN
                rounds:=minRound;
                FOR i:=1 TO particlestep DO
                    IF lastParticle > lowerintensity THEN DEC(lastParticle);END;
                END;
                IF lastParticle <= lowerintensity THEN motion:=plus;END;
            END;
        END;

        (* read and process key *)
        IF singlestep THEN
            WHILE getKeyboardCode(keycode)=FALSE DO
            END;
            chk:=(keycode # keySpace);
            singlestep:=NOT(chk);
        ELSE
            chk:=getKeyboardCode(keycode);
        END;
        IF chk THEN
            CASE keycode OF
            | lowerR        : newPalette64(firepal);
            | upperR        : newPalette64(rpal);
            | upperG,lowerG : newPalette64(gpal);
            | upperB,lowerB : newPalette64(bpal);
            | key1          : newPalette64(palrouge);
            | key2          : newPalette64(palvert);
            | key3          : newPalette64(palbleu);
            | key0          : newPalette64(palgris);
            | keySpace      : singlestep:=NOT (singlestep);
            | keyEscape     : EXIT;
            | keyCR         : EXIT;
            | lowerC,upperC : coarse := NOT(coarse);
                              (*
                              reinitialize as to avoid nasty weird effect
                              with x/y MOD 2 positions
                              *)
                              FOR i := minParticle TO lastParticle DO
                                  newparticle(i);
                              END;
                              (* avoid last line artefact *)
                              clearsmoothscreen(ndxblack);
                              (*
                              FOR i := xmin TO xmax DO
                                  wplot(i,ymax,ndxblack);
                                  wplot(i,ymax-1,ndxblack);
                                  splot(i,ymax,ndxblack);
                                  splot(i,ymax-1,ndxblack);
                              END;
                              *)
            | keyPageUp     : FOR i:=1 TO particlestep DO
                                  IF lastParticle < maxParticle THEN
                                      INC(lastParticle);
                                      newparticle(lastParticle);
                                  END;
                              END;
            | keyPageDn     : FOR i:=1 TO particlestep DO
                                  IF lastParticle > particlestep THEN DEC(lastParticle);END;
                              END;
            | keyHome       : FOR i := lastParticle+1 TO maxParticle DO
                                  newparticle(i);
                              END;
                              lastParticle := maxParticle;
            | keyEnd        : lastParticle := particlestep;
            | keyLeft       : IF wind > minWind THEN DEC(wind);END;
            | keyRight      : IF wind < maxWind THEN INC(wind);END;
            | upperD,lowerD : DOUBLEBUFFER:=NOT(DOUBLEBUFFER);
            END;
        END;
        IF stopmouse THEN
            IF mouseclick() THEN EXIT; END;
        END;

        IF noise THEN
            IF PlaybackDone() THEN
                GoPlayback (databackground.ptr,
                            databackground.len,
                            databackground.channels,
                            databackground.frequency);
            END;
        END;

    END;
    opt:=lastParticle;
    IF keycode = keyCR THEN
        WHILE lastParticle > minParticle DO
            FOR i:=1 TO particlestep DO
                IF lastParticle > minParticle THEN DEC(lastParticle);END;
            END;
            IF coarse THEN
                burnX2(lastParticle,wind);
                smoothX2(DOUBLEBUFFER);
            ELSE
                burn(lastParticle,wind);
                smooth(DOUBLEBUFFER);
            END;
            smooth2video;
        END;
    END;

    setVideoMode(text);

    CASE lastParticle OF
    | 1..9:       i:=1;
    | 10..99:     i:=2;
    | 100..999:   i:=3;
    | 1000..9999: i:=4;
    ELSE          i:=5;
    END;
    IO.WrCard(opt,i);WrStr(" particles, wind force was ");
    CASE wind OF
    | 1..9:       i:=1;
    | 10..99:     i:=2;
    ELSE          i:=3;
    END;
    IO.WrInt(wind,i);WrLn;

    IF noise THEN (* fire may be still playing *)
        REPEAT
        UNTIL PlaybackDone();
        SBCardSpeakerOff();
    END;

    abort(errNone,"");
END Fire.

