(* ---------------------------------------------------------------
Title         Q&D Win9X LFN library
Author        PhG
Overview      limited subset mainly created for CS utility
Notes         w9X prefix for all functions (see interrup.h)
              model really cannot be small
              use FIO functions on short path to get size, date and attributes
              should we always force trailing $00 in paths ?

              winXP hides its LFN support !
              should we add a switch to force LFN support ?
              check environment variable at first lib call ?

              good old interrupt list tells us that the windows NT DOS Box always
              returns v5.50 (bx=$3205) after GET TRUE VERSION NUMBER

Bugs
Wish List     use these functions in : dcomp, with, procdups, fix pcopy too

--------------------------------------------------------------- *)

IMPLEMENTATION MODULE QD_LFN;

IMPORT SYSTEM;
IMPORT Lib;

(* ------------------------------------------------------------ *)

(*
                         msdos7 before win9x    DOS box from win9x   DOS box from WinXP
getDOSversion            7.10                   7.10                 5.0
getTrueDOSversion        7.10                   7.10                 5.50
isWindowsEnh             FALSE (0.22)           TRUE (4.10)          FALSE (0.22)
MS DOS 7 / Windows 9X    TRUE                   TRUE                 FALSE

*)

(*
INT 21 - DOS 2+ - GET DOS VERSION
win95 returns 7.0, osr2 7.1, NT DOS box 5.0, various OS/2 modes 10 or 20 !
*)

PROCEDURE w9XgetDOSversion (VAR major,minor:CARDINAL);
VAR
    R : SYSTEM.Registers;
BEGIN
    R.AH := 30H;
    R.AL := 00H; (* DOS 5+ : what to return in BH : here, useless OEM number *)
    Lib.Dos(R);
    major:=CARDINAL(R.AL);
    minor:=CARDINAL(R.AH);
END w9XgetDOSversion;

(*
INT 21 - DOS 5+ - GET TRUE VERSION NUMBER
win95 returns 7.0, osr2 7.1, NT DOS box 5.50 (which will do as a check for WinXP console)
*)

PROCEDURE w9XgetTrueDOSversion (VAR major,minor:CARDINAL );
VAR
    R : SYSTEM.Registers;
BEGIN
    R.AX:=3306H;
    Lib.Dos(R);
    major:=CARDINAL(R.BL);
    minor:=CARDINAL(R.BH);
END w9XgetTrueDOSversion;

CONST
    multiplex = 2FH;

(* INT 2F - MS Windows - WINDOWS ENHANCED MODE INSTALLATION CHECK *)

PROCEDURE w9XisWindowsEnh (VAR major,minor:CARDINAL  ) : BOOLEAN;
VAR
    R : SYSTEM.Registers;
BEGIN
    R.AX:=1600H;
    Lib.Intr(R,multiplex);
    major:=CARDINAL(R.AL); (* if >= 3 *)
    minor:=CARDINAL(R.AH);
    (*
    does not like 80H seen as out of range with checking enabled !
    yet this is a perfectly legal set !
    *)
    (* RETURN NOT (major IN {00H, 01H, 80H, 0FFH}); *) (* not 3.1 or more *)
    CASE major OF
    | 00H, 01H, 80H, 0FFH :
        RETURN FALSE;
    ELSE
        RETURN TRUE;
    END;
END w9XisWindowsEnh;

(* INT 2F - Windows95 - CHECK MS-DOS VERSION 7 *)

PROCEDURE w9XisMSDOS7 (  ) : BOOLEAN;
VAR
    R : SYSTEM.Registers;
BEGIN
    R.AX:=4A33H;
    Lib.Intr(R, multiplex);
    RETURN (R.AX=0); (* MS DOS 7.00+ *)
END w9XisMSDOS7;

(* ------------------------------------------------------------ *)

(*
quirk : for compatibility with DOS versions prior to v7.00, the carry flag
should be set on call to ensure that it is set on exit
*)

CONST
    dtformat64      = 0;
    dtformatDOS     = 1; (* in low double-word of time QWORD (date is high word, time is low word of double-WORD) *)

(* INT 21 - Windows95 - LONG FILENAME - FIND FIRST MATCHING FILE *)

PROCEDURE w9XfindFirst (spec:path9X;
                       allowableMask,requiredMask:SHORTCARD;
                       VAR unicodeconversion:unicodeConversionFlagType;
                       VAR findDataRecord:findDataRecordType;
                       VAR fiohandle,errcode:CARDINAL):BOOLEAN;
VAR
    R : SYSTEM.Registers;
BEGIN
    R.AX := 714EH;
    R.CL := allowableMask; (* 0 and 5 ignored *)
    R.CH := requiredMask;
    R.SI := dtformatDOS; (* for our ease *)
    R.DS := Seg(spec); (* both "*.*" and "*" match any filename *)
    R.DX := Ofs(spec);
    R.ES := Seg(findDataRecord);
    R.DI := Ofs(findDataRecord);
    INCL(R.Flags,SYSTEM.CarryFlag); (* quirk *)
    Lib.Dos(R);
    IF (SYSTEM.CarryFlag IN R.Flags) THEN
        errcode:=R.AX; (* $7100 if unsupported function *)
        RETURN FALSE;
    ELSE
        fiohandle:=R.AX;
        unicodeconversion:=unicodeConversionFlagType(R.CX);
        RETURN TRUE;
    END;
END w9XfindFirst;

(* INT 21 - Windows95 - LONG FILENAME - FIND NEXT MATCHING FILE *)

PROCEDURE w9XfindNext (fiohandle:CARDINAL;
                      VAR unicodeconversion:unicodeConversionFlagType;
                      VAR findDataRecord:findDataRecordType;
                      VAR errcode:CARDINAL):BOOLEAN;
VAR
    R : SYSTEM.Registers;
BEGIN
    R.AX := 714FH;
    R.BX := fiohandle;
    R.SI := dtformatDOS; (* for our ease *)
    R.ES := Seg(findDataRecord);
    R.DI := Ofs(findDataRecord);
    INCL(R.Flags, SYSTEM.CarryFlag); (* quirk *)
    Lib.Dos(R);
    IF (SYSTEM.CarryFlag IN R.Flags) THEN
        errcode:=R.AX; (* $7100 if unsupported function *)
        RETURN FALSE;
    ELSE
        fiohandle:=R.AX;
        unicodeconversion:=unicodeConversionFlagType(R.CX);
        RETURN TRUE;
    END;
END w9XfindNext;

(* INT 21 - Windows95 - LONG FILENAME - "FindClose" - TERMINATE DIRECTORY SEARCH *)

PROCEDURE w9XfindClose (fiohandle:CARDINAL; VAR errcode:CARDINAL):BOOLEAN ;
VAR
    R:SYSTEM.Registers;
BEGIN
    R.AX := 71A1H;
    R.BX := fiohandle;
    Lib.Dos(R);
    IF (SYSTEM.CarryFlag IN R.Flags) THEN
        errcode:=R.AX; (* $7100 if unsupported function *)
        RETURN FALSE;
    ELSE
        RETURN TRUE;
    END;
END w9XfindClose;

(* ------------------------------------------------------------ *)

(* INT 21 - Windows95 - LONG FILENAME - GET CURRENT DIRECTORY *)

(*
darn, it's a partial result, not always with unit or full path

the returned pathname does not include the drive letter, colon, or
leading backslash, and is not necessarily a long filename
this function returns whatever path was used when changing to the
current directory, and may include a mixture of long and short components
*)

PROCEDURE w9XgetCurrentDirectory (unit:SHORTCARD;
                                 VAR errcode:CARDINAL; VAR current:path9X):BOOLEAN ;
VAR
    R:SYSTEM.Registers;
BEGIN
    R.AX := 7147H;
    R.DL := unit;         (* 0=current, 1=A:, etc. *)
    R.DS := Seg(current);
    R.SI := Ofs(current);
    INCL(R.Flags, SYSTEM.CarryFlag); (* quirk *)
    Lib.Dos(R);
    IF (SYSTEM.CarryFlag IN R.Flags) THEN
        errcode:=R.AX; (* $7100 if unsupported function *)
        RETURN FALSE;
    ELSE
        RETURN TRUE;
    END;
END w9XgetCurrentDirectory;

(* ------------------------------------------------------------ *)

CONST
    returnTruePath = 00H; (* return a path containing true path for a SUBSTed drive letter *)
    returnSubstPath= 80H; (* return a path containing the SUBSTed drive letter *)

(* INT 21 - Windows95 - LONG FILENAME - GET SHORT (8.3) FILENAME FOR FILE *)

(*
full path, even if relative path given, and all uppercase
this call returns the short name
for any long-filename portions of the provided pathname or filename
*)

PROCEDURE w9XlongToShort (long:path9X;
                         VAR errcode:CARDINAL; VAR short:path9X):BOOLEAN;
VAR
    R : SYSTEM.Registers;
BEGIN
	R.AX := 7160H;
	R.CL := 01H;
	R.CH := returnSubstPath;
	R.DS := Seg(long);
	R.SI := Ofs(long);
	R.ES := Seg(short);
	R.DI := Ofs(short); (* 67-byte (possibly 128-byte) buffer for short filename *)
    Lib.Dos(R);
    IF (SYSTEM.CarryFlag IN R.Flags) THEN
        errcode:=R.AX; (* 02h = invalid component, 03h = malformed *)
        RETURN FALSE;
    ELSE
        RETURN TRUE;
    END;
END w9XlongToShort;

(* INT 21 - Windows95 - LONG FILENAME - GET CANONICAL LONG FILENAME OR PATH *)

PROCEDURE w9XshortToLong (short:path9X;
                         VAR errcode:CARDINAL;VAR long:path9X):BOOLEAN;
VAR
    R : SYSTEM.Registers;
BEGIN
	R.AX := 7160H;
	R.CL := 02H;
	R.CH := returnSubstPath;
	R.DS := Seg(short);
	R.SI := Ofs(short);
	R.ES := Seg(long); (* will contain TRUENAME qualified long name *)
	R.DI := Ofs(long);
    Lib.Dos(R);
    IF (SYSTEM.CarryFlag IN R.Flags) THEN
        errcode:=R.AX; (* 02h = invalid component, 03h = malformed *)
        RETURN FALSE;
    ELSE
        RETURN TRUE;
    END;
END w9XshortToLong;

(* INT 21 - Windows95 - LONG FILENAME - "TRUENAME" - CANONICALIZE PATH *)

(*
determine the canonical name of the specified filename or path,
corresponding to the undocumented TRUENAME command in COMMAND.COM
if a complete path is given, the result will be a short-form complete path;
otherwise, the given relative path is appended to the short-form
current directory name, '.'/'..'/'...'/etc. are resolved,
and the final result uppercased without converting any remaining
long-form names to short-form
*)

PROCEDURE w9XtrueName (who:path9X;
                      VAR errcode:CARDINAL;VAR canonical:path9X):BOOLEAN;
VAR
    R : SYSTEM.Registers;
BEGIN
	R.AX := 7160H;
	R.CL := 00H;
	R.CH := returnSubstPath;
	R.DS := Seg(who);
	R.SI := Ofs(who);
	R.ES := Seg(canonical);
	R.DI := Ofs(canonical);
    INCL(R.Flags, SYSTEM.CarryFlag); (* quirk *)
    Lib.Dos(R);
    IF (SYSTEM.CarryFlag IN R.Flags) THEN
        errcode:=R.AX; (* 02h = invalid component, 03h = malformed *)
        RETURN FALSE;
    ELSE
        RETURN TRUE;
    END;
END w9XtrueName;

(* INT 21 - Windows95 - LONG FILENAME - CHANGE DIRECTORY *)

PROCEDURE w9XchangeDir (where:path9X;VAR errcode:CARDINAL):BOOLEAN;
VAR
    R : SYSTEM.Registers;
BEGIN
	R.AX := 713BH;
	R.DS := Seg(where);
	R.DX := Ofs(where);
    INCL(R.Flags, SYSTEM.CarryFlag); (* quirk *)
    Lib.Dos(R);
    IF (SYSTEM.CarryFlag IN R.Flags) THEN
        errcode:=R.AX;
        RETURN FALSE;
    ELSE
        RETURN TRUE;
    END;
END w9XchangeDir;

(* INT 21 - Windows95 - LONG FILENAME - MAKE DIRECTORY *)

PROCEDURE w9XmakeDir (who:path9X;VAR errcode:CARDINAL):BOOLEAN;
VAR
    R : SYSTEM.Registers;
BEGIN
    R.AX := 7139H;
	R.DS := Seg(who);
	R.DX := Ofs(who);
    INCL(R.Flags, SYSTEM.CarryFlag); (* quirk *)
    Lib.Dos(R);
    IF (SYSTEM.CarryFlag IN R.Flags) THEN
        errcode:=R.AX; (* $7100 if unsupported function *)
        RETURN FALSE;
    ELSE
        RETURN TRUE;
    END;
END w9XmakeDir;

(* INT 21 - Windows95 - LONG FILENAME - REMOVE DIRECTORY *)

PROCEDURE w9XrmDir (who:path9X;VAR errcode:CARDINAL):BOOLEAN;
VAR
    R : SYSTEM.Registers;
BEGIN
    R.AX := 713AH;
	R.DS := Seg(who);
	R.DX := Ofs(who);
    INCL(R.Flags, SYSTEM.CarryFlag); (* quirk *)
    Lib.Dos(R);
    IF (SYSTEM.CarryFlag IN R.Flags) THEN
        errcode:=R.AX; (* $7100 if unsupported function *)
        RETURN FALSE;
    ELSE
        RETURN TRUE;
    END;
END w9XrmDir;

(* INT 21 - Windows95 - LONG FILENAME - RENAME FILE *)

(*
old file or directory name (long names allowed)
the file may be renamed into a different directory, but not across disks
*)

PROCEDURE w9Xrename (oldname,newname:path9X;VAR errcode:CARDINAL):BOOLEAN;
VAR
    R : SYSTEM.Registers;
BEGIN
    R.AX := 7156H;
	R.DS := Seg(oldname);
	R.DX := Ofs(oldname);
	R.ES := Seg(newname);
	R.DI := Ofs(newname);
    INCL(R.Flags, SYSTEM.CarryFlag); (* quirk *)
    Lib.Dos(R);
    IF (SYSTEM.CarryFlag IN R.Flags) THEN
        errcode:=R.AX; (* $7100 if unsupported function *)
        RETURN FALSE;
    ELSE
        RETURN TRUE;
    END;
END w9Xrename;

(* INT 21 - Windows95 - LONG FILENAME - CREATE OR OPEN FILE *)

(*

darn, there does not seem to exist a LFN CLOSE such as 213E !

 0	open file (fail if file does not exist)
 1	truncate file if it already exists (fail if file does not exist)
 4	create new file if file does not already exist (fail if exists)
 only valid combinations of multiple flags are bits 4&0 and 4&1


 2-0	file access mode
	000 read-only
	001 write-only
	010 read-write
	100 read-only, do not modify file's last-access time
 6-4	file sharing modes
 7	no-inherit flag
 8	do not buffer data (requires that all reads/writes be exact physical
	  sectors)
 9	do not compress file even if volume normally compresses files
 10	use alias hint in DI as numeric tail for short-name alias
 12-11	unused??? (0)
 13	return error code instead of generating INT 24h if critical error
	  while opening file
 14	commit file after every write operation

*)

PROCEDURE w9XopenFile (create:BOOLEAN;who:path9X;VAR hnd,errcode:CARDINAL):BOOLEAN;
VAR
    R : SYSTEM.Registers;
    action:CARDINAL;
BEGIN
    R.AX := 716CH;
	R.DS := Seg(who);
	R.SI := Ofs(who);
	R.CX := 00H; (* attributes for default file *)
    R.DI := 1;   (* alias hint *)
    R.BX := 02H; (* access mode rw = %0010 but maybe we should trap critical handler too ? *)
    IF create THEN
        action:=12H; (* %10010 create/truncate *)
    ELSE
        action:=01H; (* %00001 open *)
    END;
    R.DX := action;
    INCL(R.Flags, SYSTEM.CarryFlag); (* quirk *)
    Lib.Dos(R);
    IF (SYSTEM.CarryFlag IN R.Flags) THEN
        errcode:=R.AX; (* $7100 if unsupported function *)
        RETURN FALSE;
    ELSE
        hnd := R.AX;
        action:=R.CX; (* 1=opened, 2=created, 3=replaced *)
        RETURN TRUE;
    END;
END w9XopenFile;

(* good old DOS function for now : same as FIO.Close() ! *)

(*
--------D-213E-------------------------------
INT 21 - DOS 2+ - "CLOSE" - CLOSE FILE
        AH = 3Eh
        BX = file handle
Return: CF clear if successful
            AX destroyed
        CF set on error
            AX = error code (06h) (see #01680 at AH=59h/BX=0000h)
Notes:  if the file was written to, any pending disk writes are performed, the
          time and date stamps are set to the current time, and the directory
          entry is updated
        recent versions of DOS preserve AH because some versions of Multiplan
          had a bug which depended on AH being preserved
SeeAlso: AH=10h,AH=3Ch,AH=3Dh,INT 2F/AX=1106h,INT 2F/AX=1227h
*)

PROCEDURE w9XcloseFile(hnd:CARDINAL);
VAR
    R : SYSTEM.Registers;
    errcode:CARDINAL;
BEGIN
    R.AH := 03EH;
    R.BX := hnd;
    INCL(R.Flags, SYSTEM.CarryFlag); (* quirk *)
    Lib.Dos(R);
    IF (SYSTEM.CarryFlag IN R.Flags) THEN
        errcode:=R.AX;
    ELSE
        errcode:=0;
    END;
END w9XcloseFile;

(* ------------------------------------------------------------ *)
(* ------------------------------------------------------------ *)

PROCEDURE w9XsupportLFN (  ):BOOLEAN;
CONST
    WinXPconsoleMajor = 5;
    WinXPconsoleMinor = 50;
VAR
    major,minor:CARDINAL;
BEGIN
    w9XgetTrueDOSversion (major,minor);
    IF major = WinXPconsoleMajor THEN
        IF minor = WinXPconsoleMinor THEN RETURN TRUE; END; (* risky business ! *)
    END;
    RETURN ( (w9XisMSDOS7 () ) AND (w9XisWindowsEnh (major,minor) ) );
END w9XsupportLFN;

(* ------------------------------------------------------------ *)

BEGIN

END QD_LFN.
