(* ---------------------------------------------------------------
Title         Q&D Vital Data Manager
Author        PhG
Overview      save/restore/compare CMOS data, MBR, boot sectors, track 0
Notes         minimal error messages and checking, etc.
              small model forbidden now because of Track 0 buffers

              we don't care/warn about unallocated partitions
              EBPR is relative to MAIN EXT,
              while logical parts are relative to EBPR ! what a crap container logic !

              -chk is almost certainly paranoiac
              (even with page crossing buffers, we've NEVER had any problem !)

              wiblock(raw) accounts for 500 Gb unit : this should do ;-)

              a few BIOSes (even modern ones, Ralf !) can't do multitrack operations :
              using oneSector was a good idea here
              (ok, ok : we're too lazy to rewrite rwCHS so it emulates that feature)

              disk last operation status may be unreliable (Award 6.0)

              available options : g j l u v y z

              "group or segclass exceeds 64K" problem can be fixed
              by putting a few procedures in their own segment name :
              use pragma call(seg_name=>xxx)
              (large model is supposed to allow 1Mb code !)
              note compiling for 386 instead of 8086 provided some space but not enough
              this is clearly the case for project to set map option on !

Bugs          support for $82 and $83 was not tested for lack of hardware
              fmtvlc handles only hex for now
Wish List     more safety ? better log ? warn if newpartitiontable ?
              warn about restoring partitions sectors automatically ?

              DEBUG : readPartitionTable, readMasterBoot, readExtSector,
              DEBUG : procSector

              check consistency ?
              check FAT16 and FAT32 boot record structures in AboutBootCode

              when restoring partitions, we reread MBR which should have been just restored too
              well... anyway, this kind of operation should be done by hand or from a checked batch !

              write UNDOBATCH code ?

              write an IODELAY for reading/writing CMOS data ?

              show unallocated space (get all block starts, sort them, check boundaries) ?

              hd sizes in Mb/Gb ? bah, everyone knows a block is 512 bytes ! ;-)

              UCLONE CLI : beware of extended partition and its crap container logic !
              we probably always should include epbr

              prevent sectorcount from being greater than 63 ?
              check data when using huge disks such as 120Gb
              force H to 0 for partition start ?

              -n should be useless but who knows... etc.

              rewrite DHTS, VITAL and UCLONE so they share common subs ?
              in another unlikely (un)life !

              fix NTFS boot (for now, conflicting infos from many sources)

              infos about Linux partitions ?

              copy MBR to an empty block in track 0 then zero MBR ?

--------------------------------------------------------------- *)

MODULE Vital;

IMPORT Lib;
IMPORT Str;
IMPORT FIO;
IMPORT SYSTEM;

FROM IO IMPORT WrStr, WrLn;

FROM Storage IMPORT Available,ALLOCATE,DEALLOCATE;

FROM FIO IMPORT FIXEDLIBS;

FROM QD_Box IMPORT str80, str2, cmdInit, cmdShow, cmdStop, delim,
Work, video, Ltrim, Rtrim, UpperCase, LowerCase, ReplaceChar,
ChkEscape, Waitkey, WaitkeyDelay, Flushkey, IsRedirected, chkJoker,
isOption, GetOptIndex, GetLongCard, GetLongInt, GetString, CharCount,
same, aR, aH, aS, aD, aA, everything, isDirectory, fixDirectory,
str128, str256, Animation, allfiles, Belongs, FixAE, CodePhonetic,
CodeSoundex, CodeSoundexOrg, isReadOnly, LtrimBlanks, RtrimBlanks,
getStrIndex, cmdSHOW,BiosWaitkey,BiosWaitkeyShifted,BiosFlushkey,
str1024, isoleItemS, dmpTTX, str2048, Elapsed, TerminalReadString,
getDosVersion, DosVersion, warning95, runningWindows,
aV, reallyeverything, chkClassicTextMode, setClassicTextMode,
AltAnimation, str16, getCurrentDirectory, setReadWrite, setReadOnly,
getFileSize, verifyString, str4096, unfixDirectory,
animShow, animSHOW, animAdvance, animEnd, animClear,
animInit, animGetSdone, anim, cleantabs, UpperCaseAlt, LowerCaseAlt,
completedInit, completedShow, completedSHOW, completedEnd, completed,
removeDups, isValidHDunit, removePhantoms, removeFloppies,
getCDROMunits, getCDROMletters, removeCDROMs, getAllHDunits;

(* FROM QD_LFN IMPORT w9XsupportLFN; *)

(* ------------------------------------------------------------ *)

CONST
    ENABLEREALUPDATE = TRUE; (* if FALSE, CMOS and hard disk are protected against updates *)
    RESETHD          = FALSE; (* TRUE to really reset hd in resetUnit() *)
CONST
    cr            = CHR(13);
    lf            = CHR(10);
    nl            = cr+lf;
    coma          = ",";
    dot           = ".";
    dquote        = '"';
    singlequote   = "'";
    star          = "*";
    question      = "?";
    backslash     = "\";
    colon         = ":";
    blank         = " ";
    semicolon     = ";";
    nullchar      = CHR(0); (* 0C would do too *)
    dotdot        = dot+dot;
    netslash      = backslash+backslash;
    stardotstar   = star+dot+star;
    extLOG        = dot+"LOG";
    extSAV        = dot+"SAV";
    extSOS        = dot+"SOS";
    extBAT        = dot+"BAT";
    extINI        = dot+"INI";
    extEXE        = dot+"EXE";
    extCFG        = dot+"CFG";
CONST
    progDTHS      = "DTHS";
    progUCLONE    = "UCLONE";
    placeholder   = "%";
    placeholderabout="~";
    strCLIrecovery= progDTHS+" % w % %"; (* unit W block filename *)
    strCLIcloning = progUCLONE+" -klonit % $$$target$$$ %,%"; (* unit $?? block,count *)
CONST
    wiblock       = 9+2; (* "###.###.###" is 512 Gb for # = 9 *)
    wiblockraw    = 9;   (* "#########" *)
    sepdot        = coma;
CONST
    alphabet      = "ABCDEFGHIJKLMNOPQRSTUVWXYZ"; (* uppercase *)
    digits        = "0123456789";
    symbols       = "_-$!(){}~#&";
    DOScharset    = alphabet+digits+symbols;

CONST
    progTitle     = "Q&D Vital Data Manager";
    progVersion   = "v1.3r";
    progCopyright = "by PhG";
    Banner        = progTitle+" "+progVersion+" "+progCopyright;
    progEXEname   = "VITAL";
CONST
    filePrefix    = "V_"; (* V_track0 will be just 8 chars *)
    fileCMOS      = filePrefix+"CMOS";
    fileMBR       = filePrefix+"MBR";
    fileTRACK0    = filePrefix+"TRACK0";
    filePART      = filePrefix+"PRI";   (* v_pri#  *)
    fileEXTENDED  = filePrefix+"EXT";   (* v_ext#  *)
    fileXBR       = filePrefix+"XBR";   (* v_xbr#? *)
    fileLOGICAL   = filePrefix+"LOG";   (* v_log#? *)
    fileINFOS     = filePrefix+"INFOS";
    fileOSTYPE    = filePrefix+"OSTYPE";
    (* UNDOBATCH     = filePrefix+"UNDO"+extBAT; *)
    sFAKE         = " ;-)";
CONST
    sOK           = "+++ ";
    sINFO         = "::: ";
    sPROBLEM      = "--- ";
    sWARN         = "*** ";
    sDIFF         = "### ";
    sNADA         = "    ";
    sNOTICE       = "    ";  (* question to user *)
    sCANCELLED    = "--- ";  (* not a problem but show nothing was done *)
    sWARN_CMOS    = sWARN+"CMOS";
    sWARN_MBR     = sWARN+"MBR";
    sWARN_TRACK0  = sWARN+"Track 0";
CONST
    sWARN_ZERO    = sWARN+"Fill unit ~ track 0 with $00 (existing MBR will remain unmodified)";
    sWARN_BOOTFLAG= sWARN+"Activate unit ~  primary partition ~ boot flag";
    sWARN_OSTYPE  = sWARN+"Change unit ~ partition index ~ indicator code from ~ to ~";
    sWARN_OSTYPEALT=sWARN+"Change unit ~ partndx ~ code from ~ TO ~ (~)"; (* can be long *)
    sWARN_XPID    = sWARN+"Change unit ~ current Windows XP disk ID serial number";
    sWARN_HIDEMBR = sWARN+"Hide unit ~ MBR";
    sWARN_UNHIDEMBR=sWARN+"Unhide unit ~ MBR";

    sWARNTABLENEW = " (existing MBR primary partition table will be overwritten)";
    sWARNTABLEKEPT= " (existing MBR primary partition table will remain unmodified)";

CONST (* for XD -c compatibility *)
    sepaddr     = " :";
    sepascii    = " | ";

TYPE
    cmdType = (cmdSave,cmdRestore,cmdCompare,cmdZero,
              cmdActivate,cmdNewCode,cmdNewXPID,
              cmdHideMBR,cmdUnhideMBR);

CONST
    wi = 24; (* was 23 for bootcode dump "extended boot signature" *)
CONST
    strMainPart     = "Primary partition"+blank;          (* filePART *)
    strExtendedPart = "Primary extended partition"+blank; (* fileEXTENDED *)
    strLogicalPart  = "Logical partition"+blank;          (* fileLOGICAL *)
    strExtendedBR   = "Logical extended partition"+blank; (* fileXBR *)
    strCode         = "O.S. indicator";
    strType         = "O.S. verbose ID";
    strDesc         = "O.S. terse ID";
    strActive       = "Boot indicator";
    strStartEndBiosTHS   = "BIOS [T|H|S] range";
    strStartEndActualTHS = "Actual [T|H|S] range";
    strPreceding    = "Preceding sectors"; (* relative *)
    strFirstSector  = "First sector";
    strTotal        = "Number of sectors"; (* "Total sectors" *)
    strSignature    = "Signature";
    strWinXPuniqueID= "Windows XP disk ID";
    strPartSize     = "Partition size (rounded)";
    strRecovery     = "Manual recovery";
    strCloning      = "Manual cloning ("+placeholderabout+")";
    strPartitionEntry="Partition entry"+blank;

(* ------------------------------------------------------------ *)

PROCEDURE sound (freq,duration,pause:CARDINAL);
BEGIN
    Lib.Sound(freq);
    Lib.Delay(duration);
    Lib.NoSound();
    Lib.Delay(pause);
END sound;

PROCEDURE alarm (  );
BEGIN
    sound(55,55,100);
    sound(55,55,10);
END alarm;

PROCEDURE alert (  );
BEGIN
    sound(550,55,100);
    sound(550,55,10);
END alert;

(* globerks because referenced in abort() *)

VAR
    DYNALLOC : BOOLEAN; (* if FALSE, fixed buffers *)
VAR
    AUDIO : BOOLEAN; (* globerk but we don't care *)
VAR
    FATALINAL : BOOLEAN; (* globerk *)
    sFatalStatusExplanation : str128; (* used by getFatalStatus() *)
    bFatalStatus : CARDINAL;

(* ------------------------------------------------------------ *)

(*# save *)
(*# call(seg_name=>helpcode)  *)

CONST
    errNone         = 0;
    errHelp         = 1;
    errOption       = 2;
    errParameter    = 3;
    errSyntax       = 4;
    errCommand      = 5;
    errExpected     = 6;
    errUnit         = 7;
    errFloppy       = 8;
    errExtension    = 9;
    errNonsense     = 10;
    errNonsenses    = 11;
    errDir          = 12;
    errAlreadyRO    = 13;       (* never displayed *)
    errAlready      = 14;       (* never displayed *)
    errNotFound     = 15;       (* never displayed *)
    errCancel       = 16;       (* never displayed *)
    errAborted      = 17;       (* never displayed *)
    errPhantom      = 18;
    errXBIOSvalues  = 19;
    errFixGeometry  = 20;
    errRedirected   = 21;
    errStorage      = 22;
    errFileSize     = 23;       (* never displayed *)
    errSignature    = 24;       (* never displayed *)
    errSaveInfos        = 25;
    errSavePartitions   = 26;
    errComparePartitions= 27;
    errRestorePartitions= 28;
    errHelper           = 29;
    errActivate         = 30;   (* never displayed *)
    errNewPartCode      = 31;   (* never displayed *)
    errNewPartFmt       = 32;
    errNewPartEnumIndex = 33;
    errNewPartID        = 34;
    errCMOSiniProblem   = 35;
    errNewXPID          = 36;
    errDynChk           = 37;
    errBadVal           = 38;
    errBadCMOSsize      = 39;
    errZeroFilledBlockNotFound= 40;
    errSignatureBlockNotFound = 41;
    errSignatureAlreadyFound  = 42;
    errMBRalreadyZeroed       = 43;
    errMBRalreadySigned       = 44;


    errBoundary         = 64;

    errInt13h           = 128;
    errXBIOSint13h      = 129;
    errWrongTHSgeometry = 130;

    errReadPartitionTable   = errInt13h; (* same for fatal() *)
    errReadMasterBootRecord = errInt13h; (* same for fatal() *)
    errReadExtSector        = errInt13h; (* same for fatal() *)
    errWriteExtSector       = errInt13h; (* same for fatal() *)

    errMismatch     = 255;      (* never displayed *)

PROCEDURE abort (e : CARDINAL; einfo : ARRAY OF CHAR);

    PROCEDURE msg2 (VAR R : ARRAY OF CHAR;S1,S2:ARRAY OF CHAR);
    BEGIN
        Str.Concat(R,S1,S2);
    END msg2;

    PROCEDURE msg3 (VAR R : ARRAY OF CHAR;S1,S2,S3:ARRAY OF CHAR);
    BEGIN
         msg2(R,S1,S2);Str.Append(R,S3);
    END msg3;

CONST
    placeholder = "!@!";
(*
 00000000011111111112222222222333333333344444444445555555555666666666677777777778
 1...'....0....'....0....'....0....'....0....'....0....'....0....'....0....'....0
*)
    msgHelp =
Banner+nl+
(*%F ENABLEREALUPDATE *)
nl+
"PLEASE NOTE THAT UPDATING CMOS OR HARD DISK DATA IS NOT ENABLED !"+nl+
(*%E  *)
nl+
"Syntax 1 : "+progEXEname+" <unit> <R|W|C> <u:[\directory\]...> [option]..."+nl+
"Syntax 2 : "+progEXEname+" <unit> <Z> [-yes] [-apply]"+nl+
"Syntax 3 : "+progEXEname+" <unit> <B|B1|B2|B3|B4> [-apply]"+nl+
"Syntax 4 : "+progEXEname+" <unit> <T> [-t:#,#] [-apply]"+nl+
"Syntax 5 : "+progEXEname+" <unit> <N> [-n:#] [-apply]"+nl+
"Syntax 6 : "+progEXEname+" <unit> <I[NVISIBLE]|V[ISIBLE]> [-apply]"+nl+
nl+
"R|S     read|save current data to "+filePrefix+stardotstar+" files"+nl+
"W|U     write|update data from "+filePrefix+stardotstar+" files"+nl+
"C       compare current data with reference data from "+filePrefix+stardotstar+" files"+nl+
"Z       fill track 0 with $00 (existing MBR sector will remain unmodified)"+nl+
"B       report boot flag status for each primary partition"+nl+
"B#      activate selected primary partition boot flag ([1..4])"+nl+
"T       show O.S. indicator code for each partition"+nl+
"N       show Windows XP disk ID serial number"+nl+
"I|V     make unit invisible or visible"+nl+
nl+
"-i      process <unit> organization (<R> or <W -s> required)"+nl+
"-c[:#]  process CMOS data (-c:# = -c -z:#)"+nl+
"-m[m|g] process MBR sector (-mm = -mg = -m -g)"+nl+
"-t      process track 0"+nl+
"-p      process partition data (-i automagically forced)"+nl+
"-z:#    specify CMOS size (64, 128, 256 or 512, default is 128)"+nl+
"-e:$    set data file(s) extension (default is "+extSAV+")"+nl+
"-o[o]   overwrite any existing data file (-oo = -o -r)"+nl+
"-r      ignore read-only status of existing data file"+nl+
'-t:#,#  modify O.S. indicator code (#,# = "partition index","new ID")'+nl+
'        ("#,and$ef" or "#,or$10" = "#,unhide" or "#,hide" = (un)hide partition)'+nl+
"-n:#    modify Windows XP disk ID serial number"+nl+
'        ("+++" or "---" = "incr" or "decr" = modify current serial number)'+nl+
"-q      do not display individual mismatch found"+nl+
"-g      when restoring, overwrite existing MBR primary partition table"+nl+
"        (default is to leave MBR primary partition table unmodified)"+nl+
"-s      backup unmodified data to *"+extSOS+" in current directory"+nl+
"-d      alternate display (unbeautified numbers)"+nl+
"-apply  REALLY apply any requested modification to existing data"+nl+
"        BE SURE TO KNOW WHAT YOU ARE DOING ! USE THIS OPTION AT YOUR OWN RISK !"+nl+
'        (default is to fake requested modification, as shown by "'+sFAKE+'" trailer)'+nl+
"-yes    do not ask user for confirmation"+nl+
"        BE SURE TO KNOW WHAT YOU ARE DOING ! USE THIS OPTION AT YOUR OWN RISK !"+nl+
"-x      ignore BIOS interrupt $13 extensions even if available"+nl+
"-ths    factorize blocks count ignoring unexpected values for TxHxS"+nl+
"-j[j]   if rebuilding TxHxS is needed, instead of finding best factorization,"+nl+
"        force headcount=255 (-j) or headcount=240 (-jj)"+nl+
"-e      assume track 0 sector count is S (as found in TxHxS) if smaller than 63"+nl+
"-n      force sector count to 63 and head count to 255 (unless -j[j])"+nl+
"-dyn    use dynamic buffers (default is to use fixed buffers)"+nl+
"-??[?]  more help (to be read at least once !)"+nl;

CONST
    msgverbosehelp =
"-a|-w   audio warning"+nl+
"-ah     assume int $1301 returns last operation status in AH (default is AL)"+nl+
nl+
"a) <unit> may be $8<0|1|2|3> or 8<0|1|2|3>H."+nl+
"b) Program defaults to processing CMOS, MBR, track 0 and partition data"+nl+
"   unless told to process a specific set of data (-i, -c, -m, -t, -p)."+nl+
"c) When comparing, {[$00..$09],$0C,$32,$3F} CMOS data is considered volatile ;"+nl+
"   when restoring, {[$00..$09],$0C} CMOS data is considered volatile"+nl+
"   (unless "+progEXEname+extINI+" exists in executable directory to override defaults)."+nl+
"d) Unless -e is specified, track 0 is assumed to be exactly 63 sectors long."+nl+
'e) Data location is "'+dot+'" (current), u: ([A..Z] range), or u:\[directory\]...'+nl+
"f) For compatibility and compiler reasons, <unit> access requires"+nl+
"   512 bytes WORD <sector>, DWORD <block>, WORD <track>, WORD <head>."+nl+
"g) -yes, -x, -j[j], -e and -n should NOT be used and are NOT recommended."+nl+
"h) For safety, -s option is HIGHLY recommended."+nl+
"i) For safety, any write command does NOT really update data"+nl+
"   unless any of -apply, -doit or -really options is specified."+nl+
(* "i) -apply or -doit option is required for any write command to REALLY update data."+nl+ *)
"j) -t:#,# option requires a partition index as listed by T command."+nl+
'   Hiding applies "AND $ef" (%11101111) to existing partition code,'+nl+
'   while unhiding applies "OR $10" (%00010000) to existing partition code.'+nl+
"   Use with caution if partition code is not supported by DOS or Windows."+nl+
"k) When comparing data, return code is 255 if any mismatch was found."+nl+
"l) Experimental -z:# option MUST be specified when saving (R|S) ;"+nl+
"   it is ignored when restoring (W|U) or comparing (C)."+nl+
"m) Experimental INVISIBLE command relocates MBR to an empty block in track 0"+nl+
"   then zeroes original MBR in order to make unit appear unformatted."+nl+
"   Experimental VISIBLE command restores original MBR from relocated block"+nl+
"   (itself then rezeroed) in order to make unit visible again."+nl+
"n) Each line in "+progEXEname+extINI+" is a single value in [0..127] range."+nl+
'   "+" prefix forces value to be restored.'+nl+
"o) -ah option is forced if "+progEXEname+extCFG+" exists in executable directory."+nl+
"p) "+placeholder+nl+
"   "+placeholder+nl+
"q) Undocumented -chk option uselessly checks buffers page boundaries."+nl+
nl+
(*%F FIXEDLIBS *)
"Unfortunately, thanks to a fatal bug in TopSpeed Modula-2 FIO library,"+nl+
"paths are limited to 65 characters (longer ones will NOT be found). :-("+nl+
nl+
(*%E  *)
"Examples : "+progEXEname+" $80 SAVE . -e:DAT"+nl+
"           "+progEXEname+" $80 RESTORE a: -yes"+nl+
"           "+progEXEname+" $80 B2"+nl+              (* ah, "Wag the dog" bomber... *)
"           "+progEXEname+" $81 T -t:2,$16"+nl+
"           "+progEXEname+" $81 N -n:$01021963"+nl;

VAR
    S : str256;
    SS: str4096; (* was str2048 enough for msgverbosehelp *)
BEGIN
    CASE e OF
    | errHelp,errHelper :
        WrStr(msgHelp);
        IF e = errHelper THEN

            Str.Copy(SS,msgverbosehelp);

            (* now tell user about VITAL.INI *)

            Lib.ParamStr(S,0); (* retrieve executable location : yes, we assume it ! *)
            Str.Caps(S); (* safety *)
            Str.Subst(S,extEXE,extINI);

            IF FIO.Exists(S) THEN
                S:="As "+progEXEname+extINI+" exists in executable directory,";
                Str.Subst(SS,placeholder,S);

                S:="CMOS values volatile status will be decided using its content.";
            ELSE
                S:="As "+progEXEname+extINI+" does not exist in executable directory,";
                Str.Subst(SS,placeholder,S);

                S:="CMOS values volatile status will be decided using default values.";
            END;
            Str.Subst(SS,placeholder,S);
            WrStr(SS);

            e:=errHelp;
        END;
    | errOption :
        msg3(S,'Unknown "',einfo,'" option !');
    | errParameter :
        msg3(S,'Unexpected "',einfo,'" parameter !');
    | errSyntax :
        S := "Wrong number of parameters !";
    | errCommand :
        msg3(S,'Unknown "',einfo,'" <command> !');
    | errExpected:
        msg3(S,"Syntax error, or command should be ",einfo," here !");
    | errUnit:
        msg3(S,'Illegal "',einfo,'" <unit> specification !');
    | errFloppy:
        msg3(S,'"',einfo,'" <unit> specification does not refer to a hard disk !');
    | errExtension:
        msg3(S,'Illegal or reserved "',einfo,'" extension !');
    | errNonsense:
        msg2(S,einfo," option is a nonsense with specified command !");
    | errNonsenses:
        msg3(S,"Any of ",einfo," options is a nonsense with specified command !");
    | errDir:
        msg3(S,'Illegal "',einfo,'" directory specification !');
    | errAlreadyRO:          S:="errAlreadyRO !";
    | errAlready:            S:="errAlready !";
    | errNotFound:           S:="errNotFound !";
    | errCancel:             S:="errCancel !";
    | errAborted:            S:="Aborted by user !";
    | errPhantom:
        msg3(S,'"',einfo,'" <unit> does not exist !');
    | errXBIOSvalues:
        msg3(S,'Unexpected values returned by "',einfo,'" procedure !');
    | errFixGeometry:
        S:='Failure rebuilding values in "FixGeometry" procedure !';
    | errRedirected:
        S:='Redirection is not allowed with "RESTORE" command !';
        video(progEXEname+" : ",TRUE);video(S,TRUE); (* send message to screen anyway ! *)
        IF AUDIO THEN alarm();END;
    | errStorage:
        S := "Storage.ALLOCATE() failure !";
    | errFileSize:           S:="errFileSize !";
    | errSignature:          S:="errSignature !";
    | errSaveInfos:
        S := "At least one error while executing saveInfos() !";
    | errSavePartitions:
        S := "At least one error while executing savePartitions() !";
    | errComparePartitions:
        S := "At least one error while executing compPartitions() !";
    | errRestorePartitions:
        S := "At least one error while executing restorePartitions() !";
    | errActivate:           S :="errActivate !";
    | errNewPartCode:        S :="errNewPartCode !";
    | errNewPartFmt:
        msg3(S,'Unexpected format in "-t:',einfo,'" option !');
    | errNewPartEnumIndex:
        msg3(S,'Illegal or out of range partition index in "-t:',einfo,'" option !');
    | errNewPartID:
        msg3(S,'Illegal or out of range new O.S. indicator code in "-t:',einfo,'" option !');
    | errCMOSiniProblem:
        msg3(S,"Illegal line ",einfo," !");
    | errNewXPID:
        msg3(S,'Illegal new Windows XP disk ID serial number in "-n:',einfo,'" option !');
    | errDynChk:
        S:="-chk option is irrelevant when using -dyn option !";
    | errBadVal  :
        msg3(S,"Illegal ",einfo," value !");
    | errBadCMOSsize :
        msg3(S,"Illegal ",einfo," CMOS size !");
    | errZeroFilledBlockNotFound:
        S:="Track 0 does not contain any $00-filled block for backup !";
    | errSignatureBlockNotFound:
        S:="Track 0 does not contain any MBR block backup !";
    | errSignatureAlreadyFound:
        S:="Track 0 seems to already contain a MBR block backup !";
    | errMBRalreadyZeroed:
        S:="MBR block has already been $00-filled !";
    | errMBRalreadySigned:
        S:="MBR block is not $00-filled !";

    | errBoundary:
        IF NOT ( DYNALLOC ) THEN
             msg2(S,einfo," fixed");
        ELSE
             msg2(S,einfo," dynamic");
        END;
        Str.Append(S," buffers would cross 64Kb page boundary !");

    | errInt13h :
        msg3(S,'Unexpected BIOS interrupt $13 failure in "',einfo,'" procedure !');
        Str.Append(S,sFatalStatusExplanation);
        IF AUDIO THEN alert();END;
    | errXBIOSint13h :
        msg3(S,'Unexpected BIOS interrupt $13 extensions failure in "',einfo,'" procedure !');
        Str.Append(S,sFatalStatusExplanation);
        IF AUDIO THEN alert();END;
    | errWrongTHSgeometry:
        msg3(S,'Unexpected geometry values returned by "',einfo,'" procedure !');
        IF AUDIO THEN alert();END;

    | errMismatch:           S:="errMismatch !";
        IF AUDIO THEN alert(); END;
    ELSE
        S := "How did you get THERE ???";
    END;
    CASE e OF
    | errNone, errHelp, errMismatch :
        ;
    ELSE
        WrStr(progEXEname+" : ");WrStr(S);WrLn;
    END;

    Lib.SetReturnCode(SHORTCARD(e));
    HALT;
END abort;

(*# restore *)

PROCEDURE fatal (XBIOS:BOOLEAN;S:ARRAY OF CHAR);
BEGIN
    IF XBIOS THEN
        abort(errXBIOSint13h,S);
    ELSE
        abort(errInt13h,S);
    END;
END fatal;

PROCEDURE isCritical (e:CARDINAL):BOOLEAN;
BEGIN
    CASE e OF
    | errInt13h, errXBIOSint13h:
        RETURN TRUE;
    ELSE
        RETURN FALSE;
    END;
END isCritical;

(* fills global sFatalStatusExplanation and useless bFatalStatus *)

PROCEDURE initFatalStatus (  );
CONST
    msg=nl+progEXEname+" : this message should never be seen !";
BEGIN
    bFatalStatus := 00H;
    sFatalStatusExplanation := msg;
END initFatalStatus;

PROCEDURE getFatalStatus(unit:BYTE);
CONST
    placeholder = "@";
    msg = nl+progEXEname+" : int $1301 @=$@ i.e. @ !";
    sb = 040H; (* segBiosData *)
VAR
    RC:str16;
    S,Z:str128;
    statuscode:CARDINAL;
    ok,rc:BOOLEAN;
    R:SYSTEM.Registers;
    biosFloppyLastRC [sb:041H] : BYTE;
    biosFixedLastRC  [sb:074H] : BYTE;
BEGIN
    IF unit < BYTE(80H) THEN
        bFatalStatus := CARDINAL(biosFloppyLastRC); (* DISKETTE - LAST OPERATION STATUS *)
    ELSE
        bFatalStatus := CARDINAL(biosFixedLastRC);  (* FIXED DISK LAST OPERATION STATUS (except ESDI drives) *)
    END;

    R.AH := 01H; (* get status of last operation *)
    R.DL := unit; (* bit 7 for hard disk *)
    Lib.Intr (R,13H);
    rc:=( NOT (SYSTEM.CarryFlag IN R.Flags) ); (* CF clear if successful status 00h *)
    IF FATALINAL THEN
        statuscode:= CARDINAL(R.AL);
    ELSE
        statuscode:= CARDINAL(R.AH); (* not standard, Ralf ! *)
    END;
    CASE statuscode OF
    | 000H : S:="successful completion";
    | 001H : S:="invalid function in AH or invalid parameter";
    | 002H : S:="address mark not found";
    | 003H : S:="disk write-protected";
    | 004H : S:="sector not found/read error";
    | 005H : S:="reset failed (hard disk)";
    (* | 005H : S:="data did not verify correctly (TI Professional PC)"; *)
    | 006H : S:="disk changed (floppy)";
    | 007H : S:="drive parameter activity failed (hard disk)";
    | 008H : S:="DMA overrun";
    | 009H : S:="data boundary error (attempted DMA across 64K boundary or >80h sectors)";
    | 00AH : S:="bad sector detected (hard disk)";
    | 00BH : S:="bad track detected (hard disk)";
    | 00CH : S:="unsupported track or invalid media";
    | 00DH : S:="invalid number of sectors on format (PS/2 hard disk)";
    | 00EH : S:="control data address mark detected (hard disk)";
    | 00FH : S:="DMA arbitration level out of range (hard disk)";
    | 010H : S:="uncorrectable CRC or ECC error on read";
    | 011H : S:="data ECC corrected (hard disk)";
    | 020H : S:="controller failure";
	| 030H : S:="drive does not support media sense"; (* added by hand from MEMORY.LST *)
    | 031H : S:="no media in drive (IBM/MS INT 13 extensions)";
    | 032H : S:="incorrect drive type stored in CMOS (Compaq)";
    | 040H : S:="seek failed";
    | 080H : S:="timeout (not ready)";
    | 0AAH : S:="drive not ready (hard disk)";
    | 0B0H : S:="volume not locked in drive (INT 13 extensions)";
    | 0B1H : S:="volume locked in drive (INT 13 extensions)";
    | 0B2H : S:="volume not removable (INT 13 extensions)";
    | 0B3H : S:="volume in use (INT 13 extensions)";
    | 0B4H : S:="lock count exceeded (INT 13 extensions)";
    | 0B5H : S:="valid eject request failed (INT 13 extensions)";
    | 0B6H : S:="volume present but read protected (INT 13 extensions)";
    | 0BBH : S:="undefined error (hard disk)";
    | 0CCH : S:="write fault (hard disk)";
    | 0E0H : S:="status register error (hard disk)";
    | 0FFH : S:="sense operation failed (hard disk)";
    ELSE
             S:="unexpected fatal disk operation status";
    END;

    Str.Copy(Z,msg);

    IF FATALINAL THEN
        RC:="AL";
    ELSE
        RC:="AH";
    END;
    Str.Subst(Z,placeholder,RC);

    Str.CardToStr (LONGCARD(statuscode),RC,16,ok);
    IF statuscode < 10H THEN Str.Prepend(RC,"0");END;
    Str.Lows(RC);
    Str.Subst(Z,placeholder,RC);

    (*
    Str.CardToStr (LONGCARD(bFatalStatus),RC,16,ok);
    IF bFatalStatus < 10H THEN Str.Prepend(RC,"0");END;
    Str.Lows(RC);
    Str.Subst(Z,placeholder,RC);
    *)

    Str.Subst(Z,placeholder,S);
    Str.Copy(sFatalStatusExplanation,Z);
END getFatalStatus;

PROCEDURE fixFatalStatusBios ():BOOLEAN;
VAR
    ini:str128;
BEGIN
    Lib.ParamStr(ini,0); (* retrieve executable location : yes, we assume it ! *)
    Str.Caps(ini); (* safety *)
    Str.Subst(ini,extEXE,extCFG);
    RETURN FIO.Exists(ini);
END fixFatalStatusBios;

(* ------------------------------------------------------------ *)
(* ------------------------------------------------------------ *)

CONST
    ioBufferSize      = (8 * 512) + FIO.BufferOverhead; (* 8 or less is ok *)
    firstBufferByte   = 1;
    lastBufferByte    = ioBufferSize;
TYPE
    ioBufferType = ARRAY [firstBufferByte..lastBufferByte] OF BYTE;
VAR
    ioBuffer     : ioBufferType;
    ioBufferLog  : ioBufferType;
    ioBufferIni  : ioBufferType;

(* ------------------------------------------------------------ *)
(* ------------------------------------------------------------ *)

CONST
    legalUnits = "$80"+delim+"80H"+delim+"128"+delim+"0X80"+delim+
                 "$81"+delim+"81H"+delim+"129"+delim+"0X81"+delim+
                 "$00"+delim+"00H"+delim+"0"+delim+"0X00"+delim+
                 "A:"+delim+"$0"+delim+"0X0"+delim+
                 "$01"+delim+"01H"+delim+"1"+delim+"0X01"+delim+
                 "B:"+delim+"$1"+delim+"0X1"+delim+
                 "$82"+delim+"82H"+delim+"130"+delim+"0X82"+delim+
                 "$83"+delim+"83H"+delim+"131"+delim+"0X83";

PROCEDURE chkUnit (VAR unit:BYTE;S:ARRAY OF CHAR):BOOLEAN;
VAR
    i:CARDINAL;
BEGIN
    i := getStrIndex(delim,S,legalUnits);
    CASE i OF
    |  1..4  : unit := BYTE(80H);
    |  5..8  : unit := BYTE(81H);
    |  9..15 : unit := BYTE(00H);
    | 16..22 : unit := BYTE(01H);
    | 23..26 : unit := BYTE(82H);
    | 27..30 : unit := BYTE(83H);
    ELSE
       RETURN FALSE; (* 0 *)
    END;
    RETURN TRUE;
END chkUnit;

(* ------------------------------------------------------------ *)

PROCEDURE donl ();
BEGIN
    WrLn;
END donl;

(* base + "\" + f8 + e3 *)

PROCEDURE chkFile (VAR R : ARRAY OF CHAR;
                  OVERWRITE,IGNORERO:BOOLEAN;base,f8,e3:ARRAY OF CHAR):CARDINAL;
VAR
    rc:CARDINAL;
BEGIN
    rc:=errNone;
    Str.Concat(R,base,f8);Str.Append(R,e3);
    IF FIO.Exists(R) THEN
        IF OVERWRITE THEN
            IF isReadOnly(R) THEN
                IF IGNORERO THEN
                    setReadWrite(R);
                ELSE
                    rc:=errAlreadyRO;
                END;
            END;
        ELSE
            rc:=errAlready;
        END;
    ELSE
        rc:=errNotFound;
    END;
    RETURN rc;
END chkFile;

PROCEDURE chkFileSize (S:ARRAY OF CHAR;expected:LONGCARD ):CARDINAL;
BEGIN
    IF getFileSize(S)=expected THEN
        RETURN errNone;
    ELSE
        RETURN errFileSize;
    END;
END chkFileSize;

PROCEDURE dmp (S1:ARRAY OF CHAR  );
BEGIN
    WrStr(S1);WrLn;
END dmp;

PROCEDURE dmp2 (S1,S2:ARRAY OF CHAR);
BEGIN
    WrStr(S1);WrStr(S2);WrLn;
END dmp2;

PROCEDURE dmp3 (S1,S2,S3:ARRAY OF CHAR);
BEGIN
    WrStr(S1);WrStr(S2);WrStr(S3);WrLn;
END dmp3;

PROCEDURE dmp4 (S1,S2,S3,S4:ARRAY OF CHAR);
BEGIN
    WrStr(S1);WrStr(S2);WrStr(S3);WrStr(S4);WrLn;
END dmp4;

PROCEDURE dmp5 (S1,S2,S3,S4,S5:ARRAY OF CHAR);
BEGIN
    WrStr(S1);WrStr(S2);WrStr(S3);WrStr(S4);WrStr(S5);WrLn;
END dmp5;

PROCEDURE dmp6 (S1,S2,S3,S4,S5,S6:ARRAY OF CHAR);
BEGIN
    WrStr(S1);WrStr(S2);WrStr(S3);WrStr(S4);WrStr(S5);WrStr(S6);WrLn;
END dmp6;

PROCEDURE beautifiedlc (v : LONGCARD;pad:CHAR; sep:CHAR; field:INTEGER) : str80;
VAR
    S,R   : str80;
    len,i : CARDINAL;
    ok  : BOOLEAN;
    ch  : CHAR;
BEGIN
    Str.CardToStr(v,S,10,ok);
    len:=Str.Length(S);
    R := "";
    FOR i := 1 TO len DO
        Str.Prepend(R,S[len-i]);
        IF i < len THEN
            IF (i MOD 3) = 0 THEN
                Str.Prepend(R,sep);
            END;
        END;
    END;
    LOOP
        IF INTEGER(Str.Length(R)) >= ABS(field) THEN EXIT; END;
        IF field < 0 THEN
            Str.Append(R,pad);  (* right alignment *)
        ELSE
            Str.Prepend(R,pad);
        END;
    END;
    RETURN R;
END beautifiedlc;

PROCEDURE fmtlc (v:LONGCARD;base:CARDINAL;wi:INTEGER;ch,prefix:CHAR) : str80;
VAR
    R : str80;
    ok: BOOLEAN;
    i : CARDINAL;
BEGIN
    Str.CardToStr(v,R,base,ok);
    FOR i:= Str.Length(R)+1 TO ABS(wi) DO
        IF wi < 0 THEN
            Str.Append(R,ch);
        ELSE
            Str.Prepend(R,ch);
        END;
    END;
    IF base=16 THEN Str.Lows(R);END;
    Str.Prepend(R,prefix);
    RETURN R;
END fmtlc;

PROCEDURE fmt (v:CARDINAL;base:CARDINAL;wi:INTEGER;ch,prefix:CHAR) : str80;
BEGIN
    RETURN fmtlc(LONGCARD(v),base,wi,ch,prefix);
END fmt;

TYPE VERYLONGCARD = RECORD (* 64 bits *)
    lo : LONGCARD;
    hi : LONGCARD;
END;

PROCEDURE fmtvlc (v:VERYLONGCARD;base:CARDINAL;wi:INTEGER;ch,prefix:CHAR) : str80;
VAR
    S:str80;
BEGIN
    base  :=16; (* //FIXME v1.3p force hex until we handle decimal *)
    wi    :=8;
    ch    :="0";
    prefix:="$";

    Str.Concat(S,fmtlc(v.hi,base,wi,ch,prefix), fmtlc(v.lo,base,wi,ch,"") );
    RETURN S;
END fmtvlc;

PROCEDURE fmtDateTimeUS ():str80;
TYPE
    tDays   = ARRAY [1..7] OF str16;
    tMonths = ARRAY [1..12] OF str16;
CONST
    tJours = tDays("Sunday","Monday","Tuesday","Wednesday",
                   "Thursday","Friday","Saturday"
                  );
    tMois = tMonths("January","February","March","April",
                    "May","June","July","August",
                    "September","October","November","December"
                   );
VAR
    Year,Month,Day : CARDINAL;
    DayOfWeek      : Lib.DayType;
    H,M,S,s        : CARDINAL;
    R              : str80;
BEGIN
    (* yes, we know it's not very american a date/time format... so what ? *)
    Lib.GetDate (Year,Month,Day,DayOfWeek);
    Lib.GetTime (H,M,S,s);

    Str.Copy(R,tJours[ORD(DayOfWeek)+1]);
    Str.Append(R,", ");

    Str.Append(R,fmt(Day,10,0,"",""));   Str.Append(R," ");
    Str.Append(R,tMois[Month]);          Str.Append(R," ");
    Str.Append(R,fmt(Year,10,0,"",""));  Str.Append(R," at ");
    Str.Append(R,fmt(H,10,0,"",""));     Str.Append(R,"h ");
    Str.Append(R,fmt(M,10,0,"",""));     Str.Append(R,"mn ");
    Str.Append(R,fmt(S,10,0,"",""));     Str.Append(R,"s");
    RETURN R;
END fmtDateTimeUS;

PROCEDURE fmtchar (enclose:BOOLEAN;c : BYTE) : str16;
VAR
    S : str16;
    enclosechar:CHAR;
BEGIN
    CASE ORD(c) OF
    | 0..ORD(blank)-1 : S:=".";
    | 255 :             S:=".";
    ELSE
                        Str.Copy(S,CHR(c));
    END;
    IF enclose THEN
        CASE ORD(c) OF
        | ORD(dquote) :
            enclosechar := singlequote;
        ELSE
            enclosechar := dquote;
        END;
        Str.Prepend(S,enclosechar);Str.Append(S,enclosechar);
    END;
    RETURN S;
END fmtchar;

PROCEDURE fdmp (hnd:FIO.File;S:ARRAY OF CHAR);
BEGIN
    FIO.WrStr(hnd,S);
END fdmp;

PROCEDURE show (hnd:FIO.File;wi:CARDINAL;S1,S2:ARRAY OF CHAR);
VAR
    i:CARDINAL;
    R:str1024; (* should do *)
BEGIN
    Str.Copy(R,S1);
    FOR i:=(Str.Length(S1)+1) TO wi DO Str.Append(R," ");END;
    Str.Append(R," : ");Str.Append(R,S2);Str.Append(R,nl);
    fdmp(hnd,R);
END show;

PROCEDURE show3 (hnd:FIO.File;wi:CARDINAL;S1,S2,S3:ARRAY OF CHAR );
CONST
    sep   = " : ";
    seplen= 3;
VAR
    winew:CARDINAL;
BEGIN
    winew:=Str.Length(S1)+seplen+wi;
    Str.Append(S1,sep);Str.Append(S1,S2);
    show(hnd,winew,S1,S3);
END show3;

PROCEDURE showTHS (hnd:FIO.File;wi, tt,hh,ss:CARDINAL;S1:ARRAY OF CHAR);
VAR
    S2:str80; (* oversized "#####, ###, ##" *)
BEGIN
    (* S2:="~, ~, ~"; *)
    S2:="~ | ~ | ~";
    Str.Subst(S2,"~", fmt(tt,10,5,blank,"") );
    Str.Subst(S2,"~", fmt(hh,10,3,blank,"") );
    Str.Subst(S2,"~", fmt(ss,10,2,blank,"") );
    show(hnd,wi,S1,S2);
END showTHS;

PROCEDURE showTHSrange (hnd:FIO.File;wi, tt,hh,ss,tr,he,se:CARDINAL;S1:ARRAY OF CHAR);
VAR
    S2:str80; (* oversized "#####, ###, ###" *) (* S can be more than 63 when rebuilt *)
BEGIN
    S2:="[ ~ | ~ | ~ ] .. [ ~ | ~ | ~ ] ";
    Str.Subst(S2,"~", fmt(tt,10,5,blank,"") );
    Str.Subst(S2,"~", fmt(hh,10,3,blank,"") );
    Str.Subst(S2,"~", fmt(ss,10,3,blank,"") );

    Str.Subst(S2,"~", fmt(tr,10,5,blank,"") );
    Str.Subst(S2,"~", fmt(he,10,3,blank,"") );
    Str.Subst(S2,"~", fmt(se,10,3,blank,"") );
    show(hnd,wi,S1,S2);
END showTHSrange;

(* ------------------------------------------------------------ *)
(* ------------------------------------------------------------ *)

(*
Format of hard disk master boot sector:
Offset	Size	Description	(Table 00650)
 00h 446 BYTEs	Master bootstrap loader code

(1B8h  4 BYTEs  Windows XP disk ID serial number)

1BEh 16 BYTEs	partition record for partition 1 (see #00651)
1CEh 16 BYTEs	partition record for partition 2
1DEh 16 BYTEs	partition record for partition 3
1EEh 16 BYTEs	partition record for partition 4
1FEh	WORD	signature, AA55h indicates valid boot block

Format of partition record:
Offset	Size	Description	(Table 00651)
 00h	BYTE	boot indicator (80h = active partition)
 01h	BYTE	partition start head
 02h	BYTE	partition start sector (bits 0-5)
 03h	BYTE	partition start track (bits 8,9 in bits 6,7 of sector)
 04h	BYTE	operating system indicator (see #00652)
 05h	BYTE	partition end head
 06h	BYTE	partition end sector (bits 0-5)
 07h	BYTE	partition end track (bits 8,9 in bits 6,7 of sector)
 08h	DWORD	sectors preceding partition
 0Ch	DWORD	length of partition in sectors
SeeAlso: #00650
*)

CONST
    mintrack      = 0;
    minhead       = 0;
    minsector     = 1;
    minblock      = 0;
    maxheadcount  = 255; (* yes, 255 and not 256 because we want to avoid MessDOS fatal boot bug *)
CONST
    sectorSize        = 512;
    firstByteInSector = 0;
    lastByteInSector  = sectorSize-1;
    oneSector         = 1;
    firstPartNdx      = 1;
    lastPartNdx       = 4;
TYPE
    SectorType        = ARRAY [firstByteInSector..lastByteInSector] OF BYTE;
    ptrToSectorType   = POINTER TO SectorType;
CONST
    firstLoaderCodeByte     = 0;
    winXPuniqueIDoffset     = 01B8H; (* LONGCARD : M$ bastards taking liberties with standards ! *)
    lastLoaderCodeByte      = 01BDH;                (* I love hard-coded constants... sometimes ;-) *)
    firstPartitionTableByte = lastLoaderCodeByte+1; (* $01bd+1=$01be til $1fd *)
    lastPartitionTableByte  = 01FFH-1-1;            (* ignore $AA55 at $1fe..$1ff *)
TYPE
    PartitionRecord = RECORD
        BootIndicator    : BYTE; (* 80h is active *)
        StartHead        : BYTE;
        StartSector      : BYTE; (* bits 0-5 *)
        StartTrack       : BYTE; (* bits 8-9 in bits 6-7 of StartSector *)
        OSindicator      : BYTE;
        EndHead          : BYTE;
        EndSector        : BYTE; (* bits 0-5 *)
        EndTrack         : BYTE; (* bits 8-9 in bits 6-7 of EndSector *)
        SectorsPreceding : LONGCARD;  (* DWORD *)
        LengthInSectors  : LONGCARD;  (* DWORD *)
    END;
    MBRrecordType = RECORD
        CASE : BOOLEAN OF
        | TRUE:
            LoaderCode : ARRAY [firstLoaderCodeByte..lastLoaderCodeByte] OF BYTE; (* $000..$1bd *)
            PartitionX : ARRAY [firstPartNdx..lastPartNdx] OF PartitionRecord;    (* $1be..$1fd *)
            Signature  : CARDINAL; (* $aa55 *)                                    (* $1fe..$1ff *)
        | FALSE :
            bytearray  : SectorType;
        END;
    END;
    ptrMBRrecordType = POINTER TO MBRrecordType;

VAR (* globerks *)
    buffMasterBoot              : MBRrecordType;
    buffMasterBootRef           : MBRrecordType; (* read from disk file *)
    buffPartitionTable          : MBRrecordType;
    buffExt                     : MBRrecordType;
    buffSector                  : SectorType; (* when comparing partitions *)
    (* buffDEBUG                   : MBRrecordType; (* used for DEBUG *) *)
    pbuffMasterBoot              : ptrMBRrecordType;
    pbuffMasterBootRef           : ptrMBRrecordType; (* read from disk file *)
    pbuffPartitionTable          : ptrMBRrecordType;
    pbuffExt                     : ptrMBRrecordType;
    pbuffSector                : ptrToSectorType; (* when comparing partitions *)
    (* pbuffDEBUG                  : ptrMBRrecordType; (* used for DEBUG *) *)

CONST
    firstSectorInTrack= 1;  (* minsector *)
    maxSectorInTrack  = 63; (* 111111b is 63 *)
TYPE
    TrackType         = ARRAY [firstSectorInTrack..maxSectorInTrack] OF SectorType;
    pTrackType        = ARRAY [firstSectorInTrack..maxSectorInTrack] OF ptrToSectorType;

VAR (* globerks *)
    buffTrack0        : TrackType;
    buffTrack0Ref     : TrackType; (* read from disk file *)
    pbuffTrack0       : pTrackType;
    pbuffTrack0Ref    : pTrackType; (* read from disk file *)

(* ------------------------------------------------------------ *)
(* ------------------------------------------------------------ *)

VAR
    DEBUG  : BOOLEAN; (* global, globerks *)
    logfile : str128;
TYPE
    howtype = (showAsTable,showAsRaw);
CONST
    sAsRaw    = "Dump : hexadecimal/ASCII";
    sAsTable  = "Dump : partition table";

PROCEDURE initLOG ();
VAR
    S:str128;
    hnd:FIO.File;
BEGIN
    Str.Concat(logfile,progEXEname,extLOG); (* already done at program start but who knows what evil lurks etc. *)
    IF FIO.Exists(logfile) THEN
        setReadWrite(logfile);
        FIO.Erase(logfile);
        (*
        hnd:=FIO.Append(logfile);
        *)
        hnd:=FIO.Create(logfile);
    ELSE
        hnd:=FIO.Create(logfile);
    END;

    Str.Concat(S,nl+sINFO+"Log started on ",fmtDateTimeUS());
    Str.Append(S,nl+nl);
    fdmp(hnd,S);
    FIO.Close(hnd);
END initLOG;

PROCEDURE logLowLevel (unit,command:BYTE; XBIOS:BOOLEAN;block:LONGCARD;
                      track,head,sector,count:WORD;
                      bcylinder,bsector:BYTE);
VAR
    hnd:FIO.File;
    S:str256; (* oversized just in case *)
BEGIN
    Str.Concat(S,sINFO+"unit ", fmt( CARDINAL(unit),16,2,"0","$"));

    Str.Append(S, ", cmd ");Str.Append(S,fmt( CARDINAL(command),16,2,"0","$"));

    IF XBIOS THEN
        Str.Append(S, ", block= ");Str.Append(S,fmtlc(block,10,0,"",""));
    ELSE
        Str.Append(S, ", T= ");Str.Append(S,fmt(track,10,0,"",""));
        Str.Append(S, ", H= ");Str.Append(S,fmt(head,10,0,"",""));
        Str.Append(S, ", S= ");Str.Append(S,fmt(sector,10,0,"",""));
        Str.Append(S, ", t= ");Str.Append(S,fmt( CARDINAL(bcylinder),10,0,"",""));
        Str.Append(S, ", s= ");Str.Append(S,fmt( CARDINAL(bsector),10,0,"",""));
    END;
    Str.Append(S, ", count= ");Str.Append(S,fmt(count,10,0,"",""));
    Str.Append(S,nl);

    hnd := FIO.Append(logfile);
    fdmp(hnd,S);
    FIO.Close(hnd);
END logLowLevel;

PROCEDURE dumpSector (how:howtype; buff:SectorType);
CONST
    hcount=16;
VAR
    i,j,v:CARDINAL;
    hnd:FIO.File;
    S,S2:str128;
    alcatraz:BOOLEAN;
BEGIN
    hnd:=FIO.Append(logfile);
    FIO.AssignBuffer(hnd,ioBufferLog);

    Str.Copy(S,nl+sINFO+sAsRaw+nl+nl);
    fdmp(hnd,S);

    i:=firstByteInSector;
    alcatraz:=FALSE;
    LOOP
        Str.Concat(S,fmt(i,16,4,"0",""),sepaddr);
        Str.Copy(S2,sepascii);
        j:=1;
        LOOP
            IF alcatraz THEN
                Str.Append(S, " "); Str.Append(S, "  "); (* ## *)
                Str.Append(S2," ");
            ELSE
                v:=CARDINAL(buff[i]);
                Str.Append(S, " "); Str.Append(S, fmt(v,16,2,"0",""));
                Str.Append(S2,fmtchar(FALSE, BYTE(v) ));
            END;
            INC(i);
            IF i > lastByteInSector THEN alcatraz:=TRUE; END;
            INC(j);
            IF j > hcount THEN EXIT; END;
        END;
        Str.Append(S,S2);Str.Append(S,nl);
        fdmp(hnd,S);
        IF alcatraz THEN EXIT; END;
    END;
    fdmp(hnd,nl);

(*
    CASE how OF
    | showAsTable:

        fdmp(hnd,sINFO+sAsTable+nl+nl);

        buffDEBUG.bytearray:=buff;

        FOR i:=firstPartNdx TO lastPartNdx DO
            Str.Concat(S, strPartitionEntry, CHR(ORD("0")+i));

            WITH buffDEBUG.PartitionX[i] DO
                show3(hnd,wi,S,strActive,fmt( CARDINAL(BootIndicator),16,2,"0","$"));

                show3(hnd,wi,S,strStartHead,fmt(CARDINAL(StartHead),16,2,"0","$"));
                show3(hnd,wi,S,strStartSector,fmt(CARDINAL(StartSector),16,2,"0","$"));
                show3(hnd,wi,S,strStartTrack,fmt(CARDINAL(StartTrack),16,2,"0","$"));

                show3(hnd,wi,S,strCode,fmt(CARDINAL(OSindicator),16,2,"0","$"));

                show3(hnd,wi,S,strEndHead,fmt(CARDINAL(EndHead),16,2,"0","$"));
                show3(hnd,wi,S,strEndSector,fmt(CARDINAL(EndSector),16,2,"0","$"));
                show3(hnd,wi,S,strEndTrack,fmt(CARDINAL(EndTrack),16,2,"0","$"));

                show3(hnd,wi,S,strPreceding,fmtlc( SectorsPreceding,10,0,"",""));
                show3(hnd,wi,S,strTotal,fmtlc( LengthInSectors,10,0,"",""));
            END;
            fdmp(hnd,nl);
        END;
    | showAsRaw: ; (* done *)
    END;
*)
    FIO.Close(hnd);
END dumpSector;

(* ------------------------------------------------------------ *)
(* ------------------------------------------------------------ *)

(*
T = block AND $03ff
H = block AND $ff
S = block AND $3f

if trackcount <= 1023, perform as above
if not, do
T = 1023
H = maxhead AND $ff
S = maxsector AND $3f
*)

PROCEDURE blockToCHS (trackcount,headcount,sectorcount:CARDINAL;
                     block:LONGCARD;
                     VAR track,head,sector:CARDINAL);
VAR
    v:LONGCARD;
BEGIN
    v      := block;
    sector := minsector + CARDINAL (v MOD LONGCARD(sectorcount));

    v      := block DIV (LONGCARD(sectorcount));
    head   := minhead   + CARDINAL (v MOD LONGCARD(headcount));

    v      := block DIV (LONGCARD(sectorcount) * LONGCARD(headcount));
    track  := mintrack  + CARDINAL (v MOD LONGCARD(trackcount));
END blockToCHS;

PROCEDURE CHStoBlock (trackcount,headcount,sectorcount:CARDINAL;
                     track,head,sector:CARDINAL;
                     VAR block:LONGCARD);
VAR
    v:LONGCARD;
BEGIN
    v:= ( LONGCARD(track) * LONGCARD(headcount) ) + LONGCARD(head);
    v:= v * LONGCARD(sectorcount) + LONGCARD(sector) - minsector; (* i.e. -1 *)
    block :=v;
END CHStoBlock;

(* assume $00, $01, $80, $81 *)

PROCEDURE isFloppy (unit:BYTE  ):BOOLEAN;
BEGIN
    CASE unit OF
    | 80H,81H,82H,83H:
        RETURN FALSE;
    ELSE
        RETURN TRUE;
    END;
END isFloppy;

(*
    first, we try to find headcount (<=highest) and trackcount
    so that their product is v (totalblocks)
    if we fail finding exact values, we rely to headcount=highest
*)

CONST
    FORCEBEST = 0;
    FORCE255  = 255;
    FORCE240  = 240;

PROCEDURE findBestFactors (BESTFIT:CARDINAL;v:LONGCARD;highest:LONGCARD;
                          VAR headcount,trackcount:CARDINAL);
VAR
    a,b:LONGCARD;
    needhack:BOOLEAN;
BEGIN
    needhack:=TRUE;
    a:=highest;      (* maxheadcount is 255 *)
    LOOP
        b:=(v DIV a);
        IF (a*b)=v THEN
            needhack:=FALSE;
            EXIT;
        END;
        DEC (a);
        IF a < 2 THEN EXIT; END;
    END;
    IF BESTFIT # FORCEBEST THEN needhack:=TRUE; END;
    IF needhack THEN
        a:=LONGCARD(BESTFIT); (* 255 or 240 *)
        b:=(v DIV a);
    END;
    headcount:= CARDINAL(a);
    trackcount:=CARDINAL(b);
END findBestFactors;

(*
PROCEDURE dbggeom (tc,hc,sc:CARDINAL;bc:LONGCARD;Z:ARRAY OF CHAR);
VAR
    S:str80;
BEGIN
Str.Copy(S,Z);
Str.Subst(S,"!",fmt(tc,10,1,"",""));
Str.Subst(S,"!",fmt(hc,10,1,"",""));
Str.Subst(S,"!",fmt(sc,10,1,"",""));
Str.Subst(S,"!",fmtlc(bc,10,1,"",""));
WrStr(S);WrLn;
END dbggeom;
*)

PROCEDURE forceTrack63(BESTFIT:CARDINAL;blockcount:LONGCARD;
                       VAR maxtrackorg,maxheadorg,maxsectororg:CARDINAL):BOOLEAN;
VAR
    t,h,s, hh:CARDINAL;
    tcount,hcount,scount:CARDINAL;
    rc:BOOLEAN;
BEGIN
    t:=maxtrackorg;
    h:=maxheadorg;
    s:=maxsectororg;

    tcount := t - mintrack  +1;
    hcount := h - minhead   +1;
    scount := s - minsector +1;

(* dbggeom(tcount,hcount,scount,blockcount,"org : !x!x!        : !"); *)

    maxsectororg := maxSectorInTrack; (* 63 = 111111b *)
    scount       := maxsectororg - minsector +1;

    CASE BESTFIT OF
    | FORCEBEST: hh:= maxheadcount; (* 255 *)
    | FORCE255:  hh:= 255;
    | FORCE240:  hh:= 240;
    ELSE
                 hh:= maxheadcount; (* should never happen *)
    END;
    hcount       := hh;
    maxheadorg   := hcount + minhead -1;

    blockcount   := blockcount DIV LONGCARD (scount);
    blockcount   := blockcount DIV LONGCARD (hcount);
    IF blockcount > MAX(CARDINAL) THEN
        maxtrackorg  :=t;
        maxheadorg   :=h;
        maxsectororg :=s;
        rc:=FALSE;
(* WrStr("pb"+nl); *)
    ELSE
        maxtrackorg := CARDINAL (blockcount+mintrack-1);
        tcount:=maxtrackorg - mintrack +1;
        rc:=TRUE;
(* dbggeom(tcount,hcount,scount,0,"new : !x!x!"); *)
    END;
    RETURN rc;
END forceTrack63;

(* ------------------------------------------------------------ *)

TYPE
    QWORD = RECORD
        lo:LONGWORD;
        hi:LONGWORD;
    END;
    XBIOSinfotype = RECORD
        bufsize         : WORD;   (* always $1A here because v1.x call *)
        flag            : WORD;
        cylinders       : LONGWORD;  (* physical *)
        heads           : LONGWORD;  (* id. *)
        sectorsPerTrack : LONGWORD;  (* id. *)
        totalSectors    : QWORD;
        bytesPerSector  : WORD;
        EDDdata         : LONGWORD;  (* unused because we only call v1.x function *)
    END;

PROCEDURE encodeCS (cylinder,sector:WORD; VAR bcylinder,bsector:BYTE);
CONST
    maskKeepLo = WORD(000FFH); (* 0000000011111111 *)
    maskKeepHi = WORD(0FF00H); (* 1111111100000000 *)
VAR
    v : WORD;
BEGIN
    v := cylinder AND maskKeepLo;
    bcylinder := BYTE(v);
    v := cylinder AND maskKeepHi;
    v := v >> WORD(2);
    bsector := BYTE(v) OR BYTE(sector);
END encodeCS;

PROCEDURE decodeCS (bcylinder,bsector:BYTE; VAR vcylinder,vsector:WORD);
CONST
    maskKeepSector = BYTE(03FH); (* 00111111 *)
    maskKeepCylinder=BYTE(0C0H); (* 11000000 *)
VAR
    v : BYTE;
BEGIN
    v := bsector AND maskKeepSector;
    vsector := WORD(v);
    v := bsector AND maskKeepCylinder;
    vcylinder := WORD(v) << WORD(2);
    vcylinder := vcylinder OR WORD(bcylinder);
END decodeCS;

PROCEDURE resetUnit (HDTOO:BOOLEAN;unit:BYTE):BOOLEAN ;
VAR
    R : SYSTEM.Registers;
    rc:BOOLEAN;
BEGIN
    IF isFloppy(unit) THEN
        R.AH := 00H; (* reset disk system *)
        R.DL := unit;
        Lib.Intr (R,13H);
        rc:=( NOT (SYSTEM.CarryFlag IN R.Flags) );
    ELSE
        IF HDTOO THEN
            R.AH := 0DH; (* reset hard disk *)
            R.DL := unit;
            Lib.Intr (R,13H);
            rc:= NOT (SYSTEM.CarryFlag IN R.Flags);
        ELSE
            rc:=TRUE; (* we won't reset hard disk *)
        END;
    END;
    IF NOT(rc) THEN getFatalStatus(unit);END;
    RETURN rc;
END resetUnit;

PROCEDURE chkExtendedSupport (unit:BYTE;
                             VAR EDDmajor,EDDflag:BYTE ):BOOLEAN;
VAR
    R : SYSTEM.Registers;
    ok: BOOLEAN;
BEGIN
    IF isFloppy(unit) THEN RETURN FALSE; END;
    ok:=FALSE;
    R.AH := 41H; (* installation check *)
    R.BX := 55AAH;
    R.DL := unit;
    Lib.Intr (R,13H);
    IF NOT (SYSTEM.CarryFlag IN R.Flags) THEN
        IF R.BX = 0AA55H THEN
            IF (R.CX AND 0001H)=0001H THEN (* extended disk access functions (AH=42h-44h,47h,48h) supported *)
                EDDmajor:=R.AH;
                EDDflag :=BYTE (R.CX AND 07H); (* we care about bits 0..2 i.e. %111 *)
                ok:=TRUE;
            END;
        END;
    END;
    IF NOT(ok) THEN getFatalStatus(unit);END;
    RETURN ok;
END chkExtendedSupport;

PROCEDURE getXBIOSvalues (VAR cyl,head,sec,bps:WORD;VAR totalSectors:LONGWORD;
                         v:XBIOSinfotype):BOOLEAN;
VAR
    n:CARDINAL;
BEGIN
    n:=0;
    IF v.bytesPerSector  # WORD(sectorSize)    THEN INC(n);END;
    IF v.cylinders       > LONGWORD(MAX(WORD)) THEN INC(n);END;
    IF v.heads           > LONGWORD(MAX(WORD)) THEN INC(n);END;
    IF v.sectorsPerTrack > LONGWORD(MAX(WORD)) THEN INC(n);END;
    IF n # 0 THEN RETURN FALSE; END;

    cyl :=WORD( v.cylinders);
    head:=WORD( v.heads);
    sec :=WORD( v.sectorsPerTrack);
    bps :=WORD( v.bytesPerSector);

    totalSectors:=v.totalSectors.lo; (* we won't handle more than LONGCARD here *)

    (* don't forget to normalize counts for 0.. range ! *)

    DEC (cyl);
    DEC (head);
    RETURN TRUE;
END getXBIOSvalues;

(*
    CH = low eight bits of maximum cylinder number
    CL = maximum sector number (bits 5-0)
         high two bits of maximum cylinder number (bits 7-6)

    the maximum cylinder number reported in CX is usually two less than
    the total cylinder count reported in the fixed disk parameter table
    (see INT 41h,INT 46h) because early hard disks used the last cylinder
    for testing purposes; however, on some Zenith machines, the maximum
    cylinder number reportedly is three less than the count in the fixed
    disk parameter table.
    for BIOSes which reserve the last cylinder for testing purposes, the
    cylinder count is automatically decremented

    SeeAlso: INT 41"HARD DISK 0"
*)

CONST
    rcNoProblemo       = 0;
    rcPhantom          = 1;
    rcInt13h           = 2;
    rcXBIOSint13h      = 3;
    rcXBIOSvalues      = 4;
    rcWrongTHSgeometry = 5;

PROCEDURE chkTHSgeometry (maxTrack,maxHead,maxSector:CARDINAL):BOOLEAN;
VAR
    i,pb,v:CARDINAL;
BEGIN
    pb:=0;
    FOR i:=1 TO 3 DO
        CASE i OF
        | 1: v:=maxTrack;
        | 2: v:=maxHead;
        | 3: v:=maxSector;
        END;
        CASE v OF
        | 0 , MAX(CARDINAL): INC(pb);
        END;
    END;
    RETURN (pb = 0);
END chkTHSgeometry;

PROCEDURE buildtotal (maxtrack,maxhead,maxsector:CARDINAL):LONGCARD;
VAR
    trackcount,headcount,sectorcount:CARDINAL;
    blockcount,totalSectors : LONGCARD;
BEGIN
    trackcount := maxtrack -mintrack +1;
    headcount  := maxhead  -minhead  +1;
    sectorcount:= maxsector-minsector+1;
    blockcount := LONGCARD(trackcount)*LONGCARD(headcount)*LONGCARD(sectorcount);
    totalSectors := blockcount;
(*
WrStr("::: maxtrack     = ");IO.WrCard(maxtrack,0);WrLn;
WrStr("::: maxhead      = ");IO.WrCard(maxhead,0);WrLn;
WrStr("::: maxsector    = ");IO.WrCard(maxsector,0);WrLn;
WrStr("::: totalSectors = ");IO.WrLngCard(totalSectors,0);WrLn;
*)
    RETURN totalSectors;
END buildtotal;

(* ------------------------------------------------------------ *)
(* ------------------------------------------------------------ *)

PROCEDURE trydiv (VAR q : LONGCARD ;v,d:LONGCARD):BOOLEAN ;
BEGIN
    q := v DIV d;
(*
WrStr("value = ");WrLngCard(v,0);
WrStr("  divisor = ");WrLngCard(d,0);
WrStr("  quotient = ");WrLngCard(q,0);WrLn;
*)
    RETURN ( v = (q * d) );
END trydiv;

CONST
    minfactentry = 0;
    maxfactentry = 1;
    minfactor    = 1;    (* so we can flag using minfactor-1=0 *)
    maxfactor    = 32+1; (* should do for at most 2^32 ! *)
TYPE
    factortype = RECORD
       k    : LONGCARD;
       flag : BOOLEAN;
    END;
VAR
    factor : ARRAY[minfactentry..maxfactentry] , [minfactor..maxfactor] OF factortype;

PROCEDURE factorize (where:CARDINAL; v:LONGCARD):CARDINAL;
VAR
    i,ndx:CARDINAL;
    quotient, divisor,added : LONGCARD;
BEGIN
    ndx:=minfactor-1;
    (* handle trivial cases *)
    IF v = 0 THEN RETURN ndx; END;
    IF v = 1 THEN
        INC(ndx);
        factor[where][ndx].k:=v;
        factor[where][ndx].flag:=TRUE;
        RETURN ndx;
    END;

    FOR i:=1 TO 2 DO
        CASE i OF
        | 1: divisor := 2;
        | 2: divisor := 3;
        END;
        LOOP
            IF trydiv (quotient, v,divisor) THEN
                INC(ndx);
                IF ndx > maxfactor THEN RETURN minfactor-1; END; (* should never happen *)
                factor[where][ndx].k:=divisor;
                factor[where][ndx].flag:=TRUE;
                v:=quotient;
                IF quotient < divisor THEN RETURN ndx; END;
            ELSE
                EXIT;
            END;
        END;
    END;

    (*
    after 2 and 3, gen next prime (5, 7, 11, 13, 17, 19, 23, 25, 29, 31...)
    by adding alternatively 2 then 4 to previous value
    *)

    added := 2;
    INC(divisor,added); (* 3+2=5 *)
    LOOP
        IF trydiv (quotient,v,divisor) THEN
            INC(ndx);
            IF ndx  > maxfactor THEN RETURN minfactor-1; END;
            factor[where][ndx].k   :=divisor;
            factor[where][ndx].flag:=TRUE;
            v:=quotient;
            IF quotient < divisor THEN RETURN ndx; END;
        ELSE
            INC(divisor,added);
            IF added=2 THEN
                added:=4;
            ELSE (* is 4 *)
                added:=2;
            END;
        END;
    END;

    RETURN ndx;
END factorize;

PROCEDURE findinfact (where,ndx:CARDINAL; limit:LONGCARD):LONGCARD;
VAR
    v, k: LONGCARD;
    i : CARDINAL;
BEGIN
    (*
    (* lazy eval : we don't find highest value here *)
    v := 1;
    i := minfactor-1;
    LOOP
        INC(i);
        IF i > ndx THEN EXIT; END;
        IF factor[where][i].flag THEN
            k:=factor[where][i].k;
            IF v * k <= limit THEN
                factor[where][i].flag := FALSE; (* no longer useable *)
                v := v * k;
            ELSE
                EXIT;
            END;
        END;
    END;
    *)
    v := 1;
    i := ndx+1;
    LOOP
        DEC(i);
        IF i < minfactor THEN EXIT; END;
        IF factor[where][i].flag THEN
            k:=factor[where][i].k;
            IF v * k <= limit THEN
                factor[where][i].flag := FALSE; (* no longer useable *)
                v := v * k;
            END;
        END;
    END;
    RETURN v;
END findinfact;

(* ------------------------------------------------------------ *)
(* ------------------------------------------------------------ *)

PROCEDURE buildTHSfromTOTAL (VAR maxTrack,maxHead,maxSector:WORD;
                            BESTFIT:CARDINAL;totalSectors:LONGCARD ):BOOLEAN;
CONST
    maxsectorcount    = 63;
    maxsectorcountalt = 255; (* desperate try to keep CARDINALs everywhere *)
    maxheadcount      = 255;
    maxtrackcount     = MAX(LONGCARD);
VAR
    rebuilt,v,quotient:LONGCARD;
    t,h,s,smax:LONGCARD;
    headcount,trackcount,sectorcount:CARDINAL;
    retry,ndx,ndxref:CARDINAL;
    rc:BOOLEAN;
BEGIN
    rc:=TRUE;
    retry := 1;
    LOOP
        v:=totalSectors;
        CASE retry OF
        | 1 :
            s:=maxsectorcount; (* try 63 first *)
            IF trydiv(quotient, v,s) THEN
                v:=quotient;
            ELSE
                s:=0;
            END;
            smax := maxsectorcount;
        | 2 :
            s:=0;
            smax := maxsectorcountalt;
        END;
        (*
        FOR now, don't care about BESTFIT which is a BAD idea here
        CASE BESTFIT OF (* should always be FORCEBEST *)
        | FORCEBEST : h:=16;
        | FORCE255:   h:=255;
        | FORCE240:   h:=240;
        ELSE
                      h:=16; (* safety *)
        END;
        *)
        ndx:=factorize(minfactentry,v);

        IF s = 0 THEN s:=findinfact(minfactentry,ndx,smax);END;
        h:=findinfact(minfactentry,ndx,maxheadcount);
        t:=findinfact(minfactentry,ndx,maxtrackcount);

        trackcount  := CARDINAL(t);
        headcount   := CARDINAL(h);
        sectorcount := CARDINAL(s);

        rebuilt     := LONGCARD(trackcount) * LONGCARD(headcount) * LONGCARD(sectorcount); (* safety *)
        IF rebuilt = totalSectors THEN EXIT; END;
        INC(retry);
        IF retry > 2 THEN rc:=FALSE; EXIT; END;
    END;
    maxTrack    := trackcount + mintrack -1;
    maxHead     := headcount  + minhead  -1;
    maxSector   := sectorcount+ minsector-1;
    RETURN rc;
END buildTHSfromTOTAL;

(* ------------------------------------------------------------ *)

PROCEDURE getGeometry (unit:BYTE;XBIOS,FIXBADTHS:BOOLEAN;BESTFIT:CARDINAL;
                      VAR maxTrack,maxHead,maxSector,bytesPerSector:WORD;
                      VAR totalSectors:LONGWORD):CARDINAL;
VAR
    R : SYSTEM.Registers;
    bcylinder,bsector:BYTE;
    XBIOSinfo:XBIOSinfotype;
    rc:CARDINAL;
    good:BOOLEAN;
BEGIN
    IF isFloppy(unit) THEN XBIOS:=FALSE; END; (* safety, though it is already trapped *)

    IF XBIOS THEN
        XBIOSinfo.bufsize := 1AH; (* $1A v1.x or $1E v2.x *)

        R.AH := 48H; (* get drive parameters *)
        R.DL := unit;
        R.DS := Seg(XBIOSinfo); (* was seg(faraddress()) *)
        R.SI := Ofs(XBIOSinfo);
        Lib.Intr (R,13H);
        (* IF BYTE(R.AH) = BYTE(00H) THEN *)
        IF NOT (SYSTEM.CarryFlag IN R.Flags) THEN
            IF getXBIOSvalues (maxTrack,maxHead,maxSector,
                              bytesPerSector,totalSectors,XBIOSinfo) THEN
                rc:=rcNoProblemo;
            ELSE
                rc:=rcXBIOSvalues;
            END;
        ELSE
            rc:=rcXBIOSint13h;
        END;
    ELSE
        R.ES := 0;
        R.DI := 0; (* guard against BIOS bugs, according to canonical intlist.zip *)
        R.AH := 08H; (* get drive parameters *)
        R.DL := unit;
        Lib.Intr (R,13H);
        (* IF BYTE(R.AH) = BYTE(00H) THEN *)
        IF NOT (SYSTEM.CarryFlag IN R.Flags) THEN
            (*
            mask bit 7 only ! compare $00,$01,$80,$81 with number of drives
            in fact, useful for floppies only, because phantom hd trapped by error
            *)
            IF ((CARDINAL(unit) AND 7FH)+1) > CARDINAL(R.DL) THEN
                rc:=rcPhantom;
            ELSE
                bcylinder:=R.CH;
                bsector  :=R.CL;
                decodeCS(bcylinder,bsector,maxTrack,maxSector);
                maxHead:=WORD(R.DH);
                totalSectors := buildtotal(maxTrack,maxHead,maxSector);
                rc:=rcNoProblemo;
            END;
        ELSE
            rc:=rcInt13h;
        END;
    END;
    IF rc = rcNoProblemo THEN
        IF chkTHSgeometry(maxTrack,maxHead,maxSector) = FALSE THEN
            IF FIXBADTHS THEN
                good:=buildTHSfromTOTAL(maxTrack,maxHead,maxSector, BESTFIT,totalSectors);
                IF good THEN
                    rc:=rcNoProblemo;
                ELSE
                    rc:=rcWrongTHSgeometry;
                END;
            ELSE
                rc:=rcWrongTHSgeometry;
            END;
        END;
    ELSE
        getFatalStatus(unit);
    END;
    RETURN rc;
END getGeometry;

PROCEDURE fixGeometry (unit:BYTE;XBIOS,FORCESECTORCOUNT:BOOLEAN;BESTFIT:CARDINAL;
                      maxtrackorg,maxheadorg,maxsectororg:CARDINAL;
                      totalSectors:LONGCARD;
                      VAR maxtrack,maxhead,maxsector:CARDINAL;
                      VAR maxblock:LONGCARD;
                      VAR trackcount,headcount,sectorcount:CARDINAL;
                      VAR blockcount:LONGCARD;
                      VAR fixTHSneeded,fixedPerfect:BOOLEAN):CARDINAL;
VAR
    v:LONGCARD;
    rc:BOOLEAN;
BEGIN
    fixTHSneeded:=FALSE;
    IF isFloppy(unit) THEN XBIOS:=FALSE; END; (* safety, though it is already trapped *)

(* dbggeom(maxtrackorg,maxheadorg,maxsectororg,totalSectors,":::   !x!x!  total = !"); *)
    (* IF XBIOS THEN *)
        IF FORCESECTORCOUNT THEN
            rc:=forceTrack63(BESTFIT,totalSectors,maxtrackorg,maxheadorg,maxsectororg);
        END;
    (* END; *)
(* dbggeom(maxtrackorg,maxheadorg,maxsectororg,totalSectors,"+++   !x!x!  total = !"); *)

    maxtrack   := maxtrackorg;
    maxhead    := maxheadorg;
    maxsector  := maxsectororg;

    trackcount := maxtrack -mintrack +1;
    headcount  := maxhead  -minhead  +1;
    sectorcount:= maxsector-minsector+1;

    blockcount := LONGCARD(trackcount)*LONGCARD(headcount)*LONGCARD(sectorcount);
    maxblock   := blockcount-1+minblock;

    IF XBIOS THEN
        fixTHSneeded := (blockcount # totalSectors); (* NEWGEOMETRY *)
        IF FORCESECTORCOUNT THEN
            rc:=FALSE;
        ELSE
            rc:=fixTHSneeded;
        END;
        IF rc THEN
            (* rebuild THS from totalSectors assuming maxsectororg is correct and trying 256 heads *)
            (* should we assume 255 heads or finds a better matching product ? *)
            blockcount := totalSectors;
            maxblock   := blockcount-1+minblock;

            v:=blockcount; (* T*H*S *)
            v:=v DIV LONGCARD(sectorcount); (* T*H *)

            findBestFactors(BESTFIT,v,LONGCARD(maxheadcount), headcount,trackcount);

            maxhead    := headcount  + minhead  -1;
            maxtrack   := trackcount + mintrack -1;

            (*
            v := LONGCARD(trackcount)*LONGCARD(headcount)*LONGCARD(sectorcount);
            IF v # blockcount THEN RETURN errFixGeometry;END;
            *)
        END;
    END;

    v:=LONGCARD(trackcount) * LONGCARD(headcount) * LONGCARD(sectorcount);
    fixedPerfect := (blockcount = v);

(* dbggeom(maxtrack,maxhead,maxsector,blockcount,"===   !x!x!  blocks= !"); *)

    RETURN errNone;
END fixGeometry;

(* ------------------------------------------------------------ *)

CONST
    opRead  = BYTE(02H);
    opWrite = BYTE(03H);

TYPE
    diskAddressPacketType = RECORD
        packetsize : BYTE;
        reserved   : BYTE; (* must be $00 *)
        count      : WORD; (* number of blocks to transfer: updated after call *)
        (* DWORD : transfer buffer *)
        ofsBuf     : WORD;
        segBuf     : WORD;
        startblock : QWORD; (* starting absolute block number *)
        (*
           for non-LBA devices, compute as
           (Cylinder*NumHeads + SelectedHead) * SectorPerTrack +
           SelectedSector - 1
        *)
    END;

PROCEDURE rwCHS (unit:BYTE;XBIOS:BOOLEAN;command:BYTE;block:LONGCARD;
                track,head,sector,count,bufsegment,bufoffset:CARDINAL):BYTE;
VAR
    R : SYSTEM.Registers;
    bcylinder,bsector,LBAcmd:BYTE;
    dap:diskAddressPacketType;
BEGIN
    CASE command OF
    | opRead : ; (* let it be ! *)
    | opWrite: ; (* let is be ! *)
(*%F ENABLEREALUPDATE *)
        command:=opRead; (* don't take chances with hard disk ! *)
(*%E  *)
    ELSE
        RETURN BYTE(0FFH); (* do nothing and force a problem *)
    END;


    IF XBIOS THEN

        IF DEBUG THEN logLowLevel(unit,command,XBIOS,block,track,head,sector,count,bcylinder,bsector); END;

        dap.packetsize:=10H;
        dap.reserved  :=00H;
        dap.count     :=count;       (* $7f at most ! *)
        dap.segBuf    :=bufsegment;
        dap.ofsBuf    :=bufoffset;
        dap.startblock.lo:=block; (* assume our qword is a longword *)
        dap.startblock.hi:=0;
        CASE command OF
        | opRead:
            LBAcmd:=42H;
        | opWrite:
            LBAcmd:=43H;
            R.AL  :=00H; (* no verify, and we don't care about v2.1 ! *)
        END;
        R.AH:=LBAcmd;
        R.DL:=unit;
        R.DS:=Seg(FarADDRESS(dap));
        R.SI:=Ofs(FarADDRESS(dap));
        Lib.Intr(R,13H);
        (* IF NOT (SYSTEM.CarryFlag IN R.Flags) THEN *)
            RETURN (R.AH); (* 00H *)
        (* ELSE
            RETURN (R.AH);
        END; *)
    ELSE
        encodeCS(track,sector, bcylinder,bsector);

        IF DEBUG THEN logLowLevel(unit,command,XBIOS,block,track,head,sector,count,bcylinder,bsector); END;

        R.DL := unit;
        R.AH := command;
        R.AL := BYTE(count);
        R.CH := bcylinder;
        R.DH := BYTE(head);
        R.CL := bsector;   (* contains cyl data too *)
        R.ES := bufsegment;   (* buffer segment *)
        R.BX := bufoffset;    (* buffer offset *)
        Lib.Intr (R,13H);
        RETURN (R.AH);
    END;
END rwCHS;

(*
Notes:  errors on a floppy may be due to the motor failing to spin up quickly
        enough; the read should be retried at least three times, resetting
        the disk with AH=00h between attempts
*)

PROCEDURE procSector (unit:BYTE;XBIOS:BOOLEAN;opKode:BYTE;
                     block:LONGCARD;track,head,sector,bufsegment,bufoffset:CARDINAL):BOOLEAN;
CONST
    maxretry = 3;
VAR
    retry : CARDINAL;
    rc    : BOOLEAN;
BEGIN
    rc := FALSE;
    IF isFloppy(unit) THEN
        retry := 0;
        LOOP
            IF rwCHS(unit,XBIOS,opKode,block,track,head,sector,oneSector,
                     bufsegment,bufoffset) = BYTE(00H) THEN rc:=TRUE; EXIT;END;
            INC(retry);
            IF retry = maxretry THEN EXIT;END;
            IF resetUnit(RESETHD,unit)=FALSE THEN EXIT;END;
        END;
    ELSE
(*%F ENABLEREALUPDATE  *)
        opKode := opRead; (* don't take chances with hard disk ! *)
(*%E  *)
        IF rwCHS(unit,XBIOS,opKode,block,track,head,sector,oneSector,
                 bufsegment,bufoffset) = BYTE(00H) THEN rc:=TRUE;END;
    END;
    IF NOT(rc) THEN getFatalStatus(unit);END;
    RETURN rc;
END procSector;

(* ------------------------------------------------------------ *)
(* ------------------------------------------------------------ *)

CONST
    CHKEVERY = 256; (* let's call chkEscape every CHKEVERY loop *)

PROCEDURE showDiff (VAR chkrounds:CARDINAL; addr : CARDINAL;ref,now : BYTE):BOOLEAN;
VAR
    S:str128;
BEGIN
    Str.Concat(S, sNADA, fmt(addr,16,4,"0","$") );
    Str.Append(S, " : ");
    Str.Append(S, fmt(CARDINAL(ref),16,2,"0",""));
    Str.Append(S," --> ");
    Str.Append(S, fmt(CARDINAL(now),16,2,"0",""));
    Str.Append(S,"   ");
    Str.Append(S,fmtchar(TRUE,ref));
    Str.Append(S," --> ");
    Str.Append(S,fmtchar(TRUE,now));
    WrStr(sDIFF);WrStr(S);WrLn;

    INC(chkrounds);
    IF (chkrounds MOD CHKEVERY) = 0 THEN
        RETURN ChkEscape();
    ELSE
        RETURN FALSE;
    END;
END showDiff;

(* ------------------------------------------------------------ *)

PROCEDURE getkbd (VAR c1,c2:CHAR);
BEGIN
    BiosFlushkey(); (* useless against DOSKEY ! *)
    BiosWaitkey(c1,c2);
END getkbd;

(* we can use video here because we know redirection cannot happen here *)

PROCEDURE ShallWeProceed (firsttime:BOOLEAN; src:ARRAY OF CHAR):BOOLEAN;
CONST
    acceptA = "<^F9>"; acceptA1 = CHR(0); acceptA2 = CHR(102);
    acceptB = "<^F1>"; acceptB1 = CHR(0); acceptB2 = CHR(94);
VAR
    S : str128;
    c1,c2 , expected1,expected2:CHAR;
BEGIN
    CASE firsttime OF
    | TRUE:
        IF same(src,"") THEN
            S:=sNOTICE+acceptA+" to perform requested operation : ";
        ELSE
            Str.Concat(S,sNOTICE+acceptA+" to update object with ",src);
            Str.Append(S," : " );
        END;
        expected1:=acceptA1;
        expected2:=acceptA2;
    | FALSE:
        IF same(src,"") THEN
            S:=sNOTICE+"Now, "+acceptB+" to _perform_ requested operation : ";
        ELSE
            Str.Concat(S,sNOTICE+"Now, "+acceptB+" to _update_ object with ",src);
            Str.Append(S," : " );
        END;
        expected1:=acceptB1;
        expected2:=acceptB2;
    END;
    video(S,TRUE);
    getkbd(c1,c2);
    video(S,FALSE);
    IF ((c1=expected1) AND (c2=expected2) ) THEN
        RETURN TRUE;
    ELSE
        RETURN FALSE;
    END;
END ShallWeProceed;

PROCEDURE queryUser (AUTOCONFIRM:BOOLEAN;msg,src:ARRAY OF CHAR):BOOLEAN;
VAR
    letsdoit:BOOLEAN;
BEGIN
    IF AUTOCONFIRM THEN
        letsdoit := TRUE;
    ELSE
        dmp(msg);
        letsdoit := FALSE;
        IF ShallWeProceed(TRUE, src) THEN
            IF ShallWeProceed(FALSE, src) THEN
                (* dmp(sINFO+"Update confirmed twice !"); *)
                letsdoit:=TRUE;
            ELSE
                dmp(sCANCELLED+"Update cancelled"); (* " at second thought" *)
            END;
        ELSE
            dmp(sCANCELLED+"Update cancelled");
        END;
    END;
    RETURN letsdoit;
END queryUser;

(* ------------------------------------------------------------ *)

PROCEDURE chkFixExtension (VAR R:ARRAY OF CHAR) : BOOLEAN;
CONST
    reservedList = "COM,EXE,BAT,SYS,OVL,OVR,TXT,DOC,DLL";
    delim        = ",";
BEGIN
    IF R[0] = dot THEN Str.Delete(R,0,1);END;
    CASE Str.Length(R) OF
    | 1..3 :
        IF getStrIndex(delim,R,reservedList) # 0 THEN RETURN FALSE; END;
        IF verifyString(R,DOScharset)=FALSE THEN RETURN FALSE;END;
        Str.Prepend(R,dot);
        RETURN TRUE;
    ELSE
        RETURN FALSE;
    END;
END chkFixExtension;

(*
    assume path is in UPPERCASE ! legal variations upon u:\...\...

    .       use current path
      \xxx  prepend current unit
       xxx  prepend current path
    .\xxx   prepend current path

    u:\xxx  ok
    u:xxx   insert current path for u:
    u:.     use current path for u:
    u:      use current path for u: too even though it's ugly because no directory explicitely specified
    u:.\xxx insert current path for u:
*)

PROCEDURE buildCanonicalPath (base:ARRAY OF CHAR; VAR R : ARRAY OF CHAR):BOOLEAN;
VAR
    p         : CARDINAL;
    drive     : SHORTCARD;
    unit      : CHAR;
    S         : str128;
BEGIN
    p := Str.CharPos(R,colon);
    CASE p OF
    | 1 :                               (* unit specified *)
        IF CharCount(R,colon) # 1 THEN RETURN FALSE; END; (* more than one ":" *)

        IF R[0]=base[0] THEN
            Str.Copy(S,base);           (* current path of current unit again *)
        ELSE
            drive := SHORTCARD( ORD(R[0])-ORD("A")+1 );
            unit  := CHR(drive + ORD("A") -1 );
            FIO.GetDir(drive,S);
            Str.Prepend(S,colon);
            Str.Prepend(S,unit);
            fixDirectory(S);            (* u:\path\ *)
        END;

        CASE R[2] OF
        | dot :
            IF Str.Length(R)=3 THEN                      (* "U:." *)
                Str.Copy(R,S);
                RETURN TRUE;
            END;
            IF R[3] # backslash THEN RETURN FALSE; END;
            Str.Delete(R,0,4);                           (* "U:.\XXX" *)
            Str.Prepend(R,S);
        | backslash :                                    (* "U:\XXX" *)
            ; (* do nothing ! *)
        ELSE                                             (* "U:XXX" or "U:" *)
            Str.Delete(R,0,2);
            Str.Prepend(R,S);
        END;
    | MAX(CARDINAL):                    (* no unit specified *)
        CASE R[0] OF
        | dot :
            IF Str.Length(R)=1 THEN                      (* "." *)
                Str.Copy(R,base);
                RETURN TRUE;
            END;
            IF R[1] # backslash THEN RETURN FALSE; END;
            Str.Delete(R,0,2);                           (* ".\XXX" *)
            Str.Prepend(R,base);
        | backslash :                                    (* "\XXX" *)
            Str.Prepend(R,colon);
            Str.Prepend(R,base[0]);
        ELSE
            Str.Prepend(R,base);                         (* "XXX" *)
        END;
    ELSE
        RETURN FALSE;                   (* illegal, for ":" is either absent or at 1 *)
    END;
    IF Str.Pos(R,netslash) # MAX(CARDINAL) THEN RETURN FALSE;END;
    fixDirectory(R);                    (* just in case *)
    RETURN TRUE;
END buildCanonicalPath;

PROCEDURE chkFixDirSpec (VAR R:ARRAY OF CHAR ):BOOLEAN ;
VAR
    n:CARDINAL;
    base:str128;
BEGIN
    getCurrentDirectory(base); (* "u:\*\" *)

    n:=0;
    IF CharCount(R,star) > 0 THEN INC(n); END;
    IF CharCount(R,question) > 0 THEN INC(n);END;
    IF Str.Pos(R,dotdot) # MAX(CARDINAL) THEN INC(n);END;
    IF Str.Pos(R,netslash) # MAX(CARDINAL) THEN INC(n);END;

    CASE CharCount(R,colon) OF
    | 0 : ;
    | 1 : IF Str.CharPos(R,colon) # 1 THEN INC(n); END;
    ELSE
        INC(n);
    END;
    IF buildCanonicalPath (base, R)=FALSE THEN INC(n);END;
    IF isDirectory(R)=FALSE THEN INC(n);END;
    RETURN (n=0);
END chkFixDirSpec;

PROCEDURE chkSignature (S:ARRAY OF CHAR):CARDINAL;
CONST
    valid = 0AA55H;
VAR
    hnd:FIO.File;
    pb,got,wanted,signature:CARDINAL;
    sigpos:LONGCARD;
BEGIN
    pb:=0;
    signature := 0; (* paranoia *)
    wanted := SIZE(signature);
    sigpos := LONGCARD (lastByteInSector - wanted +1); (* yes, we merely mean $1FE *)
    hnd:=FIO.OpenRead(S);
    FIO.Seek(hnd, sigpos);
    IF FIO.GetPos(hnd) # sigpos THEN INC(pb);END;
    got:=FIO.RdBin(hnd,signature,wanted);
    FIO.Close(hnd);
    IF got # wanted THEN INC(pb);END;
    IF signature # valid THEN INC(pb);END;
    IF pb = 0 THEN
        RETURN errNone;
    ELSE
        RETURN errSignature;
    END;
END chkSignature;

(* ------------------------------------------------------------ *)
(* ------------------------------------------------------------ *)

PROCEDURE validCMOSsize (v:LONGCARD):BOOLEAN;
VAR
    i:CARDINAL ;
    k:LONGCARD;
BEGIN
    FOR i:=1 TO 4 DO
        CASE i OF
        | 1: k:=64;
        | 2: k:=128; (* default *)
        | 3: k:=256;
        | 4: k:=512;
        END;
        IF v=k THEN RETURN TRUE; END;
    END;
    RETURN FALSE;
END validCMOSsize;

PROCEDURE IODELAY ();
CONST
    count = 100; (* was 10 *)
VAR
    i,k:CARDINAL;
BEGIN
    FOR i:=1 TO count DO
        k:=i;
    END; (* dummy for now, could be a Lib.Delay (15ms) ? *)
END IODELAY;

CONST
    undefinedCMOSsize = 0;
    defaultCMOSsize = 128;
    maxCMOSsize     = 512;
    CMOSfirstByte   = 1-1;
    maxCMOSlastByte = maxCMOSsize-1; (* was 128 *)
TYPE
    CMOSarrayType = ARRAY [CMOSfirstByte..maxCMOSlastByte] OF BYTE;
    CMOSstatusType = RECORD
        volatile : BOOLEAN; (* compare C *)
        restore  : BOOLEAN; (* restore W|U *)
    END;

VAR
    CMOSarray    : CMOSarrayType;
    CMOSarrayRef : CMOSarrayType;
    CMOSflag     : ARRAY [CMOSfirstByte..maxCMOSlastByte] OF CMOSstatusType;

CONST
    RTCaddrPort = 70H;
    RTCdataPort = 71H;
    DisableNMI  = 80H;
    EnableNMI   = 00H;
    SafeCMOSaddr= 0DH; (* status D register, battery power *)

(*

0072  RW  CMOS memory address, region 2 (256 bytes)
0073  RW  CMOS memory data, region 2

0074  RW  CMOS memory address, region 3 (256 bytes)
0075  RW  CMOS memory data, region 3

//FIXME : good old Ralf does not agree with CMOSpwd !

*)

PROCEDURE getIOfix ( addr:CARDINAL ):CARDINAL ;
VAR
    k:CARDINAL;
BEGIN
    CASE addr OF
    |   0..128-1: k:=0; (* $70 $71 *)
    | 128..256-1: k:=2; (* $72 $73 *)
    | 256..384-1: k:=4; (* $74 $75 *)
    | 384..512-1: k:=6; (* $76 $77 *)
    ELSE
                  k:=0; (* safety *)
    END;
    RETURN k;
END getIOfix;

PROCEDURE ReadFromCMOS (addr : CARDINAL) : CARDINAL;
VAR
    got : SHORTCARD;
    k:CARDINAL;
BEGIN
    k:=getIOfix(addr);
    SYSTEM.DI;
    SYSTEM.Out ( RTCaddrPort+k,SHORTCARD(addr + DisableNMI) );
    IODELAY;
    got := SYSTEM.In(RTCdataPort+k);
    IODELAY;
    SYSTEM.Out ( RTCaddrPort+k,SHORTCARD(SafeCMOSaddr + EnableNMI));
    SYSTEM.EI;
    RETURN CARDINAL(got);
END ReadFromCMOS;

PROCEDURE WriteToCMOS (addr : CARDINAL; value : CARDINAL );
VAR
    k:CARDINAL;
BEGIN
(*%T ENABLEREALUPDATE *)
    k:=getIOfix(addr);
    SYSTEM.DI;
    SYSTEM.Out ( RTCaddrPort+k,SHORTCARD(addr + DisableNMI) );
    IODELAY;
    SYSTEM.Out ( RTCdataPort+k,SHORTCARD(value) );
    IODELAY;
    SYSTEM.Out ( RTCaddrPort+k,SHORTCARD(SafeCMOSaddr + EnableNMI));
    SYSTEM.EI;
(*%E *)
END WriteToCMOS;





PROCEDURE CMOSisVolatile (addr:CARDINAL) : BOOLEAN;
VAR
    rc:BOOLEAN;
BEGIN
    (*
    CASE addr OF (* we used a SET but sometimes $3F was not taken into account *)
    | 0,1,2,3,4,5,6,7,8,9,0CH,032H,03FH :
        RETURN TRUE; (* ignore these addresses *)
    ELSE
        RETURN FALSE;
    END;
    *)
    rc:=CMOSflag[addr].volatile;
    RETURN rc;
END CMOSisVolatile;

PROCEDURE CMOScanBeRestored ( addr:CARDINAL ):BOOLEAN;
VAR
    rc:BOOLEAN;
BEGIN
    IF CMOSisVolatile(addr) THEN
        rc:=CMOSflag[addr].restore;
    ELSE
        rc:=TRUE;
    END;
    RETURN rc;
END CMOScanBeRestored;

CONST
    badCMOSaddr = MAX(CARDINAL);

PROCEDURE strToCMOSaddr(VAR restore:BOOLEAN; S:ARRAY OF CHAR):CARDINAL;
VAR
    base,p:CARDINAL;
    v:LONGCARD;
    ok:BOOLEAN;
BEGIN
    Str.Caps(S);

    (* check prefix *)

    CASE S[0] OF
    | "+" :
        restore:=TRUE;
        Str.Delete(S,0,1);
    ELSE
        restore:=FALSE;
    END;

    (* accepted now : $# 0X# #H  *)

    base:=16;
    IF    Str.Match(S,"$*") THEN
          Str.Delete(S,0,1);
    ELSIF Str.Match(S,"0X*") THEN
          Str.Delete(S,0,2);
    ELSIF Str.Match(S,"*H") THEN
          p:=Str.RCharPos(S,"H");
          S[p]:=nullchar;
    ELSE
        base:=10;
    END;
    v:=Str.StrToCard(S,base,ok);
    IF ok=FALSE THEN RETURN badCMOSaddr;END;

    IF v > MAX(CARDINAL) THEN RETURN badCMOSaddr;END;

    p:=CARDINAL(v);
    IF p < CMOSfirstByte THEN RETURN badCMOSaddr;END; (* silly ! *)
    IF p > maxCMOSlastByte  THEN RETURN badCMOSaddr;END;

    RETURN p;
END strToCMOSaddr;

PROCEDURE initCMOSvolatile (VAR R:ARRAY OF CHAR):CARDINAL;
VAR
    currline:CARDINAL;
    i,rc:CARDINAL;
    hin:FIO.File;
    ini,S:str128;
    restoreMe,ignoreMe,ok:BOOLEAN;
BEGIN
    rc:=errNone;
    Str.Copy(R,"");

    Lib.ParamStr(ini,0); (* retrieve executable location : yes, we assume it ! *)
    Str.Caps(ini); (* safety *)
    Str.Subst(ini,extEXE,extINI);

    IF FIO.Exists(ini) THEN
        ignoreMe:=FALSE;
        restoreMe:=TRUE;
        FOR i:=CMOSfirstByte TO maxCMOSlastByte DO
            CMOSflag[i].volatile := ignoreMe;
            CMOSflag[i].restore  := restoreMe;
        END;

        currline:=1;
        hin:=FIO.OpenRead(ini);
        FIO.AssignBuffer(hin,ioBufferIni);
        LOOP
            IF FIO.EOF THEN EXIT; END;
            FIO.RdStr(hin,S);
            LtrimBlanks(S);
            RtrimBlanks(S);

            CASE S[0] OF
            | nullchar,semicolon:
                ;
            ELSE
                i:=strToCMOSaddr( restoreMe,S );
                IF i = badCMOSaddr THEN (* "line ## of ?" *)
                    Str.CardToStr( LONGCARD(currline), R, 10,ok);
                    Str.Append(R," in ");
                    Str.Append(R,ini);
                    rc:=errCMOSiniProblem;
                    EXIT;
                ELSE
                    CMOSflag[i].volatile := TRUE;
                    CMOSflag[i].restore  := restoreMe;
                END;
            END;
            INC(currline);
        END;
        FIO.Close(hin);
    ELSE
        FOR i:=CMOSfirstByte TO maxCMOSlastByte DO
            CASE i OF
            | 0,1,2,3,4,5,6,7,8,9,0CH :
                ignoreMe:=TRUE;  restoreMe:=FALSE;
            | 032H,03FH :
                ignoreMe:=TRUE;  restoreMe:=TRUE;
            ELSE
                ignoreMe:=FALSE; restoreMe:=TRUE;
            END;
            CMOSflag[i].volatile := ignoreMe;
            CMOSflag[i].restore  := restoreMe;
        END;
    END;

    (*
    FOR i:=CMOSfirstByte TO CMOSlastByte DO
        IF CMOSisVolatile(i) THEN
            Str.CardToStr( LONGCARD(i), S,16,ok);
            IF i < 16 THEN Str.Prepend(S,"0");END;
            Str.Lows(S);
            WrStr("$"); WrStr(S); WrStr(" will not be compared");
            IF CMOScanBeRestored(i)=FALSE THEN WrStr(" nor restored");END;
            WrLn;
        END;
    END;
    *)
    (*
    FOR i:=CMOSfirstByte TO CMOSlastByte DO
        IF CMOScanBeRestored(i)=FALSE THEN
            Str.CardToStr( LONGCARD(i), S,16,ok);
            IF i < 16 THEN Str.Prepend(S,"0");END;
            Str.Lows(S);
            WrStr("$"); WrStr(S); WrStr(" will not be restored");WrLn;
        END;
    END;
    *)

    RETURN rc;
END initCMOSvolatile;



PROCEDURE grabCMOSfilesize (base,e3:ARRAY OF CHAR):LONGCARD;
VAR
    newcmossize:LONGCARD;
    S:str128;
    usedefault:BOOLEAN;
BEGIN
    Str.Concat(S,base,fileCMOS);Str.Append(S,e3); (* see saveCMOS() and chkFile() *)
    IF FIO.Exists(S) THEN
        newcmossize:=getFileSize(S);
        usedefault:= NOT ( validCMOSsize( newcmossize ) );
    ELSE
        usedefault:= TRUE;
    END;
    IF usedefault THEN newcmossize:=defaultCMOSsize; END;
    RETURN newcmossize;
END grabCMOSfilesize;

PROCEDURE getCMOSname(VAR R:ARRAY OF CHAR;newcmossize:LONGCARD);
CONST
    whatme = "CMOS";
BEGIN
    Str.Copy(R,whatme+" (~ bytes)" );
    Str.Subst(R,"~",fmtlc(newcmossize,10,1,"",""));
END getCMOSname;

(* ------------------------------------------------------------ *)
(* ------------------------------------------------------------ *)

PROCEDURE saveCMOS (newcmossize:LONGCARD;OVERWRITE,IGNORERO:BOOLEAN;base,e3:ARRAY OF CHAR):CARDINAL;
VAR
    target,what:str128;
    CMOSlastByte, i:CARDINAL;
    hnd:FIO.File;
BEGIN
    getCMOSname(what,newcmossize);

    CMOSlastByte:=CARDINAL(newcmossize)-1;
    CASE chkFile(target, OVERWRITE,IGNORERO,base,fileCMOS,e3) OF
    | errAlreadyRO:
        dmp5(sPROBLEM,what," not saved : ",target," is read-only !");
        RETURN errAlreadyRO;
    | errAlready:
        dmp5(sPROBLEM,what," not saved : ",target," already exists !");
        RETURN errAlready;
    END;

    FOR i := CMOSfirstByte TO CMOSlastByte DO
        CMOSarray[i] := BYTE ( ReadFromCMOS(i) );
    END;

    hnd := FIO.Create(target);
    FIO.AssignBuffer(hnd,ioBuffer);
    FIO.WrBin (hnd,CMOSarray, CARDINAL(newcmossize) );
    FIO.Flush(hnd);
    FIO.Close(hnd);

    dmp4(sOK,what," saved to ",target);
    RETURN errNone;
END saveCMOS;

PROCEDURE compCMOS (VAR mismatches:LONGCARD;
                   newcmossize:LONGCARD;VERBOSE:BOOLEAN;base,e3:ARRAY OF CHAR):CARDINAL;
VAR
    source,what:str128;
    CMOSlastByte, i,got:CARDINAL;
    hnd:FIO.File;
    ref,now:BYTE;
    expected:LONGCARD;
    chkrounds:CARDINAL;
BEGIN
    getCMOSname(what,newcmossize);

    CMOSlastByte:=CARDINAL(newcmossize)-1;
    (* expected:=SIZE(CMOSarrayRef); *)
    expected:=newcmossize;
    CASE chkFile(source, FALSE,FALSE,base,fileCMOS,e3) OF
    | errNotFound:
        dmp5(sPROBLEM,what," not compared : ",source," does not exist !");
        INC(mismatches); (* force an error *)
        RETURN errNotFound;
    END;
    CASE chkFileSize(source, expected) OF
    | errFileSize:
        dmp5(sPROBLEM,what," not compared : ",source," filesize does not match specified CMOS size !");
        INC(mismatches); (* force an error *)
        RETURN errFileSize;
    END;

    IF VERBOSE THEN dmp5(sINFO,"Comparing ",what," with ",source);END;

    hnd := FIO.OpenRead(source);
    FIO.AssignBuffer(hnd,ioBuffer);
    got:=FIO.RdBin (hnd,CMOSarrayRef, CARDINAL(expected) );
    FIO.Close(hnd);

    FOR i := CMOSfirstByte TO CMOSlastByte DO
        CMOSarray[i] := BYTE ( ReadFromCMOS(i) );
    END;

    chkrounds:=0;
    mismatches:=0;
    FOR i := CMOSfirstByte TO CMOSlastByte DO
        IF CMOSisVolatile(i)=FALSE THEN
            ref:=CMOSarrayRef[i];
            now:=CMOSarray[i];
            IF now # ref THEN
                IF VERBOSE THEN
                    IF mismatches=0 THEN donl; END;
                    IF showDiff(chkrounds,i,ref,now) THEN RETURN errAborted;END;
                END;
                INC (mismatches);
            END;
        END;
    END;
    IF mismatches = 0 THEN
        dmp3(sOK,what," match.");
        RETURN errNone;
    ELSE
        IF VERBOSE THEN donl; END;
        dmp3(sPROBLEM,what," do not match !");
        RETURN errMismatch;
    END;
END compCMOS;

PROCEDURE restoreCMOS (newcmossize:LONGCARD;REALLY,AUTOCONFIRM:BOOLEAN;base,e3:ARRAY OF CHAR):CARDINAL;
VAR
    hnd:FIO.File;
    source,what:str128;
    CMOSlastByte,i,got : CARDINAL;
    S:str128;
    expected:LONGCARD;
BEGIN
    getCMOSname(what,newcmossize);

    CMOSlastByte:=CARDINAL(newcmossize)-1;
    (* expected:=SIZE(CMOSarrayRef); *)
    expected:=newcmossize;
    CASE chkFile(source, FALSE,FALSE,base,fileCMOS,e3) OF
    | errNotFound:
        dmp6(sPROBLEM,"No attempt to restore ",what," : ",source," does not exist !");
        RETURN errNotFound;
    END;
    CASE chkFileSize(source, expected) OF
    | errFileSize:
        dmp6(sPROBLEM,"No attempt to restore ",what," : ",source," filesize does not match specified CMOS size !");
        RETURN errFileSize;
    END;

    S:=sWARN_CMOS;
    IF queryUser(AUTOCONFIRM,S,source)=FALSE THEN RETURN errCancel;END;

    hnd := FIO.OpenRead(source);
    FIO.AssignBuffer(hnd,ioBuffer);
    got:=FIO.RdBin (hnd,CMOSarrayRef, CARDINAL(expected) );
    FIO.Close(hnd);

IF REALLY THEN
    FOR i := CMOSfirstByte TO CMOSlastByte DO
        IF CMOScanBeRestored(i) THEN
            WriteToCMOS (i,CARDINAL (CMOSarrayRef[i]) );
        END;
    END;
    S:="";
ELSE
    S:=sFAKE;
END;

    dmp5(sOK,what," updated with ",source,S);
    RETURN errNone;
END restoreCMOS;

(* ------------------------------------------------------------ *)
(* ------------------------------------------------------------ *)

PROCEDURE readPartitionTable (XBIOS:BOOLEAN; unit:BYTE;
                             trackcount,headcount,sectorcount:CARDINAL):BOOLEAN;
VAR
    track,head,sector:CARDINAL;
    block:LONGCARD;
    rc:BOOLEAN;
BEGIN
    track   := mintrack;
    head    := minhead;
    sector  := minsector;
    CHStoBlock (trackcount,headcount,sectorcount,
               track,head,sector,
               block);

    IF NOT ( DYNALLOC ) THEN
    rc:= procSector (unit,XBIOS,opRead,block,track,head,sector,
                    Seg(buffPartitionTable),Ofs(buffPartitionTable));
    ELSE
    rc:= procSector (unit,XBIOS,opRead,block,track,head,sector,
                    Seg(pbuffPartitionTable^),Ofs(pbuffPartitionTable^));
    END;

    RETURN rc;
END readPartitionTable;

(* same as readPartitionTable but to another buffer ! *)

PROCEDURE readMasterBootRecord (XBIOS:BOOLEAN;unit:BYTE;
                               trackcount,headcount,sectorcount:CARDINAL):BOOLEAN;
VAR
    track,head,sector:CARDINAL;
    block:LONGCARD;
    rc:BOOLEAN;
BEGIN
    track   := mintrack;
    head    := minhead;
    sector  := minsector;
    CHStoBlock (trackcount,headcount,sectorcount,
               track,head,sector,
               block);

    IF NOT ( DYNALLOC ) THEN
    rc:= procSector (unit,XBIOS,opRead,block,track,head,sector,
                    Seg(buffMasterBoot),Ofs(buffMasterBoot));
    ELSE
    rc:= procSector (unit,XBIOS,opRead,block,track,head,sector,
                    Seg(pbuffMasterBoot^),Ofs(pbuffMasterBoot^));
    END;
    RETURN rc;
END readMasterBootRecord;

(* read specified block to buffExt *)

PROCEDURE readExtSector (XBIOS:BOOLEAN;
                         unit:BYTE;
                         trackcount,headcount,sectorcount:CARDINAL;
                         block:LONGCARD):BOOLEAN;
VAR
    track,head,sector:CARDINAL;
    rc:BOOLEAN;
BEGIN
    blockToCHS (trackcount,headcount,sectorcount,block,
                track,head,sector);

    IF NOT ( DYNALLOC ) THEN
    rc:= procSector (unit,XBIOS,opRead,block,track,head,sector,
                    Seg(buffExt),Ofs(buffExt));
    ELSE
    rc:= procSector (unit,XBIOS,opRead,block,track,head,sector,
                    Seg(pbuffExt^),Ofs(pbuffExt^));
    END;
    RETURN rc;
END readExtSector;

(* write buffExt to specified block *)

PROCEDURE writeExtSector (XBIOS:BOOLEAN;
                         unit:BYTE;
                         trackcount,headcount,sectorcount:CARDINAL;
                         block:LONGCARD):BOOLEAN;
VAR
    track,head,sector:CARDINAL;
    rc:BOOLEAN;
BEGIN
    blockToCHS (trackcount,headcount,sectorcount,block,
                track,head,sector);

    IF NOT ( DYNALLOC ) THEN
    rc:= procSector (unit,XBIOS,opWrite,block,track,head,sector,
                    Seg(buffExt),Ofs(buffExt));
    ELSE
    rc:= procSector (unit,XBIOS,opWrite,block,track,head,sector,
                    Seg(pbuffExt^),Ofs(pbuffExt^));
    END;
    RETURN rc;
END writeExtSector;

(* ------------------------------------------------------------ *)

PROCEDURE saveMBR (OVERWRITE,IGNORERO,XBIOS:BOOLEAN;
                  unit:BYTE;trackcount,headcount,sectorcount:CARDINAL;
                  base,e3:ARRAY OF CHAR):CARDINAL;
CONST
    what = "MBR";
VAR
    target:str128;
    hnd:FIO.File;
    track,head,sector:CARDINAL;
    block:LONGCARD;
    result:BOOLEAN;
BEGIN
    CASE chkFile(target, OVERWRITE,IGNORERO,base,fileMBR,e3) OF
    | errAlreadyRO:
        dmp4(sPROBLEM,what+" not saved : ",target," is read-only !");
        RETURN errAlreadyRO;
    | errAlready:
        dmp4(sPROBLEM,what+" not saved : ",target," already exists !");
        RETURN errAlready;
    END;

    track   := mintrack;
    head    := minhead;
    sector  := minsector;
    CHStoBlock (trackcount,headcount,sectorcount,
               track,head,sector,
               block);

    IF NOT ( DYNALLOC ) THEN
        result:=procSector (unit,XBIOS,opRead,block,track,head,sector,
                            Seg(buffMasterBoot),Ofs(buffMasterBoot));
    ELSE
        result:=procSector (unit,XBIOS,opRead,block,track,head,sector,
                            Seg(pbuffMasterBoot^),Ofs(pbuffMasterBoot^));
    END;
    IF result=FALSE THEN RETURN errInt13h; END;

    IF NOT ( DYNALLOC ) THEN
    IF DEBUG THEN dumpSector(showAsTable, SectorType(buffMasterBoot) );END;
    ELSE
    IF DEBUG THEN dumpSector(showAsTable, SectorType(pbuffMasterBoot^) );END;
    END;

    hnd := FIO.Create(target);
    FIO.AssignBuffer(hnd,ioBuffer);
    IF NOT ( DYNALLOC ) THEN
        FIO.WrBin (hnd,buffMasterBoot,SIZE(buffMasterBoot));
    ELSE
        FIO.WrBin (hnd,pbuffMasterBoot^,SIZE(pbuffMasterBoot^));
    END;
    FIO.Flush(hnd);
    FIO.Close(hnd);

    dmp3(sOK,what+" saved to ",target);
    RETURN errNone;
END saveMBR;

PROCEDURE compMBR (VAR mismatches:LONGCARD;
                  VERBOSE,XBIOS:BOOLEAN;
                  unit:BYTE;trackcount,headcount,sectorcount:CARDINAL;
                  base,e3:ARRAY OF CHAR):CARDINAL;
CONST
    what = "MBR";
VAR
    source:str128;
    hnd:FIO.File;
    i,got: CARDINAL;
    ref,now:BYTE;
    track,head,sector:CARDINAL;
    block:LONGCARD;
    expected:LONGCARD;
    chkrounds:CARDINAL;
    result:BOOLEAN;
BEGIN
    IF NOT ( DYNALLOC ) THEN
        expected:=SIZE(buffMasterBootRef);
    ELSE
        expected:=SIZE(pbuffMasterBootRef^);
    END;
    CASE chkFile(source, FALSE,FALSE,base,fileMBR,e3) OF
    | errNotFound:
        dmp4(sPROBLEM,what+" not compared : ",source," does not exist !");
        INC(mismatches); (* force an error *)
        RETURN errNotFound;
    END;
    CASE chkFileSize(source, expected) OF
    | errFileSize:
        dmp4(sPROBLEM,what+" not compared : ",source," filesize is not valid !");
        INC(mismatches); (* force an error *)
        RETURN errFileSize;
    END;

    IF VERBOSE THEN dmp3(sINFO,"Comparing "+what+" with ",source);END;

    hnd := FIO.OpenRead(source);
    FIO.AssignBuffer(hnd,ioBuffer);
    IF NOT ( DYNALLOC ) THEN
        got:=FIO.RdBin(hnd,buffMasterBootRef, CARDINAL(expected) );
    ELSE
        got:=FIO.RdBin(hnd,pbuffMasterBootRef^, CARDINAL(expected) );
    END;
    FIO.Close(hnd);

    track   := mintrack;
    head    := minhead;
    sector  := minsector;
    CHStoBlock (trackcount,headcount,sectorcount,
               track,head,sector,
               block);

    IF NOT ( DYNALLOC ) THEN
        result:=procSector (unit,XBIOS,opRead,block,track,head,sector,
                           Seg(buffMasterBoot),Ofs(buffMasterBoot));
    ELSE
        result:=procSector (unit,XBIOS,opRead,block,track,head,sector,
                           Seg(pbuffMasterBoot^),Ofs(pbuffMasterBoot^));
    END;
    IF result=FALSE THEN RETURN errInt13h; END;

    IF NOT ( DYNALLOC ) THEN
    IF DEBUG THEN dumpSector(showAsTable, SectorType(buffMasterBoot) );END;
    ELSE
    IF DEBUG THEN dumpSector(showAsTable, SectorType(pbuffMasterBoot^) );END;
    END;

    chkrounds:=0;
    mismatches:=0;
    FOR i := firstByteInSector TO lastByteInSector DO
        IF NOT ( DYNALLOC ) THEN
            ref:=buffMasterBootRef.bytearray[i];
            now:=buffMasterBoot.bytearray[i];
        ELSE
            ref:=pbuffMasterBootRef^.bytearray[i];
            now:=pbuffMasterBoot^.bytearray[i];
        END;
        IF now # ref THEN
            IF VERBOSE THEN
                IF mismatches=0 THEN donl; END;
                IF showDiff(chkrounds,i,ref,now) THEN RETURN errAborted;END;
            END;
            INC (mismatches);
        END;
    END;

    IF mismatches = 0 THEN
        dmp2(sOK,what+" match.");
        RETURN errNone;
    ELSE
        IF VERBOSE THEN donl; END;
        dmp2(sPROBLEM,what+" do not match !");
        RETURN errMismatch;
    END;
END compMBR;

PROCEDURE restoreMBR (REALLY,AUTOCONFIRM,NEWTABLE,XBIOS:BOOLEAN;
                     unit:BYTE;trackcount,headcount,sectorcount:CARDINAL;
                     base,e3:ARRAY OF CHAR):CARDINAL;
CONST
    what="MBR";
VAR
    source:str128;
    hnd:FIO.File;
    i,got:CARDINAL;
    S:str128;
    track,head,sector:CARDINAL;
    block:LONGCARD;
    expected:LONGCARD;
    result:BOOLEAN;
BEGIN
    IF NOT ( DYNALLOC ) THEN
        expected:= SIZE(buffMasterBootRef);
    ELSE
        expected:= SIZE(pbuffMasterBootRef^);
    END;
    CASE chkFile(source, FALSE,FALSE,base,fileMBR,e3) OF
    | errNotFound:
        dmp4(sPROBLEM,"No attempt to restore "+what+" : ",source," does not exist !");
        RETURN errNotFound;
    END;
    CASE chkFileSize(source, expected) OF
    | errFileSize:
        dmp4(sPROBLEM,"No attempt to restore "+what+" : ",source," filesize is not valid !");
        RETURN errFileSize;
    END;
    CASE chkSignature(source) OF
    | errSignature:
        dmp4(sPROBLEM,"No attempt to restore "+what+" : ",source," $AA55 signature is missing !");
        RETURN errSignature;
    END;

    IF NEWTABLE THEN
        S:=sWARN_MBR+sWARNTABLENEW;
    ELSE
        S:=sWARN_MBR+sWARNTABLEKEPT;
    END;
    IF queryUser(AUTOCONFIRM,S,source)=FALSE THEN RETURN errCancel;END;

    hnd := FIO.OpenRead(source);
    FIO.AssignBuffer(hnd,ioBuffer);
    IF NOT ( DYNALLOC ) THEN
        got:=FIO.RdBin (hnd,buffMasterBootRef, CARDINAL(expected) );
    ELSE
        got:=FIO.RdBin (hnd,pbuffMasterBootRef^, CARDINAL(expected) );
    END;
    FIO.Close(hnd);

    IF NEWTABLE=FALSE THEN
        IF readPartitionTable(XBIOS,unit,trackcount,headcount,sectorcount)=FALSE THEN
            RETURN errReadPartitionTable;
        END;

        IF NOT ( DYNALLOC ) THEN
        IF DEBUG THEN dumpSector(showAsTable, SectorType(buffPartitionTable) );END;
        ELSE
        IF DEBUG THEN dumpSector(showAsTable, SectorType(pbuffPartitionTable^) );END;
        END;

        FOR i := firstPartitionTableByte TO lastPartitionTableByte DO
            IF NOT ( DYNALLOC ) THEN
                buffMasterBootRef.bytearray[i]:=buffPartitionTable.bytearray[i];
            ELSE
                pbuffMasterBootRef^.bytearray[i]:=pbuffPartitionTable^.bytearray[i];
            END;
        END;
    END;

IF REALLY THEN
    track   := mintrack;
    head    := minhead;
    sector  := minsector;
    CHStoBlock (trackcount,headcount,sectorcount,
               track,head,sector,
               block);
    IF NOT ( DYNALLOC ) THEN
        result:= procSector (unit,XBIOS,opWrite,block,track,head,sector,
                            Seg(buffMasterBootRef),Ofs(buffMasterBootRef));
    ELSE
        result:= procSector (unit,XBIOS,opWrite,block,track,head,sector,
                            Seg(pbuffMasterBootRef^),Ofs(pbuffMasterBootRef^));
    END;
    IF result=FALSE THEN RETURN errInt13h; END;

    IF NOT ( DYNALLOC ) THEN
    IF DEBUG THEN dumpSector(showAsTable, SectorType(buffMasterBootRef) );END;
    ELSE
    IF DEBUG THEN dumpSector(showAsTable, SectorType(pbuffMasterBootRef^) );END;
    END;

    S:="";
ELSE
    S:=sFAKE;
END;
    dmp4(sOK,what+" updated with ",source,S);
    RETURN errNone;
END restoreMBR;

(* ------------------------------------------------------------ *)
(* ------------------------------------------------------------ *)

(* in sectors ! *)

PROCEDURE getTrack0size (ASSUMESTANDARDTRACK0:BOOLEAN;sectorcount:CARDINAL):CARDINAL;
VAR
    count:CARDINAL;
BEGIN
    IF ASSUMESTANDARDTRACK0 THEN
        count:= maxSectorInTrack; (* 63 *)
    ELSE
        IF sectorcount < maxSectorInTrack THEN
            count:= sectorcount;
        ELSE
            count:=maxSectorInTrack;
        END;
    END;
    RETURN count;
END getTrack0size;

PROCEDURE saveTrack0 (OVERWRITE,IGNORERO,XBIOS,ASSUMESTANDARDTRACK0:BOOLEAN;
                     unit:BYTE;trackcount,headcount,sectorcount:CARDINAL;
                     base,e3:ARRAY OF CHAR):CARDINAL;
CONST
    what = "Track 0";
VAR
    target:str128;
    hnd:FIO.File;
    track,head,sector:CARDINAL;
    block:LONGCARD;
    i : CARDINAL;
    result:BOOLEAN;
BEGIN
    CASE chkFile(target, OVERWRITE,IGNORERO,base,fileTRACK0,e3) OF
    | errAlreadyRO:
        dmp4(sPROBLEM,what+" not saved : ",target," is read-only !");
        RETURN errAlreadyRO;
    | errAlready:
        dmp4(sPROBLEM,what+" not saved : ",target," already exists !");
        RETURN errAlready;
    END;

    track   := mintrack;
    head    := minhead;
    sector  := minsector;
    CHStoBlock (trackcount,headcount,sectorcount,
               track,head,sector,
               block);

    FOR i:=firstSectorInTrack TO getTrack0size(ASSUMESTANDARDTRACK0,sectorcount) DO
        blockToCHS (trackcount,headcount,sectorcount,
                   block,
                   track,head,sector);

        IF NOT ( DYNALLOC ) THEN
            result:= procSector (unit,XBIOS,opRead,block,track,head,sector,
                                Seg(buffTrack0[i]),Ofs(buffTrack0[i]));
        ELSE
            result:= procSector (unit,XBIOS,opRead,block,track,head,sector,
                                Seg(pbuffTrack0[i]^),Ofs(pbuffTrack0[i]^));
        END;
        IF result=FALSE THEN RETURN errInt13h; END;

        IF NOT ( DYNALLOC ) THEN
        IF DEBUG THEN dumpSector(showAsRaw, SectorType(buffTrack0[i]) );END;
        ELSE
        IF DEBUG THEN dumpSector(showAsRaw, SectorType(pbuffTrack0[i]^) );END;
        END;

        INC(block);
    END;

    hnd := FIO.Create(target);
    FIO.AssignBuffer(hnd,ioBuffer);
    FOR i:=firstSectorInTrack TO getTrack0size(ASSUMESTANDARDTRACK0,sectorcount) DO
        IF NOT ( DYNALLOC ) THEN
            FIO.WrBin (hnd,buffTrack0[i],SIZE(buffTrack0[i]));
        ELSE
            FIO.WrBin (hnd,pbuffTrack0[i]^,SIZE(pbuffTrack0[i]^));
        END;
    END;
    FIO.Flush(hnd);
    FIO.Close(hnd);

    dmp3(sOK,what+" saved to ",target);
    RETURN errNone;
END saveTrack0;

PROCEDURE compTrack0 (VAR mismatches:LONGCARD;
                     VERBOSE,XBIOS,ASSUMESTANDARDTRACK0:BOOLEAN;
                     unit:BYTE;trackcount,headcount,sectorcount:CARDINAL;
                     base,e3:ARRAY OF CHAR):CARDINAL;
CONST
    what = "Track 0";
VAR
    source:str128;
    hnd:FIO.File;
    addr,n,i,got: CARDINAL;
    ref,now:BYTE;
    track,head,sector:CARDINAL;
    block:LONGCARD;
    expected:LONGCARD;
    chkrounds:CARDINAL;
    result:BOOLEAN;
BEGIN
    IF NOT ( DYNALLOC ) THEN
        expected:= LONGCARD( getTrack0size(ASSUMESTANDARDTRACK0,sectorcount) ) * SIZE(buffTrack0Ref[1]) ;
    ELSE
        expected:= LONGCARD( getTrack0size(ASSUMESTANDARDTRACK0,sectorcount) ) * SIZE(pbuffTrack0Ref[1]^) ;
    END;

    CASE chkFile(source, FALSE,FALSE,base,fileTRACK0,e3) OF
    | errNotFound:
        dmp4(sPROBLEM,what+" not compared : ",source," does not exist !");
        INC(mismatches); (* force an error *)
        RETURN errNotFound;
    END;
    CASE chkFileSize(source, expected) OF
    | errFileSize:
        dmp4(sPROBLEM,what+" not compared : ",source," filesize is not valid !");
        INC(mismatches); (* force an error *)
        RETURN errFileSize;
    END;

    IF VERBOSE THEN dmp3(sINFO,"Comparing "+what+" with ",source);END;

    hnd := FIO.OpenRead(source);
    FIO.AssignBuffer(hnd,ioBuffer);
    FOR i:=firstSectorInTrack TO getTrack0size(ASSUMESTANDARDTRACK0,sectorcount) DO
        IF NOT ( DYNALLOC ) THEN
            got:=FIO.RdBin (hnd,buffTrack0Ref[i], SIZE(buffTrack0Ref[i]) );
        ELSE
            got:=FIO.RdBin (hnd,pbuffTrack0Ref[i]^, SIZE(pbuffTrack0Ref[i]^) );
        END;
    END;
    FIO.Close(hnd);

    track   := mintrack;
    head    := minhead;
    sector  := minsector;
    CHStoBlock (trackcount,headcount,sectorcount,
               track,head,sector,
               block);

    FOR i:=firstSectorInTrack TO getTrack0size(ASSUMESTANDARDTRACK0,sectorcount) DO
        blockToCHS (trackcount,headcount,sectorcount,
                   block,
                   track,head,sector);
        IF NOT ( DYNALLOC ) THEN
            result:= procSector (unit,XBIOS,opRead,block,track,head,sector,
                                Seg(buffTrack0[i]),Ofs(buffTrack0[i]));
        ELSE
            result:= procSector (unit,XBIOS,opRead,block,track,head,sector,
                                Seg(pbuffTrack0[i]^),Ofs(pbuffTrack0[i]^));
        END;
        IF result=FALSE THEN RETURN errInt13h; END;

        IF NOT ( DYNALLOC ) THEN
        IF DEBUG THEN dumpSector(showAsRaw, SectorType(buffTrack0[i]) );END;
        ELSE
        IF DEBUG THEN dumpSector(showAsRaw, SectorType(pbuffTrack0[i]^) );END;
        END;

        INC(block);
    END;

    chkrounds:=0;
    addr:=0;
    mismatches:=0;
    FOR n:=firstSectorInTrack TO getTrack0size(ASSUMESTANDARDTRACK0,sectorcount) DO (* yes : n here *)
        FOR i := firstByteInSector TO lastByteInSector DO
            IF NOT ( DYNALLOC ) THEN
                ref:=buffTrack0Ref[n,i];
                now:=buffTrack0[n,i];
            ELSE
                ref:=pbuffTrack0Ref[n]^[i];
                now:=pbuffTrack0[n]^[i];
            END;
            IF now # ref THEN
                IF VERBOSE THEN
                    IF mismatches=0 THEN donl; END;
                    IF showDiff(chkrounds,addr,ref,now) THEN RETURN errAborted;END;
                END;
                INC (mismatches);
            END;
            INC(addr);
        END;
    END;

    IF mismatches = 0 THEN
        dmp2(sOK,what+" match.");
        RETURN errNone;
    ELSE
        IF VERBOSE THEN donl; END;
        dmp2(sPROBLEM,what+" do not match !");
        RETURN errMismatch;
    END;
END compTrack0;

PROCEDURE restoreTrack0 (REALLY,AUTOCONFIRM,NEWTABLE,XBIOS,ASSUMESTANDARDTRACK0:BOOLEAN;
                        unit:BYTE;trackcount,headcount,sectorcount:CARDINAL;
                        base,e3:ARRAY OF CHAR):CARDINAL;
CONST
    what = "Track 0";
VAR
    source:str128;
    hnd:FIO.File;
    i,got:CARDINAL;
    S:str128;
    track,head,sector:CARDINAL;
    block:LONGCARD;
    expected:LONGCARD;
    result:BOOLEAN;
BEGIN
    IF NOT ( DYNALLOC ) THEN
        expected:= LONGCARD( getTrack0size(ASSUMESTANDARDTRACK0,sectorcount) ) * SIZE(buffTrack0Ref[1]) ;
    ELSE
        expected:= LONGCARD( getTrack0size(ASSUMESTANDARDTRACK0,sectorcount) ) * SIZE(pbuffTrack0Ref[1]^) ;
    END;

    CASE chkFile(source, FALSE,FALSE,base,fileTRACK0,e3) OF
    | errNotFound:
        dmp4(sPROBLEM,"No attempt to restore "+what+" : ",source," does not exist !");
        RETURN errNotFound;
    END;
    CASE chkFileSize(source, expected ) OF
    | errFileSize:
        dmp4(sPROBLEM,"No attempt to restore "+what+" : ",source," filesize is not valid !");
        RETURN errFileSize;
    END;
    CASE chkSignature(source) OF
    | errSignature:
        dmp4(sPROBLEM,"No attempt to restore "+what+" : ",source," $AA55 signature is missing !");
        RETURN errSignature;
    END;

    IF NEWTABLE THEN
        S:=sWARN_TRACK0+sWARNTABLENEW;
    ELSE
        S:=sWARN_TRACK0+sWARNTABLEKEPT;
    END;
    IF queryUser(AUTOCONFIRM,S,source)=FALSE THEN RETURN errCancel;END;

    hnd := FIO.OpenRead(source);
    FIO.AssignBuffer(hnd,ioBuffer);
    FOR i:=firstSectorInTrack TO getTrack0size(ASSUMESTANDARDTRACK0,sectorcount) DO
        IF NOT ( DYNALLOC ) THEN
            got:=FIO.RdBin (hnd,buffTrack0Ref[i], SIZE(buffTrack0Ref[i]) );
        ELSE
            got:=FIO.RdBin (hnd,pbuffTrack0Ref[i]^, SIZE(pbuffTrack0Ref[i]^) );
        END;
    END;
    FIO.Close(hnd);

    IF NEWTABLE = FALSE THEN
        IF readPartitionTable(XBIOS,unit,trackcount,headcount,sectorcount)=FALSE THEN
            RETURN errReadPartitionTable;
        END;
        IF NOT ( DYNALLOC ) THEN
        IF DEBUG THEN dumpSector(showAsTable, SectorType(buffPartitionTable) );END;
        ELSE
        IF DEBUG THEN dumpSector(showAsTable, SectorType(pbuffPartitionTable^) );END;
        END;

        (* buffTrack0[1] is MBR containing primary partition table *)

        FOR i := firstPartitionTableByte TO lastPartitionTableByte DO
            IF NOT ( DYNALLOC ) THEN
                buffTrack0Ref[ 1 ,i]:=buffPartitionTable.bytearray[i]; (* bytearray is SectorType *)
            ELSE
                pbuffTrack0Ref[ 1 ]^[i]:=pbuffPartitionTable^.bytearray[i]; (* bytearray is sectorType *)
            END;
        END;
    END;

IF REALLY THEN
    track   := mintrack;
    head    := minhead;
    sector  := minsector;
    CHStoBlock (trackcount,headcount,sectorcount,
               track,head,sector,
               block);

    FOR i:=firstSectorInTrack TO getTrack0size(ASSUMESTANDARDTRACK0,sectorcount) DO
        blockToCHS (trackcount,headcount,sectorcount,
                   block,
                   track,head,sector);
        IF NOT ( DYNALLOC ) THEN
            result:=procSector (unit,XBIOS,opWrite,block,track,head,sector,
                               Seg(buffTrack0Ref[i]),Ofs(buffTrack0Ref[i]));
        ELSE
            result:=procSector (unit,XBIOS,opWrite,block,track,head,sector,
                               Seg(pbuffTrack0Ref[i]^),Ofs(pbuffTrack0Ref[i]^));
        END;
        IF result=FALSE THEN RETURN errInt13h; END;
        IF NOT ( DYNALLOC ) THEN
        IF DEBUG THEN dumpSector(showAsRaw, SectorType(buffTrack0Ref[i]) );END;
        ELSE
        IF DEBUG THEN dumpSector(showAsRaw, SectorType(pbuffTrack0Ref[i]^) );END;
        END;
        INC(block);
    END;

    S:="";
ELSE
    S:=sFAKE;
END;
    dmp4(sOK,what+" updated with ",source,S);
    RETURN errNone;
END restoreTrack0;

(* ------------------------------------------------------------ *)

PROCEDURE zeroTrack0 (REALLY,AUTOCONFIRM,XBIOS,ASSUMESTANDARDTRACK0:BOOLEAN;
                     unit:BYTE;trackcount,headcount,sectorcount:CARDINAL):CARDINAL;
CONST
    what = "Track 0";
VAR
    i,j:CARDINAL;
    S:str128;
    track,head,sector:CARDINAL;
    block:LONGCARD;
    result:BOOLEAN;
BEGIN
    S:=sWARN_ZERO;
    Str.Subst(S,"~",fmt( CARDINAL(unit),16,2,"0","$"));
    IF queryUser(AUTOCONFIRM,S,"")=FALSE THEN RETURN errCancel;END;

    FOR i:=firstSectorInTrack TO getTrack0size(ASSUMESTANDARDTRACK0,sectorcount) DO
        FOR j:= firstByteInSector TO lastByteInSector DO
            IF NOT ( DYNALLOC ) THEN
                buffTrack0Ref[i,j]:=BYTE(00H);
            ELSE
                pbuffTrack0Ref[i]^[j]:=BYTE(00H);
            END;
        END;
    END;

    (* read current MBR then save it to track buffer *)

    IF readMasterBootRecord(XBIOS,unit,trackcount,headcount,sectorcount)=FALSE THEN
        RETURN errReadMasterBootRecord;
    END;

    IF NOT ( DYNALLOC ) THEN
    IF DEBUG THEN dumpSector(showAsTable, SectorType(buffMasterBoot) );END;
    ELSE
    IF DEBUG THEN dumpSector(showAsTable, SectorType(pbuffMasterBoot^) );END;
    END;
    (* yes, we could use Lib.FastMove *)
    (*
    FOR j:= firstByteInSector TO lastByteInSector DO
        buffTrack0Ref[ 1 , j ] := buffMasterBoot.bytearray[j];
    END;
    *)
    IF NOT ( DYNALLOC ) THEN
        buffTrack0Ref[1] := SectorType ( buffMasterBoot );
    ELSE
        pbuffTrack0Ref[1]^ := SectorType ( pbuffMasterBoot^ );
    END;

IF REALLY THEN
    track   := mintrack;
    head    := minhead;
    sector  := minsector;
    CHStoBlock (trackcount,headcount,sectorcount,
               track,head,sector,
               block);

    FOR i:=firstSectorInTrack TO getTrack0size(ASSUMESTANDARDTRACK0,sectorcount) DO
        blockToCHS (trackcount,headcount,sectorcount,
                   block,
                   track,head,sector);
        IF NOT ( DYNALLOC ) THEN
            result:= procSector (unit,XBIOS,opWrite,block,track,head,sector,
                                Seg(buffTrack0Ref[i]),Ofs(buffTrack0Ref[i]));
        ELSE
            result:= procSector (unit,XBIOS,opWrite,block,track,head,sector,
                                Seg(pbuffTrack0Ref[i]^),Ofs(pbuffTrack0Ref[i]^));
        END;
        IF result=FALSE THEN RETURN errInt13h; END;
        IF NOT ( DYNALLOC ) THEN
        IF DEBUG THEN dumpSector(showAsRaw, SectorType(buffTrack0Ref[i]) );END;
        ELSE
        IF DEBUG THEN dumpSector(showAsRaw, SectorType(pbuffTrack0Ref[i]^) );END;
        END;
        INC(block);
    END;

    S:="";
ELSE
    S:=sFAKE;
END;
    dmp3(sOK,what+" has been filled with $00",S);
    RETURN errNone;
END zeroTrack0;

(* ------------------------------------------------------------ *)
(* ------------------------------------------------------------ *)

(* data taken from Ralf Brown's Interrup List 60, with minor tweaking in descriptions *)

CONST
    IDemptyPart             = BYTE(00H);
CONST
    IDextendedPart          = BYTE(05H);
    IDextendedPartLBA       = BYTE(0FH); (* id 05H but using LBA-mode *)
    IDextendedPartHidden    = BYTE(15H);
    IDextendedPartLBAhidden = BYTE(1FH); (* id 05H but using LBA-mode *)

(* don't care about extended partitions, whether primary or logical, which haven't a boot record *)

PROCEDURE isFAT (ID:BYTE):BOOLEAN;
BEGIN
    CASE ID OF
    | 001H, 004H, 006H, 00EH :
        RETURN TRUE;
    | 011H, 014H, 016H, 01EH :
        RETURN TRUE;
    ELSE
        RETURN FALSE;
    END;
END isFAT;

PROCEDURE isFAT32 (ID:BYTE):BOOLEAN;
BEGIN
    CASE ID OF
    | 00BH, 00CH :
         RETURN TRUE;
    | 01BH, 01CH :
         RETURN TRUE;
    ELSE
        RETURN FALSE;
    END;
END isFAT32;

PROCEDURE isNTFS (ID:BYTE):BOOLEAN; (* v1.3p *)
BEGIN
    CASE ID OF
    | 007H, 017H: (* yes, yes, there are others but let's stick to these for now *)
        RETURN TRUE;
    ELSE
        RETURN FALSE;
    END;
END isNTFS;

PROCEDURE isEmptyPart (ID:BYTE):BOOLEAN;
BEGIN
    CASE ID OF
    | IDemptyPart :
        RETURN TRUE;
    ELSE
        RETURN FALSE;
    END;
END isEmptyPart;

PROCEDURE isExtendedPart (ID:BYTE):BOOLEAN;
BEGIN
    CASE ID OF
    | IDextendedPart, IDextendedPartLBA :
        RETURN TRUE;
    | IDextendedPartHidden, IDextendedPartLBAhidden :
        RETURN TRUE;
    ELSE
        RETURN FALSE;
    END;
END isExtendedPart;

CONST
    sNoLongID = "Unknown partition type";

PROCEDURE getIDpartStr (IDpart:BYTE;VAR sHex:ARRAY OF CHAR;VAR sID:str256);
VAR
    S:str256;
    ok:BOOLEAN;
BEGIN
    Str.Copy(sHex,fmt( CARDINAL(IDpart),16,2,"0","$") );
    CASE IDpart OF
    | 000H : S:="Empty partition-table entry"; (* // *)
    | 001H : S:="DOS FAT12";
    | 002H : S:="XENIX root file system";
    | 003H : S:="XENIX /usr file system (obsolete)";
    | 004H : S:="DOS FAT16 (< 32M)";
    | 005H : S:="DOS 3.3+ extended partition";         (* // *)
    | 006H : S:="DOS 3.31+ Large File System (FAT16, >= 32M)";
    | 007H : S:="8-ung ! QNX, OS/2 HPFS, Windows NT NTFS, Advanced Unix, or unknown";
    | 008H : S:="8-ung ! OS/2 (v1.0-1.3 only), AIX bootable partition, SplitDrive, Commodore DOS, or DELL partition spanning multiple drives";
    | 009H : S:="8-ung ! AIX data partition, or Coherent filesystem";
    | 00AH : S:="8-ung ! OS/2 Boot Manager, OPUS, or Coherent swap partition";
    | 00BH : S:="Windows95 FAT32";
    | 00CH : S:="Windows95 FAT32 (using LBA-mode INT $13 extensions)";
    | 00EH : S:="logical-block-addressable VFAT (same as 06h but using LBA-mode INT $13)";
    | 00FH : S:="logical-block-addressable VFAT (same as 05h but using LBA-mode INT $13)"; (* // *)
    | 010H : S:="OPUS";
    | 011H : S:="OS/2 Boot Manager hidden FAT12 partition";
    | 012H : S:="Compaq Diagnostics partition";
    | 014H : S:="8-ung ! (resulted from using Novell DOS 7.0 FDISK to delete Linux Native part), "+
                "or OS/2 Boot Manager hidden < 32M FAT16 partition";
    | 015H : S:="hidden DOS 3.3+ extended partition"; (* // added by me, probably used by XOSL *)
    | 016H : S:="OS/2 Boot Manager hidden >= 32M FAT16 partition";
    | 017H : S:="8-ung ! OS/2 Boot Manager hidden HPFS partition, or hidden NTFS partition";
    | 018H : S:='AST special Windows swap file ("Zero-Volt Suspend" partition)';
    | 019H : S:="Willowtech Photon coS";
    | 01BH : S:="hidden Windows95 FAT32 partition";
    | 01CH : S:="hidden Windows95 FAT32 partition (using LBA-mode INT $13 extensions)";
    | 01EH : S:="hidden LBA VFAT partition";
    | 01FH : S:="hidden LBA VFAT extended partition"; (* // added by me, used by XOSL *)
    | 020H : S:="Willowsoft Overture File System (OFS1)";
    | 021H : S:="8-ung ! officially listed as reserved, or FSo2";
    | 023H : S:="officially listed as reserved";
    | 024H : S:="NEC MS-DOS 3.x";
    | 026H : S:="officially listed as reserved";
    | 031H : S:="officially listed as reserved";
    | 033H : S:="officially listed as reserved";
    | 034H : S:="officially listed as reserved";
    | 036H : S:="officially listed as reserved";
    | 038H : S:="Theos";
    | 03CH : S:="PowerQuest PartitionMagic recovery partition";
    | 040H : S:="VENIX 80286";
    | 041H : S:="8-ung ! Personal RISC Boot, or PowerPC boot partition";
    | 042H : S:="SFS (Secure File System) by Peter Gutmann";
    | 045H : S:="EUMEL/Elan";
    | 046H : S:="EUMEL/Elan";
    | 047H : S:="EUMEL/Elan";
    | 048H : S:="EUMEL/Elan";
    | 04FH : S:="Oberon boot/data partition";
    | 050H : S:="OnTrack Disk Manager (read-only partition)";
    | 051H : S:="8-ung ! OnTrack Disk Manager (read/write partition) or NOVELL";
    | 052H : S:="8-ung ! CP/M, or Microport System V/386";
    | 053H : S:="OnTrack Disk Manager (write-only partition ?)";
    | 054H : S:="OnTrack Disk Manager (DDO)";
    | 055H : S:="EZ-Drive";
    | 056H : S:="GoldenBow VFeature";
    | 05CH : S:="Priam EDISK";
    | 061H : S:="SpeedStor";
    | 063H : S:="8-ung ! Unix SysV/386 (386/ix), Mach (MtXinu BSD 4.3 on Mach), or GNU HURD";
    | 064H : S:="8-ung ! Novell NetWare 286, or SpeedStore";
    | 065H : S:="Novell NetWare (3.11)";
    | 067H : S:="Novell";
    | 068H : S:="Novell";
    | 069H : S:="Novell";
    | 070H : S:="DiskSecure Multi-Boot";
    | 071H : S:="officially listed as reserved";
    | 073H : S:="officially listed as reserved";
    | 074H : S:="officially listed as reserved";
    | 075H : S:="PC/IX";
    | 076H : S:="officially listed as reserved";
    | 07EH : S:="F.I.X.";
    | 080H : S:="Minix v1.1-1.4a";
    | 081H : S:="8-ung ! Minix v1.4b+, Linux, or Mitac Advanced Disk Manager";
    | 082H : S:="8-ung ! Linux Swap partition, Prime, or Solaris (Unix)";
    | 083H : S:="Linux native file system (ext2fs/xiafs)";
    | 084H : S:="OS/2-renumbered type 04h partition (related to hiding DOS C: drive)";
    | 085H : S:="Linux EXT";
    | 086H : S:="FAT16 volume/stripe set (Windows NT)";
    | 087H : S:="8-ung ! HPFS Fault-Tolerant mirrored partition, or NTFS volume/stripe set";
    | 093H : S:="Amoeba file system";
    | 094H : S:="Amoeba bad block table";
    | 098H : S:="Datalight ROM-DOS SuperBoot";
    | 099H : S:="Mylex EISA SCSI";
    | 0A0H : S:='Phoenix NoteBIOS Power Management "Save-to-Disk" partition';
    | 0A1H : S:="officially listed as reserved";
    | 0A3H : S:="officially listed as reserved";
    | 0A4H : S:="officially listed as reserved";
    | 0A5H : S:="FreeBSD, BSD/386";
    | 0A6H : S:="OpenBSD";
    | 0A9H : S:="NetBSD";
    | 0B1H : S:="officially listed as reserved";
    | 0B3H : S:="officially listed as reserved";
    | 0B4H : S:="officially listed as reserved";
    | 0B6H : S:="8-ung ! officially listed as reserved, but Windows NT mirror set (master) FAT16 file system";
    | 0B7H : S:="8-ung ! BSDI file system (secondarily swap), or Windows NT mirror set (master) NTFS file system";
    | 0B8H : S:="BSDI swap partition (secondarily file system)";
    | 0BEH : S:="Solaris boot partition";
    | 0C0H : S:="8-ung ! DR-DOS/Novell DOS secured partition, or CTOS";
    | 0C1H : S:="DR DOS 6.0 LOGIN.EXE-secured FAT12 partition";
    | 0C4H : S:="DR DOS 6.0 LOGIN.EXE-secured FAT16 partition";
    | 0C6H : S:="8-ung ! DR DOS 6.0 LOGIN.EXE-secured Huge partition, corrupted FAT16 volume/stripe set (Windows NT), or Windows NT mirror set (slave) FAT16 file system";
    | 0C7H : S:="8-ung ! Syrinx Boot, corrupted NTFS volume/stripe set, or Windows NT mirror set (slave) NTFS file system";
    | 0CBH : S:="Reserved for DR-DOS secured FAT32";
    | 0CCH : S:="Reserved for DR-DOS secured FAT32 (LBA)";
    | 0CEH : S:="Reserved for DR-DOS secured FAT16 (LBA)";
    | 0D0H : S:="Multiuser DOS secured FAT12";
    | 0D1H : S:="Old Multiuser DOS secured FAT12";
    | 0D4H : S:="Old Multiuser DOS secured FAT16 (< 32M)";
    | 0D5H : S:="Old Multiuser DOS secured extended partition";
    | 0D6H : S:="Old Multiuser DOS secured FAT16 (>= 32M)";
    | 0D8H : S:="CP/M-86";
    | 0DBH : S:="8-ung ! CP/M, Concurrent CP/M, Concurrent DOS, or CTOS (Convergent Technologies OS)";
    | 0E1H : S:="SpeedStor FAT12 extended partition";
    | 0E2H : S:="DOS read-only (Florian Painke's XFDISK 1.0.4)";
    | 0E3H : S:="8-ung ! DOS read-only, or Storage Dimensions";
    | 0E4H : S:="SpeedStor FAT16 extended partition";
    | 0E5H : S:="officially listed as reserved";
    | 0E6H : S:="officially listed as reserved";
    | 0EBH : S:="BeOS BFS (BFS1)";
    | 0F1H : S:="Storage Dimensions";
    | 0F2H : S:="DOS 3.3+ secondary partition";
    | 0F3H : S:="officially listed as reserved";
    | 0F4H : S:="8-ung ! SpeedStor, or Storage Dimensions";
    | 0F5H : S:="Prologue";
    | 0F6H : S:="officially listed as reserved";
    | 0FEH : S:="8-ung ! LANstep, or IBM PS/2 IML (Initial Microcode Load) partition";
    | 0FFH : S:="Xenix bad block table";
    ELSE
        S:=sNoLongID;
    END;
    Str.Copy(sID,S);
END getIDpartStr;

(* most useful/used only ! should match PartInfo *)

CONST
    sNoShortID = "...";

PROCEDURE getIDshortDesc (IDpart:BYTE;isPrimary,pad:BOOLEAN):str16;
CONST
    widesc = 16; (* change strHeader accordingly *)
VAR
    S : str16;
    i : CARDINAL;
BEGIN
    CASE IDpart OF
    | 000H : S:="Empty";
    | 001H : S:="FAT12";
    | 004H : S:="FAT16";
    | 005H : IF isPrimary THEN
             S:="Extended";
             ELSE
             S:="EBPR";
             END;
    | 006H : S:="FAT16B";
    | 007H : S:="NT NTFS"; (* v1.3p *)
    | 00BH : S:="FAT32";
    | 00CH : S:="FAT32X";
    | 00EH : S:="FAT16X";
    | 00FH : IF isPrimary THEN
             S:="ExtendedX"
             ELSE
             S:="EBPRX";
             END;
    | 011H : S:="Hidden FAT12";
    | 014H : S:="Hidden FAT16";
    | 015H : IF isPrimary THEN
             S:="Hidden Extended";
             ELSE
             S:="Hidden EBPR";
             END;
    | 016H : S:="Hidden FAT16B";
    | 017H : S:="Hidden NT NTFS"; (* v1.3p *)
    | 01BH : S:="Hidden FAT32";
    | 01CH : S:="Hidden FAT32X";
    | 01EH : S:="Hidden FAT16X";
    | 01FH : IF isPrimary THEN
             S:="Hidden ExtendedX";
             ELSE
             S:="Hidden EBPRX";
             END;
             (* "1234567890123456" *)
    ELSE
        S:=sNoShortID;
    END;
    IF pad THEN
        WHILE Str.Length(S) < widesc DO
           Str.Append(S, " ");
        END;
    END;
    RETURN S;
END getIDshortDesc;

PROCEDURE getHideUnhideStatus (VAR R:ARRAY OF CHAR; IDpart:BYTE):BOOLEAN;
VAR
    rc: BOOLEAN;
    S:str80;
BEGIN
    rc:=TRUE;
    CASE IDpart OF
    | 001H : S:="FAT12";
    | 004H : S:="FAT16";
    | 005H : S:="Extended/EBPR";
    | 006H : S:="FAT16B";
    | 007H : S:="NT NTFS";
    | 00BH : S:="FAT32";
    | 00CH : S:="FAT32X";
    | 00EH : S:="FAT16X";
    | 00FH : S:="ExtendedX/EBPRX";
    | 011H : S:="Hidden FAT12";
    | 014H : S:="Hidden FAT16";
    | 015H : S:="Hidden Extended/EBPR";
    | 016H : S:="Hidden FAT16B";
    | 017H : S:="Hidden NT NTFS";
    | 01BH : S:="Hidden FAT32";
    | 01CH : S:="Hidden FAT32X";
    | 01EH : S:="Hidden FAT16X";
    | 01FH : S:="Hidden ExtendedX/EBPRX";
             (* "12345678901234567890123456789" *)
    ELSE
             S:="unsupported";
             rc:=FALSE;
    END;
    Str.Copy(R,S);
    RETURN rc;
END getHideUnhideStatus;

(* ------------------------------------------------------------ *)
(* ------------------------------------------------------------ *)

CONST
    dash10 = "==========";
    dashes = dash10+dash10+dash10+dash10+dash10+dash10+dash10;

PROCEDURE chapter (hnd:FIO.File;S:ARRAY OF CHAR );
VAR
    R:str1024; (* should do *)
BEGIN
    Str.Concat(R,nl+dashes+nl,S);Str.Append(R,nl+dashes+nl+nl);
    fdmp(hnd,R);
END chapter;

PROCEDURE fmtrangelc (lower,upper:LONGCARD):str80;
VAR
    R:str80;
BEGIN
    Str.Concat(R,"[",fmtlc(lower,10,0,"",""));
    Str.Append(R,"..");
    Str.Append(R,fmtlc(upper,10,0,"",""));
    Str.Append(R,"]");
    RETURN R;
END fmtrangelc;

PROCEDURE fmtrange (lower,upper:CARDINAL):str80;
BEGIN
    RETURN fmtrangelc( LONGCARD(lower),LONGCARD(upper) );
END fmtrange;

PROCEDURE fmtTHS (ALTFORMAT:BOOLEAN; t,h,s:CARDINAL;mul:CHAR):str80;
VAR
    S:str80;
BEGIN
    IF NOT(ALTFORMAT) THEN
        Str.Concat(S,beautifiedlc( (LONGCARD(t)*LONGCARD(h)*LONGCARD(s)),blank,sepdot,wiblock), " = ");
        Str.Append(S,fmt(t,10,0,"",""));Str.Append(S,mul);
        Str.Append(S,fmt(h,10,0,"",""));Str.Append(S,mul);
        Str.Append(S,fmt(s,10,0,"",""));
    ELSE
        Str.Concat(S,fmtlc( (LONGCARD(t)*LONGCARD(h)*LONGCARD(s)),10,wiblockraw,blank,""), " = ");
        Str.Append(S,fmt(t,10,0,"",""));Str.Append(S,mul);
        Str.Append(S,fmt(h,10,0,"",""));Str.Append(S,mul);
        Str.Append(S,fmt(s,10,0,"",""));
    END;
    RETURN S;
END fmtTHS;

TYPE
    fixeddiskparametersType = RECORD
        cylcount:WORD;
        headcount:BYTE;
        pad1:WORD; (* starting reduced write current cylinder (XT only, 0 for others) *)
        pad2:WORD; (* starting write precompensation cylinder number *)
        pad3:BYTE; (* maximum ECC burst length (XT only) *)
        pad4:BYTE; (* control BYTE *)
        pad5:BYTE; (* standard timeout (XT only, 0 for others) *)
        pad6:BYTE; (* formatting timeout (XT and WD1002 only, 0 for others) *)
        pad7:BYTE; (* timeout for checking drive (XT and WD1002 only, 0 for others) *)
        pad8:WORD; (* cylinder number of landing zone (AT and later only) *)
        sectorcount:BYTE;
        rsvd:BYTE;
    END;

(* see INT 41 - SYSTEM DATA - HARD DISK 0 PARAMETER TABLE ADDRESS [NOT A VECTOR!] *)
(*
    BIOSes which support four hard drives may store the parameter tables
        for drives 81h-83h immediately following the parameter table pointed
        at by INT 41, with a separate copy of the drive 81h table for INT 46.
        The check for such an arrangement is to test whether INT 46 points
        somewhere other than exactly 16 bytes past INT 41, and the sixteen
        bytes starting at offset 10h from INT 41 are identical to the sixteen
        bytes pointed at by INT 46
    another arrangement for BIOSes which support four IDE drives is to have
        four tables pointed at by INT 41 in the order primary master,
        primary slave, secondary master, and secondary slave, in which case
        (for example) a system with only primary master and secondary master
        will have valid tables at offsets 00h and 20h, with garbage (but
        sectors-per-track = 00h) at offsets 10h and 30h
*)

PROCEDURE fmtBIOSgeometry (ALTFORMAT:BOOLEAN;unit:BYTE):str80;
CONST
    sBadGeom = "?x?x?";
VAR
    S:str80;
    a : FarADDRESS;
    table : fixeddiskparametersType;
    R:SYSTEM.Registers;
    c,h,s:CARDINAL;
    v:BYTE;
BEGIN
    CASE unit OF
    | 80H : v:=41H;
    | 81H : v:=46H;
    | 82H : v:=41H;
    | 83H : v:=41H;
    ELSE
        RETURN sBadGeom; (* cannot happen : already trapped ! *)
    END;
    R.AH := 35H;
    R.AL := v;
    Lib.Dos(R);
    a := [R.ES:R.BX];
    CASE unit OF        (* assumption ! *)
    | 82H: Lib.IncAddr(a,SIZE(table));   (* 10H *)
    | 83H: Lib.IncAddr(a,SIZE(table)*2); (* 20H *)
    END;
    Lib.FarMove ( a, FarADR(table), SIZE(table));
    CASE unit OF
    | 82H: IF CARDINAL(table.sectorcount) = 00H THEN RETURN sBadGeom;END;
    | 83H: IF CARDINAL(table.sectorcount) = 00H THEN RETURN sBadGeom;END;
    END;

    c := CARDINAL(table.cylcount);
    h := CARDINAL(table.headcount);
    s := CARDINAL(table.sectorcount);
    RETURN fmtTHS(ALTFORMAT,c,h,s,"x");
END fmtBIOSgeometry;

PROCEDURE doCmdParms (hnd:FIO.File;unit:BYTE;
                     XBIOS,XBIOSavailable,
                     NEWGEOMETRY,PERFECTGEOMETRY,ALTFORMAT,ASSUMESTANDARDTRACK0,FORCESECTORCOUNT:BOOLEAN;
                     EDDmajor,EDDflag:BYTE; BESTFIT:CARDINAL;
                     maxtrackorg,maxheadorg,maxsectororg:CARDINAL;
                     totalSectors:LONGCARD;
                     maxtrack,maxhead,maxsector:CARDINAL;
                     maxblock:LONGCARD;
                     trackcount,headcount,sectorcount:CARDINAL;
                     blockcount:LONGCARD);
CONST
    strMode       = "Access mode";
    strUnit       = "Unit";
    strTHS        = "TxHxS";
    strTotal      = "Total blocks";
    strTrack      = "Track";
    strHead       = "Head";
    strSector     = "Sector";
    strBlock      = "Block";
    strBIOSths    = "BIOS TxHxS";
    strBIOStable  = "BIOS table";

    warnFloppyFactor = nl+
"::: Note specifying -j[j] option with a floppy unit has no effect."+nl;

    warnUselessFactor= nl+
"::: Note specifying -j[j] option with this system has no effect."+nl;

    warnXBIOS = nl+
"::: Note specifying -x option with this system is UNSAFE and NOT recommended :"+nl+
"::: you should rely on BIOS interrupt $13 extensions instead."+nl;

    warnFactor= nl+
"::: Note specifying -j[j] option with this system is NOT recommended :"+nl+
"::: you should let "+progEXEname+" try and rebuild better Track/Head/Sector values."+nl;

    warnStandardTrack0= nl+
"::: Note specifying -e option is not recommended."+nl;

    warnForceSectorCount = nl+
"::: Note specifying -n option is not recommended."+nl;

    warnXBIOSuselessFactor = warnXBIOS+warnUselessFactor;

VAR
    S,R : str128;
    total:LONGCARD;
BEGIN
    Str.Copy(S,fmt( CARDINAL(unit),16,2,"0","$"));
    IF isFloppy(unit) THEN
        Str.Append(S," (floppy disk)");
    ELSE
        Str.Append(S," (hard disk)");
    END;
    show(hnd,wi,strUnit,S);

    IF XBIOS THEN
        S:="BIOS interrupt $13 extensions";
        CASE CARDINAL(EDDmajor) OF (* well, extensions in fact *)
        | 01H : R:="1.x";
        | 20H : R:="2.0 (EDD 1.0)";
        | 21H : R:="2.1 (EDD 1.1)";
        | 30H : R:="3.0 (EDD 3.0)";
        ELSE
                R:="";
        END;
        IF same(R,"")=FALSE THEN
            Str.Append(S," v");Str.Append(S,R);
            Str.Append(S," %"); (* was " -- %" *)
            Str.Append(S,fmt( CARDINAL(EDDflag),2,4,"0","" ));
            (*
            0 extended disk access functions (AH=42h-44h,47h,48h) supported
            1 removable drive controller functions supported (AH=45h,46h,48h,49h,INT 15/AH=52h)
            2 enhanced disk drive (EDD) functions (AH=48h,AH=4Eh) supported
              extended drive parameter table is valid (see #00273,#00278)
            *)
        END;
    ELSE
        S:="BIOS interrupt $13";
    END;
    show(hnd,wi,strMode,S);

    fdmp(hnd,nl);
    show(hnd,wi,strTrack, fmtrange  (mintrack,  maxtrack));
    show(hnd,wi,strHead,  fmtrange  (minhead,   maxhead));
    show(hnd,wi,strSector,fmtrange  (minsector, maxsector));
    show(hnd,wi,strBlock, fmtrangelc(LONGCARD(minblock),  maxblock));

    fdmp(hnd,nl);
    IF NOT(ALTFORMAT) THEN
        show(hnd,wi,strTotal,beautifiedlc(blockcount,blank,sepdot,wiblock));
    ELSE
        show(hnd,wi,strTotal,fmtlc(blockcount,10,wiblockraw,blank,""));
    END;

    show(hnd,wi,strTHS,fmtTHS(ALTFORMAT,trackcount,headcount,sectorcount,"x"));

    fdmp(hnd,nl);
    show(hnd,wi,strBIOSths,fmtTHS (ALTFORMAT,
                                  maxtrackorg-mintrack+1,
                                  maxheadorg-minhead+1,
                                  maxsectororg-minsector+1,"x"));
    IF isFloppy(unit)=FALSE  THEN
        show(hnd,wi,strBIOStable,fmtBIOSgeometry(ALTFORMAT,unit));
    END;

    IF isFloppy(unit) THEN
        IF BESTFIT # FORCEBEST THEN fdmp(hnd,warnFloppyFactor); END;
    ELSE
        IF XBIOS THEN
            IF NEWGEOMETRY THEN
                IF PERFECTGEOMETRY=FALSE THEN
                    IF FORCESECTORCOUNT=FALSE THEN
                        IF BESTFIT # FORCEBEST THEN fdmp(hnd,warnFactor); END;
                    END;
                END;
            ELSE
                IF BESTFIT # FORCEBEST THEN fdmp(hnd,warnUselessFactor); END;
            END;
        ELSE
            IF XBIOSavailable THEN
                IF BESTFIT = FORCEBEST THEN
                    fdmp(hnd,warnXBIOS);
                ELSE
                    fdmp(hnd,warnXBIOSuselessFactor);
                END;
            END;
            (*
            older BIOSes would require more checks but who cares ? ;-)
            *)
        END;
        IF ASSUMESTANDARDTRACK0=FALSE THEN fdmp(hnd,warnStandardTrack0); END;
        IF FORCESECTORCOUNT THEN fdmp(hnd,warnForceSectorCount);END;
    END;
END doCmdParms;

(* ------------------------------------------------------------ *)

PROCEDURE getSuffix (VAR suffix:ARRAY OF CHAR;
                    isPrimary:BOOLEAN; primindex,ndxpart,subindex:CARDINAL);
VAR
    c1,c2:CHAR;
BEGIN
    c1:=CHR ( ORD("0")+primindex); (* 1..4 *)
    c2:=CHR ( ORD("A")+subindex ); (* A..  *)
    IF isPrimary THEN
        Str.Copy(suffix,c1);
    ELSE
        Str.Concat(suffix, c1,c2);
    END;
END getSuffix;

PROCEDURE getAlias (VAR f8:ARRAY OF CHAR;
                   isPrimary:BOOLEAN;
                   partID:BYTE; primindex,ndxpart,subindex:CARDINAL);
VAR
    F,strWhat:str128;
    suffix:str2;
BEGIN
    IF isPrimary THEN
        IF isExtendedPart(partID) THEN
            F:=fileEXTENDED;
        ELSE
            F:=filePART;
        END;
    ELSE
        IF isExtendedPart(partID) THEN
            F:=fileXBR;
        ELSE
            F:=fileLOGICAL;
        END;
    END;
    getSuffix(suffix, isPrimary,primindex,ndxpart,subindex);
    Str.Concat(f8,F,suffix);
END getAlias;

PROCEDURE getDesc (VAR what:ARRAY OF CHAR;
                  isPrimary:BOOLEAN;partID:BYTE;primindex,ndxpart,subindex:CARDINAL);
VAR
    strWhat:str128;
    suffix:str2;
BEGIN
    IF isPrimary THEN
        IF isExtendedPart(partID) THEN
            strWhat := strExtendedPart;
        ELSE
            strWhat := strMainPart;
        END;
    ELSE
        IF isExtendedPart(partID) THEN
            strWhat := strExtendedBR;
        ELSE
            strWhat := strLogicalPart;
        END;
    END;
    getSuffix(suffix, isPrimary,primindex,ndxpart,subindex);
    Str.Concat(what,strWhat,suffix);
END getDesc;

(* ------------------------------------------------------------ *)

TYPE
    ptrToEntry = POINTER TO entryType;
    entryType = RECORD
        next      : ptrToEntry;

        primary   : BOOLEAN;
        pprimindex: SHORTCARD;   (* primary partition index 1..4 *)
        pndxpart  : SHORTCARD;   (* logical partition index 1..4 *)
        psubindex : SHORTCARD;   (* secondary index A.. *)
        pcode     : SHORTCARD;   (* partition code *)
        parentblock: LONGCARD;    (* block where partition code is *)
        pbootflag : SHORTCARD;
        bT        : CARDINAL;    (* start THS *)
        bH        : SHORTCARD;
        bS        : SHORTCARD;
        eT        : CARDINAL;    (* end THS *)
        eH        : SHORTCARD;
        eS        : SHORTCARD;
        pfirst    : LONGCARD;    (* partition first sector *)
        pbefore   : LONGCARD;    (* partition preceding sectors *)
        pcount    : LONGCARD;    (* partition size *)
        pname     : str16;       (* f8.e3 is 8+1+3=12 but hey, let's be generous ! ;-) *)
        data      : SectorType;
    END;

PROCEDURE initList (VAR anchor:ptrToEntry);
BEGIN
    anchor:=NIL;
END initList;

PROCEDURE freeList (anchor:ptrToEntry);
VAR
    needed : CARDINAL;
    ptr    : ptrToEntry;
BEGIN
    needed := SIZE(entryType);
    ptr:=anchor;
    WHILE anchor # NIL DO
        ptr := anchor^.next;
        DEALLOCATE(anchor,needed);
        anchor:=ptr;
    END
END freeList;

(* ------------------------------------------------------------ *)

PROCEDURE chex (ifirst,icurr:CARDINAL):CHAR;
VAR
    c:CHAR;
BEGIN
    IF icurr = ifirst THEN (* only first hex has "$" prefix *)
        c:="$";
    ELSE
        c:=" "; (* separator in fact ! *)
    END;
    RETURN c;
END chex;

(*
good old Ralf is of no use here, or very, very partially :
INT 21 - DOS 2+ internal - TRANSLATE BIOS PARAMETER BLOCK TO DRIVE PARAM BLOCK
INT 21 - Windows95 - FAT32 - "Get_ExtDPB" - GET EXTENDED DPB

source code from FIPS, PART and XOSL were a little more useful for boot structures
though they disagree on FAT32 boot record parsing
*)

TYPE DOSbrType = RECORD
    jmpCode             : ARRAY [1..3] OF BYTE; (* "eb ?? 90" or  "e9 ?? ??" *)
    OEMname             : ARRAY [0..7] OF CHAR; (* $00 terminated *)
    bytesPerSector      : CARDINAL;             (* 512 *)
    sectorsPerCluster   : SHORTCARD;            (* power of 2 : 1,2,4,...,128 *)
    reservedSectors     : CARDINAL;             (* 1, starting at 0 *)
    numberOfFATs        : SHORTCARD;            (* 2 *)
    numberOfRootEntries : CARDINAL;             (* 512 *)
    numberOfTotalSectors: CARDINAL;             (* 0 if BIGDOS i.e. > 32Mb *)
    mediaDescriptor     : SHORTCARD;            (* $f8 *)
    sectorsPerFAT       : CARDINAL;
    sectorsPerTrack     : CARDINAL;
    numberOfHeads       : CARDINAL;
    hiddenSectors       : LONGCARD;             (* ignore high if dos < 4.0 - is first sector of partition *)
    bigTotal            : LONGCARD;             (* if numberOfTotalSectors was 0 *)
    physicalDriveNumber : SHORTCARD;            (* $80 or $81 *)
    dirtyflag           : BYTE;                 (* reserved *)
    extBRsignature      : BYTE;                 (* $29 *)
    volumeSerialNumber  : LONGCARD;
    volumeLabel         : ARRAY [0..10]  OF CHAR; (* $00 terminated *)
    fileSystemID        : ARRAY [0..7]   OF CHAR; (* padded with blanks *)
    xcode               : ARRAY [1..448] OF BYTE;

    magic               : CARDINAL;             (* $aa55 *)
END;

TYPE WINbrType = RECORD
    jmpCode             : ARRAY [1..3] OF BYTE; (* "eb 58 90" *)
    OEMname             : ARRAY [0..7] OF CHAR; (* $00 terminated *)
    bytesPerSector      : CARDINAL;             (* 512 *)
    sectorsPerCluster   : SHORTCARD;            (* power of 2 : 1,2,4,...,128 *)
    reservedSectors     : CARDINAL;             (* 33, starting at 0 *)
    numberOfFATs        : SHORTCARD;            (* 2 *)
    rsvd                : ARRAY [1..4] OF BYTE;
    mediaDescriptor     : SHORTCARD;            (* $f8 *)
    sectorsPerFAT       : CARDINAL;
    sectorsPerTrack     : CARDINAL;
    numberOfHeads       : CARDINAL;
    hiddenSectors       : LONGCARD;             (* ignore high if dos < 4.0 - is first sector of partition *)
    bigTotal            : LONGCARD;             (* if numberOfTotalSectors was 0 *)
    bigSectorsPerFAT    : LONGCARD;
    activeFATs          : SHORTCARD;            (* attrExt *)
    FSversionMajor      : SHORTCARD;
    FSversionMinor      : CARDINAL;
    firstClusterOfRoot  : LONGCARD;             (* 2 *)
    FSinfoSector        : CARDINAL;             (* 1 *)
    FSbackupBootSector  : CARDINAL;             (* 6 *)
    rsvd2               : ARRAY [1..12] OF BYTE;
    physicalDriveNumber : SHORTCARD;            (* $80 or $81 *)
    rsvd3               : BYTE;                 (* for NT *)
    extBRsignature      : BYTE;                 (* $29 *)
    volumeSerialNumber  : LONGCARD;
    volumeLabel         : ARRAY [0..10]  OF CHAR; (* $00 terminated *)
    fileSystemID        : ARRAY [0..7]   OF CHAR; (* padded with blanks *)
    xcode               : ARRAY [1..418] OF BYTE;
    magic               : LONGCARD;             (* $aa550000*)
END;

(* many conflicting sources : visopsys, WinHex, LinuxNFTS, testdisk, etc. *)

TYPE NTFSbrType = RECORD
    jmpCode             : ARRAY [1..3] OF BYTE; (* 00: $eb ?? 90 *)
    OEMname             : ARRAY [0..7] OF CHAR; (* 03: "NTFS    " *)
    bytesPerSector      : CARDINAL;             (* 0b: *)
    sectorsPerCluster   : SHORTCARD;            (* 0d: power of 2 *)
    reservedSectors     : CARDINAL;             (* 0e: *)
    numberOfFATs        : SHORTCARD;            (* 10: *)
    rootentries         : CARDINAL;             (* 11: *)
    numberOfSectors     : CARDINAL;             (* 13: *)
    mediaDescriptor     : SHORTCARD;            (* 15: *)
    FATlength           : CARDINAL;             (* 16: *)
    sectorsPerTrack     : CARDINAL;             (* 18: *)
    numberOfHeads       : CARDINAL;             (* 1a: *)
    hiddenSectors       : LONGCARD;             (* 1c: *)
    totalSectors        : LONGCARD;             (* 20: *)
    physicalDriveNumber : SHORTCARD;            (* 24: *)
    currhead            : SHORTCARD;            (* 25: *)
    xtdbootsig          : SHORTCARD;            (* 26: *)
    rsvd1               : SHORTCARD;            (* 27: *)
    sectorsPerVolume    : VERYLONGCARD;         (* 28: *)
    mftStart            : VERYLONGCARD;         (* 30: LCN of VCN 0 of the $MFT *)
    mftMirrorStart      : VERYLONGCARD;         (* 38: same for $MFTmirror *)
    clustersPerMFT      : SHORTCARD;            (* 40: *)
    rsvd2               : ARRAY[1..3] OF BYTE;  (* 41: *)
    clustersPerIndex    : SHORTCARD;            (* 44: *)
    rsvd3               : ARRAY[1..3] OF BYTE;  (* 45: *)
    volumeSerialNumber  : VERYLONGCARD;         (* 48: *)
    checksum            : LONGCARD;             (* 50: *)
    xcode               : ARRAY [1..426] OF BYTE; (* 54: *)
    magic               : CARDINAL;             (* 1fe: $aa55 *)
END;

PROCEDURE aboutBootCode (p:ptrToEntry;hnd:FIO.File );
VAR
    ok,isPrimary:BOOLEAN;
    partID:BYTE;
    primindex,ndxpart,subindex:CARDINAL;
    S,what,header:str128;
    block:LONGCARD;
    b : DOSbrType;
    bu: WINbrType;
    bn: NTFSbrType;
    i : CARDINAL;
BEGIN
    partID    := p^.pcode;
    IF isEmptyPart(partID) THEN RETURN; END; (* time to exit if empty *)

    IF isExtendedPart(partID) THEN RETURN; END;
    ok:= ( isFAT(partID) OR isFAT32(partID) OR isNTFS(partID) );
    IF NOT(ok) THEN RETURN; END; (* don't bother with most NTFS, Linux(es) and others *)

    isPrimary := p^.primary;
    primindex := CARDINAL( p^.pprimindex );
    ndxpart   := CARDINAL( p^.pndxpart);
    subindex  := CARDINAL( p^.psubindex);
    block     := p^.pfirst;

    getDesc(what, isPrimary,partID,primindex,ndxpart,subindex);

    Str.Concat(header,what," (entry #");
    Str.Append(header,fmt(ndxpart,10,0,"",""));
    Str.Append(header,") located at sector ");
    Str.Append(header,fmtlc(block,10,0,"",""));
    chapter(hnd,header);

IF isFAT(partID) THEN

    show(hnd,wi,"Type","FAT");
    b:=DOSbrType(p^.data);

    S:="";
    FOR i:=1 TO 3 DO
        Str.Append(S,fmt(CARDINAL( b.jmpCode[i]),16,2,"0",chex(1,i)));
    END;
    show(hnd,wi,"Jump"                ,S);

    Str.Copy(S, b.OEMname);RtrimBlanks(S);
    Str.Append(S,dquote);Str.Prepend(S,dquote);
    Str.Append(S," (");
    FOR i:=0 TO 7 DO
        Str.Append(S,fmt(CARDINAL( b.OEMname[i]),16,2,"0",chex(0,i)));
    END;
    Str.Append(S,")");
    show(hnd,wi,"OEM name",S);

    show(hnd,wi,"Bytes per sector"    ,fmt( b.bytesPerSector,10,0,"",""));
    show(hnd,wi,"Sectors per cluster" ,fmt(CARDINAL( b.sectorsPerCluster),10,0,"",""));
    show(hnd,wi,"Reserved sectors"    ,fmt( b.reservedSectors,10,0,"",""));
    show(hnd,wi,"Number of FATs"      ,fmt(CARDINAL( b.numberOfFATs),10,0,"",""));
    show(hnd,wi,"Root directory entries",fmt( b.numberOfRootEntries,10,0,"",""));
    show(hnd,wi,"Total sectors"       ,fmt( b.numberOfTotalSectors,10,0,"",""));
    show(hnd,wi,"Media descriptor"    ,fmt(CARDINAL( b.mediaDescriptor),16,2,"0","$"));
    show(hnd,wi,"Sectors per FAT"     ,fmt( b.sectorsPerFAT,10,0,"",""));
    show(hnd,wi,"Sectors per track"   ,fmt( b.sectorsPerTrack,10,0,"",""));
    show(hnd,wi,"Number of heads"     ,fmt( b.numberOfHeads,10,0,"",""));
    show(hnd,wi,"Hidden sectors"      ,fmtlc( b.hiddenSectors,10,0,"",""));
    show(hnd,wi,"Big total sectors"   ,fmtlc( b.bigTotal,10,0,"",""));
    show(hnd,wi,"Physical drive ID"   ,fmt(CARDINAL( b.physicalDriveNumber),16,2,"0","$"));
    show(hnd,wi,"Dirty flag"          ,fmt(CARDINAL( b.dirtyflag),16,2,"0","$"));
    show(hnd,wi,"Extended boot signature",fmt(CARDINAL( b.extBRsignature),16,2,"0","$"));
    show(hnd,wi,"Volume serial number",fmtlc( b.volumeSerialNumber,16,8,"0","$"));

    Str.Copy(S, b.volumeLabel);RtrimBlanks(S);
    Str.Append(S,dquote);Str.Prepend(S,dquote);
    Str.Append(S," (");
    FOR i:=0 TO 10 DO
        Str.Append(S,fmt(CARDINAL( b.volumeLabel[i]),16,2,"0",chex(0,i)));
    END;
    Str.Append(S,")");
    show(hnd,wi,"Volume label",S);

    Str.Copy(S, b.fileSystemID);RtrimBlanks(S);
    show(hnd,wi,"File system ID"      ,S);
    show(hnd,wi,"Signature"           ,fmt( b.magic,16,4,"0","$"));

END;

IF isFAT32(partID) THEN

    show(hnd,wi,"Type","FAT32");
    bu:=WINbrType(p^.data);

    S:="";
    FOR i:=1 TO 3 DO
        Str.Append(S,fmt(CARDINAL( bu.jmpCode[i]),16,2,"0",chex(1,i)));
    END;
    show(hnd,wi,"Jump"                ,S);

    Str.Copy(S, bu.OEMname);RtrimBlanks(S);
    Str.Append(S,dquote);Str.Prepend(S,dquote);
    Str.Append(S," (");
    FOR i:=0 TO 7 DO
        Str.Append(S,fmt(CARDINAL( bu.OEMname[i]),16,2,"0",chex(0,i)));
    END;
    Str.Append(S,")");
    show(hnd,wi,"OEM name",S);

    show(hnd,wi,"Bytes per sector"    ,fmt( bu.bytesPerSector,10,0,"",""));
    show(hnd,wi,"Sectors per cluster" ,fmt(CARDINAL( bu.sectorsPerCluster),10,0,"",""));
    show(hnd,wi,"Reserved sectors"    ,fmt( bu.reservedSectors,10,0,"",""));
    show(hnd,wi,"Number of FATs"      ,fmt(CARDINAL( bu.numberOfFATs),10,0,"",""));
    S:="";
    FOR i:=1 TO 4 DO
        Str.Append(S,fmt(CARDINAL( bu.rsvd[i]),16,2,"0",chex(1,i)));
    END;
    show(hnd,wi,"Reserved"            ,S);
    show(hnd,wi,"Media descriptor"    ,fmt(CARDINAL( bu.mediaDescriptor),16,2,"0","$"));
    show(hnd,wi,"Sectors per FAT"     ,fmt( bu.sectorsPerFAT,10,0,"",""));
    show(hnd,wi,"Sectors per track"   ,fmt( bu.sectorsPerTrack,10,0,"",""));
    show(hnd,wi,"Number of heads"     ,fmt( bu.numberOfHeads,10,0,"",""));
    show(hnd,wi,"Hidden sectors"      ,fmtlc( bu.hiddenSectors,10,0,"",""));
    show(hnd,wi,"Big total sectors"   ,fmtlc( bu.bigTotal,10,0,"",""));
    show(hnd,wi,"Big sectors per FAT" ,fmtlc( bu.bigSectorsPerFAT,10,0,"",""));
    show(hnd,wi,"Active FATs flag"    ,fmt( CARDINAL(bu.activeFATs),16,2,"0","$"));
    show(hnd,wi,"FS major version"    ,fmt( CARDINAL(bu.FSversionMajor),10,0,"",""));
    show(hnd,wi,"FS minor version"    ,fmt( bu.FSversionMinor,10,0,"",""));
    show(hnd,wi,"First cluster of root",fmtlc( bu.firstClusterOfRoot,10,0,"",""));
    show(hnd,wi,"FS info sector"      ,fmt( bu.FSinfoSector,10,0,"",""));
    show(hnd,wi,"FS backup boot sector",fmt( bu.FSbackupBootSector,10,0,"",""));
    S:="";
    FOR i:=1 TO 12 DO
        Str.Append(S,fmt(CARDINAL( bu.rsvd2[i]),16,2,"0",chex(1,i)));
    END;
    show(hnd,wi,"Reserved"            ,S);
    show(hnd,wi,"Physical drive ID"   ,fmt(CARDINAL( bu.physicalDriveNumber),16,2,"0","$"));
    show(hnd,wi,"Reserved for NT"     ,fmt(CARDINAL( bu.rsvd3),16,2,"0","$"));
    show(hnd,wi,"Extended boot signature",fmt(CARDINAL( bu.extBRsignature),16,2,"0","$"));
    show(hnd,wi,"Volume serial number",fmtlc( bu.volumeSerialNumber,16,8,"0","$"));

    Str.Copy(S, bu.volumeLabel);RtrimBlanks(S);
    Str.Append(S,dquote);Str.Prepend(S,dquote);
    Str.Append(S," (");
    FOR i:=0 TO 10 DO
        Str.Append(S,fmt(CARDINAL( bu.volumeLabel[i]),16,2,"0",chex(0,i)));
    END;
    Str.Append(S,")");
    show(hnd,wi,"Volume label",S);

    Str.Copy(S, bu.fileSystemID);RtrimBlanks(S);
    show(hnd,wi,"File system ID"      ,S);
    show(hnd,wi,"Signature"           ,fmtlc( bu.magic,16,8,"0","$"));

END;

IF isNTFS(partID) THEN
    show(hnd,wi,"Type","NTFS");
    bn:=NTFSbrType(p^.data);

    S:="";
    FOR i:=1 TO 3 DO
        Str.Append(S,fmt(CARDINAL( bn.jmpCode[i]),16,2,"0",chex(1,i)));
    END;
    show(hnd,wi,"Jump"                ,S);

    Str.Copy(S, bn.OEMname);RtrimBlanks(S);
    Str.Append(S,dquote);Str.Prepend(S,dquote);
    Str.Append(S," (");
    FOR i:=0 TO 7 DO
        Str.Append(S,fmt(CARDINAL( bn.OEMname[i]),16,2,"0",chex(0,i)));
    END;
    Str.Append(S,")");
    show(hnd,wi,"OEM name",S);

    show(hnd,wi,"Bytes per sector"    ,fmt( bn.bytesPerSector,10,0,"",""));
    show(hnd,wi,"Sectors per cluster" ,fmt(CARDINAL( bn.sectorsPerCluster),10,0,"",""));
    show(hnd,wi,"Number of FATs"      ,fmt(CARDINAL( bn.numberOfFATs),10,0,"",""));
    show(hnd,wi,"Root entries"        ,fmt( bn.rootentries,10,0,"",""));
    (* show(hnd,wi,"Number of sectors"   ,fmt( bn.numberOfSectors,10,0,"","")); *)
    show(hnd,wi,"Media descriptor"    ,fmt(CARDINAL( bn.mediaDescriptor),16,2,"0","$"));
    show(hnd,wi,"Sectors per FAT"     ,fmt( bn.FATlength,10,0,"",""));
    show(hnd,wi,"Sectors per track"   ,fmt( bn.sectorsPerTrack,10,0,"",""));
    show(hnd,wi,"Number of heads"     ,fmt( bn.numberOfHeads,10,0,"",""));
    show(hnd,wi,"Hidden sectors"      ,fmtlc( bn.hiddenSectors,10,0,"",""));
    show(hnd,wi,"Big total sectors"   ,fmtlc( bn.totalSectors,10,0,"",""));
    show(hnd,wi,"Physical drive ID"   ,fmt(CARDINAL( bn.physicalDriveNumber),16,2,"0","$"));
    (* show(hnd,wi,"Current head"        ,fmt(CARDINAL( bn.currhead),16,2,"0","$")); *)
    (* show(hnd,wi,"Extended boot signature"  ,fmt(CARDINAL( bn.xtdbootsig),16,2,"0","$")); *)
    (* show(hnd,wi,"Reserved"            ,fmt(CARDINAL( bn.rsvd1),16,2,"0","$")); *)

    show(hnd,wi,"Sectors per volume"  ,fmtvlc( bn.sectorsPerVolume,10,0,"",""));
    show(hnd,wi,"MFT start"           ,fmtvlc( bn.mftStart,10,0,"",""));
    show(hnd,wi,"MFT mirror start"    ,fmtvlc( bn.mftMirrorStart,10,0,"",""));
    show(hnd,wi,"Clusters per MFT"    ,fmt(CARDINAL( bn.clustersPerMFT),10,0,"",""));
    (* S:="";
    FOR i:=1 TO 3 DO
        Str.Append(S,fmt(CARDINAL( bn.rsvd2[i]),16,2,"0",chex(1,i)));
    END;
    show(hnd,wi,"Reserved"            ,S); *)
    show(hnd,wi,"Clusters per index"  ,fmt(CARDINAL( bn.clustersPerIndex),10,0,"",""));
    (* S:="";
    FOR i:=1 TO 3 DO
        Str.Append(S,fmt(CARDINAL( bn.rsvd3[i]),16,2,"0",chex(1,i)));
    END;
    show(hnd,wi,"Reserved"            ,S); *)
    show(hnd,wi,"Volume serial number",fmtvlc( bn.volumeSerialNumber,16,8,"0","$"));
    show(hnd,wi,"Checksum"            ,fmtlc( bn.checksum,16,8,"0","$"));
    show(hnd,wi,"Signature"           ,fmt  ( bn.magic,16,4,"0","$"));
END;

END aboutBootCode;

(* ------------------------------------------------------------ *)

PROCEDURE aboutSector (p:ptrToEntry;hnd:FIO.File);
CONST
    hcount=16;
VAR
    isPrimary:BOOLEAN;
    partID:BYTE;
    primindex,ndxpart,subindex:CARDINAL;
    what,header:str128;
    block:LONGCARD;
    i,j,v:CARDINAL;
    S,S2:str128;
    alcatraz:BOOLEAN;
BEGIN
    partID    := p^.pcode;
    IF isEmptyPart(partID) THEN RETURN; END; (* time to exit if empty *)

    isPrimary := p^.primary;
    primindex := CARDINAL( p^.pprimindex );
    ndxpart   := CARDINAL( p^.pndxpart);
    subindex  := CARDINAL( p^.psubindex);
    block     := p^.pfirst;

    getDesc(what, isPrimary,partID,primindex,ndxpart,subindex);

    Str.Concat(header,what," (entry #");
    Str.Append(header,fmt(ndxpart,10,0,"",""));
    Str.Append(header,") located at sector ");
    Str.Append(header,fmtlc(block,10,0,"",""));
    chapter(hnd,header);

    i:=firstByteInSector;
    alcatraz:=FALSE;
    LOOP
        Str.Concat(S,fmt(i,16,4,"0",""),sepaddr);
        Str.Copy(S2,sepascii);
        j:=1;
        LOOP
            IF alcatraz THEN
                Str.Append(S, " "); Str.Append(S, "  "); (* ## *)
                Str.Append(S2," ");
            ELSE
                v:=CARDINAL(p^.data[i]);
                Str.Append(S, " "); Str.Append(S, fmt(v,16,2,"0",""));
                Str.Append(S2,fmtchar(FALSE, BYTE(v) ));
            END;
            INC(i);
            IF i > lastByteInSector THEN alcatraz:=TRUE; END;
            INC(j);
            IF j > hcount THEN EXIT; END;
        END;
        Str.Append(S,S2);Str.Append(S,nl);
        fdmp(hnd,S);
        IF alcatraz THEN EXIT; END;
    END;
END aboutSector;

(* ------------------------------------------------------------ *)

PROCEDURE roundnum (VAR mb,frac:LONGCARD; total,divisor:LONGCARD;decimales:CARDINAL);
VAR
    v,limit:LONGCARD;
    i:CARDINAL;
BEGIN

    mb   := total DIV divisor;  (* integer part *)
    v    := total - mb*divisor; (* remainder *)

    limit:= 1;
    FOR i:=1 TO (decimales+1) DO v:=v*10; limit:=limit*10; END;
    DEC(limit);

    frac:=v DIV divisor;

    IF (frac MOD 10) >= 5 THEN
        INC(frac,10);
        IF frac > limit THEN frac:=0; INC(mb);END; (* not pretty but close enough *)
    END;
    frac := frac DIV 10;
END roundnum;

PROCEDURE fmtpartsize (VAR R:str16;isprimary:BOOLEAN;id:BYTE;partblocks:LONGCARD):BOOLEAN;
CONST
    (* assume 512 bytes per sector *)
    oneMega = LONGCARD(2048);  (* expressed in blocks : 1024 * 1024 / 512 *)
    oneGiga = LONGCARD(1024*oneMega);  (* idem : 1024 * 1024 * 1024 / 512 *)
    fracsep = dot; (* english style for consistency *)
    decimales=2;
VAR
    ok:BOOLEAN;
    frac,mb:LONGCARD;
BEGIN
    Str.Copy(R,"?");
    IF isEmptyPart(id) THEN RETURN FALSE;END; (* cannot happen *)

    ok:=(isprimary OR (isExtendedPart(id)=FALSE) );
    IF ok THEN
        roundnum(mb,frac, partblocks,oneMega,decimales);
        Str.Copy  (R, fmtlc(mb,10,0,"","") );
        Str.Append(R,fracsep);
        Str.Append(R, fmtlc(frac,10,1,"",""));
        Str.Append(R," Mb");
    END;
    RETURN ok;
END fmtpartsize;

(* an empty partition can appear only here *)

PROCEDURE aboutPart (p:ptrToEntry;hnd:FIO.File;
                    ALTFORMAT,showCLI,addCR:BOOLEAN; unit:BYTE;
                    trackcount,headcount,sectorcount:CARDINAL );
VAR
    isPrimary:BOOLEAN;
    partID,bootflag : BYTE;
    block,total,preceding:LONGCARD;
    sHex,F,sNicePartSize:str16;
    sID:str256; (* may be long *)
    primindex,ndxpart,subindex,q:CARDINAL;
    sTrack,sHead,sSector:CARDINAL;
    eTrack,eHead,eSector:CARDINAL;
    what,header,S:str128;
    SS:str80;
    FF:str16;
    sPiste,sTete,sSecteur:CARDINAL;
    ePiste,eTete,eSecteur:CARDINAL;
BEGIN
    partID    := p^.pcode;
    isPrimary := p^.primary;
    primindex := CARDINAL( p^.pprimindex );
    ndxpart   := CARDINAL( p^.pndxpart);
    subindex  := CARDINAL( p^.psubindex);

    getDesc(what, isPrimary,partID,primindex,ndxpart,subindex);

    Str.Concat(header,what," (entry #");
    Str.Append(header,fmt(ndxpart,10,0,"",""));

    IF isEmptyPart(partID) THEN
        Str.Append(header,")");
    ELSE
        block := p^.pfirst;
        Str.Append(header,") located at sector ");
        Str.Append(header,fmtlc(block,10,0,"",""));
    END;
    chapter(hnd,header);

    getIDpartStr (partID, sHex,sID);
    show(hnd,wi,strCode,sHex);
    show(hnd,wi,strType,sID);

    Str.Copy(S,getIDshortDesc (partID,isPrimary, FALSE) );
    show(hnd,wi,strDesc,S);


    IF isEmptyPart(partID) THEN RETURN; END; (* time to exit if empty *)


    IF addCR THEN fdmp(hnd,nl); END;

    bootflag := p^.pbootflag;

    block    := p^.pfirst;
    total    := p^.pcount;
    preceding:= p^.pbefore;

    sTrack   := CARDINAL(p^.bT);
    sHead    := CARDINAL(p^.bH);
    sSector  := CARDINAL(p^.bS);

    eTrack   := CARDINAL(p^.eT);
    eHead    := CARDINAL(p^.eH);
    eSector  := CARDINAL(p^.eS);

    Str.Copy(F, p^.pname); (* f8.e3 *)

    Str.Copy(S,fmt( CARDINAL(bootflag),16,2,"0","$"));
    CASE bootflag OF
    | 80H : Str.Append(S," (yes)");
    | 00H : Str.Append(S," (no)");
    ELSE
            Str.Append(S," (illegal value)");
    END;
    show(hnd,wi,strActive,S);
    IF addCR THEN fdmp(hnd,nl); END;

    IF NOT(ALTFORMAT) THEN
        show(hnd,wi,strFirstSector,beautifiedlc(block,blank,sepdot,wiblock));
        show(hnd,wi,strTotal,beautifiedlc(total,blank,sepdot,wiblock));
        show(hnd,wi,strPreceding,beautifiedlc(preceding,blank,sepdot,wiblock));
    ELSE
        show(hnd,wi,strFirstSector,fmtlc(block,10,wiblockraw,blank,""));
        show(hnd,wi,strTotal,fmtlc(total,10,wiblockraw,blank,""));
        show(hnd,wi,strPreceding,fmtlc(preceding,10,wiblockraw,blank,""));
    END;
    IF addCR THEN fdmp(hnd,nl); END;

    showTHSrange(hnd,wi, sTrack,sHead,sSector,eTrack,eHead,eSector, strStartEndBiosTHS);
    (* IF addCR THEN fdmp(hnd,nl);END; *)

    blockToCHS (trackcount,headcount,sectorcount,block, sPiste,sTete,sSecteur);
    blockToCHS (trackcount,headcount,sectorcount,(block+total-1), ePiste,eTete,eSecteur);
    showTHSrange(hnd,wi, sPiste,sTete,sSecteur,ePiste,eTete,eSecteur, strStartEndActualTHS);
    IF addCR THEN fdmp(hnd,nl);END;

    show(hnd,wi,strSignature,fmt(  MBRrecordType(p^.data).Signature,16,4,"0","$") );

    IF fmtpartsize(sNicePartSize, isPrimary,partID,total) THEN
        IF addCR THEN fdmp(hnd,nl);END;
        show(hnd,wi,strPartSize,sNicePartSize);
    END;

    IF showCLI THEN
        IF addCR THEN fdmp(hnd,nl); END;
        Str.Copy(S,strCLIrecovery); (* unit W block filename *)
        Str.Subst(S,placeholder,fmt( CARDINAL(unit),16,2,"0","$"));
        Str.Subst(S,placeholder,fmtlc(block,10,wiblockraw,blank,""));
        Str.Subst(S,placeholder,F);
        show(hnd,wi,strRecovery,S);

        IF addCR THEN fdmp(hnd,nl); END;
        Str.Copy(S,strCLIcloning); (* -c unit $?? block,count *)
        Str.Subst(S,placeholder,fmt( CARDINAL(unit),16,2,"0","$"));
        Str.Subst(S,placeholder,fmtlc(block,10,1,blank,""));  (* don't pad #,# *)
        Str.Subst(S,placeholder,fmtlc(total,10,1,blank,""));

        Str.Copy(FF,F);
        Str.Subst(FF,filePrefix,"");
        q:=Str.CharPos(FF,dot);
        IF q # MAX(CARDINAL) THEN FF[q]:=nullchar;END;
        Str.Lows(FF);

        Str.Copy(SS,strCloning);
        Str.Subst(SS,placeholderabout,FF);

        show(hnd,wi,SS,S);
    END;
END aboutPart;

(* ------------------------------------------------------------ *)

PROCEDURE aboutMe (p:ptrToEntry;hnd:FIO.File;ALTFORMAT:BOOLEAN);
CONST
    sSep     = "  ";
    sPrimary = "  Pri";
    sLogical = "  Log";
    sBoot    = ",Boot"+sSep;
    sNoBoot  = "     "+sSep;
VAR
    S:str128;
    R:str16;
    partID,bootflag : BYTE;
    ndxpart: CARDINAL;
    isPrimary:BOOLEAN;
    block,total:LONGCARD;
BEGIN
    partID    := p^.pcode;
    IF isEmptyPart(partID) THEN RETURN; END; (* time to exit if empty *)

    Str.Concat(S,fmt(CARDINAL(partID),16,2,"0","$"),  sSep);

    ndxpart   := CARDINAL( p^.pndxpart);
    Str.Append(S, fmt(ndxpart,10,1,"",""));

    isPrimary := p^.primary;
    IF isPrimary THEN
        R:=sPrimary;
    ELSE
        R:=sLogical;
    END;
    Str.Append(S,R);

    bootflag := p^.pbootflag;
    IF bootflag = BYTE(080H) THEN
        R:=sBoot;
    ELSE
        R:=sNoBoot;
    END;
    Str.Append(S,R);

    Str.Append(S, getIDshortDesc(partID,isPrimary,TRUE));
    Str.Append(S,sSep);

    block    := p^.pfirst;
    total    := p^.pcount;

    IF NOT(ALTFORMAT) THEN
        Str.Append(S, beautifiedlc(block,blank,sepdot,wiblock));
        Str.Append(S,sSep);
        Str.Append(S, beautifiedlc(total,blank,sepdot,wiblock));
    ELSE
        Str.Append(S, fmtlc(block,10,wiblockraw,blank,""));
        Str.Append(S,sSep);
        Str.Append(S, fmtlc(total,10,wiblockraw,blank,""));
    END;
    Str.Append(S,sSep);

    Str.Copy(R, p^.pname); (* f8.e3 *)
    Str.Append(S,R);
    Str.Append(S,nl);
    fdmp(hnd,S);
END aboutMe;

(* ------------------------------------------------------------ *)

(* assume buffMasterBoot is ok *)

PROCEDURE aboutMBR (hnd:FIO.File;unit:BYTE;
                   ALTFORMAT,showCLI,addCR,HEXDUMP:BOOLEAN;e3:ARRAY OF CHAR);
CONST
    hcount=16;
    firstblock = 0; (* hard-coded out of lazyness *)
VAR
    header:str128;
    block:LONGCARD;
    i,j,v:CARDINAL;
    S,S2:str128;
    alcatraz:BOOLEAN;
    F:str16;
    winXPid:LONGCARD;
BEGIN
    block:=firstblock;
    header := "Master Boot Record (MBR) located at sector ";
    Str.Append(header,fmtlc(block,10,0,"",""));
    chapter(hnd,header);
IF HEXDUMP THEN
    i:=firstByteInSector;
    alcatraz:=FALSE;
    LOOP
        Str.Concat(S,fmt(i,16,4,"0",""),sepaddr);
        Str.Copy(S2,sepascii);
        j:=1;
        LOOP
            IF alcatraz THEN
                Str.Append(S, " "); Str.Append(S, "  "); (* ## *)
                Str.Append(S2," ");
            ELSE
                IF NOT ( DYNALLOC ) THEN
                    v:=CARDINAL( buffMasterBoot.bytearray[i] );
                ELSE
                    v:=CARDINAL( pbuffMasterBoot^.bytearray[i] );
                END;
                Str.Append(S, " "); Str.Append(S, fmt(v,16,2,"0",""));
                Str.Append(S2,fmtchar(FALSE, BYTE(v) ));
            END;
            INC(i);
            IF i > lastByteInSector THEN alcatraz:=TRUE; END;
            INC(j);
            IF j > hcount THEN EXIT; END;
        END;
        Str.Append(S,S2);Str.Append(S,nl);
        fdmp(hnd,S);
        IF alcatraz THEN EXIT; END;
    END;
ELSE
    (*
    S:="";
    FOR i:=1 TO 3 DO
        IF i > 1 THEN Str.Append(S," "); END;
        IF NOT ( DYNALLOC ) THEN
        Str.Append(S,fmt(CARDINAL( buffMasterBoot.bytearray[i-1]),16,2,"0","$"));
        (*%E *)
        (*%T DYNALLOC *)
        Str.Append(S,fmt(CARDINAL( pbuffMasterBoot^.bytearray[i-1]),16,2,"0","$"));
        (*%E *)
    END;
    show(hnd,wi,"Jump"                ,S);

    IF addCR THEN fdmp(hnd,nl); END;
    *)

    IF NOT ( DYNALLOC ) THEN
        Lib.FarMove(FarADR(buffMasterBoot.bytearray[winXPuniqueIDoffset]),FarADR(winXPid),SIZE(winXPid));
        show(hnd,wi,strWinXPuniqueID,fmtlc(winXPid,16,8,"0","$") );
        IF addCR THEN fdmp(hnd,nl); END;
        show(hnd,wi,strSignature,fmt(  buffMasterBoot.Signature,16,4,"0","$") );
    ELSE
        Lib.FarMove(FarADR(pbuffMasterBoot^.bytearray[winXPuniqueIDoffset]),FarADR(winXPid),SIZE(winXPid));
        show(hnd,wi,strWinXPuniqueID,fmtlc(winXPid,16,8,"0","$") );
        IF addCR THEN fdmp(hnd,nl); END;
        show(hnd,wi,strSignature,fmt(  pbuffMasterBoot^.Signature,16,4,"0","$") );
    END;

    IF showCLI THEN
        IF addCR THEN fdmp(hnd,nl); END;
        Str.Concat(F,fileMBR,e3);
        Str.Copy(S,strCLIrecovery);
        Str.Subst(S,placeholder,fmt( CARDINAL(unit),16,2,"0","$"));
        Str.Subst(S,placeholder,fmtlc(block,10,wiblockraw,blank,""));
        Str.Subst(S,placeholder,F);
        show(hnd,wi,strRecovery,S);

        IF addCR THEN fdmp(hnd,nl); END;
        Str.Concat(F,fileTRACK0,e3);
        Str.Copy(S,strCLIrecovery);
        Str.Subst(S,placeholder,fmt( CARDINAL(unit),16,2,"0","$"));
        Str.Subst(S,placeholder,fmtlc(block,10,wiblockraw,blank,""));
        Str.Subst(S,placeholder,F);
        show(hnd,wi,strRecovery,S);
    END;
END;
END aboutMBR;

(* ------------------------------------------------------------ *)

PROCEDURE showInfos (anchor:ptrToEntry; hnd:FIO.File;
                    ALTFORMAT,showCLI,addCR:BOOLEAN;
                    XBIOS:BOOLEAN;
                    trackcount,headcount,sectorcount:CARDINAL;unit:BYTE;
                    e3:ARRAY OF CHAR );
CONST
(*         "$06  1  Pri,Boot  ????????????????  ###,###,###  ###,###,###  $$$$$$$$.$$$" *)
strHeader ="Type #  Status    Terse ID          Start        Size         File";
(*         "$06  1  Pri,Boot  ????????????????  #########  #########  $$$$$$$$.$$$" *)
strHeaderA="Type #  Status    Terse ID          Start      Size       File";
VAR
    ptr:ptrToEntry;
    header,pattern:str128;
BEGIN

    (* synthesis first *)

    IF NOT(ALTFORMAT) THEN
        header:=strHeader;
    ELSE
        header:=strHeaderA;
    END;
    chapter(hnd,header);
    ptr:=anchor;
    WHILE ptr # NIL DO
        aboutMe(ptr, hnd,ALTFORMAT);
        ptr:=ptr^.next;
    END;

    (* infos about MBR *)

    aboutMBR(hnd,unit,ALTFORMAT,showCLI,addCR,FALSE,e3);

    (* infos about each partition *)

    ptr:=anchor;
    WHILE ptr # NIL DO
        aboutPart (ptr, hnd,ALTFORMAT,showCLI,addCR,unit,
                  trackcount,headcount,sectorcount);
        ptr:=ptr^.next;
    END;

    (* infos about boot code *)

    ptr:=anchor;
    WHILE ptr # NIL DO
        aboutBootCode(ptr, hnd);
        ptr:=ptr^.next;
    END;

    (* raw dumps *)

    aboutMBR(hnd,unit,ALTFORMAT,showCLI,addCR,TRUE,e3);

    ptr:=anchor;
    WHILE ptr # NIL DO
        aboutSector(ptr, hnd);
        ptr:=ptr^.next;
    END;

END showInfos;

(* ------------------------------------------------------------ *)

(* assume buffExt content is ok *)

PROCEDURE grabPart (VAR anchor:ptrToEntry;
                    isPrimary:BOOLEAN; primindex,ndxpart,subindex:CARDINAL;
                    unit:BYTE;baseblock,parentBlock:LONGCARD;
                    XBIOS:BOOLEAN;trackcount,headcount,sectorcount:CARDINAL;
                    e3:ARRAY OF CHAR):CARDINAL;
CONST
    sEMPTYPARTNAME = "_EMPTY_.$$$"; (* this F8E3 should never appear ! *)
VAR
    p : ptrToEntry;
    needed:CARDINAL;
    partID : BYTE;
    F, F8E3 : str16;
    preceding,total,block:LONGCARD;
    bcylinder,bhead,bsector:BYTE;
    vcylinder,vhead,vsector:WORD;
    track,head,sector:CARDINAL;
BEGIN
    needed:=SIZE(entryType);
    IF Available(needed)=FALSE THEN RETURN errStorage;END ;
    IF anchor = NIL THEN
        ALLOCATE( anchor,needed);
        p:=anchor;
    ELSE
        p:=anchor;
        WHILE p^.next # NIL DO
            p:=p^.next;
        END;
        ALLOCATE(p^.next, needed);
        p:=p^.next;
    END;
    p^.next       := NIL;

    p^.primary    := isPrimary;
    p^.pprimindex := SHORTCARD(primindex);
    p^.pndxpart   := SHORTCARD(ndxpart);
    p^.psubindex  := SHORTCARD(subindex);

    IF NOT ( DYNALLOC ) THEN
    partID        := buffExt.PartitionX[ndxpart].OSindicator;
    ELSE
    partID        := pbuffExt^.PartitionX[ndxpart].OSindicator;
    END;
    p^.pcode      := partID;
    p^.parentblock:= parentBlock; (* was baseblock *)

    IF isEmptyPart(partID) THEN

        Str.Copy(p^.pname,sEMPTYPARTNAME); (* this should never appear ! *)

        RETURN errNone;
    END;
    IF NOT ( DYNALLOC ) THEN
    p^.pbootflag  := buffExt.PartitionX[ndxpart].BootIndicator ;
    preceding    := buffExt.PartitionX[ndxpart].SectorsPreceding;
    total        := buffExt.PartitionX[ndxpart].LengthInSectors;
    ELSE
    p^.pbootflag  := pbuffExt^.PartitionX[ndxpart].BootIndicator ;
    preceding    := pbuffExt^.PartitionX[ndxpart].SectorsPreceding;
    total        := pbuffExt^.PartitionX[ndxpart].LengthInSectors;
    END;

    block        := preceding+baseblock;

    p^.pfirst     := block;
    p^.pcount     := total;
    p^.pbefore    := preceding;

    IF NOT ( DYNALLOC ) THEN
    bcylinder    := buffExt.PartitionX[ndxpart].StartTrack;
    bhead        := buffExt.PartitionX[ndxpart].StartHead;
    bsector      := buffExt.PartitionX[ndxpart].StartSector;
    ELSE
    bcylinder    := pbuffExt^.PartitionX[ndxpart].StartTrack;
    bhead        := pbuffExt^.PartitionX[ndxpart].StartHead;
    bsector      := pbuffExt^.PartitionX[ndxpart].StartSector;
    END;
    decodeCS(bcylinder,bsector,vcylinder,vsector);
    vhead        := WORD(bhead);

    p^.bT         := vcylinder;
    p^.bH         := SHORTCARD(vhead);
    p^.bS         := SHORTCARD(vsector);

    IF NOT ( DYNALLOC ) THEN
    bcylinder    := buffExt.PartitionX[ndxpart].EndTrack;
    bhead        := buffExt.PartitionX[ndxpart].EndHead;
    bsector      := buffExt.PartitionX[ndxpart].EndSector;
    ELSE
    bcylinder    := pbuffExt^.PartitionX[ndxpart].EndTrack;
    bhead        := pbuffExt^.PartitionX[ndxpart].EndHead;
    bsector      := pbuffExt^.PartitionX[ndxpart].EndSector;
    END;

    decodeCS(bcylinder,bsector,vcylinder,vsector);
    vhead        := WORD(bhead);

    p^.eT         := vcylinder;
    p^.eH         := SHORTCARD(vhead);
    p^.eS         := SHORTCARD(vsector);

    getAlias(F,  isPrimary,partID,primindex,ndxpart,subindex);
    Str.Concat(F8E3,F,e3);
    Str.Copy(p^.pname,F8E3);

    (* now, fill p^.data with sector located at block position *)

    blockToCHS (trackcount,headcount,sectorcount,
               block,
               track,head,sector);
    IF procSector (unit,XBIOS,opRead,block,track,head,sector,
                  Seg(p^.data),Ofs(p^.data))=FALSE THEN
        RETURN errInt13h;
    END;

    IF DEBUG THEN dumpSector(showAsRaw, SectorType(p^.data) );END;

    RETURN errNone;
END grabPart;

(* assume buffMasterBoot content is ok *)

PROCEDURE grabExtendedPartX (VAR anchor:ptrToEntry;
                             primindex:CARDINAL;
                             XBIOS:BOOLEAN;
                             trackcount,headcount,sectorcount:CARDINAL;
                             unit:BYTE; e3:ARRAY OF CHAR):CARDINAL;
VAR
    partID : BYTE;
    baseblockxtd,baseblockpart,block : LONGCARD;
    ndxpart,subindex : CARDINAL;
    exthere,loghere,alcatraz,valid:BOOLEAN;
    rc:CARDINAL;
    parentBlock:LONGCARD;
BEGIN
    IF NOT ( DYNALLOC ) THEN
    partID := buffMasterBoot.PartitionX[primindex].OSindicator;
    ELSE
    partID := pbuffMasterBoot^.PartitionX[primindex].OSindicator;
    END;
    IF isExtendedPart(partID)=FALSE THEN RETURN errNone;END;

    (* fill buffExt using buffMasterBoot infos *)

    IF NOT ( DYNALLOC ) THEN
    baseblockxtd := buffMasterBoot.PartitionX[primindex].SectorsPreceding; (* relative to primary ext *)
    ELSE
    baseblockxtd := pbuffMasterBoot^.PartitionX[primindex].SectorsPreceding; (* relative to primary ext *)
    END;

    baseblockpart:= baseblockxtd;                                      (* relative to local ext *)
    IF readExtSector (XBIOS,unit,trackcount,headcount,sectorcount,baseblockxtd)=FALSE THEN
        RETURN errReadExtSector;
    END;

    IF NOT ( DYNALLOC ) THEN
    IF DEBUG THEN dumpSector(showAsTable, SectorType(buffExt) );END;
    ELSE
    IF DEBUG THEN dumpSector(showAsTable, SectorType(pbuffExt^) );END;
    END;

    (* let's hope "there can be only one" logical and extended -- or none *)

    subindex := 0; (* 0 will become "A", etc. *)
    LOOP
        (* scan current buffExt for logical partition, relative to baseblockpart *)
        loghere:=FALSE;
        ndxpart:=firstPartNdx;
        LOOP
            IF NOT ( DYNALLOC ) THEN
            partID:= buffExt.PartitionX[ndxpart].OSindicator;
            ELSE
            partID:= pbuffExt^.PartitionX[ndxpart].OSindicator;
            END;
            valid := NOT ( isEmptyPart(partID) );
            valid := valid AND NOT(isExtendedPart(partID));
            IF valid THEN
                parentBlock:=baseblockpart;
                rc:=grabPart (anchor, FALSE , primindex, ndxpart, subindex,
                              unit,baseblockpart,parentBlock,
                              XBIOS,trackcount,headcount,sectorcount, e3);
                IF rc # errNone THEN RETURN rc; END;
                loghere:=TRUE;
                EXIT;
            END;
            INC(ndxpart);
            IF ndxpart > lastPartNdx THEN EXIT; END;
        END;
        (* scan current buffExt for extended boot record, relative to baseblockxtd *)
        exthere:=FALSE;
        ndxpart:=firstPartNdx;
        LOOP
            IF NOT ( DYNALLOC ) THEN
            partID := buffExt.PartitionX[ndxpart].OSindicator;
            ELSE
            partID := pbuffExt^.PartitionX[ndxpart].OSindicator;
            END;
            valid := isExtendedPart(partID);
            IF valid THEN
                parentBlock:=baseblockpart;
                rc:=grabPart (anchor, FALSE , primindex, ndxpart, subindex,
                              unit,baseblockxtd,parentBlock,
                              XBIOS,trackcount,headcount,sectorcount, e3);
                IF rc # errNone THEN RETURN rc; END;
                (* now read next extended record and fill buffExt using buffExt infos *)
                IF NOT ( DYNALLOC ) THEN
                block := buffExt.PartitionX[ndxpart].SectorsPreceding;
                ELSE
                block := pbuffExt^.PartitionX[ndxpart].SectorsPreceding;
                END;
                INC(block,baseblockxtd); (* damn crap is relative to primary *)
                baseblockpart:=block;    (* damn crap is relative to local extended *)

                IF readExtSector (XBIOS,unit,trackcount,headcount,sectorcount,block)=FALSE THEN
                    RETURN errReadExtSector;
                END;
                IF NOT ( DYNALLOC ) THEN
                IF DEBUG THEN dumpSector(showAsTable, SectorType(buffExt) );END;
                ELSE
                IF DEBUG THEN dumpSector(showAsTable, SectorType(pbuffExt^) );END;
                END;
                exthere:=TRUE;
                EXIT;
            END;
            INC(ndxpart);
            IF ndxpart > lastPartNdx THEN EXIT; END;
        END;

        alcatraz:= NOT(exthere);
        IF alcatraz THEN EXIT; END;
        IF DEBUG THEN
            IF ChkEscape() THEN RETURN errAborted; END; (* safety to escape from an infinite loop *)
        END;
        INC(subindex);
    END;
    RETURN errNone;
END grabExtendedPartX;

(* assume buffMasterBoot content is ok *)

PROCEDURE grabMainPartX (VAR anchor:ptrToEntry;
                         primindex:CARDINAL;
                         unit:BYTE;
                         XBIOS:BOOLEAN;trackcount,headcount,sectorcount:CARDINAL;
                         e3:ARRAY OF CHAR):CARDINAL;
CONST
    baseblockmain = 0; (* primary MBR partitions don't need silly relative computations *)
VAR
    rc     :CARDINAL;
    ndxpart,subindex:CARDINAL;
    parentBlock:LONGCARD;
BEGIN
    IF NOT ( DYNALLOC ) THEN
    buffExt:=buffMasterBoot;
    ELSE
    pbuffExt^:=pbuffMasterBoot^;
    END;
    ndxpart:=primindex; (* used to retrieve informations from sector *)
    subindex:=0;        (* not used for primary partitions *)
    parentBlock:=baseblockmain;
    rc:=grabPart (anchor, TRUE ,primindex, ndxpart, subindex,
                 unit,baseblockmain,parentBlock,
                 XBIOS,trackcount,headcount,sectorcount, e3);
    IF rc # errNone THEN RETURN rc; END;
    RETURN errNone;
END grabMainPartX;

PROCEDURE chkProblems (VAR pb,pbmem,pbfatal:CARDINAL; rc:CARDINAL);
BEGIN
    CASE rc OF
    | errNone:
        ;
    | errInt13h,errXBIOSint13h:
        INC(pbfatal);
    | errStorage:
        INC(pbmem);
    ELSE
        INC(pb);
    END;
END chkProblems;

PROCEDURE saveInfos (OVERWRITE,IGNORERO,XBIOS,XBIOSavailable,
                    NEWGEOMETRY,PERFECTGEOMETRY,
                    ALTFORMAT,showCLI,addCR,ASSUMESTANDARDTRACK0,FORCESECTORCOUNT:BOOLEAN;
                    EDDmajor, EDDflag:BYTE; BESTFIT:CARDINAL;
                    unit:BYTE;trackcount,headcount,sectorcount:CARDINAL;
                    base,e3:ARRAY OF CHAR;
                    maxtrackorg,maxheadorg,maxsectororg:CARDINAL;
                    totalSectors:LONGCARD;
                    maxtrack,maxhead,maxsector:CARDINAL;
                    maxblock, blockcount:LONGCARD): CARDINAL;
VAR
    hnd:FIO.File;
    what,target:str128;
    pb,pbmem,pbfatal,primindex,j,rc:CARDINAL;
    anchor:ptrToEntry;
BEGIN
    Str.Concat(what,"Unit ", fmt( CARDINAL(unit),16,2,"0","$"));
    Str.Append(what," infos");

    CASE chkFile(target, OVERWRITE,IGNORERO,base,fileINFOS,e3) OF
    | errAlreadyRO:
        dmp5(sPROBLEM,what," not saved : ",target," is read-only !");
        RETURN errAlreadyRO;
    | errAlready:
        dmp5(sPROBLEM,what," not saved : ",target," already exists !");
        RETURN errAlready;
    END;

    IF readMasterBootRecord(XBIOS,unit,trackcount,headcount,sectorcount)=FALSE THEN
        RETURN errReadMasterBootRecord;
    END;
    IF NOT ( DYNALLOC ) THEN
    IF DEBUG THEN dumpSector(showAsTable, SectorType(buffMasterBoot) );END;
    ELSE
    IF DEBUG THEN dumpSector(showAsTable, SectorType(pbuffMasterBoot^) );END;
    END;

    (* we have buffMasterBoot and we won't change it now *)
    (* "there can be only one"... extended partition ! *)

    initList(anchor);

    pb:=0;
    pbmem:=0;
    pbfatal:=0;

    FOR j:=1 TO 2 DO
        FOR primindex:= firstPartNdx TO lastPartNdx DO
            CASE j OF
            | 1 : rc:= grabMainPartX     (anchor,primindex,unit,
                                         XBIOS,trackcount,headcount,sectorcount,
                                         e3);
            | 2 : rc:= grabExtendedPartX (anchor,primindex,
                                         XBIOS,trackcount,headcount,sectorcount,
                                         unit,e3);
            END;
            chkProblems(pb,pbmem,pbfatal, rc);
        END;
    END;
    IF pbfatal # 0 THEN RETURN errInt13h; END;
    IF pbmem # 0 THEN RETURN errStorage; END;
    IF pb # 0 THEN RETURN errSaveInfos; END;

    hnd := FIO.Create(target);
    FIO.AssignBuffer(hnd,ioBuffer);

    chapter(hnd,"Unit parameters");
    doCmdParms (hnd,unit,
               XBIOS,XBIOSavailable,
               NEWGEOMETRY,PERFECTGEOMETRY,ALTFORMAT,ASSUMESTANDARDTRACK0,FORCESECTORCOUNT,
               EDDmajor, EDDflag, BESTFIT,
               maxtrackorg,maxheadorg,maxsectororg, totalSectors,
               maxtrack,maxhead,maxsector, maxblock,
               trackcount,headcount,sectorcount, blockcount);
    showInfos  (anchor,hnd,ALTFORMAT,showCLI,addCR,
               XBIOS,trackcount,headcount,sectorcount,unit,e3);
    FIO.Flush(hnd);
    FIO.Close(hnd);

    freeList(anchor);

    dmp4(sOK,what," saved to ",target);

    RETURN errNone;
END saveInfos;

(* ------------------------------------------------------------ *)
(* ------------------------------------------------------------ *)

(* assume NEWTABLE is useless here : no MBR, no track 0 *)

PROCEDURE restoreMe (p:ptrToEntry;
                     REALLY,AUTOCONFIRM, XBIOS:BOOLEAN;
                     unit:BYTE; trackcount,headcount,sectorcount:CARDINAL;
                     base:ARRAY OF CHAR):CARDINAL;
VAR
    S,what,source:str128;
    hnd:FIO.File;
    F,SU:str16;
    partID:BYTE;
    isPrimary:BOOLEAN;
    primindex,ndxpart,subindex:CARDINAL;
    expected:LONGCARD;
    i,got:CARDINAL;
    block:LONGCARD;
    track,head,sector:CARDINAL;
BEGIN
    partID    := p^.pcode;
    IF isEmptyPart(partID) THEN RETURN errNone; END; (* time to exit if empty *)

    isPrimary := p^.primary;
    primindex := CARDINAL( p^.pprimindex );
    ndxpart   := CARDINAL( p^.pndxpart);
    subindex  := CARDINAL( p^.psubindex);
    Str.Copy(F, p^.pname);

    getDesc(what, isPrimary,partID,primindex,ndxpart,subindex);
    SU:="(~) ";
    Str.Subst(SU,"~", fmt( CARDINAL(unit),16,2,"0","$"));
    Str.Prepend(what,SU);
    (*
    Str.Append(what," (");
    Str.Append(what, fmt( CARDINAL(partID),16,2,"0","$"));
    Str.Append(what,")");
    *)

    (* base + "\" + f8 + e3 = base + "\" + f8.e3 ;-) *)

    IF NOT ( DYNALLOC ) THEN
    expected := SIZE(buffSector);
    ELSE
    expected := SIZE(pbuffSector^);
    END;
    CASE chkFile(source, FALSE,FALSE,base,F,"") OF
    | errNotFound:
        dmp5(sPROBLEM+"No attempt to restore ",what," : ",source," does not exist !");
        RETURN errNotFound;
    END;
    CASE chkFileSize(source, expected) OF
    | errFileSize:
        dmp5(sPROBLEM+"No attempt to restore ",what," : ",source," filesize is not valid !");
        RETURN errFileSize;
    END;
    CASE chkSignature(source) OF
    | errSignature:
        dmp5(sPROBLEM+"No attempt to restore ",what," : ",source," $AA55 signature is missing !");
        RETURN errSignature;
    END;

    Str.Concat(S,sWARN,what);
    IF queryUser(AUTOCONFIRM,S,source)=FALSE THEN RETURN errCancel;END;

    hnd := FIO.OpenRead(source);
    FIO.AssignBuffer(hnd,ioBuffer);
    IF NOT ( DYNALLOC ) THEN
        got:=FIO.RdBin (hnd,buffSector, CARDINAL(expected) );
    ELSE
        got:=FIO.RdBin (hnd,pbuffSector^, CARDINAL(expected) );
    END;
    FIO.Close(hnd);

IF REALLY THEN

    block    := p^.pfirst;

    blockToCHS (trackcount,headcount,sectorcount,block,
                track,head,sector);

    IF procSector (unit,XBIOS,opWrite,block,track,head,sector,
                  Seg( p^.data ),Ofs( p^.data ))=FALSE THEN
        RETURN errInt13h;
    END;

    IF DEBUG THEN dumpSector(showAsRaw, SectorType( p^.data ) );END;

    S:="";
ELSE
    S:=sFAKE;
END;
    dmp5(sOK,what," updated with ",source,S);
    RETURN errNone;
END restoreMe;

(* ------------------------------------------------------------ *)

PROCEDURE compMe (VAR mismatches:LONGCARD;
                 p:ptrToEntry;VERBOSE:BOOLEAN; base:ARRAY OF CHAR):CARDINAL;
VAR
    i,got : CARDINAL;
    ref,now:BYTE;
    what,source:str128;
    hnd:FIO.File;
    F:str16;
    partID:BYTE;
    isPrimary:BOOLEAN;
    primindex,ndxpart,subindex:CARDINAL;
    expected:LONGCARD;
    chkrounds:CARDINAL;
BEGIN
    partID    := p^.pcode;
    IF isEmptyPart(partID) THEN RETURN errNone; END; (* time to exit if empty *)

    isPrimary := p^.primary;
    primindex := CARDINAL( p^.pprimindex );
    ndxpart   := CARDINAL( p^.pndxpart);
    subindex  := CARDINAL( p^.psubindex);
    Str.Copy(F, p^.pname);

    getDesc(what, isPrimary,partID,primindex,ndxpart,subindex);
    (*
    Str.Append(what," (");
    Str.Append(what, fmt( CARDINAL(partID),16,2,"0","$"));
    Str.Append(what,")");
    *)

    (* base + "\" + f8 + e3 = base + "\" + f8.e3 ;-) *)

    IF NOT ( DYNALLOC ) THEN
        expected := SIZE(buffSector);
    ELSE
        expected := SIZE(pbuffSector^);
    END;
    CASE chkFile(source, FALSE,FALSE,base,F,"") OF
    | errNotFound:
        dmp5(sPROBLEM,what," not compared : ",source," does not exist !");
        INC(mismatches); (* force an error *)
        RETURN errNotFound;
    END;
    CASE chkFileSize(source, expected) OF
    | errFileSize:
        dmp5(sPROBLEM,what," not compared : ",source," filesize is not valid !");
        INC(mismatches); (* force an error *)
        RETURN errFileSize;
    END;

    IF VERBOSE THEN dmp5(sINFO,"Comparing ",what," with ",source);END;

    hnd := FIO.OpenRead(source);
    FIO.AssignBuffer(hnd,ioBuffer);
    IF NOT ( DYNALLOC ) THEN
        got:=FIO.RdBin(hnd,buffSector, CARDINAL(expected) );
    ELSE
        got:=FIO.RdBin(hnd,pbuffSector^, CARDINAL(expected) );
    END;
    FIO.Close(hnd);

    chkrounds:=0;
    mismatches:=0;
    FOR i := firstByteInSector TO lastByteInSector DO
        IF NOT ( DYNALLOC ) THEN
            ref:=buffSector[i];
        ELSE
            ref:=pbuffSector^[i];
        END;
        now:=p^.data[i];
        IF now # ref THEN
            IF VERBOSE THEN
                IF mismatches=0 THEN donl; END;
                IF showDiff(chkrounds,i,ref,now) THEN RETURN errAborted;END;
            END;
            INC (mismatches);
        END;
    END;

    IF mismatches = 0 THEN
        dmp3(sOK,what," match.");
        RETURN errNone;
    ELSE
        IF VERBOSE THEN donl; END;
        dmp3(sPROBLEM,what," do not match !");
        RETURN errMismatch;
    END;
END compMe;

(* ------------------------------------------------------------ *)

PROCEDURE saveMe (p:ptrToEntry; OVERWRITE,IGNORERO:BOOLEAN;
                  base:ARRAY OF CHAR):CARDINAL;
VAR
    S,what,target:str128;
    hnd:FIO.File;
    F:str16;
    partID:BYTE;
    isPrimary:BOOLEAN;
    primindex,ndxpart,subindex:CARDINAL;
BEGIN
    partID    := p^.pcode;
    IF isEmptyPart(partID) THEN RETURN errNone; END; (* time to exit if empty *)

    isPrimary := p^.primary;
    primindex := CARDINAL( p^.pprimindex );
    ndxpart   := CARDINAL( p^.pndxpart);
    subindex  := CARDINAL( p^.psubindex);
    Str.Copy(F, p^.pname);

    getDesc(what, isPrimary,partID,primindex,ndxpart,subindex);
    (*
    Str.Append(what," (");
    Str.Append(what, fmt( CARDINAL(partID),16,2,"0","$"));
    Str.Append(what,")");
    *)

    (* base + "\" + f8 + e3 = base + "\" + f8.e3 ;-) *)
    CASE chkFile(target, OVERWRITE,IGNORERO,base,F,"") OF
    | errAlreadyRO:
        dmp5(sPROBLEM,what," not saved : ",target," is read-only !");
        RETURN errAlreadyRO;
    | errAlready:
        dmp5(sPROBLEM,what," not saved : ",target," already exists !");
        RETURN errAlready;
    END;

    hnd := FIO.Create(target);
    FIO.AssignBuffer(hnd,ioBuffer);
    FIO.WrBin (hnd,p^.data, SIZE(p^.data));
    FIO.Flush(hnd);
    FIO.Close(hnd);

    dmp4(sOK,what," saved to ",target);
    RETURN errNone;
END saveMe;

(* ------------------------------------------------------------ *)

(* before v1.3j, was AUTOCONFIRM,NEWTABLE, while NEWTABLE was NOT used here *)

PROCEDURE procPartitions (VAR mismatches:LONGCARD;
                         cmd:cmdType;
                         REALLY,AUTOCONFIRM,
                         OVERWRITE,IGNORERO,VERBOSE,XBIOS:BOOLEAN;
                         unit:BYTE;trackcount,headcount,sectorcount:CARDINAL;
                         base,e3:ARRAY OF CHAR):CARDINAL;
VAR
    target:str128;
    pb,pbmem,pbfatal,primindex,j,rc,errCmd:CARDINAL;
    anchor,ptr:ptrToEntry;
    diffs:LONGCARD;
BEGIN
    CASE cmd OF
    | cmdSave:    errCmd:=errSavePartitions;
    | cmdCompare: errCmd:=errComparePartitions;
    | cmdRestore: errCmd:=errRestorePartitions;
    END;

    IF readMasterBootRecord(XBIOS,unit,trackcount,headcount,sectorcount)=FALSE THEN
        RETURN errReadMasterBootRecord;
    END;

    IF NOT ( DYNALLOC ) THEN
    IF DEBUG THEN dumpSector(showAsTable, SectorType(buffMasterBoot) );END;
    ELSE
    IF DEBUG THEN dumpSector(showAsTable, SectorType(pbuffMasterBoot^) );END;
    END;

    (* we have buffMasterBoot and we won't change it now *)
    (* "there can be only one"... extended partition ! *)

    initList(anchor);

    pb:=0;
    pbmem:=0;
    pbfatal:=0;

    FOR j:=1 TO 2 DO
        FOR primindex:= firstPartNdx TO lastPartNdx DO
            CASE j OF
            | 1 : rc:= grabMainPartX     (anchor,primindex,unit,
                                         XBIOS,trackcount,headcount,sectorcount,
                                         e3);
            | 2 : rc:= grabExtendedPartX (anchor,primindex,
                                         XBIOS,trackcount,headcount,sectorcount,
                                         unit,e3);
            END;
            chkProblems(pb,pbmem,pbfatal, rc);
        END;
    END;
    IF pbfatal # 0 THEN RETURN errInt13h; END;
    IF pbmem # 0 THEN RETURN errStorage; END;
    IF pb # 0 THEN RETURN errCmd; END;

    mismatches:=0;
    ptr:=anchor;
    WHILE ptr # NIL DO
        (*
            each individual procedure filters out stored empty part,
            but here would be a good place to check and skip them
        *)
        CASE cmd OF
        | cmdSave :   rc:=saveMe (ptr, OVERWRITE,IGNORERO,base);
        | cmdRestore: rc:=restoreMe (ptr, REALLY,AUTOCONFIRM, XBIOS,
                                    unit, trackcount,headcount,sectorcount,
                                    base);
        | cmdCompare: rc:=compMe (diffs,ptr, VERBOSE, base);
                      INC(mismatches,diffs);
        END;
        chkProblems(pb,pbmem,pbfatal, rc);
        ptr:=ptr^.next;
    END;
    freeList(anchor);

    IF pbfatal # 0 THEN RETURN errInt13h; END;
    IF pbmem # 0 THEN RETURN errStorage; END;
    IF pb # 0 THEN RETURN errCmd; END;

    RETURN errNone;
END procPartitions;

(* ------------------------------------------------------------ *)
(* ------------------------------------------------------------ *)

CONST
    SHOWBOOTFLAGSTATE = 0;

PROCEDURE showActiveFlags (addCR:BOOLEAN):BOOLEAN;
CONST
    placeholder = "!";
    sHeader     = "Partition  Type  Terse ID          Boot flag";
               (* "1          $06   ????????????????  $80" *)
    sInfos      = "!          !   !  !";
VAR
    OSID,bootflag:BYTE;
    i,actived,illegal:CARDINAL;
    S:str128;
    pb:BOOLEAN;
BEGIN
    dmp2(sINFO,dashes);
    dmp2(sINFO,sHeader);
    dmp2(sINFO,dashes);
    IF addCR THEN donl;END;

    (* safety check : only one bootable partition, and only legal values *)

    actived:=0; (* yes, we know it's frenglish for "active"... damned... er, damn... *)
    illegal:=0;
    FOR i:= firstPartNdx TO lastPartNdx DO
        IF NOT ( DYNALLOC ) THEN
        OSID    :=buffMasterBoot.PartitionX[i].OSindicator;
        bootflag:=buffMasterBoot.PartitionX[i].BootIndicator;
        ELSE
        OSID    :=pbuffMasterBoot^.PartitionX[i].OSindicator;
        bootflag:=pbuffMasterBoot^.PartitionX[i].BootIndicator;
        END;
        Str.Copy(S,sInfos);
        Str.Subst(S, placeholder, fmt(i,10,0,"","") );
        Str.Subst(S, placeholder, fmt( CARDINAL(OSID),16,2,"0","$") );
        Str.Subst(S, placeholder, getIDshortDesc (OSID, TRUE,TRUE) ); (* primary and padded *)
        Str.Subst(S, placeholder, fmt( CARDINAL(bootflag),16,2,"0","$") );
        CASE bootflag OF
        | 80H : Str.Append(S," (yes)");           INC(actived);
        | 00H : Str.Append(S," (no)");
        ELSE
                Str.Append(S," (illegal value)"); INC(illegal);
        END;
        dmp2(sINFO,S);
    END;

    (* show possible warnings *)
    pb:=( (actived # 1) OR (illegal # 0) );

    IF (pb AND addCR) THEN WrLn; END;

    CASE actived OF
    | 0 :
        dmp2(sWARN,"Make sure there is at least one active partition !");
    | 1 :
        ;
    ELSE
        dmp2(sWARN,"Make sure there is only one active partition !");
    END;
    IF illegal # 0 THEN
        dmp2(sPROBLEM,"Make sure there are no illegal values for boot flags !");
    END;

    pb:=(illegal # 0); (* this is a real problem ! *)

    RETURN pb;
END showActiveFlags;

PROCEDURE procBootFlag (activateID : CARDINAL;
                       addCR,  REALLY,AUTOCONFIRM,XBIOS:BOOLEAN;  unit:BYTE;
                       trackcount,headcount,sectorcount:CARDINAL):CARDINAL;
VAR
    track,head,sector:CARDINAL;
    block:LONGCARD;
    i:CARDINAL;
    OSID,bootflag:BYTE;
    S:str128;
    pb,result:BOOLEAN;
BEGIN
    track   := mintrack;
    head    := minhead;
    sector  := minsector;
    CHStoBlock (trackcount,headcount,sectorcount,
               track,head,sector,
               block);

    IF NOT ( DYNALLOC ) THEN
        result:= procSector (unit,XBIOS,opRead,block,track,head,sector,
                            Seg(buffMasterBoot),Ofs(buffMasterBoot));
    ELSE
        result:= procSector (unit,XBIOS,opRead,block,track,head,sector,
                            Seg(pbuffMasterBoot^),Ofs(pbuffMasterBoot^));
    END;
    IF result=FALSE THEN RETURN errInt13h; END;

    IF NOT ( DYNALLOC ) THEN
    IF DEBUG THEN dumpSector(showAsTable, SectorType(buffMasterBoot) );END;
    ELSE
    IF DEBUG THEN dumpSector(showAsTable, SectorType(pbuffMasterBoot^) );END;
    END;

    pb:=showActiveFlags(addCR); (* fix "isl 342" problem *)

    IF activateID = SHOWBOOTFLAGSTATE THEN RETURN errNone; END;

    IF addCR THEN donl; END;

    (* ok, let's see if we can activate selected partition *)

    i:=activateID;
    IF NOT ( DYNALLOC ) THEN
    OSID    :=buffMasterBoot.PartitionX[i].OSindicator;
    bootflag:=buffMasterBoot.PartitionX[i].BootIndicator;
    ELSE
    OSID    :=pbuffMasterBoot^.PartitionX[i].OSindicator;
    bootflag:=pbuffMasterBoot^.PartitionX[i].BootIndicator;
    END;

    IF pb THEN
        dmp2( sPROBLEM,"Operation aborted : partition table structure looks invalid !");
        RETURN errActivate;
    END;
    IF isEmptyPart( OSID ) THEN
        dmp2( sPROBLEM,"Operation aborted : selected partition is not used !");
        RETURN errActivate;
    END;
    IF isExtendedPart( OSID ) THEN
        dmp2( sPROBLEM,"Operation aborted : selected partition cannot boot !");
        RETURN errActivate;
    END;
    IF bootflag = BYTE(080H) THEN
        dmp2( sINFO,"Operation aborted : selected partition is already activated !");
        RETURN errNone;
    END;

    S:=sWARN_BOOTFLAG;
    Str.Subst(S,"~",fmt( CARDINAL(unit),16,2,"0","$"));
    Str.Subst(S,"~", fmt(activateID,10,0,"","") );
    IF queryUser(AUTOCONFIRM,S,"")=FALSE THEN RETURN errCancel;END;

    FOR i:= firstPartNdx TO lastPartNdx DO
        IF i = activateID THEN
            bootflag:=80H;
        ELSE
            bootflag:=00H;
        END;

        IF NOT ( DYNALLOC ) THEN
            buffMasterBoot.PartitionX[i].BootIndicator := bootflag;
        ELSE
            pbuffMasterBoot^.PartitionX[i].BootIndicator := bootflag;
        END;
    END;

IF REALLY THEN
    track   := mintrack;
    head    := minhead;
    sector  := minsector;
    CHStoBlock (trackcount,headcount,sectorcount,
               track,head,sector,
               block);
    IF NOT ( DYNALLOC ) THEN
        result:= procSector (unit,XBIOS,opWrite,block,track,head,sector,
                            Seg(buffMasterBoot),Ofs(buffMasterBoot));
    ELSE
        result:= procSector (unit,XBIOS,opWrite,block,track,head,sector,
                            Seg(pbuffMasterBoot^),Ofs(pbuffMasterBoot^));
    END;
    IF result=FALSE THEN RETURN errInt13h; END;
    IF NOT ( DYNALLOC ) THEN
    IF DEBUG THEN dumpSector(showAsTable, SectorType(buffMasterBoot) );END;
    ELSE
    IF DEBUG THEN dumpSector(showAsTable, SectorType(pbuffMasterBoot^) );END;
    END;

    S:="";
ELSE
    S:=sFAKE;
END;
    dmp4(sOK+"Partition ",fmt(activateID,10,0,"","")," boot flag has been activated.",S);
    RETURN errNone;
END procBootFlag;

(* ------------------------------------------------------------ *)
(* ------------------------------------------------------------ *)

CONST
    SHOWPARTITIONCODES        = 0; (* 1-1 *)
    FIRSTENUMINDEX            = 1;
    MAXENUMINDEX              = 512; (* should be reasonable, eh eh... *)
    sDefaultNewPartCode       = "0,PhG"; (* SHOWPARTITIONCODE *)
    opPartUser                = 0;
    opPartHide                = 1;
    opPartUnhide              = 2;

PROCEDURE parseNewPart (VAR request:CARDINAL;
                       VAR newOSid:SHORTCARD;
                       VAR opPart:CARDINAL;
                       S:str16):CARDINAL;
VAR
    p,base:CARDINAL;
    R:str16;
    v:LONGCARD;
    ok:BOOLEAN;
BEGIN
    opPart:=opPartUser;
    request := 0;
    newOSid := 0;

    IF same(S,sDefaultNewPartCode) THEN
        request:=SHOWPARTITIONCODES;
        newOSid:=00H; (* useless here *)
        RETURN errNone;
    END;

    p:=CharCount(S,coma);
    IF p # 1 THEN RETURN errNewPartFmt;END;
    p:=Str.CharPos(S,coma);
    Str.Slice(R, S,0,p);
    Str.Delete(S,0,p+1);

    base:=10;
    v:=Str.StrToCard(R,base,ok);
    IF ok THEN ok:= ( (v >= FIRSTENUMINDEX) AND (v <= MAXENUMINDEX) ); END;
    IF NOT(ok) THEN RETURN errNewPartEnumIndex;END;
    request := CARDINAL(v);

    Str.Copy(R,S);
    Str.Caps(R); (* accepted : $# 0X# #H HIDE UNHIDE *)

    IF getStrIndex(coma, R, "HIDE,OR$10") # 0 THEN (* 00010000 *)
        opPart:=opPartHide;
        RETURN errNone;
    END;
    IF getStrIndex(coma, R, "UNHIDE,SHOW,AND$EF") # 0 THEN (* 11101111 *)
        opPart:=opPartUnhide;
        RETURN errNone;
    END;

    base:=16;
    IF    Str.Match(R,"$*") THEN
          Str.Delete(R,0,1);
    ELSIF Str.Match(R,"0X*") THEN
          Str.Delete(R,0,2);
    ELSIF Str.Match(R,"*H") THEN
          p:=Str.RCharPos(R,"H");
          R[p]:=nullchar;
    ELSE
        base:=10;
    END;
    v:=Str.StrToCard(R,base,ok);
    IF ok THEN ok:= (v <= MAX(SHORTCARD)); END;
    IF NOT(ok) THEN RETURN errNewPartID;END;
    newOSid := SHORTCARD(v);

    RETURN errNone;
END parseNewPart;

PROCEDURE aboutPartCode (p:ptrToEntry;partcodeenumindex:CARDINAL;
                        placeholder:CHAR;pat:ARRAY OF CHAR);
VAR
    partID:BYTE;
    ndxpart:CARDINAL; (* [1..4] and not enumeration index ! *)
    isPrimary:BOOLEAN;
    block,parentblock:LONGCARD;
    S:str128;
    F:str16;
    i:CARDINAL;
BEGIN
    partID    := p^.pcode;
    IF isEmptyPart(partID) THEN RETURN; END; (* time to exit if empty *)

    isPrimary := p^.primary;
    ndxpart   := CARDINAL( p^.pndxpart);
    parentblock := p^.parentblock;
    block     := p^.pfirst;
    Str.Copy(F, p^.pname); (* f8.e3 *)
    i:=Str.RCharPos(F,dot);
    IF i # MAX(CARDINAL) THEN F[i]:=nullchar;END; (* brutal ! *)

    Str.Copy(S,pat);
    Str.Subst(S,placeholder, fmt(partcodeenumindex,10,2,blank,""));
    Str.Subst(S,placeholder, fmt(CARDINAL(partID),16,2,"0","$"));
    Str.Subst(S,placeholder, getIDshortDesc(partID,isPrimary,TRUE));
    Str.Subst(S,placeholder, fmtlc(parentblock,10,wiblockraw,blank,""));
    Str.Subst(S,placeholder, fmt(ndxpart,10,1,blank,""));
    Str.Subst(S,placeholder, fmtlc(block,10,wiblockraw,blank,""));
    Str.Subst(S,placeholder, F);
    dmp2(sINFO,S);
END aboutPartCode;

PROCEDURE procPartitionCode (BACKUP,REALLY,AUTOCONFIRM,XBIOS,addCR:BOOLEAN;
                            unit:BYTE; trackcount,headcount,sectorcount,
                            opPart,userPartcodeenumNdx:CARDINAL;newpartcode:SHORTCARD):CARDINAL;
CONST
    sWhat       = "Sector ~";
    placeholder = "~";
    sHeader     = "Index  Type  Terse ID          Parent     Entry  Block      Filename";
               (* "##     $06   ????????????????  #########  #      #########  $" *)
    sInfos      = "~     ~   ~  ~  ~      ~  ~";
VAR
    pb,pbmem,pbfatal,primindex,j,rc:CARDINAL;
    anchor,ptr:ptrToEntry;
    e3,F:str16;
    partcodeenumindex:CARDINAL;
    parentblock:LONGCARD;
    ndxpart:CARDINAL; (* [1..4] and not enumeration index ! *)
    oldpartcode:SHORTCARD;
    S,target,what:str128;
    hnd:FIO.File;
    ok:BOOLEAN;
    Z:str80;
BEGIN
    IF readMasterBootRecord(XBIOS,unit,trackcount,headcount,sectorcount)=FALSE THEN
        RETURN errReadMasterBootRecord;
    END;

    Str.Copy(e3,extSOS);

    IF NOT ( DYNALLOC ) THEN
    IF DEBUG THEN dumpSector(showAsTable, SectorType(buffMasterBoot) );END;
    ELSE
    IF DEBUG THEN dumpSector(showAsTable, SectorType(pbuffMasterBoot^) );END;
    END;

    (* we have buffMasterBoot and we won't change it now *)
    (* "there can be only one"... extended partition ! *)

    initList(anchor);

    pb:=0;
    pbmem:=0;
    pbfatal:=0;

    FOR j:=1 TO 2 DO
        FOR primindex:= firstPartNdx TO lastPartNdx DO
            CASE j OF
            | 1 : rc:= grabMainPartX     (anchor,primindex,unit,
                                         XBIOS,trackcount,headcount,sectorcount,
                                         e3);
            | 2 : rc:= grabExtendedPartX (anchor,primindex,
                                         XBIOS,trackcount,headcount,sectorcount,
                                         unit,e3);
            END;
            chkProblems(pb,pbmem,pbfatal, rc);
        END;
    END;
    IF pbfatal # 0 THEN RETURN errInt13h; END;
    IF pbmem # 0 THEN RETURN errStorage; END;
    IF pb # 0 THEN RETURN errNewPartCode; END;

    (* always show header and data *)

    dmp2(sINFO,dashes);
    dmp2(sINFO,sHeader);
    dmp2(sINFO,dashes);
    IF addCR THEN donl;END;

    partcodeenumindex:=FIRSTENUMINDEX-1;
    ptr:=anchor;
    WHILE ptr # NIL DO
        IF isEmptyPart(ptr^.pcode)=FALSE THEN INC(partcodeenumindex); END;
        aboutPartCode(ptr,partcodeenumindex,placeholder,sInfos);
        ptr:=ptr^.next;
    END;

    IF userPartcodeenumNdx = SHOWPARTITIONCODES THEN
        freeList(anchor);
        RETURN errNone;
    END;

    IF addCR THEN donl; END;

    (* go on : find parentblock and partindex for matching "request" entry *)

    parentblock:=MAX(LONGCARD);
    partcodeenumindex:=FIRSTENUMINDEX-1;
    ptr:=anchor;
    LOOP
        IF ptr = NIL THEN EXIT; END;
        IF isEmptyPart(ptr^.pcode)=FALSE THEN INC(partcodeenumindex); END;
        IF partcodeenumindex = userPartcodeenumNdx THEN
            oldpartcode := ptr^.pcode;
            ndxpart     := CARDINAL( ptr^.pndxpart);
            parentblock := ptr^.parentblock;
            EXIT;
        END;
        ptr:=ptr^.next;
    END;

    CASE opPart OF
    | opPartHide:   newpartcode := (oldpartcode OR  010H); (* 00010000 *)
    | opPartUnhide: newpartcode := (oldpartcode AND 0EFH); (* 11101111 *)
    END;

    IF parentblock=MAX(LONGCARD) THEN
        Str.Concat(S,fmt(FIRSTENUMINDEX,10,1,blank,""),"..");
        Str.Append(S,fmt(partcodeenumindex,10,1,blank,""));
        Str.Prepend(S,"Operation aborted : index out of [");
        Str.Append(S,"] range !");
        dmp2( sPROBLEM,S);
        RETURN errNewPartCode;
    END;
    IF oldpartcode=newpartcode THEN
        S:="Operation aborted : partition index ~ indicator code would not change !";
        Str.Subst(S,"~",fmt(userPartcodeenumNdx,10,1,blank,""));
        dmp2( sINFO,S);
        RETURN errNewPartCode;
    END;

    (* read specified block to buffExt *)

    IF readExtSector (XBIOS,unit,trackcount,headcount,sectorcount,
                      parentblock)=FALSE THEN
        RETURN errReadExtSector;
    END;

    Str.Copy(what,sWhat);
    Str.Subst(what,placeholder, fmtlc(parentblock,10,1,blank,""));

    IF BACKUP THEN
        CASE chkFile(target, TRUE,TRUE,"",fileOSTYPE,extSOS) OF
        | errAlreadyRO:
            dmp5(sPROBLEM,what," not saved : ",target," is read-only !");
            RETURN errAlreadyRO;
        | errAlready:
            dmp5(sPROBLEM,what," not saved : ",target," already exists !");
            RETURN errAlready;
        END;

        hnd := FIO.Create(target);
        FIO.AssignBuffer(hnd,ioBuffer);
        IF NOT ( DYNALLOC ) THEN
            FIO.WrBin (hnd,buffExt, SIZE(buffExt));
        ELSE
            FIO.WrBin (hnd,pbuffExt^, SIZE(pbuffExt^));
        END;
        FIO.Flush(hnd);
        FIO.Close(hnd);

        dmp4(sOK,what," saved to ",target);

    END;

    (* let's change partition code : fix "ndxpart" entry in parentblock *)
    (* let's warn about DOS/Win hide/unhide status *)

    CASE opPart OF
    | opPartHide,opPartUnhide :
        ok:=getHideUnhideStatus(Z,newpartcode);
        S:=sWARN_OSTYPEALT;
        Str.Subst(S,"~",fmt( CARDINAL(unit),16,2,"0","$"));
        Str.Subst(S,"~",fmt(userPartcodeenumNdx,10,1,blank,""));
        Str.Subst(S,"~",fmt( CARDINAL(oldpartcode),16,2,"0","$"));
        Str.Subst(S,"~",fmt( CARDINAL(newpartcode),16,2,"0","$"));
        Str.Subst(S,"~",Z);
    | opPartUser:
        S:=sWARN_OSTYPE;
        Str.Subst(S,"~",fmt( CARDINAL(unit),16,2,"0","$"));
        Str.Subst(S,"~",fmt(userPartcodeenumNdx,10,1,blank,""));
        Str.Subst(S,"~",fmt( CARDINAL(oldpartcode),16,2,"0","$"));
        Str.Subst(S,"~",fmt( CARDINAL(newpartcode),16,2,"0","$"));
    END;

    IF queryUser(AUTOCONFIRM,S,"")=FALSE THEN RETURN errCancel;END;
IF REALLY THEN
    IF NOT ( DYNALLOC ) THEN
        buffExt.PartitionX[ndxpart].OSindicator:=newpartcode;
    ELSE
        pbuffExt^.PartitionX[ndxpart].OSindicator:=newpartcode;
    END;

    IF writeExtSector (XBIOS,unit,trackcount,headcount,sectorcount,
                      parentblock)=FALSE THEN
        RETURN errWriteExtSector;
    END;

    IF NOT ( DYNALLOC ) THEN
    IF DEBUG THEN dumpSector(showAsTable, SectorType(buffExt) );END;
    ELSE
    IF DEBUG THEN dumpSector(showAsTable, SectorType(pbuffExt^) );END;
    END;

    S:="";
ELSE
    S:=sFAKE;
END;
    dmp4(sOK,what," has been updated with new O.S. indicator code.",S);

    freeList(anchor);
    RETURN errNone;
END procPartitionCode;

(* ------------------------------------------------------------ *)
(* ------------------------------------------------------------ *)

CONST
    sDefaultNewXPID = "PhG";
    opXPIDuser      = 0;
    opXPIDincr      = 1;
    opXPIDdecr      = 2;

PROCEDURE parseNewXPID (VAR changeXPID : BOOLEAN;
                       VAR newXPIDsernum:LONGCARD;
                       VAR opXPID : CARDINAL;
                       R:str16):CARDINAL;
VAR
    p,base,rc:CARDINAL;
    v:LONGCARD;
    ok:BOOLEAN;
BEGIN
    opXPID := opXPIDuser;
    newXPIDsernum := 0;

    changeXPID := NOT ( same(R,sDefaultNewXPID) );
    IF changeXPID = FALSE THEN RETURN errNone;END;

    Str.Caps(R); (* accepted : $# 0X# #H +[+[+]] -[-[-]] [incr] [decr] [INC] [DEC] [plus] [minus] *)

    IF getStrIndex (coma, R, "+,++,+++,INCR,INC,PLUS") # 0 THEN
        opXPID := opXPIDincr;
        RETURN errNone;
    END;
    IF getStrIndex (coma, R, "-,--,---,DECR,DEC,MINUS") # 0 THEN
        opXPID := opXPIDdecr;
        RETURN errNone;
    END;

    base:=16;
    IF    Str.Match(R,"$*") THEN
          Str.Delete(R,0,1);
    ELSIF Str.Match(R,"0X*") THEN
          Str.Delete(R,0,2);
    ELSIF Str.Match(R,"*H") THEN
          p:=Str.RCharPos(R,"H");
          R[p]:=nullchar;
    ELSE
        base:=10;
    END;
    v:=Str.StrToCard(R,base,ok);
    IF ok THEN
        newXPIDsernum:=v;
        rc:=errNone;
    ELSE
        rc:=errNewXPID;
    END;
    RETURN rc;
END parseNewXPID;

PROCEDURE procXPID (changeXPID,BACKUP,REALLY,AUTOCONFIRM,XBIOS,addCR:BOOLEAN;
                   unit:BYTE; trackcount,headcount,sectorcount,
                   opXPID:CARDINAL; newXPIDsernum:LONGCARD):CARDINAL;
CONST
    placeholder = "~";
    sCurrent    = "Windows XP disk ID serial number is currently : ~";
    sWanted     = "Windows XP disk ID serial number would become : ~";
    what        = "MBR";
VAR
    track,head,sector:CARDINAL;
    block:LONGCARD;
    winXPid:LONGCARD;
    S,target:str128;
    hnd:FIO.File;
    result:BOOLEAN;
BEGIN
    IF readMasterBootRecord(XBIOS,unit,trackcount,headcount,sectorcount)=FALSE THEN
        RETURN errReadMasterBootRecord;
    END;

    IF NOT ( DYNALLOC ) THEN
    Lib.FarMove (FarADR(buffMasterBoot.bytearray[winXPuniqueIDoffset]),
                FarADR(winXPid),SIZE(winXPid));
    ELSE
    Lib.FarMove (FarADR(pbuffMasterBoot^.bytearray[winXPuniqueIDoffset]),
                FarADR(winXPid),SIZE(winXPid));
    END;

    IF NOT ( DYNALLOC ) THEN
    IF DEBUG THEN dumpSector(showAsTable, SectorType(buffMasterBoot) );END;
    ELSE
    IF DEBUG THEN dumpSector(showAsTable, SectorType(pbuffMasterBoot^) );END;
    END;

    (* show current XP ID *)

    S:=sCurrent;
    Str.Subst(S,placeholder,fmtlc(winXPid,16,8,"0","$"));
    dmp2(sINFO,S);
    IF changeXPID = FALSE THEN RETURN errNone;END;

    IF addCR THEN donl; END;

    CASE opXPID OF
    | opXPIDincr : newXPIDsernum := winXPid; INC (newXPIDsernum);
    | opXPIDdecr : newXPIDsernum := winXPid; DEC (newXPIDsernum);
    END;

    S:=sWanted;
    Str.Subst(S,placeholder,fmtlc(newXPIDsernum,16,8,"0","$"));
    dmp2(sINFO,S);
    IF addCR THEN donl; END;

    IF newXPIDsernum = winXPid THEN
        dmp2( sINFO,"Operation aborted : Windows XP disk ID serial number would not change !");
        RETURN errNewXPID;
    END;

    IF BACKUP THEN
        (* force -oo *)
        CASE chkFile(target, TRUE,TRUE,"",fileMBR,extSOS) OF
        | errAlreadyRO:
            dmp5(sPROBLEM,what," not saved : ",target," is read-only !");
            RETURN errAlreadyRO;
        | errAlready:
            dmp5(sPROBLEM,what," not saved : ",target," already exists !");
            RETURN errAlready;
        END;

        hnd := FIO.Create(target);
        FIO.AssignBuffer(hnd,ioBuffer);
        IF NOT ( DYNALLOC ) THEN
            FIO.WrBin (hnd,buffMasterBoot, SIZE(buffMasterBoot));
        ELSE
            FIO.WrBin (hnd,pbuffMasterBoot^,SIZE(pbuffMasterBoot^));
        END;
        FIO.Flush(hnd);
        FIO.Close(hnd);

        dmp4(sOK,what," saved to ",target);

    END;

    (* let's change XP ID *)

    S:=sWARN_XPID;
    Str.Subst(S,"~",fmt( CARDINAL(unit),16,2,"0","$"));
    IF queryUser(AUTOCONFIRM,S,"")=FALSE THEN RETURN errCancel;END;

IF REALLY THEN
    IF NOT ( DYNALLOC ) THEN
    Lib.FarMove (FarADR(newXPIDsernum),
                FarADR(buffMasterBoot.bytearray[winXPuniqueIDoffset]),
                SIZE(newXPIDsernum));
    ELSE
    Lib.FarMove (FarADR(newXPIDsernum),
                FarADR(pbuffMasterBoot^.bytearray[winXPuniqueIDoffset]),
                SIZE(newXPIDsernum));
    END;

    track   := mintrack;
    head    := minhead;
    sector  := minsector;
    CHStoBlock (trackcount,headcount,sectorcount,
               track,head,sector,
               block);
    IF NOT ( DYNALLOC ) THEN
        result:= procSector (unit,XBIOS,opWrite,block,track,head,sector,
                            Seg(buffMasterBoot),Ofs(buffMasterBoot));
    ELSE
        result:= procSector (unit,XBIOS,opWrite,block,track,head,sector,
                            Seg(pbuffMasterBoot^),Ofs(pbuffMasterBoot^));
    END;
    IF result=FALSE THEN RETURN errInt13h; END;
    IF NOT ( DYNALLOC ) THEN
    IF DEBUG THEN dumpSector(showAsTable, SectorType(buffMasterBoot) );END;
    ELSE
    IF DEBUG THEN dumpSector(showAsTable, SectorType(pbuffMasterBoot^) );END;
    END;

    S:="";
ELSE
    S:=sFAKE;
END;
    dmp4(sOK,what," has been updated with new Windows XP disk ID serial number.",S);

    RETURN errNone;
END procXPID;

(* ------------------------------------------------------------ *)
(* ------------------------------------------------------------ *)

CONST
    opHideMe   = 0;
    opUnhideMe = 1;

PROCEDURE isBlockZeroed (i:CARDINAL; DYNALLOC:BOOLEAN):BOOLEAN ;
VAR
    sum:LONGCARD;
    j:CARDINAL;
    bval:BYTE;
BEGIN
    sum:=0;
    FOR j:= firstByteInSector TO lastByteInSector DO
        IF NOT ( DYNALLOC ) THEN
            bval := buffTrack0[i,j];
        ELSE
            bval := pbuffTrack0[i]^[j];
        END;
        INC(sum, LONGCARD(bval));
    END;
    RETURN (sum = 0);
END isBlockZeroed;

PROCEDURE isBlockSigned (i:CARDINAL;DYNALLOC:BOOLEAN ):BOOLEAN;
CONST
    sigmbr    = 0AA55H;
VAR
    j,sig:CARDINAL;
    bval:BYTE;
BEGIN
    sig:=0;
    FOR j:=1 TO 2 DO
        IF NOT( DYNALLOC ) THEN
                    bval := buffTrack0[i,lastByteInSector-j+1];
        ELSE
                    bval := pbuffTrack0[i]^[lastByteInSector-j+1];
        END;
        CASE j OF
        | 1: sig:=CARDINAL(bval) ;               (* $aa *)
        | 2: sig:=(sig << 8) + CARDINAL(bval) ;  (* $55 *)
        END;
    END;
    RETURN (sig = sigmbr);
END isBlockSigned;

PROCEDURE procHideShowMBR (BACKUP,REALLY,AUTOCONFIRM,XBIOS,ASSUMESTANDARDTRACK0:BOOLEAN;
                          unit:BYTE; trackcount,headcount,sectorcount, opmbr:CARDINAL):CARDINAL;
CONST
    sHidden   = "MBR has been saved to block ~ in track 0, then hidden.";
    sUnhidden = "MBR has been restored from block ~ in track 0.";
VAR
    track,head,sector:CARDINAL;
    block,blockMBR:LONGCARD;
    i,j,srcndx,dstndx,zerondx: CARDINAL;
    result,found:BOOLEAN;
    S,what:str128;
BEGIN
    track   := mintrack;
    head    := minhead;
    sector  := minsector;
    CHStoBlock (trackcount,headcount,sectorcount,
               track,head,sector,
               block);
    blockMBR := block; (* for later use *)

    FOR i:=firstSectorInTrack TO getTrack0size(ASSUMESTANDARDTRACK0,sectorcount) DO
        blockToCHS (trackcount,headcount,sectorcount,
                   block,
                   track,head,sector);

        IF NOT ( DYNALLOC ) THEN
            result:= procSector (unit,XBIOS,opRead,block,track,head,sector,
                                Seg(buffTrack0[i]),Ofs(buffTrack0[i]));
        ELSE
            result:= procSector (unit,XBIOS,opRead,block,track,head,sector,
                                Seg(pbuffTrack0[i]^),Ofs(pbuffTrack0[i]^));
        END;
        IF result=FALSE THEN RETURN errInt13h; END;

        IF NOT ( DYNALLOC ) THEN
        IF DEBUG THEN dumpSector(showAsRaw, SectorType(buffTrack0[i]) );END;
        ELSE
        IF DEBUG THEN dumpSector(showAsRaw, SectorType(pbuffTrack0[i]^) );END;
        END;

        INC(block);
    END;

    (*
    scanning 63..2, find a zeroed block OR $aa55 signature
    relocate MBR                        OR restore MBR
    zero MBR                            OR older relocated
    remember to check for possible problems : room and consecutive ops
    *)

    CASE opmbr OF
    | opHideMe:
        IF isBlockZeroed(firstSectorInTrack,DYNALLOC) THEN
            RETURN errMBRalreadyZeroed;
        END;

        found:=FALSE;
        i:=getTrack0size(ASSUMESTANDARDTRACK0,sectorcount);
        LOOP
            IF i <= firstSectorInTrack THEN EXIT; END;
            found:= isBlockSigned(i,DYNALLOC); IF found THEN EXIT;END;
            DEC(i);
        END;
        IF found THEN RETURN errSignatureAlreadyFound;END;

        found:=FALSE;
        i:=getTrack0size(ASSUMESTANDARDTRACK0,sectorcount);
        LOOP
            IF i <= firstSectorInTrack THEN EXIT; END;
            found:= isBlockZeroed(i,DYNALLOC); IF found THEN EXIT;END;
            DEC(i);
        END;
        IF NOT(found) THEN RETURN errZeroFilledBlockNotFound;END;

        srcndx:=firstSectorInTrack;
        dstndx:=i;
        S:=sWARN_HIDEMBR;
        what:=sHidden;
        Str.Subst(what,"~",fmt( dstndx,10,1,"",""));
    | opUnhideMe:
        IF isBlockSigned(firstSectorInTrack,DYNALLOC) THEN
            RETURN errMBRalreadySigned;
        END;

        found:=FALSE;
        i:=getTrack0size(ASSUMESTANDARDTRACK0,sectorcount);
        LOOP
            IF i <= firstSectorInTrack THEN EXIT; END;
            found:= isBlockSigned(i,DYNALLOC); IF found THEN EXIT;END;
            DEC(i);
        END;
        IF NOT(found) THEN RETURN errSignatureBlockNotFound;END;

        srcndx:=i;
        dstndx:=firstSectorInTrack;
        S:=sWARN_UNHIDEMBR;
        what:=sUnhidden;
        Str.Subst(what,"~",fmt( srcndx,10,1,"",""));
    END;

    zerondx:=srcndx; (* mbr for hide, first empty block for unhide *)

    (* relocate MBR                        OR restore MBR *)

    IF NOT ( DYNALLOC ) THEN
        buffTrack0[dstndx]:=buffTrack0[srcndx];
    ELSE
        pbuffTrack0[dstndx]^:=pbuffTrack0[srcndx]^;
    END;

    (* zero MBR                            OR zero older relocated *)

    FOR j:= firstByteInSector TO lastByteInSector DO
        IF NOT ( DYNALLOC ) THEN
            buffTrack0[zerondx,j]:=BYTE(00H);
        ELSE
            pbuffTrack0[zerondx]^[j]:=BYTE(00H);
        END;
    END;

    (* update track 0 *)

    Str.Subst(S,"~",fmt( CARDINAL(unit),16,2,"0","$"));
    IF queryUser(AUTOCONFIRM,S,"")=FALSE THEN RETURN errCancel;END;

IF REALLY THEN

    block := blockMBR;
    FOR i:=firstSectorInTrack TO getTrack0size(ASSUMESTANDARDTRACK0,sectorcount) DO
        blockToCHS (trackcount,headcount,sectorcount,
                   block,
                   track,head,sector);

        IF NOT ( DYNALLOC ) THEN
            result:= procSector (unit,XBIOS,opWrite,block,track,head,sector,
                                Seg(buffTrack0[i]),Ofs(buffTrack0[i]));
        ELSE
            result:= procSector (unit,XBIOS,opWrite,block,track,head,sector,
                                Seg(pbuffTrack0[i]^),Ofs(pbuffTrack0[i]^));
        END;
        IF result=FALSE THEN RETURN errInt13h; END;

        IF NOT ( DYNALLOC ) THEN
        IF DEBUG THEN dumpSector(showAsRaw, SectorType(buffTrack0[i]) );END;
        ELSE
        IF DEBUG THEN dumpSector(showAsRaw, SectorType(pbuffTrack0[i]^) );END;
        END;

        INC(block);
    END;
    S := "";
ELSE
    S := sFAKE;
END;

    dmp3(sOK,what,S);

    RETURN errNone;
END procHideShowMBR;

(* ------------------------------------------------------------ *)
(* ------------------------------------------------------------ *)

PROCEDURE fmtbignum (base,wi:CARDINAL;v:LONGCARD):str16;
VAR
    i : CARDINAL;
    R:str16;
    ok,lo:BOOLEAN;
    pad,prefix,suffix:CHAR;
BEGIN
    CASE base OF
    | 16: pad:="0";prefix:="$"; suffix:=""; lo:=TRUE;
    ELSE
          pad:=" ";prefix:= ""; suffix:=""; lo:=FALSE;
    END;
    Str.CardToStr ( v, R, base, ok);
    FOR i:=Str.Length(R)+1 TO wi DO Str.Prepend(R,pad);END;
    IF lo THEN Str.Lows(R); END;
    Str.Prepend(R,prefix);Str.Append(R,suffix);
    RETURN R;
END fmtbignum;

PROCEDURE fmtnum (base,wi:CARDINAL;v:CARDINAL):str16;
BEGIN
    RETURN fmtbignum(base,wi,LONGCARD(v));
END fmtnum;

PROCEDURE fmtsegofs (hi,lo:CARDINAL;sepa:CHAR ):str16;
VAR
    R:str16;
BEGIN
    Str.Concat(R, fmtnum(16,4,hi), sepa);
    Str.Append(R, fmtnum(16,4,lo));
    ReplaceChar(R,"$","");
    RETURN R;
END fmtsegofs;

PROCEDURE segofs2addr (segment,offset:CARDINAL):LONGCARD;
BEGIN
    RETURN LONGCARD(segment) << 4 + LONGCARD(offset);
END segofs2addr;

(* ssss:oooo to linear address *)

PROCEDURE so2addr (so:LONGCARD):LONGCARD ;
VAR
    segment,offset:LONGCARD;
BEGIN
    segment:=so >> 16;
    offset :=so AND 0000FFFFH;
    RETURN segment << 4 + offset;
END so2addr;

PROCEDURE splitaddr (a:LONGCARD;VAR hi,lo:CARDINAL );
BEGIN
    hi:= CARDINAL(a >> 16);
    lo:= CARDINAL(a AND 0000FFFFH);
END splitaddr;

(* ------------------------------------------------------------ *)

PROCEDURE crosspages (DEBUG:BOOLEAN;a:FarADDRESS; varsize :CARDINAL):BOOLEAN;
VAR
    a1,a2:FarADDRESS;
    page1,page2,lo1,lo2:CARDINAL;
    seg1,seg2,ofs1,ofs2:CARDINAL;

    so1,so2:LONGCARD;
    addr1,addr2:LONGCARD;
BEGIN
    IF DEBUG THEN WrStr("::: crosspages"+nl);END;

    a1:=a;
    a2:=Lib.AddFarAddr(a1,varsize-1);

    so1:=LONGCARD(a1); (* automagically converted to ssss:oooo *)
    so2:=LONGCARD(a2);

    splitaddr(so1, seg1,ofs1);
    splitaddr(so2, seg2,ofs2);

    addr1:=so2addr(so1); (* ssss:oooo to linear *)
    addr2:=so2addr(so2);
    splitaddr(addr1, page1,lo1);
    splitaddr(addr2, page2,lo2);

    IF DEBUG THEN
        WrStr(":::   [");WrStr(fmtbignum(16,8,addr1));
        WrStr("..");WrStr(fmtbignum(16,8,addr2));WrStr("]"+"  ");

        WrStr( fmtsegofs(CARDINAL(page1),CARDINAL(lo1),"-" ));
        WrStr("..");
        WrStr( fmtsegofs(CARDINAL(page2),CARDINAL(lo2),"-" ));WrStr("  ");

        WrStr( fmtsegofs(CARDINAL(seg1),CARDINAL(ofs1),":" ));
        WrStr("..");
        WrStr( fmtsegofs(CARDINAL(seg2),CARDINAL(ofs2),":" ));
        WrLn;
    END;

    RETURN ( page1 # page2 );
END crosspages;

(* ------------------------------------------------------------ *)

PROCEDURE onsamepage (DEBUG:BOOLEAN;anchor:ptrToSectorType ):BOOLEAN;
VAR
    a1,a2:FarADDRESS;
    page1,page2,lo1,lo2:CARDINAL;
    seg1,seg2,ofs1,ofs2:CARDINAL;

    so1,so2:LONGCARD;
    addr1,addr2:LONGCARD;
BEGIN
    a1:=FarADDRESS(anchor^);
    a2:=Lib.AddFarAddr(a1,SIZE(ptrToSectorType^)-1);

    so1:=LONGCARD(a1); (* automagically converted to ssss:oooo *)
    so2:=LONGCARD(a2);

    splitaddr(so1, seg1,ofs1);
    splitaddr(so2, seg2,ofs2);

    addr1:=so2addr(so1); (* ssss:oooo to linear *)
    addr2:=so2addr(so2);
    splitaddr(addr1, page1,lo1);
    splitaddr(addr2, page2,lo2);

    IF DEBUG THEN
        WrStr("[");WrStr(fmtbignum(16,8,addr1));
        WrStr("..");WrStr(fmtbignum(16,8,addr2));WrStr("]"+"  ");

        WrStr( fmtsegofs(CARDINAL(page1),CARDINAL(lo1),"-" ));
        WrStr("..");
        WrStr( fmtsegofs(CARDINAL(page2),CARDINAL(lo2),"-" ));WrStr("  ");

        WrStr( fmtsegofs(CARDINAL(seg1),CARDINAL(ofs1),":" ));
        WrStr("..");
        WrStr( fmtsegofs(CARDINAL(seg2),CARDINAL(ofs2),":" ));
        WrLn;
    END;

    RETURN ( page1=page2 );
END onsamepage;

PROCEDURE releaseMem (anchor:ptrToSectorType);
BEGIN
    IF anchor # NIL THEN DEALLOCATE(anchor,SIZE(anchor^)); END;
END releaseMem;

PROCEDURE releaseMemAlt (anchor:ptrMBRrecordType);
BEGIN
    IF anchor # NIL THEN DEALLOCATE(anchor,SIZE(anchor^)); END;
END releaseMemAlt;

PROCEDURE grabMem (DEBUG:BOOLEAN):ptrToSectorType;
CONST
    firstbuff = 1;
    lastbuff  = 16;
VAR
    buff : ARRAY [firstbuff..lastbuff] OF ptrToSectorType;
    anchor : ptrToSectorType;
    last,i,wanted:CARDINAL;
BEGIN
    IF DEBUG THEN WrStr("::: grabMem");WrLn;END;
    anchor:=NIL;
    wanted:=SIZE(ptrToSectorType^);
    i:=firstbuff-1;
    LOOP
        INC(i);
        IF i > lastbuff THEN EXIT; END;
        IF Available(wanted)=FALSE THEN
            IF DEBUG THEN WrStr("Storage.Available() returned FALSE !");WrLn;END;
            EXIT;
        END;
        ALLOCATE(buff[i],wanted);
        IF DEBUG THEN
            WrStr("::: ");WrStr( fmtnum(10,2,i) );WrStr(" @ ");
        END;
        IF onsamepage(DEBUG,buff[i]) THEN anchor:=buff[i]; EXIT; END;
    END;
    DEC(i);
    last:=i;
    FOR i:= firstbuff TO last DO
        DEALLOCATE( buff[i] ,wanted);
    END;
    RETURN anchor;
END grabMem;

(* ------------------------------------------------------------ *)
(* ------------------------------------------------------------ *)

PROCEDURE abortDoc (  );
CONST
    memento =
"(* MBR *)"+nl+
nl+
"$1b8     4 BYTEs    Windows XP disk ID serial number"+nl+
nl+
"$1be    16 BYTEs    partition record for partition 1"+nl+
"$1ce    16 BYTEs    partition record for partition 2"+nl+
"$1de    16 BYTEs    partition record for partition 3"+nl+
"$1ee    16 BYTEs    partition record for partition 4"+nl+
"$1fe    WORD        signature, AA55h indicates valid boot block"+nl+
nl+
"(* partition record *)"+nl+
nl+
"$00     BYTE        boot indicator (80h = active partition)"+nl+
"$01     BYTE        partition start head"+nl+
"$02     BYTE        partition start sector (bits 0-5)"+nl+
"$03     BYTE        partition start track (bits 8,9 in bits 6,7 of sector)"+nl+
"$04     BYTE        operating system indicator (* partition code *)"+nl+
"$05     BYTE        partition end head"+nl+
"$06     BYTE        partition end sector (bits 0-5)"+nl+
"$07     BYTE        partition end track (bits 8,9 in bits 6,7 of sector)"+nl+
"$08     DWORD       sectors preceding partition"+nl+
"$0C     DWORD       length of partition in sectors"+nl+
nl+
"(* DOS boot record *)"+nl+
nl+
"$000    3 BYTEs     jmpCode               (* eb ?? 90 or e9 ?? ?? *)"+nl+
"$003    8 CHARs     OEMname               (* $00 terminated *)"+nl+
"$00b    CARDINAL    bytesPerSector        (* 512 *)"+nl+
"$00d    SHORTCARD   sectorsPerCluster     (* power of 2 : 1,2,4,...,128 *)"+nl+
"$00e    CARDINAL    reservedSectors       (* 1, starting at 0 *)"+nl+
"$010    SHORTCARD   numberOfFATs          (* 2 *)"+nl+
"$011    CARDINAL    numberOfRootEntries   (* 512 *)"+nl+
"$013    CARDINAL    numberOfTotalSectors  (* 0 if BIGDOS i.e. > 32Mb *)"+nl+
"$015    SHORTCARD   mediaDescriptor       (* $f8 *)"+nl+
"$016    CARDINAL    sectorsPerFAT"+nl+
"$018    CARDINAL    sectorsPerTrack"+nl+
"$01a    CARDINAL    numberOfHeads"+nl+
"$01c    LONGCARD    hiddenSectors         (* ignore high if dos < 4.0 - is first sector of partition *)"+nl+
"$020    LONGCARD    bigTotal              (* if numberOfTotalSectors was 0 *)"+nl+
"$024    SHORTCARD   physicalDriveNumber   (* $80 or $81 *)"+nl+
"$025    BYTE        dirtyflag             (* reserved *)"+nl+
"$026    BYTE        extBRsignature        (* $29 *)"+nl+
"$027    LONGCARD    volumeSerialNumber"+nl+
"$02b    11 CHARs    volumeLabel           (* $00 terminated *)"+nl+
"$036    8 CHARs     fileSystemID          (* padded with blanks *)"+nl+
"$03e    448 BYTEs   xcode"+nl+
"$1fe    CARDINAL    magic                 (* $aa55 *)"+nl+
nl+
"(* Win boot record *)"+nl+
nl+
"$000    3 BYTEs     jmpCode               (* eb 58 90 *)"+nl+
"$003    8 CHARs     OEMname               (* $00 terminated *)"+nl+
"$00b    CARDINAL    bytesPerSector        (* 512 *)"+nl+
"$00d    SHORTCARD   sectorsPerCluster     (* power of 2 : 1,2,4,...,128 *)"+nl+
"$00e    CARDINAL    reservedSectors       (* 33, starting at 0 *)"+nl+
"$010    SHORTCARD   numberOfFATs          (* 2 *)"+nl+
"$011    4 BYTEs     rsvd"+nl+
"$015    SHORTCARD   mediaDescriptor       (* $f8 *)"+nl+
"$016    CARDINAL    sectorsPerFAT"+nl+
"$018    CARDINAL    sectorsPerTrack"+nl+
"$01a    CARDINAL    numberOfHeads"+nl+
"$01c    LONGCARD    hiddenSectors         (* ignore high if dos < 4.0 - is first sector of partition *)"+nl+
"$020    LONGCARD    bigTotal              (* if numberOfTotalSectors was 0 *)"+nl+
"$024    LONGCARD    bigSectorsPerFAT"+nl+
"$028    SHORTCARD   activeFATs            (* attrExt *)"+nl+
"$029    SHORTCARD   FSversionMajor"+nl+
"$02a    CARDINAL    FSversionMinor"+nl+
"$02c    LONGCARD    firstClusterOfRoot    (* 2 *)"+nl+
"$030    CARDINAL    FSinfoSector          (* 1 *)"+nl+
"$032    CARDINAL    FSbackupBootSector    (* 6 *)"+nl+
"$034    12 BYTEs    rsvd2"+nl+
"$040    SHORTCARD   physicalDriveNumber   (* $80 or $81 *)"+nl+
"$041    BYTE        rsvd3                 (* for NT *)"+nl+
"$042    BYTE        extBRsignature        (* $29 *)"+nl+
"$043    LONGCARD    volumeSerialNumber"+nl+
"$047    11 CHARs    volumeLabel           (* $00 terminated *)"+nl+
"$052    8 CHARs     fileSystemID          (* padded with blanks *)"+nl+
"$05a    418 BYTEs   xcode"+nl+
"$1fc    LONGCARD    magic                 (* $aa550000*)"+nl;

(* //FIXME v1.3p add NTFS boot record too ? *)

CONST
    sep = "     ";
    isPrimary = TRUE;
    isLogical = FALSE;
VAR
    i,j:CARDINAL;
    S1,R1,R2:str16;
    S2:str256;
    ok1,ok2:BOOLEAN;
BEGIN
    FOR j:=1 TO 2 DO
        CASE j OF
        | 1 : S2:="(* long O.S. indicator codes *)";
        | 2 : S2:="(* most common short O.S. indicator codes *)";
        END;
        WrStr(S2);WrLn;
        WrLn;
        FOR i:=MIN(BYTE) TO MAX(BYTE) DO
            getIDpartStr( BYTE(i), S1,S2);
            CASE j OF
            | 1 :
                IF same(S2,sNoLongID)=FALSE THEN
                    WrStr(S1);WrStr(sep);WrStr(S2);WrLn;
                END;
            | 2 :
                R1:=getIDshortDesc ( BYTE(i), isPrimary,FALSE);
                R2:=getIDshortDesc ( BYTE(i), isLogical,FALSE);

                ok1:=( same(R1,sNoShortID)=FALSE );
                ok2:=( same(R2,sNoShortID)=FALSE );
                IF (ok1 OR ok2) THEN
                    WrStr(S1);WrStr(sep);
                    IF same(R1,R2) THEN
                        WrStr(R1);
                    ELSE
                        IF ok1 THEN WrStr(R1);WrStr(" (primary)");END;
                        IF ok2 THEN
                            IF ok1 THEN WrStr(" --- ");END;
                            WrStr(R2);WrStr(" (logical)");
                        END;
                    END;
                    WrLn;
                END;
            END;
        END;
        WrLn;
    END;
    WrStr(memento);
    abort(errNone,"");
END abortDoc;

(* ------------------------------------------------------------ *)
(* ------------------------------------------------------------ *)

TYPE
    vitaldata     = (objCMOS,objMBR,objTrack0,objAbout,objPartition);
    setOfData     = SET OF vitaldata;
CONST
    legalCommands = "R"+delim+"READ"+delim+"S"+delim+"SAVE"+delim+
                    "W"+delim+"WRITE"+delim+"U"+delim+"UPDATE"+delim+
                    "C"+delim+"COMPARE"+delim+
                    "Z"+delim+"ZERO"+delim+
                    "B"+delim+"BOOT"+delim+
                    "B1"+delim+"BOOT1"+delim+
                    "B2"+delim+"BOOT2"+delim+
                    "B3"+delim+"BOOT3"+delim+
                    "B4"+delim+"BOOT4"+delim+
                    "T"+delim+"TYPES"+delim+
                    "N"+delim+"ID"+delim+"XP"+delim+"XPFIX"+delim+
                    "I"+delim+"INVISIBLE"+delim+"HIDEMBR"+delim+"HIDEUNIT"+delim+
                    "V"+delim+"VISIBLE"+delim+"UNHIDEMBR"+delim+"UNHIDEUNIT";

CONST
    firstparm = 1;
    maxparm   = 3; (* longest is "hd cmd file" *)
VAR
    parmcount,i,opt,lastparm:CARDINAL;
    S,R:str128;
    sPB:str256;(* str128 could be too short *)
    parm : ARRAY [firstparm..maxparm] OF str128;
    cmd : cmdType;
    sUnit,sCmd,sDir:str128;
    XBIOSavailable:BOOLEAN;
    unit,EDDmajor,EDDflag:BYTE;
    maxtrackorg,maxheadorg,maxsectororg,bytespersector:CARDINAL;
    maxtrack,maxhead,maxsector,trackcount,headcount,sectorcount:CARDINAL;
    totalsectors,maxblock,blockcount:LONGCARD;
    OVERWRITE,IGNORERO,AUTOCONFIRM,VERBOSE:BOOLEAN;
    XBIOS,REALLY,NEWTABLE,BACKUP,showCLI:BOOLEAN;
    FIXBADTHS : BOOLEAN;
    BESTFIT : CARDINAL;
    dataSet : setOfData;
    sExtension,sNewPartCode,sNewXPID:str16;
    rc:CARDINAL;
    totalmismatches,mismatches:LONGCARD;
    ALTFORMAT,addCR,NEWGEOMETRY,PERFECTGEOMETRY:BOOLEAN;
    FORCESECTORCOUNT,ASSUMESTANDARDTRACK0:BOOLEAN; (* was fixTHSgeometry really needed ? *)
    CHECKBOUNDARIES:BOOLEAN;
    activateID,partcodeenumindex:CARDINAL;
    newpartcode : SHORTCARD;
    changeXPID:BOOLEAN;
    newcmossize,newXPIDsernum : LONGCARD;
    opPart,opXPID,opmbr:CARDINAL;
BEGIN
    Lib.DisableBreakCheck();
    FIO.IOcheck:=FALSE;       (* always ! *)
    WrLn;

    parmcount := Lib.ParamCount();
    IF parmcount=0 THEN abort(errHelp,"");END;

    initFatalStatus;
    addCR         := TRUE; (* more pleasant dump, not user modifiable *)

    DEBUG         := FALSE; (* global, globerk *)
    FATALINAL     := TRUE;  (* global, globerk *)
    AUDIO         := FALSE;
    DYNALLOC      := FALSE;

    OVERWRITE     := FALSE;
    IGNORERO      := FALSE;
    AUTOCONFIRM   := FALSE;
    VERBOSE       := TRUE;
    XBIOS         := TRUE;
    BESTFIT       := FORCEBEST;
    REALLY        := FALSE;
    NEWTABLE      := FALSE; (* before v1.3j, was true *)
    BACKUP        := FALSE;
    ALTFORMAT     := FALSE;
    CHECKBOUNDARIES:=FALSE;
    ASSUMESTANDARDTRACK0:= TRUE;
    FORCESECTORCOUNT := FALSE;
    FIXBADTHS     := FALSE;
    sExtension    := "";
    dataSet       := setOfData{};
    Str.Concat(logfile,progEXEname,extLOG); (* just in case ! *)
    activateID    := SHOWBOOTFLAGSTATE; (* useless safety *)
    partcodeenumindex  := SHOWPARTITIONCODES;
    newpartcode   := 00H;
    sNewPartCode  := sDefaultNewPartCode;
    sNewXPID      := sDefaultNewXPID;
    newcmossize   := undefinedCMOSsize;
    lastparm      := firstparm-1;

    FOR i := 1 TO parmcount DO
        Lib.ParamStr(S,i); cleantabs(S);
        Str.Copy(R,S);
        UpperCase(R);
        IF isOption(R) THEN
            opt := GetOptIndex(R, "?"+delim+"H"+delim+"HELP"+delim+
                                  "D"+delim+"DISPLAY"+delim+
                                  "O"+delim+"OVERWRITE"+delim+
                                  "YES"+delim+"OUI"+delim+"AUTOCONFIRM"+delim+
                                  "Q"+delim+"QUIET"+delim+
                                  "X"+delim+"LBA"+delim+
                                  "R"+delim+"READONLY"+delim+
                                  "OO"+delim+"OR"+delim+
                                  "J"+delim+"F255"+delim+"MAXHEAD"+delim+
                                  "C"+delim+"CMOS"+delim+
                                  "M"+delim+"MBR"+delim+
                                  "T"+delim+"TRACK0"+delim+
                                  "P"+delim+"PARTITION"+delim+
                                  "E:"+delim+"EXT:"+delim+
                                  "APPLY"+delim+"UPDATE"+delim+
                                  "G"+delim+"GO"+delim+ (* before v1.3j, was K,KEEP *)
                                  "S"+delim+"SAVE"+delim+"B"+delim+"BACKUP"+delim+
                                  "JJ"+delim+"F240"+delim+
                                  "A"+delim+"AUDIO"+delim+"W"+delim+
                                  "I"+delim+"INFOS"+delim+
                                  "??"+delim+"HH"+delim+
                                  "64KB"+delim+"PAGE"+delim+"CROSS"+delim+"CHK"+delim+"PARANOIA"+delim+
                                  "T:"+delim+"NEWTYPE:"+delim+
                                  "???"+delim+"HHH"+delim+
                                  "AH"+delim+
                                  "N:"+delim+"ID:"+delim+
                                  "DYN"+delim+"DY"+delim+
                                  "E"+delim+"T0FIX"+delim+
                                  "N"+delim+"63"+delim+"TRACK63"+delim+
                                  "DOIT"+delim+"REALLY"+delim+
                                  "MM"+delim+"MG"+delim+
                                  "THS"+delim+"FIXBADTHS"+delim+"BAD"+delim+
                                  "Z:"+delim+"CMOSSIZE:"+delim+"SIZE:"+delim+
                                  "C:"+delim+"CMOS:"+delim+
                                  "DEBUG"+delim+"LOG"
                              );
            CASE opt OF
            | 1,2,3 :   abort(errHelp,"");
            | 4,5:      ALTFORMAT := TRUE;
            | 6,7 :     OVERWRITE := TRUE;
            | 8,9,10:   AUTOCONFIRM:=TRUE;
            | 11,12:    VERBOSE   := FALSE;
            | 13,14:    XBIOS     := FALSE;
            | 15,16:    IGNORERO  := TRUE;
            | 17,18:    OVERWRITE := TRUE; IGNORERO := TRUE;
            | 19,20,21: BESTFIT   := FORCE255;
            | 22,23:    INCL(dataSet,objCMOS);
            | 24,25:    INCL(dataSet,objMBR);
            | 26,27:    INCL(dataSet,objTrack0);
            | 28,29:    INCL(dataSet,objPartition); INCL(dataSet,objAbout);
            | 30,31:    GetString(R,sExtension); (* keep upper case here *)
            | 32,33:    REALLY:=TRUE;
            | 34,35:    NEWTABLE:=TRUE; (* before v1.3j, was false *)
            | 36,37,38,39:BACKUP:=TRUE;
            | 40,41:    BESTFIT   := FORCE240;
            | 42,43,44: AUDIO     := TRUE;
            | 45,46:    INCL(dataSet,objAbout);
            | 47,48:    abort(errHelper,"");
            | 49,50,51,52,53: CHECKBOUNDARIES:=TRUE;
            | 54,55:    GetString(S,sNewPartCode); (* keep original case here *)
            | 56,57:    abortDoc();
            | 58 :      FATALINAL := FALSE;
            | 59,60:    GetString(S,sNewXPID);
            | 61,62:    DYNALLOC := TRUE;
            | 63,64:    ASSUMESTANDARDTRACK0:=FALSE;
            | 65,66,67: FORCESECTORCOUNT:=TRUE;
            | 68,69:    REALLY:=TRUE; (* -apply = -doit = -really *)
            | 70,71:    INCL(dataSet,objMBR); NEWTABLE:=TRUE;
            | 72,73,74: FIXBADTHS := TRUE;
            | 75,76,77: IF GetLongCard(R,newcmossize)=FALSE THEN abort(errBadVal,S);END;
                        IF newcmossize > maxCMOSsize THEN abort(errBadCMOSsize,S);END;
                        IF validCMOSsize( newcmossize )=FALSE THEN abort(errBadCMOSsize,S);END;
            | 78,79:    IF GetLongCard(R,newcmossize)=FALSE THEN abort(errBadVal,S);END;
                        IF newcmossize > maxCMOSsize THEN abort(errBadCMOSsize,S);END;
                        IF validCMOSsize( newcmossize )=FALSE THEN abort(errBadCMOSsize,S);END;
                        INCL(dataSet,objCMOS); (* force -c *)
            | 80,81:    DEBUG:=TRUE;
            ELSE
                abort(errOption,S); (* could be errHelp, eh eh ! *)
            END;
        ELSE
            INC(lastparm);
            IF lastparm > maxparm THEN abort(errParameter,S);END;
            Str.Copy( parm[lastparm], R);
        END;
    END;

    CASE lastparm OF
    | 2 : (* unit cmd *)
        Str.Copy(sUnit,  parm[1]);
        Str.Copy(sCmd,   parm[2]);
        Str.Copy(sDir,   ".");     (* default for Z or B is current directory *)
        i := getStrIndex(delim,sCmd,legalCommands);
        CASE i OF
        | 1..10: abort(errExpected,"<Z|B|B1|B2|B3|B4|T|N|V|I>");
        | 11,12: cmd:=cmdZero;
        | 13,14: cmd:=cmdActivate; activateID := SHOWBOOTFLAGSTATE; (* request current status *)
        | 15,16: cmd:=cmdActivate; activateID := 1;
        | 17,18: cmd:=cmdActivate; activateID := 2;
        | 19,20: cmd:=cmdActivate; activateID := 3;
        | 21,22: cmd:=cmdActivate; activateID := 4;
        | 23,24: cmd:=cmdNewCode;
        | 25,26,27,28: cmd:=cmdNewXPID;
        | 29,30,31,32: cmd:=cmdHideMBR;
        | 33,34,35,36: cmd:=cmdUnhideMBR;
        ELSE     abort(errCommand,sCmd);
        END;
    | 3 : (* unit cmd dir *)
        Str.Copy(sUnit,  parm[1]);
        Str.Copy(sCmd,   parm[2]);
        Str.Copy(sDir,   parm[3]);
        i := getStrIndex(delim,sCmd,legalCommands);
        CASE i OF
        | 1..4:  cmd := cmdSave;
        | 5..8:  cmd := cmdRestore;
        | 9,10:  cmd := cmdCompare;
        | 11..36:abort(errExpected,"<R|W|C>");
        ELSE     abort(errCommand,sCmd);
        END;
    ELSE
        abort(errSyntax,"");
    END;

    IF chkUnit(unit,sUnit)=FALSE THEN abort(errUnit,sUnit); END;
    IF isFloppy(unit) THEN abort(errFloppy,sUnit);END;

IF NOT ( DYNALLOC ) THEN

    (* now is a good time to check if static buffers don't cross 64Kb boundary *)
    IF CHECKBOUNDARIES THEN
        IF crosspages( DEBUG,FarADR(buffMasterBoot),SIZE(buffMasterBoot)) THEN
            abort(errBoundary,"buffMasterBoot");
        END;
        IF crosspages( DEBUG,FarADR(buffMasterBootRef),SIZE(buffMasterBootRef)) THEN
            abort(errBoundary,"buffMasterBootRef");
        END;
        IF crosspages( DEBUG,FarADR(buffPartitionTable),SIZE(buffPartitionTable)) THEN
            abort(errBoundary,"buffPartitionTable");
        END;
        IF crosspages( DEBUG,FarADR(buffExt),SIZE(buffExt)) THEN
            abort(errBoundary,"buffExt");
        END;
        IF crosspages( DEBUG,FarADR(buffSector),SIZE(buffSector)) THEN
            abort(errBoundary,"buffSector");
        END;

        (* darn : whatever dirty trick we try, we abort at bufftrack0ref[50] : fed up with it ! *)

        FOR i:= firstSectorInTrack TO maxSectorInTrack DO
            IF crosspages(DEBUG,FarADR(buffTrack0[i]),SIZE(buffTrack0[i])) THEN
                Str.Concat(R,"buffTrack0[",fmtnum(10,1,i));Str.Append(R,"]");
                abort(errBoundary,R);
            END;
        END;
        FOR i:= firstSectorInTrack TO maxSectorInTrack DO
            IF crosspages(DEBUG,FarADR(buffTrack0Ref[i]),SIZE(buffTrack0Ref[i])) THEN
                Str.Concat(R,"buffTrack0Ref[",fmtnum(10,1,i));Str.Append(R,"]");
                abort(errBoundary,R);
            END;
        END;
        IF crosspages( DEBUG,FarADR(buffTrack0),SIZE(buffTrack0)) THEN
            abort(errBoundary,"buffTrack0");
        END;
        IF crosspages( DEBUG,FarADR(buffTrack0Ref),SIZE(buffTrack0Ref)) THEN
            abort(errBoundary,"buffTrack0Ref");
        END;
    END;

ELSE

    IF CHECKBOUNDARIES THEN abort(errDynChk,"");END;

    (* now is a good time to create buffers *)
    (* we'll let good old DOS handle deallocating them most of the time *)
    (* maybe we should check only if CHECKBOUNDARIES ? bah... *)

    pbuffMasterBoot       := ptrMBRrecordType(grabMem(DEBUG));
    IF pbuffMasterBoot    = NIL THEN abort(errBoundary,"pbuffMasterBoot");END;
    pbuffMasterBootRef    := ptrMBRrecordType(grabMem(DEBUG));
    IF pbuffMasterBootRef = NIL THEN abort(errBoundary,"pbuffMasterBootRef");END;
    pbuffPartitionTable   := ptrMBRrecordType(grabMem(DEBUG));
    IF pbuffPartitionTable= NIL THEN abort(errBoundary,"pbuffPartitionTable");END;
    pbuffExt              := ptrMBRrecordType(grabMem(DEBUG));
    IF pbuffExt           = NIL THEN abort(errBoundary,"pbuffExt");END;
    pbuffSector           := grabMem(DEBUG);
    IF pbuffSector        = NIL THEN abort(errBoundary,"pbuffSector");END;
    FOR i:= firstSectorInTrack TO maxSectorInTrack DO
        pbuffTrack0[i] := grabMem(DEBUG);
        IF pbuffTrack0[i] = NIL THEN
            Str.Concat(R,"buffTrack0[",fmtnum(10,1,i));Str.Append(R,"]");
            abort(errBoundary,R);
        END;
    END;
    FOR i:= firstSectorInTrack TO maxSectorInTrack DO
        pbuffTrack0Ref[i] := grabMem(DEBUG);
        IF pbuffTrack0Ref[i] = NIL THEN
            Str.Concat(R,"buffTrack0Ref[",fmtnum(10,1,i));Str.Append(R,"]");
            abort(errBoundary,R);
        END;
    END;

END;

    (* let's check for Good Old DOS *)

    (* GOD:=NOT ( w9XsupportLFN() ); *)

    IF fixFatalStatusBios () THEN FATALINAL:=FALSE; END; (* if .CFG exists, force -AH *)

    IF resetUnit(RESETHD,unit)=FALSE THEN abort(errInt13h,"resetUnit");END;
    XBIOSavailable:=chkExtendedSupport(unit,EDDmajor,EDDflag);
    XBIOS := (XBIOS AND XBIOSavailable);
    IF isFloppy(unit) THEN XBIOS:=FALSE; END; (* paranoia : we already called isFloppy and it's trapped at chkExtendedSupport() *)

    i:= getGeometry (unit,XBIOS,FIXBADTHS,BESTFIT,
                    maxtrackorg,maxheadorg,maxsectororg,bytespersector,
                    totalsectors);
    CASE i OF
    | rcPhantom :        abort(errPhantom,sUnit); (* will only trap phantom floppy ! *)
    | rcInt13h:          abort(errInt13h,"getDiskGeometry");
    | rcXBIOSint13h:     abort(errXBIOSint13h,"getDiskGeometry");
    | rcXBIOSvalues:     abort(errXBIOSvalues,"getXBIOSvalues");
    | rcWrongTHSgeometry:abort(errWrongTHSgeometry,"getDiskGeometry");
    END;

    (* MUST be done now ! required initialization common to all commands ! *)

    i:=fixGeometry (unit,XBIOS,FORCESECTORCOUNT, BESTFIT,
                   maxtrackorg,maxheadorg,maxsectororg,totalsectors,
                   maxtrack,maxhead,maxsector,maxblock,
                   trackcount,headcount,sectorcount,blockcount,
                   NEWGEOMETRY,PERFECTGEOMETRY);
    IF i # errNone THEN abort(errFixGeometry,"");END;
    IF chkFixDirSpec(sDir)=FALSE THEN abort(errDir,sDir);END; (* "u:\*\" *)

    IF DEBUG THEN initLOG(); END;

    (* note AUDIO is valid for all commands because of possible fatal low-level errors *)
    (* now, if required, process Z B[#] T command and quit *)

    CASE cmd OF
    | cmdZero:
        (* valid : AUTOCONFIRM, XBIOS, BESTFIT, BACKUP, REALLY *)
        IF OVERWRITE      THEN abort(errNonsense,"-o");END;
        IF IGNORERO       THEN abort(errNonsense,"-r");END;
        IF VERBOSE=FALSE  THEN abort(errNonsense,"-q");END;
        IF NEWTABLE       THEN abort(errNonsense,"-g");END; (* we never touch MBR here *)
        IF ALTFORMAT      THEN abort(errNonsense,"-d");END;
        IF same(sExtension,"")=FALSE THEN abort(errNonsense,"-e:$");END;
        IF same(sNewPartCode,sDefaultNewPartCode)=FALSE THEN abort(errNonsense,"-t:#,#");END;
        IF same(sNewXPID,sDefaultNewXPID)=FALSE THEN abort(errNonsense,"-n:#");END;
        IF dataSet # setOfData{}     THEN abort(errNonsenses,"-c, -m, -t or -p");END;

        IF BACKUP THEN
            rc:=saveTrack0 (TRUE,TRUE,XBIOS,ASSUMESTANDARDTRACK0,
                           unit,trackcount,headcount,sectorcount,sDir,extSOS);
            IF isCritical(rc) THEN fatal(XBIOS,"saveTrack0 (backup)");END;
        END;
        rc:=zeroTrack0 (REALLY,AUTOCONFIRM,XBIOS,ASSUMESTANDARDTRACK0,
                       unit,trackcount,headcount,sectorcount);
        IF isCritical(rc) THEN fatal(XBIOS,"zeroTrack0");END;
        rc:=errNone; (* ignore non fatal errors such as errCancel *)
        abort(rc,"");
    | cmdActivate :
        (* valid B :  XBIOS, BESTFIT *)
        (* valid B# : AUTOCONFIRM, XBIOS, BESTFIT, REALLY, BACKUP *)
        IF OVERWRITE      THEN abort(errNonsense,"-o");END;
        IF IGNORERO       THEN abort(errNonsense,"-r");END;
        IF VERBOSE=FALSE  THEN abort(errNonsense,"-q");END;
        IF NEWTABLE       THEN abort(errNonsense,"-g");END; (* we never touch MBR here *)
        IF ALTFORMAT      THEN abort(errNonsense,"-d");END;
        IF same(sExtension,"")=FALSE THEN abort(errNonsense,"-e:$");END;
        IF same(sNewPartCode,sDefaultNewPartCode)=FALSE THEN abort(errNonsense,"-t:#,#");END;
        IF same(sNewXPID,sDefaultNewXPID)=FALSE THEN abort(errNonsense,"-n:#");END;
        IF dataSet # setOfData{}     THEN abort(errNonsenses,"-c, -m, -t or -p");END;
        IF activateID = SHOWBOOTFLAGSTATE THEN
            IF AUTOCONFIRM THEN abort(errNonsense,"-yes");END;
            IF REALLY      THEN abort(errNonsense,"-apply");END;
            IF BACKUP      THEN abort(errNonsense,"-s");END;
        ELSE
            IF BACKUP THEN
                rc:=saveMBR (TRUE,TRUE,XBIOS,
                            unit,trackcount,headcount,sectorcount,sDir,extSOS);
                IF isCritical(rc) THEN fatal(XBIOS,"saveMBR (backup)");END;
            END;
        END;
        rc:=procBootFlag (activateID, addCR,
                         REALLY,AUTOCONFIRM,XBIOS,unit,
                         trackcount,headcount,sectorcount);
        IF isCritical(rc) THEN fatal(XBIOS,"procBootFlag");END;
        rc:=errNone; (* ignore non fatal errors such as errCancel *)
        abort(rc,"");
    | cmdNewCode:
        rc:=parseNewPart(partcodeenumindex,newpartcode,opPart, sNewPartCode);
        IF rc # errNone THEN abort(rc,sNewPartCode);END;

        (* valid T : XBIOS, BESTFIT *)
        (* valid -t:#,# : AUTOCONFIRM, XBIOS, BESTFIT, REALLY, BACKUP *)
        IF OVERWRITE      THEN abort(errNonsense,"-o");END;
        IF IGNORERO       THEN abort(errNonsense,"-r");END;
        IF VERBOSE=FALSE  THEN abort(errNonsense,"-q");END;
        IF NEWTABLE       THEN abort(errNonsense,"-g");END; (* we never touch MBR here *)
        IF ALTFORMAT      THEN abort(errNonsense,"-d");END;
        IF same(sExtension,"")=FALSE THEN abort(errNonsense,"-e:$");END;
        IF same(sNewXPID,sDefaultNewXPID)=FALSE THEN abort(errNonsense,"-n:#");END;
        IF dataSet # setOfData{}     THEN abort(errNonsenses,"-c, -m, -t or -p");END;
        IF partcodeenumindex = SHOWPARTITIONCODES THEN
            IF AUTOCONFIRM THEN abort(errNonsense,"-yes");END;
            IF REALLY      THEN abort(errNonsense,"-apply");END;
            IF BACKUP      THEN abort(errNonsense,"-s");END;
        ELSE
            ;
        END;
        rc:=procPartitionCode (BACKUP,REALLY,AUTOCONFIRM,XBIOS,addCR,unit,
                              trackcount,headcount,sectorcount,
                              opPart,partcodeenumindex,newpartcode);
        IF isCritical(rc) THEN fatal(XBIOS,"procPartitionCode");END;
        rc:=errNone;
        abort(rc,"");
    | cmdNewXPID:
        rc:=parseNewXPID(changeXPID,newXPIDsernum,opXPID, sNewXPID);
        IF rc # errNone THEN abort(rc,sNewXPID);END;

        (* valid N : XBIOS, BESTFIT *)
        (* valid -n:# : AUTOCONFIRM, XBIOS, BESTFIT, REALLY, BACKUP *)
        IF OVERWRITE      THEN abort(errNonsense,"-o");END;
        IF IGNORERO       THEN abort(errNonsense,"-r");END;
        IF VERBOSE=FALSE  THEN abort(errNonsense,"-q");END;
        IF NEWTABLE       THEN abort(errNonsense,"-g");END; (* we never touch MBR here *)
        IF ALTFORMAT      THEN abort(errNonsense,"-d");END;
        IF same(sExtension,"")=FALSE THEN abort(errNonsense,"-e:$");END;
        IF same(sNewPartCode,sDefaultNewPartCode)=FALSE THEN abort(errNonsense,"-t:#,#");END;
        IF dataSet # setOfData{}     THEN abort(errNonsenses,"-c, -m, -t or -p");END;
        IF changeXPID=FALSE THEN
            IF AUTOCONFIRM THEN abort(errNonsense,"-yes");END;
            IF REALLY      THEN abort(errNonsense,"-apply");END;
            IF BACKUP      THEN abort(errNonsense,"-s");END;
        ELSE
            ;
        END;
        rc:=procXPID (changeXPID,BACKUP,REALLY,AUTOCONFIRM,XBIOS,addCR,unit,
                     trackcount,headcount,sectorcount,
                     opXPID,newXPIDsernum);
        IF isCritical(rc) THEN fatal(XBIOS,"procXPID");END;
        rc:=errNone;
        abort(rc,"");
    | cmdHideMBR, cmdUnhideMBR:
        (* valid : AUTOCONFIRM, XBIOS, BESTFIT, REALLY, BACKUP *)
        IF OVERWRITE      THEN abort(errNonsense,"-o");END;
        IF IGNORERO       THEN abort(errNonsense,"-r");END;
        IF VERBOSE=FALSE  THEN abort(errNonsense,"-q");END;
        IF NEWTABLE       THEN abort(errNonsense,"-g");END;
        IF ALTFORMAT      THEN abort(errNonsense,"-d");END;
        IF same(sExtension,"")=FALSE THEN abort(errNonsense,"-e:$");END;
        IF same(sNewPartCode,sDefaultNewPartCode)=FALSE THEN abort(errNonsense,"-t:#,#");END;
        IF dataSet # setOfData{}     THEN abort(errNonsenses,"-c, -m, -t or -p");END;

        IF BACKUP THEN
            rc:=saveTrack0 (TRUE,TRUE,XBIOS,ASSUMESTANDARDTRACK0,
                           unit,trackcount,headcount,sectorcount,sDir,extSOS);
            IF isCritical(rc) THEN fatal(XBIOS,"saveTrack0 (backup)");END;
        END;

        CASE cmd OF
        | cmdHideMBR : opmbr:=opHideMe;
        | cmdUnhideMBR:opmbr:=opUnhideMe;
        END;
        rc:=procHideShowMBR (BACKUP,REALLY,AUTOCONFIRM,XBIOS,ASSUMESTANDARDTRACK0,
                            unit,trackcount,headcount,sectorcount, opmbr );
        IF isCritical(rc) THEN fatal(XBIOS,"procHideShowMBR");END;
        IF rc # errNone THEN abort(rc,"procHideShowMBR");END;
        rc:=errNone;
        abort(rc,"");
    END;

    (* Z B[#] T N I V are no longer possible, check others *)
    (* common to R,W,C commands *)

    IF same(sExtension,"") THEN sExtension:=extSAV;END;
    IF chkFixExtension(sExtension)=FALSE THEN abort(errExtension,sExtension);END;

    IF dataSet=setOfData{} THEN
        INCL(dataSet,objCMOS);
        INCL(dataSet,objMBR);
        INCL(dataSet,objTrack0);
        INCL(dataSet,objAbout);
        INCL(dataSet,objPartition);
    END;

    (* check valid options for command *)

    CASE cmd OF
    | cmdSave:
        (* valid : OVERWRITE, IGNORERO, XBIOS, BESTFIT, ALTFORMAT, extension, dataSet *)
        IF AUTOCONFIRM    THEN abort(errNonsense,"-yes");END;
        IF VERBOSE=FALSE  THEN abort(errNonsense,"-q");END;
        IF NEWTABLE       THEN abort(errNonsense,"-g");END;
        IF BACKUP         THEN abort(errNonsense,"-s");END;
        IF REALLY         THEN abort(errNonsense,"-apply");END;
        IF same(sNewPartCode,sDefaultNewPartCode)=FALSE THEN abort(errNonsense,"-t:#,#");END;
        IF same(sNewXPID,sDefaultNewXPID)=FALSE THEN abort(errNonsense,"-n:#");END;
    | cmdRestore:
        (* valid : REALLY, AUTOCONFIRM, XBIOS, BESTFIT, NEWTABLE, BACKUP, ALTFORMAT, extension, dataSet *)

        IF IsRedirected() THEN abort(errRedirected,""); END;

        IF OVERWRITE      THEN abort(errNonsense,"-o");END;
        IF IGNORERO       THEN abort(errNonsense,"-r");END;
        IF VERBOSE=FALSE  THEN abort(errNonsense,"-q");END;
        IF same(sNewPartCode,sDefaultNewPartCode)=FALSE THEN abort(errNonsense,"-t:#,#");END;
        IF same(sNewXPID,sDefaultNewXPID)=FALSE THEN abort(errNonsense,"-n:#");END;
        IF (objCMOS IN dataSet) THEN
            rc:=initCMOSvolatile(sPB);
            IF rc # errNone THEN abort(rc,sPB);END;
        END;
    | cmdCompare:
        (* valid : VERBOSE, XBIOS, BESTFIT, extension, dataSet *)
        IF OVERWRITE      THEN abort(errNonsense,"-o");END;
        IF IGNORERO       THEN abort(errNonsense,"-r");END;
        IF AUTOCONFIRM    THEN abort(errNonsense,"-yes");END;
        IF NEWTABLE       THEN abort(errNonsense,"-g");END;
        IF BACKUP         THEN abort(errNonsense,"-s");END;
        IF REALLY         THEN abort(errNonsense,"-apply");END;
        IF ALTFORMAT      THEN abort(errNonsense,"-d");END;
        IF same(sNewPartCode,sDefaultNewPartCode)=FALSE THEN abort(errNonsense,"-t:#,#");END;
        IF same(sNewXPID,sDefaultNewXPID)=FALSE THEN abort(errNonsense,"-n:#");END;
        IF (objCMOS IN dataSet) THEN
            rc:=initCMOSvolatile(sPB);
            IF rc # errNone THEN abort(rc,sPB);END;
        END;
    END;

    rc:=errNone; (* not necessary but just in case... *)
    totalmismatches:=0;

    IF (objCMOS IN dataSet) THEN
        IF newcmossize = undefinedCMOSsize THEN newcmossize := defaultCMOSsize; END;
        CASE cmd OF
        | cmdSave:    rc:=saveCMOS (newcmossize,OVERWRITE,IGNORERO,sDir,sExtension);
        | cmdRestore: newcmossize:=grabCMOSfilesize(sDir,sExtension);
                      IF BACKUP THEN
                      rc:=saveCMOS(newcmossize,TRUE,TRUE,sDir,extSOS);
                      END;
                      rc:=restoreCMOS (newcmossize,REALLY,AUTOCONFIRM,sDir,sExtension);
        | cmdCompare: newcmossize:=grabCMOSfilesize(sDir,sExtension);
                      rc:=compCMOS (mismatches,newcmossize,VERBOSE,sDir,sExtension);
                      INC(totalmismatches,mismatches);
        END;
    END;
    IF (objMBR IN dataSet) THEN
        CASE cmd OF
        | cmdSave:    rc:=saveMBR (OVERWRITE,IGNORERO,XBIOS,unit,
                                  trackcount,headcount,sectorcount,sDir,sExtension);
                      IF isCritical(rc) THEN fatal(XBIOS,"saveMBR");END;
        | cmdRestore: IF BACKUP THEN
                      rc:=saveMBR (TRUE,TRUE,XBIOS,
                                  unit,trackcount,headcount,sectorcount,sDir,extSOS);
                      IF isCritical(rc) THEN fatal(XBIOS,"saveMBR (backup)");END;
                      END;
                      rc:=restoreMBR (REALLY,AUTOCONFIRM,NEWTABLE,XBIOS,unit,
                                     trackcount,headcount,sectorcount,sDir,sExtension);
                      IF isCritical(rc) THEN fatal(XBIOS,"restoreMBR");END;
        | cmdCompare: rc:=compMBR (mismatches,VERBOSE,XBIOS,unit,
                                  trackcount,headcount,sectorcount,sDir,sExtension);
                      IF isCritical(rc) THEN fatal(XBIOS,"compMBR");END;
                      INC(totalmismatches,mismatches);
        END;
    END;
    IF (objTrack0 IN dataSet) THEN
        CASE cmd OF
        | cmdSave:    rc:=saveTrack0 (OVERWRITE,IGNORERO,XBIOS,ASSUMESTANDARDTRACK0,unit,
                                     trackcount,headcount,sectorcount,sDir,sExtension);
                      IF isCritical(rc) THEN fatal(XBIOS,"saveTrack0");END;
        | cmdRestore: IF BACKUP THEN
                      rc:=saveTrack0 (TRUE,TRUE,XBIOS,ASSUMESTANDARDTRACK0,unit,
                                     trackcount,headcount,sectorcount,sDir,extSOS);
                      IF isCritical(rc) THEN fatal(XBIOS,"saveTrack0 (backup)");END;
                      END;
                      rc:=restoreTrack0 (REALLY,AUTOCONFIRM,NEWTABLE,XBIOS,ASSUMESTANDARDTRACK0,unit,
                                        trackcount,headcount,sectorcount,sDir,sExtension);
                      IF isCritical(rc) THEN fatal(XBIOS,"restoreTrack0");END;
        | cmdCompare: rc:=compTrack0 (mismatches,VERBOSE,XBIOS,ASSUMESTANDARDTRACK0,unit,
                                     trackcount,headcount,sectorcount,sDir,sExtension);
                      IF isCritical(rc) THEN fatal(XBIOS,"compTrack0");END;
                      INC(totalmismatches,mismatches);
        END;
    END;
    IF (objAbout IN dataSet) THEN
        showCLI := (objPartition IN dataSet);
        showCLI := TRUE; (* bah, always show it anyway *)
        CASE cmd OF
        | cmdSave:    rc:=saveInfos (OVERWRITE,IGNORERO,XBIOS,XBIOSavailable,
                                    NEWGEOMETRY,PERFECTGEOMETRY,
                                    ALTFORMAT,showCLI,addCR,ASSUMESTANDARDTRACK0,FORCESECTORCOUNT,
                                    EDDmajor, EDDflag, BESTFIT,
                                    unit,trackcount,headcount,sectorcount,
                                    sDir,sExtension,
                                    maxtrackorg,maxheadorg,maxsectororg,totalsectors,
                                    maxtrack,maxhead,maxsector,maxblock,
                                    blockcount);
                      IF isCritical(rc) THEN fatal(XBIOS,"saveInfos");END;
        | cmdRestore: IF BACKUP THEN
                      rc:=saveInfos (TRUE,TRUE,XBIOS,XBIOSavailable,
                                    NEWGEOMETRY,PERFECTGEOMETRY,
                                    ALTFORMAT,showCLI,addCR,ASSUMESTANDARDTRACK0,FORCESECTORCOUNT,
                                    EDDmajor, EDDflag, BESTFIT,
                                    unit,trackcount,headcount,sectorcount,
                                    sDir,extSOS,
                                    maxtrackorg,maxheadorg,maxsectororg,totalsectors,
                                    maxtrack,maxhead,maxsector,maxblock,
                                    blockcount);
                      IF isCritical(rc) THEN fatal(XBIOS,"saveInfos (backup)");END;
                      END;
        | cmdCompare:
                      ; (* don't do anything here *)
        END;
    END;
    IF (objPartition IN dataSet) THEN
        (* procPartitions uses cmd *)
        CASE cmd OF
        | cmdSave:    rc:=procPartitions (mismatches,cmd,
                                         REALLY,AUTOCONFIRM,
                                         OVERWRITE,IGNORERO,VERBOSE,XBIOS,
                                         unit,trackcount,headcount,sectorcount,
                                         sDir,sExtension);
                      IF isCritical(rc) THEN fatal(XBIOS,"savePartitions");END;
        | cmdRestore: IF BACKUP THEN
                      rc:=procPartitions (mismatches,cmdSave,
                                         REALLY,AUTOCONFIRM,
                                         TRUE,TRUE, VERBOSE,XBIOS,
                                         unit,trackcount,headcount,sectorcount,
                                         sDir,extSOS);
                      IF isCritical(rc) THEN fatal(XBIOS,"savePartitions (backup)");END;
                      END;
                      rc:=procPartitions (mismatches,cmd,
                                         REALLY,AUTOCONFIRM,
                                         OVERWRITE,IGNORERO,VERBOSE,XBIOS,
                                         unit,trackcount,headcount,sectorcount,
                                         sDir,sExtension);
                      IF isCritical(rc) THEN fatal(XBIOS,"restorePartitions");END;
        | cmdCompare: rc:=procPartitions (mismatches,cmd,
                                         REALLY,AUTOCONFIRM,
                                         OVERWRITE,IGNORERO,VERBOSE,XBIOS,
                                         unit,trackcount,headcount,sectorcount,
                                         sDir,sExtension);
                      IF isCritical(rc) THEN fatal(XBIOS,"compPartitions");END;
                      INC(totalmismatches,mismatches);
        END;
    END;

IF DYNALLOC THEN
    (* now is a good time to release buffers, though we let good old DOS handle previous abort() *)
    releaseMemAlt(pbuffMasterBoot);
    releaseMemAlt(pbuffMasterBootRef);
    releaseMemAlt(pbuffPartitionTable);
    releaseMemAlt(pbuffExt);
    releaseMem(pbuffSector);
    FOR i:= firstSectorInTrack TO maxSectorInTrack DO
        releaseMem(pbuffTrack0[i]);
    END;
    FOR i:= firstSectorInTrack TO maxSectorInTrack DO
        releaseMem(pbuffTrack0Ref[i]);
    END;
END;

    IF totalmismatches # 0 THEN (* amount does not matter *)
        abort(errMismatch,"");
    ELSE
        abort(errNone,""); (* using cr could lead to minor warnings/errors *)
    END;
END Vital.



(*

;
; VITAL.INI is used by Q&D VITAL utility :
; it lists CMOS addresses considered volatile.
; It must be in executable directory.
; Each line is a value in [0..127] range.
; "+" prefix forces value to be restored (W|U).
;
; If VITAL.INI does not exist, default values are :
;
; $00..$09
; $0c
; $32      (restored)
; $3F      (restored)
;

$00
$01
$02
$03
$04
$05
$06
$07
$08
$09

$0c

+$32

+$3F

; for p7gamer

$eb
$ed

*)





(*

MODULE Test;

IMPORT IO;
IMPORT Str;
IMPORT Lib;

FROM IO IMPORT WrStr,WrLn,WrLngCard;

FROM QD_Box IMPORT str128;

(* ------------------------------------------------------------ *)

PROCEDURE roundnum (VAR mb,frac:LONGCARD; total,divisor:LONGCARD;decimales:CARDINAL);
VAR
    v,limit:LONGCARD;
    i:CARDINAL;
BEGIN

    mb   := total DIV divisor;  (* integer part *)
    v    := total - mb*divisor; (* remainder *)

    limit:= 1;
    FOR i:=1 TO (decimales+1) DO v:=v*10; limit:=limit*10; END;
    DEC(limit);

    frac:=v DIV divisor;

    IF (frac MOD 10) >= 5 THEN
        INC(frac,10);
        IF frac > limit THEN frac:=0; INC(mb);END;
    END;
    frac := frac DIV 10;
END roundnum;

CONST
    oneMega = LONGCARD(2048);
    wi    = 6;
    count = 50-2;
VAR
    block,delta:LONGCARD;
    mb,frac:LONGCARD;
    i,decimals:CARDINAL;
    quo:LONGREAL;
    ok:BOOLEAN;
    S : str128;
BEGIN
    IF Lib.ParamCount() # 3 THEN
        WrStr("Syntax : TEST first_block delta_block decimals");WrLn;
        WrLn;
        WrStr("This test program calls roundnum() 48 times.");WrLn;
        WrLn;
        WrStr("Example : TEST 2040400 1 2");WrLn;
        HALT;
    END;
    Lib.ParamStr( S, 1);
    block:=Str.StrToCard(S,10,ok);
    Lib.ParamStr( S, 2);
    delta:=Str.StrToCard(S,10,ok);
    Lib.ParamStr( S, 3);
    decimals:=CARDINAL ( Str.StrToCard(S,10,ok) );

    FOR i := 1 TO count DO
        WrLngCard(block,wi);      WrStr(" blocks  =  ");
        WrLngCard(block*512,wi);  WrStr(" bytes  =  ");
        roundnum(mb,frac, block,oneMega,decimals);
        WrLngCard(mb,wi);  WrStr(".");  WrLngCard(frac,1); WrStr(" Mb  =  ");

        quo := LONGREAL(block) / LONGREAL(oneMega);
        Str.FixRealToStr( quo, 5, S,ok);
        WrStr(S);
        WrLn;
        INC(block,delta);
    END;
END Test.

*)

