
(*
    possible problem when patching wininit.exe strings :
    if patched strings are smaller than original at $6b2 and $760
    what happens if executable code reads strings sequentially ?
    bah...
*)

MODULE PASpeek;

IMPORT Lib;
IMPORT Str;
IMPORT FIO;

FROM IO IMPORT WrStr,WrLn;

FROM QD_Box IMPORT str80, str2, cmdInit, cmdShow, cmdStop, delim,
Work, video, Ltrim, Rtrim, UpperCase, LowerCase, ReplaceChar,
ChkEscape, Waitkey, WaitkeyDelay, Flushkey, IsRedirected, chkJoker,
isOption, GetOptIndex, GetLongCard, GetLongInt, GetString, CharCount,
same, aR, aH, aS, aD, aA, everything, isDirectory, fixDirectory,
str128, str256, Animation, allfiles, Belongs, FixAE, CodePhonetic,
CodeSoundex, CodeSoundexOrg, isReadOnly, LtrimBlanks, RtrimBlanks,
getStrIndex, cmdSHOW,BiosWaitkey,BiosWaitkeyShifted,BiosFlushkey,
str1024, isoleItemS, dmpTTX, str2048, Elapsed, TerminalReadString,
getDosVersion, DosVersion, warning95, runningWindows,
aV, reallyeverything, chkClassicTextMode, setClassicTextMode,
AltAnimation, str16, getCurrentDirectory, setReadWrite, setReadOnly,
getFileSize, verifyString, str4096, unfixDirectory,
animShow, animSHOW, animAdvance, animEnd, animClear,
animInit, animGetSdone, anim, cleantabs, UpperCaseAlt, LowerCaseAlt,
completedInit, completedShow, completedSHOW, completedEnd, completed,
removeDups, isValidHDunit, removePhantoms, removeFloppies,
getCDROMunits, getCDROMletters, removeCDROMs, getAllHDunits,
getAllLegalUnits;

FROM QD_File IMPORT pathtype, w9XnothingRequired,
fileOpenRead, fileOpen, fileExists, fileIsRO, fileSetRW, fileSetRO,
fileErase, fileCreate, fileRename, fileGetFileSize, fileIsDirectorySpec,
fileClose;

FROM QD_LFN IMPORT path9X, huge9X, findDataRecordType,
unicodeConversionFlagType, w9XchangeDir,
w9XgetDOSversion, w9XgetTrueDOSversion, w9XisWindowsEnh, w9XisMSDOS7,
w9XfindFirst, w9XfindNext, w9XfindClose, w9XgetCurrentDirectory,
w9XlongToShort, w9XshortToLong, w9XtrueName, w9XchangeDir,
w9XmakeDir, w9XrmDir, w9Xrename, w9XopenFile, w9XcloseFile,
w9XsupportLFN;

(* ------------------------------------------------------------ *)

CONST
    exe         = "PASPEEK";
    version     = "v1.0";
    title       = "Q&D Pascal strings Peek";
    who         = "by PhG";
CONST
    cr          = CHR(13);
    lf          = CHR(10);
    nl          = cr+lf;
    SHOW        = "::: ! string @ $! being ! character(s) long";
    placeholder = "!";

PROCEDURE abort (rc:CARDINAL;S:ARRAY OF CHAR);
CONST
    helpmsg =
title+" "+version+" "+who+nl+
nl+
"Syntax : "+exe+" <file> <first> <last> [![*]|*[!]]"+nl+
nl+
"This program extracts <file> Pascal strings found in <first>..<last> range."+nl+
'Optional "*" final parameter shows string address and character count.'+nl+
"Program assumes ASCII strings with a [1..255] BYTE length :"+nl+
'optional "!" final parameter assumes Unicode strings with a WORD length.'+nl+
nl+
"Examples : "+exe+" wininit.exe 929 2061 *"+nl+
"           "+exe+" newspeak.exe $989a $bf27"+nl+
"           "+exe+" vtuner.exe $4a1c0 $4b4ff !"+nl;
BEGIN
    IF same(S,"") THEN
        ;
    ELSIF same(S,"?") THEN
        WrStr(helpmsg);
    ELSE
        WrStr(S);WrLn;
    END;
    Lib.SetReturnCode( SHORTCARD(rc) );
    HALT;
END abort;

(* ------------------------------------------------------------ *)

CONST
    ioBufferSize    = (8 * 512) + FIO.BufferOverhead;
    firstBufferByte = 1;
    lastBufferByte  = ioBufferSize;
TYPE
    ioBufferType  = ARRAY [firstBufferByte..lastBufferByte] OF BYTE;
VAR
    ioBufferIn:ioBufferType;

(* ------------------------------------------------------------ *)

PROCEDURE getVal (VAR v:LONGCARD; S:ARRAY OF CHAR):BOOLEAN ;
VAR
    ok:BOOLEAN;
    base:CARDINAL;
BEGIN
    Str.Caps(S);
    IF S[0] = "$" THEN
        Str.Delete(S,0,1);
        base:=16;
    ELSE
        base:=10;
    END;
    v:=Str.StrToCard(S,base,ok);
    IF base=16 THEN Str.Lows(S);END;
    RETURN ok;
END getVal;

PROCEDURE strVal (VAR S:ARRAY OF CHAR; v:LONGCARD;base,wi:CARDINAL;pad:CHAR);
VAR
    i:CARDINAL;
    ok:BOOLEAN;
BEGIN
    Str.CardToStr(v,S,base,ok);
    FOR i:=Str.Length(S)+1 TO wi DO
        Str.Prepend(S,pad);
    END;
END strVal;

(* ------------------------------------------------------------ *)

VAR
    src:pathtype;
    fsize,fposFirst,fposLast,here:LONGCARD;
    useLFN:BOOLEAN;
    hin:FIO.File;
    S,R:str256;
    A:str16;
    n,got,needed,wanted,rc,wlen,csize:CARDINAL;
    blen,ch:SHORTCARD;
    verbose,unicrap:BOOLEAN;
BEGIN
    WrLn;
    FIO.IOcheck:=FALSE;

    useLFN := w9XsupportLFN();

    verbose := FALSE;
    unicrap := FALSE;

    n:=Lib.ParamCount();
    CASE n OF
    | 3,4 :
        Lib.ParamStr(src,1);
        IF chkJoker(src) THEN abort(2,"<file> cannot contain any joker !");END;
        IF fileExists(useLFN,src)=FALSE THEN abort(3,"<file> does not exist !");END;
        Lib.ParamStr(S,2);
        IF getVal(fposFirst,S)=FALSE THEN abort(4,"Illegal <first> value !");END;
        Lib.ParamStr(S,3);
        IF getVal(fposLast, S)=FALSE THEN abort(5,"Illegal <last> value !");END;
        IF n = 4 THEN
            Lib.ParamStr(S,4);
            IF same    (S,"*") THEN
                 verbose := TRUE;
            ELSIF same (S,"*!") THEN
                 verbose := TRUE; unicrap := TRUE;
            ELSIF same (S,"!") THEN
                                  unicrap := TRUE;
            ELSIF same (S,"!*") THEN
                 verbose := TRUE; unicrap := TRUE;
            ELSE
                abort(11,"Illegal optional final parameter !");
            END;
        END;
    ELSE
        abort(1,"?");
    END;
    fsize:=fileGetFileSize(useLFN,src);
    (* fsize is 1-based while fpos is 0-based hence >= *)
    IF fposFirst >= fsize THEN abort(6,"<first> is beyond <file> size !");END;
    IF fposLast  >= fsize THEN abort(7,"<last> is beyond <file> size !");END;
    IF fposLast < fposFirst THEN abort(8,"<last> is smaller than <first> !");END;

    rc:=0;

    hin:=fileOpenRead(useLFN,src);
    FIO.AssignBuffer(hin,ioBufferIn);

    FIO.Seek(hin,fposFirst);
    LOOP
        here:=fposFirst;

        IF unicrap THEN
            needed:=SIZE(wlen);
            got:=FIO.RdBin(hin,wlen,needed);
            wanted:=wlen;
            csize:=2;
        ELSE
            needed:=SIZE(blen);
            got:=FIO.RdBin(hin,blen,needed);
            wanted:=CARDINAL(blen);
            csize:=1;
        END;
        IF got # needed THEN
            S:="Unexpected problem while reading !";
            rc:=9;
            EXIT;
        END;
        INC(fposFirst, LONGCARD(got) );
        IF fposFirst > fposLast THEN EXIT; END;

        IF wanted # 0 THEN (* ignore 0 length *)

            got:=FIO.RdBin(hin,R,wanted * csize);
            R[got]:=0C;
            INC(fposFirst, LONGCARD(got) );

            IF unicrap THEN (* we won't check it's $## $00 : we just ignore second byte *)
                S:="";
                FOR n:=1 TO wanted DO
                    Str.Append(S, R[(n-1)*2]);
                END;
                Str.Copy(R,S);
            END;

            IF verbose THEN
                Str.Copy(S,SHOW);
                IF unicrap THEN
                    A:="Unicode";
                ELSE
                    A:="ASCII";
                END;
                Str.Subst(S,placeholder,A);
                strVal(A,here,16,8,"0");
                Str.Lows(A);
                Str.Subst(S,placeholder,A);
                strVal(A, LONGCARD(wanted),10,1,"");
                Str.Subst(S,placeholder,A);
                WrStr(S);WrLn;
            END;
            WrStr(R);WrLn;
        END;
    END;
    fileClose(useLFN,hin);
    IF rc # 0 THEN abort(rc,S);END;

    abort(0,"");
END PASpeek.
