(* ---------------------------------------------------------------
Title         Q&D With
Author        who cares ?
Overview      see help
Usage         see help
Notes         out of lazyness, semi-dynamic buildpathlist and buildfilelist
Bugs          vindoze 9X LFNs can lead to a very, very long command line,
              which is likely to crash the program, especially with 9x
              it should not occur with good old DOS limits
Wish List     make auto-expand default mode (as in DIRBAT) ?

--------------------------------------------------------------- *)

MODULE With;

IMPORT Str;
IMPORT Lib;
IMPORT FIO;

FROM IO IMPORT WrStr,WrLn,WrCard;

FROM Storage IMPORT ALLOCATE,DEALLOCATE,Available;

FROM QD_Box IMPORT str80, str2, cmdInit, cmdShow, cmdStop, delim,
Work, video, Ltrim, Rtrim, UpperCase, LowerCase, ReplaceChar,
ChkEscape, Waitkey, WaitkeyDelay, Flushkey, IsRedirected, chkJoker,
isOption, GetOptIndex, GetLongCard, GetLongInt, GetString, CharCount,
same, aR, aH, aS, aD, aA, everything, isDirectory, fixDirectory,
str128, str256, Animation, allfiles, Belongs, FixAE, CodePhonetic,
CodeSoundex, CodeSoundexOrg, isReadOnly, LtrimBlanks, RtrimBlanks,
getStrIndex, cmdSHOW,BiosWaitkey,BiosWaitkeyShifted,BiosFlushkey,
str1024, isoleItemS, dmpTTX, str2048, Elapsed, TerminalReadString,
getDosVersion, DosVersion, warning95, runningWindows,
aV, reallyeverything, chkClassicTextMode, setClassicTextMode,
AltAnimation, str16, getCurrentDirectory, setReadWrite,
getFileSize, verifyString, str4096, unfixDirectory,
animShow, animSHOW, animAdvance, animEnd, animClear,
animInit, animGetSdone, anim, cleantabs,
completedInit, completedShow, completedSHOW, completedEnd, completed;

FROM QD_LFN IMPORT path9X, huge9X, findDataRecordType,
unicodeConversionFlagType, w9XchangeDir,
w9XgetDOSversion, w9XgetTrueDOSversion, w9XisWindowsEnh, w9XisMSDOS7,
w9XfindFirst, w9XfindNext, w9XfindClose, w9XgetCurrentDirectory,
w9XlongToShort, w9XshortToLong, w9XtrueName, w9XchangeDir,
w9XmakeDir, w9XrmDir, w9Xrename, w9XsupportLFN;

(* ------------------------------------------------------------ *)

TYPE
    pathtype = path9X;

(* ------------------------------------------------------------ *)

CONST
    firstPath     = 1;   (* was 0, but 1 required by Lib.QSort and by firstPath-1 of course ! *)
    maxPath       = 5000; (* // 7500 *)
    firstFname    = 1;
    maxFname      = 5450; (* 65535 DIV (8+1+3) *)
    maxCLILEN     = 127-2-2;  (* Lib.ExecCmd expects [0..126] but randomly crashes 121..125 *)
CONST
    sMaxPath      = "5000";
    sMaxFname     = "10000";
TYPE
    scantype = (normalandspecial,normal,special,directoriesonly);
CONST
    dirbatName  = "DIRBAT";
    nl          = CHR(13)+CHR(10);
    colon       = ":";
    dot         = ".";
    backslash   = "\";
    dotdot      = dot+dot;
    star        = "*";
    stardotstar = star+dot+star;
    netslash    = backslash+backslash;
CONST
    dquote     = '"';
    dollar     = "$";
    underscore = "_";
    percent    = "%";
    pound      = "#";
    question   = "?";
CONST
    cDollar   = dollar;
    cCRLF     = underscore;
    cPound    = pound;
    cQuestion = question;
    cPercent  = "p";
    cU        = "u";
    cD        = "d";
    cB        = "b";
    cN        = "n";
    cE        = "e";
    cF        = "f";
    cC        = "c";
    cQ        = "q";
    cX        = "x";
CONST
    escch       = dollar;
    fmtDOLLAR   = escch+cDollar;
    fmtCRLF     = escch+cCRLF;
    fmtPERCENT  = escch+cPercent;
    fmtPOUND    = escch+cPound;
    fmtQUESTION = escch+cQuestion;
CONST
    fmtU        = escch+cU;
    fmtD        = escch+cD;
    fmtB        = escch+cB;
    fmtN        = escch+cN;
    fmtE        = escch+cE;
    fmtF        = escch+cF;
    fmtC        = escch+cC;
    fmtQ        = escch+cQ;
    fmtX        = escch+cX;
CONST           (* "## -                : " *)
    msgDefault   = "Default directory   : ";
    msgBaseDir   =   " - Base directory : ";
    msgSpec      =   " - Specification  : ";
    msgCmd       = "Command             : ";
    msgRecurse   = "Recursion           : ";
    msgExpand    = "Joker expansion     : ";
    msgAsk       = "Confirmation        : ";
    msgAttributes= "Attributes filter   : ";
    msgZeroFilter= "0-length filter     : ";
    msgTodayFilter="Current day filter  : ";
CONST
    strEsc    = str2(CHR(27));
    strYes    = str2("Y");
    strNo     = str2("N");
    strOui    = str2("O");
    strNon    = str2("N");
    strAll    = str2("A");
    strTous   = str2("T");

(* ------------------------------------------------------------ *)

CONST
    progEXEname   = "WITH";
    progTitle     = "Q&D With";
    progVersion   = "v1.2b";
    progCopyright = "by PhG";
    Banner        = progTitle+" "+progVersion+" "+progCopyright;

CONST
    errNone           = 0;
    errHelp           = 1;
    errOption         = 2;
    errParameter      = 3;
    errBadAttrib      = 4;
    errSyntax         = 5;
    errBadSpec        = 6;
    errTooManyDirs    = 7;
    errNotIfDir       = 8;
    errRecursion      = 9;
    errCmdSyntax      = 10;
    errAborted        = 11;
    errList           = 12;
    errTooManyFilesInDir=13;
    errStorage        = 14;
    errZeroToday      = 15;
    errHelper         = 16;

PROCEDURE abort (e : CARDINAL; einfo : ARRAY OF CHAR);

    MODULE message;
    IMPORT Str;
    EXPORT msg3;

    PROCEDURE msg3 (VAR R:ARRAY OF CHAR;S1,S2,S3:ARRAY OF CHAR);
    BEGIN
        Str.Concat(R,S1,S2);Str.Append(R,S3);
    END msg3;

    END message;

CONST
(*
 00000000011111111112222222222333333333344444444445555555555666666666677777777778
 1...'....0....'....0....'....0....'....0....'....0....'....0....'....0....'....0
*)
    msghelp=
Banner+nl+
nl+
"Syntax : "+progEXEname+' <filespec>... [option]... <"command">'+nl+
nl+
"  -n    auto-expand only normal files (H and S excluded, default is -n -z)"+nl+
"  -z    auto-expand only special files (H or S required, default is -n -z)"+nl+
"  -d    auto-expand only directories (H or S included)"+nl+
"  -0|-o process 0-length entries only (-o is supported for obvious reasons)"+nl+
"  -j    process current day's entries only"+nl+
"  -s    include subdirectories (valid if only one filespec was specified)"+nl+
"  -a    ask confirmation (Yes/No/Always/Escape)"+nl+
"  -e    expand jokers and pass each file individually (forced by any of nzd0oj)"+nl+
"  -v[v] (very) verbose (default is -v)"+nl+
"  -q    quiet"+nl+
"  -lfn  disable LFN support even if available (token replacement ONLY !)"+nl+
"  -t    test mode (-q ignored, forced with redirected output)"+nl+
"  -??   more help"+nl+
nl+
"This program applies <command> to specified file(s) ; in default joker mode,"+nl+
"it will not try to run <command> if no files matches <filespec>."+nl+
"For safety, -n, -z, -d and -0 options automagically force -e option."+nl+
"Note LFN support is limited to token replacement ONLY !"+nl;

    msgHelper = nl+
"Command tokens are :"+nl+
nl+
"  "+fmtCRLF     +"  newline"+nl+
"  "+fmtPERCENT  +"  percent character"+nl+
"  "+fmtDOLLAR   +"  dollar character"+nl+
"  "+fmtU        +"  unit"+nl+
"  "+fmtD        +"  directory"+nl+
"  "+fmtB        +'  directory without trailing "\"'+nl+
"  "+fmtN        +"  file"+nl+
"  "+fmtE        +"  extension (without dot)"+nl+
"  "+fmtF        +"  file.extension"+nl+
"  "+fmtC        +"  shortcut for "+fmtU+fmtD+fmtF+" (any LFN automagically becomes "+fmtQ+fmtC+fmtQ+")"+nl+
"  "+fmtX        +"  shortcut for "+fmtU+fmtD+fmtF+" (forced to DOS format even with LFN support)"+nl+
"  "+fmtQ        +"  double quote"+nl+
"  "+fmtPOUND    +"  auto-incremented ##### decimal number starting from 1 (-e advised)"+nl+
"  "+fmtQUESTION +'  auto-incremented ??? string starting from "AAA" (-e advised)'+nl+
nl+
"a) Though auto-incrementation is global, it should not be used with -s option."+nl+
"b) Unlike "+dirbatName+" utility, this program is single-line oriented by design :"+nl+
'   "'+fmtCRLF+'" token will be ignored except in test mode or with redirected output.'+nl+
"c) This program will not process more than "+sMaxPath+" directories,"+nl+
"   and no more than "+sMaxFname+" files per directory, whatever available RAM."+nl+
"d) For safety, any command line longer than 122 characters will be skipped."+nl+
"e) If LFN support is available, and if -lfn option was NOT specified,"+nl+
"   program will replace each original f8e3 token with its matching LFN form :"+nl+
"   "+fmtQ+" token is highly recommended in order to avoid unexpected side effects"+nl+
"   (note only "+fmtC+" token automagically encloses LFN with double quotes)."+nl+
nl+
"Examples : "+progEXEname+' *.tmp -s "DEL '+fmtU+fmtD+fmtN+dot+fmtE+'"'+nl+
"           "+progEXEname+' c:\bat\*.exe c:\tools\*.exe "COPY '+fmtU+fmtD+fmtN+dot+fmtE+' G:\tmp"'+nl+
"           "+progEXEname+' *.C *.H *.CPP "del $f"'+nl+
"           "+progEXEname+' -q -e *.thm "RAPPORT $f"'+nl+
"           "+progEXEname+' -e \mesdoc~1\*.* "dir $c"'+nl+
"           "+progEXEname+' -e \mesdoc~1\*.* "dir $q$u$d$f$q"'+nl;

VAR
    S : str256;
BEGIN
    CASE e OF
    | errHelp,errHelper :
        WrStr(msghelp);
        IF e=errHelper THEN
            WrStr(msgHelper);
            e:=errHelp;
        END;
    | errOption :      msg3(S,"Illegal ",einfo," option !");
    | errParameter :   msg3(S,"Useless ",einfo," parameter !");
    | errBadAttrib :   msg3(S,"Illegal attribute in ",einfo," option !");
    | errSyntax :      S:="Syntax error !";
    | errBadSpec :     msg3(S,"Illegal ",einfo," specification !");
    | errTooManyDirs : msg3(S,"Too many directories from ",einfo," !");
    | errNotIfDir    : S:="Recursion unsupported with -a:D option !";
    | errRecursion   : S:="Recursion supported if only one filespec was specified !";
    | errCmdSyntax   : S:="Command must be delimited with double quotes !";
    | errAborted     : S:="Aborted by user !";
    | errList       :  S:="-n, -z and -d options are mutually exclusive !";
    | errTooManyFilesInDir : S:="Too many files in directory to process !";
    | errStorage :     S:="Storage.ALLOCATE() failure !";
    | errZeroToday :   S:="-0 and -j options are mutually exclusive !";
    ELSE
        S := "This is illogical, Captain !";
    END;
    CASE e OF
    | errNone, errHelp : ;
    ELSE
        WrStr(progEXEname+" : ");WrStr(S);WrLn;
    END;
    Lib.SetReturnCode(SHORTCARD(e));
    HALT;
END abort;

(* ------------------------------------------------------------ *)
(* ------------------------------------------------------------ *)

TYPE
    ptrToEntry = POINTER TO pathEntrytype;
    pathEntrytype  = RECORD
        slen : SHORTCARD;
        string:CHAR; (* variable length *)
    END;
VAR (* globerk TO keep compiler happy *)
    Path      : ARRAY[firstPath..maxPath] OF ptrToEntry;

PROCEDURE freePathList ( last:CARDINAL );
VAR
    i,len,needed:CARDINAL;
BEGIN
    FOR i:=firstPath TO last DO
         IF Path[i] # NIL THEN
             len := CARDINAL(Path[i]^.slen);
             needed := SIZE(pathEntrytype)-SIZE(CHAR)+len;
             DEALLOCATE(Path[i],needed);
         END;
    END;
END freePathList;

(* ------------------------------------------------------------ *)

PROCEDURE fixDirPath (VAR S : ARRAY OF CHAR);
VAR
    len : CARDINAL;
BEGIN
    len := Str.Length(S);
    IF len = 0 THEN
        Str.Copy(S,backslash);
    ELSE
        IF S[len-1] # backslash THEN
            Str.Append(S,backslash);
        END;
    END;
END fixDirPath;

PROCEDURE isDirEntry (S : ARRAY OF CHAR) : BOOLEAN;
BEGIN
    IF same(S,dot) THEN RETURN TRUE; END;
    RETURN same(S,dotdot);
END isDirEntry;

PROCEDURE getentry (i:CARDINAL; VAR R : ARRAY OF CHAR);
CONST
    nullchar=CHR(0);
VAR
    len:CARDINAL;
BEGIN
    len := CARDINAL(Path[i]^.slen);
    Lib.FastMove( ADR(Path[i]^.string),ADR(R),len);
    R[len]:=nullchar; (* REQUIRED safety ! *)
END getentry;

PROCEDURE setentry (i:CARDINAL; S : ARRAY OF CHAR  ) : BOOLEAN ;
VAR
    len,needed:CARDINAL;
BEGIN
    len    := Str.Length(S);
    needed := SIZE(pathEntrytype)-SIZE(CHAR)+len;
    IF Available(needed) THEN
        ALLOCATE(Path[i],needed);
        Path[i]^.slen := SHORTCARD(len);
        Lib.FastMove( ADR(S),ADR(Path[i]^.string),len);
    ELSE
        Path[i]:=NIL;
    END;
    RETURN (Path[i] # NIL);
END setentry;

PROCEDURE doDir (root : ARRAY OF CHAR;eyecandy:BOOLEAN;
                 VAR index:CARDINAL;VAR err:BOOLEAN);
VAR
    path    : str128;
    S       : str128;
    entry   : FIO.DirEntry;
    found   : BOOLEAN;
BEGIN
    IF index > maxPath THEN
        err:=TRUE;
        RETURN;
    END;
    fixDirPath(root); (* add required "\" here *)
(* WrStr("Dir  ");WrCard(index,8);WrStr(" : ");WrStr(root);WrLn; *)
    IF setentry(index,root)=FALSE THEN
        err:=TRUE;
        RETURN;
    END;

    Str.Copy(path,root);
    (* fixDirPath(path); (* add required \ *) was done a few lines earlier *)
    Str.Append(path,stardotstar); (* root\*.* *)

    found := FIO.ReadFirstEntry(path,everything,entry);
    WHILE found DO
        IF eyecandy THEN Work(cmdShow); END;
        Str.Copy(S,root);
        fixDirPath(S);
        Str.Append(S,entry.Name); (* root\f8e3 *)
        IF isDirEntry(entry.Name)=FALSE THEN (* skip . and .. *)
            IF aD IN entry.attr THEN
                INC(index);
                doDir(S,eyecandy,index,err);
            END;
        END;
        found :=FIO.ReadNextEntry(entry);
    END;
END doDir;

PROCEDURE BuildPathList (rootdir : ARRAY OF CHAR) : CARDINAL;
CONST
    msg1 = "Building list of directories for ";
VAR
    found    : BOOLEAN;
    i        : CARDINAL;
    prompt   : str128;
    error    : BOOLEAN;
BEGIN
    Str.Concat(prompt,msg1,rootdir);

    video (prompt,TRUE);
    Work(cmdInit);

    i        := firstPath;
    error    := FALSE;

    doDir(rootdir,TRUE,i,error);

    Work(cmdStop);
    video (prompt,FALSE);
    IF error THEN i:=MAX(CARDINAL); END;
    RETURN i;
END BuildPathList;

(* ------------------------------------------------------------ *)
(* ------------------------------------------------------------ *)

(*
Year stored relative to 1980 (ex. 1988 stores as 8)
    year      month    day   

 F E D C B A 9 8 7 6 5 4 3 2 1 0   <-- Bit Number
*)

CONST
    yyMask=BITSET{9..15};
    yyShft=9;
    mmMask=BITSET{5..8};
    mmShft=5;
    ddMask=BITSET{0..4};
    ddShft=0;
    mindd=1;
    maxdd=31;
    minmm=1;
    maxmm=12;
    minyy=1980; (* base year for messdos *)
    maxyy=minyy+127; (* was 2099 *)
    baseyear=minyy;  (* 1980 *)

PROCEDURE PackDMY (d,m,y : CARDINAL  ) : CARDINAL;
BEGIN
    IF y < baseyear THEN
        y:=baseyear;
    END;
    DEC(y,baseyear);
    IF y > 127 THEN y:=127; END; (* %1111111 i.e. $7f max *)
    y := y << yyShft;
    m := m << mmShft;
    RETURN (y + m + d);
END PackDMY;

PROCEDURE gethodie (  ):CARDINAL;
VAR
    j,m,a,v:CARDINAL;
    dow:Lib.DayType;
BEGIN
    Lib.GetDate(a,m,j,dow);
    RETURN PackDMY(j,m,a);
END gethodie;

(* ------------------------------------------------------------ *)

PROCEDURE fmtnum (VAR R:ARRAY OF CHAR; num,base,digits:CARDINAL;pad:CHAR);
VAR
    ok:BOOLEAN;
    i:CARDINAL;
BEGIN
    Str.CardToStr( LONGCARD(num), R, base, ok );
    FOR i:=Str.Length(R)+1 TO digits DO
        Str.Prepend(R,pad);
    END;
END fmtnum;

PROCEDURE chkSpec (defaultdir:ARRAY OF CHAR;VAR basedir,spec:ARRAY OF CHAR):BOOLEAN;
VAR
    u,d,n,e:str128; (* "u:" "\*\" "" "" *)
BEGIN
    IF Str.Pos(spec,netslash) # MAX(CARDINAL) THEN RETURN FALSE; END;
    IF same(spec,dot) THEN Str.Copy(spec,stardotstar);END;
    IF Str.Match(spec,"*\") THEN Str.Append(spec,stardotstar);END;
    CASE CharCount(spec,colon) OF
    | 0 : ;
    | 1 : IF Str.CharPos(spec,colon) # 1 THEN RETURN FALSE; END; (* only "?:*" allowed *)
    ELSE
        RETURN FALSE;
    END;

    IF Str.Match(spec,"?:\*") THEN
        ;
    ELSIF Str.Match(spec,"?:*") THEN
        RETURN FALSE;
    ELSIF Str.Match(spec,"\*") THEN
        Str.Prepend(spec,colon);
        Str.Prepend(spec,defaultdir[0]);
    ELSE
        Str.Prepend(spec,defaultdir);
    END;

    IF chkJoker(spec)=FALSE THEN
        IF isDirectory(spec) THEN Str.Append(spec,backslash+stardotstar);END;
    END;

    Lib.SplitAllPath(spec,u,d,n,e);
    Lib.MakeAllPath(basedir,u,d,"","");
    Lib.MakeAllPath(spec,"","",n,e);
    RETURN TRUE;
END chkSpec;

PROCEDURE chkQuotedLastParm (  ):BOOLEAN;
VAR
    i:CARDINAL;
    cli:str128;
BEGIN
    i := 0;
    LOOP
        cli[i] := Lib.CommandLine^[i];
        IF cli[i] = CHR(0) THEN EXIT; END;
        INC(i);
    END;
    IF i=0 THEN RETURN FALSE; END;
    cleantabs(cli);
    LtrimBlanks(cli);
    RtrimBlanks(cli);
    IF cli[Str.Length(cli)-1] # dquote THEN RETURN FALSE; END;
    RETURN ( CharCount(cli,dquote) = 2 );
END chkQuotedLastParm;

PROCEDURE wrbool (flag:BOOLEAN);
BEGIN
    IF flag THEN
        WrStr("yes");
    ELSE
        WrStr("no");
    END;
END wrbool;

(* assume legal "???" string *)

TYPE
    str3 = ARRAY [0..2] OF CHAR;
CONST
    orgnumalpha  = str3("AA"+CHR(ORD("A")-1)); (* same as 1-1 ! *)

PROCEDURE incalpha (VAR S:str3);
VAR
    i,code:CARDINAL;
    carry:BOOLEAN;
BEGIN
    i:=Str.Length(S);
    IF i = 0 THEN RETURN; END; (* should never happen but... *)
    LOOP
        DEC(i);
        code:=ORD(S[i]);
        INC(code);
        IF code > ORD("Z") THEN
            IF i=0 THEN
                code:=ORD("_"); (* safety *)
            ELSE
                code:=ORD("A");
            END;
            carry:=TRUE;
        ELSE
            carry:=FALSE;
        END;
        S[i]:=CHR(code);
        IF carry=FALSE THEN EXIT; END;
        IF i=0 THEN EXIT; END;
    END;
END incalpha;

(* ------------------------------------------------------------ *)

PROCEDURE procCmd (useLFN,ask,test,verbose,allowNL:BOOLEAN;
                   numauto:CARDINAL;numalpha:str3;
                   udne,cmd:ARRAY OF CHAR ):BOOLEAN;
VAR
    shortform,longform:pathtype;
    u,d,dd,n,e,ext:pathtype; (* was str128 *)
    R:str2048; (* really oversized ! *)
    i,len,rc:CARDINAL;
    ch,lowch:CHAR;
    getting:(grab,gotesc);
    snum:str16;
    code:str2;
    flagExec:BOOLEAN;
    cancelledExec:BOOLEAN;
BEGIN
    cancelledExec:=FALSE;

    IF useLFN THEN
        Str.Copy(shortform,udne);
        IF w9XshortToLong(shortform,rc,longform) THEN
            Lib.SplitAllPath(longform,u,d,n,e);
        ELSE
            Lib.SplitAllPath(shortform,u,d,n,e);
        END;
    ELSE
        Lib.SplitAllPath(udne,u,d,n,e); (* "u:" "\*\" "f" ".e" *) (* handles multiple dots *)
    END;
    Str.Copy(dd,d);
    unfixDirectory(dd);
    Str.Copy(ext,e); Str.Subst(ext,dot,"");
    R:="";
    getting:=grab;
    len := Str.Length(cmd);
    i:=0;
    WHILE i < len DO
        ch := cmd[i];
        CASE getting OF
        | grab :
            IF ch = escch THEN
                getting:=gotesc;
            ELSE
                Str.Append(R,ch);
            END;
        | gotesc:
            lowch:=ch; Str.Lows(lowch);
            CASE lowch OF
            | cDollar :  Str.Append(R,dollar);
            | cCRLF:     Str.Append(R,nl);
                IF NOT(allowNL) THEN
                    cancelledExec:=TRUE; (* single-line orientation reminder ! *)
                END;
            | cPercent:  Str.Append(R,percent);
            | cU:        Str.Append(R,u);
            | cD:        Str.Append(R,d);
            | cB:        Str.Append(R,dd);
            | cN:        Str.Append(R,n);
            | cE:        Str.Append(R,ext);
            | cF:        Str.Append(R,n);Str.Append(R,e);
            | cC:        IF useLFN THEN Str.Append(R,dquote);END;
                         Str.Append(R,u);
                         Str.Append(R,d);
                         Str.Append(R,n);Str.Append(R,e);
                         IF useLFN THEN Str.Append(R,dquote);END;
            | cX:        Str.Append(R,udne);
            | cQ:        Str.Append(R,dquote);
            | cPound:    fmtnum(snum,numauto,10,5,"0");Str.Append(R,snum);
            | cQuestion: Str.Append(R,numalpha);
            ELSE
                Str.Append(R,escch); Str.Append(R,ch);
            END;
            getting := grab;
        END;
        INC(i);
    END;
    IF test THEN
        WrStr(R);WrLn;
    ELSE
        IF cancelledExec THEN
            WrStr("--- Immediate mode cannot handle a multiline command !");WrLn;
        ELSE
            IF ask THEN
                WrLn; (* oops ! *)
                WrStr('::: About to exec "');WrStr(R); WrStr('" ? [Y/N/A/Esc] : ');
                code := Waitkey();
                UpperCase(code);
                IF code=strEsc THEN
                    WrStr("Aborted !"+nl);
                    abort(errAborted,"");
                ELSIF ( (code=strYes) OR (code=strOui) ) THEN
                    WrStr("Y");
                    flagExec:=TRUE;
                ELSIF ( (code=strAll) OR (code=strTous) ) THEN
                    WrStr("A");
                    flagExec:=TRUE;
                    ask :=FALSE;
                ELSE
                    WrStr("N");
                    flagExec:=FALSE;
                END;
            ELSE
                IF verbose THEN WrStr('::: Running "'); WrStr(R); WrStr('"'); END;
                flagExec := TRUE;
            END;
            IF verbose THEN WrLn; END;
            IF flagExec THEN
                IF Str.Length(R) < maxCLILEN THEN (* < 123 is okay else crash *)
                    rc := Lib.ExecCmd(R); (* directly use command.com *)
                ELSE
                    WrStr("--- Skipping this long command which would crash the program :");WrLn;
                    WrLn;
                    WrStr(R);WrLn;
                    WrLn;
                    (* abort(errNone,""); *)
                END;
            END;
        END;
    END;
    RETURN ask;
END procCmd;

(* ------------------------------------------------------------ *)

TYPE
    ptrToFname = POINTER TO fnameEntrytype;
    fnameEntrytype  = RECORD
        slen : SHORTCARD;
        string:CHAR; (* variable length *)
    END;
VAR (* globerks *)
    Fname  : ARRAY[firstFname..maxFname] OF ptrToFname;

PROCEDURE getFname (i:CARDINAL; VAR R : ARRAY OF CHAR);
CONST
    nullchar=CHR(0);
VAR
    len:CARDINAL;
BEGIN
    len := CARDINAL(Fname[i]^.slen);
    Lib.FastMove( ADR(Fname[i]^.string),ADR(R),len);
    R[len]:=nullchar; (* REQUIRED safety ! *)
END getFname;

PROCEDURE setFname (i:CARDINAL; S : ARRAY OF CHAR  ) : BOOLEAN ;
VAR
    len,needed:CARDINAL;
BEGIN
    len    := Str.Length(S);
    needed := SIZE(fnameEntrytype)-SIZE(CHAR)+len;
    IF Available(needed) THEN
        ALLOCATE(Fname[i],needed);
        Fname[i]^.slen := SHORTCARD(len);
        Lib.FastMove( ADR(S),ADR(Fname[i]^.string),len);
    ELSE
        Fname[i]:=NIL;
    END;
    RETURN (Fname[i] # NIL);
END setFname;

PROCEDURE freeFnameList (last:CARDINAL);
VAR
    i,len,needed:CARDINAL;
BEGIN
    FOR i:=firstFname TO last DO
         IF Fname[i] # NIL THEN
             len := CARDINAL(Fname[i]^.slen);
             needed := SIZE(fnameEntrytype)-SIZE(CHAR)+len;
             DEALLOCATE(Fname[i],needed);
         END;
    END;
END freeFnameList;

PROCEDURE procSpec (VAR numauto:CARDINAL;VAR numalpha:str3;VAR rc:CARDINAL;
                    scanmode:scantype;hodie:CARDINAL;
                    useLFN,zerofilter,todayfilter,expand,ask,test,verbose,allowNL:BOOLEAN;
                    root,spec,cmd:ARRAY OF CHAR):BOOLEAN;
VAR
    found,onlydirs,goahead,makemyday,ok:BOOLEAN;
    entry:FIO.DirEntry;
    S,R:str128;
    lastFname,i:CARDINAL;
    f8e3:str16; (* oversized *)
BEGIN
    rc:=errNone;
    fixDirectory(root);
    Str.Concat(S,root,spec);

    (* v1.2a : always count files *)

    lastFname:=firstFname-1;
    onlydirs := (scanmode=directoriesonly);
    found := FIO.ReadFirstEntry(S,everything,entry);  (* was wanted *)
    WHILE found DO

        IF zerofilter THEN (* process only *)
            goahead:=FALSE;
            IF entry.size = 0 THEN
                IF (aD IN entry.attr)=FALSE THEN
                    goahead:=NOT( isDirEntry(entry.Name) );
                END;
            END;
        ELSIF todayfilter THEN
            goahead:=FALSE;
            IF entry.date = hodie THEN
                IF (aD IN entry.attr)=FALSE THEN
                    goahead:=NOT( isDirEntry(entry.Name) );
                END;
            END;
        ELSE
            goahead := TRUE;
        END;

        CASE scanmode OF
        | special:          ok:=((aH IN entry.attr) OR (aS IN entry.attr));
                            ok:=( ok AND (NOT (aD IN entry.attr)) );
        | normal :          ok:=NOT ((aH IN entry.attr) OR (aS IN entry.attr));
                            ok:=( ok AND (NOT (aD IN entry.attr)) );
        | normalandspecial: ok:=NOT (aD IN entry.attr);
        | directoriesonly:  ok:=(aD IN entry.attr);
        END;
        makemyday := ok;

        goahead   := (goahead AND makemyday);


        Str.Copy(f8e3,entry.Name);
(* WrStr("File ");WrCard(lastFname,8);WrStr(" : ");WrStr(f8e3);WrLn; *)
        IF onlydirs THEN
            IF isDirEntry (f8e3)=FALSE THEN (* even here, "." and ".." do not apply as directories *)
                IF goahead THEN

                    (*
                    we could ignore silently overflow,
                    for whoever has 10000 files in the same directory
                    must be crazy and deserves a warning <g>
                    but we're too kind...
                    *)

                    IF lastFname < maxFname THEN
                        INC(lastFname);
                    ELSE
                        rc:=errTooManyFilesInDir; RETURN TRUE;
                    END;

                    ok:=setFname(lastFname, f8e3);
                    IF NOT(ok) THEN rc:=errStorage;RETURN TRUE;END;
                END;
            END;
        ELSE
            IF goahead THEN

                IF lastFname < maxFname THEN
                    INC(lastFname);
                ELSE
                    rc:=errTooManyFilesInDir; RETURN TRUE;
                END;

                ok:=setFname(lastFname, f8e3);
                IF NOT(ok) THEN rc:=errStorage;RETURN TRUE;END;
            END;
        END;

        found :=FIO.ReadNextEntry(entry);
    END;

    IF expand THEN
        FOR i:= firstFname TO lastFname DO

            INC(numauto);
            incalpha(numalpha);

            getFname(i,f8e3);
(* WrStr("Got  ");WrCard(i,8);WrStr(" : ");WrStr(f8e3);WrLn; *)
            Str.Concat(R,root,f8e3);
            ask:=procCmd(useLFN,ask,test,verbose,allowNL,numauto,numalpha,R,cmd);
        END;
    ELSE
        IF lastFname >= firstFname THEN (* only fi there's at least one matching file *)
            INC(numauto);incalpha(numalpha); (* is it really wise here ? *)
            ask:=procCmd(useLFN,ask,test,verbose,allowNL,numauto,numalpha,S,cmd);
        END;
    END;
    freeFnameList(lastFname); (* don't forget it ! *)

    RETURN ask;
END procSpec;

(* ------------------------------------------------------------ *)
(* ------------------------------------------------------------ *)

TYPE
    specentrytype = RECORD
        basedir : str128;
        spec    : str128;
    END;
CONST
    firstSpec = 1;
    maxSpec   = 32+1; (* allow for final command -- and 32 because... we're under a hex spell *)
VAR
    specentry : ARRAY [firstSpec..maxSpec] OF specentrytype;
VAR
    lastPath  : CARDINAL;
    spec,cmd,currdir,defaultdir,basedir : str128;
    zerofilter,todayfilter,recurse,flagAsk,flagExpand:BOOLEAN;
    verbose,veryverbose,testmode,allowNL: BOOLEAN;
    useLFN:BOOLEAN;
    currdrive:SHORTCARD;
    rc,lastSpec :CARDINAL;
    numauto:CARDINAL;
    numalpha:str3;
    scanmode:scantype;
    hodie : CARDINAL;
VAR
    parmcount,i,j,opt:CARDINAL;
    S,R,ATTR:str128;
BEGIN
    (* Lib.DisableBreakCheck(); *)
    FIO.IOcheck := FALSE;
    FIO.ShareMode:=FIO.ShareDenyNone; (* very, very important ! *)

    WrLn; (* here now for ulterior help, error, etc. display *)

    useLFN     := TRUE;
    scanmode   := normalandspecial;
    zerofilter := FALSE;
    todayfilter:= FALSE;
    recurse    := FALSE;
    flagAsk    := FALSE;
    flagExpand := FALSE; (* once true, forever true *)
    verbose    := TRUE;
    veryverbose:= FALSE;
    testmode   := FALSE;
    lastSpec   := firstSpec-1;

    parmcount := Lib.ParamCount();
    IF parmcount=0 THEN abort(errHelp,""); END;

    currdrive := FIO.GetDrive(); (* 1=A, etc. *)
    FIO.GetDir(currdrive,currdir); (* we could use 0 for default drive *)
    (* we have unit letter and "\xxx" directory now *)

    Str.Copy(defaultdir,CHR(ORD("A")-1+currdrive));
    Str.Append(defaultdir,colon);
    Str.Append(defaultdir,currdir);
    UpperCase(defaultdir); (* probably useless *)
    fixDirectory(defaultdir);      (* add required trailing "\" *)

    FOR i := 1 TO parmcount DO
        Lib.ParamStr(S,i); cleantabs(S);
        Str.Copy(R,S);UpperCase(R);
        IF isOption(R) THEN
            opt := GetOptIndex(R, "?"+delim+"H"+delim+"HELP"+delim+
                                  "N"+delim+"NORMAL"+delim+
                                  "S"+delim+"RECURSE"+delim+
                                  "A"+delim+"ASK"+delim+
                                  "E"+delim+"EXPAND"+delim+
                                  "V"+delim+"VERBOSE"+delim+
                                  "T"+delim+"TEST"+delim+
                                  "0"+delim+"ZERO"+delim+
                                  "VV"+delim+"VERYVERBOSE"+delim+
                                  "Z"+delim+"SPECIAL"+delim+
                                  "D"+delim+"DIRECTORIES"+delim+
                                  "Q"+delim+"QUIET"+delim+
                                  "LFN"+delim+"9X"+delim+"X"+delim+
                                  "J"+delim+"TODAY"+delim+"HODIE"+delim+
                                  "O"+delim+
                                  "??"
                              );
            CASE opt OF
            | 1,2,3 : abort(errHelp,"");
            | 4,5   : CASE scanmode OF
                      | normalandspecial,normal:
                          scanmode:=normal;
                      ELSE
                          abort(errList,"");
                      END;
                      flagExpand := TRUE;
            | 6,7   : recurse    := TRUE;
            | 8,9   : flagAsk    := TRUE;
            | 10,11 : flagExpand := TRUE;
            | 12,13 : verbose    := TRUE; veryverbose:= FALSE;
            | 14,15 : testmode   := TRUE;
            | 16,17 : zerofilter := TRUE;
                      flagExpand := TRUE;
            | 18,19 : verbose    := TRUE; veryverbose:= TRUE;
            | 20,21 : CASE scanmode OF
                      | normalandspecial,special:
                          scanmode:=special;
                      ELSE
                          abort(errList,"");
                      END;
                      flagExpand := TRUE;
            | 22,23 : CASE scanmode OF
                      | normalandspecial,directoriesonly:
                          scanmode:=directoriesonly;
                      ELSE
                          abort(errList,"");
                      END;
                      flagExpand := TRUE;
            |24,25:   verbose    := FALSE; veryverbose:= FALSE;
            |26,27,28:useLFN     := FALSE;
            |29,30,31:todayfilter:= TRUE;
                      flagExpand := TRUE;
            |32:      zerofilter := TRUE; (* yep, 0 and O *)
                      flagExpand := TRUE;
            |33:      abort(errHelper,"");
            ELSE
                abort(errOption,S);
            END;
        ELSE
           INC(lastSpec);
           IF lastSpec > maxSpec THEN abort(errParameter,S);END;
           Str.Copy(specentry[lastSpec].spec,S);
        END;
    END;

    useLFN := ( useLFN AND w9XsupportLFN() );

    IF lastSpec < firstSpec THEN abort(errSyntax,"");END; (* not even a filespec *)
    IF lastSpec = firstSpec THEN abort(errSyntax,"");END; (* filespec without a command *)

    IF chkQuotedLastParm()=FALSE THEN abort(errCmdSyntax,"");END;

    IF todayfilter THEN
        IF zerofilter THEN abort(errZeroToday,""); END;
    END;

    Str.Copy(cmd,specentry[lastSpec].spec);
    DEC(lastSpec);
    IF recurse THEN
        IF lastSpec # firstSpec THEN abort(errRecursion,"");END;
    END;

    FOR i:=firstSpec TO lastSpec DO
        Str.Copy(spec,specentry[i].spec);
        UpperCase(spec);
        IF chkSpec(defaultdir,basedir,spec)=FALSE THEN abort(errBadSpec,spec);END;
        Str.Copy(specentry[i].basedir,basedir);
        Str.Copy(specentry[i].spec,spec);
    END;

    hodie:=gethodie();

(*
    IF ( (aD IN wanted) AND recurse ) THEN abort(errNotIfDir,"");END;
*)

    IF IsRedirected() THEN testmode:=TRUE; END;
    allowNL:=( testmode OR IsRedirected() ); (* prevent multiline quirk better suited to DIRBAT *)

IF testmode THEN
    flagAsk:=FALSE; (* cancel possible -q, useless here *)
ELSE
    IF veryverbose THEN
        IF verbose THEN
            WrStr(Banner);WrLn;
            WrLn;
        END;
        WrStr(msgDefault);WrStr(defaultdir);WrLn;
        WrLn;
        FOR i:=firstSpec TO lastSpec DO
            WrCard(i,2);WrStr(msgBaseDir);
            WrStr(specentry[i].basedir);WrLn;
            WrCard(i,2);WrStr(msgSpec);
            WrStr(specentry[i].spec);WrLn;
        END;
        WrLn;
        WrStr(msgCmd);WrStr(dquote);WrStr(cmd);WrStr(dquote);WrLn;
        WrLn;
        WrStr(msgRecurse);wrbool(recurse);WrLn;
        WrStr(msgExpand);wrbool(flagExpand);WrLn;
        WrStr(msgAsk);wrbool(flagAsk);WrLn;
        WrStr(msgZeroFilter);wrbool(zerofilter);WrLn;
        WrStr(msgTodayFilter);wrbool(todayfilter);WrLn;

        WrStr(msgAttributes);
        CASE scanmode OF
        | normalandspecial: S:="all files, including normal and special";
        | normal:           S:="normal files, excluding hidden or system files";
        | special:          S:="hidden or system files";
        | directoriesonly:  S:="directories only";
        END;
        WrStr(S);WrLn;

        WrLn;
    END;
END;

    numauto:=1-1; (* just in case we would need it *)
    numalpha:=orgnumalpha;

    IF recurse THEN
        Str.Copy(spec,specentry[firstSpec].spec);
        lastPath := BuildPathList (specentry[firstSpec].basedir);
        IF lastPath=MAX(CARDINAL) THEN abort(errTooManyDirs,specentry[firstSpec].basedir);END;

        FOR i:=firstPath TO lastPath DO
            getentry( i, S );
            flagAsk := procSpec(numauto,numalpha,rc, scanmode,hodie,useLFN,
                       zerofilter,todayfilter,flagExpand,
                       flagAsk,testmode,verbose,allowNL,
                       S,spec,cmd);
            CASE rc OF
            | errTooManyFilesInDir,errStorage:abort(rc,"");
            END;
        END;
        freePathList(lastPath);
    ELSE
        FOR i:=firstSpec TO lastSpec DO
            flagAsk := procSpec(numauto,numalpha,rc, scanmode,hodie,useLFN,
                       zerofilter,todayfilter,flagExpand,
                       flagAsk,testmode,verbose,allowNL,
                       specentry[i].basedir,specentry[i].spec,cmd);
            CASE rc OF
            | errTooManyFilesInDir,errStorage:abort(rc,"");
            END;
        END;
    END;

    abort(errNone,"");
END With.

