(* ---------------------------------------------------------------
Title         Q&D Show Pictures Dimensions
Overview      Yet Another Completely Useless Program
Usage         see help
Notes         model cannot be small
Bugs          yes, we know JPG data should not be hardcoded
              YATB : checking in a set does not work ! seen in chkTGA()
Wish List     clever external pattern database ?
              filter according to user-specified dimensions ?
              more formats ?
              more infos about pictures ? bah, we just need dimensions

--------------------------------------------------------------- *)

MODULE picDimS;

IMPORT Str;
IMPORT Lib;
IMPORT FIO;

FROM IO IMPORT WrStr, WrLn;

FROM Storage IMPORT Available,ALLOCATE,DEALLOCATE;

FROM QD_Box IMPORT str80, str2, cmdInit, cmdShow, cmdStop, delim,
Work, video, Ltrim, Rtrim, UpperCase, LowerCase, ReplaceChar,
ChkEscape, Waitkey, WaitkeyDelay, Flushkey, IsRedirected, chkJoker,
isOption, GetOptIndex, GetLongCard, GetLongInt, GetString, CharCount,
same, aR, aH, aS, aD, aA, everything, isDirectory, fixDirectory,
str128, str256, Animation, allfiles, Belongs, FixAE, CodePhonetic,
CodeSoundex, CodeSoundexOrg, isReadOnly, LtrimBlanks, RtrimBlanks,
getStrIndex, cmdSHOW,BiosWaitkey,BiosWaitkeyShifted,BiosFlushkey,
str1024, isoleItemS, dmpTTX, str2048, Elapsed, TerminalReadString,
getDosVersion, DosVersion, warning95, runningWindows,
aV, reallyeverything, chkClassicTextMode, setClassicTextMode,
AltAnimation, str16, getCurrentDirectory, setReadWrite, setReadOnly,
getFileSize, verifyString, str4096, unfixDirectory,
animShow, animSHOW, animAdvance, animEnd, animClear,
animInit, animGetSdone, anim, cleantabs, UpperCaseAlt, LowerCaseAlt,
completedInit, completedShow, completedSHOW, completedEnd, completed,
removeDups, isValidHDunit, removePhantoms, removeFloppies,
getCDROMunits, getCDROMletters, removeCDROMs, getAllHDunits;

FROM QD_LFN IMPORT path9X, huge9X, findDataRecordType,
unicodeConversionFlagType, w9XchangeDir,
w9XgetDOSversion, w9XgetTrueDOSversion, w9XisWindowsEnh, w9XisMSDOS7,
w9XfindFirst, w9XfindNext, w9XfindClose, w9XgetCurrentDirectory,
w9XlongToShort, w9XshortToLong, w9XtrueName, w9XchangeDir,
w9XmakeDir, w9XrmDir, w9Xrename, w9XopenFile, w9XcloseFile,
w9XsupportLFN;

FROM QD_File IMPORT pathtype, w9XnothingRequired,
fileOpenRead, fileOpen, fileExists, fileExistsAlt,
fileIsRO, fileSetRW, fileSetRO,
fileErase, fileCreate, fileRename, fileGetFileSize, fileIsDirectorySpec,
fileClose;

(* ------------------------------------------------------------ *)

CONST
    cr          = CHR(13);
    lf          = CHR(10);
    nl          = cr+lf;
    ctrlZ       = CHR(26); (* $1a *)
    blank       = " ";
    dot         = ".";
    nullchar    = CHR(0);
    doublequote = '"';
    star        = "*";
    stardotstar = star+dot+star;
    dotdot      = dot+dot;
    specSWP     = "*.SWP";
    specPAR     = "*.PAR";
    specPAGEFILE= "*\PAGEFILE.SYS"; (* was "?:\PAGEFILE.SYS" *)
    specLST     = "*.LST";
    specRPT     = "*.RPT";
    TOOMANY     = MAX(CARDINAL);
    supportedFormats = "GIF, PNG, JPG, PCX, BMP, TGA and DDS";
    partialsupport   = "JPG, PCX, TGA and DDS";
CONST
    progEXEname   = "PICDIMS";
    progTitle     = "Q&D Show Pictures Dimensions";
    progVersion   = "v1.0d";
    progCopyright = "by PhG";
    banner        = progTitle+" "+progVersion+" "+progCopyright;
CONST
    errNone            = 0;
    errHelp            = 1;
    errUnknownOption   = 2;
    errTooManyParms    = 3;
    errMissingSpec     = 4;
    errNotFound        = 5;
    errNotFile         = 6;
    errJokerPath       = 7;
    errAborted         = 8;
    errNoMatch         = 9;
    errTooMany         = 10;
    errFmt             = 11;
    errScreen          = 12;
    errInverse         = 13;

PROCEDURE abort (e : CARDINAL; einfo : ARRAY OF CHAR);
CONST
(*
 00000000011111111112222222222333333333344444444445555555555666666666677777777778
 1...'....0....'....0....'....0....'....0....'....0....'....0....'....0....'....0
*)

errmsg =
banner+nl+
nl+
"Syntax : "+progEXEname+" <filespec> [option]..."+nl+
nl+
"This program shows "+supportedFormats+" pictures dimensions."+nl+
nl+
"  -f[f] pad dimensions as ####x#### using space (-f) or 0 (-ff)"+nl+
"  -l    list unknown files in addition to recognized graphics files"+nl+
"  -#    list file only if one dimension is greater than specified screen size"+nl+
"        (320x[2]00  640x[4]80  800x[6]00  1024x[7]68  1280x[9]60  1600x[1]200)"+nl+
"  -i    invert results (-# option only)"+nl+
"  -x    disable LFN support even if available"+nl+
nl+
"a) For obvious reasons, program will not try and analyze files matching"+nl+
"   "+specSWP+", "+specPAR+" and "+specPAGEFILE+" specifications."+nl+
"   Files matching "+specLST+" and "+specRPT+" will be skipped too."+nl+
"b) "+partialsupport+" support is limited : unexpected results may happen."+nl;

VAR
    S  : str256; (* we may get a LFN *)
BEGIN
    CASE e OF
    | errHelp :
        WrStr(errmsg);
    | errUnknownOption:
        Str.Concat(S,"Unknown ",einfo);Str.Append(S," option !");
    | errTooManyParms:
        Str.Concat(S,einfo," is one parameter too many !");
    | errMissingSpec:
        S := "Missing <filespec> !";
    | errNotFound:
        Str.Concat(S,einfo," does not exist !");
    | errNotFile:
        Str.Concat(S,einfo," looks like a directory !");
    | errJokerPath:
        S := "Jokers are not allowed in path !";
    | errAborted:
        S := "Aborted by user !";
    | errNoMatch:
        S := "No file matches <filespec>";
    | errTooMany:
        S := "Storage.ALLOCATE() failure !"; (* or 65535 matches ! *)
        S := "Too many files !";
    | errFmt:
        S :="-f and -ff options are mutually exclusive !";
    | errScreen:
        S := "Screen dimensions defined more than once !";
    | errInverse:
        S := "-i option requires -# option !";
    ELSE
        S := "This is illogical, Captain !";
    END;
    CASE e OF
    | errNone,errHelp :
        ;
    ELSE
        WrStr(progEXEname+" : ");WrStr(S);WrLn;
    END;
    Lib.SetReturnCode(SHORTCARD(e));
    HALT;
END abort;

(* ------------------------------------------------------------ *)

PROCEDURE fmtbignum (v:LONGCARD; base:CARDINAL;wi:INTEGER; pad:CHAR ):str16;
VAR
    S:str16;
    ok:BOOLEAN;
    i : CARDINAL;
BEGIN
    Str.CardToStr( v, S, base,ok);
    FOR i:=Str.Length(S)+1 TO ABS(wi) DO
         IF wi < 0 THEN
             Str.Append(S,pad);
         ELSE
             Str.Prepend(S,pad);
         END;
    END;
    IF base=16 THEN Str.Lows(S);END;
    RETURN S;
END fmtbignum;

PROCEDURE dwflip (v:LONGCARD):LONGCARD;
TYPE
    doubleword = RECORD (* boy, this is ugly... but effective ! *)
        CASE : BOOLEAN OF
        | TRUE:  n:LONGCARD;
        | FALSE: a,b,c,d:SHORTCARD;
        END;
    END;
VAR
    intel,motorola:doubleword;
BEGIN
    motorola.n:=v;
    intel.a := motorola.d;
    intel.b := motorola.c;
    intel.c := motorola.b;
    intel.d := motorola.a;
    RETURN intel.n;
END dwflip;

PROCEDURE wflip (v:CARDINAL):CARDINAL;
TYPE
    singleword = RECORD (* boy, this is ugly... but effective ! *)
        CASE : BOOLEAN OF
        | TRUE:  n:CARDINAL;
        | FALSE: a,b:SHORTCARD;
        END;
    END;
VAR
    intel,motorola:singleword;
BEGIN
    motorola.n:=v;
    intel.a := motorola.b;
    intel.b := motorola.a;
    RETURN intel.n;
END wflip;

PROCEDURE readByte (hin:FIO.File; pos:LONGCARD):BYTE;
VAR
    b:BYTE;
    got:CARDINAL;
BEGIN
    (* FIO.Seek(hin,pos); *)
    got:=FIO.RdBin(hin,b,SIZE(b));
    IF got # SIZE(b) THEN b:=0;END; (* ignore errors *)
    RETURN b;
END readByte;

PROCEDURE readWord (hin:FIO.File; pos:LONGCARD):WORD;
VAR
    w:WORD;
    got:CARDINAL;
BEGIN
    (* FIO.Seek(hin,pos); *)
    got:=FIO.RdBin(hin,w,SIZE(w));
    IF got # SIZE(w) THEN w:=0;END; (* ignore errors *)
    RETURN w;
END readWord;

PROCEDURE readDword (hin:FIO.File; pos:LONGCARD):LONGWORD;
VAR
    d:LONGWORD;
    got:CARDINAL;
BEGIN
    (* FIO.Seek(hin,pos); *)
    got:=FIO.RdBin(hin,d,SIZE(d));
    IF got # SIZE(d) THEN d:=0;END; (* ignore errors *)
    RETURN d;
END readDword;

(* ------------------------------------------------------------ *)

PROCEDURE chkJokerPath (spec:pathtype  ):BOOLEAN;
VAR
    S,u,d,n,e:pathtype;
BEGIN
    Lib.SplitAllPath(spec,u,d,n,e);
    Lib.MakeAllPath(S,u,d,"","");
    RETURN chkJoker(S);
END chkJokerPath;

(* Str.Match is not case sensitive *)

PROCEDURE isReservedPattern (S:ARRAY OF CHAR):BOOLEAN;
BEGIN
    IF Str.Match(S,specLST) THEN RETURN TRUE; END;
    IF Str.Match(S,specRPT) THEN RETURN TRUE; END;
    IF Str.Match(S,specSWP) THEN RETURN TRUE; END;
    IF Str.Match(S,specPAR) THEN RETURN TRUE; END;
    RETURN Str.Match(S,specPAGEFILE);
END isReservedPattern;

PROCEDURE isReservedEntry (S : ARRAY OF CHAR) : BOOLEAN; (* assume uppercase *)
BEGIN
    IF same(S,dot) THEN RETURN TRUE; END;
    IF same(S,dotdot) THEN RETURN TRUE; END;
    RETURN isReservedPattern(S);
END isReservedEntry;

(* ------------------------------------------------------------ *)

CONST
    firstEntry = 1; (* 1..count *)
TYPE
    ptrToEntry = POINTER TO entryType;
    entryType = RECORD
        next   : ptrToEntry;
        slen   : CARDINAL; (* a SHORTCARD would do fine in almost all cases  *)
        string : CHAR;      (* here, after other data, because variable length *)
    END;

PROCEDURE store (VAR newInList,anchor:ptrToEntry; VAR lastEntry:CARDINAL;
                S:pathtype):BOOLEAN ;
VAR
    len,needed:CARDINAL;
    rc:BOOLEAN;
BEGIN
    INC(lastEntry);
    IF lastEntry=TOOMANY THEN RETURN FALSE;END; (* too many files but fake storage ALLOCATE failure here *)

    len:=Str.Length(S);
    needed:=SIZE(entryType)-SIZE(CHAR)+len;
    rc:= Available(needed);
    IF rc THEN
        CASE lastEntry OF
        | firstEntry :
            ALLOCATE( anchor,needed);
            newInList := anchor;
        ELSE
            ALLOCATE(newInList^.next,needed);
            newInList :=newInList^.next;
        END;
        Lib.FastMove( ADR(S),ADR(newInList^.string),len);
        newInList^.slen := len;
        newInList^.next := NIL;
    END;
    RETURN rc;
END store;

PROCEDURE buildMatchList (VAR anchor:ptrToEntry;
                          useLFN:BOOLEAN;spec:pathtype):CARDINAL;
VAR
    S,u,d,n,e,dirbase,filespec:pathtype; (* some are oversized but safety first ! *)
    newInList : ptrToEntry;
    lastEntry: CARDINAL;
    unicodeconversion:unicodeConversionFlagType;
    w9Xentry : findDataRecordType;
    w9Xhandle,errcode:CARDINAL;
    DOSentry     : FIO.DirEntry;
    rc,found:BOOLEAN;
    dosattr:FIO.FileAttr;
BEGIN
    Lib.SplitAllPath(spec,u,d,n,e);
    Lib.MakeAllPath(dirbase,u,d,"","");
    fixDirectory(dirbase);
    Lib.MakeAllPath(filespec,"","",n,e);

    lastEntry:=firstEntry-1;
    anchor:=NIL;

    IF useLFN THEN
        found := w9XfindFirst (spec,SHORTCARD(everything),SHORTCARD(w9XnothingRequired),
                              unicodeconversion,w9Xentry,w9Xhandle,errcode);
    ELSE
        found := FIO.ReadFirstEntry(spec,everything,DOSentry);
    END;
    WHILE found DO
        IF useLFN THEN
            Str.Copy(S,w9Xentry.fullfilename);
        ELSE
            Str.Copy(S,DOSentry.Name);
        END;
        IF isReservedEntry(S) THEN (* skip "." ".." "*.SWP" "*.PAR" *)
            ; (* silently ignore this spec *)
        ELSE
            IF useLFN THEN
                dosattr:=FIO.FileAttr(w9Xentry.attr AND 0FFH);
            ELSE
                dosattr:=DOSentry.attr;
            END;
            IF NOT (aD IN dosattr) THEN
                Str.Prepend(S,dirbase);
                IF store(newInList,anchor,lastEntry,S)=FALSE THEN
                    IF useLFN THEN rc:=w9XfindClose(w9Xhandle,errcode); END;
                    RETURN TOOMANY; (* storage ALLOCATE failure or too many files *)
                END;
            END;
        END;
        IF useLFN THEN
            found :=w9XfindNext(w9Xhandle, unicodeconversion,w9Xentry,errcode);
        ELSE
            found :=FIO.ReadNextEntry(DOSentry);
        END;
    END;
    IF useLFN THEN rc:=w9XfindClose(w9Xhandle,errcode); END;
    RETURN lastEntry;
END buildMatchList;

PROCEDURE freeMatchList (anchor:ptrToEntry);
VAR
    len,needed      : CARDINAL;
    firstInList,newInList   : ptrToEntry;
BEGIN
    firstInList := anchor;
    newInList := firstInList;
    WHILE newInList # NIL DO
        len         := CARDINAL(newInList^.slen);
        needed      := SIZE(entryType)-SIZE(CHAR)+len;
        firstInList := firstInList^.next;
        DEALLOCATE (newInList,needed);
        newInList := firstInList;
    END
END freeMatchList;

PROCEDURE getMatchEntry (VAR R:pathtype;
                         n:CARDINAL; anchor:ptrToEntry);
VAR
    i,len:CARDINAL;
    newInList:ptrToEntry;
    S:pathtype;
BEGIN
    newInList := anchor;
    DEC(n); (* trick to force to anchor if 1, and locate correct string if > 1 *)
    FOR i:=firstEntry TO n DO
         newInList := newInList^.next;
    END;
    len         := newInList^.slen;
    Lib.FastMove( ADR(newInList^.string),ADR(S),len);
    S[len]      := nullchar; (* REQUIRED safety ! *)
    Str.Copy(R,S); (* yep, compiler won't let us fill R directly *)
END getMatchEntry;

(* ------------------------------------------------------------ *)
(* ------------------------------------------------------------ *)

CONST
    ioBufferSize      = (8 * 512) + FIO.BufferOverhead;
    firstioBufferByte = 1;
    lastioBufferByte  = ioBufferSize;
TYPE
    ioBufferType  = ARRAY [firstioBufferByte..lastioBufferByte] OF BYTE;
VAR
    ioBufferIn : ioBufferType;

(* ------------------------------------------------------------ *)

CONST
    idUNKNOWN = 0;
    idJPG     = 1;
    idGIF     = 2;
    idPNG     = 3;
    idPCX     = 4;
    idBMP     = 5;
    idDDS     = 6;
    idTGA     = 7;

TYPE
    JPGheaderType = RECORD
        SOI:  CARDINAL;             (* 2 $ff $d8 *)
        APP0: CARDINAL;             (* 2 $ff $e0 *)
        mlen: CARDINAL;             (* 2 motorola, including mlen itself, >= $10 *)
        id:   ARRAY [0..3] OF CHAR; (* 4 "JFIF" =  $4a $46 $49 $46 *)
    END;

TYPE
    GIFheaderType = RECORD
        sig:      ARRAY[0..5] OF CHAR;   (* 6 *)
        wi:       CARDINAL;              (* 2 *)
        he:       CARDINAL;              (* 2 *)
    END;

TYPE
    PNGheaderType = RECORD
        sig1:     ARRAY[0..6] OF CHAR;   (* 7 *)
        filler:   ARRAY[0..4] OF BYTE;   (* 5 *)
        sig2:     ARRAY[0..3] OF CHAR;   (* 4 *)
        wi:       LONGCARD;              (* 4 motorola *)
        he:       LONGCARD;              (* 4 motorola *)
    END;

TYPE
    PCXrgbType = RECORD
        red,green,blue:BYTE;
    END;
    (* (almost) useless fields are indented again *)

    PCXheaderType = RECORD
     manufacturer    : BYTE; (* constant 10=$0A=ZSoft *)
     version         : BYTE; (* constant 5=PC Paintbrush v3.0+ *)
     encoding        : BYTE; (* constant 1=RLE *)
    bitsPerPixel     : BYTE; (* 1, 2, 4 or 8, i.e. mono, 4, 16 OR 256 colors  *)
	                  (* window, i.e. image dimensions : xmin, ymin, xmax, ymax *)
    leftmargin       : WORD;
    uppermargin      : WORD;
    rightmargin      : WORD; (* do not use xmax-xmin ! *)
    lowermargin      : WORD;
     hDPIresolution  : WORD; (* put 300 for instance *)
     vDPIresolution  : WORD; (* idem *)
    colormap         : ARRAY[0..15] OF PCXrgbType;
     reserved1       : BYTE; (* must be 0 *)
    NCP              : BYTE; (* number of color planes, 1 or 4 *)
    NBS              : WORD; (* number of bytes per scanline, always even *)
                            (* from here, fields may contain rubbish *)
     paletteInfo     : WORD; (* 1=color or BW, 2=grayscale *)
     hscreensize     : WORD;
     vscreensize     : WORD;
     reserved2       : ARRAY[0..53] OF BYTE; (* must be 0 *)
    END;

TYPE
    BMPFileHeader = RECORD
        bfType 	     : ARRAY[0..1] OF CHAR; (* "BM" string *)
        bfSize 	     : LONGCARD;            (* file size in bytes *)
        bfReserved1  : CARDINAL;            (* must be set to 0 *)
        bfReserved2  : CARDINAL;            (* idem *)
        bfOffBits    : LONGCARD;            (* offset from this structure to the actual bitmap data in file *)
    END;
    BMPInfoHeader = RECORD
        biSize 	      : LONGCARD; (* size of this structure *)
        biWidth       : LONGINT;  (* # of pixels *)
        biHeight      : LONGINT;  (* # of pixels *)
        biPlanes      : CARDINAL; (* must be 1   *)
        biBitCount    : CARDINAL; (* bits per pixel (1=mono, 4=16 colors) *)
        biCompression : LONGCARD; (* 0=not compressed, 1=RLE8, 2=RLE4 *)
        (* from here, 0=default *)
        biSizeImage 	: LONGCARD; (* # of bytes in image (can be 0 if no compression) *)
        biXpelsPerMeter : LONGINT;  (* could be 0 *)
        biYpelsPerMeter : LONGINT;
        biClrUsed 	: LONGCARD; (* set to 0 to force use of all pallette *)
        biClrImportant 	: LONGCARD; (* 0=all colors are important *)
    END;
    BMPtotalHeaderType = RECORD (* assume following subheaders *)
       FILE:BMPFileHeader;
       INFO:BMPInfoHeader;
    END;

    TGAheaderType = RECORD
        info        : BYTE;
        colortyp    : BYTE;         (* 0,1 *)
        imagetyp    : BYTE;         (* 1,2,9,10 *)
        origin      : CARDINAL;
        colnumber   : CARDINAL;
        entrybits   : BYTE;         (* 16,24,32 *)
        xvalue      : CARDINAL;  (* lower left *)
        yvalue      : CARDINAL;  (* lower left *)
        width       : CARDINAL;
        height      : CARDINAL;
        pixelsize   : BYTE;         (* 8,16 or 16,24,32 *)
        descriptor  : BYTE;
    END;

    TYPE DDSheaderType = RECORD
        sig      : ARRAY[0..3] OF CHAR; (* "DDS " i.e. $44445320 *)
        (* now just enough of DDSURFACEDESC2 fields as to retrieve picdims *)
        dwSize   : LONGCARD; (* size of structure : always $7c (124) *)
        dwFlags  : LONGCARD;
        dwHeight : LONGCARD;
        dwWidth  : LONGCARD;
        (* we don't care of the rest *)
    END;

(* ------------------------------------------------------------ *)

CONST
    databufferlen = SIZE(PCXheaderType); (* longest header for now *)
VAR
    databuffer : ARRAY[0..databufferlen-1] OF BYTE;

PROCEDURE chkJPG (VAR x,y:LONGCARD; hin:FIO.File):BOOLEAN;
VAR
    h:JPGheaderType;
    ok:BOOLEAN;
    skiplen:CARDINAL;
    p:LONGCARD;
    b:BYTE;
    n:CARDINAL;
BEGIN
    Lib.WordMove( ADR(databuffer), ADR(h), SIZE(h) DIV 2);
    ok:=FALSE;
    IF ( (h.SOI = 0D8FFH) AND (h.APP0 = 0E0FFH) ) THEN
        IF same(h.id,"JFIF") THEN
            skiplen := wflip( h.mlen );
            ok:=( skiplen >= 010H);
            IF ok THEN
                p := SIZE(h.SOI) + SIZE(h.APP0)+LONGCARD(skiplen) ;
                LOOP
                    FIO.Seek(hin,p);
                    b:=readByte(hin,0);
                    IF b # BYTE(0FFH) THEN RETURN FALSE;END; (* not a jpeg marker *)
                    b:=readByte(hin,0);
                    CASE CARDINAL(b) OF
                    | 0D9H: (* EOI END of image *)
                        RETURN FALSE;
                    | 0C0H,0C1H: (* SOF0, SOF1 :  start of frame *)
                        n:=readWord(hin,0);
                        b:=readByte(hin,0);
                        n:=readWord(hin,0);
                        y:=LONGCARD(wflip(n));
                        n:=readWord(hin,0);
                        x:=LONGCARD(wflip(n));
                        RETURN TRUE;
                    ELSE
                        p:=FIO.GetPos(hin);
                        n:=readWord(hin,0);
                        skiplen := wflip(n);
                        INC (p, LONGCARD(skiplen) );
                    END;
                END;
            END;
        END;
    END;
    RETURN ok;
END chkJPG;

PROCEDURE chkGIF (VAR x,y:LONGCARD):BOOLEAN; (* ok *)
VAR
    h:GIFheaderType;
    ok:BOOLEAN;
BEGIN
    Lib.WordMove( ADR(databuffer), ADR(h), SIZE(h) DIV 2);
    ok:=FALSE;
    IF (same(h.sig,"GIF87a") OR same(h.sig,"GIF89a") ) THEN
        x:=LONGCARD (h.wi);
        y:=LONGCARD (h.he);
        ok:=TRUE;
    END;
    RETURN ok;
END chkGIF;

PROCEDURE chkPNG (VAR x,y:LONGCARD):BOOLEAN; (* ok *)
VAR
    h:PNGheaderType;
    ok:BOOLEAN;
BEGIN
    Lib.WordMove( ADR(databuffer), ADR(h), SIZE(h) DIV 2);
    ok:=FALSE;
    IF same(h.sig1,CHR(89H)+"PNG"+nl+ctrlZ) THEN
        IF same(h.sig2,"IHDR") THEN
            x:=dwflip(h.wi);
            y:=dwflip(h.he);
            ok:=TRUE;
        END;
    END;
    RETURN ok;
END chkPNG;

PROCEDURE chkPCX (VAR x,y:LONGCARD ):BOOLEAN;
CONST
    kTen = BYTE(0AH);
    kOne = BYTE(1);
    kZero= BYTE(0);
VAR
    h:PCXheaderType;
    ok:BOOLEAN;
BEGIN
    Lib.WordMove( ADR(databuffer), ADR(h), SIZE(h) DIV 2);
    ok:=FALSE;
    IF h.manufacturer = kTen THEN
        IF h.encoding = kOne THEN
            IF h.reserved1 = kZero THEN
                x:= LONGCARD(h.rightmargin-h.leftmargin)+1;
                y:= LONGCARD(h.lowermargin-h.uppermargin)+1;
                ok:=TRUE;
            END;
        END;
    END;
    RETURN ok;
END chkPCX;

PROCEDURE chkBMP (VAR x,y:LONGCARD ):BOOLEAN;
VAR
    h:BMPtotalHeaderType;
    ok:BOOLEAN;
BEGIN
    Lib.WordMove( ADR(databuffer), ADR(h), SIZE(h) DIV 2);
    ok:=FALSE;
    IF same(h.FILE.bfType,"BM") THEN
        IF h.FILE.bfReserved1 = 0 THEN
            IF h.FILE.bfReserved2 = 0 THEN
                x:=LONGCARD( h.INFO.biWidth );
                y:=LONGCARD( h.INFO.biHeight );
                ok:=TRUE;
            END;
        END;
    END;
    RETURN ok;
END chkBMP;

(* mere probability without guarantee *)

PROCEDURE chkTGA (VAR x,y:LONGCARD ):BOOLEAN;
VAR
    h:TGAheaderType;
    ok:BOOLEAN;
    n:CARDINAL;
BEGIN
    Lib.WordMove( ADR(databuffer), ADR(h), SIZE(h) DIV 2);
    n:=0;
    CASE CARDINAL( h.colortyp  ) OF
    | 0,1 : INC(n);
    END;
    CASE CARDINAL( h.imagetyp  ) OF
    | 1,2,9,10: INC(n);
    END;
    CASE CARDINAL( h.entrybits ) OF
    | 0,16,24,32 : INC(n);
    END;
    CASE CARDINAL( h.pixelsize ) OF (* checking 8,16,24,32 set would not work ! *)
    | 8, 16, 24, 32 : INC(n);
    END;
    ok:= (n = 4);
    IF ok THEN
        x:= LONGCARD(h.width);
        y:= LONGCARD(h.height);
    END;
    RETURN ok;
END chkTGA;

PROCEDURE chkDDS (VAR x,y:LONGCARD ):BOOLEAN;
CONST
    kStructSize = 124; (* $7c *)
VAR
    h:DDSheaderType;
    ok:BOOLEAN;
BEGIN
    Lib.WordMove( ADR(databuffer), ADR(h), SIZE(h) DIV 2);
    ok:=FALSE;
    IF (same(h.sig,"DDS ")) THEN
        IF h.dwSize = kStructSize THEN
            x:=h.dwHeight;
            y:=h.dwWidth;
            ok:=TRUE;
        END;
    END;
    RETURN ok;
END chkDDS;

(* ------------------------------------------------------------ *)

PROCEDURE fmtXY (VAR R:ARRAY OF CHAR;padchar:CHAR;padwi,id:CARDINAL;x,y:LONGCARD);
CONST
    wi=2+4+3+4; (* "  #### x ####" *)
VAR
    S : str80;
    Z : str16;
    i:CARDINAL;
BEGIN
    CASE id OF
    | idJPG: Z:="jpg";
    | idGIF: Z:="gif";
    | idPNG: Z:="png";
    | idPCX: Z:="pcx";
    | idBMP: Z:="bmp";
    | idDDS: Z:="dds";
    | idTGA: Z:="tga";
    ELSE     Z:="..."; (* was "???" *)
    END;
    IF id = idUNKNOWN THEN
        Str.Prepend(Z,"--- ");
        S:="";
    ELSE
        Str.Prepend(Z,"+++ ");
        S:="~ x ~";
        Str.Subst(S,"~",fmtbignum(x,10,padwi,padchar));
        Str.Subst(S,"~",fmtbignum(y,10,padwi,padchar));
    END;

    FOR i:=Str.Length(S)+1 TO wi DO
        Str.Prepend(S,blank);
    END;
    Str.Prepend(S,Z);
    Str.Append(S,blank+blank);
    Str.Copy(R,S);
END fmtXY;

PROCEDURE showit (useLFN,shownotpix,inverse,DEBUG:BOOLEAN;
                 padchar:CHAR;padwi,minW,minH:CARDINAL;S:pathtype );
CONST
    wanted = databufferlen;
VAR
    hin:FIO.File;
    got:CARDINAL;
    x,y:LONGCARD;
    id:CARDINAL;
    R:str80;
    dim,showme:BOOLEAN;
    minX,minY:LONGCARD;
BEGIN
    minX:=LONGCARD(minW);
    minY:=LONGCARD(minH);

    showme := TRUE;

    hin:=fileOpenRead(useLFN,S);
    Lib.WordFill( ADR(databuffer), databufferlen DIV 2, 00H); (* reset state *)
    got:=FIO.RdBin(hin,databuffer,wanted);

    IF chkJPG(x,y,hin) THEN (* should not be hard coded *)
        id:=idJPG;
    ELSIF chkGIF(x,y) THEN
        id:=idGIF;
    ELSIF chkPNG(x,y) THEN
        id:=idPNG;
    ELSIF chkPCX(x,y) THEN
        id:=idPCX;
    ELSIF chkBMP(x,y) THEN
        id:=idBMP;
    ELSIF chkDDS(x,y) THEN
        id:=idDDS;
    ELSIF chkTGA(x,y) THEN
        id:=idTGA;
    ELSE
        id:=idUNKNOWN;
        x:=MAX(LONGCARD); (* force display *)
        y:=MAX(LONGCARD);
        showme:=shownotpix;
    END;
    fileClose(useLFN,hin);

    IF (x > minX) OR (y > minY) THEN
        dim:=TRUE;
    ELSE
        dim:=FALSE;
    END;
    IF inverse THEN dim:=NOT(dim);END;

    IF (showme AND dim) THEN
        fmtXY(R,padchar,padwi,id,x,y);
        WrStr(R);
        IF useLFN THEN WrStr(doublequote); END;
        WrStr(S);
        IF useLFN THEN WrStr(doublequote); END;
        WrLn;
    END;
END showit;

PROCEDURE showXY (useLFN,showall,inverse,DEBUG:BOOLEAN;
                 padchar:CHAR;padwi,lastfile,minW,minH:CARDINAL;anchor:ptrToEntry):BOOLEAN;
VAR
    S:pathtype;
    flagAbort:BOOLEAN;
    i:CARDINAL;
BEGIN
    flagAbort:=FALSE;
    i:=firstEntry-1;
    LOOP
        INC(i);
        IF i > lastfile THEN EXIT; END;
        getMatchEntry(S, i,anchor);
        showit (useLFN,showall,inverse,DEBUG,padchar,padwi,minW,minH,S);
        flagAbort:=ChkEscape();
        IF flagAbort THEN EXIT; END;
    END;
    RETURN flagAbort;
END showXY;

(* ------------------------------------------------------------ *)
(* ------------------------------------------------------------ *)

CONST
    firstparm = 1;
    maxparm   = 1;
VAR
    parmcount,i,opt,lastparm:CARDINAL;
    S,R,spec:pathtype;
    shownotpix,inverse,useLFN:BOOLEAN;
    DEBUG:BOOLEAN;
    parm:ARRAY [firstparm..maxparm] OF pathtype;
    anchor:ptrToEntry;
    alcatraz:BOOLEAN;
    lastfile:CARDINAL;
    fmtxy:(raw,useblank,usezero);
    padwi:CARDINAL;
    padchar:CHAR;
    redef,minW , minH : CARDINAL;
    XY:str16;
BEGIN
    Lib.DisableBreakCheck();
    FIO.IOcheck := FALSE; (* don't let topspeed handle problems *)
    WrLn;

    parmcount := Lib.ParamCount();
    IF parmcount = 0 THEN abort(errHelp,"");END;

    lastparm    := firstparm-1;
    shownotpix  := FALSE;
    fmtxy       := raw;
    useLFN      := TRUE;
    minW        := 0;
    minH        := 0;
    inverse     :=FALSE;
    redef       := 0;

    FOR i := 1 TO parmcount DO
        Lib.ParamStr(S,i); cleantabs(S);
        Str.Copy(R,S);
        UpperCase(R);
        IF isOption(R) THEN
            opt := GetOptIndex(R, "?"+delim+"H"+delim+"HELP"+delim+
                                  "X"+delim+"LFN"+delim+
                                  "L"+delim+"LIST"+delim+"ALL"+delim+
                                  "F"+delim+"BLANK"+delim+
                                  "FF"+delim+"ZERO"+delim+
                                  "I"+delim+"INVERSE"+delim+
                                  "2"+delim+"320X200"+delim+"320*200"+delim+
                                  "4"+delim+"640X480"+delim+"640*480"+delim+
                                  "6"+delim+"800X600"+delim+"800*600"+delim+
                                  "7"+delim+"1024X768"+delim+"1024*768"+delim+
                                  "9"+delim+"1280X960"+delim+"1280*960"+delim+
                                  "1"+delim+"1600X1200"+delim+"1600*1200"+delim+
                                  "DEBUG"
                              );
            CASE opt OF
            | 1,2,3 : abort(errHelp,"");
            | 4,5:    useLFN    := FALSE;
            | 6,7,8:  shownotpix := TRUE;
            | 9,10:   CASE fmtxy OF
                      | raw,useblank: fmtxy:=useblank;
                      ELSE            abort(errFmt,"");
                      END;
            |11,12:   CASE fmtxy OF
                      | raw,usezero:  fmtxy:=usezero;
                      ELSE            abort(errFmt,"");
                      END;
            |13,14  : inverse:=TRUE;
            |15,16,17 : minW:=320;  minH:=200;  INC(redef);
            |18,19,20 : minW:=640;  minH:=480;  INC(redef);
            |21,22,23 : minW:=800;  minH:=600;  INC(redef);
            |24,25,26 : minW:=1024; minH:=768;  INC(redef);
            |27,28,29 : minW:=1280; minH:=960;  INC(redef);
            |30,31,32 : minW:=1600; minH:=1200; INC(redef);
            |33:      DEBUG     := TRUE;
            ELSE
                abort(errUnknownOption,S);
            END;
        ELSE
            INC(lastparm);
            IF lastparm > maxparm THEN abort(errTooManyParms,S);END;
            Str.Copy(parm[lastparm],S); (* keep case *)
        END;
    END;
    IF lastparm < firstparm THEN abort(errMissingSpec,"");END;
    XY:="";
    CASE redef OF
    | 0 : IF inverse THEN abort(errInverse,"");END;
    | 1 : CASE minW OF
          | 320:  XY:="320x200";
          | 640:  XY:="640x480";
          | 800:  XY:="800x600";
          | 1024: XY:="1024x768";
          | 1280: XY:="1280x1024";
          | 1600: XY:="1600x1200";
          END;
    ELSE
        abort(errScreen,"");
    END;

    useLFN:=( useLFN AND w9XsupportLFN() );
    IF useLFN=FALSE THEN
        FOR i:=firstparm TO lastparm DO
            UpperCase( parm[i] );
        END;
    END;
    Str.Copy(spec,parm[firstparm]);

    IF same(spec,dot) THEN
        Str.Copy(spec,stardotstar);
    ELSE
        IF fileIsDirectorySpec(useLFN,spec) THEN
            fixDirectory(spec);
            Str.Append(spec,stardotstar);
        END;
    END;
    IF chkJokerPath (spec) THEN abort(errJokerPath,spec);END;

    lastfile:=buildMatchList (anchor, useLFN,spec);
    CASE lastfile OF
    | firstEntry-1: freeMatchList(anchor); abort(errNoMatch,S);
    | TOOMANY:      freeMatchList(anchor); abort(errTooMany,S);
    END;
    CASE fmtxy OF
    | raw      : padwi:=1; padchar:="";
    | useblank : padwi:=4; padchar:=" ";
    | usezero  : padwi:=4; padchar:="0";
    END;

    S:="::: List only recognized files : ~";
    IF shownotpix THEN
        R:="no";
    ELSE
        R:="yes";
    END;
    Str.Subst(S,"~",R);
    WrStr(S);WrLn;

    S:="::: Dimensions filter          : ~";
    IF same(XY,"") THEN
        R:="no";
    ELSE
        IF inverse THEN
            Str.Concat(R,"dimensions smaller or equal to ",XY);
        ELSE
            Str.Concat(R,"one dimension greater than ",XY);
        END;
    END;
    Str.Subst(S,"~",R);
    WrStr(S);WrLn;
    WrLn;

    alcatraz:=showXY (useLFN,shownotpix,inverse,DEBUG,
                     padchar,padwi,lastfile,minW,minH,anchor);
    freeMatchList(anchor);

    IF alcatraz THEN abort(errAborted,"");END;

    abort(errNone,"");
END picDimS.


